/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.SQLEditorThemeSettings;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;

public class SQLTokenAdapter
extends Token {
    private final TPToken token;

    public SQLTokenAdapter(TPToken token, SQLRuleScanner scanner) {
        super((Object)SQLTokenAdapter.makeTextAttribute(token, scanner));
        this.token = token;
    }

    public TPToken getToken() {
        return this.token;
    }

    public String toString() {
        return "Adapter of [" + this.token.toString() + "]";
    }

    private static TextAttribute makeTextAttribute(TPToken token, SQLRuleScanner scanner) {
        int style;
        Color color;
        Object object;
        if (token instanceof TPTokenDefault && (object = token.getData()) instanceof SQLTokenType) {
            SQLTokenType tokenType = (SQLTokenType)object;
            SQLEditorThemeSettings themeSettings = SQLEditorThemeSettings.instance;
            switch (tokenType) {
                case T_KEYWORD: 
                case T_BLOCK_BEGIN: 
                case T_BLOCK_END: 
                case T_BLOCK_HEADER: {
                    color = themeSettings.editorKeywordColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_STRING: {
                    color = themeSettings.editorStringColor;
                    style = 0;
                    break;
                }
                case T_QUOTED: 
                case T_TYPE: {
                    color = themeSettings.editorDatatypeColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_FUNCTION: {
                    color = themeSettings.editorFunctionColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_NUMBER: {
                    color = themeSettings.editorNumberColor;
                    style = 0;
                    break;
                }
                case T_COMMENT: {
                    color = themeSettings.editorCommentColor;
                    style = 0;
                    break;
                }
                case T_DELIMITER: {
                    color = themeSettings.editorDelimiterColor;
                    style = 0;
                    break;
                }
                case T_BLOCK_TOGGLE: {
                    color = themeSettings.editorDelimiterColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_CONTROL: 
                case T_SET_DELIMITER: {
                    color = themeSettings.editorCommandColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_PARAMETER: 
                case T_VARIABLE: {
                    color = themeSettings.editorParameterColor;
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_TABLE: {
                    color = themeSettings.editorTableColor;
                    style = 0;
                    break;
                }
                case T_TABLE_ALIAS: {
                    color = themeSettings.editorTableAliasColor;
                    style = 2;
                    break;
                }
                case T_COLUMN: {
                    color = themeSettings.editorColumnColor;
                    style = 0;
                    break;
                }
                case T_COLUMN_DERIVED: {
                    color = themeSettings.editorColumnDerivedColor;
                    style = 2;
                    break;
                }
                case T_SCHEMA: {
                    color = themeSettings.editorSchemaColor;
                    style = 0;
                    break;
                }
                case T_COMPOSITE_FIELD: {
                    color = themeSettings.editorCompositeFieldColor;
                    style = 0;
                    break;
                }
                case T_SQL_VARIABLE: {
                    color = themeSettings.editorSqlVariableColor;
                    style = 0;
                    break;
                }
                case T_SEMANTIC_ERROR: {
                    color = themeSettings.editorSemanticErrorColor;
                    style = 0;
                    break;
                }
                default: {
                    color = themeSettings.editorTextColor;
                    style = 0;
                    break;
                }
            }
        } else {
            color = SQLEditorThemeSettings.instance.editorTextColor;
            style = 0;
        }
        if (UIStyles.isDarkHighContrastTheme()) {
            color = color == SQLEditorThemeSettings.instance.editorTextColor ? UIStyles.COLOR_WHITE : UIStyles.getInvertedColor((Color)color);
        }
        return new TextAttribute(color, null, style);
    }
}

