# Introduction

Earthly is a build automation tool that uses docker containers to enforce build repeatability. Earthly is meant to be run on your local system and in your CI. Earthly's implicit caching and parallelism will make your builds repeatable and fast.

This tutorial will walk you through a basic example of using Earthly.

## Earthly is better logged in

A better, interactive version of this tutorial is available in Earthly Cloud. Get started with Earthly Cloud for free by visiting the [sign up](https://cloud.earthly.dev/login) page.

## Table of Contents

* **Introduction** <-- You are here.
* [Part 1: A simple Earthfile](./part-1-a-simple-earthfile.md)
* [Part 2: Outputs](./part-2-outputs.md)
* [Part 3: Adding dependencies With Caching](./part-3-adding-dependencies-with-caching.md)
* [Part 4: Args](./part-4-args.md)
* [Part 5: Importing](./part-5-importing.md)
* [Part 6: Using Docker In Earthly](./part-6-using-docker-with-earthly.md)
* [Part 7: Using remote runners](./part-7-using-remote-runners.md)
* [Part 8: Using Earthly in CI](./part-8a-using-earthly-in-your-current-ci.md)
* [Final words](./final-words.md)

## Installation

We recommend you install Earthly on your computer, so you can follow along and try the examples. See the [installation instructions](https://earthly.dev/get-earthly).

## Questions & Feedback

If you have any questions, feedback or suggestions for Earthly or this tutorial feel free to reach out to us on our [Slack community](https://earthly.dev/slack) or open a [GitHub issue](https://github.com/earthly/earthly/issues). Earthly is free and open and we love and appreciate feedback and contributions from the community!

## Get Started with Earthly

We will start the first lesson with a simple Earthfile.

👉 [Part 1: A simple Earthfile](./part-1-a-simple-earthfile.md)
