package command

type Type int

const (
	AddCmd            Type = iota + 1 // "ADD"
	ArgCmd                            // "ARG"
	BuildCmd                          // "BUILD"
	CacheCmd                          // "CACHE"
	CmdCmd                            // "CMD"
	CommandCmd                        // "COMMAND"
	CopyCmd                           // "COPY"
	DoCmd                             // "DO"
	DockerCmd                         // "DOCKER"
	EnterScopeDoCmd                   // "ENTER-SCOPE-DO"
	EntrypointCmd                     // "ENTRYPOINT"
	EnvCmd                            // "ENV"
	ExposeCmd                         // "EXPOSE"
	FromCmd                           // "FROM"
	FromDockerfileCmd                 // "FROM DOCKERFILE"
	GitCloneCmd                       // "GIT CLONE"
	HealthcheckCmd                    // "HEALTHCHECK"
	HostCmd                           // "HOST"
	ImportCmd                         // "IMPORT"
	LabelCmd                          // "LABEL"
	LetCmd                            // "LET"
	LoadCmd                           // "LOAD"
	LocallyCmd                        // "LOCALLY"
	OnBuildCmd                        // "ON BUILD"
	ProjectCmd                        // "PROJECT"
	RunCmd                            // "RUN"
	SaveArtifactCmd                   // "SAVE ARTIFACT"
	SaveImageCmd                      // "SAVE IMAGE"
	SetCmd                            // "SET"
	ShellCmd                          // "SHELL"
	StopSignalCmd                     // "STOP SIGNAL"
	UserCmd                           // "USER"
	VolumeCmd                         // "VOLUME"
	WorkdirCmd                        // "WORKDIR"
	FunctionCmd                       // "FUNCTION"
)
