#include <common.h>

#include <pspsdk.h>
#include <pspkernel.h>
#include <pspthreadman.h>
#include <psploadexec.h>
#include <pspumd.h>
#include <pspiofilemgr.h>

char data1[472] = {0};
char data2[472] = {0};
char data3[472] = {0};

unsigned char dataRef[472] =
{
	0x00, 0x50, 0x53, 0x46, 0x01, 0x01, 0x00, 0x00, 0xB4, 0x00, 0x00, 0x00,
	0x20, 0x01, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04,
	0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x00, 0x04, 0x02, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x04, 0x02, 0x0A, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x04, 0x04,
	0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x26, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x1C, 0x00, 0x00, 0x00, 0x31, 0x00, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x04, 0x04,
	0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00,
	0x4D, 0x00, 0x04, 0x02, 0x05, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x2C, 0x00, 0x00, 0x00, 0x5C, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x63, 0x00, 0x04, 0x02,
	0x0C, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
	0x42, 0x4F, 0x4F, 0x54, 0x41, 0x42, 0x4C, 0x45, 0x00, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4F, 0x52, 0x59, 0x00, 0x44, 0x49, 0x53, 0x43, 0x5F, 0x49,
	0x44, 0x00, 0x44, 0x49, 0x53, 0x43, 0x5F, 0x4E, 0x55, 0x4D, 0x42, 0x45,
	0x52, 0x00, 0x44, 0x49, 0x53, 0x43, 0x5F, 0x54, 0x4F, 0x54, 0x41, 0x4C,
	0x00, 0x44, 0x49, 0x53, 0x43, 0x5F, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4F,
	0x4E, 0x00, 0x50, 0x41, 0x52, 0x45, 0x4E, 0x54, 0x41, 0x4C, 0x5F, 0x4C,
	0x45, 0x56, 0x45, 0x4C, 0x00, 0x50, 0x53, 0x50, 0x5F, 0x53, 0x59, 0x53,
	0x54, 0x45, 0x4D, 0x5F, 0x56, 0x45, 0x52, 0x00, 0x52, 0x45, 0x47, 0x49,
	0x4F, 0x4E, 0x00, 0x54, 0x49, 0x54, 0x4C, 0x45, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x55, 0x47, 0x00, 0x00, 0x55, 0x43, 0x4A, 0x53,
	0x31, 0x30, 0x30, 0x34, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x31, 0x2E, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x31, 0x2E, 0x35, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x43, 0x75, 0x62, 0x65,
	0x20, 0x73, 0x61, 0x6D, 0x70, 0x6C, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};


#define FILE_NAME "disc0:/PSP_GAME/PARAM.SFO"
#define UMD0_FILE_NAME "umd0:/PSP_GAME/PARAM.SFO"

int main(int argc, char **argv)
{
	char temp[1024];
	SceIoStat sceIoStat;
	int fileHandle;

	printf("sceIoGetstat: %d\n", sceIoGetstat(FILE_NAME, &sceIoStat));
	printf("Size: %lld\n", sceIoStat.st_size);
	printf("LBN: %d\n", sceIoStat.st_private[0]);
	// TEST normal file access.
	{
		fileHandle = sceIoOpen(FILE_NAME, PSP_O_RDONLY, 0777);
		printf("HandleNormal: %s\n", (fileHandle > 0) ? "Ok" : "Error");
		sceIoRead(fileHandle, data1, sizeof(data1));
		sceIoClose(fileHandle);
		printf("memcmp_Normal: %d\n", memcmp(data1, dataRef, sizeof(dataRef)));
	}
	// TEST sce_lbn access
	{
		sprintf(temp, "disc0:/sce_lbn0x%08X_size0x%08X", (int)sceIoStat.st_private[0], (int)sceIoStat.st_size);
		fileHandle = sceIoOpen(temp, PSP_O_RDONLY, 0777);
		printf("HandleRaw: %s\n", (fileHandle > 0) ? "Ok" : "Error");
		sceIoRead(fileHandle, data2, sizeof(data2));
		sceIoClose(fileHandle);
		printf("memcmp_Raw: %d\n", memcmp(data2, dataRef, sizeof(dataRef)));
	}
	// TEST umd0:/ access
	{
		fileHandle = sceIoOpen(UMD0_FILE_NAME, PSP_O_RDONLY, 0777);
		printf("HandleUmd0: %s\n", (fileHandle > 0) ? "Ok" : "Error");
		sceIoLseek(fileHandle, (long long int)sceIoStat.st_private[0] * 0x800, SEEK_SET);
		sceIoRead(fileHandle, data3, sizeof(data3));
		sceIoClose(fileHandle);
		printf("memcmp_Umd0: %d\n", memcmp(data3, dataRef, sizeof(dataRef)));
	}

	return 0;
}