/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.ActiveItem;
import org.openhab.core.items.ItemStateConverter;
import org.openhab.core.items.StateChangeListener;
import org.openhab.core.items.TimeSeriesListener;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.service.CommandDescriptionService;
import org.openhab.core.service.StateDescriptionService;
import org.openhab.core.types.Command;
import org.openhab.core.types.CommandDescription;
import org.openhab.core.types.CommandDescriptionBuilder;
import org.openhab.core.types.CommandOption;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class GenericItem
implements ActiveItem {
    private final Logger logger = LoggerFactory.getLogger(GenericItem.class);
    private static final String ITEM_THREADPOOLNAME = "items";
    protected @Nullable EventPublisher eventPublisher;
    protected Set<StateChangeListener> listeners = new CopyOnWriteArraySet(Collections.newSetFromMap(new WeakHashMap()));
    protected Set<TimeSeriesListener> timeSeriesListeners = new CopyOnWriteArraySet(Collections.newSetFromMap(new WeakHashMap()));
    protected List<String> groupNames = new ArrayList<String>();
    protected Set<String> tags = new HashSet<String>();
    protected final String name;
    protected final String type;
    protected State state = UnDefType.NULL;
    protected @Nullable State lastState;
    protected @Nullable ZonedDateTime lastStateUpdate;
    protected @Nullable ZonedDateTime lastStateChange;
    protected @Nullable String label;
    protected @Nullable String category;
    private @Nullable StateDescriptionService stateDescriptionService;
    private @Nullable CommandDescriptionService commandDescriptionService;
    protected @Nullable ItemStateConverter itemStateConverter;

    public GenericItem(String type, String name) {
        this.name = name;
        this.type = type;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public <T extends State> @Nullable T getStateAs(Class<T> typeClass) {
        return this.state.as(typeClass);
    }

    @Override
    public @Nullable State getLastState() {
        return this.lastState;
    }

    @Override
    public @Nullable ZonedDateTime getLastStateUpdate() {
        return this.lastStateUpdate;
    }

    @Override
    public @Nullable ZonedDateTime getLastStateChange() {
        return this.lastStateChange;
    }

    @Override
    public String getUID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getGroupNames() {
        return List.copyOf(this.groupNames);
    }

    @Override
    public void addGroupName(String groupItemName) {
        if (!this.groupNames.contains(groupItemName)) {
            this.groupNames.add(groupItemName);
        }
    }

    @Override
    public void addGroupNames(String ... groupItemNames) {
        String[] stringArray = groupItemNames;
        int n = groupItemNames.length;
        int n2 = 0;
        while (n2 < n) {
            String groupItemName = stringArray[n2];
            this.addGroupName(groupItemName);
            ++n2;
        }
    }

    @Override
    public void addGroupNames(List<String> groupItemNames) {
        for (String groupItemName : groupItemNames) {
            this.addGroupName(groupItemName);
        }
    }

    @Override
    public void removeGroupName(String groupItemName) {
        this.groupNames.remove(groupItemName);
    }

    public void dispose() {
        this.listeners.clear();
        this.eventPublisher = null;
        this.stateDescriptionService = null;
        this.commandDescriptionService = null;
        this.itemStateConverter = null;
    }

    public void setEventPublisher(@Nullable EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setStateDescriptionService(@Nullable StateDescriptionService stateDescriptionService) {
        this.stateDescriptionService = stateDescriptionService;
    }

    public void setCommandDescriptionService(@Nullable CommandDescriptionService commandDescriptionService) {
        this.commandDescriptionService = commandDescriptionService;
    }

    public void setItemStateConverter(@Nullable ItemStateConverter itemStateConverter) {
        this.itemStateConverter = itemStateConverter;
    }

    protected void internalSend(Command command, @Nullable String source) {
        EventPublisher eventPublisher = this.eventPublisher;
        if (eventPublisher instanceof EventPublisher) {
            EventPublisher publisher = eventPublisher;
            publisher.post(ItemEventFactory.createCommandEvent(this.getName(), command, source));
        }
    }

    public void setState(State state, @Nullable String source) {
        this.applyState(state, source);
    }

    public final void setState(State state) {
        this.setState(state, null);
    }

    public void setState(State state, @Nullable State lastState, @Nullable ZonedDateTime lastStateUpdate, @Nullable ZonedDateTime lastStateChange, @Nullable String source) {
        State oldState = this.state;
        this.state = state;
        this.lastState = lastState != null ? lastState : this.lastState;
        this.lastStateUpdate = lastStateUpdate != null ? lastStateUpdate : this.lastStateUpdate;
        this.lastStateChange = lastStateChange != null ? lastStateChange : this.lastStateChange;
        this.notifyListeners(oldState, state);
        this.sendStateUpdatedEvent(state, lastStateUpdate, source);
        if (!oldState.equals(state)) {
            this.sendStateChangedEvent(state, oldState, lastStateUpdate, lastStateChange, source);
        }
    }

    protected final void applyState(State state, @Nullable String source) {
        ZonedDateTime now = ZonedDateTime.now();
        State oldState = this.state;
        boolean stateChanged = !oldState.equals(state);
        this.state = state;
        if (stateChanged) {
            this.lastState = oldState;
        }
        this.notifyListeners(oldState, state);
        this.sendStateUpdatedEvent(state, this.lastStateUpdate, source);
        if (stateChanged) {
            this.sendStateChangedEvent(state, oldState, this.lastStateUpdate, this.lastStateChange, source);
            this.lastStateChange = now;
        }
        this.lastStateUpdate = now;
    }

    public void setTimeSeries(TimeSeries timeSeries) {
        this.applyTimeSeries(timeSeries);
    }

    protected final void applyTimeSeries(TimeSeries timeSeries) {
        CopyOnWriteArraySet<TimeSeriesListener> clonedListeners = new CopyOnWriteArraySet<TimeSeriesListener>(this.timeSeriesListeners);
        ExecutorService pool = ThreadPoolManager.getPool(ITEM_THREADPOOLNAME);
        clonedListeners.forEach(listener -> pool.execute(() -> {
            try {
                listener.timeSeriesUpdated(this, timeSeries);
            }
            catch (Exception e) {
                this.logger.warn("failed notifying listener '{}' about timeseries update of item {}: {}", new Object[]{listener, this.getName(), e.getMessage(), e});
            }
        }));
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null) {
            eventPublisher1.post(ItemEventFactory.createTimeSeriesUpdatedEvent(this.name, timeSeries, null));
        }
    }

    private void sendStateUpdatedEvent(State newState, @Nullable ZonedDateTime lastStateUpdate, @Nullable String source) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null) {
            eventPublisher1.post(ItemEventFactory.createStateUpdatedEvent(this.name, newState, lastStateUpdate, source));
        }
    }

    private void sendStateChangedEvent(State newState, State oldState, @Nullable ZonedDateTime lastStateUpdate, @Nullable ZonedDateTime lastStateChange, @Nullable String source) {
        EventPublisher eventPublisher1 = this.eventPublisher;
        if (eventPublisher1 != null) {
            eventPublisher1.post(ItemEventFactory.createStateChangedEvent(this.name, newState, oldState, lastStateUpdate, lastStateChange, source));
        }
    }

    public void send(RefreshType command) {
        this.internalSend(command, null);
    }

    public void send(RefreshType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    protected void notifyListeners(State oldState, State newState) {
        CopyOnWriteArraySet<StateChangeListener> clonedListeners = new CopyOnWriteArraySet<StateChangeListener>(this.listeners);
        ExecutorService pool = ThreadPoolManager.getPool(ITEM_THREADPOOLNAME);
        try {
            boolean stateChanged = !newState.equals(oldState);
            clonedListeners.forEach(listener -> pool.execute(() -> {
                try {
                    listener.stateUpdated(this, newState);
                    if (stateChanged) {
                        listener.stateChanged(this, oldState, newState);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed notifying listener '{}' about state update of item {}: {}", new Object[]{listener, this.getName(), e.getMessage(), e});
                }
            }));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("failed comparing oldState '{}' to newState '{}' for item {}: {}", new Object[]{oldState, newState, this.getName(), e.getMessage(), e});
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (");
        sb.append("Type=");
        sb.append(this.getClass().getSimpleName());
        sb.append(", ");
        sb.append("State=");
        sb.append(this.getState());
        sb.append(", ");
        sb.append("Label=");
        sb.append(this.getLabel());
        sb.append(", ");
        sb.append("Category=");
        sb.append(this.getCategory());
        if (!this.getTags().isEmpty()) {
            sb.append(", ");
            sb.append("Tags=[");
            sb.append(String.join((CharSequence)", ", this.getTags()));
            sb.append("]");
        }
        if (!this.getGroupNames().isEmpty()) {
            sb.append(", ");
            sb.append("Groups=[");
            sb.append(String.join((CharSequence)", ", this.getGroupNames()));
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeSeriesListener(TimeSeriesListener listener) {
        Set<TimeSeriesListener> set = this.timeSeriesListeners;
        synchronized (set) {
            this.timeSeriesListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeSeriesListener(TimeSeriesListener listener) {
        Set<TimeSeriesListener> set = this.timeSeriesListeners;
        synchronized (set) {
            this.timeSeriesListeners.remove(listener);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericItem other = (GenericItem)obj;
        return this.name.equals(other.name);
    }

    @Override
    public Set<String> getTags() {
        return Set.copyOf(this.tags);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.stream().anyMatch(t -> t.equalsIgnoreCase(tag));
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    @Override
    public void addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
    }

    @Override
    public void removeTag(String tag) {
        this.tags.remove(this.tags.stream().filter(t -> t.equalsIgnoreCase(tag)).findFirst().orElse(tag));
    }

    @Override
    public void removeAllTags() {
        this.tags.clear();
    }

    @Override
    public @Nullable String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(@Nullable String label) {
        this.label = label;
    }

    @Override
    public @Nullable String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Override
    public @Nullable StateDescription getStateDescription() {
        return this.getStateDescription(null);
    }

    @Override
    public @Nullable StateDescription getStateDescription(@Nullable Locale locale) {
        StateDescriptionService stateDescriptionService = this.stateDescriptionService;
        if (stateDescriptionService instanceof StateDescriptionService) {
            StateDescriptionService service = stateDescriptionService;
            return service.getStateDescription(this.name, locale);
        }
        return null;
    }

    @Override
    public @Nullable CommandDescription getCommandDescription(@Nullable Locale locale) {
        CommandDescription commandOptions = this.getCommandOptions(locale);
        if (commandOptions != null) {
            return commandOptions;
        }
        StateDescription stateDescription = this.getStateDescription(locale);
        if (stateDescription != null && !stateDescription.getOptions().isEmpty()) {
            return this.stateOptions2CommandOptions(stateDescription);
        }
        return null;
    }

    public boolean isAcceptedState(List<Class<? extends State>> acceptedDataTypes, State state) {
        return acceptedDataTypes.stream().anyMatch(clazz -> clazz.isAssignableFrom(state.getClass()));
    }

    protected void logSetTypeError(State state) {
        this.logger.error("Tried to set invalid state {} ({}) on item {} of type {}, ignoring it", new Object[]{state, state.getClass().getSimpleName(), this.getName(), this.getClass().getSimpleName()});
    }

    protected void logSetTypeError(TimeSeries timeSeries) {
        this.logger.error("Tried to set invalid state in time series {} on item {} of type {}, ignoring it", new Object[]{timeSeries, this.getName(), this.getClass().getSimpleName()});
    }

    protected @Nullable CommandDescription getCommandOptions(@Nullable Locale locale) {
        CommandDescriptionService service;
        CommandDescription commandDescription;
        CommandDescriptionService commandDescriptionService = this.commandDescriptionService;
        if (commandDescriptionService instanceof CommandDescriptionService && (commandDescription = (service = commandDescriptionService).getCommandDescription(this.name, locale)) != null) {
            return commandDescription;
        }
        return null;
    }

    private CommandDescription stateOptions2CommandOptions(StateDescription stateDescription) {
        CommandDescriptionBuilder builder = CommandDescriptionBuilder.create();
        stateDescription.getOptions().forEach(so -> {
            CommandDescriptionBuilder commandDescriptionBuilder2 = builder.withCommandOption(new CommandOption(so.getValue(), so.getLabel()));
        });
        return builder.build();
    }
}

