/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/typed/certmanager/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeCertificates implements CertificateInterface
type fakeCertificates struct {
	*gentype.FakeClientWithList[*v1.Certificate, *v1.CertificateList]
	Fake *FakeCertmanagerV1
}

func newFakeCertificates(fake *FakeCertmanagerV1, namespace string) certmanagerv1.CertificateInterface {
	return &fakeCertificates{
		gentype.NewFakeClientWithList[*v1.Certificate, *v1.CertificateList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("certificates"),
			v1.SchemeGroupVersion.WithKind("Certificate"),
			func() *v1.Certificate { return &v1.Certificate{} },
			func() *v1.CertificateList { return &v1.CertificateList{} },
			func(dst, src *v1.CertificateList) { dst.ListMeta = src.ListMeta },
			func(list *v1.CertificateList) []*v1.Certificate { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.CertificateList, items []*v1.Certificate) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
