// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcknowledgeJob = "AcknowledgeJob"

// AcknowledgeJobRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeJob for more information on using the AcknowledgeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcknowledgeJobRequest method.
//	req, resp := client.AcknowledgeJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob
func (c *CodePipeline) AcknowledgeJobRequest(input *AcknowledgeJobInput) (req *request.Request, output *AcknowledgeJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeJobInput{}
	}

	output = &AcknowledgeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcknowledgeJob API operation for AWS CodePipeline.
//
// Returns information about a specified job and whether that job has been received
// by the job worker. Used for custom actions only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation AcknowledgeJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidNonceException
//     The nonce was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob
func (c *CodePipeline) AcknowledgeJob(input *AcknowledgeJobInput) (*AcknowledgeJobOutput, error) {
	req, out := c.AcknowledgeJobRequest(input)
	return out, req.Send()
}

// AcknowledgeJobWithContext is the same as AcknowledgeJob with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) AcknowledgeJobWithContext(ctx aws.Context, input *AcknowledgeJobInput, opts ...request.Option) (*AcknowledgeJobOutput, error) {
	req, out := c.AcknowledgeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcknowledgeThirdPartyJob = "AcknowledgeThirdPartyJob"

// AcknowledgeThirdPartyJobRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeThirdPartyJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeThirdPartyJob for more information on using the AcknowledgeThirdPartyJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcknowledgeThirdPartyJobRequest method.
//	req, resp := client.AcknowledgeThirdPartyJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob
func (c *CodePipeline) AcknowledgeThirdPartyJobRequest(input *AcknowledgeThirdPartyJobInput) (req *request.Request, output *AcknowledgeThirdPartyJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeThirdPartyJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeThirdPartyJobInput{}
	}

	output = &AcknowledgeThirdPartyJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcknowledgeThirdPartyJob API operation for AWS CodePipeline.
//
// Confirms a job worker has received the specified job. Used for partner actions
// only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation AcknowledgeThirdPartyJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidNonceException
//     The nonce was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - InvalidClientTokenException
//     The client token was specified in an invalid format
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob
func (c *CodePipeline) AcknowledgeThirdPartyJob(input *AcknowledgeThirdPartyJobInput) (*AcknowledgeThirdPartyJobOutput, error) {
	req, out := c.AcknowledgeThirdPartyJobRequest(input)
	return out, req.Send()
}

// AcknowledgeThirdPartyJobWithContext is the same as AcknowledgeThirdPartyJob with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeThirdPartyJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) AcknowledgeThirdPartyJobWithContext(ctx aws.Context, input *AcknowledgeThirdPartyJobInput, opts ...request.Option) (*AcknowledgeThirdPartyJobOutput, error) {
	req, out := c.AcknowledgeThirdPartyJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomActionType = "CreateCustomActionType"

// CreateCustomActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomActionType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomActionType for more information on using the CreateCustomActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomActionTypeRequest method.
//	req, resp := client.CreateCustomActionTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType
func (c *CodePipeline) CreateCustomActionTypeRequest(input *CreateCustomActionTypeInput) (req *request.Request, output *CreateCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opCreateCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomActionTypeInput{}
	}

	output = &CreateCustomActionTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomActionType API operation for AWS CodePipeline.
//
// Creates a new custom action that can be used in all pipelines associated
// with the Amazon Web Services account. Only used for custom actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation CreateCustomActionType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - LimitExceededException
//     The number of pipelines associated with the Amazon Web Services account has
//     exceeded the limit allowed for the account.
//
//   - TooManyTagsException
//     The tags limit for a resource has been exceeded.
//
//   - InvalidTagsException
//     The specified resource tags are invalid.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType
func (c *CodePipeline) CreateCustomActionType(input *CreateCustomActionTypeInput) (*CreateCustomActionTypeOutput, error) {
	req, out := c.CreateCustomActionTypeRequest(input)
	return out, req.Send()
}

// CreateCustomActionTypeWithContext is the same as CreateCustomActionType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) CreateCustomActionTypeWithContext(ctx aws.Context, input *CreateCustomActionTypeInput, opts ...request.Option) (*CreateCustomActionTypeOutput, error) {
	req, out := c.CreateCustomActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipeline for more information on using the CreatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePipelineRequest method.
//	req, resp := client.CreatePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline
func (c *CodePipeline) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for AWS CodePipeline.
//
// Creates a pipeline.
//
// In the pipeline structure, you must include either artifactStore or artifactStores
// in your pipeline, but you cannot use both. If you create a cross-region action
// in your pipeline, you must use artifactStores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNameInUseException
//     The specified pipeline name is already in use.
//
//   - InvalidStageDeclarationException
//     The stage declaration was specified in an invalid format.
//
//   - InvalidActionDeclarationException
//     The action declaration was specified in an invalid format.
//
//   - InvalidBlockerDeclarationException
//     Reserved for future use.
//
//   - InvalidStructureException
//     The structure was specified in an invalid format.
//
//   - LimitExceededException
//     The number of pipelines associated with the Amazon Web Services account has
//     exceeded the limit allowed for the account.
//
//   - TooManyTagsException
//     The tags limit for a resource has been exceeded.
//
//   - InvalidTagsException
//     The specified resource tags are invalid.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline
func (c *CodePipeline) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	return out, req.Send()
}

// CreatePipelineWithContext is the same as CreatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) CreatePipelineWithContext(ctx aws.Context, input *CreatePipelineInput, opts ...request.Option) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomActionType = "DeleteCustomActionType"

// DeleteCustomActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomActionType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomActionType for more information on using the DeleteCustomActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomActionTypeRequest method.
//	req, resp := client.DeleteCustomActionTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType
func (c *CodePipeline) DeleteCustomActionTypeRequest(input *DeleteCustomActionTypeInput) (req *request.Request, output *DeleteCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomActionTypeInput{}
	}

	output = &DeleteCustomActionTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomActionType API operation for AWS CodePipeline.
//
// Marks a custom action as deleted. PollForJobs for the custom action fails
// after the action is marked for deletion. Used for custom actions only.
//
// To re-create a custom action after it has been deleted you must use a string
// in the version field that has never been used before. This string can be
// an incremented version number, for example. To restore a deleted custom action,
// use a JSON file that is identical to the deleted action, including the original
// string in the version field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeleteCustomActionType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType
func (c *CodePipeline) DeleteCustomActionType(input *DeleteCustomActionTypeInput) (*DeleteCustomActionTypeOutput, error) {
	req, out := c.DeleteCustomActionTypeRequest(input)
	return out, req.Send()
}

// DeleteCustomActionTypeWithContext is the same as DeleteCustomActionType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeleteCustomActionTypeWithContext(ctx aws.Context, input *DeleteCustomActionTypeInput, opts ...request.Option) (*DeleteCustomActionTypeOutput, error) {
	req, out := c.DeleteCustomActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipeline for more information on using the DeletePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePipelineRequest method.
//	req, resp := client.DeletePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline
func (c *CodePipeline) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePipeline API operation for AWS CodePipeline.
//
// Deletes the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline
func (c *CodePipeline) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	return out, req.Send()
}

// DeletePipelineWithContext is the same as DeletePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeletePipelineWithContext(ctx aws.Context, input *DeletePipelineInput, opts ...request.Option) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebhook = "DeleteWebhook"

// DeleteWebhookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebhook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebhook for more information on using the DeleteWebhook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWebhookRequest method.
//	req, resp := client.DeleteWebhookRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteWebhook
func (c *CodePipeline) DeleteWebhookRequest(input *DeleteWebhookInput) (req *request.Request, output *DeleteWebhookOutput) {
	op := &request.Operation{
		Name:       opDeleteWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebhookInput{}
	}

	output = &DeleteWebhookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWebhook API operation for AWS CodePipeline.
//
// Deletes a previously created webhook by name. Deleting the webhook stops
// CodePipeline from starting a pipeline every time an external event occurs.
// The API returns successfully when trying to delete a webhook that is already
// deleted. If a deleted webhook is re-created by calling PutWebhook with the
// same name, it will have a different URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeleteWebhook for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteWebhook
func (c *CodePipeline) DeleteWebhook(input *DeleteWebhookInput) (*DeleteWebhookOutput, error) {
	req, out := c.DeleteWebhookRequest(input)
	return out, req.Send()
}

// DeleteWebhookWithContext is the same as DeleteWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeleteWebhookWithContext(ctx aws.Context, input *DeleteWebhookInput, opts ...request.Option) (*DeleteWebhookOutput, error) {
	req, out := c.DeleteWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterWebhookWithThirdParty = "DeregisterWebhookWithThirdParty"

// DeregisterWebhookWithThirdPartyRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterWebhookWithThirdParty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterWebhookWithThirdParty for more information on using the DeregisterWebhookWithThirdParty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterWebhookWithThirdPartyRequest method.
//	req, resp := client.DeregisterWebhookWithThirdPartyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeregisterWebhookWithThirdParty
func (c *CodePipeline) DeregisterWebhookWithThirdPartyRequest(input *DeregisterWebhookWithThirdPartyInput) (req *request.Request, output *DeregisterWebhookWithThirdPartyOutput) {
	op := &request.Operation{
		Name:       opDeregisterWebhookWithThirdParty,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterWebhookWithThirdPartyInput{}
	}

	output = &DeregisterWebhookWithThirdPartyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterWebhookWithThirdParty API operation for AWS CodePipeline.
//
// Removes the connection between the webhook that was created by CodePipeline
// and the external tool with events to be detected. Currently supported only
// for webhooks that target an action type of GitHub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeregisterWebhookWithThirdParty for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - WebhookNotFoundException
//     The specified webhook was entered in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeregisterWebhookWithThirdParty
func (c *CodePipeline) DeregisterWebhookWithThirdParty(input *DeregisterWebhookWithThirdPartyInput) (*DeregisterWebhookWithThirdPartyOutput, error) {
	req, out := c.DeregisterWebhookWithThirdPartyRequest(input)
	return out, req.Send()
}

// DeregisterWebhookWithThirdPartyWithContext is the same as DeregisterWebhookWithThirdParty with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterWebhookWithThirdParty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeregisterWebhookWithThirdPartyWithContext(ctx aws.Context, input *DeregisterWebhookWithThirdPartyInput, opts ...request.Option) (*DeregisterWebhookWithThirdPartyOutput, error) {
	req, out := c.DeregisterWebhookWithThirdPartyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableStageTransition = "DisableStageTransition"

// DisableStageTransitionRequest generates a "aws/request.Request" representing the
// client's request for the DisableStageTransition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableStageTransition for more information on using the DisableStageTransition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableStageTransitionRequest method.
//	req, resp := client.DisableStageTransitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition
func (c *CodePipeline) DisableStageTransitionRequest(input *DisableStageTransitionInput) (req *request.Request, output *DisableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opDisableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableStageTransitionInput{}
	}

	output = &DisableStageTransitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableStageTransition API operation for AWS CodePipeline.
//
// Prevents artifacts in a pipeline from transitioning to the next stage in
// the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DisableStageTransition for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition
func (c *CodePipeline) DisableStageTransition(input *DisableStageTransitionInput) (*DisableStageTransitionOutput, error) {
	req, out := c.DisableStageTransitionRequest(input)
	return out, req.Send()
}

// DisableStageTransitionWithContext is the same as DisableStageTransition with the addition of
// the ability to pass a context and additional request options.
//
// See DisableStageTransition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DisableStageTransitionWithContext(ctx aws.Context, input *DisableStageTransitionInput, opts ...request.Option) (*DisableStageTransitionOutput, error) {
	req, out := c.DisableStageTransitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableStageTransition = "EnableStageTransition"

// EnableStageTransitionRequest generates a "aws/request.Request" representing the
// client's request for the EnableStageTransition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableStageTransition for more information on using the EnableStageTransition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableStageTransitionRequest method.
//	req, resp := client.EnableStageTransitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition
func (c *CodePipeline) EnableStageTransitionRequest(input *EnableStageTransitionInput) (req *request.Request, output *EnableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opEnableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableStageTransitionInput{}
	}

	output = &EnableStageTransitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableStageTransition API operation for AWS CodePipeline.
//
// Enables artifacts in a pipeline to transition to a stage in a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation EnableStageTransition for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition
func (c *CodePipeline) EnableStageTransition(input *EnableStageTransitionInput) (*EnableStageTransitionOutput, error) {
	req, out := c.EnableStageTransitionRequest(input)
	return out, req.Send()
}

// EnableStageTransitionWithContext is the same as EnableStageTransition with the addition of
// the ability to pass a context and additional request options.
//
// See EnableStageTransition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) EnableStageTransitionWithContext(ctx aws.Context, input *EnableStageTransitionInput, opts ...request.Option) (*EnableStageTransitionOutput, error) {
	req, out := c.EnableStageTransitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActionType = "GetActionType"

// GetActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetActionType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActionType for more information on using the GetActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetActionTypeRequest method.
//	req, resp := client.GetActionTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetActionType
func (c *CodePipeline) GetActionTypeRequest(input *GetActionTypeInput) (req *request.Request, output *GetActionTypeOutput) {
	op := &request.Operation{
		Name:       opGetActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActionTypeInput{}
	}

	output = &GetActionTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActionType API operation for AWS CodePipeline.
//
// Returns information about an action type created for an external provider,
// where the action is to be used by customers of the external provider. The
// action can be created with any supported integration model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetActionType for usage and error information.
//
// Returned Error Types:
//
//   - ActionTypeNotFoundException
//     The specified action type cannot be found.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetActionType
func (c *CodePipeline) GetActionType(input *GetActionTypeInput) (*GetActionTypeOutput, error) {
	req, out := c.GetActionTypeRequest(input)
	return out, req.Send()
}

// GetActionTypeWithContext is the same as GetActionType with the addition of
// the ability to pass a context and additional request options.
//
// See GetActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetActionTypeWithContext(ctx aws.Context, input *GetActionTypeInput, opts ...request.Option) (*GetActionTypeOutput, error) {
	req, out := c.GetActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobDetails = "GetJobDetails"

// GetJobDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobDetails for more information on using the GetJobDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobDetailsRequest method.
//	req, resp := client.GetJobDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails
func (c *CodePipeline) GetJobDetailsRequest(input *GetJobDetailsInput) (req *request.Request, output *GetJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobDetailsInput{}
	}

	output = &GetJobDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobDetails API operation for AWS CodePipeline.
//
// Returns information about a job. Used for custom actions only.
//
// When this API is called, CodePipeline returns temporary credentials for the
// S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts. This API also returns
// any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetJobDetails for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails
func (c *CodePipeline) GetJobDetails(input *GetJobDetailsInput) (*GetJobDetailsOutput, error) {
	req, out := c.GetJobDetailsRequest(input)
	return out, req.Send()
}

// GetJobDetailsWithContext is the same as GetJobDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetJobDetailsWithContext(ctx aws.Context, input *GetJobDetailsInput, opts ...request.Option) (*GetJobDetailsOutput, error) {
	req, out := c.GetJobDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipeline = "GetPipeline"

// GetPipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipeline for more information on using the GetPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineRequest method.
//	req, resp := client.GetPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline
func (c *CodePipeline) GetPipelineRequest(input *GetPipelineInput) (req *request.Request, output *GetPipelineOutput) {
	op := &request.Operation{
		Name:       opGetPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineInput{}
	}

	output = &GetPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipeline API operation for AWS CodePipeline.
//
// Returns the metadata, structure, stages, and actions of a pipeline. Can be
// used to return the entire structure of a pipeline in JSON format, which can
// then be modified and used to update the pipeline structure with UpdatePipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - PipelineVersionNotFoundException
//     The pipeline version was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline
func (c *CodePipeline) GetPipeline(input *GetPipelineInput) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	return out, req.Send()
}

// GetPipelineWithContext is the same as GetPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineWithContext(ctx aws.Context, input *GetPipelineInput, opts ...request.Option) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineExecution = "GetPipelineExecution"

// GetPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineExecution for more information on using the GetPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineExecutionRequest method.
//	req, resp := client.GetPipelineExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution
func (c *CodePipeline) GetPipelineExecutionRequest(input *GetPipelineExecutionInput) (req *request.Request, output *GetPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opGetPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineExecutionInput{}
	}

	output = &GetPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineExecution API operation for AWS CodePipeline.
//
// Returns information about an execution of a pipeline, including details about
// artifacts, the pipeline execution ID, and the name, version, and status of
// the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipelineExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - PipelineExecutionNotFoundException
//     The pipeline execution was specified in an invalid format or cannot be found,
//     or an execution ID does not belong to the specified pipeline.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution
func (c *CodePipeline) GetPipelineExecution(input *GetPipelineExecutionInput) (*GetPipelineExecutionOutput, error) {
	req, out := c.GetPipelineExecutionRequest(input)
	return out, req.Send()
}

// GetPipelineExecutionWithContext is the same as GetPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineExecutionWithContext(ctx aws.Context, input *GetPipelineExecutionInput, opts ...request.Option) (*GetPipelineExecutionOutput, error) {
	req, out := c.GetPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineState = "GetPipelineState"

// GetPipelineStateRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineState for more information on using the GetPipelineState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPipelineStateRequest method.
//	req, resp := client.GetPipelineStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState
func (c *CodePipeline) GetPipelineStateRequest(input *GetPipelineStateInput) (req *request.Request, output *GetPipelineStateOutput) {
	op := &request.Operation{
		Name:       opGetPipelineState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineStateInput{}
	}

	output = &GetPipelineStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineState API operation for AWS CodePipeline.
//
// Returns information about the state of a pipeline, including the stages and
// actions.
//
// Values returned in the revisionId and revisionUrl fields indicate the source
// revision information, such as the commit ID, for the current state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipelineState for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState
func (c *CodePipeline) GetPipelineState(input *GetPipelineStateInput) (*GetPipelineStateOutput, error) {
	req, out := c.GetPipelineStateRequest(input)
	return out, req.Send()
}

// GetPipelineStateWithContext is the same as GetPipelineState with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineStateWithContext(ctx aws.Context, input *GetPipelineStateInput, opts ...request.Option) (*GetPipelineStateOutput, error) {
	req, out := c.GetPipelineStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThirdPartyJobDetails = "GetThirdPartyJobDetails"

// GetThirdPartyJobDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetThirdPartyJobDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThirdPartyJobDetails for more information on using the GetThirdPartyJobDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetThirdPartyJobDetailsRequest method.
//	req, resp := client.GetThirdPartyJobDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails
func (c *CodePipeline) GetThirdPartyJobDetailsRequest(input *GetThirdPartyJobDetailsInput) (req *request.Request, output *GetThirdPartyJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetThirdPartyJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetThirdPartyJobDetailsInput{}
	}

	output = &GetThirdPartyJobDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThirdPartyJobDetails API operation for AWS CodePipeline.
//
// Requests the details of a job for a third party action. Used for partner
// actions only.
//
// When this API is called, CodePipeline returns temporary credentials for the
// S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts. This API also returns
// any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetThirdPartyJobDetails for usage and error information.
//
// Returned Error Types:
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidClientTokenException
//     The client token was specified in an invalid format
//
//   - InvalidJobException
//     The job was specified in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails
func (c *CodePipeline) GetThirdPartyJobDetails(input *GetThirdPartyJobDetailsInput) (*GetThirdPartyJobDetailsOutput, error) {
	req, out := c.GetThirdPartyJobDetailsRequest(input)
	return out, req.Send()
}

// GetThirdPartyJobDetailsWithContext is the same as GetThirdPartyJobDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetThirdPartyJobDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetThirdPartyJobDetailsWithContext(ctx aws.Context, input *GetThirdPartyJobDetailsInput, opts ...request.Option) (*GetThirdPartyJobDetailsOutput, error) {
	req, out := c.GetThirdPartyJobDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActionExecutions = "ListActionExecutions"

// ListActionExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListActionExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActionExecutions for more information on using the ListActionExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListActionExecutionsRequest method.
//	req, resp := client.ListActionExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions
func (c *CodePipeline) ListActionExecutionsRequest(input *ListActionExecutionsInput) (req *request.Request, output *ListActionExecutionsOutput) {
	op := &request.Operation{
		Name:       opListActionExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionExecutionsInput{}
	}

	output = &ListActionExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActionExecutions API operation for AWS CodePipeline.
//
// Lists the action executions that have occurred in a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListActionExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
//   - PipelineExecutionNotFoundException
//     The pipeline execution was specified in an invalid format or cannot be found,
//     or an execution ID does not belong to the specified pipeline.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions
func (c *CodePipeline) ListActionExecutions(input *ListActionExecutionsInput) (*ListActionExecutionsOutput, error) {
	req, out := c.ListActionExecutionsRequest(input)
	return out, req.Send()
}

// ListActionExecutionsWithContext is the same as ListActionExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListActionExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListActionExecutionsWithContext(ctx aws.Context, input *ListActionExecutionsInput, opts ...request.Option) (*ListActionExecutionsOutput, error) {
	req, out := c.ListActionExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActionExecutionsPages iterates over the pages of a ListActionExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActionExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListActionExecutions operation.
//	pageNum := 0
//	err := client.ListActionExecutionsPages(params,
//	    func(page *codepipeline.ListActionExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListActionExecutionsPages(input *ListActionExecutionsInput, fn func(*ListActionExecutionsOutput, bool) bool) error {
	return c.ListActionExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActionExecutionsPagesWithContext same as ListActionExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListActionExecutionsPagesWithContext(ctx aws.Context, input *ListActionExecutionsInput, fn func(*ListActionExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActionExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActionExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListActionExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListActionTypes = "ListActionTypes"

// ListActionTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListActionTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActionTypes for more information on using the ListActionTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListActionTypesRequest method.
//	req, resp := client.ListActionTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes
func (c *CodePipeline) ListActionTypesRequest(input *ListActionTypesInput) (req *request.Request, output *ListActionTypesOutput) {
	op := &request.Operation{
		Name:       opListActionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionTypesInput{}
	}

	output = &ListActionTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActionTypes API operation for AWS CodePipeline.
//
// Gets a summary of all CodePipeline action types associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListActionTypes for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes
func (c *CodePipeline) ListActionTypes(input *ListActionTypesInput) (*ListActionTypesOutput, error) {
	req, out := c.ListActionTypesRequest(input)
	return out, req.Send()
}

// ListActionTypesWithContext is the same as ListActionTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListActionTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListActionTypesWithContext(ctx aws.Context, input *ListActionTypesInput, opts ...request.Option) (*ListActionTypesOutput, error) {
	req, out := c.ListActionTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActionTypesPages iterates over the pages of a ListActionTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActionTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListActionTypes operation.
//	pageNum := 0
//	err := client.ListActionTypesPages(params,
//	    func(page *codepipeline.ListActionTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListActionTypesPages(input *ListActionTypesInput, fn func(*ListActionTypesOutput, bool) bool) error {
	return c.ListActionTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActionTypesPagesWithContext same as ListActionTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListActionTypesPagesWithContext(ctx aws.Context, input *ListActionTypesInput, fn func(*ListActionTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActionTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActionTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListActionTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelineExecutions = "ListPipelineExecutions"

// ListPipelineExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineExecutions for more information on using the ListPipelineExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPipelineExecutionsRequest method.
//	req, resp := client.ListPipelineExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions
func (c *CodePipeline) ListPipelineExecutionsRequest(input *ListPipelineExecutionsInput) (req *request.Request, output *ListPipelineExecutionsOutput) {
	op := &request.Operation{
		Name:       opListPipelineExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelineExecutionsInput{}
	}

	output = &ListPipelineExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineExecutions API operation for AWS CodePipeline.
//
// Gets a summary of the most recent executions for a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListPipelineExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions
func (c *CodePipeline) ListPipelineExecutions(input *ListPipelineExecutionsInput) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	return out, req.Send()
}

// ListPipelineExecutionsWithContext is the same as ListPipelineExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelineExecutionsWithContext(ctx aws.Context, input *ListPipelineExecutionsInput, opts ...request.Option) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelineExecutionsPages iterates over the pages of a ListPipelineExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelineExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPipelineExecutions operation.
//	pageNum := 0
//	err := client.ListPipelineExecutionsPages(params,
//	    func(page *codepipeline.ListPipelineExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListPipelineExecutionsPages(input *ListPipelineExecutionsInput, fn func(*ListPipelineExecutionsOutput, bool) bool) error {
	return c.ListPipelineExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelineExecutionsPagesWithContext same as ListPipelineExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelineExecutionsPagesWithContext(ctx aws.Context, input *ListPipelineExecutionsInput, fn func(*ListPipelineExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelineExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelineExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelineExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelines for more information on using the ListPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPipelinesRequest method.
//	req, resp := client.ListPipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines
func (c *CodePipeline) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for AWS CodePipeline.
//
// Gets a summary of all of the pipelines associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListPipelines for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines
func (c *CodePipeline) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	return out, req.Send()
}

// ListPipelinesWithContext is the same as ListPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelinesWithContext(ctx aws.Context, input *ListPipelinesInput, opts ...request.Option) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPipelines operation.
//	pageNum := 0
//	err := client.ListPipelinesPages(params,
//	    func(page *codepipeline.ListPipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListPipelinesPages(input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool) error {
	return c.ListPipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelinesPagesWithContext same as ListPipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelinesPagesWithContext(ctx aws.Context, input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource
func (c *CodePipeline) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS CodePipeline.
//
// Gets the set of key-value pairs (metadata) that are used to manage the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ResourceNotFoundException
//     The resource was specified in an invalid format.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
//   - InvalidArnException
//     The specified resource ARN is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource
func (c *CodePipeline) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *codepipeline.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWebhooks = "ListWebhooks"

// ListWebhooksRequest generates a "aws/request.Request" representing the
// client's request for the ListWebhooks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebhooks for more information on using the ListWebhooks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWebhooksRequest method.
//	req, resp := client.ListWebhooksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks
func (c *CodePipeline) ListWebhooksRequest(input *ListWebhooksInput) (req *request.Request, output *ListWebhooksOutput) {
	op := &request.Operation{
		Name:       opListWebhooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWebhooksInput{}
	}

	output = &ListWebhooksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebhooks API operation for AWS CodePipeline.
//
// Gets a listing of all the webhooks in this Amazon Web Services Region for
// this account. The output lists all webhooks and includes the webhook URL
// and ARN and the configuration for each webhook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListWebhooks for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidNextTokenException
//     The next token was specified in an invalid format. Make sure that the next
//     token you provide is the token returned by a previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks
func (c *CodePipeline) ListWebhooks(input *ListWebhooksInput) (*ListWebhooksOutput, error) {
	req, out := c.ListWebhooksRequest(input)
	return out, req.Send()
}

// ListWebhooksWithContext is the same as ListWebhooks with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebhooks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListWebhooksWithContext(ctx aws.Context, input *ListWebhooksInput, opts ...request.Option) (*ListWebhooksOutput, error) {
	req, out := c.ListWebhooksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWebhooksPages iterates over the pages of a ListWebhooks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWebhooks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWebhooks operation.
//	pageNum := 0
//	err := client.ListWebhooksPages(params,
//	    func(page *codepipeline.ListWebhooksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodePipeline) ListWebhooksPages(input *ListWebhooksInput, fn func(*ListWebhooksOutput, bool) bool) error {
	return c.ListWebhooksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWebhooksPagesWithContext same as ListWebhooksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListWebhooksPagesWithContext(ctx aws.Context, input *ListWebhooksInput, fn func(*ListWebhooksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWebhooksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWebhooksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWebhooksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPollForJobs = "PollForJobs"

// PollForJobsRequest generates a "aws/request.Request" representing the
// client's request for the PollForJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForJobs for more information on using the PollForJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PollForJobsRequest method.
//	req, resp := client.PollForJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs
func (c *CodePipeline) PollForJobsRequest(input *PollForJobsInput) (req *request.Request, output *PollForJobsOutput) {
	op := &request.Operation{
		Name:       opPollForJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForJobsInput{}
	}

	output = &PollForJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForJobs API operation for AWS CodePipeline.
//
// Returns information about any jobs for CodePipeline to act on. PollForJobs
// is valid only for action types with "Custom" in the owner field. If the action
// type contains AWS or ThirdParty in the owner field, the PollForJobs action
// returns an error.
//
// When this API is called, CodePipeline returns temporary credentials for the
// S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts. This API also returns
// any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PollForJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ActionTypeNotFoundException
//     The specified action type cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs
func (c *CodePipeline) PollForJobs(input *PollForJobsInput) (*PollForJobsOutput, error) {
	req, out := c.PollForJobsRequest(input)
	return out, req.Send()
}

// PollForJobsWithContext is the same as PollForJobs with the addition of
// the ability to pass a context and additional request options.
//
// See PollForJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PollForJobsWithContext(ctx aws.Context, input *PollForJobsInput, opts ...request.Option) (*PollForJobsOutput, error) {
	req, out := c.PollForJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPollForThirdPartyJobs = "PollForThirdPartyJobs"

// PollForThirdPartyJobsRequest generates a "aws/request.Request" representing the
// client's request for the PollForThirdPartyJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForThirdPartyJobs for more information on using the PollForThirdPartyJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PollForThirdPartyJobsRequest method.
//	req, resp := client.PollForThirdPartyJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs
func (c *CodePipeline) PollForThirdPartyJobsRequest(input *PollForThirdPartyJobsInput) (req *request.Request, output *PollForThirdPartyJobsOutput) {
	op := &request.Operation{
		Name:       opPollForThirdPartyJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForThirdPartyJobsInput{}
	}

	output = &PollForThirdPartyJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForThirdPartyJobs API operation for AWS CodePipeline.
//
// Determines whether there are any third party jobs for a job worker to act
// on. Used for partner actions only.
//
// When this API is called, CodePipeline returns temporary credentials for the
// S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PollForThirdPartyJobs for usage and error information.
//
// Returned Error Types:
//
//   - ActionTypeNotFoundException
//     The specified action type cannot be found.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs
func (c *CodePipeline) PollForThirdPartyJobs(input *PollForThirdPartyJobsInput) (*PollForThirdPartyJobsOutput, error) {
	req, out := c.PollForThirdPartyJobsRequest(input)
	return out, req.Send()
}

// PollForThirdPartyJobsWithContext is the same as PollForThirdPartyJobs with the addition of
// the ability to pass a context and additional request options.
//
// See PollForThirdPartyJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PollForThirdPartyJobsWithContext(ctx aws.Context, input *PollForThirdPartyJobsInput, opts ...request.Option) (*PollForThirdPartyJobsOutput, error) {
	req, out := c.PollForThirdPartyJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutActionRevision = "PutActionRevision"

// PutActionRevisionRequest generates a "aws/request.Request" representing the
// client's request for the PutActionRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutActionRevision for more information on using the PutActionRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutActionRevisionRequest method.
//	req, resp := client.PutActionRevisionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision
func (c *CodePipeline) PutActionRevisionRequest(input *PutActionRevisionInput) (req *request.Request, output *PutActionRevisionOutput) {
	op := &request.Operation{
		Name:       opPutActionRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutActionRevisionInput{}
	}

	output = &PutActionRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutActionRevision API operation for AWS CodePipeline.
//
// Provides information to CodePipeline about new revisions to a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutActionRevision for usage and error information.
//
// Returned Error Types:
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
//   - ActionNotFoundException
//     The specified action cannot be found.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision
func (c *CodePipeline) PutActionRevision(input *PutActionRevisionInput) (*PutActionRevisionOutput, error) {
	req, out := c.PutActionRevisionRequest(input)
	return out, req.Send()
}

// PutActionRevisionWithContext is the same as PutActionRevision with the addition of
// the ability to pass a context and additional request options.
//
// See PutActionRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutActionRevisionWithContext(ctx aws.Context, input *PutActionRevisionInput, opts ...request.Option) (*PutActionRevisionOutput, error) {
	req, out := c.PutActionRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApprovalResult = "PutApprovalResult"

// PutApprovalResultRequest generates a "aws/request.Request" representing the
// client's request for the PutApprovalResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApprovalResult for more information on using the PutApprovalResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutApprovalResultRequest method.
//	req, resp := client.PutApprovalResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult
func (c *CodePipeline) PutApprovalResultRequest(input *PutApprovalResultInput) (req *request.Request, output *PutApprovalResultOutput) {
	op := &request.Operation{
		Name:       opPutApprovalResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApprovalResultInput{}
	}

	output = &PutApprovalResultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutApprovalResult API operation for AWS CodePipeline.
//
// Provides the response to a manual approval request to CodePipeline. Valid
// responses include Approved and Rejected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutApprovalResult for usage and error information.
//
// Returned Error Types:
//
//   - InvalidApprovalTokenException
//     The approval request already received a response or has expired.
//
//   - ApprovalAlreadyCompletedException
//     The approval action has already been approved or rejected.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
//   - ActionNotFoundException
//     The specified action cannot be found.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult
func (c *CodePipeline) PutApprovalResult(input *PutApprovalResultInput) (*PutApprovalResultOutput, error) {
	req, out := c.PutApprovalResultRequest(input)
	return out, req.Send()
}

// PutApprovalResultWithContext is the same as PutApprovalResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutApprovalResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutApprovalResultWithContext(ctx aws.Context, input *PutApprovalResultInput, opts ...request.Option) (*PutApprovalResultOutput, error) {
	req, out := c.PutApprovalResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobFailureResult = "PutJobFailureResult"

// PutJobFailureResultRequest generates a "aws/request.Request" representing the
// client's request for the PutJobFailureResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobFailureResult for more information on using the PutJobFailureResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutJobFailureResultRequest method.
//	req, resp := client.PutJobFailureResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult
func (c *CodePipeline) PutJobFailureResultRequest(input *PutJobFailureResultInput) (req *request.Request, output *PutJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobFailureResultInput{}
	}

	output = &PutJobFailureResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutJobFailureResult API operation for AWS CodePipeline.
//
// Represents the failure of a job as returned to the pipeline by a job worker.
// Used for custom actions only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutJobFailureResult for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - InvalidJobStateException
//     The job state was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult
func (c *CodePipeline) PutJobFailureResult(input *PutJobFailureResultInput) (*PutJobFailureResultOutput, error) {
	req, out := c.PutJobFailureResultRequest(input)
	return out, req.Send()
}

// PutJobFailureResultWithContext is the same as PutJobFailureResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobFailureResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutJobFailureResultWithContext(ctx aws.Context, input *PutJobFailureResultInput, opts ...request.Option) (*PutJobFailureResultOutput, error) {
	req, out := c.PutJobFailureResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobSuccessResult = "PutJobSuccessResult"

// PutJobSuccessResultRequest generates a "aws/request.Request" representing the
// client's request for the PutJobSuccessResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobSuccessResult for more information on using the PutJobSuccessResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutJobSuccessResultRequest method.
//	req, resp := client.PutJobSuccessResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult
func (c *CodePipeline) PutJobSuccessResultRequest(input *PutJobSuccessResultInput) (req *request.Request, output *PutJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobSuccessResultInput{}
	}

	output = &PutJobSuccessResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutJobSuccessResult API operation for AWS CodePipeline.
//
// Represents the success of a job as returned to the pipeline by a job worker.
// Used for custom actions only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutJobSuccessResult for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - InvalidJobStateException
//     The job state was specified in an invalid format.
//
//   - OutputVariablesSizeExceededException
//     Exceeded the total size limit for all variables in the pipeline.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult
func (c *CodePipeline) PutJobSuccessResult(input *PutJobSuccessResultInput) (*PutJobSuccessResultOutput, error) {
	req, out := c.PutJobSuccessResultRequest(input)
	return out, req.Send()
}

// PutJobSuccessResultWithContext is the same as PutJobSuccessResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobSuccessResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutJobSuccessResultWithContext(ctx aws.Context, input *PutJobSuccessResultInput, opts ...request.Option) (*PutJobSuccessResultOutput, error) {
	req, out := c.PutJobSuccessResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutThirdPartyJobFailureResult = "PutThirdPartyJobFailureResult"

// PutThirdPartyJobFailureResultRequest generates a "aws/request.Request" representing the
// client's request for the PutThirdPartyJobFailureResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutThirdPartyJobFailureResult for more information on using the PutThirdPartyJobFailureResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutThirdPartyJobFailureResultRequest method.
//	req, resp := client.PutThirdPartyJobFailureResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult
func (c *CodePipeline) PutThirdPartyJobFailureResultRequest(input *PutThirdPartyJobFailureResultInput) (req *request.Request, output *PutThirdPartyJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobFailureResultInput{}
	}

	output = &PutThirdPartyJobFailureResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutThirdPartyJobFailureResult API operation for AWS CodePipeline.
//
// Represents the failure of a third party job as returned to the pipeline by
// a job worker. Used for partner actions only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutThirdPartyJobFailureResult for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - InvalidJobStateException
//     The job state was specified in an invalid format.
//
//   - InvalidClientTokenException
//     The client token was specified in an invalid format
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult
func (c *CodePipeline) PutThirdPartyJobFailureResult(input *PutThirdPartyJobFailureResultInput) (*PutThirdPartyJobFailureResultOutput, error) {
	req, out := c.PutThirdPartyJobFailureResultRequest(input)
	return out, req.Send()
}

// PutThirdPartyJobFailureResultWithContext is the same as PutThirdPartyJobFailureResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutThirdPartyJobFailureResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutThirdPartyJobFailureResultWithContext(ctx aws.Context, input *PutThirdPartyJobFailureResultInput, opts ...request.Option) (*PutThirdPartyJobFailureResultOutput, error) {
	req, out := c.PutThirdPartyJobFailureResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutThirdPartyJobSuccessResult = "PutThirdPartyJobSuccessResult"

// PutThirdPartyJobSuccessResultRequest generates a "aws/request.Request" representing the
// client's request for the PutThirdPartyJobSuccessResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutThirdPartyJobSuccessResult for more information on using the PutThirdPartyJobSuccessResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutThirdPartyJobSuccessResultRequest method.
//	req, resp := client.PutThirdPartyJobSuccessResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult
func (c *CodePipeline) PutThirdPartyJobSuccessResultRequest(input *PutThirdPartyJobSuccessResultInput) (req *request.Request, output *PutThirdPartyJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobSuccessResultInput{}
	}

	output = &PutThirdPartyJobSuccessResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutThirdPartyJobSuccessResult API operation for AWS CodePipeline.
//
// Represents the success of a third party job as returned to the pipeline by
// a job worker. Used for partner actions only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutThirdPartyJobSuccessResult for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - JobNotFoundException
//     The job was specified in an invalid format or cannot be found.
//
//   - InvalidJobStateException
//     The job state was specified in an invalid format.
//
//   - InvalidClientTokenException
//     The client token was specified in an invalid format
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult
func (c *CodePipeline) PutThirdPartyJobSuccessResult(input *PutThirdPartyJobSuccessResultInput) (*PutThirdPartyJobSuccessResultOutput, error) {
	req, out := c.PutThirdPartyJobSuccessResultRequest(input)
	return out, req.Send()
}

// PutThirdPartyJobSuccessResultWithContext is the same as PutThirdPartyJobSuccessResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutThirdPartyJobSuccessResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutThirdPartyJobSuccessResultWithContext(ctx aws.Context, input *PutThirdPartyJobSuccessResultInput, opts ...request.Option) (*PutThirdPartyJobSuccessResultOutput, error) {
	req, out := c.PutThirdPartyJobSuccessResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutWebhook = "PutWebhook"

// PutWebhookRequest generates a "aws/request.Request" representing the
// client's request for the PutWebhook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutWebhook for more information on using the PutWebhook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutWebhookRequest method.
//	req, resp := client.PutWebhookRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhook
func (c *CodePipeline) PutWebhookRequest(input *PutWebhookInput) (req *request.Request, output *PutWebhookOutput) {
	op := &request.Operation{
		Name:       opPutWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutWebhookInput{}
	}

	output = &PutWebhookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutWebhook API operation for AWS CodePipeline.
//
// Defines a webhook and returns a unique webhook URL generated by CodePipeline.
// This URL can be supplied to third party source hosting providers to call
// every time there's a code change. When CodePipeline receives a POST request
// on this URL, the pipeline defined in the webhook is started as long as the
// POST request satisfied the authentication and filtering requirements supplied
// when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty
// APIs can be used to automatically configure supported third parties to call
// the generated webhook URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutWebhook for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - LimitExceededException
//     The number of pipelines associated with the Amazon Web Services account has
//     exceeded the limit allowed for the account.
//
//   - InvalidWebhookFilterPatternException
//     The specified event filter rule is in an invalid format.
//
//   - InvalidWebhookAuthenticationParametersException
//     The specified authentication type is in an invalid format.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - TooManyTagsException
//     The tags limit for a resource has been exceeded.
//
//   - InvalidTagsException
//     The specified resource tags are invalid.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhook
func (c *CodePipeline) PutWebhook(input *PutWebhookInput) (*PutWebhookOutput, error) {
	req, out := c.PutWebhookRequest(input)
	return out, req.Send()
}

// PutWebhookWithContext is the same as PutWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See PutWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutWebhookWithContext(ctx aws.Context, input *PutWebhookInput, opts ...request.Option) (*PutWebhookOutput, error) {
	req, out := c.PutWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterWebhookWithThirdParty = "RegisterWebhookWithThirdParty"

// RegisterWebhookWithThirdPartyRequest generates a "aws/request.Request" representing the
// client's request for the RegisterWebhookWithThirdParty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterWebhookWithThirdParty for more information on using the RegisterWebhookWithThirdParty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterWebhookWithThirdPartyRequest method.
//	req, resp := client.RegisterWebhookWithThirdPartyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RegisterWebhookWithThirdParty
func (c *CodePipeline) RegisterWebhookWithThirdPartyRequest(input *RegisterWebhookWithThirdPartyInput) (req *request.Request, output *RegisterWebhookWithThirdPartyOutput) {
	op := &request.Operation{
		Name:       opRegisterWebhookWithThirdParty,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWebhookWithThirdPartyInput{}
	}

	output = &RegisterWebhookWithThirdPartyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterWebhookWithThirdParty API operation for AWS CodePipeline.
//
// Configures a connection between the webhook that was created and the external
// tool with events to be detected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation RegisterWebhookWithThirdParty for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - WebhookNotFoundException
//     The specified webhook was entered in an invalid format or cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RegisterWebhookWithThirdParty
func (c *CodePipeline) RegisterWebhookWithThirdParty(input *RegisterWebhookWithThirdPartyInput) (*RegisterWebhookWithThirdPartyOutput, error) {
	req, out := c.RegisterWebhookWithThirdPartyRequest(input)
	return out, req.Send()
}

// RegisterWebhookWithThirdPartyWithContext is the same as RegisterWebhookWithThirdParty with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterWebhookWithThirdParty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) RegisterWebhookWithThirdPartyWithContext(ctx aws.Context, input *RegisterWebhookWithThirdPartyInput, opts ...request.Option) (*RegisterWebhookWithThirdPartyOutput, error) {
	req, out := c.RegisterWebhookWithThirdPartyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetryStageExecution = "RetryStageExecution"

// RetryStageExecutionRequest generates a "aws/request.Request" representing the
// client's request for the RetryStageExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetryStageExecution for more information on using the RetryStageExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetryStageExecutionRequest method.
//	req, resp := client.RetryStageExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution
func (c *CodePipeline) RetryStageExecutionRequest(input *RetryStageExecutionInput) (req *request.Request, output *RetryStageExecutionOutput) {
	op := &request.Operation{
		Name:       opRetryStageExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetryStageExecutionInput{}
	}

	output = &RetryStageExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetryStageExecution API operation for AWS CodePipeline.
//
// You can retry a stage that has failed without having to run a pipeline again
// from the beginning. You do this by either retrying the failed actions in
// a stage or by retrying all actions in the stage starting from the first action
// in the stage. When you retry the failed actions in a stage, all actions that
// are still in progress continue working, and failed actions are triggered
// again. When you retry a failed stage from the first action in the stage,
// the stage cannot have any actions in progress. Before a stage can be retried,
// it must either have all actions failed or some actions failed and some succeeded.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation RetryStageExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConflictException
//     Your request cannot be handled because the pipeline is busy handling ongoing
//     activities. Try again later.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
//   - StageNotRetryableException
//     Unable to retry. The pipeline structure or stage state might have changed
//     while actions awaited retry, or the stage contains no failed actions.
//
//   - NotLatestPipelineExecutionException
//     The stage has failed in a later run of the pipeline and the pipelineExecutionId
//     associated with the request is out of date.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution
func (c *CodePipeline) RetryStageExecution(input *RetryStageExecutionInput) (*RetryStageExecutionOutput, error) {
	req, out := c.RetryStageExecutionRequest(input)
	return out, req.Send()
}

// RetryStageExecutionWithContext is the same as RetryStageExecution with the addition of
// the ability to pass a context and additional request options.
//
// See RetryStageExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) RetryStageExecutionWithContext(ctx aws.Context, input *RetryStageExecutionInput, opts ...request.Option) (*RetryStageExecutionOutput, error) {
	req, out := c.RetryStageExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRollbackStage = "RollbackStage"

// RollbackStageRequest generates a "aws/request.Request" representing the
// client's request for the RollbackStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RollbackStage for more information on using the RollbackStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RollbackStageRequest method.
//	req, resp := client.RollbackStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RollbackStage
func (c *CodePipeline) RollbackStageRequest(input *RollbackStageInput) (req *request.Request, output *RollbackStageOutput) {
	op := &request.Operation{
		Name:       opRollbackStage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RollbackStageInput{}
	}

	output = &RollbackStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RollbackStage API operation for AWS CodePipeline.
//
// Rolls back a stage execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation RollbackStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConflictException
//     Your request cannot be handled because the pipeline is busy handling ongoing
//     activities. Try again later.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - PipelineExecutionNotFoundException
//     The pipeline execution was specified in an invalid format or cannot be found,
//     or an execution ID does not belong to the specified pipeline.
//
//   - PipelineExecutionOutdatedException
//     The specified pipeline execution is outdated and cannot be used as a target
//     pipeline execution for rollback.
//
//   - StageNotFoundException
//     The stage was specified in an invalid format or cannot be found.
//
//   - UnableToRollbackStageException
//     Unable to roll back the stage. The cause might be if the pipeline version
//     has changed since the target pipeline execution was deployed, the stage is
//     currently running, or an incorrect target pipeline execution ID was provided.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RollbackStage
func (c *CodePipeline) RollbackStage(input *RollbackStageInput) (*RollbackStageOutput, error) {
	req, out := c.RollbackStageRequest(input)
	return out, req.Send()
}

// RollbackStageWithContext is the same as RollbackStage with the addition of
// the ability to pass a context and additional request options.
//
// See RollbackStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) RollbackStageWithContext(ctx aws.Context, input *RollbackStageInput, opts ...request.Option) (*RollbackStageOutput, error) {
	req, out := c.RollbackStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipelineExecution = "StartPipelineExecution"

// StartPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipelineExecution for more information on using the StartPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartPipelineExecutionRequest method.
//	req, resp := client.StartPipelineExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution
func (c *CodePipeline) StartPipelineExecutionRequest(input *StartPipelineExecutionInput) (req *request.Request, output *StartPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStartPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPipelineExecutionInput{}
	}

	output = &StartPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipelineExecution API operation for AWS CodePipeline.
//
// Starts the specified pipeline. Specifically, it begins processing the latest
// commit to the source location specified as part of the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation StartPipelineExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConflictException
//     Your request cannot be handled because the pipeline is busy handling ongoing
//     activities. Try again later.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - ConcurrentPipelineExecutionsLimitExceededException
//     The pipeline has reached the limit for concurrent pipeline executions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution
func (c *CodePipeline) StartPipelineExecution(input *StartPipelineExecutionInput) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	return out, req.Send()
}

// StartPipelineExecutionWithContext is the same as StartPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) StartPipelineExecutionWithContext(ctx aws.Context, input *StartPipelineExecutionInput, opts ...request.Option) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPipelineExecution = "StopPipelineExecution"

// StopPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPipelineExecution for more information on using the StopPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopPipelineExecutionRequest method.
//	req, resp := client.StopPipelineExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StopPipelineExecution
func (c *CodePipeline) StopPipelineExecutionRequest(input *StopPipelineExecutionInput) (req *request.Request, output *StopPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStopPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPipelineExecutionInput{}
	}

	output = &StopPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPipelineExecution API operation for AWS CodePipeline.
//
// Stops the specified pipeline execution. You choose to either stop the pipeline
// execution by completing in-progress actions without starting subsequent actions,
// or by abandoning in-progress actions. While completing or abandoning in-progress
// actions, the pipeline execution is in a Stopping state. After all in-progress
// actions are completed or abandoned, the pipeline execution is in a Stopped
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation StopPipelineExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ConflictException
//     Your request cannot be handled because the pipeline is busy handling ongoing
//     activities. Try again later.
//
//   - PipelineNotFoundException
//     The pipeline was specified in an invalid format or cannot be found.
//
//   - PipelineExecutionNotStoppableException
//     Unable to stop the pipeline execution. The execution might already be in
//     a Stopped state, or it might no longer be in progress.
//
//   - DuplicatedStopRequestException
//     The pipeline execution is already in a Stopping state. If you already chose
//     to stop and wait, you cannot make that request again. You can choose to stop
//     and abandon now, but be aware that this option can lead to failed tasks or
//     out of sequence tasks. If you already chose to stop and abandon, you cannot
//     make that request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StopPipelineExecution
func (c *CodePipeline) StopPipelineExecution(input *StopPipelineExecutionInput) (*StopPipelineExecutionOutput, error) {
	req, out := c.StopPipelineExecutionRequest(input)
	return out, req.Send()
}

// StopPipelineExecutionWithContext is the same as StopPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) StopPipelineExecutionWithContext(ctx aws.Context, input *StopPipelineExecutionInput, opts ...request.Option) (*StopPipelineExecutionOutput, error) {
	req, out := c.StopPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/TagResource
func (c *CodePipeline) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS CodePipeline.
//
// Adds to or modifies the tags of the given resource. Tags are metadata that
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ResourceNotFoundException
//     The resource was specified in an invalid format.
//
//   - InvalidArnException
//     The specified resource ARN is invalid.
//
//   - TooManyTagsException
//     The tags limit for a resource has been exceeded.
//
//   - InvalidTagsException
//     The specified resource tags are invalid.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/TagResource
func (c *CodePipeline) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UntagResource
func (c *CodePipeline) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS CodePipeline.
//
// Removes tags from an Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ResourceNotFoundException
//     The resource was specified in an invalid format.
//
//   - InvalidArnException
//     The specified resource ARN is invalid.
//
//   - InvalidTagsException
//     The specified resource tags are invalid.
//
//   - ConcurrentModificationException
//     Unable to modify the tag due to a simultaneous update request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UntagResource
func (c *CodePipeline) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateActionType = "UpdateActionType"

// UpdateActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateActionType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateActionType for more information on using the UpdateActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateActionTypeRequest method.
//	req, resp := client.UpdateActionTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdateActionType
func (c *CodePipeline) UpdateActionTypeRequest(input *UpdateActionTypeInput) (req *request.Request, output *UpdateActionTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateActionTypeInput{}
	}

	output = &UpdateActionTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateActionType API operation for AWS CodePipeline.
//
// Updates an action type that was created with any supported integration model,
// where the action type is to be used by customers of the action type provider.
// Use a JSON file with the action definition and UpdateActionType to provide
// the full structure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation UpdateActionType for usage and error information.
//
// Returned Error Types:
//
//   - RequestFailedException
//     The request failed because of an unknown error, exception, or failure.
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - ActionTypeNotFoundException
//     The specified action type cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdateActionType
func (c *CodePipeline) UpdateActionType(input *UpdateActionTypeInput) (*UpdateActionTypeOutput, error) {
	req, out := c.UpdateActionTypeRequest(input)
	return out, req.Send()
}

// UpdateActionTypeWithContext is the same as UpdateActionType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) UpdateActionTypeWithContext(ctx aws.Context, input *UpdateActionTypeInput, opts ...request.Option) (*UpdateActionTypeOutput, error) {
	req, out := c.UpdateActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipeline for more information on using the UpdatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePipelineRequest method.
//	req, resp := client.UpdatePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline
func (c *CodePipeline) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipeline API operation for AWS CodePipeline.
//
// Updates a specified pipeline with edits or changes to its structure. Use
// a JSON file with the pipeline structure and UpdatePipeline to provide the
// full structure of the pipeline. Updating the pipeline increases the version
// number of the pipeline by 1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The validation was specified in an invalid format.
//
//   - InvalidStageDeclarationException
//     The stage declaration was specified in an invalid format.
//
//   - InvalidActionDeclarationException
//     The action declaration was specified in an invalid format.
//
//   - InvalidBlockerDeclarationException
//     Reserved for future use.
//
//   - InvalidStructureException
//     The structure was specified in an invalid format.
//
//   - LimitExceededException
//     The number of pipelines associated with the Amazon Web Services account has
//     exceeded the limit allowed for the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline
func (c *CodePipeline) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	return out, req.Send()
}

// UpdatePipelineWithContext is the same as UpdatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) UpdatePipelineWithContext(ctx aws.Context, input *UpdatePipelineInput, opts ...request.Option) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an Amazon Web Services session credentials object. These credentials
// are temporary credentials that are issued by Amazon Web Services Secure Token
// Service (STS). They can be used to access input and output artifacts in the
// S3 bucket used to store artifact for the pipeline in CodePipeline.
type AWSSessionCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The access key for the session.
	//
	// AccessKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AWSSessionCredentials's
	// String and GoString methods.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true" sensitive:"true"`

	// The secret access key for the session.
	//
	// SecretAccessKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AWSSessionCredentials's
	// String and GoString methods.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true" sensitive:"true"`

	// The token for the session.
	//
	// SessionToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AWSSessionCredentials's
	// String and GoString methods.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSSessionCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSSessionCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AWSSessionCredentials) SetAccessKeyId(v string) *AWSSessionCredentials {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AWSSessionCredentials) SetSecretAccessKey(v string) *AWSSessionCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AWSSessionCredentials) SetSessionToken(v string) *AWSSessionCredentials {
	s.SessionToken = &v
	return s
}

// Represents the input of an AcknowledgeJob action.
type AcknowledgeJobInput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the job for which you want to confirm receipt.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A system-generated random number that CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Get this number from the response
	// of the PollForJobs request that returned this job.
	//
	// Nonce is a required field
	Nonce *string `locationName:"nonce" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Nonce == nil {
		invalidParams.Add(request.NewErrParamRequired("Nonce"))
	}
	if s.Nonce != nil && len(*s.Nonce) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Nonce", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *AcknowledgeJobInput) SetJobId(v string) *AcknowledgeJobInput {
	s.JobId = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *AcknowledgeJobInput) SetNonce(v string) *AcknowledgeJobInput {
	s.Nonce = &v
	return s
}

// Represents the output of an AcknowledgeJob action.
type AcknowledgeJobOutput struct {
	_ struct{} `type:"structure"`

	// Whether the job worker has received the specified job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AcknowledgeJobOutput) SetStatus(v string) *AcknowledgeJobOutput {
	s.Status = &v
	return s
}

// Represents the input of an AcknowledgeThirdPartyJob action.
type AcknowledgeThirdPartyJobInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// The unique system-generated ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// A system-generated random number that CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Get this number from the response
	// to a GetThirdPartyJobDetails request.
	//
	// Nonce is a required field
	Nonce *string `locationName:"nonce" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeThirdPartyJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeThirdPartyJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeThirdPartyJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeThirdPartyJobInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Nonce == nil {
		invalidParams.Add(request.NewErrParamRequired("Nonce"))
	}
	if s.Nonce != nil && len(*s.Nonce) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Nonce", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcknowledgeThirdPartyJobInput) SetClientToken(v string) *AcknowledgeThirdPartyJobInput {
	s.ClientToken = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AcknowledgeThirdPartyJobInput) SetJobId(v string) *AcknowledgeThirdPartyJobInput {
	s.JobId = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *AcknowledgeThirdPartyJobInput) SetNonce(v string) *AcknowledgeThirdPartyJobInput {
	s.Nonce = &v
	return s
}

// Represents the output of an AcknowledgeThirdPartyJob action.
type AcknowledgeThirdPartyJobOutput struct {
	_ struct{} `type:"structure"`

	// The status information for the third party job, if any.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeThirdPartyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeThirdPartyJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AcknowledgeThirdPartyJobOutput) SetStatus(v string) *AcknowledgeThirdPartyJobOutput {
	s.Status = &v
	return s
}

// Represents information about an action configuration.
type ActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration data for the action.
	Configuration map[string]*string `locationName:"configuration" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionConfiguration) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionConfiguration) SetConfiguration(v map[string]*string) *ActionConfiguration {
	s.Configuration = v
	return s
}

// Represents information about an action configuration property.
type ActionConfigurationProperty struct {
	_ struct{} `type:"structure"`

	// The description of the action configuration property that is displayed to
	// users.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the configuration property is a key.
	//
	// Key is a required field
	Key *bool `locationName:"key" type:"boolean" required:"true"`

	// The name of the action configuration property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Indicates that the property is used with PollForJobs. When creating a custom
	// action, an action can have up to one queryable property. If it has one, that
	// property must be both required and not secret.
	//
	// If you create a pipeline with a custom action type, and that custom action
	// contains a queryable property, the value for that configuration property
	// is subject to other restrictions. The value must be less than or equal to
	// twenty (20) characters. The value can contain only alphanumeric characters,
	// underscores, and hyphens.
	Queryable *bool `locationName:"queryable" type:"boolean"`

	// Whether the configuration property is a required value.
	//
	// Required is a required field
	Required *bool `locationName:"required" type:"boolean" required:"true"`

	// Whether the configuration property is secret. Secrets are hidden from all
	// calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and
	// PollForThirdPartyJobs.
	//
	// When updating a pipeline, passing * * * * * without changing any other values
	// of the action preserves the previous value of the secret.
	//
	// Secret is a required field
	Secret *bool `locationName:"secret" type:"boolean" required:"true"`

	// The type of the configuration property.
	Type *string `locationName:"type" type:"string" enum:"ActionConfigurationPropertyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionConfigurationProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionConfigurationProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionConfigurationProperty"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Required == nil {
		invalidParams.Add(request.NewErrParamRequired("Required"))
	}
	if s.Secret == nil {
		invalidParams.Add(request.NewErrParamRequired("Secret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ActionConfigurationProperty) SetDescription(v string) *ActionConfigurationProperty {
	s.Description = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ActionConfigurationProperty) SetKey(v bool) *ActionConfigurationProperty {
	s.Key = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionConfigurationProperty) SetName(v string) *ActionConfigurationProperty {
	s.Name = &v
	return s
}

// SetQueryable sets the Queryable field's value.
func (s *ActionConfigurationProperty) SetQueryable(v bool) *ActionConfigurationProperty {
	s.Queryable = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ActionConfigurationProperty) SetRequired(v bool) *ActionConfigurationProperty {
	s.Required = &v
	return s
}

// SetSecret sets the Secret field's value.
func (s *ActionConfigurationProperty) SetSecret(v bool) *ActionConfigurationProperty {
	s.Secret = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActionConfigurationProperty) SetType(v string) *ActionConfigurationProperty {
	s.Type = &v
	return s
}

// Represents the context of an action in the stage of a pipeline to a job worker.
type ActionContext struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID that corresponds to an action's execution.
	ActionExecutionId *string `locationName:"actionExecutionId" type:"string"`

	// The name of the action in the context of a job.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionContext) GoString() string {
	return s.String()
}

// SetActionExecutionId sets the ActionExecutionId field's value.
func (s *ActionContext) SetActionExecutionId(v string) *ActionContext {
	s.ActionExecutionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionContext) SetName(v string) *ActionContext {
	s.Name = &v
	return s
}

// Represents information about an action declaration.
type ActionDeclaration struct {
	_ struct{} `type:"structure"`

	// Specifies the action type and the provider of the action.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The action's configuration. These are key-value pairs that specify input
	// values for an action. For more information, see Action Structure Requirements
	// in CodePipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	// For the list of configuration properties for the CloudFormation action type
	// in CodePipeline, see Configuration Properties Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html)
	// in the CloudFormation User Guide. For template snippets with examples, see
	// Using Parameter Override Functions with CodePipeline Pipelines (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html)
	// in the CloudFormation User Guide.
	//
	// The values can be represented in either JSON or YAML format. For example,
	// the JSON configuration item format is as follows:
	//
	// JSON:
	//
	// "Configuration" : { Key : Value },
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// The name or ID of the artifact consumed by the action, such as a test or
	// build artifact.
	InputArtifacts []*InputArtifact `locationName:"inputArtifacts" type:"list"`

	// The action declaration's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The variable namespace associated with the action. All variables produced
	// as output by this action fall under this namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The name or ID of the result of the action declaration, such as a test or
	// build artifact.
	OutputArtifacts []*OutputArtifact `locationName:"outputArtifacts" type:"list"`

	// The action declaration's Amazon Web Services Region, such as us-east-1.
	Region *string `locationName:"region" min:"4" type:"string"`

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The order in which actions are run.
	RunOrder *int64 `locationName:"runOrder" min:"1" type:"integer"`

	// A timeout duration in minutes that can be applied against the ActionType’s
	// default timeout value specified in Quotas for CodePipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/limits.html).
	// This attribute is available only to the manual approval ActionType.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionDeclaration"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Region != nil && len(*s.Region) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 4))
	}
	if s.RunOrder != nil && *s.RunOrder < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RunOrder", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 5))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}
	if s.InputArtifacts != nil {
		for i, v := range s.InputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputArtifacts != nil {
		for i, v := range s.OutputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *ActionDeclaration) SetActionTypeId(v *ActionTypeId) *ActionDeclaration {
	s.ActionTypeId = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionDeclaration) SetConfiguration(v map[string]*string) *ActionDeclaration {
	s.Configuration = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *ActionDeclaration) SetInputArtifacts(v []*InputArtifact) *ActionDeclaration {
	s.InputArtifacts = v
	return s
}

// SetName sets the Name field's value.
func (s *ActionDeclaration) SetName(v string) *ActionDeclaration {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ActionDeclaration) SetNamespace(v string) *ActionDeclaration {
	s.Namespace = &v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *ActionDeclaration) SetOutputArtifacts(v []*OutputArtifact) *ActionDeclaration {
	s.OutputArtifacts = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ActionDeclaration) SetRegion(v string) *ActionDeclaration {
	s.Region = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ActionDeclaration) SetRoleArn(v string) *ActionDeclaration {
	s.RoleArn = &v
	return s
}

// SetRunOrder sets the RunOrder field's value.
func (s *ActionDeclaration) SetRunOrder(v int64) *ActionDeclaration {
	s.RunOrder = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *ActionDeclaration) SetTimeoutInMinutes(v int64) *ActionDeclaration {
	s.TimeoutInMinutes = &v
	return s
}

// Represents information about the run of an action.
type ActionExecution struct {
	_ struct{} `type:"structure"`

	// ID of the workflow action execution in the current stage. Use the GetPipelineState
	// action to retrieve the current action execution details of the current stage.
	//
	// For older executions, this field might be empty. The action execution ID
	// is available for executions run on or after March 2020.
	ActionExecutionId *string `locationName:"actionExecutionId" type:"string"`

	// The details of an error returned by a URL external to Amazon Web Services.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The external ID of the run of the action.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The URL of a resource external to Amazon Web Services that is used when running
	// the action (for example, an external repository URL).
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`

	// The last status change of the action.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp"`

	// The ARN of the user who last changed the pipeline.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" type:"string"`

	// A percentage of completeness of the action as it runs.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The status of the action, or for a completed action, the last status of the
	// action.
	Status *string `locationName:"status" type:"string" enum:"ActionExecutionStatus"`

	// A summary of the run of the action.
	Summary *string `locationName:"summary" min:"1" type:"string"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// command. It is used to validate that the approval request corresponding to
	// this token is still valid.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecution) GoString() string {
	return s.String()
}

// SetActionExecutionId sets the ActionExecutionId field's value.
func (s *ActionExecution) SetActionExecutionId(v string) *ActionExecution {
	s.ActionExecutionId = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *ActionExecution) SetErrorDetails(v *ErrorDetails) *ActionExecution {
	s.ErrorDetails = v
	return s
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *ActionExecution) SetExternalExecutionId(v string) *ActionExecution {
	s.ExternalExecutionId = &v
	return s
}

// SetExternalExecutionUrl sets the ExternalExecutionUrl field's value.
func (s *ActionExecution) SetExternalExecutionUrl(v string) *ActionExecution {
	s.ExternalExecutionUrl = &v
	return s
}

// SetLastStatusChange sets the LastStatusChange field's value.
func (s *ActionExecution) SetLastStatusChange(v time.Time) *ActionExecution {
	s.LastStatusChange = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *ActionExecution) SetLastUpdatedBy(v string) *ActionExecution {
	s.LastUpdatedBy = &v
	return s
}

// SetPercentComplete sets the PercentComplete field's value.
func (s *ActionExecution) SetPercentComplete(v int64) *ActionExecution {
	s.PercentComplete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActionExecution) SetStatus(v string) *ActionExecution {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ActionExecution) SetSummary(v string) *ActionExecution {
	s.Summary = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ActionExecution) SetToken(v string) *ActionExecution {
	s.Token = &v
	return s
}

// Returns information about an execution of an action, including the action
// execution ID, and the name, version, and timing of the action.
type ActionExecutionDetail struct {
	_ struct{} `type:"structure"`

	// The action execution ID.
	ActionExecutionId *string `locationName:"actionExecutionId" type:"string"`

	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Input details for the action execution, such as role ARN, Region, and input
	// artifacts.
	Input *ActionExecutionInput `locationName:"input" type:"structure"`

	// The last update time of the action execution.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// Output details for the action execution, such as the action execution result.
	Output *ActionExecutionOutput `locationName:"output" type:"structure"`

	// The pipeline execution ID for the action execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The version of the pipeline where the action was run.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// The name of the stage that contains the action.
	StageName *string `locationName:"stageName" min:"1" type:"string"`

	// The start time of the action execution.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the action execution. Status categories are InProgress, Succeeded,
	// and Failed.
	Status *string `locationName:"status" type:"string" enum:"ActionExecutionStatus"`

	// The ARN of the user who changed the pipeline execution details.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionDetail) GoString() string {
	return s.String()
}

// SetActionExecutionId sets the ActionExecutionId field's value.
func (s *ActionExecutionDetail) SetActionExecutionId(v string) *ActionExecutionDetail {
	s.ActionExecutionId = &v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *ActionExecutionDetail) SetActionName(v string) *ActionExecutionDetail {
	s.ActionName = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ActionExecutionDetail) SetInput(v *ActionExecutionInput) *ActionExecutionDetail {
	s.Input = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ActionExecutionDetail) SetLastUpdateTime(v time.Time) *ActionExecutionDetail {
	s.LastUpdateTime = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *ActionExecutionDetail) SetOutput(v *ActionExecutionOutput) *ActionExecutionDetail {
	s.Output = v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *ActionExecutionDetail) SetPipelineExecutionId(v string) *ActionExecutionDetail {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineVersion sets the PipelineVersion field's value.
func (s *ActionExecutionDetail) SetPipelineVersion(v int64) *ActionExecutionDetail {
	s.PipelineVersion = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ActionExecutionDetail) SetStageName(v string) *ActionExecutionDetail {
	s.StageName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ActionExecutionDetail) SetStartTime(v time.Time) *ActionExecutionDetail {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActionExecutionDetail) SetStatus(v string) *ActionExecutionDetail {
	s.Status = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *ActionExecutionDetail) SetUpdatedBy(v string) *ActionExecutionDetail {
	s.UpdatedBy = &v
	return s
}

// Filter values for the action execution.
type ActionExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The latest execution in the pipeline.
	//
	// Filtering on the latest execution is available for executions run on or after
	// February 08, 2024.
	LatestInPipelineExecution *LatestInPipelineExecutionFilter `locationName:"latestInPipelineExecution" type:"structure"`

	// The pipeline execution ID used to filter action execution history.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionExecutionFilter"}
	if s.LatestInPipelineExecution != nil {
		if err := s.LatestInPipelineExecution.Validate(); err != nil {
			invalidParams.AddNested("LatestInPipelineExecution", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatestInPipelineExecution sets the LatestInPipelineExecution field's value.
func (s *ActionExecutionFilter) SetLatestInPipelineExecution(v *LatestInPipelineExecutionFilter) *ActionExecutionFilter {
	s.LatestInPipelineExecution = v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *ActionExecutionFilter) SetPipelineExecutionId(v string) *ActionExecutionFilter {
	s.PipelineExecutionId = &v
	return s
}

// Input information used for an action execution.
type ActionExecutionInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Configuration data for an action execution.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// Details of input artifacts of the action that correspond to the action execution.
	InputArtifacts []*ArtifactDetail `locationName:"inputArtifacts" type:"list"`

	// The variable namespace associated with the action. All variables produced
	// as output by this action fall under this namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The Amazon Web Services Region for the action, such as us-east-1.
	Region *string `locationName:"region" min:"4" type:"string"`

	// Configuration data for an action execution with all variable references replaced
	// with their real values for the execution.
	ResolvedConfiguration map[string]*string `locationName:"resolvedConfiguration" type:"map"`

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionInput) GoString() string {
	return s.String()
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *ActionExecutionInput) SetActionTypeId(v *ActionTypeId) *ActionExecutionInput {
	s.ActionTypeId = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionExecutionInput) SetConfiguration(v map[string]*string) *ActionExecutionInput {
	s.Configuration = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *ActionExecutionInput) SetInputArtifacts(v []*ArtifactDetail) *ActionExecutionInput {
	s.InputArtifacts = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ActionExecutionInput) SetNamespace(v string) *ActionExecutionInput {
	s.Namespace = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ActionExecutionInput) SetRegion(v string) *ActionExecutionInput {
	s.Region = &v
	return s
}

// SetResolvedConfiguration sets the ResolvedConfiguration field's value.
func (s *ActionExecutionInput) SetResolvedConfiguration(v map[string]*string) *ActionExecutionInput {
	s.ResolvedConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ActionExecutionInput) SetRoleArn(v string) *ActionExecutionInput {
	s.RoleArn = &v
	return s
}

// Output details listed for an action execution, such as the action execution
// result.
type ActionExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Execution result information listed in the output details for an action execution.
	ExecutionResult *ActionExecutionResult `locationName:"executionResult" type:"structure"`

	// Details of output artifacts of the action that correspond to the action execution.
	OutputArtifacts []*ArtifactDetail `locationName:"outputArtifacts" type:"list"`

	// The outputVariables field shows the key-value pairs that were output as part
	// of that execution.
	OutputVariables map[string]*string `locationName:"outputVariables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionResult sets the ExecutionResult field's value.
func (s *ActionExecutionOutput) SetExecutionResult(v *ActionExecutionResult) *ActionExecutionOutput {
	s.ExecutionResult = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *ActionExecutionOutput) SetOutputArtifacts(v []*ArtifactDetail) *ActionExecutionOutput {
	s.OutputArtifacts = v
	return s
}

// SetOutputVariables sets the OutputVariables field's value.
func (s *ActionExecutionOutput) SetOutputVariables(v map[string]*string) *ActionExecutionOutput {
	s.OutputVariables = v
	return s
}

// Execution result information, such as the external execution ID.
type ActionExecutionResult struct {
	_ struct{} `type:"structure"`

	// Represents information about an error in CodePipeline.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The action provider's external ID for the action execution.
	ExternalExecutionId *string `locationName:"externalExecutionId" type:"string"`

	// The action provider's summary for the action execution.
	ExternalExecutionSummary *string `locationName:"externalExecutionSummary" type:"string"`

	// The deepest external link to the external resource (for example, a repository
	// URL or deployment endpoint) that is used when running the action.
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionExecutionResult) GoString() string {
	return s.String()
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *ActionExecutionResult) SetErrorDetails(v *ErrorDetails) *ActionExecutionResult {
	s.ErrorDetails = v
	return s
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *ActionExecutionResult) SetExternalExecutionId(v string) *ActionExecutionResult {
	s.ExternalExecutionId = &v
	return s
}

// SetExternalExecutionSummary sets the ExternalExecutionSummary field's value.
func (s *ActionExecutionResult) SetExternalExecutionSummary(v string) *ActionExecutionResult {
	s.ExternalExecutionSummary = &v
	return s
}

// SetExternalExecutionUrl sets the ExternalExecutionUrl field's value.
func (s *ActionExecutionResult) SetExternalExecutionUrl(v string) *ActionExecutionResult {
	s.ExternalExecutionUrl = &v
	return s
}

// The specified action cannot be found.
type ActionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionNotFoundException) GoString() string {
	return s.String()
}

func newErrorActionNotFoundException(v protocol.ResponseMetadata) error {
	return &ActionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ActionNotFoundException) Code() string {
	return "ActionNotFoundException"
}

// Message returns the exception's message.
func (s *ActionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ActionNotFoundException) OrigErr() error {
	return nil
}

func (s *ActionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ActionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ActionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about the version (or revision) of an action.
type ActionRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent version of the action was created,
	// in timestamp format.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" required:"true"`

	// The unique identifier of the change that set the state to this revision (for
	// example, a deployment ID or timestamp).
	//
	// RevisionChangeId is a required field
	RevisionChangeId *string `locationName:"revisionChangeId" min:"1" type:"string" required:"true"`

	// The system-generated unique ID that identifies the revision number of the
	// action.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRevision) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionRevision) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionRevision"}
	if s.Created == nil {
		invalidParams.Add(request.NewErrParamRequired("Created"))
	}
	if s.RevisionChangeId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionChangeId"))
	}
	if s.RevisionChangeId != nil && len(*s.RevisionChangeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionChangeId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreated sets the Created field's value.
func (s *ActionRevision) SetCreated(v time.Time) *ActionRevision {
	s.Created = &v
	return s
}

// SetRevisionChangeId sets the RevisionChangeId field's value.
func (s *ActionRevision) SetRevisionChangeId(v string) *ActionRevision {
	s.RevisionChangeId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ActionRevision) SetRevisionId(v string) *ActionRevision {
	s.RevisionId = &v
	return s
}

// Represents information about the state of an action.
type ActionState struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Represents information about the version (or revision) of an action.
	CurrentRevision *ActionRevision `locationName:"currentRevision" type:"structure"`

	// A URL link for more information about the state of the action, such as a
	// deployment group details page.
	EntityUrl *string `locationName:"entityUrl" min:"1" type:"string"`

	// Represents information about the run of an action.
	LatestExecution *ActionExecution `locationName:"latestExecution" type:"structure"`

	// A URL link for more information about the revision, such as a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionState) GoString() string {
	return s.String()
}

// SetActionName sets the ActionName field's value.
func (s *ActionState) SetActionName(v string) *ActionState {
	s.ActionName = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *ActionState) SetCurrentRevision(v *ActionRevision) *ActionState {
	s.CurrentRevision = v
	return s
}

// SetEntityUrl sets the EntityUrl field's value.
func (s *ActionState) SetEntityUrl(v string) *ActionState {
	s.EntityUrl = &v
	return s
}

// SetLatestExecution sets the LatestExecution field's value.
func (s *ActionState) SetLatestExecution(v *ActionExecution) *ActionState {
	s.LatestExecution = v
	return s
}

// SetRevisionUrl sets the RevisionUrl field's value.
func (s *ActionState) SetRevisionUrl(v string) *ActionState {
	s.RevisionUrl = &v
	return s
}

// Returns information about the details of an action type.
type ActionType struct {
	_ struct{} `type:"structure"`

	// The configuration properties for the action type.
	ActionConfigurationProperties []*ActionConfigurationProperty `locationName:"actionConfigurationProperties" type:"list"`

	// Represents information about an action type.
	//
	// Id is a required field
	Id *ActionTypeId `locationName:"id" type:"structure" required:"true"`

	// The details of the input artifact for the action, such as its commit ID.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The settings for the action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionType) GoString() string {
	return s.String()
}

// SetActionConfigurationProperties sets the ActionConfigurationProperties field's value.
func (s *ActionType) SetActionConfigurationProperties(v []*ActionConfigurationProperty) *ActionType {
	s.ActionConfigurationProperties = v
	return s
}

// SetId sets the Id field's value.
func (s *ActionType) SetId(v *ActionTypeId) *ActionType {
	s.Id = v
	return s
}

// SetInputArtifactDetails sets the InputArtifactDetails field's value.
func (s *ActionType) SetInputArtifactDetails(v *ArtifactDetails) *ActionType {
	s.InputArtifactDetails = v
	return s
}

// SetOutputArtifactDetails sets the OutputArtifactDetails field's value.
func (s *ActionType) SetOutputArtifactDetails(v *ArtifactDetails) *ActionType {
	s.OutputArtifactDetails = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *ActionType) SetSettings(v *ActionTypeSettings) *ActionType {
	s.Settings = v
	return s
}

// Information about parameters for artifacts associated with the action type,
// such as the minimum and maximum artifacts allowed.
type ActionTypeArtifactDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of artifacts that can be used with the actiontype. For
	// example, you should specify a minimum and maximum of zero input artifacts
	// for an action type with a category of source.
	//
	// MaximumCount is a required field
	MaximumCount *int64 `locationName:"maximumCount" type:"integer" required:"true"`

	// The minimum number of artifacts that can be used with the action type. For
	// example, you should specify a minimum and maximum of zero input artifacts
	// for an action type with a category of source.
	//
	// MinimumCount is a required field
	MinimumCount *int64 `locationName:"minimumCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeArtifactDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeArtifactDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeArtifactDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeArtifactDetails"}
	if s.MaximumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumCount"))
	}
	if s.MinimumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumCount sets the MaximumCount field's value.
func (s *ActionTypeArtifactDetails) SetMaximumCount(v int64) *ActionTypeArtifactDetails {
	s.MaximumCount = &v
	return s
}

// SetMinimumCount sets the MinimumCount field's value.
func (s *ActionTypeArtifactDetails) SetMinimumCount(v int64) *ActionTypeArtifactDetails {
	s.MinimumCount = &v
	return s
}

// The parameters for the action type definition that are provided when the
// action type is created or updated.
type ActionTypeDeclaration struct {
	_ struct{} `type:"structure"`

	// The description for the action type to be updated.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Information about the executor for an action type that was created with any
	// supported integration model.
	//
	// Executor is a required field
	Executor *ActionTypeExecutor `locationName:"executor" type:"structure" required:"true"`

	// The action category, owner, provider, and version of the action type to be
	// updated.
	//
	// Id is a required field
	Id *ActionTypeIdentifier `locationName:"id" type:"structure" required:"true"`

	// Details for the artifacts, such as application files, to be worked on by
	// the action. For example, the minimum and maximum number of input artifacts
	// allowed.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ActionTypeArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// Details for the output artifacts, such as a built application, that are the
	// result of the action. For example, the minimum and maximum number of output
	// artifacts allowed.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ActionTypeArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// Details identifying the accounts with permissions to use the action type.
	Permissions *ActionTypePermissions `locationName:"permissions" type:"structure"`

	// The properties of the action type to be updated.
	Properties []*ActionTypeProperty `locationName:"properties" type:"list"`

	// The links associated with the action type to be updated.
	Urls *ActionTypeUrls `locationName:"urls" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeDeclaration"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Executor == nil {
		invalidParams.Add(request.NewErrParamRequired("Executor"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.InputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("InputArtifactDetails"))
	}
	if s.OutputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArtifactDetails"))
	}
	if s.Executor != nil {
		if err := s.Executor.Validate(); err != nil {
			invalidParams.AddNested("Executor", err.(request.ErrInvalidParams))
		}
	}
	if s.Id != nil {
		if err := s.Id.Validate(); err != nil {
			invalidParams.AddNested("Id", err.(request.ErrInvalidParams))
		}
	}
	if s.InputArtifactDetails != nil {
		if err := s.InputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("InputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputArtifactDetails != nil {
		if err := s.OutputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("OutputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Urls != nil {
		if err := s.Urls.Validate(); err != nil {
			invalidParams.AddNested("Urls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ActionTypeDeclaration) SetDescription(v string) *ActionTypeDeclaration {
	s.Description = &v
	return s
}

// SetExecutor sets the Executor field's value.
func (s *ActionTypeDeclaration) SetExecutor(v *ActionTypeExecutor) *ActionTypeDeclaration {
	s.Executor = v
	return s
}

// SetId sets the Id field's value.
func (s *ActionTypeDeclaration) SetId(v *ActionTypeIdentifier) *ActionTypeDeclaration {
	s.Id = v
	return s
}

// SetInputArtifactDetails sets the InputArtifactDetails field's value.
func (s *ActionTypeDeclaration) SetInputArtifactDetails(v *ActionTypeArtifactDetails) *ActionTypeDeclaration {
	s.InputArtifactDetails = v
	return s
}

// SetOutputArtifactDetails sets the OutputArtifactDetails field's value.
func (s *ActionTypeDeclaration) SetOutputArtifactDetails(v *ActionTypeArtifactDetails) *ActionTypeDeclaration {
	s.OutputArtifactDetails = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ActionTypeDeclaration) SetPermissions(v *ActionTypePermissions) *ActionTypeDeclaration {
	s.Permissions = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ActionTypeDeclaration) SetProperties(v []*ActionTypeProperty) *ActionTypeDeclaration {
	s.Properties = v
	return s
}

// SetUrls sets the Urls field's value.
func (s *ActionTypeDeclaration) SetUrls(v *ActionTypeUrls) *ActionTypeDeclaration {
	s.Urls = v
	return s
}

// The action engine, or executor, for an action type created for a provider,
// where the action is to be used by customers of the provider. The action engine
// is associated with the model used to create and update the action, such as
// the Lambda integration model.
type ActionTypeExecutor struct {
	_ struct{} `type:"structure"`

	// The action configuration properties for the action type. These properties
	// are specified in the action definition when the action type is created.
	//
	// Configuration is a required field
	Configuration *ExecutorConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The timeout in seconds for the job. An action execution can have multiple
	// jobs. This is the timeout for a single job, not the entire action execution.
	JobTimeout *int64 `locationName:"jobTimeout" min:"60" type:"integer"`

	// The policy statement that specifies the permissions in the CodePipeline customer
	// account that are needed to successfully run an action.
	//
	// To grant permission to another account, specify the account ID as the Principal,
	// a domain-style identifier defined by the service, for example codepipeline.amazonaws.com.
	//
	// The size of the passed JSON policy document cannot exceed 2048 characters.
	PolicyStatementsTemplate *string `locationName:"policyStatementsTemplate" min:"1" type:"string"`

	// The integration model used to create and update the action type, Lambda or
	// JobWorker.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ExecutorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeExecutor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeExecutor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeExecutor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeExecutor"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.JobTimeout != nil && *s.JobTimeout < 60 {
		invalidParams.Add(request.NewErrParamMinValue("JobTimeout", 60))
	}
	if s.PolicyStatementsTemplate != nil && len(*s.PolicyStatementsTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStatementsTemplate", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionTypeExecutor) SetConfiguration(v *ExecutorConfiguration) *ActionTypeExecutor {
	s.Configuration = v
	return s
}

// SetJobTimeout sets the JobTimeout field's value.
func (s *ActionTypeExecutor) SetJobTimeout(v int64) *ActionTypeExecutor {
	s.JobTimeout = &v
	return s
}

// SetPolicyStatementsTemplate sets the PolicyStatementsTemplate field's value.
func (s *ActionTypeExecutor) SetPolicyStatementsTemplate(v string) *ActionTypeExecutor {
	s.PolicyStatementsTemplate = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActionTypeExecutor) SetType(v string) *ActionTypeExecutor {
	s.Type = &v
	return s
}

// Represents information about an action type.
type ActionTypeId struct {
	_ struct{} `type:"structure"`

	// A category defines what kind of action can be taken in the stage, and constrains
	// the provider type for the action. Valid categories are limited to one of
	// the following values.
	//
	//    * Source
	//
	//    * Build
	//
	//    * Test
	//
	//    * Deploy
	//
	//    * Invoke
	//
	//    * Approval
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The creator of the action being called. There are three valid values for
	// the Owner field in the action category section within your pipeline structure:
	// AWS, ThirdParty, and Custom. For more information, see Valid Action Types
	// and Providers in CodePipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
	//
	// Owner is a required field
	Owner *string `locationName:"owner" type:"string" required:"true" enum:"ActionOwner"`

	// The provider of the service being called by the action. Valid providers are
	// determined by the action category. For example, an action in the Deploy category
	// type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
	// For more information, see Valid Action Types and Providers in CodePipeline
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that describes the action version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeId"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ActionTypeId) SetCategory(v string) *ActionTypeId {
	s.Category = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ActionTypeId) SetOwner(v string) *ActionTypeId {
	s.Owner = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *ActionTypeId) SetProvider(v string) *ActionTypeId {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ActionTypeId) SetVersion(v string) *ActionTypeId {
	s.Version = &v
	return s
}

// Specifies the category, owner, provider, and version of the action type.
type ActionTypeIdentifier struct {
	_ struct{} `type:"structure"`

	// Defines what kind of action can be taken in the stage, one of the following:
	//
	//    * Source
	//
	//    * Build
	//
	//    * Test
	//
	//    * Deploy
	//
	//    * Approval
	//
	//    * Invoke
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The creator of the action type being called: AWS or ThirdParty.
	//
	// Owner is a required field
	Owner *string `locationName:"owner" type:"string" required:"true"`

	// The provider of the action type being called. The provider name is supplied
	// when the action type is created.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that describes the action type version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeIdentifier"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ActionTypeIdentifier) SetCategory(v string) *ActionTypeIdentifier {
	s.Category = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ActionTypeIdentifier) SetOwner(v string) *ActionTypeIdentifier {
	s.Owner = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *ActionTypeIdentifier) SetProvider(v string) *ActionTypeIdentifier {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ActionTypeIdentifier) SetVersion(v string) *ActionTypeIdentifier {
	s.Version = &v
	return s
}

// The specified action type cannot be found.
type ActionTypeNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeNotFoundException) GoString() string {
	return s.String()
}

func newErrorActionTypeNotFoundException(v protocol.ResponseMetadata) error {
	return &ActionTypeNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ActionTypeNotFoundException) Code() string {
	return "ActionTypeNotFoundException"
}

// Message returns the exception's message.
func (s *ActionTypeNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ActionTypeNotFoundException) OrigErr() error {
	return nil
}

func (s *ActionTypeNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ActionTypeNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ActionTypeNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details identifying the users with permissions to use the action type.
type ActionTypePermissions struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Web Services account IDs with access to use the action type
	// in their pipelines.
	//
	// AllowedAccounts is a required field
	AllowedAccounts []*string `locationName:"allowedAccounts" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypePermissions"}
	if s.AllowedAccounts == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedAccounts"))
	}
	if s.AllowedAccounts != nil && len(s.AllowedAccounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedAccounts", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedAccounts sets the AllowedAccounts field's value.
func (s *ActionTypePermissions) SetAllowedAccounts(v []*string) *ActionTypePermissions {
	s.AllowedAccounts = v
	return s
}

// Represents information about each property specified in the action configuration,
// such as the description and key name that display for the customer using
// the action type.
type ActionTypeProperty struct {
	_ struct{} `type:"structure"`

	// The description of the property that is displayed to users.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the configuration property is a key.
	//
	// Key is a required field
	Key *bool `locationName:"key" type:"boolean" required:"true"`

	// The property name that is displayed to users.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Whether to omit the field value entered by the customer in the log. If true,
	// the value is not saved in CloudTrail logs for the action execution.
	//
	// NoEcho is a required field
	NoEcho *bool `locationName:"noEcho" type:"boolean" required:"true"`

	// Whether the configuration property is an optional value.
	//
	// Optional is a required field
	Optional *bool `locationName:"optional" type:"boolean" required:"true"`

	// Indicates that the property is used with polling. An action type can have
	// up to one queryable property. If it has one, that property must be both required
	// and not secret.
	Queryable *bool `locationName:"queryable" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeProperty"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NoEcho == nil {
		invalidParams.Add(request.NewErrParamRequired("NoEcho"))
	}
	if s.Optional == nil {
		invalidParams.Add(request.NewErrParamRequired("Optional"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ActionTypeProperty) SetDescription(v string) *ActionTypeProperty {
	s.Description = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ActionTypeProperty) SetKey(v bool) *ActionTypeProperty {
	s.Key = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionTypeProperty) SetName(v string) *ActionTypeProperty {
	s.Name = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *ActionTypeProperty) SetNoEcho(v bool) *ActionTypeProperty {
	s.NoEcho = &v
	return s
}

// SetOptional sets the Optional field's value.
func (s *ActionTypeProperty) SetOptional(v bool) *ActionTypeProperty {
	s.Optional = &v
	return s
}

// SetQueryable sets the Queryable field's value.
func (s *ActionTypeProperty) SetQueryable(v bool) *ActionTypeProperty {
	s.Queryable = &v
	return s
}

// Returns information about the settings for an action type.
type ActionTypeSettings struct {
	_ struct{} `type:"structure"`

	// The URL returned to the CodePipeline console that provides a deep link to
	// the resources of the external system, such as the configuration page for
	// a CodeDeploy deployment group. This link is provided as part of the action
	// display in the pipeline.
	EntityUrlTemplate *string `locationName:"entityUrlTemplate" min:"1" type:"string"`

	// The URL returned to the CodePipeline console that contains a link to the
	// top-level landing page for the external system, such as the console page
	// for CodeDeploy. This link is shown on the pipeline view page in the CodePipeline
	// console and provides a link to the execution entity of the external action.
	ExecutionUrlTemplate *string `locationName:"executionUrlTemplate" min:"1" type:"string"`

	// The URL returned to the CodePipeline console that contains a link to the
	// page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string `locationName:"revisionUrlTemplate" min:"1" type:"string"`

	// The URL of a sign-up page where users can sign up for an external service
	// and perform initial configuration of the action provided by that service.
	ThirdPartyConfigurationUrl *string `locationName:"thirdPartyConfigurationUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeSettings"}
	if s.EntityUrlTemplate != nil && len(*s.EntityUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityUrlTemplate", 1))
	}
	if s.ExecutionUrlTemplate != nil && len(*s.ExecutionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionUrlTemplate", 1))
	}
	if s.RevisionUrlTemplate != nil && len(*s.RevisionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionUrlTemplate", 1))
	}
	if s.ThirdPartyConfigurationUrl != nil && len(*s.ThirdPartyConfigurationUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThirdPartyConfigurationUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityUrlTemplate sets the EntityUrlTemplate field's value.
func (s *ActionTypeSettings) SetEntityUrlTemplate(v string) *ActionTypeSettings {
	s.EntityUrlTemplate = &v
	return s
}

// SetExecutionUrlTemplate sets the ExecutionUrlTemplate field's value.
func (s *ActionTypeSettings) SetExecutionUrlTemplate(v string) *ActionTypeSettings {
	s.ExecutionUrlTemplate = &v
	return s
}

// SetRevisionUrlTemplate sets the RevisionUrlTemplate field's value.
func (s *ActionTypeSettings) SetRevisionUrlTemplate(v string) *ActionTypeSettings {
	s.RevisionUrlTemplate = &v
	return s
}

// SetThirdPartyConfigurationUrl sets the ThirdPartyConfigurationUrl field's value.
func (s *ActionTypeSettings) SetThirdPartyConfigurationUrl(v string) *ActionTypeSettings {
	s.ThirdPartyConfigurationUrl = &v
	return s
}

// Returns information about URLs for web pages that display to customers as
// links on the pipeline view, such as an external configuration page for the
// action type.
type ActionTypeUrls struct {
	_ struct{} `type:"structure"`

	// The URL returned to the CodePipeline console that contains a link to the
	// page where customers can configure the external action.
	ConfigurationUrl *string `locationName:"configurationUrl" min:"1" type:"string"`

	// The URL returned to the CodePipeline console that provides a deep link to
	// the resources of the external system, such as a status page. This link is
	// provided as part of the action display in the pipeline.
	EntityUrlTemplate *string `locationName:"entityUrlTemplate" min:"1" type:"string"`

	// The link to an execution page for the action type in progress. For example,
	// for a CodeDeploy action, this link is shown on the pipeline view page in
	// the CodePipeline console, and it links to a CodeDeploy status page.
	ExecutionUrlTemplate *string `locationName:"executionUrlTemplate" min:"1" type:"string"`

	// The URL returned to the CodePipeline console that contains a link to the
	// page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string `locationName:"revisionUrlTemplate" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeUrls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTypeUrls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeUrls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeUrls"}
	if s.ConfigurationUrl != nil && len(*s.ConfigurationUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationUrl", 1))
	}
	if s.EntityUrlTemplate != nil && len(*s.EntityUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityUrlTemplate", 1))
	}
	if s.ExecutionUrlTemplate != nil && len(*s.ExecutionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionUrlTemplate", 1))
	}
	if s.RevisionUrlTemplate != nil && len(*s.RevisionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionUrlTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationUrl sets the ConfigurationUrl field's value.
func (s *ActionTypeUrls) SetConfigurationUrl(v string) *ActionTypeUrls {
	s.ConfigurationUrl = &v
	return s
}

// SetEntityUrlTemplate sets the EntityUrlTemplate field's value.
func (s *ActionTypeUrls) SetEntityUrlTemplate(v string) *ActionTypeUrls {
	s.EntityUrlTemplate = &v
	return s
}

// SetExecutionUrlTemplate sets the ExecutionUrlTemplate field's value.
func (s *ActionTypeUrls) SetExecutionUrlTemplate(v string) *ActionTypeUrls {
	s.ExecutionUrlTemplate = &v
	return s
}

// SetRevisionUrlTemplate sets the RevisionUrlTemplate field's value.
func (s *ActionTypeUrls) SetRevisionUrlTemplate(v string) *ActionTypeUrls {
	s.RevisionUrlTemplate = &v
	return s
}

// The approval action has already been approved or rejected.
type ApprovalAlreadyCompletedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApprovalAlreadyCompletedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApprovalAlreadyCompletedException) GoString() string {
	return s.String()
}

func newErrorApprovalAlreadyCompletedException(v protocol.ResponseMetadata) error {
	return &ApprovalAlreadyCompletedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ApprovalAlreadyCompletedException) Code() string {
	return "ApprovalAlreadyCompletedException"
}

// Message returns the exception's message.
func (s *ApprovalAlreadyCompletedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ApprovalAlreadyCompletedException) OrigErr() error {
	return nil
}

func (s *ApprovalAlreadyCompletedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ApprovalAlreadyCompletedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ApprovalAlreadyCompletedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about the result of an approval request.
type ApprovalResult struct {
	_ struct{} `type:"structure"`

	// The response submitted by a reviewer assigned to an approval action request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApprovalStatus"`

	// The summary of the current status of the approval request.
	//
	// Summary is a required field
	Summary *string `locationName:"summary" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApprovalResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApprovalResult) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApprovalResult) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApprovalResult"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Summary == nil {
		invalidParams.Add(request.NewErrParamRequired("Summary"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *ApprovalResult) SetStatus(v string) *ApprovalResult {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ApprovalResult) SetSummary(v string) *ApprovalResult {
	s.Summary = &v
	return s
}

// Artifacts are the files that are worked on by actions in the pipeline. See
// the action configuration for each action for details about artifact parameters.
// For example, the S3 source action artifact is a file name (or file path),
// and the files are generally provided as a ZIP file. Example artifact name:
// SampleApp_Windows.zip
type Artifact struct {
	_ struct{} `type:"structure"`

	// The location of an artifact.
	Location *ArtifactLocation `locationName:"location" type:"structure"`

	// The artifact's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The artifact's revision ID. Depending on the type of object, this could be
	// a commit ID (GitHub) or a revision ID (Amazon S3).
	Revision *string `locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Artifact) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *Artifact) SetLocation(v *ArtifactLocation) *Artifact {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Artifact) SetName(v string) *Artifact {
	s.Name = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *Artifact) SetRevision(v string) *Artifact {
	s.Revision = &v
	return s
}

// Artifact details for the action execution, such as the artifact location.
type ArtifactDetail struct {
	_ struct{} `type:"structure"`

	// The artifact object name for the action execution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon S3 artifact location for the action execution.
	S3location *S3Location `locationName:"s3location" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactDetail) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ArtifactDetail) SetName(v string) *ArtifactDetail {
	s.Name = &v
	return s
}

// SetS3location sets the S3location field's value.
func (s *ArtifactDetail) SetS3location(v *S3Location) *ArtifactDetail {
	s.S3location = v
	return s
}

// Returns information about the details of an artifact.
type ArtifactDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of artifacts allowed for the action type.
	//
	// MaximumCount is a required field
	MaximumCount *int64 `locationName:"maximumCount" type:"integer" required:"true"`

	// The minimum number of artifacts allowed for the action type.
	//
	// MinimumCount is a required field
	MinimumCount *int64 `locationName:"minimumCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactDetails"}
	if s.MaximumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumCount"))
	}
	if s.MinimumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumCount sets the MaximumCount field's value.
func (s *ArtifactDetails) SetMaximumCount(v int64) *ArtifactDetails {
	s.MaximumCount = &v
	return s
}

// SetMinimumCount sets the MinimumCount field's value.
func (s *ArtifactDetails) SetMinimumCount(v int64) *ArtifactDetails {
	s.MinimumCount = &v
	return s
}

// Represents information about the location of an artifact.
type ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that contains the artifact.
	S3Location *S3ArtifactLocation `locationName:"s3Location" type:"structure"`

	// The type of artifact in the location.
	Type *string `locationName:"type" type:"string" enum:"ArtifactLocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactLocation) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *ArtifactLocation) SetS3Location(v *S3ArtifactLocation) *ArtifactLocation {
	s.S3Location = v
	return s
}

// SetType sets the Type field's value.
func (s *ArtifactLocation) SetType(v string) *ArtifactLocation {
	s.Type = &v
	return s
}

// Represents revision details of an artifact.
type ArtifactRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The name of an artifact. This name might be system-generated, such as "MyApp",
	// or defined by the user when an action is created.
	Name *string `locationName:"name" min:"1" type:"string"`

	// An additional identifier for a revision, such as a commit date or, for artifacts
	// stored in Amazon S3 buckets, the ETag value.
	RevisionChangeIdentifier *string `locationName:"revisionChangeIdentifier" min:"1" type:"string"`

	// The revision ID of the artifact.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Summary information about the most recent revision of the artifact. For GitHub
	// and CodeCommit repositories, the commit message. For Amazon S3 buckets or
	// actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`

	// The commit ID for the artifact revision. For artifacts stored in GitHub or
	// CodeCommit repositories, the commit ID is linked to a commit details page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactRevision) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *ArtifactRevision) SetCreated(v time.Time) *ArtifactRevision {
	s.Created = &v
	return s
}

// SetName sets the Name field's value.
func (s *ArtifactRevision) SetName(v string) *ArtifactRevision {
	s.Name = &v
	return s
}

// SetRevisionChangeIdentifier sets the RevisionChangeIdentifier field's value.
func (s *ArtifactRevision) SetRevisionChangeIdentifier(v string) *ArtifactRevision {
	s.RevisionChangeIdentifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ArtifactRevision) SetRevisionId(v string) *ArtifactRevision {
	s.RevisionId = &v
	return s
}

// SetRevisionSummary sets the RevisionSummary field's value.
func (s *ArtifactRevision) SetRevisionSummary(v string) *ArtifactRevision {
	s.RevisionSummary = &v
	return s
}

// SetRevisionUrl sets the RevisionUrl field's value.
func (s *ArtifactRevision) SetRevisionUrl(v string) *ArtifactRevision {
	s.RevisionUrl = &v
	return s
}

// The S3 bucket where artifacts for the pipeline are stored.
//
// You must include either artifactStore or artifactStores in your pipeline,
// but you cannot use both. If you create a cross-region action in your pipeline,
// you must use artifactStores.
type ArtifactStore struct {
	_ struct{} `type:"structure"`

	// The encryption key used to encrypt the data in the artifact store, such as
	// an Amazon Web Services Key Management Service key. If this is undefined,
	// the default key for Amazon S3 is used.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The S3 bucket used for storing the artifacts for a pipeline. You can specify
	// the name of an S3 bucket but not a folder in the bucket. A folder to contain
	// the pipeline artifacts is created for you based on the name of the pipeline.
	// You can use any S3 bucket in the same Amazon Web Services Region as the pipeline
	// to store your pipeline artifacts.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"3" type:"string" required:"true"`

	// The type of the artifact store, such as S3.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactStoreType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactStore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactStore) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactStore) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactStore"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ArtifactStore) SetEncryptionKey(v *EncryptionKey) *ArtifactStore {
	s.EncryptionKey = v
	return s
}

// SetLocation sets the Location field's value.
func (s *ArtifactStore) SetLocation(v string) *ArtifactStore {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *ArtifactStore) SetType(v string) *ArtifactStore {
	s.Type = &v
	return s
}

// Reserved for future use.
type BlockerDeclaration struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Reserved for future use.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BlockerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockerDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockerDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockerDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockerDeclaration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BlockerDeclaration) SetName(v string) *BlockerDeclaration {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *BlockerDeclaration) SetType(v string) *BlockerDeclaration {
	s.Type = &v
	return s
}

// Unable to modify the tag due to a simultaneous update request.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The pipeline has reached the limit for concurrent pipeline executions.
type ConcurrentPipelineExecutionsLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentPipelineExecutionsLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentPipelineExecutionsLimitExceededException) GoString() string {
	return s.String()
}

func newErrorConcurrentPipelineExecutionsLimitExceededException(v protocol.ResponseMetadata) error {
	return &ConcurrentPipelineExecutionsLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentPipelineExecutionsLimitExceededException) Code() string {
	return "ConcurrentPipelineExecutionsLimitExceededException"
}

// Message returns the exception's message.
func (s *ConcurrentPipelineExecutionsLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentPipelineExecutionsLimitExceededException) OrigErr() error {
	return nil
}

func (s *ConcurrentPipelineExecutionsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentPipelineExecutionsLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentPipelineExecutionsLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request cannot be handled because the pipeline is busy handling ongoing
// activities. Try again later.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a CreateCustomActionType operation.
type CreateCustomActionTypeInput struct {
	_ struct{} `type:"structure"`

	// The category of the custom action, such as a build action or a test action.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The configuration properties for the custom action.
	//
	// You can refer to a name in the configuration properties of the custom action
	// within the URL templates by following the format of {Config:name}, as long
	// as the configuration property is both required and not secret. For more information,
	// see Create a Custom Action for a Pipeline (https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html).
	ConfigurationProperties []*ActionConfigurationProperty `locationName:"configurationProperties" type:"list"`

	// The details of the input artifact for the action, such as its commit ID.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The provider of the service used in the custom action, such as CodeDeploy.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// URLs that provide users information about this custom action.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`

	// The tags for the custom action.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The version identifier of the custom action.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomActionTypeInput"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.InputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("InputArtifactDetails"))
	}
	if s.OutputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArtifactDetails"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.ConfigurationProperties != nil {
		for i, v := range s.ConfigurationProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConfigurationProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InputArtifactDetails != nil {
		if err := s.InputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("InputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputArtifactDetails != nil {
		if err := s.OutputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("OutputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *CreateCustomActionTypeInput) SetCategory(v string) *CreateCustomActionTypeInput {
	s.Category = &v
	return s
}

// SetConfigurationProperties sets the ConfigurationProperties field's value.
func (s *CreateCustomActionTypeInput) SetConfigurationProperties(v []*ActionConfigurationProperty) *CreateCustomActionTypeInput {
	s.ConfigurationProperties = v
	return s
}

// SetInputArtifactDetails sets the InputArtifactDetails field's value.
func (s *CreateCustomActionTypeInput) SetInputArtifactDetails(v *ArtifactDetails) *CreateCustomActionTypeInput {
	s.InputArtifactDetails = v
	return s
}

// SetOutputArtifactDetails sets the OutputArtifactDetails field's value.
func (s *CreateCustomActionTypeInput) SetOutputArtifactDetails(v *ArtifactDetails) *CreateCustomActionTypeInput {
	s.OutputArtifactDetails = v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateCustomActionTypeInput) SetProvider(v string) *CreateCustomActionTypeInput {
	s.Provider = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateCustomActionTypeInput) SetSettings(v *ActionTypeSettings) *CreateCustomActionTypeInput {
	s.Settings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomActionTypeInput) SetTags(v []*Tag) *CreateCustomActionTypeInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateCustomActionTypeInput) SetVersion(v string) *CreateCustomActionTypeInput {
	s.Version = &v
	return s
}

// Represents the output of a CreateCustomActionType operation.
type CreateCustomActionTypeOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the details of an action type.
	//
	// ActionType is a required field
	ActionType *ActionType `locationName:"actionType" type:"structure" required:"true"`

	// Specifies the tags applied to the custom action.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomActionTypeOutput) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *CreateCustomActionTypeOutput) SetActionType(v *ActionType) *CreateCustomActionTypeOutput {
	s.ActionType = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomActionTypeOutput) SetTags(v []*Tag) *CreateCustomActionTypeOutput {
	s.Tags = v
	return s
}

// Represents the input of a CreatePipeline action.
type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	//
	// Pipeline is a required field
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`

	// The tags for the pipeline.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.Pipeline == nil {
		invalidParams.Add(request.NewErrParamRequired("Pipeline"))
	}
	if s.Pipeline != nil {
		if err := s.Pipeline.Validate(); err != nil {
			invalidParams.AddNested("Pipeline", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineInput) SetPipeline(v *PipelineDeclaration) *CreatePipelineInput {
	s.Pipeline = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePipelineInput) SetTags(v []*Tag) *CreatePipelineInput {
	s.Tags = v
	return s
}

// Represents the output of a CreatePipeline action.
type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`

	// Specifies the tags applied to the pipeline.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineOutput) SetPipeline(v *PipelineDeclaration) *CreatePipelineOutput {
	s.Pipeline = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePipelineOutput) SetTags(v []*Tag) *CreatePipelineOutput {
	s.Tags = v
	return s
}

// Represents information about a current revision.
type CurrentRevision struct {
	_ struct{} `type:"structure"`

	// The change identifier for the current revision.
	//
	// ChangeIdentifier is a required field
	ChangeIdentifier *string `locationName:"changeIdentifier" min:"1" type:"string" required:"true"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The revision ID of the current version of an artifact.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The summary of the most recent revision of the artifact.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrentRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrentRevision) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CurrentRevision) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CurrentRevision"}
	if s.ChangeIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeIdentifier"))
	}
	if s.ChangeIdentifier != nil && len(*s.ChangeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeIdentifier", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Revision", 1))
	}
	if s.RevisionSummary != nil && len(*s.RevisionSummary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionSummary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeIdentifier sets the ChangeIdentifier field's value.
func (s *CurrentRevision) SetChangeIdentifier(v string) *CurrentRevision {
	s.ChangeIdentifier = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *CurrentRevision) SetCreated(v time.Time) *CurrentRevision {
	s.Created = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CurrentRevision) SetRevision(v string) *CurrentRevision {
	s.Revision = &v
	return s
}

// SetRevisionSummary sets the RevisionSummary field's value.
func (s *CurrentRevision) SetRevisionSummary(v string) *CurrentRevision {
	s.RevisionSummary = &v
	return s
}

// Represents the input of a DeleteCustomActionType operation. The custom action
// will be marked as deleted.
type DeleteCustomActionTypeInput struct {
	_ struct{} `type:"structure"`

	// The category of the custom action that you want to delete, such as source
	// or deploy.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The provider of the service used in the custom action, such as CodeDeploy.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// The version of the custom action to delete.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomActionTypeInput"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *DeleteCustomActionTypeInput) SetCategory(v string) *DeleteCustomActionTypeInput {
	s.Category = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *DeleteCustomActionTypeInput) SetProvider(v string) *DeleteCustomActionTypeInput {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteCustomActionTypeInput) SetVersion(v string) *DeleteCustomActionTypeInput {
	s.Version = &v
	return s
}

type DeleteCustomActionTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomActionTypeOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeletePipeline action.
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to be deleted.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletePipelineInput) SetName(v string) *DeletePipelineInput {
	s.Name = &v
	return s
}

type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

type DeleteWebhookInput struct {
	_ struct{} `type:"structure"`

	// The name of the webhook you want to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWebhookInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteWebhookInput) SetName(v string) *DeleteWebhookInput {
	s.Name = &v
	return s
}

type DeleteWebhookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebhookOutput) GoString() string {
	return s.String()
}

type DeregisterWebhookWithThirdPartyInput struct {
	_ struct{} `type:"structure"`

	// The name of the webhook you want to deregister.
	WebhookName *string `locationName:"webhookName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWebhookWithThirdPartyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWebhookWithThirdPartyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterWebhookWithThirdPartyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterWebhookWithThirdPartyInput"}
	if s.WebhookName != nil && len(*s.WebhookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWebhookName sets the WebhookName field's value.
func (s *DeregisterWebhookWithThirdPartyInput) SetWebhookName(v string) *DeregisterWebhookWithThirdPartyInput {
	s.WebhookName = &v
	return s
}

type DeregisterWebhookWithThirdPartyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWebhookWithThirdPartyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWebhookWithThirdPartyOutput) GoString() string {
	return s.String()
}

// Represents the input of a DisableStageTransition action.
type DisableStageTransitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline in which you want to disable the flow of artifacts
	// from one stage to another.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The reason given to the user that a stage is disabled, such as waiting for
	// manual approval or manual tests. This message is displayed in the pipeline
	// console UI.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to disable the inbound or outbound transition
	// of artifacts.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts are prevented from transitioning into the stage
	// and being processed by the actions in that stage (inbound), or prevented
	// from transitioning from the stage after they have been processed by the actions
	// in that stage (outbound).
	//
	// TransitionType is a required field
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableStageTransitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableStageTransitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableStageTransitionInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.TransitionType == nil {
		invalidParams.Add(request.NewErrParamRequired("TransitionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *DisableStageTransitionInput) SetPipelineName(v string) *DisableStageTransitionInput {
	s.PipelineName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisableStageTransitionInput) SetReason(v string) *DisableStageTransitionInput {
	s.Reason = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DisableStageTransitionInput) SetStageName(v string) *DisableStageTransitionInput {
	s.StageName = &v
	return s
}

// SetTransitionType sets the TransitionType field's value.
func (s *DisableStageTransitionInput) SetTransitionType(v string) *DisableStageTransitionInput {
	s.TransitionType = &v
	return s
}

type DisableStageTransitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableStageTransitionOutput) GoString() string {
	return s.String()
}

// The pipeline execution is already in a Stopping state. If you already chose
// to stop and wait, you cannot make that request again. You can choose to stop
// and abandon now, but be aware that this option can lead to failed tasks or
// out of sequence tasks. If you already chose to stop and abandon, you cannot
// make that request again.
type DuplicatedStopRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicatedStopRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicatedStopRequestException) GoString() string {
	return s.String()
}

func newErrorDuplicatedStopRequestException(v protocol.ResponseMetadata) error {
	return &DuplicatedStopRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicatedStopRequestException) Code() string {
	return "DuplicatedStopRequestException"
}

// Message returns the exception's message.
func (s *DuplicatedStopRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicatedStopRequestException) OrigErr() error {
	return nil
}

func (s *DuplicatedStopRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicatedStopRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicatedStopRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of an EnableStageTransition action.
type EnableStageTransitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline in which you want to enable the flow of artifacts
	// from one stage to another.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to enable the transition of artifacts,
	// either into the stage (inbound) or from that stage to the next stage (outbound).
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts are allowed to enter the stage and be processed
	// by the actions in that stage (inbound) or whether already processed artifacts
	// are allowed to transition to the next stage (outbound).
	//
	// TransitionType is a required field
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableStageTransitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableStageTransitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableStageTransitionInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.TransitionType == nil {
		invalidParams.Add(request.NewErrParamRequired("TransitionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *EnableStageTransitionInput) SetPipelineName(v string) *EnableStageTransitionInput {
	s.PipelineName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *EnableStageTransitionInput) SetStageName(v string) *EnableStageTransitionInput {
	s.StageName = &v
	return s
}

// SetTransitionType sets the TransitionType field's value.
func (s *EnableStageTransitionInput) SetTransitionType(v string) *EnableStageTransitionInput {
	s.TransitionType = &v
	return s
}

type EnableStageTransitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableStageTransitionOutput) GoString() string {
	return s.String()
}

// Represents information about the key used to encrypt data in the artifact
// store, such as an Amazon Web Services Key Management Service (Key Management
// Service) key.
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The ID used to identify the key. For an Amazon Web Services KMS key, you
	// can use the key ID, the key ARN, or the alias ARN.
	//
	// Aliases are recognized only in the account that created the KMS key. For
	// cross-account actions, you can only use the key ID or key ARN to identify
	// the key. Cross-account actions involve using the role from the other account
	// (AccountB), so specifying the key ID will use the key from the other account
	// (AccountB).
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The type of encryption key, such as an Amazon Web Services KMS key. When
	// creating or updating a pipeline, the value must be set to 'KMS'.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EncryptionKeyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionKey"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *EncryptionKey) SetId(v string) *EncryptionKey {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionKey) SetType(v string) *EncryptionKey {
	s.Type = &v
	return s
}

// Represents information about an error in CodePipeline.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The system ID or number code of the error.
	Code *string `locationName:"code" type:"string"`

	// The text of the error message.
	Message *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorDetails) SetCode(v string) *ErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorDetails) SetMessage(v string) *ErrorDetails {
	s.Message = &v
	return s
}

// The details of the actions taken and results produced on an artifact as it
// passes through stages in the pipeline.
type ExecutionDetails struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID of this action used to identify this job worker
	// in any external systems, such as CodeDeploy.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The percentage of work completed on the action, represented on a scale of
	// 0 to 100 percent.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The summary of the current status of the actions.
	Summary *string `locationName:"summary" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalExecutionId", 1))
	}
	if s.Summary != nil && len(*s.Summary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Summary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *ExecutionDetails) SetExternalExecutionId(v string) *ExecutionDetails {
	s.ExternalExecutionId = &v
	return s
}

// SetPercentComplete sets the PercentComplete field's value.
func (s *ExecutionDetails) SetPercentComplete(v int64) *ExecutionDetails {
	s.PercentComplete = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ExecutionDetails) SetSummary(v string) *ExecutionDetails {
	s.Summary = &v
	return s
}

// The interaction or event that started a pipeline execution.
type ExecutionTrigger struct {
	_ struct{} `type:"structure"`

	// Detail related to the event that started a pipeline execution, such as the
	// webhook ARN of the webhook that triggered the pipeline execution or the user
	// ARN for a user-initiated start-pipeline-execution CLI command.
	TriggerDetail *string `locationName:"triggerDetail" type:"string"`

	// The type of change-detection method, command, or user interaction that started
	// a pipeline execution.
	TriggerType *string `locationName:"triggerType" type:"string" enum:"TriggerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionTrigger) GoString() string {
	return s.String()
}

// SetTriggerDetail sets the TriggerDetail field's value.
func (s *ExecutionTrigger) SetTriggerDetail(v string) *ExecutionTrigger {
	s.TriggerDetail = &v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *ExecutionTrigger) SetTriggerType(v string) *ExecutionTrigger {
	s.TriggerType = &v
	return s
}

// The action engine, or executor, related to the supported integration model
// used to create and update the action type. The available executor types are
// Lambda and JobWorker.
type ExecutorConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about the JobWorker executor of the action type.
	JobWorkerExecutorConfiguration *JobWorkerExecutorConfiguration `locationName:"jobWorkerExecutorConfiguration" type:"structure"`

	// Details about the Lambda executor of the action type.
	LambdaExecutorConfiguration *LambdaExecutorConfiguration `locationName:"lambdaExecutorConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutorConfiguration"}
	if s.JobWorkerExecutorConfiguration != nil {
		if err := s.JobWorkerExecutorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JobWorkerExecutorConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaExecutorConfiguration != nil {
		if err := s.LambdaExecutorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LambdaExecutorConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobWorkerExecutorConfiguration sets the JobWorkerExecutorConfiguration field's value.
func (s *ExecutorConfiguration) SetJobWorkerExecutorConfiguration(v *JobWorkerExecutorConfiguration) *ExecutorConfiguration {
	s.JobWorkerExecutorConfiguration = v
	return s
}

// SetLambdaExecutorConfiguration sets the LambdaExecutorConfiguration field's value.
func (s *ExecutorConfiguration) SetLambdaExecutorConfiguration(v *LambdaExecutorConfiguration) *ExecutorConfiguration {
	s.LambdaExecutorConfiguration = v
	return s
}

// The configuration that specifies the result, such as rollback, to occur upon
// stage failure.
type FailureConditions struct {
	_ struct{} `type:"structure"`

	// The specified result for when the failure conditions are met, such as rolling
	// back the stage.
	Result *string `locationName:"result" type:"string" enum:"Result"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureConditions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureConditions) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *FailureConditions) SetResult(v string) *FailureConditions {
	s.Result = &v
	return s
}

// Represents information about failure details.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The external ID of the run of the action that failed.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The message about the failure.
	//
	// Message is a required field
	Message *string `locationName:"message" min:"1" type:"string" required:"true"`

	// The type of the failure.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FailureType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailureDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailureDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalExecutionId", 1))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *FailureDetails) SetExternalExecutionId(v string) *FailureDetails {
	s.ExternalExecutionId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FailureDetails) SetMessage(v string) *FailureDetails {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *FailureDetails) SetType(v string) *FailureDetails {
	s.Type = &v
	return s
}

type GetActionTypeInput struct {
	_ struct{} `type:"structure"`

	// Defines what kind of action can be taken in the stage. The following are
	// the valid values:
	//
	//    * Source
	//
	//    * Build
	//
	//    * Test
	//
	//    * Deploy
	//
	//    * Approval
	//
	//    * Invoke
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The creator of an action type that was created with any supported integration
	// model. There are two valid values: AWS and ThirdParty.
	//
	// Owner is a required field
	Owner *string `locationName:"owner" type:"string" required:"true"`

	// The provider of the action type being called. The provider name is specified
	// when the action type is created.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that describes the action type version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetActionTypeInput"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *GetActionTypeInput) SetCategory(v string) *GetActionTypeInput {
	s.Category = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetActionTypeInput) SetOwner(v string) *GetActionTypeInput {
	s.Owner = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *GetActionTypeInput) SetProvider(v string) *GetActionTypeInput {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetActionTypeInput) SetVersion(v string) *GetActionTypeInput {
	s.Version = &v
	return s
}

type GetActionTypeOutput struct {
	_ struct{} `type:"structure"`

	// The action type information for the requested action type, such as the action
	// type ID.
	ActionType *ActionTypeDeclaration `locationName:"actionType" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionTypeOutput) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *GetActionTypeOutput) SetActionType(v *ActionTypeDeclaration) *GetActionTypeOutput {
	s.ActionType = v
	return s
}

// Represents the input of a GetJobDetails action.
type GetJobDetailsInput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobDetailsInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobDetailsInput) SetJobId(v string) *GetJobDetailsInput {
	s.JobId = &v
	return s
}

// Represents the output of a GetJobDetails action.
type GetJobDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the job.
	//
	// If AWSSessionCredentials is used, a long-running job can call GetJobDetails
	// again to obtain new credentials.
	JobDetails *JobDetails `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobDetailsOutput) GoString() string {
	return s.String()
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetJobDetailsOutput) SetJobDetails(v *JobDetails) *GetJobDetailsOutput {
	s.JobDetails = v
	return s
}

// Represents the input of a GetPipelineExecution action.
type GetPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution about which you want to get execution details.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline about which you want to get execution details.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineExecutionInput"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *GetPipelineExecutionInput) SetPipelineExecutionId(v string) *GetPipelineExecutionInput {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineExecutionInput) SetPipelineName(v string) *GetPipelineExecutionInput {
	s.PipelineName = &v
	return s
}

// Represents the output of a GetPipelineExecution action.
type GetPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Represents information about the execution of a pipeline.
	PipelineExecution *PipelineExecution `locationName:"pipelineExecution" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecution sets the PipelineExecution field's value.
func (s *GetPipelineExecutionOutput) SetPipelineExecution(v *PipelineExecution) *GetPipelineExecutionOutput {
	s.PipelineExecution = v
	return s
}

// Represents the input of a GetPipeline action.
type GetPipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline for which you want to get information. Pipeline
	// names must be unique in an Amazon Web Services account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version number of the pipeline. If you do not specify a version, defaults
	// to the current version.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPipelineInput) SetName(v string) *GetPipelineInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetPipelineInput) SetVersion(v int64) *GetPipelineInput {
	s.Version = &v
	return s
}

// Represents the output of a GetPipeline action.
type GetPipelineOutput struct {
	_ struct{} `type:"structure"`

	// Represents the pipeline metadata information returned as part of the output
	// of a GetPipeline action.
	Metadata *PipelineMetadata `locationName:"metadata" type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetPipelineOutput) SetMetadata(v *PipelineMetadata) *GetPipelineOutput {
	s.Metadata = v
	return s
}

// SetPipeline sets the Pipeline field's value.
func (s *GetPipelineOutput) SetPipeline(v *PipelineDeclaration) *GetPipelineOutput {
	s.Pipeline = v
	return s
}

// Represents the input of a GetPipelineState action.
type GetPipelineStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline about which you want to get information.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineStateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPipelineStateInput) SetName(v string) *GetPipelineStateInput {
	s.Name = &v
	return s
}

// Represents the output of a GetPipelineState action.
type GetPipelineStateOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The name of the pipeline for which you want to get the state.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline.
	//
	// A newly created pipeline is always assigned a version number of 1.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// A list of the pipeline stage output information, including stage name, state,
	// most recent run details, whether the stage is disabled, and other data.
	StageStates []*StageState `locationName:"stageStates" type:"list"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPipelineStateOutput) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *GetPipelineStateOutput) SetCreated(v time.Time) *GetPipelineStateOutput {
	s.Created = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineStateOutput) SetPipelineName(v string) *GetPipelineStateOutput {
	s.PipelineName = &v
	return s
}

// SetPipelineVersion sets the PipelineVersion field's value.
func (s *GetPipelineStateOutput) SetPipelineVersion(v int64) *GetPipelineStateOutput {
	s.PipelineVersion = &v
	return s
}

// SetStageStates sets the StageStates field's value.
func (s *GetPipelineStateOutput) SetStageStates(v []*StageState) *GetPipelineStateOutput {
	s.StageStates = v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *GetPipelineStateOutput) SetUpdated(v time.Time) *GetPipelineStateOutput {
	s.Updated = &v
	return s
}

// Represents the input of a GetThirdPartyJobDetails action.
type GetThirdPartyJobDetailsInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// The unique system-generated ID used for identifying the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyJobDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThirdPartyJobDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThirdPartyJobDetailsInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *GetThirdPartyJobDetailsInput) SetClientToken(v string) *GetThirdPartyJobDetailsInput {
	s.ClientToken = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetThirdPartyJobDetailsInput) SetJobId(v string) *GetThirdPartyJobDetailsInput {
	s.JobId = &v
	return s
}

// Represents the output of a GetThirdPartyJobDetails action.
type GetThirdPartyJobDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the job, including any protected values defined for the job.
	JobDetails *ThirdPartyJobDetails `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThirdPartyJobDetailsOutput) GoString() string {
	return s.String()
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetThirdPartyJobDetailsOutput) SetJobDetails(v *ThirdPartyJobDetails) *GetThirdPartyJobDetailsOutput {
	s.JobDetails = v
	return s
}

// The Git repository branches specified as filter criteria to start the pipeline.
type GitBranchFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The list of patterns of Git branches that, when a commit is pushed, are to
	// be excluded from starting the pipeline.
	Excludes []*string `locationName:"excludes" min:"1" type:"list"`

	// The list of patterns of Git branches that, when a commit is pushed, are to
	// be included as criteria that starts the pipeline.
	Includes []*string `locationName:"includes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitBranchFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitBranchFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitBranchFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitBranchFilterCriteria"}
	if s.Excludes != nil && len(s.Excludes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Excludes", 1))
	}
	if s.Includes != nil && len(s.Includes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Includes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludes sets the Excludes field's value.
func (s *GitBranchFilterCriteria) SetExcludes(v []*string) *GitBranchFilterCriteria {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *GitBranchFilterCriteria) SetIncludes(v []*string) *GitBranchFilterCriteria {
	s.Includes = v
	return s
}

// A type of trigger configuration for Git-based source actions.
//
// You can specify the Git configuration trigger type for all third-party Git-based
// source actions that are supported by the CodeStarSourceConnection action
// type.
type GitConfiguration struct {
	_ struct{} `type:"structure"`

	// The field where the repository event that will start the pipeline is specified
	// as pull requests.
	PullRequest []*GitPullRequestFilter `locationName:"pullRequest" min:"1" type:"list"`

	// The field where the repository event that will start the pipeline, such as
	// pushing Git tags, is specified with details.
	Push []*GitPushFilter `locationName:"push" min:"1" type:"list"`

	// The name of the pipeline source action where the trigger configuration, such
	// as Git tags, is specified. The trigger configuration will start the pipeline
	// upon the specified change only.
	//
	// You can only specify one trigger configuration per source action.
	//
	// SourceActionName is a required field
	SourceActionName *string `locationName:"sourceActionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitConfiguration"}
	if s.PullRequest != nil && len(s.PullRequest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PullRequest", 1))
	}
	if s.Push != nil && len(s.Push) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Push", 1))
	}
	if s.SourceActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceActionName"))
	}
	if s.SourceActionName != nil && len(*s.SourceActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceActionName", 1))
	}
	if s.PullRequest != nil {
		for i, v := range s.PullRequest {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PullRequest", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Push != nil {
		for i, v := range s.Push {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Push", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullRequest sets the PullRequest field's value.
func (s *GitConfiguration) SetPullRequest(v []*GitPullRequestFilter) *GitConfiguration {
	s.PullRequest = v
	return s
}

// SetPush sets the Push field's value.
func (s *GitConfiguration) SetPush(v []*GitPushFilter) *GitConfiguration {
	s.Push = v
	return s
}

// SetSourceActionName sets the SourceActionName field's value.
func (s *GitConfiguration) SetSourceActionName(v string) *GitConfiguration {
	s.SourceActionName = &v
	return s
}

// The Git repository file paths specified as filter criteria to start the pipeline.
type GitFilePathFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The list of patterns of Git repository file paths that, when a commit is
	// pushed, are to be excluded from starting the pipeline.
	Excludes []*string `locationName:"excludes" min:"1" type:"list"`

	// The list of patterns of Git repository file paths that, when a commit is
	// pushed, are to be included as criteria that starts the pipeline.
	Includes []*string `locationName:"includes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitFilePathFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitFilePathFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitFilePathFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitFilePathFilterCriteria"}
	if s.Excludes != nil && len(s.Excludes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Excludes", 1))
	}
	if s.Includes != nil && len(s.Includes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Includes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludes sets the Excludes field's value.
func (s *GitFilePathFilterCriteria) SetExcludes(v []*string) *GitFilePathFilterCriteria {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *GitFilePathFilterCriteria) SetIncludes(v []*string) *GitFilePathFilterCriteria {
	s.Includes = v
	return s
}

// The event criteria for the pull request trigger configuration, such as the
// lists of branches or file paths to include and exclude.
type GitPullRequestFilter struct {
	_ struct{} `type:"structure"`

	// The field that specifies to filter on branches for the pull request trigger
	// configuration.
	Branches *GitBranchFilterCriteria `locationName:"branches" type:"structure"`

	// The field that specifies which pull request events to filter on (opened,
	// updated, closed) for the trigger configuration.
	Events []*string `locationName:"events" min:"1" type:"list" enum:"GitPullRequestEventType"`

	// The field that specifies to filter on file paths for the pull request trigger
	// configuration.
	FilePaths *GitFilePathFilterCriteria `locationName:"filePaths" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitPullRequestFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitPullRequestFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitPullRequestFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitPullRequestFilter"}
	if s.Events != nil && len(s.Events) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Events", 1))
	}
	if s.Branches != nil {
		if err := s.Branches.Validate(); err != nil {
			invalidParams.AddNested("Branches", err.(request.ErrInvalidParams))
		}
	}
	if s.FilePaths != nil {
		if err := s.FilePaths.Validate(); err != nil {
			invalidParams.AddNested("FilePaths", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranches sets the Branches field's value.
func (s *GitPullRequestFilter) SetBranches(v *GitBranchFilterCriteria) *GitPullRequestFilter {
	s.Branches = v
	return s
}

// SetEvents sets the Events field's value.
func (s *GitPullRequestFilter) SetEvents(v []*string) *GitPullRequestFilter {
	s.Events = v
	return s
}

// SetFilePaths sets the FilePaths field's value.
func (s *GitPullRequestFilter) SetFilePaths(v *GitFilePathFilterCriteria) *GitPullRequestFilter {
	s.FilePaths = v
	return s
}

// The event criteria that specify when a specified repository event will start
// the pipeline for the specified trigger configuration, such as the lists of
// Git tags to include and exclude.
type GitPushFilter struct {
	_ struct{} `type:"structure"`

	// The field that specifies to filter on branches for the push trigger configuration.
	Branches *GitBranchFilterCriteria `locationName:"branches" type:"structure"`

	// The field that specifies to filter on file paths for the push trigger configuration.
	FilePaths *GitFilePathFilterCriteria `locationName:"filePaths" type:"structure"`

	// The field that contains the details for the Git tags trigger configuration.
	Tags *GitTagFilterCriteria `locationName:"tags" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitPushFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitPushFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitPushFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitPushFilter"}
	if s.Branches != nil {
		if err := s.Branches.Validate(); err != nil {
			invalidParams.AddNested("Branches", err.(request.ErrInvalidParams))
		}
	}
	if s.FilePaths != nil {
		if err := s.FilePaths.Validate(); err != nil {
			invalidParams.AddNested("FilePaths", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranches sets the Branches field's value.
func (s *GitPushFilter) SetBranches(v *GitBranchFilterCriteria) *GitPushFilter {
	s.Branches = v
	return s
}

// SetFilePaths sets the FilePaths field's value.
func (s *GitPushFilter) SetFilePaths(v *GitFilePathFilterCriteria) *GitPushFilter {
	s.FilePaths = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GitPushFilter) SetTags(v *GitTagFilterCriteria) *GitPushFilter {
	s.Tags = v
	return s
}

// The Git tags specified as filter criteria for whether a Git tag repository
// event will start the pipeline.
type GitTagFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The list of patterns of Git tags that, when pushed, are to be excluded from
	// starting the pipeline.
	Excludes []*string `locationName:"excludes" min:"1" type:"list"`

	// The list of patterns of Git tags that, when pushed, are to be included as
	// criteria that starts the pipeline.
	Includes []*string `locationName:"includes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitTagFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GitTagFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitTagFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitTagFilterCriteria"}
	if s.Excludes != nil && len(s.Excludes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Excludes", 1))
	}
	if s.Includes != nil && len(s.Includes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Includes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludes sets the Excludes field's value.
func (s *GitTagFilterCriteria) SetExcludes(v []*string) *GitTagFilterCriteria {
	s.Excludes = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *GitTagFilterCriteria) SetIncludes(v []*string) *GitTagFilterCriteria {
	s.Includes = v
	return s
}

// Represents information about an artifact to be worked on, such as a test
// or build artifact.
type InputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the artifact to be worked on (for example, "My App").
	//
	// Artifacts are the files that are worked on by actions in the pipeline. See
	// the action configuration for each action for details about artifact parameters.
	// For example, the S3 source action input artifact is a file name (or file
	// path), and the files are generally provided as a ZIP file. Example artifact
	// name: SampleApp_Windows.zip
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputArtifact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputArtifact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputArtifact"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *InputArtifact) SetName(v string) *InputArtifact {
	s.Name = &v
	return s
}

// The action declaration was specified in an invalid format.
type InvalidActionDeclarationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidActionDeclarationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidActionDeclarationException) GoString() string {
	return s.String()
}

func newErrorInvalidActionDeclarationException(v protocol.ResponseMetadata) error {
	return &InvalidActionDeclarationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidActionDeclarationException) Code() string {
	return "InvalidActionDeclarationException"
}

// Message returns the exception's message.
func (s *InvalidActionDeclarationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidActionDeclarationException) OrigErr() error {
	return nil
}

func (s *InvalidActionDeclarationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidActionDeclarationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidActionDeclarationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The approval request already received a response or has expired.
type InvalidApprovalTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidApprovalTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidApprovalTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidApprovalTokenException(v protocol.ResponseMetadata) error {
	return &InvalidApprovalTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidApprovalTokenException) Code() string {
	return "InvalidApprovalTokenException"
}

// Message returns the exception's message.
func (s *InvalidApprovalTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidApprovalTokenException) OrigErr() error {
	return nil
}

func (s *InvalidApprovalTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidApprovalTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidApprovalTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource ARN is invalid.
type InvalidArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) GoString() string {
	return s.String()
}

func newErrorInvalidArnException(v protocol.ResponseMetadata) error {
	return &InvalidArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArnException) Code() string {
	return "InvalidArnException"
}

// Message returns the exception's message.
func (s *InvalidArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArnException) OrigErr() error {
	return nil
}

func (s *InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Reserved for future use.
type InvalidBlockerDeclarationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidBlockerDeclarationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidBlockerDeclarationException) GoString() string {
	return s.String()
}

func newErrorInvalidBlockerDeclarationException(v protocol.ResponseMetadata) error {
	return &InvalidBlockerDeclarationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidBlockerDeclarationException) Code() string {
	return "InvalidBlockerDeclarationException"
}

// Message returns the exception's message.
func (s *InvalidBlockerDeclarationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidBlockerDeclarationException) OrigErr() error {
	return nil
}

func (s *InvalidBlockerDeclarationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidBlockerDeclarationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidBlockerDeclarationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client token was specified in an invalid format
type InvalidClientTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidClientTokenException(v protocol.ResponseMetadata) error {
	return &InvalidClientTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClientTokenException) Code() string {
	return "InvalidClientTokenException"
}

// Message returns the exception's message.
func (s *InvalidClientTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClientTokenException) OrigErr() error {
	return nil
}

func (s *InvalidClientTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClientTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClientTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The job was specified in an invalid format or cannot be found.
type InvalidJobException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobException) GoString() string {
	return s.String()
}

func newErrorInvalidJobException(v protocol.ResponseMetadata) error {
	return &InvalidJobException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidJobException) Code() string {
	return "InvalidJobException"
}

// Message returns the exception's message.
func (s *InvalidJobException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidJobException) OrigErr() error {
	return nil
}

func (s *InvalidJobException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidJobException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidJobException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The job state was specified in an invalid format.
type InvalidJobStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobStateException) GoString() string {
	return s.String()
}

func newErrorInvalidJobStateException(v protocol.ResponseMetadata) error {
	return &InvalidJobStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidJobStateException) Code() string {
	return "InvalidJobStateException"
}

// Message returns the exception's message.
func (s *InvalidJobStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidJobStateException) OrigErr() error {
	return nil
}

func (s *InvalidJobStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidJobStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidJobStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The next token was specified in an invalid format. Make sure that the next
// token you provide is the token returned by a previous call.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The nonce was specified in an invalid format.
type InvalidNonceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNonceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNonceException) GoString() string {
	return s.String()
}

func newErrorInvalidNonceException(v protocol.ResponseMetadata) error {
	return &InvalidNonceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNonceException) Code() string {
	return "InvalidNonceException"
}

// Message returns the exception's message.
func (s *InvalidNonceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNonceException) OrigErr() error {
	return nil
}

func (s *InvalidNonceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNonceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNonceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The stage declaration was specified in an invalid format.
type InvalidStageDeclarationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStageDeclarationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStageDeclarationException) GoString() string {
	return s.String()
}

func newErrorInvalidStageDeclarationException(v protocol.ResponseMetadata) error {
	return &InvalidStageDeclarationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStageDeclarationException) Code() string {
	return "InvalidStageDeclarationException"
}

// Message returns the exception's message.
func (s *InvalidStageDeclarationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStageDeclarationException) OrigErr() error {
	return nil
}

func (s *InvalidStageDeclarationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStageDeclarationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStageDeclarationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure was specified in an invalid format.
type InvalidStructureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStructureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStructureException) GoString() string {
	return s.String()
}

func newErrorInvalidStructureException(v protocol.ResponseMetadata) error {
	return &InvalidStructureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStructureException) Code() string {
	return "InvalidStructureException"
}

// Message returns the exception's message.
func (s *InvalidStructureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStructureException) OrigErr() error {
	return nil
}

func (s *InvalidStructureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStructureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStructureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource tags are invalid.
type InvalidTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagsException) GoString() string {
	return s.String()
}

func newErrorInvalidTagsException(v protocol.ResponseMetadata) error {
	return &InvalidTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagsException) Code() string {
	return "InvalidTagsException"
}

// Message returns the exception's message.
func (s *InvalidTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagsException) OrigErr() error {
	return nil
}

func (s *InvalidTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified authentication type is in an invalid format.
type InvalidWebhookAuthenticationParametersException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidWebhookAuthenticationParametersException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidWebhookAuthenticationParametersException) GoString() string {
	return s.String()
}

func newErrorInvalidWebhookAuthenticationParametersException(v protocol.ResponseMetadata) error {
	return &InvalidWebhookAuthenticationParametersException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidWebhookAuthenticationParametersException) Code() string {
	return "InvalidWebhookAuthenticationParametersException"
}

// Message returns the exception's message.
func (s *InvalidWebhookAuthenticationParametersException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidWebhookAuthenticationParametersException) OrigErr() error {
	return nil
}

func (s *InvalidWebhookAuthenticationParametersException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidWebhookAuthenticationParametersException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidWebhookAuthenticationParametersException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified event filter rule is in an invalid format.
type InvalidWebhookFilterPatternException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidWebhookFilterPatternException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidWebhookFilterPatternException) GoString() string {
	return s.String()
}

func newErrorInvalidWebhookFilterPatternException(v protocol.ResponseMetadata) error {
	return &InvalidWebhookFilterPatternException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidWebhookFilterPatternException) Code() string {
	return "InvalidWebhookFilterPatternException"
}

// Message returns the exception's message.
func (s *InvalidWebhookFilterPatternException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidWebhookFilterPatternException) OrigErr() error {
	return nil
}

func (s *InvalidWebhookFilterPatternException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidWebhookFilterPatternException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidWebhookFilterPatternException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about a job.
type Job struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account to use when performing the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Other data about a job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`

	// A system-generated random number that CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Use this number in an AcknowledgeJob
	// request.
	Nonce *string `locationName:"nonce" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Job) SetAccountId(v string) *Job {
	s.AccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *Job) SetData(v *JobData) *Job {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *Job) SetId(v string) *Job {
	s.Id = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *Job) SetNonce(v string) *Job {
	s.Nonce = &v
	return s
}

// Represents other information about a job required for a job worker to complete
// the job.
type JobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an Amazon Web Services session credentials object. These credentials
	// are temporary credentials that are issued by Amazon Web Services Secure Token
	// Service (STS). They can be used to access input and output artifacts in the
	// S3 bucket used to store artifacts for the pipeline in CodePipeline.
	//
	// ArtifactCredentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by JobData's
	// String and GoString methods.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure" sensitive:"true"`

	// A system-generated token, such as a deployment ID, required by a job to continue
	// the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// Represents information about the key used to encrypt data in the artifact
	// store, such as an KMS key.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The artifact supplied to the job.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The output of the job.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	//
	// Includes pipelineArn and pipelineExecutionId for custom jobs.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobData) GoString() string {
	return s.String()
}

// SetActionConfiguration sets the ActionConfiguration field's value.
func (s *JobData) SetActionConfiguration(v *ActionConfiguration) *JobData {
	s.ActionConfiguration = v
	return s
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *JobData) SetActionTypeId(v *ActionTypeId) *JobData {
	s.ActionTypeId = v
	return s
}

// SetArtifactCredentials sets the ArtifactCredentials field's value.
func (s *JobData) SetArtifactCredentials(v *AWSSessionCredentials) *JobData {
	s.ArtifactCredentials = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *JobData) SetContinuationToken(v string) *JobData {
	s.ContinuationToken = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *JobData) SetEncryptionKey(v *EncryptionKey) *JobData {
	s.EncryptionKey = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *JobData) SetInputArtifacts(v []*Artifact) *JobData {
	s.InputArtifacts = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *JobData) SetOutputArtifacts(v []*Artifact) *JobData {
	s.OutputArtifacts = v
	return s
}

// SetPipelineContext sets the PipelineContext field's value.
func (s *JobData) SetPipelineContext(v *PipelineContext) *JobData {
	s.PipelineContext = v
	return s
}

// Represents information about the details of a job.
type JobDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID associated with the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Represents other information about a job required for a job worker to complete
	// the job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *JobDetails) SetAccountId(v string) *JobDetails {
	s.AccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *JobDetails) SetData(v *JobData) *JobDetails {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *JobDetails) SetId(v string) *JobDetails {
	s.Id = &v
	return s
}

// The job was specified in an invalid format or cannot be found.
type JobNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobNotFoundException) GoString() string {
	return s.String()
}

func newErrorJobNotFoundException(v protocol.ResponseMetadata) error {
	return &JobNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *JobNotFoundException) Code() string {
	return "JobNotFoundException"
}

// Message returns the exception's message.
func (s *JobNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *JobNotFoundException) OrigErr() error {
	return nil
}

func (s *JobNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *JobNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *JobNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the polling configuration for the JobWorker action engine,
// or executor.
type JobWorkerExecutorConfiguration struct {
	_ struct{} `type:"structure"`

	// The accounts in which the job worker is configured and might poll for jobs
	// as part of the action execution.
	PollingAccounts []*string `locationName:"pollingAccounts" min:"1" type:"list"`

	// The service Principals in which the job worker is configured and might poll
	// for jobs as part of the action execution.
	PollingServicePrincipals []*string `locationName:"pollingServicePrincipals" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobWorkerExecutorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobWorkerExecutorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobWorkerExecutorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobWorkerExecutorConfiguration"}
	if s.PollingAccounts != nil && len(s.PollingAccounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PollingAccounts", 1))
	}
	if s.PollingServicePrincipals != nil && len(s.PollingServicePrincipals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PollingServicePrincipals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPollingAccounts sets the PollingAccounts field's value.
func (s *JobWorkerExecutorConfiguration) SetPollingAccounts(v []*string) *JobWorkerExecutorConfiguration {
	s.PollingAccounts = v
	return s
}

// SetPollingServicePrincipals sets the PollingServicePrincipals field's value.
func (s *JobWorkerExecutorConfiguration) SetPollingServicePrincipals(v []*string) *JobWorkerExecutorConfiguration {
	s.PollingServicePrincipals = v
	return s
}

// Details about the configuration for the Lambda action engine, or executor.
type LambdaExecutorConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function used by the action engine.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"lambdaFunctionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaExecutorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaExecutorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaExecutorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaExecutorConfiguration"}
	if s.LambdaFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionArn"))
	}
	if s.LambdaFunctionArn != nil && len(*s.LambdaFunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *LambdaExecutorConfiguration) SetLambdaFunctionArn(v string) *LambdaExecutorConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

// The field that specifies to filter on the latest execution in the pipeline.
//
// Filtering on the latest execution is available for executions run on or after
// February 08, 2024.
type LatestInPipelineExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The execution ID for the latest execution in the pipeline.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The start time to filter on for the latest execution in the pipeline. Valid
	// options:
	//
	//    * All
	//
	//    * Latest
	//
	// StartTimeRange is a required field
	StartTimeRange *string `locationName:"startTimeRange" type:"string" required:"true" enum:"StartTimeRange"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LatestInPipelineExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LatestInPipelineExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LatestInPipelineExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LatestInPipelineExecutionFilter"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *LatestInPipelineExecutionFilter) SetPipelineExecutionId(v string) *LatestInPipelineExecutionFilter {
	s.PipelineExecutionId = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *LatestInPipelineExecutionFilter) SetStartTimeRange(v string) *LatestInPipelineExecutionFilter {
	s.StartTimeRange = &v
	return s
}

// The number of pipelines associated with the Amazon Web Services account has
// exceeded the limit allowed for the account.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListActionExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Input information used to filter action execution history.
	Filter *ActionExecutionFilter `locationName:"filter" type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Action
	// execution history is retained for up to 12 months, based on action execution
	// start times. Default value is 100.
	//
	// Detailed execution history is available for executions run on or after February
	// 21, 2019.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous ListActionExecutions call,
	// which can be used to return the next set of action executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the pipeline for which you want to list action execution history.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActionExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListActionExecutionsInput) SetFilter(v *ActionExecutionFilter) *ListActionExecutionsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActionExecutionsInput) SetMaxResults(v int64) *ListActionExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionExecutionsInput) SetNextToken(v string) *ListActionExecutionsInput {
	s.NextToken = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *ListActionExecutionsInput) SetPipelineName(v string) *ListActionExecutionsInput {
	s.PipelineName = &v
	return s
}

type ListActionExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The details for a list of recent executions, such as action execution ID.
	ActionExecutionDetails []*ActionExecutionDetail `locationName:"actionExecutionDetails" type:"list"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned and can be used in a subsequent ListActionExecutions call
	// to return the next set of action executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionExecutionsOutput) GoString() string {
	return s.String()
}

// SetActionExecutionDetails sets the ActionExecutionDetails field's value.
func (s *ListActionExecutionsOutput) SetActionExecutionDetails(v []*ActionExecutionDetail) *ListActionExecutionsOutput {
	s.ActionExecutionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionExecutionsOutput) SetNextToken(v string) *ListActionExecutionsOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListActionTypes action.
type ListActionTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of action types to those created by a specified entity.
	ActionOwnerFilter *string `locationName:"actionOwnerFilter" type:"string" enum:"ActionOwner"`

	// An identifier that was returned from the previous list action types call,
	// which can be used to return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The Region to filter on for the list of action types.
	RegionFilter *string `locationName:"regionFilter" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActionTypesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RegionFilter != nil && len(*s.RegionFilter) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("RegionFilter", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionOwnerFilter sets the ActionOwnerFilter field's value.
func (s *ListActionTypesInput) SetActionOwnerFilter(v string) *ListActionTypesInput {
	s.ActionOwnerFilter = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionTypesInput) SetNextToken(v string) *ListActionTypesInput {
	s.NextToken = &v
	return s
}

// SetRegionFilter sets the RegionFilter field's value.
func (s *ListActionTypesInput) SetRegionFilter(v string) *ListActionTypesInput {
	s.RegionFilter = &v
	return s
}

// Represents the output of a ListActionTypes action.
type ListActionTypesOutput struct {
	_ struct{} `type:"structure"`

	// Provides details of the action types.
	//
	// ActionTypes is a required field
	ActionTypes []*ActionType `locationName:"actionTypes" type:"list" required:"true"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned. It can be used in a subsequent list action types call to
	// return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListActionTypesOutput) GoString() string {
	return s.String()
}

// SetActionTypes sets the ActionTypes field's value.
func (s *ListActionTypesOutput) SetActionTypes(v []*ActionType) *ListActionTypesOutput {
	s.ActionTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionTypesOutput) SetNextToken(v string) *ListActionTypesOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListPipelineExecutions action.
type ListPipelineExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The pipeline execution to filter on.
	Filter *PipelineExecutionFilter `locationName:"filter" type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Pipeline
	// history is limited to the most recent 12 months, based on pipeline execution
	// start times. Default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous ListPipelineExecutions call,
	// which can be used to return the next set of pipeline executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the pipeline for which you want to get execution summary information.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelineExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelineExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPipelineExecutionsInput) SetFilter(v *PipelineExecutionFilter) *ListPipelineExecutionsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPipelineExecutionsInput) SetMaxResults(v int64) *ListPipelineExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelineExecutionsInput) SetNextToken(v string) *ListPipelineExecutionsInput {
	s.NextToken = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *ListPipelineExecutionsInput) SetPipelineName(v string) *ListPipelineExecutionsInput {
	s.PipelineName = &v
	return s
}

// Represents the output of a ListPipelineExecutions action.
type ListPipelineExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used in the next ListPipelineExecutions call. To view
	// all items in the list, continue to call this operation with each subsequent
	// token until no more nextToken values are returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of executions in the history of a pipeline.
	PipelineExecutionSummaries []*PipelineExecutionSummary `locationName:"pipelineExecutionSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelineExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelineExecutionsOutput) SetNextToken(v string) *ListPipelineExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetPipelineExecutionSummaries sets the PipelineExecutionSummaries field's value.
func (s *ListPipelineExecutionsOutput) SetPipelineExecutionSummaries(v []*PipelineExecutionSummary) *ListPipelineExecutionsOutput {
	s.PipelineExecutionSummaries = v
	return s
}

// Represents the input of a ListPipelines action.
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of pipelines to return in a single call. To retrieve the
	// remaining pipelines, make another call with the returned nextToken value.
	// The minimum value you can specify is 1. The maximum accepted value is 1000.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// An identifier that was returned from the previous list pipelines call. It
	// can be used to return the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPipelinesInput) SetMaxResults(v int64) *ListPipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesInput) SetNextToken(v string) *ListPipelinesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListPipelines action.
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned. It can be used in a subsequent list pipelines call to return
	// the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of pipelines.
	Pipelines []*PipelineSummary `locationName:"pipelines" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesOutput) SetNextToken(v string) *ListPipelinesOutput {
	s.NextToken = &v
	return s
}

// SetPipelines sets the Pipelines field's value.
func (s *ListPipelinesOutput) SetPipelines(v []*PipelineSummary) *ListPipelinesOutput {
	s.Pipelines = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous API call, which would be used
	// to return the next page of the list. The ListTagsforResource call lists all
	// available tags in one call and does not use pagination.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource to get tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned and can be used in a subsequent API call to return the next
	// page of the list. The ListTagsforResource call lists all available tags in
	// one call and does not use pagination.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The tags for the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The detail returned for each webhook after listing webhooks, such as the
// webhook URL, the webhook name, and the webhook ARN.
type ListWebhookItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the webhook.
	Arn *string `locationName:"arn" type:"string"`

	// The detail returned for each webhook, such as the webhook authentication
	// type and filter rules.
	//
	// Definition is a required field
	Definition *WebhookDefinition `locationName:"definition" type:"structure" required:"true"`

	// The number code of the error.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The text of the error message about the webhook.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The date and time a webhook was last successfully triggered, in timestamp
	// format.
	LastTriggered *time.Time `locationName:"lastTriggered" type:"timestamp"`

	// Specifies the tags applied to the webhook.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A unique URL generated by CodePipeline. When a POST request is made to this
	// URL, the defined pipeline is started as long as the body of the post request
	// satisfies the defined authentication and filtering conditions. Deleting and
	// re-creating a webhook makes the old URL invalid and generates a new one.
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhookItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhookItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListWebhookItem) SetArn(v string) *ListWebhookItem {
	s.Arn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ListWebhookItem) SetDefinition(v *WebhookDefinition) *ListWebhookItem {
	s.Definition = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ListWebhookItem) SetErrorCode(v string) *ListWebhookItem {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ListWebhookItem) SetErrorMessage(v string) *ListWebhookItem {
	s.ErrorMessage = &v
	return s
}

// SetLastTriggered sets the LastTriggered field's value.
func (s *ListWebhookItem) SetLastTriggered(v time.Time) *ListWebhookItem {
	s.LastTriggered = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListWebhookItem) SetTags(v []*Tag) *ListWebhookItem {
	s.Tags = v
	return s
}

// SetUrl sets the Url field's value.
func (s *ListWebhookItem) SetUrl(v string) *ListWebhookItem {
	s.Url = &v
	return s
}

type ListWebhooksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that was returned from the previous ListWebhooks call, which can
	// be used to return the next set of webhooks in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebhooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebhooksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWebhooksInput) SetMaxResults(v int64) *ListWebhooksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebhooksInput) SetNextToken(v string) *ListWebhooksInput {
	s.NextToken = &v
	return s
}

type ListWebhooksOutput struct {
	_ struct{} `type:"structure"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned and can be used in a subsequent ListWebhooks call to return
	// the next set of webhooks in the list.
	NextToken *string `min:"1" type:"string"`

	// The JSON detail returned for each webhook in the list output for the ListWebhooks
	// call.
	Webhooks []*ListWebhookItem `locationName:"webhooks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebhooksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebhooksOutput) SetNextToken(v string) *ListWebhooksOutput {
	s.NextToken = &v
	return s
}

// SetWebhooks sets the Webhooks field's value.
func (s *ListWebhooksOutput) SetWebhooks(v []*ListWebhookItem) *ListWebhooksOutput {
	s.Webhooks = v
	return s
}

// The stage has failed in a later run of the pipeline and the pipelineExecutionId
// associated with the request is out of date.
type NotLatestPipelineExecutionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotLatestPipelineExecutionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotLatestPipelineExecutionException) GoString() string {
	return s.String()
}

func newErrorNotLatestPipelineExecutionException(v protocol.ResponseMetadata) error {
	return &NotLatestPipelineExecutionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotLatestPipelineExecutionException) Code() string {
	return "NotLatestPipelineExecutionException"
}

// Message returns the exception's message.
func (s *NotLatestPipelineExecutionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotLatestPipelineExecutionException) OrigErr() error {
	return nil
}

func (s *NotLatestPipelineExecutionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotLatestPipelineExecutionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotLatestPipelineExecutionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about the output of an action.
type OutputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the output of an artifact, such as "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Output artifact names must be unique within a pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputArtifact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputArtifact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputArtifact"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OutputArtifact) SetName(v string) *OutputArtifact {
	s.Name = &v
	return s
}

// Exceeded the total size limit for all variables in the pipeline.
type OutputVariablesSizeExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputVariablesSizeExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputVariablesSizeExceededException) GoString() string {
	return s.String()
}

func newErrorOutputVariablesSizeExceededException(v protocol.ResponseMetadata) error {
	return &OutputVariablesSizeExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OutputVariablesSizeExceededException) Code() string {
	return "OutputVariablesSizeExceededException"
}

// Message returns the exception's message.
func (s *OutputVariablesSizeExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OutputVariablesSizeExceededException) OrigErr() error {
	return nil
}

func (s *OutputVariablesSizeExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OutputVariablesSizeExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OutputVariablesSizeExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about a pipeline to a job worker.
//
// PipelineContext contains pipelineArn and pipelineExecutionId for custom action
// jobs. The pipelineArn and pipelineExecutionId fields are not populated for
// ThirdParty action jobs.
type PipelineContext struct {
	_ struct{} `type:"structure"`

	// The context of an action to a job worker in the stage of a pipeline.
	Action *ActionContext `locationName:"action" type:"structure"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The execution ID of the pipeline.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The name of the pipeline. This is a user-specified value. Pipeline names
	// must be unique across all pipeline names under an Amazon Web Services account.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The stage of the pipeline.
	Stage *StageContext `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineContext) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PipelineContext) SetAction(v *ActionContext) *PipelineContext {
	s.Action = v
	return s
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *PipelineContext) SetPipelineArn(v string) *PipelineContext {
	s.PipelineArn = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PipelineContext) SetPipelineExecutionId(v string) *PipelineContext {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineContext) SetPipelineName(v string) *PipelineContext {
	s.PipelineName = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *PipelineContext) SetStage(v *StageContext) *PipelineContext {
	s.Stage = v
	return s
}

// Represents the structure of actions and stages to be performed in the pipeline.
type PipelineDeclaration struct {
	_ struct{} `type:"structure"`

	// Represents information about the S3 bucket where artifacts are stored for
	// the pipeline.
	//
	// You must include either artifactStore or artifactStores in your pipeline,
	// but you cannot use both. If you create a cross-region action in your pipeline,
	// you must use artifactStores.
	ArtifactStore *ArtifactStore `locationName:"artifactStore" type:"structure"`

	// A mapping of artifactStore objects and their corresponding Amazon Web Services
	// Regions. There must be an artifact store for the pipeline Region and for
	// each cross-region action in the pipeline.
	//
	// You must include either artifactStore or artifactStores in your pipeline,
	// but you cannot use both. If you create a cross-region action in your pipeline,
	// you must use artifactStores.
	ArtifactStores map[string]*ArtifactStore `locationName:"artifactStores" type:"map"`

	// The method that the pipeline will use to handle multiple executions. The
	// default mode is SUPERSEDED.
	ExecutionMode *string `locationName:"executionMode" type:"string" enum:"ExecutionMode"`

	// The name of the pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// CodePipeline provides the following pipeline types, which differ in characteristics
	// and price, so that you can tailor your pipeline features and cost to the
	// needs of your applications.
	//
	//    * V1 type pipelines have a JSON structure that contains standard pipeline,
	//    stage, and action-level parameters.
	//
	//    * V2 type pipelines have the same structure as a V1 type, along with additional
	//    parameters for release safety and trigger configuration.
	//
	// Including V2 parameters, such as triggers on Git tags, in the pipeline JSON
	// when creating or updating a pipeline will result in the pipeline having the
	// V2 type of pipeline and the associated costs.
	//
	// For information about pricing for CodePipeline, see Pricing (http://aws.amazon.com/codepipeline/pricing/).
	//
	// For information about which type of pipeline to choose, see What type of
	// pipeline is right for me? (https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html).
	PipelineType *string `locationName:"pipelineType" type:"string" enum:"PipelineType"`

	// The Amazon Resource Name (ARN) for CodePipeline to use to either perform
	// actions with no actionRoleArn, or to use to assume roles for actions with
	// an actionRoleArn.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The stage in which to perform the action.
	//
	// Stages is a required field
	Stages []*StageDeclaration `locationName:"stages" type:"list" required:"true"`

	// The trigger configuration specifying a type of event, such as Git tags, that
	// starts the pipeline.
	//
	// When a trigger configuration is specified, default change detection for repository
	// and branch commits is disabled.
	Triggers []*PipelineTriggerDeclaration `locationName:"triggers" type:"list"`

	// A list that defines the pipeline variables for a pipeline resource. Variable
	// names can have alphanumeric and underscore characters, and the values must
	// match [A-Za-z0-9@\-_]+.
	Variables []*PipelineVariableDeclaration `locationName:"variables" type:"list"`

	// The version number of the pipeline. A new pipeline always has a version number
	// of 1. This number is incremented when a pipeline is updated.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineDeclaration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Stages == nil {
		invalidParams.Add(request.NewErrParamRequired("Stages"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}
	if s.ArtifactStore != nil {
		if err := s.ArtifactStore.Validate(); err != nil {
			invalidParams.AddNested("ArtifactStore", err.(request.ErrInvalidParams))
		}
	}
	if s.ArtifactStores != nil {
		for i, v := range s.ArtifactStores {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ArtifactStores", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Stages != nil {
		for i, v := range s.Stages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Stages", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactStore sets the ArtifactStore field's value.
func (s *PipelineDeclaration) SetArtifactStore(v *ArtifactStore) *PipelineDeclaration {
	s.ArtifactStore = v
	return s
}

// SetArtifactStores sets the ArtifactStores field's value.
func (s *PipelineDeclaration) SetArtifactStores(v map[string]*ArtifactStore) *PipelineDeclaration {
	s.ArtifactStores = v
	return s
}

// SetExecutionMode sets the ExecutionMode field's value.
func (s *PipelineDeclaration) SetExecutionMode(v string) *PipelineDeclaration {
	s.ExecutionMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *PipelineDeclaration) SetName(v string) *PipelineDeclaration {
	s.Name = &v
	return s
}

// SetPipelineType sets the PipelineType field's value.
func (s *PipelineDeclaration) SetPipelineType(v string) *PipelineDeclaration {
	s.PipelineType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PipelineDeclaration) SetRoleArn(v string) *PipelineDeclaration {
	s.RoleArn = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *PipelineDeclaration) SetStages(v []*StageDeclaration) *PipelineDeclaration {
	s.Stages = v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *PipelineDeclaration) SetTriggers(v []*PipelineTriggerDeclaration) *PipelineDeclaration {
	s.Triggers = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *PipelineDeclaration) SetVariables(v []*PipelineVariableDeclaration) *PipelineDeclaration {
	s.Variables = v
	return s
}

// SetVersion sets the Version field's value.
func (s *PipelineDeclaration) SetVersion(v int64) *PipelineDeclaration {
	s.Version = &v
	return s
}

// Represents information about an execution of a pipeline.
type PipelineExecution struct {
	_ struct{} `type:"structure"`

	// A list of ArtifactRevision objects included in a pipeline execution.
	ArtifactRevisions []*ArtifactRevision `locationName:"artifactRevisions" type:"list"`

	// The method that the pipeline will use to handle multiple executions. The
	// default mode is SUPERSEDED.
	ExecutionMode *string `locationName:"executionMode" type:"string" enum:"ExecutionMode"`

	// The type of the pipeline execution.
	ExecutionType *string `locationName:"executionType" type:"string" enum:"ExecutionType"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The name of the pipeline with the specified pipeline execution.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline with the specified pipeline execution.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// The metadata about the execution pertaining to stage rollback.
	RollbackMetadata *PipelineRollbackMetadata `locationName:"rollbackMetadata" type:"structure"`

	// The status of the pipeline execution.
	//
	//    * Cancelled: The pipeline’s definition was updated before the pipeline
	//    execution could be completed.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Stopped: The pipeline execution was manually stopped. For more information,
	//    see Stopped Executions (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Stopping: The pipeline execution received a request to be manually stopped.
	//    Depending on the selected stop mode, the execution is either completing
	//    or abandoning in-progress actions. For more information, see Stopped Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead. For more information, see Superseded Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status *string `locationName:"status" type:"string" enum:"PipelineExecutionStatus"`

	// A summary that contains a description of the pipeline execution status.
	StatusSummary *string `locationName:"statusSummary" type:"string"`

	// The interaction or event that started a pipeline execution.
	Trigger *ExecutionTrigger `locationName:"trigger" type:"structure"`

	// A list of pipeline variables used for the pipeline execution.
	Variables []*ResolvedPipelineVariable `locationName:"variables" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecution) GoString() string {
	return s.String()
}

// SetArtifactRevisions sets the ArtifactRevisions field's value.
func (s *PipelineExecution) SetArtifactRevisions(v []*ArtifactRevision) *PipelineExecution {
	s.ArtifactRevisions = v
	return s
}

// SetExecutionMode sets the ExecutionMode field's value.
func (s *PipelineExecution) SetExecutionMode(v string) *PipelineExecution {
	s.ExecutionMode = &v
	return s
}

// SetExecutionType sets the ExecutionType field's value.
func (s *PipelineExecution) SetExecutionType(v string) *PipelineExecution {
	s.ExecutionType = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PipelineExecution) SetPipelineExecutionId(v string) *PipelineExecution {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineExecution) SetPipelineName(v string) *PipelineExecution {
	s.PipelineName = &v
	return s
}

// SetPipelineVersion sets the PipelineVersion field's value.
func (s *PipelineExecution) SetPipelineVersion(v int64) *PipelineExecution {
	s.PipelineVersion = &v
	return s
}

// SetRollbackMetadata sets the RollbackMetadata field's value.
func (s *PipelineExecution) SetRollbackMetadata(v *PipelineRollbackMetadata) *PipelineExecution {
	s.RollbackMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *PipelineExecution) SetStatus(v string) *PipelineExecution {
	s.Status = &v
	return s
}

// SetStatusSummary sets the StatusSummary field's value.
func (s *PipelineExecution) SetStatusSummary(v string) *PipelineExecution {
	s.StatusSummary = &v
	return s
}

// SetTrigger sets the Trigger field's value.
func (s *PipelineExecution) SetTrigger(v *ExecutionTrigger) *PipelineExecution {
	s.Trigger = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *PipelineExecution) SetVariables(v []*ResolvedPipelineVariable) *PipelineExecution {
	s.Variables = v
	return s
}

// The pipeline execution to filter on.
type PipelineExecutionFilter struct {
	_ struct{} `type:"structure"`

	// Filter for pipeline executions where the stage was successful in the current
	// pipeline version.
	SucceededInStage *SucceededInStageFilter `locationName:"succeededInStage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineExecutionFilter"}
	if s.SucceededInStage != nil {
		if err := s.SucceededInStage.Validate(); err != nil {
			invalidParams.AddNested("SucceededInStage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSucceededInStage sets the SucceededInStage field's value.
func (s *PipelineExecutionFilter) SetSucceededInStage(v *SucceededInStageFilter) *PipelineExecutionFilter {
	s.SucceededInStage = v
	return s
}

// The pipeline execution was specified in an invalid format or cannot be found,
// or an execution ID does not belong to the specified pipeline.
type PipelineExecutionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionNotFoundException) GoString() string {
	return s.String()
}

func newErrorPipelineExecutionNotFoundException(v protocol.ResponseMetadata) error {
	return &PipelineExecutionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineExecutionNotFoundException) Code() string {
	return "PipelineExecutionNotFoundException"
}

// Message returns the exception's message.
func (s *PipelineExecutionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineExecutionNotFoundException) OrigErr() error {
	return nil
}

func (s *PipelineExecutionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineExecutionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineExecutionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Unable to stop the pipeline execution. The execution might already be in
// a Stopped state, or it might no longer be in progress.
type PipelineExecutionNotStoppableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionNotStoppableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionNotStoppableException) GoString() string {
	return s.String()
}

func newErrorPipelineExecutionNotStoppableException(v protocol.ResponseMetadata) error {
	return &PipelineExecutionNotStoppableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineExecutionNotStoppableException) Code() string {
	return "PipelineExecutionNotStoppableException"
}

// Message returns the exception's message.
func (s *PipelineExecutionNotStoppableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineExecutionNotStoppableException) OrigErr() error {
	return nil
}

func (s *PipelineExecutionNotStoppableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineExecutionNotStoppableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineExecutionNotStoppableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified pipeline execution is outdated and cannot be used as a target
// pipeline execution for rollback.
type PipelineExecutionOutdatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionOutdatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionOutdatedException) GoString() string {
	return s.String()
}

func newErrorPipelineExecutionOutdatedException(v protocol.ResponseMetadata) error {
	return &PipelineExecutionOutdatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineExecutionOutdatedException) Code() string {
	return "PipelineExecutionOutdatedException"
}

// Message returns the exception's message.
func (s *PipelineExecutionOutdatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineExecutionOutdatedException) OrigErr() error {
	return nil
}

func (s *PipelineExecutionOutdatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineExecutionOutdatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineExecutionOutdatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information about a pipeline execution.
type PipelineExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The method that the pipeline will use to handle multiple executions. The
	// default mode is SUPERSEDED.
	ExecutionMode *string `locationName:"executionMode" type:"string" enum:"ExecutionMode"`

	// Type of the pipeline execution.
	ExecutionType *string `locationName:"executionType" type:"string" enum:"ExecutionType"`

	// The date and time of the last change to the pipeline execution, in timestamp
	// format.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The metadata for the stage execution to be rolled back.
	RollbackMetadata *PipelineRollbackMetadata `locationName:"rollbackMetadata" type:"structure"`

	// A list of the source artifact revisions that initiated a pipeline execution.
	SourceRevisions []*SourceRevision `locationName:"sourceRevisions" type:"list"`

	// The date and time when the pipeline execution began, in timestamp format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the pipeline execution.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Stopped: The pipeline execution was manually stopped. For more information,
	//    see Stopped Executions (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Stopping: The pipeline execution received a request to be manually stopped.
	//    Depending on the selected stop mode, the execution is either completing
	//    or abandoning in-progress actions. For more information, see Stopped Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead. For more information, see Superseded Executions
	//    (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status *string `locationName:"status" type:"string" enum:"PipelineExecutionStatus"`

	// Status summary for the pipeline.
	StatusSummary *string `locationName:"statusSummary" type:"string"`

	// The interaction that stopped a pipeline execution.
	StopTrigger *StopExecutionTrigger `locationName:"stopTrigger" type:"structure"`

	// The interaction or event that started a pipeline execution, such as automated
	// change detection or a StartPipelineExecution API call.
	Trigger *ExecutionTrigger `locationName:"trigger" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineExecutionSummary) GoString() string {
	return s.String()
}

// SetExecutionMode sets the ExecutionMode field's value.
func (s *PipelineExecutionSummary) SetExecutionMode(v string) *PipelineExecutionSummary {
	s.ExecutionMode = &v
	return s
}

// SetExecutionType sets the ExecutionType field's value.
func (s *PipelineExecutionSummary) SetExecutionType(v string) *PipelineExecutionSummary {
	s.ExecutionType = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *PipelineExecutionSummary) SetLastUpdateTime(v time.Time) *PipelineExecutionSummary {
	s.LastUpdateTime = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PipelineExecutionSummary) SetPipelineExecutionId(v string) *PipelineExecutionSummary {
	s.PipelineExecutionId = &v
	return s
}

// SetRollbackMetadata sets the RollbackMetadata field's value.
func (s *PipelineExecutionSummary) SetRollbackMetadata(v *PipelineRollbackMetadata) *PipelineExecutionSummary {
	s.RollbackMetadata = v
	return s
}

// SetSourceRevisions sets the SourceRevisions field's value.
func (s *PipelineExecutionSummary) SetSourceRevisions(v []*SourceRevision) *PipelineExecutionSummary {
	s.SourceRevisions = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PipelineExecutionSummary) SetStartTime(v time.Time) *PipelineExecutionSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PipelineExecutionSummary) SetStatus(v string) *PipelineExecutionSummary {
	s.Status = &v
	return s
}

// SetStatusSummary sets the StatusSummary field's value.
func (s *PipelineExecutionSummary) SetStatusSummary(v string) *PipelineExecutionSummary {
	s.StatusSummary = &v
	return s
}

// SetStopTrigger sets the StopTrigger field's value.
func (s *PipelineExecutionSummary) SetStopTrigger(v *StopExecutionTrigger) *PipelineExecutionSummary {
	s.StopTrigger = v
	return s
}

// SetTrigger sets the Trigger field's value.
func (s *PipelineExecutionSummary) SetTrigger(v *ExecutionTrigger) *PipelineExecutionSummary {
	s.Trigger = v
	return s
}

// Information about a pipeline.
type PipelineMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The date and time that polling for source changes (periodic checks) was stopped
	// for the pipeline, in timestamp format. You can migrate (update) a polling
	// pipeline to use event-based change detection. For example, for a pipeline
	// with a CodeCommit source, we recommend you migrate (update) your pipeline
	// to use CloudWatch Events. To learn more, see Migrate polling pipelines to
	// use event-based change detection (https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html)
	// in the CodePipeline User Guide.
	PollingDisabledAt *time.Time `locationName:"pollingDisabledAt" type:"timestamp"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineMetadata) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *PipelineMetadata) SetCreated(v time.Time) *PipelineMetadata {
	s.Created = &v
	return s
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *PipelineMetadata) SetPipelineArn(v string) *PipelineMetadata {
	s.PipelineArn = &v
	return s
}

// SetPollingDisabledAt sets the PollingDisabledAt field's value.
func (s *PipelineMetadata) SetPollingDisabledAt(v time.Time) *PipelineMetadata {
	s.PollingDisabledAt = &v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *PipelineMetadata) SetUpdated(v time.Time) *PipelineMetadata {
	s.Updated = &v
	return s
}

// The specified pipeline name is already in use.
type PipelineNameInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineNameInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineNameInUseException) GoString() string {
	return s.String()
}

func newErrorPipelineNameInUseException(v protocol.ResponseMetadata) error {
	return &PipelineNameInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineNameInUseException) Code() string {
	return "PipelineNameInUseException"
}

// Message returns the exception's message.
func (s *PipelineNameInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineNameInUseException) OrigErr() error {
	return nil
}

func (s *PipelineNameInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineNameInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineNameInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The pipeline was specified in an invalid format or cannot be found.
type PipelineNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineNotFoundException) GoString() string {
	return s.String()
}

func newErrorPipelineNotFoundException(v protocol.ResponseMetadata) error {
	return &PipelineNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineNotFoundException) Code() string {
	return "PipelineNotFoundException"
}

// Message returns the exception's message.
func (s *PipelineNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineNotFoundException) OrigErr() error {
	return nil
}

func (s *PipelineNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The metadata for the stage execution to be rolled back.
type PipelineRollbackMetadata struct {
	_ struct{} `type:"structure"`

	// The pipeline execution ID to which the stage will be rolled back.
	RollbackTargetPipelineExecutionId *string `locationName:"rollbackTargetPipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineRollbackMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineRollbackMetadata) GoString() string {
	return s.String()
}

// SetRollbackTargetPipelineExecutionId sets the RollbackTargetPipelineExecutionId field's value.
func (s *PipelineRollbackMetadata) SetRollbackTargetPipelineExecutionId(v string) *PipelineRollbackMetadata {
	s.RollbackTargetPipelineExecutionId = &v
	return s
}

// Returns a summary of a pipeline.
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The method that the pipeline will use to handle multiple executions. The
	// default mode is SUPERSEDED.
	ExecutionMode *string `locationName:"executionMode" type:"string" enum:"ExecutionMode"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// CodePipeline provides the following pipeline types, which differ in characteristics
	// and price, so that you can tailor your pipeline features and cost to the
	// needs of your applications.
	//
	//    * V1 type pipelines have a JSON structure that contains standard pipeline,
	//    stage, and action-level parameters.
	//
	//    * V2 type pipelines have the same structure as a V1 type, along with additional
	//    parameters for release safety and trigger configuration.
	//
	// Including V2 parameters, such as triggers on Git tags, in the pipeline JSON
	// when creating or updating a pipeline will result in the pipeline having the
	// V2 type of pipeline and the associated costs.
	//
	// For information about pricing for CodePipeline, see Pricing (http://aws.amazon.com/codepipeline/pricing/).
	//
	// For information about which type of pipeline to choose, see What type of
	// pipeline is right for me? (https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html).
	PipelineType *string `locationName:"pipelineType" type:"string" enum:"PipelineType"`

	// The date and time of the last update to the pipeline, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp"`

	// The version number of the pipeline.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineSummary) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *PipelineSummary) SetCreated(v time.Time) *PipelineSummary {
	s.Created = &v
	return s
}

// SetExecutionMode sets the ExecutionMode field's value.
func (s *PipelineSummary) SetExecutionMode(v string) *PipelineSummary {
	s.ExecutionMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *PipelineSummary) SetName(v string) *PipelineSummary {
	s.Name = &v
	return s
}

// SetPipelineType sets the PipelineType field's value.
func (s *PipelineSummary) SetPipelineType(v string) *PipelineSummary {
	s.PipelineType = &v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *PipelineSummary) SetUpdated(v time.Time) *PipelineSummary {
	s.Updated = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PipelineSummary) SetVersion(v int64) *PipelineSummary {
	s.Version = &v
	return s
}

// Represents information about the specified trigger configuration, such as
// the filter criteria and the source stage for the action that contains the
// trigger.
//
// This is only supported for the CodeStarSourceConnection action type.
//
// When a trigger configuration is specified, default change detection for repository
// and branch commits is disabled.
type PipelineTriggerDeclaration struct {
	_ struct{} `type:"structure"`

	// Provides the filter criteria and the source stage for the repository event
	// that starts the pipeline, such as Git tags.
	//
	// GitConfiguration is a required field
	GitConfiguration *GitConfiguration `locationName:"gitConfiguration" type:"structure" required:"true"`

	// The source provider for the event, such as connections configured for a repository
	// with Git tags, for the specified trigger configuration.
	//
	// ProviderType is a required field
	ProviderType *string `locationName:"providerType" type:"string" required:"true" enum:"PipelineTriggerProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineTriggerDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineTriggerDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineTriggerDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineTriggerDeclaration"}
	if s.GitConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("GitConfiguration"))
	}
	if s.ProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderType"))
	}
	if s.GitConfiguration != nil {
		if err := s.GitConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GitConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGitConfiguration sets the GitConfiguration field's value.
func (s *PipelineTriggerDeclaration) SetGitConfiguration(v *GitConfiguration) *PipelineTriggerDeclaration {
	s.GitConfiguration = v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *PipelineTriggerDeclaration) SetProviderType(v string) *PipelineTriggerDeclaration {
	s.ProviderType = &v
	return s
}

// A pipeline-level variable used for a pipeline execution.
type PipelineVariable struct {
	_ struct{} `type:"structure"`

	// The name of a pipeline-level variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of a pipeline-level variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PipelineVariable) SetName(v string) *PipelineVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PipelineVariable) SetValue(v string) *PipelineVariable {
	s.Value = &v
	return s
}

// A variable declared at the pipeline level.
type PipelineVariableDeclaration struct {
	_ struct{} `type:"structure"`

	// The value of a pipeline-level variable.
	DefaultValue *string `locationName:"defaultValue" min:"1" type:"string"`

	// The description of a pipeline-level variable. It's used to add additional
	// context about the variable, and not being used at time when pipeline executes.
	Description *string `locationName:"description" type:"string"`

	// The name of a pipeline-level variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVariableDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVariableDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineVariableDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineVariableDeclaration"}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultValue", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *PipelineVariableDeclaration) SetDefaultValue(v string) *PipelineVariableDeclaration {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PipelineVariableDeclaration) SetDescription(v string) *PipelineVariableDeclaration {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PipelineVariableDeclaration) SetName(v string) *PipelineVariableDeclaration {
	s.Name = &v
	return s
}

// The pipeline version was specified in an invalid format or cannot be found.
type PipelineVersionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVersionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipelineVersionNotFoundException) GoString() string {
	return s.String()
}

func newErrorPipelineVersionNotFoundException(v protocol.ResponseMetadata) error {
	return &PipelineVersionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PipelineVersionNotFoundException) Code() string {
	return "PipelineVersionNotFoundException"
}

// Message returns the exception's message.
func (s *PipelineVersionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PipelineVersionNotFoundException) OrigErr() error {
	return nil
}

func (s *PipelineVersionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PipelineVersionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PipelineVersionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a PollForJobs action.
type PollForJobsInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with
	// a queryable property, you must supply that property as a key in the map.
	// Only jobs whose action configuration matches the mapped value are returned.
	QueryParam map[string]*string `locationName:"queryParam" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForJobsInput"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.MaxBatchSize != nil && *s.MaxBatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBatchSize", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *PollForJobsInput) SetActionTypeId(v *ActionTypeId) *PollForJobsInput {
	s.ActionTypeId = v
	return s
}

// SetMaxBatchSize sets the MaxBatchSize field's value.
func (s *PollForJobsInput) SetMaxBatchSize(v int64) *PollForJobsInput {
	s.MaxBatchSize = &v
	return s
}

// SetQueryParam sets the QueryParam field's value.
func (s *PollForJobsInput) SetQueryParam(v map[string]*string) *PollForJobsInput {
	s.QueryParam = v
	return s
}

// Represents the output of a PollForJobs action.
type PollForJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs to take action on.
	Jobs []*Job `locationName:"jobs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *PollForJobsOutput) SetJobs(v []*Job) *PollForJobsOutput {
	s.Jobs = v
	return s
}

// Represents the input of a PollForThirdPartyJobs action.
type PollForThirdPartyJobsInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForThirdPartyJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForThirdPartyJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForThirdPartyJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForThirdPartyJobsInput"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.MaxBatchSize != nil && *s.MaxBatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBatchSize", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *PollForThirdPartyJobsInput) SetActionTypeId(v *ActionTypeId) *PollForThirdPartyJobsInput {
	s.ActionTypeId = v
	return s
}

// SetMaxBatchSize sets the MaxBatchSize field's value.
func (s *PollForThirdPartyJobsInput) SetMaxBatchSize(v int64) *PollForThirdPartyJobsInput {
	s.MaxBatchSize = &v
	return s
}

// Represents the output of a PollForThirdPartyJobs action.
type PollForThirdPartyJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs to take action on.
	Jobs []*ThirdPartyJob `locationName:"jobs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForThirdPartyJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PollForThirdPartyJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *PollForThirdPartyJobsOutput) SetJobs(v []*ThirdPartyJob) *PollForThirdPartyJobsOutput {
	s.Jobs = v
	return s
}

// Represents the input of a PutActionRevision action.
type PutActionRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of the action that processes the revision.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// Represents information about the version (or revision) of an action.
	//
	// ActionRevision is a required field
	ActionRevision *ActionRevision `locationName:"actionRevision" type:"structure" required:"true"`

	// The name of the pipeline that starts processing the revision to the source.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage that contains the action that acts on the revision.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutActionRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutActionRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutActionRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutActionRevisionInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.ActionRevision == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionRevision"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.ActionRevision != nil {
		if err := s.ActionRevision.Validate(); err != nil {
			invalidParams.AddNested("ActionRevision", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *PutActionRevisionInput) SetActionName(v string) *PutActionRevisionInput {
	s.ActionName = &v
	return s
}

// SetActionRevision sets the ActionRevision field's value.
func (s *PutActionRevisionInput) SetActionRevision(v *ActionRevision) *PutActionRevisionInput {
	s.ActionRevision = v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PutActionRevisionInput) SetPipelineName(v string) *PutActionRevisionInput {
	s.PipelineName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *PutActionRevisionInput) SetStageName(v string) *PutActionRevisionInput {
	s.StageName = &v
	return s
}

// Represents the output of a PutActionRevision action.
type PutActionRevisionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the artifact revision was previously used in an execution
	// of the specified pipeline.
	NewRevision *bool `locationName:"newRevision" type:"boolean"`

	// The ID of the current workflow state of the pipeline.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutActionRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutActionRevisionOutput) GoString() string {
	return s.String()
}

// SetNewRevision sets the NewRevision field's value.
func (s *PutActionRevisionOutput) SetNewRevision(v bool) *PutActionRevisionOutput {
	s.NewRevision = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PutActionRevisionOutput) SetPipelineExecutionId(v string) *PutActionRevisionOutput {
	s.PipelineExecutionId = &v
	return s
}

// Represents the input of a PutApprovalResult action.
type PutApprovalResultInput struct {
	_ struct{} `type:"structure"`

	// The name of the action for which approval is requested.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The name of the pipeline that contains the action.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Represents information about the result of the approval request.
	//
	// Result is a required field
	Result *ApprovalResult `locationName:"result" type:"structure" required:"true"`

	// The name of the stage that contains the action.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// action. It is used to validate that the approval request corresponding to
	// this token is still valid.
	//
	// Token is a required field
	Token *string `locationName:"token" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApprovalResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApprovalResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApprovalResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApprovalResultInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Result == nil {
		invalidParams.Add(request.NewErrParamRequired("Result"))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Result != nil {
		if err := s.Result.Validate(); err != nil {
			invalidParams.AddNested("Result", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *PutApprovalResultInput) SetActionName(v string) *PutApprovalResultInput {
	s.ActionName = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PutApprovalResultInput) SetPipelineName(v string) *PutApprovalResultInput {
	s.PipelineName = &v
	return s
}

// SetResult sets the Result field's value.
func (s *PutApprovalResultInput) SetResult(v *ApprovalResult) *PutApprovalResultInput {
	s.Result = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *PutApprovalResultInput) SetStageName(v string) *PutApprovalResultInput {
	s.StageName = &v
	return s
}

// SetToken sets the Token field's value.
func (s *PutApprovalResultInput) SetToken(v string) *PutApprovalResultInput {
	s.Token = &v
	return s
}

// Represents the output of a PutApprovalResult action.
type PutApprovalResultOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp showing when the approval or rejection was submitted.
	ApprovedAt *time.Time `locationName:"approvedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApprovalResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApprovalResultOutput) GoString() string {
	return s.String()
}

// SetApprovedAt sets the ApprovedAt field's value.
func (s *PutApprovalResultOutput) SetApprovedAt(v time.Time) *PutApprovalResultOutput {
	s.ApprovedAt = &v
	return s
}

// Represents the input of a PutJobFailureResult action.
type PutJobFailureResultInput struct {
	_ struct{} `type:"structure"`

	// The details about the failure of a job.
	//
	// FailureDetails is a required field
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The unique system-generated ID of the job that failed. This is the same ID
	// returned from PollForJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobFailureResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobFailureResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobFailureResultInput"}
	if s.FailureDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureDetails"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.FailureDetails != nil {
		if err := s.FailureDetails.Validate(); err != nil {
			invalidParams.AddNested("FailureDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *PutJobFailureResultInput) SetFailureDetails(v *FailureDetails) *PutJobFailureResultInput {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobFailureResultInput) SetJobId(v string) *PutJobFailureResultInput {
	s.JobId = &v
	return s
}

type PutJobFailureResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutJobSuccessResult action.
type PutJobSuccessResultInput struct {
	_ struct{} `type:"structure"`

	// A token generated by a job worker, such as a CodeDeploy deployment ID, that
	// a successful job provides to identify a custom action in progress. Future
	// jobs use this token to identify the running instance of the action. It can
	// be reused to return more information about the progress of the custom action.
	// When the action is complete, no continuation token should be supplied.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// The ID of the current revision of the artifact successfully worked on by
	// the job.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The execution details of the successful job, such as the actions taken by
	// the job worker.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The unique system-generated ID of the job that succeeded. This is the same
	// ID returned from PollForJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// Key-value pairs produced as output by a job worker that can be made available
	// to a downstream action configuration. outputVariables can be included only
	// when there is no continuation token on the request.
	OutputVariables map[string]*string `locationName:"outputVariables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobSuccessResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobSuccessResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobSuccessResultInput"}
	if s.ContinuationToken != nil && len(*s.ContinuationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContinuationToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.CurrentRevision != nil {
		if err := s.CurrentRevision.Validate(); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionDetails != nil {
		if err := s.ExecutionDetails.Validate(); err != nil {
			invalidParams.AddNested("ExecutionDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *PutJobSuccessResultInput) SetContinuationToken(v string) *PutJobSuccessResultInput {
	s.ContinuationToken = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *PutJobSuccessResultInput) SetCurrentRevision(v *CurrentRevision) *PutJobSuccessResultInput {
	s.CurrentRevision = v
	return s
}

// SetExecutionDetails sets the ExecutionDetails field's value.
func (s *PutJobSuccessResultInput) SetExecutionDetails(v *ExecutionDetails) *PutJobSuccessResultInput {
	s.ExecutionDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobSuccessResultInput) SetJobId(v string) *PutJobSuccessResultInput {
	s.JobId = &v
	return s
}

// SetOutputVariables sets the OutputVariables field's value.
func (s *PutJobSuccessResultInput) SetOutputVariables(v map[string]*string) *PutJobSuccessResultInput {
	s.OutputVariables = v
	return s
}

type PutJobSuccessResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobSuccessResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutThirdPartyJobFailureResult action.
type PutThirdPartyJobFailureResultInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// Represents information about failure details.
	//
	// FailureDetails is a required field
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The ID of the job that failed. This is the same ID returned from PollForThirdPartyJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobFailureResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutThirdPartyJobFailureResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutThirdPartyJobFailureResultInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FailureDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureDetails"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.FailureDetails != nil {
		if err := s.FailureDetails.Validate(); err != nil {
			invalidParams.AddNested("FailureDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutThirdPartyJobFailureResultInput) SetClientToken(v string) *PutThirdPartyJobFailureResultInput {
	s.ClientToken = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *PutThirdPartyJobFailureResultInput) SetFailureDetails(v *FailureDetails) *PutThirdPartyJobFailureResultInput {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutThirdPartyJobFailureResultInput) SetJobId(v string) *PutThirdPartyJobFailureResultInput {
	s.JobId = &v
	return s
}

type PutThirdPartyJobFailureResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutThirdPartyJobSuccessResult action.
type PutThirdPartyJobSuccessResultInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// A token generated by a job worker, such as a CodeDeploy deployment ID, that
	// a successful job provides to identify a partner action in progress. Future
	// jobs use this token to identify the running instance of the action. It can
	// be reused to return more information about the progress of the partner action.
	// When the action is complete, no continuation token should be supplied.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// Represents information about a current revision.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The details of the actions taken and results produced on an artifact as it
	// passes through stages in the pipeline.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The ID of the job that successfully completed. This is the same ID returned
	// from PollForThirdPartyJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobSuccessResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutThirdPartyJobSuccessResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutThirdPartyJobSuccessResultInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ContinuationToken != nil && len(*s.ContinuationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContinuationToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.CurrentRevision != nil {
		if err := s.CurrentRevision.Validate(); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionDetails != nil {
		if err := s.ExecutionDetails.Validate(); err != nil {
			invalidParams.AddNested("ExecutionDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetClientToken(v string) *PutThirdPartyJobSuccessResultInput {
	s.ClientToken = &v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetContinuationToken(v string) *PutThirdPartyJobSuccessResultInput {
	s.ContinuationToken = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetCurrentRevision(v *CurrentRevision) *PutThirdPartyJobSuccessResultInput {
	s.CurrentRevision = v
	return s
}

// SetExecutionDetails sets the ExecutionDetails field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetExecutionDetails(v *ExecutionDetails) *PutThirdPartyJobSuccessResultInput {
	s.ExecutionDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetJobId(v string) *PutThirdPartyJobSuccessResultInput {
	s.JobId = &v
	return s
}

type PutThirdPartyJobSuccessResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutThirdPartyJobSuccessResultOutput) GoString() string {
	return s.String()
}

type PutWebhookInput struct {
	_ struct{} `type:"structure"`

	// The tags for the webhook.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The detail provided in an input file to create the webhook, such as the webhook
	// name, the pipeline name, and the action name. Give the webhook a unique name
	// that helps you identify it. You might name the webhook after the pipeline
	// and action it targets so that you can easily recognize what it's used for
	// later.
	//
	// Webhook is a required field
	Webhook *WebhookDefinition `locationName:"webhook" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutWebhookInput"}
	if s.Webhook == nil {
		invalidParams.Add(request.NewErrParamRequired("Webhook"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Webhook != nil {
		if err := s.Webhook.Validate(); err != nil {
			invalidParams.AddNested("Webhook", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *PutWebhookInput) SetTags(v []*Tag) *PutWebhookInput {
	s.Tags = v
	return s
}

// SetWebhook sets the Webhook field's value.
func (s *PutWebhookInput) SetWebhook(v *WebhookDefinition) *PutWebhookInput {
	s.Webhook = v
	return s
}

type PutWebhookOutput struct {
	_ struct{} `type:"structure"`

	// The detail returned from creating the webhook, such as the webhook name,
	// webhook URL, and webhook ARN.
	Webhook *ListWebhookItem `locationName:"webhook" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWebhookOutput) GoString() string {
	return s.String()
}

// SetWebhook sets the Webhook field's value.
func (s *PutWebhookOutput) SetWebhook(v *ListWebhookItem) *PutWebhookOutput {
	s.Webhook = v
	return s
}

type RegisterWebhookWithThirdPartyInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing webhook created with PutWebhook to register with
	// a supported third party.
	WebhookName *string `locationName:"webhookName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWebhookWithThirdPartyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWebhookWithThirdPartyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterWebhookWithThirdPartyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterWebhookWithThirdPartyInput"}
	if s.WebhookName != nil && len(*s.WebhookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebhookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWebhookName sets the WebhookName field's value.
func (s *RegisterWebhookWithThirdPartyInput) SetWebhookName(v string) *RegisterWebhookWithThirdPartyInput {
	s.WebhookName = &v
	return s
}

type RegisterWebhookWithThirdPartyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWebhookWithThirdPartyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWebhookWithThirdPartyOutput) GoString() string {
	return s.String()
}

// The request failed because of an unknown error, exception, or failure.
type RequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestFailedException) GoString() string {
	return s.String()
}

func newErrorRequestFailedException(v protocol.ResponseMetadata) error {
	return &RequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestFailedException) Code() string {
	return "RequestFailedException"
}

// Message returns the exception's message.
func (s *RequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestFailedException) OrigErr() error {
	return nil
}

func (s *RequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A pipeline-level variable used for a pipeline execution.
type ResolvedPipelineVariable struct {
	_ struct{} `type:"structure"`

	// The name of a pipeline-level variable.
	Name *string `locationName:"name" type:"string"`

	// The resolved value of a pipeline-level variable.
	ResolvedValue *string `locationName:"resolvedValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedPipelineVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolvedPipelineVariable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ResolvedPipelineVariable) SetName(v string) *ResolvedPipelineVariable {
	s.Name = &v
	return s
}

// SetResolvedValue sets the ResolvedValue field's value.
func (s *ResolvedPipelineVariable) SetResolvedValue(v string) *ResolvedPipelineVariable {
	s.ResolvedValue = &v
	return s
}

// The resource was specified in an invalid format.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a RetryStageExecution action.
type RetryStageExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution in the failed stage to be retried. Use the
	// GetPipelineState action to retrieve the current pipelineExecutionId of the
	// failed stage
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline that contains the failed stage.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The scope of the retry attempt.
	//
	// RetryMode is a required field
	RetryMode *string `locationName:"retryMode" type:"string" required:"true" enum:"StageRetryMode"`

	// The name of the failed stage to be retried.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStageExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStageExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryStageExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryStageExecutionInput"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.RetryMode == nil {
		invalidParams.Add(request.NewErrParamRequired("RetryMode"))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *RetryStageExecutionInput) SetPipelineExecutionId(v string) *RetryStageExecutionInput {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *RetryStageExecutionInput) SetPipelineName(v string) *RetryStageExecutionInput {
	s.PipelineName = &v
	return s
}

// SetRetryMode sets the RetryMode field's value.
func (s *RetryStageExecutionInput) SetRetryMode(v string) *RetryStageExecutionInput {
	s.RetryMode = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *RetryStageExecutionInput) SetStageName(v string) *RetryStageExecutionInput {
	s.StageName = &v
	return s
}

// Represents the output of a RetryStageExecution action.
type RetryStageExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the current workflow execution in the failed stage.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStageExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStageExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *RetryStageExecutionOutput) SetPipelineExecutionId(v string) *RetryStageExecutionOutput {
	s.PipelineExecutionId = &v
	return s
}

type RollbackStageInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline for which the stage will be rolled back.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage in the pipeline to be rolled back.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// The pipeline execution ID for the stage to be rolled back to.
	//
	// TargetPipelineExecutionId is a required field
	TargetPipelineExecutionId *string `locationName:"targetPipelineExecutionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackStageInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.TargetPipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetPipelineExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *RollbackStageInput) SetPipelineName(v string) *RollbackStageInput {
	s.PipelineName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *RollbackStageInput) SetStageName(v string) *RollbackStageInput {
	s.StageName = &v
	return s
}

// SetTargetPipelineExecutionId sets the TargetPipelineExecutionId field's value.
func (s *RollbackStageInput) SetTargetPipelineExecutionId(v string) *RollbackStageInput {
	s.TargetPipelineExecutionId = &v
	return s
}

type RollbackStageOutput struct {
	_ struct{} `type:"structure"`

	// The execution ID of the pipeline execution for the stage that has been rolled
	// back.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStageOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *RollbackStageOutput) SetPipelineExecutionId(v string) *RollbackStageOutput {
	s.PipelineExecutionId = &v
	return s
}

// The location of the S3 bucket that contains a revision.
type S3ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key of the object in the S3 bucket, which uniquely identifies the object
	// in the bucket.
	//
	// ObjectKey is a required field
	ObjectKey *string `locationName:"objectKey" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ArtifactLocation) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3ArtifactLocation) SetBucketName(v string) *S3ArtifactLocation {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *S3ArtifactLocation) SetObjectKey(v string) *S3ArtifactLocation {
	s.ObjectKey = &v
	return s
}

// The Amazon S3 artifact location for an action's artifacts.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 artifact bucket for an action's artifacts.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// The artifact name.
	Key *string `locationName:"key" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// Information about the version (or revision) of a source artifact that initiated
// a pipeline execution.
type SourceRevision struct {
	_ struct{} `type:"structure"`

	// The name of the action that processed the revision to the source artifact.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The system-generated unique ID that identifies the revision number of the
	// artifact.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Summary information about the most recent revision of the artifact. For GitHub
	// and CodeCommit repositories, the commit message. For Amazon S3 buckets or
	// actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`

	// The commit ID for the artifact revision. For artifacts stored in GitHub or
	// CodeCommit repositories, the commit ID is linked to a commit details page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceRevision) GoString() string {
	return s.String()
}

// SetActionName sets the ActionName field's value.
func (s *SourceRevision) SetActionName(v string) *SourceRevision {
	s.ActionName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *SourceRevision) SetRevisionId(v string) *SourceRevision {
	s.RevisionId = &v
	return s
}

// SetRevisionSummary sets the RevisionSummary field's value.
func (s *SourceRevision) SetRevisionSummary(v string) *SourceRevision {
	s.RevisionSummary = &v
	return s
}

// SetRevisionUrl sets the RevisionUrl field's value.
func (s *SourceRevision) SetRevisionUrl(v string) *SourceRevision {
	s.RevisionUrl = &v
	return s
}

// A list that allows you to specify, or override, the source revision for a
// pipeline execution that's being started. A source revision is the version
// with all the changes to your application code, or source artifact, for the
// pipeline execution.
type SourceRevisionOverride struct {
	_ struct{} `type:"structure"`

	// The name of the action where the override will be applied.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The type of source revision, based on the source provider. For example, the
	// revision type for the CodeCommit action provider is the commit ID.
	//
	// RevisionType is a required field
	RevisionType *string `locationName:"revisionType" type:"string" required:"true" enum:"SourceRevisionType"`

	// The source revision, or version of your source artifact, with the changes
	// that you want to run in the pipeline execution.
	//
	// RevisionValue is a required field
	RevisionValue *string `locationName:"revisionValue" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceRevisionOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceRevisionOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceRevisionOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceRevisionOverride"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.RevisionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionType"))
	}
	if s.RevisionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionValue"))
	}
	if s.RevisionValue != nil && len(*s.RevisionValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *SourceRevisionOverride) SetActionName(v string) *SourceRevisionOverride {
	s.ActionName = &v
	return s
}

// SetRevisionType sets the RevisionType field's value.
func (s *SourceRevisionOverride) SetRevisionType(v string) *SourceRevisionOverride {
	s.RevisionType = &v
	return s
}

// SetRevisionValue sets the RevisionValue field's value.
func (s *SourceRevisionOverride) SetRevisionValue(v string) *SourceRevisionOverride {
	s.RevisionValue = &v
	return s
}

// Represents information about a stage to a job worker.
type StageContext struct {
	_ struct{} `type:"structure"`

	// The name of the stage.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageContext) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StageContext) SetName(v string) *StageContext {
	s.Name = &v
	return s
}

// Represents information about a stage and its definition.
type StageDeclaration struct {
	_ struct{} `type:"structure"`

	// The actions included in a stage.
	//
	// Actions is a required field
	Actions []*ActionDeclaration `locationName:"actions" type:"list" required:"true"`

	// Reserved for future use.
	Blockers []*BlockerDeclaration `locationName:"blockers" type:"list"`

	// The name of the stage.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The method to use when a stage has not completed successfully. For example,
	// configuring this field for rollback will roll back a failed stage automatically
	// to the last successful pipeline execution in the stage.
	OnFailure *FailureConditions `locationName:"onFailure" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StageDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StageDeclaration"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Blockers != nil {
		for i, v := range s.Blockers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Blockers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *StageDeclaration) SetActions(v []*ActionDeclaration) *StageDeclaration {
	s.Actions = v
	return s
}

// SetBlockers sets the Blockers field's value.
func (s *StageDeclaration) SetBlockers(v []*BlockerDeclaration) *StageDeclaration {
	s.Blockers = v
	return s
}

// SetName sets the Name field's value.
func (s *StageDeclaration) SetName(v string) *StageDeclaration {
	s.Name = &v
	return s
}

// SetOnFailure sets the OnFailure field's value.
func (s *StageDeclaration) SetOnFailure(v *FailureConditions) *StageDeclaration {
	s.OnFailure = v
	return s
}

// Represents information about the run of a stage.
type StageExecution struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution associated with the stage.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The status of the stage, or for a completed stage, the last status of the
	// stage.
	//
	// A status of cancelled means that the pipeline’s definition was updated
	// before the stage execution could be completed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StageExecutionStatus"`

	// The type of pipeline execution for the stage, such as a rollback pipeline
	// execution.
	Type *string `locationName:"type" type:"string" enum:"ExecutionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageExecution) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StageExecution) SetPipelineExecutionId(v string) *StageExecution {
	s.PipelineExecutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StageExecution) SetStatus(v string) *StageExecution {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *StageExecution) SetType(v string) *StageExecution {
	s.Type = &v
	return s
}

// The stage was specified in an invalid format or cannot be found.
type StageNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageNotFoundException) GoString() string {
	return s.String()
}

func newErrorStageNotFoundException(v protocol.ResponseMetadata) error {
	return &StageNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StageNotFoundException) Code() string {
	return "StageNotFoundException"
}

// Message returns the exception's message.
func (s *StageNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StageNotFoundException) OrigErr() error {
	return nil
}

func (s *StageNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StageNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StageNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Unable to retry. The pipeline structure or stage state might have changed
// while actions awaited retry, or the stage contains no failed actions.
type StageNotRetryableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageNotRetryableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageNotRetryableException) GoString() string {
	return s.String()
}

func newErrorStageNotRetryableException(v protocol.ResponseMetadata) error {
	return &StageNotRetryableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StageNotRetryableException) Code() string {
	return "StageNotRetryableException"
}

// Message returns the exception's message.
func (s *StageNotRetryableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StageNotRetryableException) OrigErr() error {
	return nil
}

func (s *StageNotRetryableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StageNotRetryableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StageNotRetryableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about the state of the stage.
type StageState struct {
	_ struct{} `type:"structure"`

	// The state of the stage.
	ActionStates []*ActionState `locationName:"actionStates" type:"list"`

	// Represents information about the run of a stage.
	InboundExecution *StageExecution `locationName:"inboundExecution" type:"structure"`

	// The inbound executions for a stage.
	InboundExecutions []*StageExecution `locationName:"inboundExecutions" type:"list"`

	// The state of the inbound transition, which is either enabled or disabled.
	InboundTransitionState *TransitionState `locationName:"inboundTransitionState" type:"structure"`

	// Information about the latest execution in the stage, including its ID and
	// status.
	LatestExecution *StageExecution `locationName:"latestExecution" type:"structure"`

	// The name of the stage.
	StageName *string `locationName:"stageName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageState) GoString() string {
	return s.String()
}

// SetActionStates sets the ActionStates field's value.
func (s *StageState) SetActionStates(v []*ActionState) *StageState {
	s.ActionStates = v
	return s
}

// SetInboundExecution sets the InboundExecution field's value.
func (s *StageState) SetInboundExecution(v *StageExecution) *StageState {
	s.InboundExecution = v
	return s
}

// SetInboundExecutions sets the InboundExecutions field's value.
func (s *StageState) SetInboundExecutions(v []*StageExecution) *StageState {
	s.InboundExecutions = v
	return s
}

// SetInboundTransitionState sets the InboundTransitionState field's value.
func (s *StageState) SetInboundTransitionState(v *TransitionState) *StageState {
	s.InboundTransitionState = v
	return s
}

// SetLatestExecution sets the LatestExecution field's value.
func (s *StageState) SetLatestExecution(v *StageExecution) *StageState {
	s.LatestExecution = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *StageState) SetStageName(v string) *StageState {
	s.StageName = &v
	return s
}

// Represents the input of a StartPipelineExecution action.
type StartPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID used to identify a unique execution request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the pipeline to start.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list that allows you to specify, or override, the source revision for a
	// pipeline execution that's being started. A source revision is the version
	// with all the changes to your application code, or source artifact, for the
	// pipeline execution.
	SourceRevisions []*SourceRevisionOverride `locationName:"sourceRevisions" type:"list"`

	// A list that overrides pipeline variables for a pipeline execution that's
	// being started. Variable names must match [A-Za-z0-9@\-_]+, and the values
	// can be anything except an empty string.
	Variables []*PipelineVariable `locationName:"variables" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPipelineExecutionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Variables != nil && len(s.Variables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Variables", 1))
	}
	if s.SourceRevisions != nil {
		for i, v := range s.SourceRevisions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceRevisions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPipelineExecutionInput) SetClientRequestToken(v string) *StartPipelineExecutionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartPipelineExecutionInput) SetName(v string) *StartPipelineExecutionInput {
	s.Name = &v
	return s
}

// SetSourceRevisions sets the SourceRevisions field's value.
func (s *StartPipelineExecutionInput) SetSourceRevisions(v []*SourceRevisionOverride) *StartPipelineExecutionInput {
	s.SourceRevisions = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *StartPipelineExecutionInput) SetVariables(v []*PipelineVariable) *StartPipelineExecutionInput {
	s.Variables = v
	return s
}

// Represents the output of a StartPipelineExecution action.
type StartPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the pipeline execution that was started.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StartPipelineExecutionOutput) SetPipelineExecutionId(v string) *StartPipelineExecutionOutput {
	s.PipelineExecutionId = &v
	return s
}

// The interaction that stopped a pipeline execution.
type StopExecutionTrigger struct {
	_ struct{} `type:"structure"`

	// The user-specified reason the pipeline was stopped.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExecutionTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExecutionTrigger) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *StopExecutionTrigger) SetReason(v string) *StopExecutionTrigger {
	s.Reason = &v
	return s
}

type StopPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// Use this option to stop the pipeline execution by abandoning, rather than
	// finishing, in-progress actions.
	//
	// This option can lead to failed or out-of-sequence tasks.
	Abandon *bool `locationName:"abandon" type:"boolean"`

	// The ID of the pipeline execution to be stopped in the current stage. Use
	// the GetPipelineState action to retrieve the current pipelineExecutionId.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline to stop.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Use this option to enter comments, such as the reason the pipeline was stopped.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPipelineExecutionInput"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbandon sets the Abandon field's value.
func (s *StopPipelineExecutionInput) SetAbandon(v bool) *StopPipelineExecutionInput {
	s.Abandon = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StopPipelineExecutionInput) SetPipelineExecutionId(v string) *StopPipelineExecutionInput {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *StopPipelineExecutionInput) SetPipelineName(v string) *StopPipelineExecutionInput {
	s.PipelineName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopPipelineExecutionInput) SetReason(v string) *StopPipelineExecutionInput {
	s.Reason = &v
	return s
}

type StopPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the pipeline execution that was stopped.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StopPipelineExecutionOutput) SetPipelineExecutionId(v string) *StopPipelineExecutionOutput {
	s.PipelineExecutionId = &v
	return s
}

// Filter for pipeline executions that have successfully completed the stage
// in the current pipeline version.
type SucceededInStageFilter struct {
	_ struct{} `type:"structure"`

	// The name of the stage for filtering for pipeline executions where the stage
	// was successful in the current pipeline version.
	StageName *string `locationName:"stageName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SucceededInStageFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SucceededInStageFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SucceededInStageFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SucceededInStageFilter"}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStageName sets the StageName field's value.
func (s *SucceededInStageFilter) SetStageName(v string) *SucceededInStageFilter {
	s.StageName = &v
	return s
}

// A tag is a key-value pair that is used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The tags you want to modify or add to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A response to a PollForThirdPartyJobs request returned by CodePipeline when
// there is a job to be worked on by a partner action.
type ThirdPartyJob struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientId *string `locationName:"clientId" type:"string"`

	// The identifier used to identify the job in CodePipeline.
	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJob) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *ThirdPartyJob) SetClientId(v string) *ThirdPartyJob {
	s.ClientId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ThirdPartyJob) SetJobId(v string) *ThirdPartyJob {
	s.JobId = &v
	return s
}

// Represents information about the job data for a partner action.
type ThirdPartyJobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an Amazon Web Services session credentials object. These credentials
	// are temporary credentials that are issued by Amazon Web Services Secure Token
	// Service (STS). They can be used to access input and output artifacts in the
	// S3 bucket used to store artifact for the pipeline in CodePipeline.
	//
	// ArtifactCredentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ThirdPartyJobData's
	// String and GoString methods.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure" sensitive:"true"`

	// A system-generated token, such as a CodeDeploy deployment ID, that a job
	// requires to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" min:"1" type:"string"`

	// The encryption key used to encrypt and decrypt data in the artifact store
	// for the pipeline, such as an Amazon Web Services Key Management Service (Amazon
	// Web Services KMS) key. This is optional and might not be present.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The name of the artifact that is worked on by the action, if any. This name
	// might be system-generated, such as "MyApp", or it might be defined by the
	// user when the action is created. The input artifact name must match the name
	// of an output artifact generated by an action in an earlier action or stage
	// of the pipeline.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The name of the artifact that is the result of the action, if any. This name
	// might be system-generated, such as "MyBuiltApp", or it might be defined by
	// the user when the action is created.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	//
	// Does not include pipelineArn and pipelineExecutionId for ThirdParty jobs.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJobData) GoString() string {
	return s.String()
}

// SetActionConfiguration sets the ActionConfiguration field's value.
func (s *ThirdPartyJobData) SetActionConfiguration(v *ActionConfiguration) *ThirdPartyJobData {
	s.ActionConfiguration = v
	return s
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *ThirdPartyJobData) SetActionTypeId(v *ActionTypeId) *ThirdPartyJobData {
	s.ActionTypeId = v
	return s
}

// SetArtifactCredentials sets the ArtifactCredentials field's value.
func (s *ThirdPartyJobData) SetArtifactCredentials(v *AWSSessionCredentials) *ThirdPartyJobData {
	s.ArtifactCredentials = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ThirdPartyJobData) SetContinuationToken(v string) *ThirdPartyJobData {
	s.ContinuationToken = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ThirdPartyJobData) SetEncryptionKey(v *EncryptionKey) *ThirdPartyJobData {
	s.EncryptionKey = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *ThirdPartyJobData) SetInputArtifacts(v []*Artifact) *ThirdPartyJobData {
	s.InputArtifacts = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *ThirdPartyJobData) SetOutputArtifacts(v []*Artifact) *ThirdPartyJobData {
	s.OutputArtifacts = v
	return s
}

// SetPipelineContext sets the PipelineContext field's value.
func (s *ThirdPartyJobData) SetPipelineContext(v *PipelineContext) *ThirdPartyJobData {
	s.PipelineContext = v
	return s
}

// The details of a job sent in response to a GetThirdPartyJobDetails request.
type ThirdPartyJobDetails struct {
	_ struct{} `type:"structure"`

	// The data to be returned by the third party job worker.
	Data *ThirdPartyJobData `locationName:"data" type:"structure"`

	// The identifier used to identify the job details in CodePipeline.
	Id *string `locationName:"id" min:"1" type:"string"`

	// A system-generated random number that CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Use this number in an AcknowledgeThirdPartyJob
	// request.
	Nonce *string `locationName:"nonce" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThirdPartyJobDetails) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ThirdPartyJobDetails) SetData(v *ThirdPartyJobData) *ThirdPartyJobDetails {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *ThirdPartyJobDetails) SetId(v string) *ThirdPartyJobDetails {
	s.Id = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *ThirdPartyJobDetails) SetNonce(v string) *ThirdPartyJobDetails {
	s.Nonce = &v
	return s
}

// The tags limit for a resource has been exceeded.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about the state of transitions between one stage and
// another stage.
type TransitionState struct {
	_ struct{} `type:"structure"`

	// The user-specified reason why the transition between two stages of a pipeline
	// was disabled.
	DisabledReason *string `locationName:"disabledReason" min:"1" type:"string"`

	// Whether the transition between stages is enabled (true) or disabled (false).
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The timestamp when the transition state was last changed.
	LastChangedAt *time.Time `locationName:"lastChangedAt" type:"timestamp"`

	// The ID of the user who last changed the transition state.
	LastChangedBy *string `locationName:"lastChangedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransitionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransitionState) GoString() string {
	return s.String()
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *TransitionState) SetDisabledReason(v string) *TransitionState {
	s.DisabledReason = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *TransitionState) SetEnabled(v bool) *TransitionState {
	s.Enabled = &v
	return s
}

// SetLastChangedAt sets the LastChangedAt field's value.
func (s *TransitionState) SetLastChangedAt(v time.Time) *TransitionState {
	s.LastChangedAt = &v
	return s
}

// SetLastChangedBy sets the LastChangedBy field's value.
func (s *TransitionState) SetLastChangedBy(v string) *TransitionState {
	s.LastChangedBy = &v
	return s
}

// Unable to roll back the stage. The cause might be if the pipeline version
// has changed since the target pipeline execution was deployed, the stage is
// currently running, or an incorrect target pipeline execution ID was provided.
type UnableToRollbackStageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnableToRollbackStageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnableToRollbackStageException) GoString() string {
	return s.String()
}

func newErrorUnableToRollbackStageException(v protocol.ResponseMetadata) error {
	return &UnableToRollbackStageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnableToRollbackStageException) Code() string {
	return "UnableToRollbackStageException"
}

// Message returns the exception's message.
func (s *UnableToRollbackStageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnableToRollbackStageException) OrigErr() error {
	return nil
}

func (s *UnableToRollbackStageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnableToRollbackStageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnableToRollbackStageException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The list of keys for the tags to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateActionTypeInput struct {
	_ struct{} `type:"structure"`

	// The action type definition for the action type to be updated.
	//
	// ActionType is a required field
	ActionType *ActionTypeDeclaration `locationName:"actionType" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateActionTypeInput"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.ActionType != nil {
		if err := s.ActionType.Validate(); err != nil {
			invalidParams.AddNested("ActionType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *UpdateActionTypeInput) SetActionType(v *ActionTypeDeclaration) *UpdateActionTypeInput {
	s.ActionType = v
	return s
}

type UpdateActionTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateActionTypeOutput) GoString() string {
	return s.String()
}

// Represents the input of an UpdatePipeline action.
type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to be updated.
	//
	// Pipeline is a required field
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineInput"}
	if s.Pipeline == nil {
		invalidParams.Add(request.NewErrParamRequired("Pipeline"))
	}
	if s.Pipeline != nil {
		if err := s.Pipeline.Validate(); err != nil {
			invalidParams.AddNested("Pipeline", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineInput) SetPipeline(v *PipelineDeclaration) *UpdatePipelineInput {
	s.Pipeline = v
	return s
}

// Represents the output of an UpdatePipeline action.
type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The structure of the updated pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineOutput) SetPipeline(v *PipelineDeclaration) *UpdatePipelineOutput {
	s.Pipeline = v
	return s
}

// The validation was specified in an invalid format.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The authentication applied to incoming webhook trigger requests.
type WebhookAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// The property used to configure acceptance of webhooks in an IP address range.
	// For IP, only the AllowedIPRange property must be set. This property must
	// be set to a valid CIDR range.
	AllowedIPRange *string `min:"1" type:"string"`

	// The property used to configure GitHub authentication. For GITHUB_HMAC, only
	// the SecretToken property must be set.
	SecretToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookAuthConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookAuthConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebhookAuthConfiguration"}
	if s.AllowedIPRange != nil && len(*s.AllowedIPRange) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedIPRange", 1))
	}
	if s.SecretToken != nil && len(*s.SecretToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedIPRange sets the AllowedIPRange field's value.
func (s *WebhookAuthConfiguration) SetAllowedIPRange(v string) *WebhookAuthConfiguration {
	s.AllowedIPRange = &v
	return s
}

// SetSecretToken sets the SecretToken field's value.
func (s *WebhookAuthConfiguration) SetSecretToken(v string) *WebhookAuthConfiguration {
	s.SecretToken = &v
	return s
}

// Represents information about a webhook and its definition.
type WebhookDefinition struct {
	_ struct{} `type:"structure"`

	// Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
	//
	//    * For information about the authentication scheme implemented by GITHUB_HMAC,
	//    see Securing your webhooks (https://developer.github.com/webhooks/securing/)
	//    on the GitHub Developer website.
	//
	//    * IP rejects webhooks trigger requests unless they originate from an IP
	//    address in the IP range whitelisted in the authentication configuration.
	//
	//    * UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.
	//
	// Authentication is a required field
	Authentication *string `locationName:"authentication" type:"string" required:"true" enum:"WebhookAuthenticationType"`

	// Properties that configure the authentication applied to incoming webhook
	// trigger requests. The required properties depend on the authentication type.
	// For GITHUB_HMAC, only the SecretToken property must be set. For IP, only
	// the AllowedIPRange property must be set to a valid CIDR range. For UNAUTHENTICATED,
	// no properties can be set.
	//
	// AuthenticationConfiguration is a required field
	AuthenticationConfiguration *WebhookAuthConfiguration `locationName:"authenticationConfiguration" type:"structure" required:"true"`

	// A list of rules applied to the body/payload sent in the POST request to a
	// webhook URL. All defined rules must pass for the request to be accepted and
	// the pipeline started.
	//
	// Filters is a required field
	Filters []*WebhookFilterRule `locationName:"filters" type:"list" required:"true"`

	// The name of the webhook.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the action in a pipeline you want to connect to the webhook.
	// The action must be from the source (first) stage of the pipeline.
	//
	// TargetAction is a required field
	TargetAction *string `locationName:"targetAction" min:"1" type:"string" required:"true"`

	// The name of the pipeline you want to connect to the webhook.
	//
	// TargetPipeline is a required field
	TargetPipeline *string `locationName:"targetPipeline" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebhookDefinition"}
	if s.Authentication == nil {
		invalidParams.Add(request.NewErrParamRequired("Authentication"))
	}
	if s.AuthenticationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationConfiguration"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TargetAction == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAction"))
	}
	if s.TargetAction != nil && len(*s.TargetAction) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAction", 1))
	}
	if s.TargetPipeline == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetPipeline"))
	}
	if s.TargetPipeline != nil && len(*s.TargetPipeline) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetPipeline", 1))
	}
	if s.AuthenticationConfiguration != nil {
		if err := s.AuthenticationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthentication sets the Authentication field's value.
func (s *WebhookDefinition) SetAuthentication(v string) *WebhookDefinition {
	s.Authentication = &v
	return s
}

// SetAuthenticationConfiguration sets the AuthenticationConfiguration field's value.
func (s *WebhookDefinition) SetAuthenticationConfiguration(v *WebhookAuthConfiguration) *WebhookDefinition {
	s.AuthenticationConfiguration = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *WebhookDefinition) SetFilters(v []*WebhookFilterRule) *WebhookDefinition {
	s.Filters = v
	return s
}

// SetName sets the Name field's value.
func (s *WebhookDefinition) SetName(v string) *WebhookDefinition {
	s.Name = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *WebhookDefinition) SetTargetAction(v string) *WebhookDefinition {
	s.TargetAction = &v
	return s
}

// SetTargetPipeline sets the TargetPipeline field's value.
func (s *WebhookDefinition) SetTargetPipeline(v string) *WebhookDefinition {
	s.TargetPipeline = &v
	return s
}

// The event criteria that specify when a webhook notification is sent to your
// URL.
type WebhookFilterRule struct {
	_ struct{} `type:"structure"`

	// A JsonPath expression that is applied to the body/payload of the webhook.
	// The value selected by the JsonPath expression must match the value specified
	// in the MatchEquals field. Otherwise, the request is ignored. For more information,
	// see Java JsonPath implementation (https://github.com/json-path/JsonPath)
	// in GitHub.
	//
	// JsonPath is a required field
	JsonPath *string `locationName:"jsonPath" min:"1" type:"string" required:"true"`

	// The value selected by the JsonPath expression must match what is supplied
	// in the MatchEquals field. Otherwise, the request is ignored. Properties from
	// the target action configuration can be included as placeholders in this value
	// by surrounding the action configuration key with curly brackets. For example,
	// if the value supplied here is "refs/heads/{Branch}" and the target action
	// has an action configuration property called "Branch" with a value of "main",
	// the MatchEquals value is evaluated as "refs/heads/main". For a list of action
	// configuration properties for built-in action types, see Pipeline Structure
	// Reference Action Requirements (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	MatchEquals *string `locationName:"matchEquals" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookFilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookFilterRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebhookFilterRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebhookFilterRule"}
	if s.JsonPath == nil {
		invalidParams.Add(request.NewErrParamRequired("JsonPath"))
	}
	if s.JsonPath != nil && len(*s.JsonPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JsonPath", 1))
	}
	if s.MatchEquals != nil && len(*s.MatchEquals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchEquals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonPath sets the JsonPath field's value.
func (s *WebhookFilterRule) SetJsonPath(v string) *WebhookFilterRule {
	s.JsonPath = &v
	return s
}

// SetMatchEquals sets the MatchEquals field's value.
func (s *WebhookFilterRule) SetMatchEquals(v string) *WebhookFilterRule {
	s.MatchEquals = &v
	return s
}

// The specified webhook was entered in an invalid format or cannot be found.
type WebhookNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebhookNotFoundException) GoString() string {
	return s.String()
}

func newErrorWebhookNotFoundException(v protocol.ResponseMetadata) error {
	return &WebhookNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WebhookNotFoundException) Code() string {
	return "WebhookNotFoundException"
}

// Message returns the exception's message.
func (s *WebhookNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WebhookNotFoundException) OrigErr() error {
	return nil
}

func (s *WebhookNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WebhookNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WebhookNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ActionCategorySource is a ActionCategory enum value
	ActionCategorySource = "Source"

	// ActionCategoryBuild is a ActionCategory enum value
	ActionCategoryBuild = "Build"

	// ActionCategoryDeploy is a ActionCategory enum value
	ActionCategoryDeploy = "Deploy"

	// ActionCategoryTest is a ActionCategory enum value
	ActionCategoryTest = "Test"

	// ActionCategoryInvoke is a ActionCategory enum value
	ActionCategoryInvoke = "Invoke"

	// ActionCategoryApproval is a ActionCategory enum value
	ActionCategoryApproval = "Approval"
)

// ActionCategory_Values returns all elements of the ActionCategory enum
func ActionCategory_Values() []string {
	return []string{
		ActionCategorySource,
		ActionCategoryBuild,
		ActionCategoryDeploy,
		ActionCategoryTest,
		ActionCategoryInvoke,
		ActionCategoryApproval,
	}
}

const (
	// ActionConfigurationPropertyTypeString is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeString = "String"

	// ActionConfigurationPropertyTypeNumber is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeNumber = "Number"

	// ActionConfigurationPropertyTypeBoolean is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeBoolean = "Boolean"
)

// ActionConfigurationPropertyType_Values returns all elements of the ActionConfigurationPropertyType enum
func ActionConfigurationPropertyType_Values() []string {
	return []string{
		ActionConfigurationPropertyTypeString,
		ActionConfigurationPropertyTypeNumber,
		ActionConfigurationPropertyTypeBoolean,
	}
}

const (
	// ActionExecutionStatusInProgress is a ActionExecutionStatus enum value
	ActionExecutionStatusInProgress = "InProgress"

	// ActionExecutionStatusAbandoned is a ActionExecutionStatus enum value
	ActionExecutionStatusAbandoned = "Abandoned"

	// ActionExecutionStatusSucceeded is a ActionExecutionStatus enum value
	ActionExecutionStatusSucceeded = "Succeeded"

	// ActionExecutionStatusFailed is a ActionExecutionStatus enum value
	ActionExecutionStatusFailed = "Failed"
)

// ActionExecutionStatus_Values returns all elements of the ActionExecutionStatus enum
func ActionExecutionStatus_Values() []string {
	return []string{
		ActionExecutionStatusInProgress,
		ActionExecutionStatusAbandoned,
		ActionExecutionStatusSucceeded,
		ActionExecutionStatusFailed,
	}
}

const (
	// ActionOwnerAws is a ActionOwner enum value
	ActionOwnerAws = "AWS"

	// ActionOwnerThirdParty is a ActionOwner enum value
	ActionOwnerThirdParty = "ThirdParty"

	// ActionOwnerCustom is a ActionOwner enum value
	ActionOwnerCustom = "Custom"
)

// ActionOwner_Values returns all elements of the ActionOwner enum
func ActionOwner_Values() []string {
	return []string{
		ActionOwnerAws,
		ActionOwnerThirdParty,
		ActionOwnerCustom,
	}
}

const (
	// ApprovalStatusApproved is a ApprovalStatus enum value
	ApprovalStatusApproved = "Approved"

	// ApprovalStatusRejected is a ApprovalStatus enum value
	ApprovalStatusRejected = "Rejected"
)

// ApprovalStatus_Values returns all elements of the ApprovalStatus enum
func ApprovalStatus_Values() []string {
	return []string{
		ApprovalStatusApproved,
		ApprovalStatusRejected,
	}
}

const (
	// ArtifactLocationTypeS3 is a ArtifactLocationType enum value
	ArtifactLocationTypeS3 = "S3"
)

// ArtifactLocationType_Values returns all elements of the ArtifactLocationType enum
func ArtifactLocationType_Values() []string {
	return []string{
		ArtifactLocationTypeS3,
	}
}

const (
	// ArtifactStoreTypeS3 is a ArtifactStoreType enum value
	ArtifactStoreTypeS3 = "S3"
)

// ArtifactStoreType_Values returns all elements of the ArtifactStoreType enum
func ArtifactStoreType_Values() []string {
	return []string{
		ArtifactStoreTypeS3,
	}
}

const (
	// BlockerTypeSchedule is a BlockerType enum value
	BlockerTypeSchedule = "Schedule"
)

// BlockerType_Values returns all elements of the BlockerType enum
func BlockerType_Values() []string {
	return []string{
		BlockerTypeSchedule,
	}
}

const (
	// EncryptionKeyTypeKms is a EncryptionKeyType enum value
	EncryptionKeyTypeKms = "KMS"
)

// EncryptionKeyType_Values returns all elements of the EncryptionKeyType enum
func EncryptionKeyType_Values() []string {
	return []string{
		EncryptionKeyTypeKms,
	}
}

const (
	// ExecutionModeQueued is a ExecutionMode enum value
	ExecutionModeQueued = "QUEUED"

	// ExecutionModeSuperseded is a ExecutionMode enum value
	ExecutionModeSuperseded = "SUPERSEDED"

	// ExecutionModeParallel is a ExecutionMode enum value
	ExecutionModeParallel = "PARALLEL"
)

// ExecutionMode_Values returns all elements of the ExecutionMode enum
func ExecutionMode_Values() []string {
	return []string{
		ExecutionModeQueued,
		ExecutionModeSuperseded,
		ExecutionModeParallel,
	}
}

const (
	// ExecutionTypeStandard is a ExecutionType enum value
	ExecutionTypeStandard = "STANDARD"

	// ExecutionTypeRollback is a ExecutionType enum value
	ExecutionTypeRollback = "ROLLBACK"
)

// ExecutionType_Values returns all elements of the ExecutionType enum
func ExecutionType_Values() []string {
	return []string{
		ExecutionTypeStandard,
		ExecutionTypeRollback,
	}
}

const (
	// ExecutorTypeJobWorker is a ExecutorType enum value
	ExecutorTypeJobWorker = "JobWorker"

	// ExecutorTypeLambda is a ExecutorType enum value
	ExecutorTypeLambda = "Lambda"
)

// ExecutorType_Values returns all elements of the ExecutorType enum
func ExecutorType_Values() []string {
	return []string{
		ExecutorTypeJobWorker,
		ExecutorTypeLambda,
	}
}

const (
	// FailureTypeJobFailed is a FailureType enum value
	FailureTypeJobFailed = "JobFailed"

	// FailureTypeConfigurationError is a FailureType enum value
	FailureTypeConfigurationError = "ConfigurationError"

	// FailureTypePermissionError is a FailureType enum value
	FailureTypePermissionError = "PermissionError"

	// FailureTypeRevisionOutOfSync is a FailureType enum value
	FailureTypeRevisionOutOfSync = "RevisionOutOfSync"

	// FailureTypeRevisionUnavailable is a FailureType enum value
	FailureTypeRevisionUnavailable = "RevisionUnavailable"

	// FailureTypeSystemUnavailable is a FailureType enum value
	FailureTypeSystemUnavailable = "SystemUnavailable"
)

// FailureType_Values returns all elements of the FailureType enum
func FailureType_Values() []string {
	return []string{
		FailureTypeJobFailed,
		FailureTypeConfigurationError,
		FailureTypePermissionError,
		FailureTypeRevisionOutOfSync,
		FailureTypeRevisionUnavailable,
		FailureTypeSystemUnavailable,
	}
}

const (
	// GitPullRequestEventTypeOpen is a GitPullRequestEventType enum value
	GitPullRequestEventTypeOpen = "OPEN"

	// GitPullRequestEventTypeUpdated is a GitPullRequestEventType enum value
	GitPullRequestEventTypeUpdated = "UPDATED"

	// GitPullRequestEventTypeClosed is a GitPullRequestEventType enum value
	GitPullRequestEventTypeClosed = "CLOSED"
)

// GitPullRequestEventType_Values returns all elements of the GitPullRequestEventType enum
func GitPullRequestEventType_Values() []string {
	return []string{
		GitPullRequestEventTypeOpen,
		GitPullRequestEventTypeUpdated,
		GitPullRequestEventTypeClosed,
	}
}

const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "Created"

	// JobStatusQueued is a JobStatus enum value
	JobStatusQueued = "Queued"

	// JobStatusDispatched is a JobStatus enum value
	JobStatusDispatched = "Dispatched"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "InProgress"

	// JobStatusTimedOut is a JobStatus enum value
	JobStatusTimedOut = "TimedOut"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "Succeeded"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "Failed"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusCreated,
		JobStatusQueued,
		JobStatusDispatched,
		JobStatusInProgress,
		JobStatusTimedOut,
		JobStatusSucceeded,
		JobStatusFailed,
	}
}

const (
	// PipelineExecutionStatusCancelled is a PipelineExecutionStatus enum value
	PipelineExecutionStatusCancelled = "Cancelled"

	// PipelineExecutionStatusInProgress is a PipelineExecutionStatus enum value
	PipelineExecutionStatusInProgress = "InProgress"

	// PipelineExecutionStatusStopped is a PipelineExecutionStatus enum value
	PipelineExecutionStatusStopped = "Stopped"

	// PipelineExecutionStatusStopping is a PipelineExecutionStatus enum value
	PipelineExecutionStatusStopping = "Stopping"

	// PipelineExecutionStatusSucceeded is a PipelineExecutionStatus enum value
	PipelineExecutionStatusSucceeded = "Succeeded"

	// PipelineExecutionStatusSuperseded is a PipelineExecutionStatus enum value
	PipelineExecutionStatusSuperseded = "Superseded"

	// PipelineExecutionStatusFailed is a PipelineExecutionStatus enum value
	PipelineExecutionStatusFailed = "Failed"
)

// PipelineExecutionStatus_Values returns all elements of the PipelineExecutionStatus enum
func PipelineExecutionStatus_Values() []string {
	return []string{
		PipelineExecutionStatusCancelled,
		PipelineExecutionStatusInProgress,
		PipelineExecutionStatusStopped,
		PipelineExecutionStatusStopping,
		PipelineExecutionStatusSucceeded,
		PipelineExecutionStatusSuperseded,
		PipelineExecutionStatusFailed,
	}
}

const (
	// PipelineTriggerProviderTypeCodeStarSourceConnection is a PipelineTriggerProviderType enum value
	PipelineTriggerProviderTypeCodeStarSourceConnection = "CodeStarSourceConnection"
)

// PipelineTriggerProviderType_Values returns all elements of the PipelineTriggerProviderType enum
func PipelineTriggerProviderType_Values() []string {
	return []string{
		PipelineTriggerProviderTypeCodeStarSourceConnection,
	}
}

const (
	// PipelineTypeV1 is a PipelineType enum value
	PipelineTypeV1 = "V1"

	// PipelineTypeV2 is a PipelineType enum value
	PipelineTypeV2 = "V2"
)

// PipelineType_Values returns all elements of the PipelineType enum
func PipelineType_Values() []string {
	return []string{
		PipelineTypeV1,
		PipelineTypeV2,
	}
}

const (
	// ResultRollback is a Result enum value
	ResultRollback = "ROLLBACK"
)

// Result_Values returns all elements of the Result enum
func Result_Values() []string {
	return []string{
		ResultRollback,
	}
}

const (
	// SourceRevisionTypeCommitId is a SourceRevisionType enum value
	SourceRevisionTypeCommitId = "COMMIT_ID"

	// SourceRevisionTypeImageDigest is a SourceRevisionType enum value
	SourceRevisionTypeImageDigest = "IMAGE_DIGEST"

	// SourceRevisionTypeS3ObjectVersionId is a SourceRevisionType enum value
	SourceRevisionTypeS3ObjectVersionId = "S3_OBJECT_VERSION_ID"
)

// SourceRevisionType_Values returns all elements of the SourceRevisionType enum
func SourceRevisionType_Values() []string {
	return []string{
		SourceRevisionTypeCommitId,
		SourceRevisionTypeImageDigest,
		SourceRevisionTypeS3ObjectVersionId,
	}
}

const (
	// StageExecutionStatusCancelled is a StageExecutionStatus enum value
	StageExecutionStatusCancelled = "Cancelled"

	// StageExecutionStatusInProgress is a StageExecutionStatus enum value
	StageExecutionStatusInProgress = "InProgress"

	// StageExecutionStatusFailed is a StageExecutionStatus enum value
	StageExecutionStatusFailed = "Failed"

	// StageExecutionStatusStopped is a StageExecutionStatus enum value
	StageExecutionStatusStopped = "Stopped"

	// StageExecutionStatusStopping is a StageExecutionStatus enum value
	StageExecutionStatusStopping = "Stopping"

	// StageExecutionStatusSucceeded is a StageExecutionStatus enum value
	StageExecutionStatusSucceeded = "Succeeded"
)

// StageExecutionStatus_Values returns all elements of the StageExecutionStatus enum
func StageExecutionStatus_Values() []string {
	return []string{
		StageExecutionStatusCancelled,
		StageExecutionStatusInProgress,
		StageExecutionStatusFailed,
		StageExecutionStatusStopped,
		StageExecutionStatusStopping,
		StageExecutionStatusSucceeded,
	}
}

const (
	// StageRetryModeFailedActions is a StageRetryMode enum value
	StageRetryModeFailedActions = "FAILED_ACTIONS"

	// StageRetryModeAllActions is a StageRetryMode enum value
	StageRetryModeAllActions = "ALL_ACTIONS"
)

// StageRetryMode_Values returns all elements of the StageRetryMode enum
func StageRetryMode_Values() []string {
	return []string{
		StageRetryModeFailedActions,
		StageRetryModeAllActions,
	}
}

const (
	// StageTransitionTypeInbound is a StageTransitionType enum value
	StageTransitionTypeInbound = "Inbound"

	// StageTransitionTypeOutbound is a StageTransitionType enum value
	StageTransitionTypeOutbound = "Outbound"
)

// StageTransitionType_Values returns all elements of the StageTransitionType enum
func StageTransitionType_Values() []string {
	return []string{
		StageTransitionTypeInbound,
		StageTransitionTypeOutbound,
	}
}

const (
	// StartTimeRangeLatest is a StartTimeRange enum value
	StartTimeRangeLatest = "Latest"

	// StartTimeRangeAll is a StartTimeRange enum value
	StartTimeRangeAll = "All"
)

// StartTimeRange_Values returns all elements of the StartTimeRange enum
func StartTimeRange_Values() []string {
	return []string{
		StartTimeRangeLatest,
		StartTimeRangeAll,
	}
}

const (
	// TriggerTypeCreatePipeline is a TriggerType enum value
	TriggerTypeCreatePipeline = "CreatePipeline"

	// TriggerTypeStartPipelineExecution is a TriggerType enum value
	TriggerTypeStartPipelineExecution = "StartPipelineExecution"

	// TriggerTypePollForSourceChanges is a TriggerType enum value
	TriggerTypePollForSourceChanges = "PollForSourceChanges"

	// TriggerTypeWebhook is a TriggerType enum value
	TriggerTypeWebhook = "Webhook"

	// TriggerTypeCloudWatchEvent is a TriggerType enum value
	TriggerTypeCloudWatchEvent = "CloudWatchEvent"

	// TriggerTypePutActionRevision is a TriggerType enum value
	TriggerTypePutActionRevision = "PutActionRevision"

	// TriggerTypeWebhookV2 is a TriggerType enum value
	TriggerTypeWebhookV2 = "WebhookV2"

	// TriggerTypeManualRollback is a TriggerType enum value
	TriggerTypeManualRollback = "ManualRollback"

	// TriggerTypeAutomatedRollback is a TriggerType enum value
	TriggerTypeAutomatedRollback = "AutomatedRollback"
)

// TriggerType_Values returns all elements of the TriggerType enum
func TriggerType_Values() []string {
	return []string{
		TriggerTypeCreatePipeline,
		TriggerTypeStartPipelineExecution,
		TriggerTypePollForSourceChanges,
		TriggerTypeWebhook,
		TriggerTypeCloudWatchEvent,
		TriggerTypePutActionRevision,
		TriggerTypeWebhookV2,
		TriggerTypeManualRollback,
		TriggerTypeAutomatedRollback,
	}
}

const (
	// WebhookAuthenticationTypeGithubHmac is a WebhookAuthenticationType enum value
	WebhookAuthenticationTypeGithubHmac = "GITHUB_HMAC"

	// WebhookAuthenticationTypeIp is a WebhookAuthenticationType enum value
	WebhookAuthenticationTypeIp = "IP"

	// WebhookAuthenticationTypeUnauthenticated is a WebhookAuthenticationType enum value
	WebhookAuthenticationTypeUnauthenticated = "UNAUTHENTICATED"
)

// WebhookAuthenticationType_Values returns all elements of the WebhookAuthenticationType enum
func WebhookAuthenticationType_Values() []string {
	return []string{
		WebhookAuthenticationTypeGithubHmac,
		WebhookAuthenticationTypeIp,
		WebhookAuthenticationTypeUnauthenticated,
	}
}
