// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrockagentruntime

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opInvokeAgent = "InvokeAgent"

// InvokeAgentRequest generates a "aws/request.Request" representing the
// client's request for the InvokeAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeAgent for more information on using the InvokeAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InvokeAgentRequest method.
//	req, resp := client.InvokeAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent
func (c *BedrockAgentRuntime) InvokeAgentRequest(input *InvokeAgentInput) (req *request.Request, output *InvokeAgentOutput) {
	op := &request.Operation{
		Name:       opInvokeAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentAliases/{agentAliasId}/sessions/{sessionId}/text",
	}

	if input == nil {
		input = &InvokeAgentInput{}
	}

	output = &InvokeAgentOutput{}
	req = c.newRequest(op, input, output)

	es := NewInvokeAgentEventStream()
	output.eventStream = es

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// InvokeAgent API operation for Agents for Amazon Bedrock Runtime.
//
// The CLI doesn't support InvokeAgent.
//
// Sends a prompt for the agent to process and respond to. Note the following
// fields for the request:
//
//   - To continue the same conversation with an agent, use the same sessionId
//     value in the request.
//
//   - To activate trace enablement, turn enableTrace to true. Trace enablement
//     helps you follow the agent's reasoning process that led it to the information
//     it processed, the actions it took, and the final result it yielded. For
//     more information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events).
//
//   - End a conversation by setting endSession to true.
//
//   - In the sessionState object, you can include attributes for the session
//     or prompt or, if you configured an action group to return control, results
//     from invocation of the action group.
//
// The response is returned in the bytes field of the chunk object.
//
//   - The attribution object contains citations for parts of the response.
//
//   - If you set enableTrace to true in the request, you can trace the agent's
//     steps and reasoning process that led it to the response.
//
//   - If the action predicted was configured to return control, the response
//     returns parameters for the action, elicited from the user, in the returnControl
//     field.
//
//   - Errors are also surfaced in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation InvokeAgent for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     There was a conflict performing an operation. Resolve the conflict and retry
//     your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - DependencyFailedException
//     There was an issue with a dependency. Check the resource configurations and
//     retry the request.
//
//   - BadGatewayException
//     There was an issue with a dependency due to a server issue. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions. Check your permissions
//     and retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent
func (c *BedrockAgentRuntime) InvokeAgent(input *InvokeAgentInput) (*InvokeAgentOutput, error) {
	req, out := c.InvokeAgentRequest(input)
	return out, req.Send()
}

// InvokeAgentWithContext is the same as InvokeAgent with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) InvokeAgentWithContext(ctx aws.Context, input *InvokeAgentInput, opts ...request.Option) (*InvokeAgentOutput, error) {
	req, out := c.InvokeAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// InvokeAgentEventStream provides the event stream handling for the InvokeAgent.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeAgentEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeAgentEventStream struct {

	// Reader is the EventStream reader for the ResponseStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader ResponseStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewInvokeAgentEventStream initializes an InvokeAgentEventStream.
// This function should only be used for testing and mocking the InvokeAgentEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewInvokeAgentEventStream(func(o *InvokeAgentEventStream){
//	    es.Reader = myMockStreamReader
//	})
func NewInvokeAgentEventStream(opts ...func(*InvokeAgentEventStream)) *InvokeAgentEventStream {
	es := &InvokeAgentEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *InvokeAgentEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *InvokeAgentEventStream) waitStreamPartClose() {
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - PayloadPart
//   - ReturnControlPayload
//   - TracePart
//   - ResponseStreamUnknownEvent
func (es *InvokeAgentEventStream) Events() <-chan ResponseStreamEvent {
	return es.Reader.Events()
}

func (es *InvokeAgentEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForResponseStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadResponseStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *InvokeAgentEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeAgentEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *InvokeAgentEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opRetrieve = "Retrieve"

// RetrieveRequest generates a "aws/request.Request" representing the
// client's request for the Retrieve operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Retrieve for more information on using the Retrieve
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetrieveRequest method.
//	req, resp := client.RetrieveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve
func (c *BedrockAgentRuntime) RetrieveRequest(input *RetrieveInput) (req *request.Request, output *RetrieveOutput) {
	op := &request.Operation{
		Name:       opRetrieve,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/retrieve",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &RetrieveInput{}
	}

	output = &RetrieveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Retrieve API operation for Agents for Amazon Bedrock Runtime.
//
// Queries a knowledge base and retrieves information from it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation Retrieve for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     There was a conflict performing an operation. Resolve the conflict and retry
//     your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - DependencyFailedException
//     There was an issue with a dependency. Check the resource configurations and
//     retry the request.
//
//   - BadGatewayException
//     There was an issue with a dependency due to a server issue. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions. Check your permissions
//     and retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve
func (c *BedrockAgentRuntime) Retrieve(input *RetrieveInput) (*RetrieveOutput, error) {
	req, out := c.RetrieveRequest(input)
	return out, req.Send()
}

// RetrieveWithContext is the same as Retrieve with the addition of
// the ability to pass a context and additional request options.
//
// See Retrieve for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrieveWithContext(ctx aws.Context, input *RetrieveInput, opts ...request.Option) (*RetrieveOutput, error) {
	req, out := c.RetrieveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// RetrievePages iterates over the pages of a Retrieve operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Retrieve method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a Retrieve operation.
//	pageNum := 0
//	err := client.RetrievePages(params,
//	    func(page *bedrockagentruntime.RetrieveOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgentRuntime) RetrievePages(input *RetrieveInput, fn func(*RetrieveOutput, bool) bool) error {
	return c.RetrievePagesWithContext(aws.BackgroundContext(), input, fn)
}

// RetrievePagesWithContext same as RetrievePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrievePagesWithContext(ctx aws.Context, input *RetrieveInput, fn func(*RetrieveOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *RetrieveInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.RetrieveRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*RetrieveOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRetrieveAndGenerate = "RetrieveAndGenerate"

// RetrieveAndGenerateRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveAndGenerate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetrieveAndGenerate for more information on using the RetrieveAndGenerate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetrieveAndGenerateRequest method.
//	req, resp := client.RetrieveAndGenerateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate
func (c *BedrockAgentRuntime) RetrieveAndGenerateRequest(input *RetrieveAndGenerateInput) (req *request.Request, output *RetrieveAndGenerateOutput) {
	op := &request.Operation{
		Name:       opRetrieveAndGenerate,
		HTTPMethod: "POST",
		HTTPPath:   "/retrieveAndGenerate",
	}

	if input == nil {
		input = &RetrieveAndGenerateInput{}
	}

	output = &RetrieveAndGenerateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveAndGenerate API operation for Agents for Amazon Bedrock Runtime.
//
// Queries a knowledge base and generates responses based on the retrieved results.
// The response only cites sources that are relevant to the query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation RetrieveAndGenerate for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     There was a conflict performing an operation. Resolve the conflict and retry
//     your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - DependencyFailedException
//     There was an issue with a dependency. Check the resource configurations and
//     retry the request.
//
//   - BadGatewayException
//     There was an issue with a dependency due to a server issue. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions. Check your permissions
//     and retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate
func (c *BedrockAgentRuntime) RetrieveAndGenerate(input *RetrieveAndGenerateInput) (*RetrieveAndGenerateOutput, error) {
	req, out := c.RetrieveAndGenerateRequest(input)
	return out, req.Send()
}

// RetrieveAndGenerateWithContext is the same as RetrieveAndGenerate with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveAndGenerate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrieveAndGenerateWithContext(ctx aws.Context, input *RetrieveAndGenerateInput, opts ...request.Option) (*RetrieveAndGenerateOutput, error) {
	req, out := c.RetrieveAndGenerateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request is denied because of missing access permissions. Check your permissions
// and retry your request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

// The AccessDeniedException is and event in the ResponseStream group of events.
func (s *AccessDeniedException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AccessDeniedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the action group being invoked. For more information
// about the possible structures, see the InvocationInput tab in OrchestrationTrace
// (https://docs.aws.amazon.com/bedrock/latest/userguide/trace-orchestration.html)
// in the Amazon Bedrock User Guide.
type ActionGroupInvocationInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the action group.
	//
	// ActionGroupName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	ActionGroupName *string `locationName:"actionGroupName" type:"string" sensitive:"true"`

	// The path to the API to call, based off the action group.
	//
	// ApiPath is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	ApiPath *string `locationName:"apiPath" type:"string" sensitive:"true"`

	// The function in the action group to call.
	//
	// Function is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	Function *string `locationName:"function" type:"string" sensitive:"true"`

	// The parameters in the Lambda input event.
	Parameters []*Parameter `locationName:"parameters" type:"list"`

	// The parameters in the request body for the Lambda input event.
	RequestBody *RequestBody `locationName:"requestBody" type:"structure"`

	// The API method being used, based off the action group.
	//
	// Verb is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	Verb *string `locationName:"verb" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *ActionGroupInvocationInput_) SetActionGroupName(v string) *ActionGroupInvocationInput_ {
	s.ActionGroupName = &v
	return s
}

// SetApiPath sets the ApiPath field's value.
func (s *ActionGroupInvocationInput_) SetApiPath(v string) *ActionGroupInvocationInput_ {
	s.ApiPath = &v
	return s
}

// SetFunction sets the Function field's value.
func (s *ActionGroupInvocationInput_) SetFunction(v string) *ActionGroupInvocationInput_ {
	s.Function = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ActionGroupInvocationInput_) SetParameters(v []*Parameter) *ActionGroupInvocationInput_ {
	s.Parameters = v
	return s
}

// SetRequestBody sets the RequestBody field's value.
func (s *ActionGroupInvocationInput_) SetRequestBody(v *RequestBody) *ActionGroupInvocationInput_ {
	s.RequestBody = v
	return s
}

// SetVerb sets the Verb field's value.
func (s *ActionGroupInvocationInput_) SetVerb(v string) *ActionGroupInvocationInput_ {
	s.Verb = &v
	return s
}

// Contains the JSON-formatted string returned by the API invoked by the action
// group.
type ActionGroupInvocationOutput_ struct {
	_ struct{} `type:"structure"`

	// The JSON-formatted string returned by the API invoked by the action group.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationOutput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationOutput_) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *ActionGroupInvocationOutput_) SetText(v string) *ActionGroupInvocationOutput_ {
	s.Text = &v
	return s
}

// Contains information about the API operation that the agent predicts should
// be called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type ApiInvocationInput_ struct {
	_ struct{} `type:"structure"`

	// The action group that the API operation belongs to.
	//
	// ActionGroup is a required field
	ActionGroup *string `locationName:"actionGroup" type:"string" required:"true"`

	// The path to the API operation.
	//
	// ApiPath is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ApiInvocationInput_'s
	// String and GoString methods.
	ApiPath *string `locationName:"apiPath" type:"string" sensitive:"true"`

	// The HTTP method of the API operation.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// The parameters to provide for the API request, as the agent elicited from
	// the user.
	Parameters []*ApiParameter `locationName:"parameters" type:"list"`

	// The request body to provide for the API request, as the agent elicited from
	// the user.
	RequestBody *ApiRequestBody `locationName:"requestBody" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiInvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroup sets the ActionGroup field's value.
func (s *ApiInvocationInput_) SetActionGroup(v string) *ApiInvocationInput_ {
	s.ActionGroup = &v
	return s
}

// SetApiPath sets the ApiPath field's value.
func (s *ApiInvocationInput_) SetApiPath(v string) *ApiInvocationInput_ {
	s.ApiPath = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *ApiInvocationInput_) SetHttpMethod(v string) *ApiInvocationInput_ {
	s.HttpMethod = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ApiInvocationInput_) SetParameters(v []*ApiParameter) *ApiInvocationInput_ {
	s.Parameters = v
	return s
}

// SetRequestBody sets the RequestBody field's value.
func (s *ApiInvocationInput_) SetRequestBody(v *ApiRequestBody) *ApiInvocationInput_ {
	s.RequestBody = v
	return s
}

// Information about a parameter to provide to the API request.
//
// This data type is used in the following API operations:
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type ApiParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	Name *string `locationName:"name" type:"string"`

	// The data type for the parameter.
	Type *string `locationName:"type" type:"string"`

	// The value of the parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiParameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ApiParameter) SetName(v string) *ApiParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ApiParameter) SetType(v string) *ApiParameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ApiParameter) SetValue(v string) *ApiParameter {
	s.Value = &v
	return s
}

// The request body to provide for the API request, as the agent elicited from
// the user.
//
// This data type is used in the following API operations:
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type ApiRequestBody struct {
	_ struct{} `type:"structure"`

	// The content of the request body. The key of the object in this field is a
	// media type defining the format of the request body.
	Content map[string]*PropertyParameters `locationName:"content" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiRequestBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiRequestBody) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ApiRequestBody) SetContent(v map[string]*PropertyParameters) *ApiRequestBody {
	s.Content = v
	return s
}

// Contains information about the API operation that was called from the action
// group and the response body that was returned.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults of the InvokeAgent request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax)
type ApiResult struct {
	_ struct{} `type:"structure"`

	// The action group that the API operation belongs to.
	//
	// ActionGroup is a required field
	ActionGroup *string `locationName:"actionGroup" type:"string" required:"true"`

	// The path to the API operation.
	//
	// ApiPath is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ApiResult's
	// String and GoString methods.
	ApiPath *string `locationName:"apiPath" type:"string" sensitive:"true"`

	// The HTTP method for the API operation.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// http status code from API execution response (for example: 200, 400, 500).
	HttpStatusCode *int64 `locationName:"httpStatusCode" type:"integer"`

	// The response body from the API operation. The key of the object is the content
	// type (currently, only TEXT is supported). The response may be returned directly
	// or from the Lambda function.
	ResponseBody map[string]*ContentBody `locationName:"responseBody" type:"map"`

	// Controls the final response state returned to end user when API/Function
	// execution failed. When this state is FAILURE, the request would fail with
	// dependency failure exception. When this state is REPROMPT, the API/function
	// response will be sent to model for re-prompt
	ResponseState *string `locationName:"responseState" type:"string" enum:"ResponseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiResult) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApiResult) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApiResult"}
	if s.ActionGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroup sets the ActionGroup field's value.
func (s *ApiResult) SetActionGroup(v string) *ApiResult {
	s.ActionGroup = &v
	return s
}

// SetApiPath sets the ApiPath field's value.
func (s *ApiResult) SetApiPath(v string) *ApiResult {
	s.ApiPath = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *ApiResult) SetHttpMethod(v string) *ApiResult {
	s.HttpMethod = &v
	return s
}

// SetHttpStatusCode sets the HttpStatusCode field's value.
func (s *ApiResult) SetHttpStatusCode(v int64) *ApiResult {
	s.HttpStatusCode = &v
	return s
}

// SetResponseBody sets the ResponseBody field's value.
func (s *ApiResult) SetResponseBody(v map[string]*ContentBody) *ApiResult {
	s.ResponseBody = v
	return s
}

// SetResponseState sets the ResponseState field's value.
func (s *ApiResult) SetResponseState(v string) *ApiResult {
	s.ResponseState = &v
	return s
}

// Contains citations for a part of an agent response.
type Attribution struct {
	_ struct{} `type:"structure"`

	// A list of citations and related information for a part of an agent response.
	Citations []*Citation `locationName:"citations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribution) GoString() string {
	return s.String()
}

// SetCitations sets the Citations field's value.
func (s *Attribution) SetCitations(v []*Citation) *Attribution {
	s.Citations = v
	return s
}

// There was an issue with a dependency due to a server issue. Retry your request.
type BadGatewayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the dependency that caused the issue, such as Amazon Bedrock,
	// Lambda, or STS.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) GoString() string {
	return s.String()
}

// The BadGatewayException is and event in the ResponseStream group of events.
func (s *BadGatewayException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the BadGatewayException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorBadGatewayException(v protocol.ResponseMetadata) error {
	return &BadGatewayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadGatewayException) Code() string {
	return "BadGatewayException"
}

// Message returns the exception's message.
func (s *BadGatewayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadGatewayException) OrigErr() error {
	return nil
}

func (s *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadGatewayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadGatewayException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This property contains the document to chat with, along with its attributes.
type ByteContentDoc struct {
	_ struct{} `type:"structure"`

	// The MIME type of the document contained in the wrapper object.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The byte value of the file to upload, encoded as a Base-64 string.
	//
	// Data is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ByteContentDoc's
	// String and GoString methods.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" min:"1" type:"blob" required:"true" sensitive:"true"`

	// The file name of the document contained in the wrapper object.
	//
	// Identifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ByteContentDoc's
	// String and GoString methods.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByteContentDoc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByteContentDoc) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ByteContentDoc) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ByteContentDoc"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Data != nil && len(s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ByteContentDoc) SetContentType(v string) *ByteContentDoc {
	s.ContentType = &v
	return s
}

// SetData sets the Data field's value.
func (s *ByteContentDoc) SetData(v []byte) *ByteContentDoc {
	s.Data = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *ByteContentDoc) SetIdentifier(v string) *ByteContentDoc {
	s.Identifier = &v
	return s
}

// An object containing a segment of the generated response that is based on
// a source in the knowledge base, alongside information about the source.
//
// This data type is used in the following API operations:
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the citations field
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the citations field
type Citation struct {
	_ struct{} `type:"structure"`

	// Contains the generated response and metadata
	GeneratedResponsePart *GeneratedResponsePart `locationName:"generatedResponsePart" type:"structure"`

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []*RetrievedReference `locationName:"retrievedReferences" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Citation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Citation) GoString() string {
	return s.String()
}

// SetGeneratedResponsePart sets the GeneratedResponsePart field's value.
func (s *Citation) SetGeneratedResponsePart(v *GeneratedResponsePart) *Citation {
	s.GeneratedResponsePart = v
	return s
}

// SetRetrievedReferences sets the RetrievedReferences field's value.
func (s *Citation) SetRetrievedReferences(v []*RetrievedReference) *Citation {
	s.RetrievedReferences = v
	return s
}

// There was a conflict performing an operation. Resolve the conflict and retry
// your request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

// The ConflictException is and event in the ResponseStream group of events.
func (s *ConflictException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConflictException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConflictException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConflictException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the body of the API response.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults field of the InvokeAgent request
//     (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax)
type ContentBody struct {
	_ struct{} `type:"structure"`

	// The body of the API response.
	Body *string `locationName:"body" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentBody) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *ContentBody) SetBody(v string) *ContentBody {
	s.Body = &v
	return s
}

// There was an issue with a dependency. Check the resource configurations and
// retry the request.
type DependencyFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the dependency that caused the issue, such as Amazon Bedrock,
	// Lambda, or STS.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) GoString() string {
	return s.String()
}

// The DependencyFailedException is and event in the ResponseStream group of events.
func (s *DependencyFailedException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the DependencyFailedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorDependencyFailedException(v protocol.ResponseMetadata) error {
	return &DependencyFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyFailedException) Code() string {
	return "DependencyFailedException"
}

// Message returns the exception's message.
func (s *DependencyFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyFailedException) OrigErr() error {
	return nil
}

func (s *DependencyFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The unique external source of the content contained in the wrapper object.
type ExternalSource struct {
	_ struct{} `type:"structure"`

	// The identifier, contentType, and data of the external source wrapper object.
	ByteContent *ByteContentDoc `locationName:"byteContent" type:"structure"`

	// The S3 location of the external source wrapper object.
	S3Location *S3ObjectDoc `locationName:"s3Location" type:"structure"`

	// The source type of the external source wrapper object.
	//
	// SourceType is a required field
	SourceType *string `locationName:"sourceType" type:"string" required:"true" enum:"ExternalSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalSource"}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}
	if s.ByteContent != nil {
		if err := s.ByteContent.Validate(); err != nil {
			invalidParams.AddNested("ByteContent", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteContent sets the ByteContent field's value.
func (s *ExternalSource) SetByteContent(v *ByteContentDoc) *ExternalSource {
	s.ByteContent = v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *ExternalSource) SetS3Location(v *S3ObjectDoc) *ExternalSource {
	s.S3Location = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ExternalSource) SetSourceType(v string) *ExternalSource {
	s.SourceType = &v
	return s
}

// Contains the generation configuration of the external source wrapper object.
type ExternalSourcesGenerationConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// Configuration settings for inference when using RetrieveAndGenerate to generate
	// responses while using an external source.
	InferenceConfig *InferenceConfig `locationName:"inferenceConfig" type:"structure"`

	// Contain the textPromptTemplate string for the external source wrapper object.
	PromptTemplate *PromptTemplate `locationName:"promptTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourcesGenerationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourcesGenerationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalSourcesGenerationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalSourcesGenerationConfiguration"}
	if s.GuardrailConfiguration != nil {
		if err := s.GuardrailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PromptTemplate != nil {
		if err := s.PromptTemplate.Validate(); err != nil {
			invalidParams.AddNested("PromptTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *ExternalSourcesGenerationConfiguration) SetGuardrailConfiguration(v *GuardrailConfiguration) *ExternalSourcesGenerationConfiguration {
	s.GuardrailConfiguration = v
	return s
}

// SetInferenceConfig sets the InferenceConfig field's value.
func (s *ExternalSourcesGenerationConfiguration) SetInferenceConfig(v *InferenceConfig) *ExternalSourcesGenerationConfiguration {
	s.InferenceConfig = v
	return s
}

// SetPromptTemplate sets the PromptTemplate field's value.
func (s *ExternalSourcesGenerationConfiguration) SetPromptTemplate(v *PromptTemplate) *ExternalSourcesGenerationConfiguration {
	s.PromptTemplate = v
	return s
}

// The configurations of the external source wrapper object in the retrieveAndGenerate
// function.
type ExternalSourcesRetrieveAndGenerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The prompt used with the external source wrapper object with the retrieveAndGenerate
	// function.
	GenerationConfiguration *ExternalSourcesGenerationConfiguration `locationName:"generationConfiguration" type:"structure"`

	// The modelArn used with the external source wrapper object in the retrieveAndGenerate
	// function.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The document used with the external source wrapper object in the retrieveAndGenerate
	// function.
	//
	// Sources is a required field
	Sources []*ExternalSource `locationName:"sources" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourcesRetrieveAndGenerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourcesRetrieveAndGenerateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalSourcesRetrieveAndGenerateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalSourcesRetrieveAndGenerateConfiguration"}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.ModelArn != nil && len(*s.ModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArn", 20))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.GenerationConfiguration != nil {
		if err := s.GenerationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GenerationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerationConfiguration sets the GenerationConfiguration field's value.
func (s *ExternalSourcesRetrieveAndGenerateConfiguration) SetGenerationConfiguration(v *ExternalSourcesGenerationConfiguration) *ExternalSourcesRetrieveAndGenerateConfiguration {
	s.GenerationConfiguration = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ExternalSourcesRetrieveAndGenerateConfiguration) SetModelArn(v string) *ExternalSourcesRetrieveAndGenerateConfiguration {
	s.ModelArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *ExternalSourcesRetrieveAndGenerateConfiguration) SetSources(v []*ExternalSource) *ExternalSourcesRetrieveAndGenerateConfiguration {
	s.Sources = v
	return s
}

// Contains information about the failure of the interaction.
type FailureTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The reason the interaction failed.
	//
	// FailureReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FailureTrace's
	// String and GoString methods.
	FailureReason *string `locationName:"failureReason" type:"string" sensitive:"true"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureTrace) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *FailureTrace) SetFailureReason(v string) *FailureTrace {
	s.FailureReason = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *FailureTrace) SetTraceId(v string) *FailureTrace {
	s.TraceId = &v
	return s
}

// Contains details about the response to the user.
type FinalResponse struct {
	_ struct{} `type:"structure"`

	// The text in the response to the user.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FinalResponse's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalResponse) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *FinalResponse) SetText(v string) *FinalResponse {
	s.Text = &v
	return s
}

// Contains information about the function that the agent predicts should be
// called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type FunctionInvocationInput_ struct {
	_ struct{} `type:"structure"`

	// The action group that the function belongs to.
	//
	// ActionGroup is a required field
	ActionGroup *string `locationName:"actionGroup" type:"string" required:"true"`

	// The name of the function.
	Function *string `locationName:"function" type:"string"`

	// A list of parameters of the function.
	Parameters []*FunctionParameter `locationName:"parameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionInvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroup sets the ActionGroup field's value.
func (s *FunctionInvocationInput_) SetActionGroup(v string) *FunctionInvocationInput_ {
	s.ActionGroup = &v
	return s
}

// SetFunction sets the Function field's value.
func (s *FunctionInvocationInput_) SetFunction(v string) *FunctionInvocationInput_ {
	s.Function = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *FunctionInvocationInput_) SetParameters(v []*FunctionParameter) *FunctionInvocationInput_ {
	s.Parameters = v
	return s
}

// Contains information about a parameter of the function.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type FunctionParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	Name *string `locationName:"name" type:"string"`

	// The data type of the parameter.
	Type *string `locationName:"type" type:"string"`

	// The value of the parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionParameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FunctionParameter) SetName(v string) *FunctionParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *FunctionParameter) SetType(v string) *FunctionParameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FunctionParameter) SetValue(v string) *FunctionParameter {
	s.Value = &v
	return s
}

// Contains information about the function that was called from the action group
// and the response that was returned.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults of the InvokeAgent request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax)
type FunctionResult struct {
	_ struct{} `type:"structure"`

	// The action group that the function belongs to.
	//
	// ActionGroup is a required field
	ActionGroup *string `locationName:"actionGroup" type:"string" required:"true"`

	// The name of the function that was called.
	Function *string `locationName:"function" type:"string"`

	// The response from the function call using the parameters. The key of the
	// object is the content type (currently, only TEXT is supported). The response
	// may be returned directly or from the Lambda function.
	ResponseBody map[string]*ContentBody `locationName:"responseBody" type:"map"`

	// Controls the final response state returned to end user when API/Function
	// execution failed. When this state is FAILURE, the request would fail with
	// dependency failure exception. When this state is REPROMPT, the API/function
	// response will be sent to model for re-prompt
	ResponseState *string `locationName:"responseState" type:"string" enum:"ResponseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionResult) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionResult) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionResult"}
	if s.ActionGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroup sets the ActionGroup field's value.
func (s *FunctionResult) SetActionGroup(v string) *FunctionResult {
	s.ActionGroup = &v
	return s
}

// SetFunction sets the Function field's value.
func (s *FunctionResult) SetFunction(v string) *FunctionResult {
	s.Function = &v
	return s
}

// SetResponseBody sets the ResponseBody field's value.
func (s *FunctionResult) SetResponseBody(v map[string]*ContentBody) *FunctionResult {
	s.ResponseBody = v
	return s
}

// SetResponseState sets the ResponseState field's value.
func (s *FunctionResult) SetResponseState(v string) *FunctionResult {
	s.ResponseState = &v
	return s
}

// Contains metadata about a part of the generated response that is accompanied
// by a citation.
//
// This data type is used in the following API operations:
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the generatedResponsePart field
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the generatedResponsePart field
type GeneratedResponsePart struct {
	_ struct{} `type:"structure"`

	// Contains metadata about a textual part of the generated response that is
	// accompanied by a citation.
	//
	// TextResponsePart is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GeneratedResponsePart's
	// String and GoString methods.
	TextResponsePart *TextResponsePart `locationName:"textResponsePart" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedResponsePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedResponsePart) GoString() string {
	return s.String()
}

// SetTextResponsePart sets the TextResponsePart field's value.
func (s *GeneratedResponsePart) SetTextResponsePart(v *TextResponsePart) *GeneratedResponsePart {
	s.TextResponsePart = v
	return s
}

// Contains configurations for response generation based on the knowledge base
// query results.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
type GenerationConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// Configuration settings for inference when using RetrieveAndGenerate to generate
	// responses while using a knowledge base as a source.
	InferenceConfig *InferenceConfig `locationName:"inferenceConfig" type:"structure"`

	// Contains the template for the prompt that's sent to the model for response
	// generation.
	PromptTemplate *PromptTemplate `locationName:"promptTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerationConfiguration"}
	if s.GuardrailConfiguration != nil {
		if err := s.GuardrailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GuardrailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PromptTemplate != nil {
		if err := s.PromptTemplate.Validate(); err != nil {
			invalidParams.AddNested("PromptTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *GenerationConfiguration) SetGuardrailConfiguration(v *GuardrailConfiguration) *GenerationConfiguration {
	s.GuardrailConfiguration = v
	return s
}

// SetInferenceConfig sets the InferenceConfig field's value.
func (s *GenerationConfiguration) SetInferenceConfig(v *InferenceConfig) *GenerationConfiguration {
	s.InferenceConfig = v
	return s
}

// SetPromptTemplate sets the PromptTemplate field's value.
func (s *GenerationConfiguration) SetPromptTemplate(v *PromptTemplate) *GenerationConfiguration {
	s.PromptTemplate = v
	return s
}

// The configuration details for the guardrail.
type GuardrailConfiguration struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the guardrail.
	//
	// GuardrailId is a required field
	GuardrailId *string `locationName:"guardrailId" type:"string" required:"true"`

	// The version of the guardrail.
	//
	// GuardrailVersion is a required field
	GuardrailVersion *string `locationName:"guardrailVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailConfiguration"}
	if s.GuardrailId == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailId"))
	}
	if s.GuardrailVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailVersion"))
	}
	if s.GuardrailVersion != nil && len(*s.GuardrailVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GuardrailVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailId sets the GuardrailId field's value.
func (s *GuardrailConfiguration) SetGuardrailId(v string) *GuardrailConfiguration {
	s.GuardrailId = &v
	return s
}

// SetGuardrailVersion sets the GuardrailVersion field's value.
func (s *GuardrailConfiguration) SetGuardrailVersion(v string) *GuardrailConfiguration {
	s.GuardrailVersion = &v
	return s
}

// The configuration for inference settings when generating responses using
// RetrieveAndGenerate.
type InferenceConfig struct {
	_ struct{} `type:"structure"`

	// Configuration settings specific to text generation while generating responses
	// using RetrieveAndGenerate.
	TextInferenceConfig *TextInferenceConfig `locationName:"textInferenceConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfig) GoString() string {
	return s.String()
}

// SetTextInferenceConfig sets the TextInferenceConfig field's value.
func (s *InferenceConfig) SetTextInferenceConfig(v *TextInferenceConfig) *InferenceConfig {
	s.TextInferenceConfig = v
	return s
}

// Specifications about the inference parameters that were provided alongside
// the prompt. These are specified in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
// object that was set when the agent was created or updated. For more information,
// see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
type InferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens allowed in the generated response.
	MaximumLength *int64 `locationName:"maximumLength" type:"integer"`

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// The likelihood of the model selecting higher-probability options while generating
	// a response. A lower value makes the model more likely to choose higher-probability
	// options, while a higher value makes the model more likely to choose lower-probability
	// options.
	Temperature *float64 `locationName:"temperature" type:"float"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK
	// is the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topK to 50, the model
	// selects the next token from among the top 50 most likely choices.
	TopK *int64 `locationName:"topK" type:"integer"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top
	// P determines the number of most-likely candidates from which the model chooses
	// the next token in the sequence. For example, if you set topP to 80, the model
	// only selects the next token from the top 80% of the probability distribution
	// of next tokens.
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) GoString() string {
	return s.String()
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *InferenceConfiguration) SetMaximumLength(v int64) *InferenceConfiguration {
	s.MaximumLength = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *InferenceConfiguration) SetStopSequences(v []*string) *InferenceConfiguration {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *InferenceConfiguration) SetTemperature(v float64) *InferenceConfiguration {
	s.Temperature = &v
	return s
}

// SetTopK sets the TopK field's value.
func (s *InferenceConfiguration) SetTopK(v int64) *InferenceConfiguration {
	s.TopK = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *InferenceConfiguration) SetTopP(v float64) *InferenceConfiguration {
	s.TopP = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

// The InternalServerException is and event in the ResponseStream group of events.
func (s *InternalServerException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalServerException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalServerException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalServerException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about the API operation or function that the agent predicts
// should be called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type InvocationInputMember struct {
	_ struct{} `type:"structure"`

	// Contains information about the API operation that the agent predicts should
	// be called.
	ApiInvocationInput *ApiInvocationInput_ `locationName:"apiInvocationInput" type:"structure"`

	// Contains information about the function that the agent predicts should be
	// called.
	FunctionInvocationInput *FunctionInvocationInput_ `locationName:"functionInvocationInput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInputMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInputMember) GoString() string {
	return s.String()
}

// SetApiInvocationInput sets the ApiInvocationInput field's value.
func (s *InvocationInputMember) SetApiInvocationInput(v *ApiInvocationInput_) *InvocationInputMember {
	s.ApiInvocationInput = v
	return s
}

// SetFunctionInvocationInput sets the FunctionInvocationInput field's value.
func (s *InvocationInputMember) SetFunctionInvocationInput(v *FunctionInvocationInput_) *InvocationInputMember {
	s.FunctionInvocationInput = v
	return s
}

// Contains information pertaining to the action group or knowledge base that
// is being invoked.
type InvocationInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains information about the action group to be invoked.
	ActionGroupInvocationInput *ActionGroupInvocationInput_ `locationName:"actionGroupInvocationInput" type:"structure"`

	// Specifies whether the agent is invoking an action group or a knowledge base.
	InvocationType *string `locationName:"invocationType" type:"string" enum:"InvocationType"`

	// Contains details about the knowledge base to look up and the query to be
	// made.
	KnowledgeBaseLookupInput *KnowledgeBaseLookupInput_ `locationName:"knowledgeBaseLookupInput" type:"structure"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroupInvocationInput sets the ActionGroupInvocationInput field's value.
func (s *InvocationInput_) SetActionGroupInvocationInput(v *ActionGroupInvocationInput_) *InvocationInput_ {
	s.ActionGroupInvocationInput = v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *InvocationInput_) SetInvocationType(v string) *InvocationInput_ {
	s.InvocationType = &v
	return s
}

// SetKnowledgeBaseLookupInput sets the KnowledgeBaseLookupInput field's value.
func (s *InvocationInput_) SetKnowledgeBaseLookupInput(v *KnowledgeBaseLookupInput_) *InvocationInput_ {
	s.KnowledgeBaseLookupInput = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *InvocationInput_) SetTraceId(v string) *InvocationInput_ {
	s.TraceId = &v
	return s
}

// A result from the invocation of an action. For more information, see Return
// control to the agent developer (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html)
// and Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
//
// This data type is used in the following API operations:
//
//   - InvokeAgent request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax)
type InvocationResultMember struct {
	_ struct{} `type:"structure"`

	// The result from the API response from the action group invocation.
	ApiResult *ApiResult `locationName:"apiResult" type:"structure"`

	// The result from the function from the action group invocation.
	FunctionResult *FunctionResult `locationName:"functionResult" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationResultMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationResultMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvocationResultMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvocationResultMember"}
	if s.ApiResult != nil {
		if err := s.ApiResult.Validate(); err != nil {
			invalidParams.AddNested("ApiResult", err.(request.ErrInvalidParams))
		}
	}
	if s.FunctionResult != nil {
		if err := s.FunctionResult.Validate(); err != nil {
			invalidParams.AddNested("FunctionResult", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiResult sets the ApiResult field's value.
func (s *InvocationResultMember) SetApiResult(v *ApiResult) *InvocationResultMember {
	s.ApiResult = v
	return s
}

// SetFunctionResult sets the FunctionResult field's value.
func (s *InvocationResultMember) SetFunctionResult(v *FunctionResult) *InvocationResultMember {
	s.FunctionResult = v
	return s
}

type InvokeAgentInput struct {
	_ struct{} `type:"structure"`

	// The alias of the agent to use.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" type:"string" required:"true"`

	// The unique identifier of the agent to use.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Specifies whether to turn on the trace or not to track the agent's reasoning
	// process. For more information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events).
	EnableTrace *bool `locationName:"enableTrace" type:"boolean"`

	// Specifies whether to end the session with the agent or not.
	EndSession *bool `locationName:"endSession" type:"boolean"`

	// The prompt text to send the agent.
	//
	// If you include returnControlInvocationResults in the sessionState field,
	// the inputText field will be ignored.
	//
	// InputText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeAgentInput's
	// String and GoString methods.
	InputText *string `locationName:"inputText" type:"string" sensitive:"true"`

	// The unique identifier of the session. Use the same value across requests
	// to continue the same conversation.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`

	// Contains parameters that specify various attributes of the session. For more
	// information, see Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
	//
	// If you include returnControlInvocationResults in the sessionState field,
	// the inputText field will be ignored.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeAgentInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}
	if s.SessionState != nil {
		if err := s.SessionState.Validate(); err != nil {
			invalidParams.AddNested("SessionState", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *InvokeAgentInput) SetAgentAliasId(v string) *InvokeAgentInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *InvokeAgentInput) SetAgentId(v string) *InvokeAgentInput {
	s.AgentId = &v
	return s
}

// SetEnableTrace sets the EnableTrace field's value.
func (s *InvokeAgentInput) SetEnableTrace(v bool) *InvokeAgentInput {
	s.EnableTrace = &v
	return s
}

// SetEndSession sets the EndSession field's value.
func (s *InvokeAgentInput) SetEndSession(v bool) *InvokeAgentInput {
	s.EndSession = &v
	return s
}

// SetInputText sets the InputText field's value.
func (s *InvokeAgentInput) SetInputText(v string) *InvokeAgentInput {
	s.InputText = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *InvokeAgentInput) SetSessionId(v string) *InvokeAgentInput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *InvokeAgentInput) SetSessionState(v *SessionState) *InvokeAgentInput {
	s.SessionState = v
	return s
}

type InvokeAgentOutput struct {
	_ struct{} `type:"structure" payload:"Completion"`

	eventStream *InvokeAgentEventStream

	// The MIME type of the input data in the request. The default value is application/json.
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"x-amzn-bedrock-agent-content-type" type:"string" required:"true"`

	// The unique identifier of the session with the agent.
	//
	// SessionId is a required field
	SessionId *string `location:"header" locationName:"x-amz-bedrock-agent-session-id" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *InvokeAgentOutput) SetContentType(v string) *InvokeAgentOutput {
	s.ContentType = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *InvokeAgentOutput) SetSessionId(v string) *InvokeAgentOutput {
	s.SessionId = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *InvokeAgentOutput) GetStream() *InvokeAgentEventStream {
	return s.eventStream
}

// Contains details about the knowledge base to look up and the query to be
// made.
type KnowledgeBaseLookupInput_ struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base to look up.
	//
	// KnowledgeBaseId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseLookupInput_'s
	// String and GoString methods.
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" sensitive:"true"`

	// The query made to the knowledge base.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseLookupInput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupInput_) GoString() string {
	return s.String()
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseLookupInput_) SetKnowledgeBaseId(v string) *KnowledgeBaseLookupInput_ {
	s.KnowledgeBaseId = &v
	return s
}

// SetText sets the Text field's value.
func (s *KnowledgeBaseLookupInput_) SetText(v string) *KnowledgeBaseLookupInput_ {
	s.Text = &v
	return s
}

// Contains details about the results from looking up the knowledge base.
type KnowledgeBaseLookupOutput_ struct {
	_ struct{} `type:"structure"`

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []*RetrievedReference `locationName:"retrievedReferences" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupOutput_) GoString() string {
	return s.String()
}

// SetRetrievedReferences sets the RetrievedReferences field's value.
func (s *KnowledgeBaseLookupOutput_) SetRetrievedReferences(v []*RetrievedReference) *KnowledgeBaseLookupOutput_ {
	s.RetrievedReferences = v
	return s
}

// Contains the query made to the knowledge base.
//
// This data type is used in the following API operations:
//
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the retrievalQuery field
type KnowledgeBaseQuery struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The text of the query made to the knowledge base.
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseQuery"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *KnowledgeBaseQuery) SetText(v string) *KnowledgeBaseQuery {
	s.Text = &v
	return s
}

// Contains configurations for the knowledge base query and retrieval process.
// For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
//
// This data type is used in the following API operations:
//
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the retrievalConfiguration field
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the retrievalConfiguration field
type KnowledgeBaseRetrievalConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains details about how the results from the vector search should be returned.
	// For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
	//
	// VectorSearchConfiguration is a required field
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration `locationName:"vectorSearchConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseRetrievalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseRetrievalConfiguration"}
	if s.VectorSearchConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorSearchConfiguration"))
	}
	if s.VectorSearchConfiguration != nil {
		if err := s.VectorSearchConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorSearchConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVectorSearchConfiguration sets the VectorSearchConfiguration field's value.
func (s *KnowledgeBaseRetrievalConfiguration) SetVectorSearchConfiguration(v *KnowledgeBaseVectorSearchConfiguration) *KnowledgeBaseRetrievalConfiguration {
	s.VectorSearchConfiguration = v
	return s
}

// Details about a result from querying the knowledge base.
//
// This data type is used in the following API operations:
//
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the retrievalResults field
type KnowledgeBaseRetrievalResult struct {
	_ struct{} `type:"structure"`

	// Contains a chunk of text from a data source in the knowledge base.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseRetrievalResult's
	// String and GoString methods.
	//
	// Content is a required field
	Content *RetrievalResultContent `locationName:"content" type:"structure" required:"true" sensitive:"true"`

	// Contains information about the location of the data source.
	//
	// Location is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseRetrievalResult's
	// String and GoString methods.
	Location *RetrievalResultLocation `locationName:"location" type:"structure" sensitive:"true"`

	// The level of relevance of the result to the query.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalResult) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *KnowledgeBaseRetrievalResult) SetContent(v *RetrievalResultContent) *KnowledgeBaseRetrievalResult {
	s.Content = v
	return s
}

// SetLocation sets the Location field's value.
func (s *KnowledgeBaseRetrievalResult) SetLocation(v *RetrievalResultLocation) *KnowledgeBaseRetrievalResult {
	s.Location = v
	return s
}

// SetScore sets the Score field's value.
func (s *KnowledgeBaseRetrievalResult) SetScore(v float64) *KnowledgeBaseRetrievalResult {
	s.Score = &v
	return s
}

// Contains details about the resource being queried.
//
// This data type is used in the following API operations:
//
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the knowledgeBaseConfiguration field
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the knowledgeBaseConfiguration field
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for response generation based on the knowwledge base
	// query results.
	GenerationConfiguration *GenerationConfiguration `locationName:"generationConfiguration" type:"structure"`

	// The unique identifier of the knowledge base that is queried and the foundation
	// model used for generation.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The ARN of the foundation model used to generate a response.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// Contains configurations for how to retrieve and return the knowledge base
	// query.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration `locationName:"retrievalConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrieveAndGenerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrieveAndGenerateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseRetrieveAndGenerateConfiguration"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.ModelArn != nil && len(*s.ModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArn", 20))
	}
	if s.GenerationConfiguration != nil {
		if err := s.GenerationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GenerationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RetrievalConfiguration != nil {
		if err := s.RetrievalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerationConfiguration sets the GenerationConfiguration field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetGenerationConfiguration(v *GenerationConfiguration) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.GenerationConfiguration = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetKnowledgeBaseId(v string) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.KnowledgeBaseId = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetModelArn(v string) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.ModelArn = &v
	return s
}

// SetRetrievalConfiguration sets the RetrievalConfiguration field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetRetrievalConfiguration(v *KnowledgeBaseRetrievalConfiguration) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.RetrievalConfiguration = v
	return s
}

// Configurations for how to perform the search query and return results. For
// more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
//
// This data type is used in the following API operations:
//
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the vectorSearchConfiguration field
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the vectorSearchConfiguration field
type KnowledgeBaseVectorSearchConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the filters to use on the metadata in the knowledge base data sources
	// before returning results. For more information, see Query configurations
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
	//
	// Filter is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseVectorSearchConfiguration's
	// String and GoString methods.
	Filter *RetrievalFilter `locationName:"filter" type:"structure" sensitive:"true"`

	// The number of source chunks to retrieve.
	NumberOfResults *int64 `locationName:"numberOfResults" min:"1" type:"integer"`

	// By default, Amazon Bedrock decides a search strategy for you. If you're using
	// an Amazon OpenSearch Serverless vector store that contains a filterable text
	// field, you can specify whether to query the knowledge base with a HYBRID
	// search using both vector embeddings and raw text, or SEMANTIC search using
	// only vector embeddings. For other vector store configurations, only SEMANTIC
	// search is available. For more information, see Test a knowledge base (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html).
	OverrideSearchType *string `locationName:"overrideSearchType" type:"string" enum:"SearchType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseVectorSearchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseVectorSearchConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseVectorSearchConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseVectorSearchConfiguration"}
	if s.NumberOfResults != nil && *s.NumberOfResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *KnowledgeBaseVectorSearchConfiguration) SetFilter(v *RetrievalFilter) *KnowledgeBaseVectorSearchConfiguration {
	s.Filter = v
	return s
}

// SetNumberOfResults sets the NumberOfResults field's value.
func (s *KnowledgeBaseVectorSearchConfiguration) SetNumberOfResults(v int64) *KnowledgeBaseVectorSearchConfiguration {
	s.NumberOfResults = &v
	return s
}

// SetOverrideSearchType sets the OverrideSearchType field's value.
func (s *KnowledgeBaseVectorSearchConfiguration) SetOverrideSearchType(v string) *KnowledgeBaseVectorSearchConfiguration {
	s.OverrideSearchType = &v
	return s
}

// The input for the pre-processing step.
//
//   - The type matches the agent step.
//
//   - The text contains the prompt.
//
//   - The inferenceConfiguration, parserMode, and overrideLambda values are
//     set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
//     object that was set when the agent was created or updated.
type ModelInvocationInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Specifications about the inference parameters that were provided alongside
	// the prompt. These are specified in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// object that was set when the agent was created or updated. For more information,
	// see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	InferenceConfiguration *InferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence.
	OverrideLambda *string `locationName:"overrideLambda" type:"string"`

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined
	// by the promptType.
	ParserMode *string `locationName:"parserMode" type:"string" enum:"CreationMode"`

	// Specifies whether the default prompt template was OVERRIDDEN. If it was,
	// the basePromptTemplate that was set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// object when the agent was created or updated is used instead.
	PromptCreationMode *string `locationName:"promptCreationMode" type:"string" enum:"CreationMode"`

	// The text that prompted the agent at this step.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ModelInvocationInput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`

	// The step in the agent sequence.
	Type *string `locationName:"type" type:"string" enum:"PromptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInvocationInput_) GoString() string {
	return s.String()
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *ModelInvocationInput_) SetInferenceConfiguration(v *InferenceConfiguration) *ModelInvocationInput_ {
	s.InferenceConfiguration = v
	return s
}

// SetOverrideLambda sets the OverrideLambda field's value.
func (s *ModelInvocationInput_) SetOverrideLambda(v string) *ModelInvocationInput_ {
	s.OverrideLambda = &v
	return s
}

// SetParserMode sets the ParserMode field's value.
func (s *ModelInvocationInput_) SetParserMode(v string) *ModelInvocationInput_ {
	s.ParserMode = &v
	return s
}

// SetPromptCreationMode sets the PromptCreationMode field's value.
func (s *ModelInvocationInput_) SetPromptCreationMode(v string) *ModelInvocationInput_ {
	s.PromptCreationMode = &v
	return s
}

// SetText sets the Text field's value.
func (s *ModelInvocationInput_) SetText(v string) *ModelInvocationInput_ {
	s.Text = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *ModelInvocationInput_) SetTraceId(v string) *ModelInvocationInput_ {
	s.TraceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ModelInvocationInput_) SetType(v string) *ModelInvocationInput_ {
	s.Type = &v
	return s
}

// Contains the result or output of an action group or knowledge base, or the
// response to the user.
type Observation struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains the JSON-formatted string returned by the API invoked by the action
	// group.
	ActionGroupInvocationOutput *ActionGroupInvocationOutput_ `locationName:"actionGroupInvocationOutput" type:"structure"`

	// Contains details about the response to the user.
	FinalResponse *FinalResponse `locationName:"finalResponse" type:"structure"`

	// Contains details about the results from looking up the knowledge base.
	KnowledgeBaseLookupOutput *KnowledgeBaseLookupOutput_ `locationName:"knowledgeBaseLookupOutput" type:"structure"`

	// Contains details about the response to reprompt the input.
	//
	// RepromptResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Observation's
	// String and GoString methods.
	RepromptResponse *RepromptResponse `locationName:"repromptResponse" type:"structure" sensitive:"true"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`

	// Specifies what kind of information the agent returns in the observation.
	// The following values are possible.
	//
	//    * ACTION_GROUP – The agent returns the result of an action group.
	//
	//    * KNOWLEDGE_BASE – The agent returns information from a knowledge base.
	//
	//    * FINISH – The agent returns a final response to the user with no follow-up.
	//
	//    * ASK_USER – The agent asks the user a question.
	//
	//    * REPROMPT – The agent prompts the user again for the same information.
	Type *string `locationName:"type" type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Observation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Observation) GoString() string {
	return s.String()
}

// SetActionGroupInvocationOutput sets the ActionGroupInvocationOutput field's value.
func (s *Observation) SetActionGroupInvocationOutput(v *ActionGroupInvocationOutput_) *Observation {
	s.ActionGroupInvocationOutput = v
	return s
}

// SetFinalResponse sets the FinalResponse field's value.
func (s *Observation) SetFinalResponse(v *FinalResponse) *Observation {
	s.FinalResponse = v
	return s
}

// SetKnowledgeBaseLookupOutput sets the KnowledgeBaseLookupOutput field's value.
func (s *Observation) SetKnowledgeBaseLookupOutput(v *KnowledgeBaseLookupOutput_) *Observation {
	s.KnowledgeBaseLookupOutput = v
	return s
}

// SetRepromptResponse sets the RepromptResponse field's value.
func (s *Observation) SetRepromptResponse(v *RepromptResponse) *Observation {
	s.RepromptResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *Observation) SetTraceId(v string) *Observation {
	s.TraceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Observation) SetType(v string) *Observation {
	s.Type = &v
	return s
}

// Details about the orchestration step, in which the agent determines the order
// in which actions are executed and which knowledge bases are retrieved.
type OrchestrationTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains information pertaining to the action group or knowledge base that
	// is being invoked.
	//
	// InvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	InvocationInput *InvocationInput_ `locationName:"invocationInput" type:"structure" sensitive:"true"`

	// The input for the orchestration step.
	//
	//    * The type is ORCHESTRATION.
	//
	//    * The text contains the prompt.
	//
	//    * The inferenceConfiguration, parserMode, and overrideLambda values are
	//    set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	//    object that was set when the agent was created or updated.
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// Details about the observation (the output of the action group Lambda or knowledge
	// base) made by the agent.
	//
	// Observation is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	Observation *Observation `locationName:"observation" type:"structure" sensitive:"true"`

	// Details about the reasoning, based on the input, that the agent uses to justify
	// carrying out an action group or getting information from a knowledge base.
	//
	// Rationale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	Rationale *Rationale `locationName:"rationale" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrchestrationTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrchestrationTrace) GoString() string {
	return s.String()
}

// SetInvocationInput sets the InvocationInput field's value.
func (s *OrchestrationTrace) SetInvocationInput(v *InvocationInput_) *OrchestrationTrace {
	s.InvocationInput = v
	return s
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *OrchestrationTrace) SetModelInvocationInput(v *ModelInvocationInput_) *OrchestrationTrace {
	s.ModelInvocationInput = v
	return s
}

// SetObservation sets the Observation field's value.
func (s *OrchestrationTrace) SetObservation(v *Observation) *OrchestrationTrace {
	s.Observation = v
	return s
}

// SetRationale sets the Rationale field's value.
func (s *OrchestrationTrace) SetRationale(v *Rationale) *OrchestrationTrace {
	s.Rationale = v
	return s
}

// A parameter for the API request or function.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	Name *string `locationName:"name" type:"string"`

	// The type of the parameter.
	Type *string `locationName:"type" type:"string"`

	// The value of the parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Parameter) SetName(v string) *Parameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Parameter) SetType(v string) *Parameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Parameter) SetValue(v string) *Parameter {
	s.Value = &v
	return s
}

// Contains a part of an agent response and citations for it.
type PayloadPart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains citations for a part of an agent response.
	Attribution *Attribution `locationName:"attribution" type:"structure"`

	// A part of the agent response in bytes.
	//
	// Bytes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PayloadPart's
	// String and GoString methods.
	//
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `locationName:"bytes" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) GoString() string {
	return s.String()
}

// SetAttribution sets the Attribution field's value.
func (s *PayloadPart) SetAttribution(v *Attribution) *PayloadPart {
	s.Attribution = v
	return s
}

// SetBytes sets the Bytes field's value.
func (s *PayloadPart) SetBytes(v []byte) *PayloadPart {
	s.Bytes = v
	return s
}

// The PayloadPart is and event in the ResponseStream group of events.
func (s *PayloadPart) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the PayloadPart value.
// This method is only used internally within the SDK's EventStream handling.
func (s *PayloadPart) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *PayloadPart) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// The foundation model output from the post-processing step.
type PostProcessingModelInvocationOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Details about the response from the Lambda parsing of the output of the post-processing
	// step.
	//
	// ParsedResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingModelInvocationOutput_'s
	// String and GoString methods.
	ParsedResponse *PostProcessingParsedResponse `locationName:"parsedResponse" type:"structure" sensitive:"true"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingModelInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingModelInvocationOutput_) GoString() string {
	return s.String()
}

// SetParsedResponse sets the ParsedResponse field's value.
func (s *PostProcessingModelInvocationOutput_) SetParsedResponse(v *PostProcessingParsedResponse) *PostProcessingModelInvocationOutput_ {
	s.ParsedResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *PostProcessingModelInvocationOutput_) SetTraceId(v string) *PostProcessingModelInvocationOutput_ {
	s.TraceId = &v
	return s
}

// Details about the response from the Lambda parsing of the output from the
// post-processing step.
type PostProcessingParsedResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The text returned by the parser.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingParsedResponse's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingParsedResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingParsedResponse) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *PostProcessingParsedResponse) SetText(v string) *PostProcessingParsedResponse {
	s.Text = &v
	return s
}

// Details about the post-processing step, in which the agent shapes the response.
type PostProcessingTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The input for the post-processing step.
	//
	//    * The type is POST_PROCESSING.
	//
	//    * The text contains the prompt.
	//
	//    * The inferenceConfiguration, parserMode, and overrideLambda values are
	//    set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	//    object that was set when the agent was created or updated.
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// The foundation model output from the post-processing step.
	//
	// ModelInvocationOutput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingTrace's
	// String and GoString methods.
	ModelInvocationOutput *PostProcessingModelInvocationOutput_ `locationName:"modelInvocationOutput" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingTrace) GoString() string {
	return s.String()
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *PostProcessingTrace) SetModelInvocationInput(v *ModelInvocationInput_) *PostProcessingTrace {
	s.ModelInvocationInput = v
	return s
}

// SetModelInvocationOutput sets the ModelInvocationOutput field's value.
func (s *PostProcessingTrace) SetModelInvocationOutput(v *PostProcessingModelInvocationOutput_) *PostProcessingTrace {
	s.ModelInvocationOutput = v
	return s
}

// The foundation model output from the pre-processing step.
type PreProcessingModelInvocationOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Details about the response from the Lambda parsing of the output of the pre-processing
	// step.
	//
	// ParsedResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingModelInvocationOutput_'s
	// String and GoString methods.
	ParsedResponse *PreProcessingParsedResponse `locationName:"parsedResponse" type:"structure" sensitive:"true"`

	// The unique identifier of the trace.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingModelInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingModelInvocationOutput_) GoString() string {
	return s.String()
}

// SetParsedResponse sets the ParsedResponse field's value.
func (s *PreProcessingModelInvocationOutput_) SetParsedResponse(v *PreProcessingParsedResponse) *PreProcessingModelInvocationOutput_ {
	s.ParsedResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *PreProcessingModelInvocationOutput_) SetTraceId(v string) *PreProcessingModelInvocationOutput_ {
	s.TraceId = &v
	return s
}

// Details about the response from the Lambda parsing of the output from the
// pre-processing step.
type PreProcessingParsedResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Whether the user input is valid or not. If false, the agent doesn't proceed
	// to orchestration.
	IsValid *bool `locationName:"isValid" type:"boolean"`

	// The text returned by the parsing of the pre-processing step, explaining the
	// steps that the agent plans to take in orchestration, if the user input is
	// valid.
	//
	// Rationale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingParsedResponse's
	// String and GoString methods.
	Rationale *string `locationName:"rationale" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingParsedResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingParsedResponse) GoString() string {
	return s.String()
}

// SetIsValid sets the IsValid field's value.
func (s *PreProcessingParsedResponse) SetIsValid(v bool) *PreProcessingParsedResponse {
	s.IsValid = &v
	return s
}

// SetRationale sets the Rationale field's value.
func (s *PreProcessingParsedResponse) SetRationale(v string) *PreProcessingParsedResponse {
	s.Rationale = &v
	return s
}

// Details about the pre-processing step, in which the agent contextualizes
// and categorizes user inputs.
type PreProcessingTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The input for the pre-processing step.
	//
	//    * The type is PRE_PROCESSING.
	//
	//    * The text contains the prompt.
	//
	//    * The inferenceConfiguration, parserMode, and overrideLambda values are
	//    set in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	//    object that was set when the agent was created or updated.
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// The foundation model output from the pre-processing step.
	//
	// ModelInvocationOutput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingTrace's
	// String and GoString methods.
	ModelInvocationOutput *PreProcessingModelInvocationOutput_ `locationName:"modelInvocationOutput" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingTrace) GoString() string {
	return s.String()
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *PreProcessingTrace) SetModelInvocationInput(v *ModelInvocationInput_) *PreProcessingTrace {
	s.ModelInvocationInput = v
	return s
}

// SetModelInvocationOutput sets the ModelInvocationOutput field's value.
func (s *PreProcessingTrace) SetModelInvocationOutput(v *PreProcessingModelInvocationOutput_) *PreProcessingTrace {
	s.ModelInvocationOutput = v
	return s
}

// Contains the template for the prompt that's sent to the model for response
// generation. For more information, see Knowledge base prompt templates (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt).
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the filter field
type PromptTemplate struct {
	_ struct{} `type:"structure"`

	// The template for the prompt that's sent to the model for response generation.
	// You can include prompt placeholders, which become replaced before the prompt
	// is sent to the model to provide instructions and context to the model. In
	// addition, you can include XML tags to delineate meaningful sections of the
	// prompt template.
	//
	// For more information, see the following resources:
	//
	//    * Knowledge base prompt templates (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt)
	//
	//    * Use XML tags with Anthropic Claude models (https://docs.anthropic.com/claude/docs/use-xml-tags)
	//
	// TextPromptTemplate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PromptTemplate's
	// String and GoString methods.
	TextPromptTemplate *string `locationName:"textPromptTemplate" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptTemplate"}
	if s.TextPromptTemplate != nil && len(*s.TextPromptTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextPromptTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTextPromptTemplate sets the TextPromptTemplate field's value.
func (s *PromptTemplate) SetTextPromptTemplate(v string) *PromptTemplate {
	s.TextPromptTemplate = &v
	return s
}

// Contains the parameters in the request body.
type PropertyParameters struct {
	_ struct{} `type:"structure"`

	// A list of parameters in the request body.
	Properties []*Parameter `locationName:"properties" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyParameters) GoString() string {
	return s.String()
}

// SetProperties sets the Properties field's value.
func (s *PropertyParameters) SetProperties(v []*Parameter) *PropertyParameters {
	s.Properties = v
	return s
}

// Contains the reasoning, based on the input, that the agent uses to justify
// carrying out an action group or getting information from a knowledge base.
type Rationale struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The reasoning or thought process of the agent, based on the input.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Rationale's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`

	// The unique identifier of the trace step.
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rationale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rationale) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Rationale) SetText(v string) *Rationale {
	s.Text = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *Rationale) SetTraceId(v string) *Rationale {
	s.TraceId = &v
	return s
}

// Contains details about the agent's response to reprompt the input.
type RepromptResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Specifies what output is prompting the agent to reprompt the input.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RepromptResponse's
	// String and GoString methods.
	Source *string `locationName:"source" type:"string" enum:"Source" sensitive:"true"`

	// The text reprompting the input.
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepromptResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepromptResponse) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *RepromptResponse) SetSource(v string) *RepromptResponse {
	s.Source = &v
	return s
}

// SetText sets the Text field's value.
func (s *RepromptResponse) SetText(v string) *RepromptResponse {
	s.Text = &v
	return s
}

// The parameters in the API request body.
type RequestBody struct {
	_ struct{} `type:"structure"`

	// The content in the request body.
	Content map[string][]*Parameter `locationName:"content" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestBody) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *RequestBody) SetContent(v map[string][]*Parameter) *RequestBody {
	s.Content = v
	return s
}

// The specified resource Amazon Resource Name (ARN) was not found. Check the
// Amazon Resource Name (ARN) and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

// The ResourceNotFoundException is and event in the ResponseStream group of events.
func (s *ResourceNotFoundException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ResourceNotFoundException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ResponseStreamEvent groups together all EventStream
// events writes for ResponseStream.
//
// These events are:
//
//   - PayloadPart
//   - ReturnControlPayload
//   - TracePart
type ResponseStreamEvent interface {
	eventResponseStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// ResponseStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be ResponseStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - PayloadPart
//   - ReturnControlPayload
//   - TracePart
//   - ResponseStreamUnknownEvent
type ResponseStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan ResponseStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readResponseStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan ResponseStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadResponseStream(eventReader *eventstreamapi.EventReader) *readResponseStream {
	r := &readResponseStream{
		eventReader: eventReader,
		stream:      make(chan ResponseStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readResponseStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readResponseStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readResponseStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readResponseStream) safeClose() {
	close(r.done)
}

func (r *readResponseStream) Err() error {
	return r.err.Err()
}

func (r *readResponseStream) Events() <-chan ResponseStreamEvent {
	return r.stream
}

func (r *readResponseStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(ResponseStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForResponseStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForResponseStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "chunk":
		return &PayloadPart{}, nil
	case "returnControl":
		return &ReturnControlPayload{}, nil
	case "trace":
		return &TracePart{}, nil
	case "accessDeniedException":
		return newErrorAccessDeniedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "badGatewayException":
		return newErrorBadGatewayException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "conflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "dependencyFailedException":
		return newErrorDependencyFailedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "internalServerException":
		return newErrorInternalServerException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "resourceNotFoundException":
		return newErrorResourceNotFoundException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "serviceQuotaExceededException":
		return newErrorServiceQuotaExceededException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "throttlingException":
		return newErrorThrottlingException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "validationException":
		return newErrorValidationException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &ResponseStreamUnknownEvent{Type: eventType}, nil
	}
}

// ResponseStreamUnknownEvent provides a failsafe event for the
// ResponseStream group of events when an unknown event is received.
type ResponseStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The ResponseStreamUnknownEvent is and event in the ResponseStream
// group of events.
func (s *ResponseStreamUnknownEvent) eventResponseStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the ResponseStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// Specifies the filters to use on the metadata attributes in the knowledge
// base data sources before returning results. For more information, see Query
// configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
//
// This data type is used in the following API operations:
//
//   - Retrieve request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax)
//     – in the filter field
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the filter field
type RetrievalFilter struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Knowledge base data sources whose metadata attributes fulfill all the filter
	// conditions inside this list are returned.
	AndAll []*RetrievalFilter `locationName:"andAll" min:"2" type:"list"`

	// Knowledge base data sources whose metadata attributes fulfill at least one
	// of the filter conditions inside this list are returned.
	OrAll []*RetrievalFilter `locationName:"orAll" min:"2" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrievalFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrievalFilter"}
	if s.AndAll != nil && len(s.AndAll) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("AndAll", 2))
	}
	if s.OrAll != nil && len(s.OrAll) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("OrAll", 2))
	}
	if s.AndAll != nil {
		for i, v := range s.AndAll {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AndAll", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OrAll != nil {
		for i, v := range s.OrAll {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAll", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAll sets the AndAll field's value.
func (s *RetrievalFilter) SetAndAll(v []*RetrievalFilter) *RetrievalFilter {
	s.AndAll = v
	return s
}

// SetOrAll sets the OrAll field's value.
func (s *RetrievalFilter) SetOrAll(v []*RetrievalFilter) *RetrievalFilter {
	s.OrAll = v
	return s
}

// Contains the cited text from the data source.
//
// This data type is used in the following API operations:
//
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the content field
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the content field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the content field
type RetrievalResultContent struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The cited text from the data source.
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultContent) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *RetrievalResultContent) SetText(v string) *RetrievalResultContent {
	s.Text = &v
	return s
}

// Contains information about the location of the data source.
//
// This data type is used in the following API operations:
//
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the location field
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the location field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the locatino field
type RetrievalResultLocation struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains the S3 location of the data source.
	S3Location *RetrievalResultS3Location `locationName:"s3Location" type:"structure"`

	// The type of the location of the data source.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RetrievalResultLocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultLocation) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *RetrievalResultLocation) SetS3Location(v *RetrievalResultS3Location) *RetrievalResultLocation {
	s.S3Location = v
	return s
}

// SetType sets the Type field's value.
func (s *RetrievalResultLocation) SetType(v string) *RetrievalResultLocation {
	s.Type = &v
	return s
}

// Contains the S3 location of the data source.
//
// This data type is used in the following API operations:
//
//   - Retrieve response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax)
//     – in the s3Location field
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the s3Location field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the s3Location field
type RetrievalResultS3Location struct {
	_ struct{} `type:"structure"`

	// The S3 URI of the data source.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultS3Location) GoString() string {
	return s.String()
}

// SetUri sets the Uri field's value.
func (s *RetrievalResultS3Location) SetUri(v string) *RetrievalResultS3Location {
	s.Uri = &v
	return s
}

// Contains details about the resource being queried.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the retrieveAndGenerateConfiguration field
type RetrieveAndGenerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration used with the external source wrapper object in the retrieveAndGenerate
	// function.
	ExternalSourcesConfiguration *ExternalSourcesRetrieveAndGenerateConfiguration `locationName:"externalSourcesConfiguration" type:"structure"`

	// Contains details about the resource being queried.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure"`

	// The type of resource that is queried by the request.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RetrieveAndGenerateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ExternalSourcesConfiguration != nil {
		if err := s.ExternalSourcesConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ExternalSourcesConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalSourcesConfiguration sets the ExternalSourcesConfiguration field's value.
func (s *RetrieveAndGenerateConfiguration) SetExternalSourcesConfiguration(v *ExternalSourcesRetrieveAndGenerateConfiguration) *RetrieveAndGenerateConfiguration {
	s.ExternalSourcesConfiguration = v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *RetrieveAndGenerateConfiguration) SetKnowledgeBaseConfiguration(v *KnowledgeBaseRetrieveAndGenerateConfiguration) *RetrieveAndGenerateConfiguration {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *RetrieveAndGenerateConfiguration) SetType(v string) *RetrieveAndGenerateConfiguration {
	s.Type = &v
	return s
}

type RetrieveAndGenerateInput struct {
	_ struct{} `type:"structure"`

	// Contains the query to be made to the knowledge base.
	//
	// Input is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveAndGenerateInput's
	// String and GoString methods.
	//
	// Input is a required field
	Input *RetrieveAndGenerateInput_ `locationName:"input" type:"structure" required:"true" sensitive:"true"`

	// Contains configurations for the knowledge base query and retrieval process.
	// For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
	RetrieveAndGenerateConfiguration *RetrieveAndGenerateConfiguration `locationName:"retrieveAndGenerateConfiguration" type:"structure"`

	// Contains details about the session with the knowledge base.
	SessionConfiguration *RetrieveAndGenerateSessionConfiguration `locationName:"sessionConfiguration" type:"structure"`

	// The unique identifier of the session. Reuse the same value to continue the
	// same session with the knowledge base.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateInput"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}
	if s.RetrieveAndGenerateConfiguration != nil {
		if err := s.RetrieveAndGenerateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RetrieveAndGenerateConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SessionConfiguration != nil {
		if err := s.SessionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SessionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *RetrieveAndGenerateInput) SetInput(v *RetrieveAndGenerateInput_) *RetrieveAndGenerateInput {
	s.Input = v
	return s
}

// SetRetrieveAndGenerateConfiguration sets the RetrieveAndGenerateConfiguration field's value.
func (s *RetrieveAndGenerateInput) SetRetrieveAndGenerateConfiguration(v *RetrieveAndGenerateConfiguration) *RetrieveAndGenerateInput {
	s.RetrieveAndGenerateConfiguration = v
	return s
}

// SetSessionConfiguration sets the SessionConfiguration field's value.
func (s *RetrieveAndGenerateInput) SetSessionConfiguration(v *RetrieveAndGenerateSessionConfiguration) *RetrieveAndGenerateInput {
	s.SessionConfiguration = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RetrieveAndGenerateInput) SetSessionId(v string) *RetrieveAndGenerateInput {
	s.SessionId = &v
	return s
}

// Contains the query made to the knowledge base.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the input field
type RetrieveAndGenerateInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The query made to the knowledge base.
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateInput_"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *RetrieveAndGenerateInput_) SetText(v string) *RetrieveAndGenerateInput_ {
	s.Text = &v
	return s
}

type RetrieveAndGenerateOutput struct {
	_ struct{} `type:"structure"`

	// A list of segments of the generated response that are based on sources in
	// the knowledge base, alongside information about the sources.
	Citations []*Citation `locationName:"citations" type:"list"`

	// Specifies if there is a guardrail intervention in the response.
	GuardrailAction *string `locationName:"guardrailAction" type:"string" enum:"GuadrailAction"`

	// Contains the response generated from querying the knowledge base.
	//
	// Output is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveAndGenerateOutput's
	// String and GoString methods.
	//
	// Output is a required field
	Output *RetrieveAndGenerateOutput_ `locationName:"output" type:"structure" required:"true" sensitive:"true"`

	// The unique identifier of the session. Reuse the same value to continue the
	// same session with the knowledge base.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput) GoString() string {
	return s.String()
}

// SetCitations sets the Citations field's value.
func (s *RetrieveAndGenerateOutput) SetCitations(v []*Citation) *RetrieveAndGenerateOutput {
	s.Citations = v
	return s
}

// SetGuardrailAction sets the GuardrailAction field's value.
func (s *RetrieveAndGenerateOutput) SetGuardrailAction(v string) *RetrieveAndGenerateOutput {
	s.GuardrailAction = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *RetrieveAndGenerateOutput) SetOutput(v *RetrieveAndGenerateOutput_) *RetrieveAndGenerateOutput {
	s.Output = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RetrieveAndGenerateOutput) SetSessionId(v string) *RetrieveAndGenerateOutput {
	s.SessionId = &v
	return s
}

// Contains the response generated from querying the knowledge base.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the output field
type RetrieveAndGenerateOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The response generated from querying the knowledge base.
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput_) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *RetrieveAndGenerateOutput_) SetText(v string) *RetrieveAndGenerateOutput_ {
	s.Text = &v
	return s
}

// Contains configuration about the session with the knowledge base.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax)
//     – in the sessionConfiguration field
type RetrieveAndGenerateSessionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the KMS key encrypting the session.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateSessionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateSessionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateSessionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateSessionConfiguration"}
	if s.KmsKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyArn"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *RetrieveAndGenerateSessionConfiguration) SetKmsKeyArn(v string) *RetrieveAndGenerateSessionConfiguration {
	s.KmsKeyArn = &v
	return s
}

type RetrieveInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base to query.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// If there are more results than can fit in the response, the response returns
	// a nextToken. Use this token in the nextToken field of another request to
	// retrieve the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Contains configurations for the knowledge base query and retrieval process.
	// For more information, see Query configurations (https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration `locationName:"retrievalConfiguration" type:"structure"`

	// Contains the query to send the knowledge base.
	//
	// RetrievalQuery is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveInput's
	// String and GoString methods.
	//
	// RetrievalQuery is a required field
	RetrievalQuery *KnowledgeBaseQuery `locationName:"retrievalQuery" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RetrievalQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("RetrievalQuery"))
	}
	if s.RetrievalConfiguration != nil {
		if err := s.RetrievalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RetrievalQuery != nil {
		if err := s.RetrievalQuery.Validate(); err != nil {
			invalidParams.AddNested("RetrievalQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *RetrieveInput) SetKnowledgeBaseId(v string) *RetrieveInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *RetrieveInput) SetNextToken(v string) *RetrieveInput {
	s.NextToken = &v
	return s
}

// SetRetrievalConfiguration sets the RetrievalConfiguration field's value.
func (s *RetrieveInput) SetRetrievalConfiguration(v *KnowledgeBaseRetrievalConfiguration) *RetrieveInput {
	s.RetrievalConfiguration = v
	return s
}

// SetRetrievalQuery sets the RetrievalQuery field's value.
func (s *RetrieveInput) SetRetrievalQuery(v *KnowledgeBaseQuery) *RetrieveInput {
	s.RetrievalQuery = v
	return s
}

type RetrieveOutput struct {
	_ struct{} `type:"structure"`

	// If there are more results than can fit in the response, the response returns
	// a nextToken. Use this token in the nextToken field of another request to
	// retrieve the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of results from querying the knowledge base.
	//
	// RetrievalResults is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveOutput's
	// String and GoString methods.
	//
	// RetrievalResults is a required field
	RetrievalResults []*KnowledgeBaseRetrievalResult `locationName:"retrievalResults" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *RetrieveOutput) SetNextToken(v string) *RetrieveOutput {
	s.NextToken = &v
	return s
}

// SetRetrievalResults sets the RetrievalResults field's value.
func (s *RetrieveOutput) SetRetrievalResults(v []*KnowledgeBaseRetrievalResult) *RetrieveOutput {
	s.RetrievalResults = v
	return s
}

// Contains metadata about a source cited for the generated response.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the retrievedReferences field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the retrievedReferences field
type RetrievedReference struct {
	_ struct{} `type:"structure"`

	// Contains the cited text from the data source.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrievedReference's
	// String and GoString methods.
	Content *RetrievalResultContent `locationName:"content" type:"structure" sensitive:"true"`

	// Contains information about the location of the data source.
	//
	// Location is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrievedReference's
	// String and GoString methods.
	Location *RetrievalResultLocation `locationName:"location" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievedReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievedReference) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *RetrievedReference) SetContent(v *RetrievalResultContent) *RetrievedReference {
	s.Content = v
	return s
}

// SetLocation sets the Location field's value.
func (s *RetrievedReference) SetLocation(v *RetrievalResultLocation) *RetrievedReference {
	s.Location = v
	return s
}

// Contains information to return from the action group that the agent has predicted
// to invoke.
//
// This data type is used in the following API operations:
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
type ReturnControlPayload struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The identifier of the action group invocation.
	InvocationId *string `locationName:"invocationId" type:"string"`

	// A list of objects that contain information about the parameters and inputs
	// that need to be sent into the API operation or function, based on what the
	// agent determines from its session with the user.
	InvocationInputs []*InvocationInputMember `locationName:"invocationInputs" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnControlPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnControlPayload) GoString() string {
	return s.String()
}

// SetInvocationId sets the InvocationId field's value.
func (s *ReturnControlPayload) SetInvocationId(v string) *ReturnControlPayload {
	s.InvocationId = &v
	return s
}

// SetInvocationInputs sets the InvocationInputs field's value.
func (s *ReturnControlPayload) SetInvocationInputs(v []*InvocationInputMember) *ReturnControlPayload {
	s.InvocationInputs = v
	return s
}

// The ReturnControlPayload is and event in the ResponseStream group of events.
func (s *ReturnControlPayload) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ReturnControlPayload value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ReturnControlPayload) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ReturnControlPayload) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// The unique wrapper object of the document from the S3 location.
type S3ObjectDoc struct {
	_ struct{} `type:"structure"`

	// The file location of the S3 wrapper object.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ObjectDoc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ObjectDoc) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectDoc) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectDoc"}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUri sets the Uri field's value.
func (s *S3ObjectDoc) SetUri(v string) *S3ObjectDoc {
	s.Uri = &v
	return s
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

// The ServiceQuotaExceededException is and event in the ResponseStream group of events.
func (s *ServiceQuotaExceededException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ServiceQuotaExceededException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ServiceQuotaExceededException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ServiceQuotaExceededException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains parameters that specify various attributes that persist across a
// session or prompt. You can define session state attributes as key-value pairs
// when writing a Lambda function (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html)
// for an action group or pass them when making an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
// request. Use session state attributes to control and provide conversational
// context for your agent and to help customize your agent's behavior. For more
// information, see Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
type SessionState struct {
	_ struct{} `type:"structure"`

	// The identifier of the invocation of an action. This value must match the
	// invocationId returned in the InvokeAgent response for the action whose results
	// are provided in the returnControlInvocationResults field. For more information,
	// see Return control to the agent developer (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html)
	// and Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
	InvocationId *string `locationName:"invocationId" type:"string"`

	// Contains attributes that persist across a prompt and the values of those
	// attributes. These attributes replace the $prompt_session_attributes$ placeholder
	// variable in the orchestration prompt template. For more information, see
	// Prompt template placeholder variables (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
	PromptSessionAttributes map[string]*string `locationName:"promptSessionAttributes" type:"map"`

	// Contains information about the results from the action group invocation.
	// For more information, see Return control to the agent developer (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html)
	// and Control session context (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
	//
	// If you include this field, the inputText field will be ignored.
	ReturnControlInvocationResults []*InvocationResultMember `locationName:"returnControlInvocationResults" min:"1" type:"list"`

	// Contains attributes that persist across a session and the values of those
	// attributes.
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionState) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionState"}
	if s.ReturnControlInvocationResults != nil && len(s.ReturnControlInvocationResults) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReturnControlInvocationResults", 1))
	}
	if s.ReturnControlInvocationResults != nil {
		for i, v := range s.ReturnControlInvocationResults {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReturnControlInvocationResults", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvocationId sets the InvocationId field's value.
func (s *SessionState) SetInvocationId(v string) *SessionState {
	s.InvocationId = &v
	return s
}

// SetPromptSessionAttributes sets the PromptSessionAttributes field's value.
func (s *SessionState) SetPromptSessionAttributes(v map[string]*string) *SessionState {
	s.PromptSessionAttributes = v
	return s
}

// SetReturnControlInvocationResults sets the ReturnControlInvocationResults field's value.
func (s *SessionState) SetReturnControlInvocationResults(v []*InvocationResultMember) *SessionState {
	s.ReturnControlInvocationResults = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *SessionState) SetSessionAttributes(v map[string]*string) *SessionState {
	s.SessionAttributes = v
	return s
}

// Contains information about where the text with a citation begins and ends
// in the generated output.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the span field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the span field
type Span struct {
	_ struct{} `type:"structure"`

	// Where the text with a citation ends in the generated output.
	End *int64 `locationName:"end" type:"integer"`

	// Where the text with a citation starts in the generated output.
	Start *int64 `locationName:"start" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *Span) SetEnd(v int64) *Span {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *Span) SetStart(v int64) *Span {
	s.Start = &v
	return s
}

// Configuration settings for text generation using a language model via the
// RetrieveAndGenerate operation. Includes parameters like temperature, top-p,
// maximum token count, and stop sequences.
//
// The valid range of maxTokens depends on the accepted values for your chosen
// model's inference parameters. To see the inference parameters for your model,
// see Inference parameters for foundation models. (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html)
type TextInferenceConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to generate in the output text. Do not use the
	// minimum of 0 or the maximum of 65536. The limit values described here are
	// arbitary values, for actual values consult the limits defined by your specific
	// model.
	MaxTokens *int64 `locationName:"maxTokens" type:"integer"`

	// A list of sequences of characters that, if generated, will cause the model
	// to stop generating further tokens. Do not use a minimum length of 1 or a
	// maximum length of 1000. The limit values described here are arbitary values,
	// for actual values consult the limits defined by your specific model.
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// Controls the random-ness of text generated by the language model, influencing
	// how much the model sticks to the most predictable next words versus exploring
	// more surprising options. A lower temperature value (e.g. 0.2 or 0.3) makes
	// model outputs more deterministic or predictable, while a higher temperature
	// (e.g. 0.8 or 0.9) makes the outputs more creative or unpredictable.
	Temperature *float64 `locationName:"temperature" type:"float"`

	// A probability distribution threshold which controls what the model considers
	// for the set of possible next tokens. The model will only consider the top
	// p% of the probability distribution when generating the next token.
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInferenceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInferenceConfig) GoString() string {
	return s.String()
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *TextInferenceConfig) SetMaxTokens(v int64) *TextInferenceConfig {
	s.MaxTokens = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *TextInferenceConfig) SetStopSequences(v []*string) *TextInferenceConfig {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *TextInferenceConfig) SetTemperature(v float64) *TextInferenceConfig {
	s.Temperature = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *TextInferenceConfig) SetTopP(v float64) *TextInferenceConfig {
	s.TopP = &v
	return s
}

// Contains the part of the generated text that contains a citation, alongside
// where it begins and ends.
//
// This data type is used in the following API operations:
//
//   - RetrieveAndGenerate response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax)
//     – in the textResponsePart field
//
//   - InvokeAgent response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax)
//     – in the textResponsePart field
type TextResponsePart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains information about where the text with a citation begins and ends
	// in the generated output.
	Span *Span `locationName:"span" type:"structure"`

	// The part of the generated text that contains a citation.
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponsePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponsePart) GoString() string {
	return s.String()
}

// SetSpan sets the Span field's value.
func (s *TextResponsePart) SetSpan(v *Span) *TextResponsePart {
	s.Span = v
	return s
}

// SetText sets the Text field's value.
func (s *TextResponsePart) SetText(v string) *TextResponsePart {
	s.Text = &v
	return s
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

// The ThrottlingException is and event in the ResponseStream group of events.
func (s *ThrottlingException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ThrottlingException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains one part of the agent's reasoning process and results from calling
// API actions and querying knowledge bases. You can use the trace to understand
// how the agent arrived at the response it provided the customer. For more
// information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement).
type Trace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains information about the failure of the interaction.
	//
	// FailureTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	FailureTrace *FailureTrace `locationName:"failureTrace" type:"structure" sensitive:"true"`

	// Details about the orchestration step, in which the agent determines the order
	// in which actions are executed and which knowledge bases are retrieved.
	//
	// OrchestrationTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	OrchestrationTrace *OrchestrationTrace `locationName:"orchestrationTrace" type:"structure" sensitive:"true"`

	// Details about the post-processing step, in which the agent shapes the response..
	//
	// PostProcessingTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	PostProcessingTrace *PostProcessingTrace `locationName:"postProcessingTrace" type:"structure" sensitive:"true"`

	// Details about the pre-processing step, in which the agent contextualizes
	// and categorizes user inputs.
	//
	// PreProcessingTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	PreProcessingTrace *PreProcessingTrace `locationName:"preProcessingTrace" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trace) GoString() string {
	return s.String()
}

// SetFailureTrace sets the FailureTrace field's value.
func (s *Trace) SetFailureTrace(v *FailureTrace) *Trace {
	s.FailureTrace = v
	return s
}

// SetOrchestrationTrace sets the OrchestrationTrace field's value.
func (s *Trace) SetOrchestrationTrace(v *OrchestrationTrace) *Trace {
	s.OrchestrationTrace = v
	return s
}

// SetPostProcessingTrace sets the PostProcessingTrace field's value.
func (s *Trace) SetPostProcessingTrace(v *PostProcessingTrace) *Trace {
	s.PostProcessingTrace = v
	return s
}

// SetPreProcessingTrace sets the PreProcessingTrace field's value.
func (s *Trace) SetPreProcessingTrace(v *PreProcessingTrace) *Trace {
	s.PreProcessingTrace = v
	return s
}

// Contains information about the agent and session, alongside the agent's reasoning
// process and results from calling API actions and querying knowledge bases
// and metadata about the trace. You can use the trace to understand how the
// agent arrived at the response it provided the customer. For more information,
// see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement).
type TracePart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The unique identifier of the alias of the agent.
	AgentAliasId *string `locationName:"agentAliasId" type:"string"`

	// The unique identifier of the agent.
	AgentId *string `locationName:"agentId" type:"string"`

	// The version of the agent.
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string"`

	// The unique identifier of the session with the agent.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`

	// Contains one part of the agent's reasoning process and results from calling
	// API actions and querying knowledge bases. You can use the trace to understand
	// how the agent arrived at the response it provided the customer. For more
	// information, see Trace enablement (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement).
	//
	// Trace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TracePart's
	// String and GoString methods.
	Trace *Trace `locationName:"trace" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TracePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TracePart) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *TracePart) SetAgentAliasId(v string) *TracePart {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *TracePart) SetAgentId(v string) *TracePart {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *TracePart) SetAgentVersion(v string) *TracePart {
	s.AgentVersion = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *TracePart) SetSessionId(v string) *TracePart {
	s.SessionId = &v
	return s
}

// SetTrace sets the Trace field's value.
func (s *TracePart) SetTrace(v *Trace) *TracePart {
	s.Trace = v
	return s
}

// The TracePart is and event in the ResponseStream group of events.
func (s *TracePart) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TracePart value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TracePart) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TracePart) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

// The ValidationException is and event in the ResponseStream group of events.
func (s *ValidationException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ValidationException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ValidationException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ValidationException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CreationModeDefault is a CreationMode enum value
	CreationModeDefault = "DEFAULT"

	// CreationModeOverridden is a CreationMode enum value
	CreationModeOverridden = "OVERRIDDEN"
)

// CreationMode_Values returns all elements of the CreationMode enum
func CreationMode_Values() []string {
	return []string{
		CreationModeDefault,
		CreationModeOverridden,
	}
}

const (
	// ExternalSourceTypeS3 is a ExternalSourceType enum value
	ExternalSourceTypeS3 = "S3"

	// ExternalSourceTypeByteContent is a ExternalSourceType enum value
	ExternalSourceTypeByteContent = "BYTE_CONTENT"
)

// ExternalSourceType_Values returns all elements of the ExternalSourceType enum
func ExternalSourceType_Values() []string {
	return []string{
		ExternalSourceTypeS3,
		ExternalSourceTypeByteContent,
	}
}

const (
	// GuadrailActionIntervened is a GuadrailAction enum value
	GuadrailActionIntervened = "INTERVENED"

	// GuadrailActionNone is a GuadrailAction enum value
	GuadrailActionNone = "NONE"
)

// GuadrailAction_Values returns all elements of the GuadrailAction enum
func GuadrailAction_Values() []string {
	return []string{
		GuadrailActionIntervened,
		GuadrailActionNone,
	}
}

const (
	// InvocationTypeActionGroup is a InvocationType enum value
	InvocationTypeActionGroup = "ACTION_GROUP"

	// InvocationTypeKnowledgeBase is a InvocationType enum value
	InvocationTypeKnowledgeBase = "KNOWLEDGE_BASE"

	// InvocationTypeFinish is a InvocationType enum value
	InvocationTypeFinish = "FINISH"
)

// InvocationType_Values returns all elements of the InvocationType enum
func InvocationType_Values() []string {
	return []string{
		InvocationTypeActionGroup,
		InvocationTypeKnowledgeBase,
		InvocationTypeFinish,
	}
}

const (
	// PromptTypePreProcessing is a PromptType enum value
	PromptTypePreProcessing = "PRE_PROCESSING"

	// PromptTypeOrchestration is a PromptType enum value
	PromptTypeOrchestration = "ORCHESTRATION"

	// PromptTypeKnowledgeBaseResponseGeneration is a PromptType enum value
	PromptTypeKnowledgeBaseResponseGeneration = "KNOWLEDGE_BASE_RESPONSE_GENERATION"

	// PromptTypePostProcessing is a PromptType enum value
	PromptTypePostProcessing = "POST_PROCESSING"
)

// PromptType_Values returns all elements of the PromptType enum
func PromptType_Values() []string {
	return []string{
		PromptTypePreProcessing,
		PromptTypeOrchestration,
		PromptTypeKnowledgeBaseResponseGeneration,
		PromptTypePostProcessing,
	}
}

const (
	// ResponseStateFailure is a ResponseState enum value
	ResponseStateFailure = "FAILURE"

	// ResponseStateReprompt is a ResponseState enum value
	ResponseStateReprompt = "REPROMPT"
)

// ResponseState_Values returns all elements of the ResponseState enum
func ResponseState_Values() []string {
	return []string{
		ResponseStateFailure,
		ResponseStateReprompt,
	}
}

const (
	// RetrievalResultLocationTypeS3 is a RetrievalResultLocationType enum value
	RetrievalResultLocationTypeS3 = "S3"
)

// RetrievalResultLocationType_Values returns all elements of the RetrievalResultLocationType enum
func RetrievalResultLocationType_Values() []string {
	return []string{
		RetrievalResultLocationTypeS3,
	}
}

const (
	// RetrieveAndGenerateTypeKnowledgeBase is a RetrieveAndGenerateType enum value
	RetrieveAndGenerateTypeKnowledgeBase = "KNOWLEDGE_BASE"

	// RetrieveAndGenerateTypeExternalSources is a RetrieveAndGenerateType enum value
	RetrieveAndGenerateTypeExternalSources = "EXTERNAL_SOURCES"
)

// RetrieveAndGenerateType_Values returns all elements of the RetrieveAndGenerateType enum
func RetrieveAndGenerateType_Values() []string {
	return []string{
		RetrieveAndGenerateTypeKnowledgeBase,
		RetrieveAndGenerateTypeExternalSources,
	}
}

const (
	// SearchTypeHybrid is a SearchType enum value
	SearchTypeHybrid = "HYBRID"

	// SearchTypeSemantic is a SearchType enum value
	SearchTypeSemantic = "SEMANTIC"
)

// SearchType_Values returns all elements of the SearchType enum
func SearchType_Values() []string {
	return []string{
		SearchTypeHybrid,
		SearchTypeSemantic,
	}
}

const (
	// SourceActionGroup is a Source enum value
	SourceActionGroup = "ACTION_GROUP"

	// SourceKnowledgeBase is a Source enum value
	SourceKnowledgeBase = "KNOWLEDGE_BASE"

	// SourceParser is a Source enum value
	SourceParser = "PARSER"
)

// Source_Values returns all elements of the Source enum
func Source_Values() []string {
	return []string{
		SourceActionGroup,
		SourceKnowledgeBase,
		SourceParser,
	}
}

const (
	// TypeActionGroup is a Type enum value
	TypeActionGroup = "ACTION_GROUP"

	// TypeKnowledgeBase is a Type enum value
	TypeKnowledgeBase = "KNOWLEDGE_BASE"

	// TypeFinish is a Type enum value
	TypeFinish = "FINISH"

	// TypeAskUser is a Type enum value
	TypeAskUser = "ASK_USER"

	// TypeReprompt is a Type enum value
	TypeReprompt = "REPROMPT"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeActionGroup,
		TypeKnowledgeBase,
		TypeFinish,
		TypeAskUser,
		TypeReprompt,
	}
}
