package backup

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AzureFileShareType enumerates the values for azure file share type.
type AzureFileShareType string

const (
	// Invalid ...
	Invalid AzureFileShareType = "Invalid"
	// XSMB ...
	XSMB AzureFileShareType = "XSMB"
	// XSync ...
	XSync AzureFileShareType = "XSync"
)

// PossibleAzureFileShareTypeValues returns an array of possible values for the AzureFileShareType const type.
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return []AzureFileShareType{Invalid, XSMB, XSync}
}

// ContainerType enumerates the values for container type.
type ContainerType string

const (
	// ContainerTypeAzureBackupServerContainer ...
	ContainerTypeAzureBackupServerContainer ContainerType = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer ...
	ContainerTypeAzureSQLContainer ContainerType = "AzureSqlContainer"
	// ContainerTypeCluster ...
	ContainerTypeCluster ContainerType = "Cluster"
	// ContainerTypeDPMContainer ...
	ContainerTypeDPMContainer ContainerType = "DPMContainer"
	// ContainerTypeGenericContainer ...
	ContainerTypeGenericContainer ContainerType = "GenericContainer"
	// ContainerTypeIaasVMContainer ...
	ContainerTypeIaasVMContainer ContainerType = "IaasVMContainer"
	// ContainerTypeIaasVMServiceContainer ...
	ContainerTypeIaasVMServiceContainer ContainerType = "IaasVMServiceContainer"
	// ContainerTypeInvalid ...
	ContainerTypeInvalid ContainerType = "Invalid"
	// ContainerTypeMABContainer ...
	ContainerTypeMABContainer ContainerType = "MABContainer"
	// ContainerTypeSQLAGWorkLoadContainer ...
	ContainerTypeSQLAGWorkLoadContainer ContainerType = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer ...
	ContainerTypeStorageContainer ContainerType = "StorageContainer"
	// ContainerTypeUnknown ...
	ContainerTypeUnknown ContainerType = "Unknown"
	// ContainerTypeVCenter ...
	ContainerTypeVCenter ContainerType = "VCenter"
	// ContainerTypeVMAppContainer ...
	ContainerTypeVMAppContainer ContainerType = "VMAppContainer"
	// ContainerTypeWindows ...
	ContainerTypeWindows ContainerType = "Windows"
)

// PossibleContainerTypeValues returns an array of possible values for the ContainerType const type.
func PossibleContainerTypeValues() []ContainerType {
	return []ContainerType{ContainerTypeAzureBackupServerContainer, ContainerTypeAzureSQLContainer, ContainerTypeCluster, ContainerTypeDPMContainer, ContainerTypeGenericContainer, ContainerTypeIaasVMContainer, ContainerTypeIaasVMServiceContainer, ContainerTypeInvalid, ContainerTypeMABContainer, ContainerTypeSQLAGWorkLoadContainer, ContainerTypeStorageContainer, ContainerTypeUnknown, ContainerTypeVCenter, ContainerTypeVMAppContainer, ContainerTypeWindows}
}

// ContainerTypeBasicProtectionContainer enumerates the values for container type basic protection container.
type ContainerTypeBasicProtectionContainer string

const (
	// ContainerTypeAzureBackupServerContainer1 ...
	ContainerTypeAzureBackupServerContainer1 ContainerTypeBasicProtectionContainer = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer1 ...
	ContainerTypeAzureSQLContainer1 ContainerTypeBasicProtectionContainer = "AzureSqlContainer"
	// ContainerTypeAzureWorkloadContainer ...
	ContainerTypeAzureWorkloadContainer ContainerTypeBasicProtectionContainer = "AzureWorkloadContainer"
	// ContainerTypeDPMContainer1 ...
	ContainerTypeDPMContainer1 ContainerTypeBasicProtectionContainer = "DPMContainer"
	// ContainerTypeGenericContainer1 ...
	ContainerTypeGenericContainer1 ContainerTypeBasicProtectionContainer = "GenericContainer"
	// ContainerTypeIaaSVMContainer ...
	ContainerTypeIaaSVMContainer ContainerTypeBasicProtectionContainer = "IaaSVMContainer"
	// ContainerTypeMicrosoftClassicComputevirtualMachines ...
	ContainerTypeMicrosoftClassicComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.ClassicCompute/virtualMachines"
	// ContainerTypeMicrosoftComputevirtualMachines ...
	ContainerTypeMicrosoftComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.Compute/virtualMachines"
	// ContainerTypeProtectionContainer ...
	ContainerTypeProtectionContainer ContainerTypeBasicProtectionContainer = "ProtectionContainer"
	// ContainerTypeSQLAGWorkLoadContainer1 ...
	ContainerTypeSQLAGWorkLoadContainer1 ContainerTypeBasicProtectionContainer = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer1 ...
	ContainerTypeStorageContainer1 ContainerTypeBasicProtectionContainer = "StorageContainer"
	// ContainerTypeVMAppContainer1 ...
	ContainerTypeVMAppContainer1 ContainerTypeBasicProtectionContainer = "VMAppContainer"
	// ContainerTypeWindows1 ...
	ContainerTypeWindows1 ContainerTypeBasicProtectionContainer = "Windows"
)

// PossibleContainerTypeBasicProtectionContainerValues returns an array of possible values for the ContainerTypeBasicProtectionContainer const type.
func PossibleContainerTypeBasicProtectionContainerValues() []ContainerTypeBasicProtectionContainer {
	return []ContainerTypeBasicProtectionContainer{ContainerTypeAzureBackupServerContainer1, ContainerTypeAzureSQLContainer1, ContainerTypeAzureWorkloadContainer, ContainerTypeDPMContainer1, ContainerTypeGenericContainer1, ContainerTypeIaaSVMContainer, ContainerTypeMicrosoftClassicComputevirtualMachines, ContainerTypeMicrosoftComputevirtualMachines, ContainerTypeProtectionContainer, ContainerTypeSQLAGWorkLoadContainer1, ContainerTypeStorageContainer1, ContainerTypeVMAppContainer1, ContainerTypeWindows1}
}

// EngineType enumerates the values for engine type.
type EngineType string

const (
	// BackupEngineTypeAzureBackupServerEngine ...
	BackupEngineTypeAzureBackupServerEngine EngineType = "AzureBackupServerEngine"
	// BackupEngineTypeBackupEngineBase ...
	BackupEngineTypeBackupEngineBase EngineType = "BackupEngineBase"
	// BackupEngineTypeDpmBackupEngine ...
	BackupEngineTypeDpmBackupEngine EngineType = "DpmBackupEngine"
)

// PossibleEngineTypeValues returns an array of possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{BackupEngineTypeAzureBackupServerEngine, BackupEngineTypeBackupEngineBase, BackupEngineTypeDpmBackupEngine}
}

// InquiryStatus enumerates the values for inquiry status.
type InquiryStatus string

const (
	// InquiryStatusFailed ...
	InquiryStatusFailed InquiryStatus = "Failed"
	// InquiryStatusInvalid ...
	InquiryStatusInvalid InquiryStatus = "Invalid"
	// InquiryStatusSuccess ...
	InquiryStatusSuccess InquiryStatus = "Success"
)

// PossibleInquiryStatusValues returns an array of possible values for the InquiryStatus const type.
func PossibleInquiryStatusValues() []InquiryStatus {
	return []InquiryStatus{InquiryStatusFailed, InquiryStatusInvalid, InquiryStatusSuccess}
}

// ItemType enumerates the values for item type.
type ItemType string

const (
	// ItemTypeAzureFileShare ...
	ItemTypeAzureFileShare ItemType = "AzureFileShare"
	// ItemTypeAzureSQLDb ...
	ItemTypeAzureSQLDb ItemType = "AzureSqlDb"
	// ItemTypeClient ...
	ItemTypeClient ItemType = "Client"
	// ItemTypeExchange ...
	ItemTypeExchange ItemType = "Exchange"
	// ItemTypeFileFolder ...
	ItemTypeFileFolder ItemType = "FileFolder"
	// ItemTypeGenericDataSource ...
	ItemTypeGenericDataSource ItemType = "GenericDataSource"
	// ItemTypeInvalid ...
	ItemTypeInvalid ItemType = "Invalid"
	// ItemTypeSAPAseDatabase ...
	ItemTypeSAPAseDatabase ItemType = "SAPAseDatabase"
	// ItemTypeSAPHanaDatabase ...
	ItemTypeSAPHanaDatabase ItemType = "SAPHanaDatabase"
	// ItemTypeSharepoint ...
	ItemTypeSharepoint ItemType = "Sharepoint"
	// ItemTypeSQLDataBase ...
	ItemTypeSQLDataBase ItemType = "SQLDataBase"
	// ItemTypeSQLDB ...
	ItemTypeSQLDB ItemType = "SQLDB"
	// ItemTypeSystemState ...
	ItemTypeSystemState ItemType = "SystemState"
	// ItemTypeVM ...
	ItemTypeVM ItemType = "VM"
	// ItemTypeVMwareVM ...
	ItemTypeVMwareVM ItemType = "VMwareVM"
)

// PossibleItemTypeValues returns an array of possible values for the ItemType const type.
func PossibleItemTypeValues() []ItemType {
	return []ItemType{ItemTypeAzureFileShare, ItemTypeAzureSQLDb, ItemTypeClient, ItemTypeExchange, ItemTypeFileFolder, ItemTypeGenericDataSource, ItemTypeInvalid, ItemTypeSAPAseDatabase, ItemTypeSAPHanaDatabase, ItemTypeSharepoint, ItemTypeSQLDataBase, ItemTypeSQLDB, ItemTypeSystemState, ItemTypeVM, ItemTypeVMwareVM}
}

// ManagementType enumerates the values for management type.
type ManagementType string

const (
	// ManagementTypeAzureBackupServer ...
	ManagementTypeAzureBackupServer ManagementType = "AzureBackupServer"
	// ManagementTypeAzureIaasVM ...
	ManagementTypeAzureIaasVM ManagementType = "AzureIaasVM"
	// ManagementTypeAzureSQL ...
	ManagementTypeAzureSQL ManagementType = "AzureSql"
	// ManagementTypeAzureStorage ...
	ManagementTypeAzureStorage ManagementType = "AzureStorage"
	// ManagementTypeAzureWorkload ...
	ManagementTypeAzureWorkload ManagementType = "AzureWorkload"
	// ManagementTypeDefaultBackup ...
	ManagementTypeDefaultBackup ManagementType = "DefaultBackup"
	// ManagementTypeDPM ...
	ManagementTypeDPM ManagementType = "DPM"
	// ManagementTypeInvalid ...
	ManagementTypeInvalid ManagementType = "Invalid"
	// ManagementTypeMAB ...
	ManagementTypeMAB ManagementType = "MAB"
)

// PossibleManagementTypeValues returns an array of possible values for the ManagementType const type.
func PossibleManagementTypeValues() []ManagementType {
	return []ManagementType{ManagementTypeAzureBackupServer, ManagementTypeAzureIaasVM, ManagementTypeAzureSQL, ManagementTypeAzureStorage, ManagementTypeAzureWorkload, ManagementTypeDefaultBackup, ManagementTypeDPM, ManagementTypeInvalid, ManagementTypeMAB}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeAzureFileShareBackupRequest ...
	ObjectTypeAzureFileShareBackupRequest ObjectType = "AzureFileShareBackupRequest"
	// ObjectTypeAzureWorkloadBackupRequest ...
	ObjectTypeAzureWorkloadBackupRequest ObjectType = "AzureWorkloadBackupRequest"
	// ObjectTypeBackupRequest ...
	ObjectTypeBackupRequest ObjectType = "BackupRequest"
	// ObjectTypeIaasVMBackupRequest ...
	ObjectTypeIaasVMBackupRequest ObjectType = "IaasVMBackupRequest"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeAzureFileShareBackupRequest, ObjectTypeAzureWorkloadBackupRequest, ObjectTypeBackupRequest, ObjectTypeIaasVMBackupRequest}
}

// ObjectTypeBasicILRRequest enumerates the values for object type basic ilr request.
type ObjectTypeBasicILRRequest string

const (
	// ObjectTypeAzureFileShareProvisionILRRequest ...
	ObjectTypeAzureFileShareProvisionILRRequest ObjectTypeBasicILRRequest = "AzureFileShareProvisionILRRequest"
	// ObjectTypeIaasVMILRRegistrationRequest ...
	ObjectTypeIaasVMILRRegistrationRequest ObjectTypeBasicILRRequest = "IaasVMILRRegistrationRequest"
	// ObjectTypeILRRequest ...
	ObjectTypeILRRequest ObjectTypeBasicILRRequest = "ILRRequest"
)

// PossibleObjectTypeBasicILRRequestValues returns an array of possible values for the ObjectTypeBasicILRRequest const type.
func PossibleObjectTypeBasicILRRequestValues() []ObjectTypeBasicILRRequest {
	return []ObjectTypeBasicILRRequest{ObjectTypeAzureFileShareProvisionILRRequest, ObjectTypeIaasVMILRRegistrationRequest, ObjectTypeILRRequest}
}

// ObjectTypeBasicOperationStatusExtendedInfo enumerates the values for object type basic operation status
// extended info.
type ObjectTypeBasicOperationStatusExtendedInfo string

const (
	// ObjectTypeOperationStatusExtendedInfo ...
	ObjectTypeOperationStatusExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusExtendedInfo"
	// ObjectTypeOperationStatusJobExtendedInfo ...
	ObjectTypeOperationStatusJobExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusJobExtendedInfo"
	// ObjectTypeOperationStatusJobsExtendedInfo ...
	ObjectTypeOperationStatusJobsExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusJobsExtendedInfo"
	// ObjectTypeOperationStatusProvisionILRExtendedInfo ...
	ObjectTypeOperationStatusProvisionILRExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusProvisionILRExtendedInfo"
)

// PossibleObjectTypeBasicOperationStatusExtendedInfoValues returns an array of possible values for the ObjectTypeBasicOperationStatusExtendedInfo const type.
func PossibleObjectTypeBasicOperationStatusExtendedInfoValues() []ObjectTypeBasicOperationStatusExtendedInfo {
	return []ObjectTypeBasicOperationStatusExtendedInfo{ObjectTypeOperationStatusExtendedInfo, ObjectTypeOperationStatusJobExtendedInfo, ObjectTypeOperationStatusJobsExtendedInfo, ObjectTypeOperationStatusProvisionILRExtendedInfo}
}

// ObjectTypeBasicRecoveryPoint enumerates the values for object type basic recovery point.
type ObjectTypeBasicRecoveryPoint string

const (
	// ObjectTypeRecoveryPoint ...
	ObjectTypeRecoveryPoint ObjectTypeBasicRecoveryPoint = "RecoveryPoint"
)

// PossibleObjectTypeBasicRecoveryPointValues returns an array of possible values for the ObjectTypeBasicRecoveryPoint const type.
func PossibleObjectTypeBasicRecoveryPointValues() []ObjectTypeBasicRecoveryPoint {
	return []ObjectTypeBasicRecoveryPoint{ObjectTypeRecoveryPoint}
}

// OperationStatusValues enumerates the values for operation status values.
type OperationStatusValues string

const (
	// OperationStatusValuesCanceled ...
	OperationStatusValuesCanceled OperationStatusValues = "Canceled"
	// OperationStatusValuesFailed ...
	OperationStatusValuesFailed OperationStatusValues = "Failed"
	// OperationStatusValuesInProgress ...
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	// OperationStatusValuesInvalid ...
	OperationStatusValuesInvalid OperationStatusValues = "Invalid"
	// OperationStatusValuesSucceeded ...
	OperationStatusValuesSucceeded OperationStatusValues = "Succeeded"
)

// PossibleOperationStatusValuesValues returns an array of possible values for the OperationStatusValues const type.
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return []OperationStatusValues{OperationStatusValuesCanceled, OperationStatusValuesFailed, OperationStatusValuesInProgress, OperationStatusValuesInvalid, OperationStatusValuesSucceeded}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid ...
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeRegister ...
	OperationTypeRegister OperationType = "Register"
	// OperationTypeReregister ...
	OperationTypeReregister OperationType = "Reregister"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeRegister, OperationTypeReregister}
}

// ProtectableContainerType enumerates the values for protectable container type.
type ProtectableContainerType string

const (
	// ProtectableContainerTypeProtectableContainer ...
	ProtectableContainerTypeProtectableContainer ProtectableContainerType = "ProtectableContainer"
	// ProtectableContainerTypeStorageContainer ...
	ProtectableContainerTypeStorageContainer ProtectableContainerType = "StorageContainer"
	// ProtectableContainerTypeVMAppContainer ...
	ProtectableContainerTypeVMAppContainer ProtectableContainerType = "VMAppContainer"
)

// PossibleProtectableContainerTypeValues returns an array of possible values for the ProtectableContainerType const type.
func PossibleProtectableContainerTypeValues() []ProtectableContainerType {
	return []ProtectableContainerType{ProtectableContainerTypeProtectableContainer, ProtectableContainerTypeStorageContainer, ProtectableContainerTypeVMAppContainer}
}

// ProtectableItemType enumerates the values for protectable item type.
type ProtectableItemType string

const (
	// ProtectableItemTypeAzureFileShare ...
	ProtectableItemTypeAzureFileShare ProtectableItemType = "AzureFileShare"
	// ProtectableItemTypeAzureVMWorkloadProtectableItem ...
	ProtectableItemTypeAzureVMWorkloadProtectableItem ProtectableItemType = "AzureVmWorkloadProtectableItem"
	// ProtectableItemTypeIaaSVMProtectableItem ...
	ProtectableItemTypeIaaSVMProtectableItem ProtectableItemType = "IaaSVMProtectableItem"
	// ProtectableItemTypeMicrosoftClassicComputevirtualMachines ...
	ProtectableItemTypeMicrosoftClassicComputevirtualMachines ProtectableItemType = "Microsoft.ClassicCompute/virtualMachines"
	// ProtectableItemTypeMicrosoftComputevirtualMachines ...
	ProtectableItemTypeMicrosoftComputevirtualMachines ProtectableItemType = "Microsoft.Compute/virtualMachines"
	// ProtectableItemTypeSAPAseSystem ...
	ProtectableItemTypeSAPAseSystem ProtectableItemType = "SAPAseSystem"
	// ProtectableItemTypeSAPHanaDatabase ...
	ProtectableItemTypeSAPHanaDatabase ProtectableItemType = "SAPHanaDatabase"
	// ProtectableItemTypeSAPHanaSystem ...
	ProtectableItemTypeSAPHanaSystem ProtectableItemType = "SAPHanaSystem"
	// ProtectableItemTypeSQLAvailabilityGroupContainer ...
	ProtectableItemTypeSQLAvailabilityGroupContainer ProtectableItemType = "SQLAvailabilityGroupContainer"
	// ProtectableItemTypeSQLDataBase ...
	ProtectableItemTypeSQLDataBase ProtectableItemType = "SQLDataBase"
	// ProtectableItemTypeSQLInstance ...
	ProtectableItemTypeSQLInstance ProtectableItemType = "SQLInstance"
	// ProtectableItemTypeWorkloadProtectableItem ...
	ProtectableItemTypeWorkloadProtectableItem ProtectableItemType = "WorkloadProtectableItem"
)

// PossibleProtectableItemTypeValues returns an array of possible values for the ProtectableItemType const type.
func PossibleProtectableItemTypeValues() []ProtectableItemType {
	return []ProtectableItemType{ProtectableItemTypeAzureFileShare, ProtectableItemTypeAzureVMWorkloadProtectableItem, ProtectableItemTypeIaaSVMProtectableItem, ProtectableItemTypeMicrosoftClassicComputevirtualMachines, ProtectableItemTypeMicrosoftComputevirtualMachines, ProtectableItemTypeSAPAseSystem, ProtectableItemTypeSAPHanaDatabase, ProtectableItemTypeSAPHanaSystem, ProtectableItemTypeSQLAvailabilityGroupContainer, ProtectableItemTypeSQLDataBase, ProtectableItemTypeSQLInstance, ProtectableItemTypeWorkloadProtectableItem}
}

// ProtectionStatus enumerates the values for protection status.
type ProtectionStatus string

const (
	// ProtectionStatusInvalid ...
	ProtectionStatusInvalid ProtectionStatus = "Invalid"
	// ProtectionStatusNotProtected ...
	ProtectionStatusNotProtected ProtectionStatus = "NotProtected"
	// ProtectionStatusProtected ...
	ProtectionStatusProtected ProtectionStatus = "Protected"
	// ProtectionStatusProtecting ...
	ProtectionStatusProtecting ProtectionStatus = "Protecting"
	// ProtectionStatusProtectionFailed ...
	ProtectionStatusProtectionFailed ProtectionStatus = "ProtectionFailed"
)

// PossibleProtectionStatusValues returns an array of possible values for the ProtectionStatus const type.
func PossibleProtectionStatusValues() []ProtectionStatus {
	return []ProtectionStatus{ProtectionStatusInvalid, ProtectionStatusNotProtected, ProtectionStatusProtected, ProtectionStatusProtecting, ProtectionStatusProtectionFailed}
}

// SQLDataDirectoryType enumerates the values for sql data directory type.
type SQLDataDirectoryType string

const (
	// SQLDataDirectoryTypeData ...
	SQLDataDirectoryTypeData SQLDataDirectoryType = "Data"
	// SQLDataDirectoryTypeInvalid ...
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = "Invalid"
	// SQLDataDirectoryTypeLog ...
	SQLDataDirectoryTypeLog SQLDataDirectoryType = "Log"
)

// PossibleSQLDataDirectoryTypeValues returns an array of possible values for the SQLDataDirectoryType const type.
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return []SQLDataDirectoryType{SQLDataDirectoryTypeData, SQLDataDirectoryTypeInvalid, SQLDataDirectoryTypeLog}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeGeoRedundant ...
	StorageTypeGeoRedundant StorageType = "GeoRedundant"
	// StorageTypeInvalid ...
	StorageTypeInvalid StorageType = "Invalid"
	// StorageTypeLocallyRedundant ...
	StorageTypeLocallyRedundant StorageType = "LocallyRedundant"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{StorageTypeGeoRedundant, StorageTypeInvalid, StorageTypeLocallyRedundant}
}

// StorageTypeState enumerates the values for storage type state.
type StorageTypeState string

const (
	// StorageTypeStateInvalid ...
	StorageTypeStateInvalid StorageTypeState = "Invalid"
	// StorageTypeStateLocked ...
	StorageTypeStateLocked StorageTypeState = "Locked"
	// StorageTypeStateUnlocked ...
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// PossibleStorageTypeStateValues returns an array of possible values for the StorageTypeState const type.
func PossibleStorageTypeStateValues() []StorageTypeState {
	return []StorageTypeState{StorageTypeStateInvalid, StorageTypeStateLocked, StorageTypeStateUnlocked}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeCopyOnlyFull ...
	TypeCopyOnlyFull Type = "CopyOnlyFull"
	// TypeDifferential ...
	TypeDifferential Type = "Differential"
	// TypeFull ...
	TypeFull Type = "Full"
	// TypeInvalid ...
	TypeInvalid Type = "Invalid"
	// TypeLog ...
	TypeLog Type = "Log"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeCopyOnlyFull, TypeDifferential, TypeFull, TypeInvalid, TypeLog}
}

// WorkloadItemType enumerates the values for workload item type.
type WorkloadItemType string

const (
	// WorkloadItemTypeInvalid ...
	WorkloadItemTypeInvalid WorkloadItemType = "Invalid"
	// WorkloadItemTypeSAPAseDatabase ...
	WorkloadItemTypeSAPAseDatabase WorkloadItemType = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem ...
	WorkloadItemTypeSAPAseSystem WorkloadItemType = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase ...
	WorkloadItemTypeSAPHanaDatabase WorkloadItemType = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem ...
	WorkloadItemTypeSAPHanaSystem WorkloadItemType = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase ...
	WorkloadItemTypeSQLDataBase WorkloadItemType = "SQLDataBase"
	// WorkloadItemTypeSQLInstance ...
	WorkloadItemTypeSQLInstance WorkloadItemType = "SQLInstance"
)

// PossibleWorkloadItemTypeValues returns an array of possible values for the WorkloadItemType const type.
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return []WorkloadItemType{WorkloadItemTypeInvalid, WorkloadItemTypeSAPAseDatabase, WorkloadItemTypeSAPAseSystem, WorkloadItemTypeSAPHanaDatabase, WorkloadItemTypeSAPHanaSystem, WorkloadItemTypeSQLDataBase, WorkloadItemTypeSQLInstance}
}

// WorkloadItemTypeBasicWorkloadItem enumerates the values for workload item type basic workload item.
type WorkloadItemTypeBasicWorkloadItem string

const (
	// WorkloadItemTypeAzureVMWorkloadItem ...
	WorkloadItemTypeAzureVMWorkloadItem WorkloadItemTypeBasicWorkloadItem = "AzureVmWorkloadItem"
	// WorkloadItemTypeSAPAseDatabase1 ...
	WorkloadItemTypeSAPAseDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem1 ...
	WorkloadItemTypeSAPAseSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase1 ...
	WorkloadItemTypeSAPHanaDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem1 ...
	WorkloadItemTypeSAPHanaSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase1 ...
	WorkloadItemTypeSQLDataBase1 WorkloadItemTypeBasicWorkloadItem = "SQLDataBase"
	// WorkloadItemTypeSQLInstance1 ...
	WorkloadItemTypeSQLInstance1 WorkloadItemTypeBasicWorkloadItem = "SQLInstance"
	// WorkloadItemTypeWorkloadItem ...
	WorkloadItemTypeWorkloadItem WorkloadItemTypeBasicWorkloadItem = "WorkloadItem"
)

// PossibleWorkloadItemTypeBasicWorkloadItemValues returns an array of possible values for the WorkloadItemTypeBasicWorkloadItem const type.
func PossibleWorkloadItemTypeBasicWorkloadItemValues() []WorkloadItemTypeBasicWorkloadItem {
	return []WorkloadItemTypeBasicWorkloadItem{WorkloadItemTypeAzureVMWorkloadItem, WorkloadItemTypeSAPAseDatabase1, WorkloadItemTypeSAPAseSystem1, WorkloadItemTypeSAPHanaDatabase1, WorkloadItemTypeSAPHanaSystem1, WorkloadItemTypeSQLDataBase1, WorkloadItemTypeSQLInstance1, WorkloadItemTypeWorkloadItem}
}

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// WorkloadTypeAzureFileShare ...
	WorkloadTypeAzureFileShare WorkloadType = "AzureFileShare"
	// WorkloadTypeAzureSQLDb ...
	WorkloadTypeAzureSQLDb WorkloadType = "AzureSqlDb"
	// WorkloadTypeClient ...
	WorkloadTypeClient WorkloadType = "Client"
	// WorkloadTypeExchange ...
	WorkloadTypeExchange WorkloadType = "Exchange"
	// WorkloadTypeFileFolder ...
	WorkloadTypeFileFolder WorkloadType = "FileFolder"
	// WorkloadTypeGenericDataSource ...
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	// WorkloadTypeInvalid ...
	WorkloadTypeInvalid WorkloadType = "Invalid"
	// WorkloadTypeSAPAseDatabase ...
	WorkloadTypeSAPAseDatabase WorkloadType = "SAPAseDatabase"
	// WorkloadTypeSAPHanaDatabase ...
	WorkloadTypeSAPHanaDatabase WorkloadType = "SAPHanaDatabase"
	// WorkloadTypeSharepoint ...
	WorkloadTypeSharepoint WorkloadType = "Sharepoint"
	// WorkloadTypeSQLDataBase ...
	WorkloadTypeSQLDataBase WorkloadType = "SQLDataBase"
	// WorkloadTypeSQLDB ...
	WorkloadTypeSQLDB WorkloadType = "SQLDB"
	// WorkloadTypeSystemState ...
	WorkloadTypeSystemState WorkloadType = "SystemState"
	// WorkloadTypeVM ...
	WorkloadTypeVM WorkloadType = "VM"
	// WorkloadTypeVMwareVM ...
	WorkloadTypeVMwareVM WorkloadType = "VMwareVM"
)

// PossibleWorkloadTypeValues returns an array of possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{WorkloadTypeAzureFileShare, WorkloadTypeAzureSQLDb, WorkloadTypeClient, WorkloadTypeExchange, WorkloadTypeFileFolder, WorkloadTypeGenericDataSource, WorkloadTypeInvalid, WorkloadTypeSAPAseDatabase, WorkloadTypeSAPHanaDatabase, WorkloadTypeSharepoint, WorkloadTypeSQLDataBase, WorkloadTypeSQLDB, WorkloadTypeSystemState, WorkloadTypeVM, WorkloadTypeVMwareVM}
}
