package attestation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CertificateModification enumerates the values for certificate modification.
type CertificateModification string

const (
	// IsAbsent After the operation was performed, the certificate is no longer present in the set of
	// certificates.
	IsAbsent CertificateModification = "IsAbsent"
	// IsPresent After the operation was performed, the certificate is in the set of certificates.
	IsPresent CertificateModification = "IsPresent"
)

// PossibleCertificateModificationValues returns an array of possible values for the CertificateModification const type.
func PossibleCertificateModificationValues() []CertificateModification {
	return []CertificateModification{IsAbsent, IsPresent}
}

// DataType enumerates the values for data type.
type DataType string

const (
	// Binary The contents of the field should be treated as binary and not interpreted by MAA.
	Binary DataType = "Binary"
	// JSON The contents of the field should be treated as a JSON object and may be further interpreted by MAA.
	JSON DataType = "JSON"
)

// PossibleDataTypeValues returns an array of possible values for the DataType const type.
func PossibleDataTypeValues() []DataType {
	return []DataType{Binary, JSON}
}

// PolicyModification enumerates the values for policy modification.
type PolicyModification string

const (
	// Removed The specified policy object was removed.
	Removed PolicyModification = "Removed"
	// Updated The specified policy object was updated.
	Updated PolicyModification = "Updated"
)

// PossiblePolicyModificationValues returns an array of possible values for the PolicyModification const type.
func PossiblePolicyModificationValues() []PolicyModification {
	return []PolicyModification{Removed, Updated}
}

// Type enumerates the values for type.
type Type string

const (
	// OpenEnclave OpenEnclave extensions to SGX
	OpenEnclave Type = "OpenEnclave"
	// SgxEnclave Intel Software Guard eXtensions
	SgxEnclave Type = "SgxEnclave"
	// Tpm Edge TPM Virtualization Based Security
	Tpm Type = "Tpm"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{OpenEnclave, SgxEnclave, Tpm}
}
