# Changelog

This changelog goes through the changes that have been made in each release
without substantial changes to our git log; to see the highlights of what has
been added to each release, please refer to the [blog](https://blog.gitea.com).

## [1.24.6](https://github.com/go-gitea/gitea/releases/tag/1.24.6) - 2025-09-10

* SECURITY
  * Upgrade xz to v0.5.15 (#35385)
* BUGFIXES
  * Fix a compare page 404 bug when the pull request disabled (#35441) (#35453)
  * Fix bug when issue disabled, pull request number in the commit message cannot be redirected (#35420) (#35442)
  * Add author.name field to Swift Package Registry API response (#35410) (#35431)
  * Remove usernames when empty in discord webhook (#35412) (#35417)
  * Allow foreachref parser to grow its buffer (#35365) (#35376)
  * Allow deleting comment with content via API like web did (#35346) (#35354)
  * Fix atom/rss mixed error (#35345) (#35347)
  * Fix review request webhook bug (#35339)
  * Remove duplicate html IDs (#35210) (#35325)
  * Fix LFS range size header response (#35277) (#35293)
  * Fix GitHub release assets URL validation (#35287) (#35290)
  * Fix token lifetime, closes #35230 (#35271) (#35281)
  * Fix push commits comments when changing the pull request target branch (#35386) (#35443)

## [1.24.5](https://github.com/go-gitea/gitea/releases/tag/v1.24.5) - 2025-08-12

* BUGFIXES
  * Fix a bug where lfs gc never worked. (#35198) (#35255)
  * Reload issue when sending webhook to make num comments is right. (#35243) (#35248)
  * Fix bug when review pull request commits (#35192) (#35246)
* MISC
  * Vertically center "Show Resolved" (#35211) (#35218)

## [1.24.4](https://github.com/go-gitea/gitea/releases/tag/v1.24.4) - 2025-08-03

* BUGFIXES
  * Fix various bugs (1.24) (#35186)
  * Fix migrate input box bug (#35166) (#35171)
  * Only hide dropzone when no files have been uploaded (#35156) (#35167)
  * Fix review comment/dimiss comment x reference can be refereced back (#35094) (#35099)
  * Fix submodule nil check (#35096) (#35098)
* MISC
  * Don't use full-file highlight when there is a git diff textconv (#35114) (#35119)
  * Increase gap on latest commit (#35104) (#35113)

## [1.24.3](https://github.com/go-gitea/gitea/releases/tag/v1.24.3) - 2025-07-15

* BUGFIXES
  * Fix form property assignment edge case (#35073) (#35078)
  * Improve submodule relative path handling (#35056) (#35075)
  * Fix incorrect comment diff hunk parsing, fix github asset ID nil panic (#35046) (#35055)
  * Fix updating user visibility (#35036) (#35044)
  * Support base64-encoded agit push options (#35037) (#35041)
  * Make submodule link work with relative path (#35034) (#35038)
  * Fix bug when displaying git user avatar in commits list (#35006)
  * Fix API response for swagger spec (#35029)
  * Start automerge check again after the conflict check and the schedule (#34988) (#35002)
  * Fix the response format for actions/workflows (#35009) (#35016)
  * Fix repo settings and protocol log problems (#35012) (#35013)
  * Fix project images scroll (#34971) (#34972)
  * Mark old reviews as stale on agit pr updates (#34933) (#34965)
  * Fix git graph page (#34948) (#34949)
  * Don't send trigger for a pending review's comment create/update/delete (#34928) (#34939)
  * Fix some log and UI problems (#34863) (#34868)
  * Fix archive API (#34853) (#34857)
  * Ignore force pushes for changed files in a PR review (#34837) (#34843)
  * Fix SSH LFS timeout (#34838) (#34842)
  * Fix team permissions (#34827) (#34836)
  * Fix job status aggregation logic (#34823) (#34835)
  * Fix issue filter (#34914) (#34915)
  * Fix typo in pull request merge warning message text (#34899) (#34903)
  * Support the open-icon of folder (#34168) (#34896)
  * Optimize flex layout of release attachment area (#34885) (#34886)
  * Fix the issue of abnormal interface when there is no issue-item on the project page (#34791) (#34880)
  * Skip updating timestamp when sync branch (#34875)
  * Fix required contexts and commit status matching bug (#34815) (#34829)

## [1.24.2](https://github.com/go-gitea/gitea/releases/tag/v1.24.2) - 2025-06-20

* BUGFIXES
  * Fix container range bug (#34795) (#34796)
  * Upgrade chi to v5.2.2 (#34798) (#34799)
* BUILD
  * Bump poetry feature to new url for dev container (#34787) (#34790)

## [1.24.1](https://github.com/go-gitea/gitea/releases/tag/v1.24.1) - 2025-06-18

* ENHANCEMENTS
  * Improve alignment of commit status icon on commit page (#34750) (#34757)
  * Support title and body query parameters for new PRs (#34537) (#34752)

* BUGFIXES
  * When using rules to delete packages, remove unclean bugs (#34632) (#34761)
  * Fix ghost user in feeds when pushing in an actions, it should be gitea-actions (#34703) (#34756)
  * Prevent double markdown link brackets when pasting URL (#34745) (#34748)
  * Prevent duplicate form submissions when creating forks (#34714) (#34735)
  * Fix markdown wrap (#34697) (#34702)
  * Fix pull requests API convert panic when head repository is deleted. (#34685) (#34687)
  * Fix commit message rendering and some UI problems (#34680) (#34683)
  * Fix container range bug (#34725) (#34732)
  * Fix incorrect cli default values (#34765) (#34766)
  * Fix dropdown filter (#34708) (#34711)
  * Hide href attribute of a tag if there is no target_url (#34556) (#34684)
  * Fix tag target (#34781) #34783

## [1.24.0](https://github.com/go-gitea/gitea/releases/tag/v1.24.0) - 2025-05-26

* BREAKING
  * Make Gitea always use its internal config, ignore `/etc/gitconfig` (#33076)
  * Improve log format (#33814)
  * Fix markdown render behaviors (#34122)
  * Add package version api endpoints (#34173)

* FEATURES
  * Enforce two-factor auth (2FA: TOTP or WebAuthn) (#34187)
  * Add fullscreen mode as a more efficient operation way to view projects (#34081)
  * Add anonymous access support for private/unlisted repositories (#34051)
  * Support public code/issue access for private repositories (#33127)
  * Add middleware for request prioritization (#33951)
  * Add cli flags LDAP group configuration (#33933)
  * Add file tree to file view page (#32721)
  * Add material icons for file list (#33837)
  * Artifacts download api for artifact actions v4 (#33510)
  * Support choose email when creating a commit via web UI (#33432)
  * Add basic auth support to rss/atom feeds (#33371)
  * Add sorting by exclusive labels (issue priority) (#33206)
  * Add sub issue list support (#32940)
  * Private README.md for organization (#32872)
  * Email option to embed images as base64 instead of link (#32061)
  * Option to delay conflict checking of old pull requests until page view (#27779)
  * Worktime tracking for the organization level (#19808)

* PERFORMANCE
  * Add cache for common package queries (#22491)
  * Move issue pin to an standalone table for querying performance (#33452)
  * Improve commits list performance to reduce unnecessary database queries (#33528)
  * Optimize total count of feed when loading activities in user dashboard. (#33841)
  * Optimize heatmap query (#33853)
  * Only use prev and next buttons for pagination on user dashboard (#33981)
  * Improve pull request list API performance (#34052)
  * Cache GPG keys, emails and users when list commits (#34086)
  * Refactor Git Attribute & performance optimization (#34154)
  * Performance optimization for tags synchronization (#34355) #34522

* ENHANCEMENTS
  * Code
    * Display when a release attachment was uploaded (#34261)
    * Support creating relative link to raw path in markdown (#34105)
    * Improve code block readability and isolate copy button (#34009)
    * Improve repository commit view (#33877)
    * Full-file syntax highlighting for diff pages (#33766)
    * Clone repository with Tea CLI (#33725)
    * Improve sync fork behavior (#33319)
    * Make git clone URL could use current signed-in user (#33091)
    * Add submodule diff links (#33097)
    * Link to tree views of submodules if possible (#33424)
    * Only keep popular licenses (#33832)
    * De-emphasize signed commits (#31160)

  * Actions
    * Add flat-square action badge style (#34062)
    * Update action status badge layout (#34018)
    * Download actions job logs from API (#33858)
    * Always show the "rerun" button for action jobs (#33692)
    * Add auto-expanding running actions step (#30058)
    * Update status check for all supported on.pull_request.types in Gitea (#33117)
    * Workflow_dispatch use workflow from trigger branch (#33098)
    * Add action auto-scroll (#30057)
    * Add workflow_job webhook (#33694)
    * Add a button editing action secret (#34462)

  * Pull Request
    * Auto expand "New PR" form (#33971)
    * Mark parent directory as viewed when all files are viewed (#33958)
    * Show info about maintainers are allowed to edit a PR (#33738)
    * Automerge supports deleting branch automatically after merging (#32343)
    * Add additional command hints for PowerShell & CMD (#33548)

  * Issues
    * Allow filtering issues by any assignee (#33343)
    * Show warning on navigation if currently editing comment or title (#32920)
    * Make tracked time representation display as hours (#33315)
    * Add No Results Prompt Message on Issue List Page (#33699)
    * Add sort option recentclose for issues and pulls (#34525) #34539

  * Packages
    * Link to nuget dependencies (#26554)
    * Add composor source field (#33502)

  * Administration
    * Improve navbar: add "admin" tip, add "active" style (#32927)
    * Add a option "--user-type bot" to admin user create, improve role display (#27885)
    * Improve admin user view page (#33735)
    * Support performance trace (#32973)
    * Change pprof labels to be prometheus compatible (#32865)
    * Allow admins and org owners to change org member public status (#28294)
    * Optimize the installation page (#32994)
    * Make public URL generation configurable (#34250)
    * Add a --fullname arg to gitea admin user create. (#34241)

  * Others
    * Improve oauth2 error handling (#33969)
    * Fail mirroring more gracefully (#34002)
    * Align User Details Page Header Layout with Design Specifications (#34192)
    * Webhook add X-Gitea-Hook-Installation-Target-Type Header (#33752)
    * Optimize the dashboard (#32990)
    * Improve button layout on small screens (#33633)
    * Add cropping support when modifying the user/org/repo avatar (#33498)
    * Make ROOT_URL support using request Host header (#32564)
    * Add `show more` organizations icon in user's profile (#32986)
    * Introduce `--page-space-bottom` at 64px (#30692)
    * Improve theme display (#30671)
    * Add alphabetical project sorting (#33504)
    * Add global lock for migrations to make upgrade more safe with multiple replications (#33706)
    * Add descriptions for private repo public access settings and improve the UI (#34057)

* API
  * Actions Runner rest api (#33873)
  * Inclusion of rename organization api (#33303)
  * Add API to support link package to repository and unlink it (#33481)
  * Add API endpoint to request contents of multiple files simultaniously (#34139)
  * Actions artifacts API list/download check status upload confirmed (#34273)
  * Add API routes to lock and unlock issues (#34165)
  * Fix some user name usages (#33689)
  * Allow filtering /repos/{owner}/{repo}/pulls by target base branch queryparam (#33684)
  * Improve swagger generation (#33664)
  * Support Ephemeral action runners (#33570)
  * Support workflow event dispatch via API (#33545)
  * Support workflow event dispatch via API (#32059)
  * Added Description Field for Secrets and Variables  (#33526)
  * Reject star-related requests if stars are disabled (#33208)
  * Let API create and edit system webhooks, attempt 2 (#33180)
  * Use `Project-URL` metadata field to get a PyPI package's homepage URL (#33089)
  * Add `last_committer_date` and `last_author_date` for file contents API (#32921)

* REFACTORS
  * Remove context from git struct (#33793)
  * Refactor admin/common.ts (#33788)
  * Refactor repo-settings.ts (#33785)
  * Refactor repo-issue.ts (#33784)
  * Small refactor to reduce unnecessary database queries and remove duplicated functions (#33779)
  * Refactor initRepoBranchTagSelector to use new init framework (#33776)
  * Refactor buttons to use new init framework (#33774)
  * Refactor markup and pdf-viewer to use new init framework (#33772)
  * Refactor error system (#33771)
  * Refactor mail code (#33768)
  * Update TypeScript types (#33799)
  * Refactor older tests to use testify (#33140)
  * Move notifywatch to service layer (#33825)
  * Decouple context from repository related structs (#33823)
  * Remove context from mail struct (#33811)
  * Refactor dropdown ellipsis (#34123)
  * Refactor functions to reduce repopath expose (#33892)
  * Refactor repo-diff.ts (#33746)
  * Refactor web route handler (#33488)
  * Refactor user & avatar (#33433)
  * Refactor user package (#33423)
  * Refactor decouple context from migration structs (#33399)
  * Refactor context flash msg and global variables (#33375)
  * Refactor response writer & access logger (#33323)
  * Refactor ref type (#33242)
  * Refactor context repository (#33202)
  * Refactor legacy JS (#33115)
  * Refactor legacy line-number and scroll code (#33094)
  * Refactor env var related code (#33075)
  * Move SetMerged to service layer (#33045)
  * Merge updatecommentattachment functions (#33044)
  * Refactor pull-request compare&create page (#33071)
  * Refactor repo-new.ts (#33070)
  * Refactor pagination (#33037)
  * Refactor tests (#33021)
  * Refactor markup render to fix various path problems (#34114)
  * Refactor Branch struct in package modules/git (#33980)
  * Don't create duplicated functions for code repositories and wiki repositories (#33924)
  * Move git references checking to gitrepo packages to reduce expose of repository path (#33891)
  * Refactor cache-control (#33861)
  * Decouple diff stats query from actual diffing (#33810)
  * Move part of updating protected branch logic to service layer (#33742)
  * Decouple Batch from git.Repository to simplify usage without requiring the creation of a Repository struct. (#34001)
  * Refactor tmpl and blob_excerpt (#32967)
  * Refactor template & test related code (#32938)
  * Refactor db package and remove unnecessary `DumpTables` (#32930)
  * Refactor pprof labels and process desc (#32909)
  * Refactor repo-projects.ts (#32892)
  * Refactor getpatch/getdiff functions and remove unnecessary fallback (#32817)
  * Uniform all temporary directories and allow customizing temp path (#32352)
  * Remove context from retry downloader (#33871)
  * Refactor global init code and add more comments (#33755)
  * Remove some unnecessary template helpers (#33069)
  * Move and rename UpdateRepository (#34136)
  * Move hooks function to gitrepo and reduce expose repopath (#33890)
  * Add abstraction layer to delete repository from disk (#33879)
  * Add abstraction layer to check if the repository exists on disk (#33874)
  * Move ParseCommitWithSSHSignature to service layer (#34087)
  * Move duplicated functions (#33977)
  * Extract code to their own functions for push update (#33944)
  * Move gitgraph from modules to services layer (#33527)
  * Move commits signature and verify functions to service layers (#33605)
  * Use `CloseIssue` and `ReopenIssue` instead of `ChangeStatus` (#32467)
  * Refactor arch route handlers (#32993)
  * Refactor "string truncate" (#32984)
  * Refactor arch route handlers (#32972)
  * Clarify path param naming (#32969)
  * Refactor request context (#32956)
  * Move some errors to their own sub packages (#32880)
  * Move RepoTransfer from models to models/repo sub package (#32506)
  * Move delete deploy keys into service layer (#32201)
  * Refactor webhook events (#33337)
  * Move some Actions related functions from `routers` to `services` (#33280)
  * Refactor RefName (#33234)
  * Refactor context RefName and RepoAssignment (#33226)
  * Refactor repository transfer (#33211)
  * Refactor error system (#33626)
  * Refactor error system (#33610)
  * Refactor package (routes and error handling, npm peer dependency) (#33111)
  * Use test context in tests and new loop system in benchmarks (#33648)
  * Some small refactors (#33144)
  * Simplify context ref name (#33267)

* BUGFIXES
  * Fix some dropdown problems on the issue sidebar (#34308) #34327
  * Do not return archive download URLs in API if downloads are disabled (#34324) #34338
  * Fix LFS files being editable in web UI (#34356) #34362
  * Fix only text/* being viewable in web UI (#34374) #34378
  * Fix LFS file not stored in LFS when uploaded/edited via API or web UI (#34367)
  * Grey out expired artifact on Artifacts list (#34314) #34404
  * Fix incorrect divergence cache after switching default branch (#34370) #34406
  * Refactor commit message rendering and fix bugs (#34412) #34414
  * Merge and tweak markup editor expander CSS (#34409) #34415
  * Fix GetUsersByEmails (#34423) #34425
  * Only git operations should update last changed of a repository (#34388) #34427
  * Fix comment textarea scroll issue in Firefox (#34438) #34446
  * Fix repo broken check (#34444) #34452
  * Fix remove org user failure on mssql (#34449) #34453
  * Fix Workflow run Not Found page (#34459) #34466
  * When updating comment, if the content is the same, just return and not update the database (#34422) #34464
  * Fix project board view (#34470) #34475
  * Fix get / delete runner to use consistent http 404 and 500 status (#34480) #34488
  * Fix url validation in webhook add/edit API (#34492) #34496
  * Fix edithook api can not update package, status and workflow_job events (#34495) #34499
  * Fix ephemeral runner deletion (#34447) #34513
  * Don't display error log when .git-blame-ignore-revs doesn't exist (#34457)
  * Only allow admins to rename default/protected branches (#33276)
  * Improve "lock conversation" UI (#34207)
  * Fix incorrect file links (#34189)
  * Optimize Overflow Menu (#34183)
  * Check user/org repo limit instead of doer (#34147)
  * Make markdown render match GitHub's behavior (#34129)
  * Fix team permission (#34128)
  * Correctly handle submodule view and avoid throwing 500 error (#34121)
  * Fix users being able bypass limits with repo transfers (#34031)
  * Avoid creating unnecessary temporary cat file sub process (#33942)
  * Refactor organization menu (#33928)
  * Fix various Fomantic UI and htmx problems (#33851)
  * Fix 500 error when error occurred in migration page (#33256)
  * Validate that the tag doesn't exist when creating a tag via the web (#33241)
  * Add missed transaction on setmerged (#33079)
  * Rework create/fork/adopt/generate repository to make sure resources will be cleanup once failed (#31035)
  * Valid email address should only start with alphanumeric (#28174)
  * Fix webhook url (#34186)
  * Fix "toAbsoluteLocaleDate" test when system locale is not en-US (#33939)
  * Fix file name could not be searched if the file was not a text file when using the Bleve indexer (#33959)
  * Fix cannot delete runners via the modal dialog (#33895)
  * Fix unpin hint on the pinned pull requests (#33207)
  * Fix parentCommit invalid memory address or nil pointer dereference. (#33204)
  * Fix comment header padding (#33377)
  * Fix some migration and repo name problems (#33986)
  * Fix various trivial frontend problems (#34263)
  * Fix Set Email Preference dropdown and button placement (#34255)
  * Fix quoted replies incorrectly render user input as part of the quote (#34216)
  * Fix button alignments and remove unnecessary styles (#34206)
  * Restore form inputs on organization create error (#34201)
  * Try to fix ACME (3rd) (#33807)
  * Fix incorrect ref "blob" (#33240)
  * Fix dynamic content loading init problem (#33748)
  * Fix git empty check and HEAD request (#33690)
  * Fix Untranslated Text on Actions Page (#33635)
  * Fix issue label delete incorrect labels webhook payload (#34575)
  * Fix incorrect page navigation with up and down arrow on last item of dashboard repos (#34570)
  * Fix/improve avatar sync from LDAP (#34573)
  * Fix some trivial problems (#34579)
  * Retain issue sort type when a keyword search is introduced (#34559)
  * Always use an empty line to separate the commit message and trailer (#34512)
  * Fix line-button issue after file selection in file tree (#34574)
  * Fix doctor deleting orphaned issues attachments (#34142)
  * Add webhook assigning test and fix possible bug (#34420)
  * Fix possible nil description of pull request when migrating from CodeCommit (#34541)
  * Refactor commit reader (#34542)
  * Fix possible pull request broken when leave the page immediately after clicking the update button #34509
  * Ignore "Close" error when uploading container blob (#34620)
  * Fix missed merge commit sha and time when migrating from codecommit (#34645)
  * Fix GetUsersByEmails (#34643)
  * Misc CSS fixes (#34638)
  * Add codecommit to supported services in api docs (#34626)
  * Validate hex colors when creating/editing labels (#34623)
  * Fix possible pull request broken when leave the page immediately after clicking the update button (#34509)
  * Fix margin issue in markup paragraph rendering (#34599)
  * Fix migration pull request title too long (#34577)
  * Fix footnote jump behavior on the issue page. (#34621)
  * Fix "oras" OCI client compatibility (#34666)
  * Fix last admin check when syncing users (#34649)
  * Fix skip paths check on tag push events in workflows (#34602) #34670

* MISC

  * Bump to alpine 3.22 (#34613)
  * Make pull request and issue history more compact (#34588)
  * Run integration tests against postgres 14 (#34514) #34536
  * Enable addtional linters (#34085)
  * Enable testifylint rules (#34075)
  * Enable staticcheck QFxxxx rules (#34064)
  * Improve Actions test (#32883)
  * Drop fomantic build (#33845)
  * Go1.24 (#33562)
  * Run yamllint with strict mode, fix issue (#33551)
  * Disable cron task to update license (#33486)
  * Optimize makefile help information generation (#33390)
  * Convert github.com/xanzy/go-gitlab into gitlab.com/gitlab-org/api/client-go (#33126)
  * Add missed changelogs (#33649)
  * Update .changelog file to add performance label group (#33472)
  * Add missing POPULATE_SQUASH_COMMENT_WITH_COMMIT_MESSAGES in app.example.ini (#33363)
  * Update README screenshots (#33347)
  * Update unrs-resolver (#34279)
  * Update go&js dependencies (#34262)
  * Optimize the calling code of queryElems (#34235)
  * Update protected_branch.tmpl (#34193)
  * Feat/optimize span svg layout (#34185)
  * Set MERMAID_MAX_SOURCE_CHARACTERS to 50000 (#34152)
  * Update JS and PY deps (#34143)
  * Add Chinese translations for README files (#34132)
  * Use `overflow-wrap: anywhere` to replace `word-break: break-all` (#34126)
  * Clarify ownership in password change error messages (#34092)
  * Add toggleClass function in dom.ts (#34063)
  * Update to golangci-lint v2 (#34054)
  * Update Makefile test comments (#34013)
  * Update go mod dependencies (#33988)
  * Use filepath.Join instead of path.Join for file system file operations (#33978)
  * Prepare common tmpl functions in a middleware (#33957)
  * Remove unused or abused styles (#33918)
  * Update JS and PY deps, misc tweaks (#33903)
  * Try to figure out attribute checker problem (#33901)
  * Add lock for a repository pull mirror (#33876)
  * Fine tune push mirror UI (#33866)
  * Improve issue & code search (#33860)
  * Use pullrequestlist instead of []*pullrequest (#33765)
  * Upgrade act to 0.261.4 and actions-proto-go to v0.4.1 (#33760)
  * Align sidebar gears to the right (#33721)
  * Update Go dependencies (skip blevesearch, meilisearch) (#33655)
  * Add migrations and doctor fixes (#33556)
  * Remove "class-name" from svg icon (#33540)
  * Update MAINTAINERS (#33529)
  * Add "No data available" display when list is empty (#33517)
  * Use `git diff-tree` for `DiffFileTree` on diff pages (#33514)
  * Give organisation members access to organisation feeds (#33508)
  * Update feishu icon (#33470)
  * Hide/disable unusable UI elements when a repository is archived (#33459)
  * Update `@github/text-expander-element` to 2.9.0 (#33435)
  * Do not access GitRepo when a repo is being created (#33380)
  * Fix incorrect ref usages (#33301)
  * Prepare for support performance trace (#33286)
  * Enable Typescript `noImplicitThis` (#33250)
  * Remove unused CSS styles and move some styles to proper files (#33217)
  * Add .run to gitignore (#33175)
  * Fix typo in gitea downloader test and add missing codebase in `ToGitServiceType` (#33146)
  * Remove extended glob pattern from branch protection UI (#33125)
  * Clean up legacy form CSS styles (#33081)
  * Unset XDG_HOME_CONFIG as gitea manages configuration locations (#33067)
  * Add IntelliJ Gateway's .uuid to gitignore (#33052)
  * User facing messages for AGit errors (#33012)
  * Always show assignees on right (#33006)
  * Fix eslint (#33002)
  * Update JS dependencies (#32914)
  * Bump x/net (#32896) (#32900)
  * Only activity tab needs heatmap data loading (#34652)

## [1.23.8](https://github.com/go-gitea/gitea/releases/tag/v1.23.8) - 2025-05-11

* SECURITY
  * Fix a bug when uploading file via lfs ssh command (#34408) (#34411)
  * Update net package (#34228) (#34232)
* BUGFIXES
  * Fix releases sidebar navigation link (#34436) #34439
  * Fix bug webhook milestone is not right. (#34419) #34429
  * Fix two missed null value checks on the wiki page. (#34205) (#34215)
  * Swift files can be passed either as file or as form value (#34068) (#34236)
  * Fix bug when API get pull changed files for deleted head repository (#34333) (#34368)
  * Upgrade github v61 -> v71 to fix migrating bug (#34389)
  * Fix bug when visiting comparation page (#34334) (#34364)
  * Fix wrong review requests when updating the pull request (#34286) (#34304)
  * Fix github migration error when using multiple tokens (#34144) (#34302)
  * Explicitly not update indexes when sync database schemas (#34281) (#34295)
  * Fix panic when comment is nil (#34257) (#34277)
  * Fix project board links to related Pull Requests (#34213) (#34222)
  * Don't assume the default wiki branch is master in the wiki API (#34244) (#34245)
* DOCUMENTATION
  * Update token creation API swagger documentation (#34288) (#34296)
* MISC
  * Fix CI Build (#34315)
  * Add riscv64 support (#34199) (#34204)
  * Bump go version in go.mod (#34160)
  * remove hardcoded 'code' string in clone_panel.tmpl (#34153) (#34158)

## [1.23.7](https://github.com/go-gitea/gitea/releases/tag/v1.23.7) - 2025-04-07

* Enhancements
  * Add a config option to block "expensive" pages for anonymous users (#34024) (#34071)
  * Also check default ssh-cert location for host (#34099) (#34100) (#34116)
* BUGFIXES
  * Fix discord webhook 400 status code when description limit is exceeded (#34084) (#34124)
  * Get changed files based on merge base when checking `pull_request` actions trigger (#34106) (#34120)
  * Fix invalid version in RPM package path (#34112) (#34115)
  * Return default avatar url when user id is zero rather than updating database (#34094) (#34095)
  * Add additional ReplaceAll in pathsep to cater for different pathsep (#34061) (#34070)
  * Try to fix check-attr bug (#34029) (#34033)
  * Git client will follow 301 but 307 (#34005) (#34010)
  * Fix block expensive for 1.23 (#34127)
  * Fix markdown frontmatter rendering (#34102) (#34107)
  * Add new CLI flags to set name and scopes when creating a user with access token (#34080) (#34103)
  * Do not show 500 error when default branch doesn't exist (#34096) (#34097)
  * Hide activity contributors, recent commits and code frequrency left tabs if there is no code permission (#34053) (#34065)
  * Simplify emoji rendering (#34048) (#34049)
  * Adjust the layout of the toolbar on the Issues/Projects page (#33667) (#34047)
  * Pull request updates will also trigger code owners review requests (#33744) (#34045)
  * Fix org repo creation being limited by user limits (#34030) (#34044)
  * Fix git client accessing renamed repo (#34034) (#34043)
  * Fix the issue with error message logging for the `check-attr` command on Windows OS. (#34035) (#34036)
  * Polyfill WeakRef (#34025) (#34028)

## [1.23.6](https://github.com/go-gitea/gitea/releases/tag/v1.23.6) - 2025-03-24

* SECURITY
  * Fix LFS URL (#33840) (#33843)
  * Update jwt and redis packages (#33984) (#33987)
  * Update golang crypto and net (#33989)
* BUGFIXES
  * Drop timeout for requests made to the internal hook api (#33947) (#33970)
  * Fix maven panic when no package exists (#33888) (#33889)
  * Fix markdown render (#33870) (#33875)
  * Fix auto concurrency cancellation skips commit status updates (#33764) (#33849)
  * Fix oauth2 auth (#33961) (#33962)
  * Fix incorrect 1.23 translations (#33932)
  * Try to figure out attribute checker problem (#33901) (#33902)
  * Ignore trivial errors when updating push data (#33864) (#33887)
  * Fix some UI problems for 1.23 (#33856)
  * Removing unwanted ui container (#33833) (#33835)
  * Support disable passkey auth (#33348) (#33819)
  * Do not call "git diff" when listing PRs (#33817)
  * Try to fix ACME (3rd) (#33807) (#33808)
  * Fix incorrect code search indexer options (#33992) #33999

## [1.23.5](https://github.com/go-gitea/gitea/releases/tag/v1.23.5) - 2025-03-04

* SECURITY
  * Bump x/oauth2 & x/crypto (#33704) (#33727)
* PERFORMANCE
  * Optimize user dashboard loading (#33686) (#33708)
* BUGFIXES
  * Fix navbar dropdown item align (#33782)
  * Fix inconsistent closed issue list icon (#33722) (#33728)
  * Fix for Maven Package Naming Convention Handling (#33678) (#33679)
  * Improve Open-with URL encoding (#33666) (#33680)
  * Deleting repository should unlink all related packages (#33653) (#33673)
  * Fix omitempty bug (#33663) (#33670)
  * Upgrade go-crypto from 1.1.4 to 1.1.6 (#33745) (#33754)
  * Fix OCI image.version annotation for releases to use full semver (#33698) (#33701)
  * Try to fix ACME path when renew (#33668) (#33693)
  * Fix mCaptcha bug (#33659) (#33661)
  * Git graph: don't show detached commits (#33645) (#33650)
  * Use MatchPhraseQuery for bleve code search (#33628)
  * Adjust appearence of commit status webhook (#33778) #33789
  * Upgrade golang net from 0.35.0 -> 0.36.0 (#33795) #33796

## [1.23.4](https://github.com/go-gitea/gitea/releases/tag/v1.23.4) - 2025-02-16

* SECURITY
  * Enhance routers for the Actions variable operations (#33547) (#33553)
  * Enhance routers for the Actions runner operations (#33549) (#33555)
  * Fix project issues list and counting (#33594) #33619
* PERFORMANCES
  * Performance optimization for pull request files loading comments attachments (#33585) (#33592)
* BUGFIXES
  * Add a transaction to `pickTask` (#33543) (#33563)
  * Fix mirror bug (#33597) (#33607)
  * Use default Git timeout when checking repo health (#33593) (#33598)
  * Fix PR's target branch dropdown (#33589) (#33591)
  * Fix various problems (artifact order, api empty slice, assignee check, fuzzy prompt, mirror proxy, adopt git) (#33569) (#33577)
  * Rework suggestion backend (#33538) (#33546)
  * Fix context usage (#33554) (#33557)
  * Only show the latest version in the Arch index (#33262) (#33580)
  * Skip deletion error for action artifacts (#33476) (#33568)
  * Make actions URL in commit status webhooks absolute (#33620) #33632
  * Add missing locale (#33641) #33642

## [1.23.3](https://github.com/go-gitea/gitea/releases/tag/v1.23.3) - 2025-02-06

* Security
  * Build Gitea with Golang v1.23.6 to fix security bugs
* BUGFIXES
  * Fix a bug caused by status webhook template #33512

## [1.23.2](https://github.com/go-gitea/gitea/releases/tag/v1.23.2) - 2025-02-04

* BREAKING
  * Add tests for webhook and fix some webhook bugs (#33396) (#33442)
    * Package webhook’s Organization was incorrectly used as the User struct. This PR fixes the issue.
    * This changelog is just a hint. The change is not really breaking because most fields are the same, most users are not affected.
* ENHANCEMENTS
  * Clone button enhancements (#33362) (#33404)
  * Repo homepage styling tweaks (#33289) (#33381)
  * Add a confirm dialog for "sync fork" (#33270) (#33273)
  * Make tracked time representation display as hours (#33315) (#33334)
  * Improve sync fork behavior (#33319) (#33332)
* BUGFIXES
  * Fix code button alignment (#33345) (#33351)
  * Correct bot label `vertical-align` (#33477) (#33480)
  * Fix SSH LFS memory usage (#33455) (#33460)
  * Fix issue sidebar dropdown keyboard support (#33447) (#33450)
  * Fix user avatar (#33439)
  * Fix `GetCommitBranchStart` bug (#33298) (#33421)
  * Add pubdate for repository rss and add some tests (#33411) (#33416)
  * Add missed auto merge feed message on dashboard (#33309) (#33405)
  * Fix issue suggestion bug (#33389) (#33391)
  * Make issue suggestion work for all editors (#33340) (#33342)
  * Fix issue count (#33338) (#33341)
  * Fix Account linking page (#33325) (#33327)
  * Fix closed dependency title (#33285) (#33287)
  * Fix sidebar milestone link (#33269) (#33272)
  * Fix missing license when sync mirror (#33255) (#33258)
  * Fix upload file form (#33230) (#33233)
  * Fix mirror bug (#33224) (#33225)
  * Fix system admin cannot fork or get private fork with API (#33401) (#33417)
  * Fix push message behavior (#33215) (#33317)
  * Trivial fixes (#33304) (#33312)
  * Fix "stop time tracking button" on navbar (#33084) (#33300)
  * Fix tag route and empty repo (#33253)
  * Fix cache test triggered by non memory cache (#33220) (#33221)
  * Revert empty lfs ref name (#33454) (#33457)
  * Fix flex width (#33414) (#33418)
  * Fix commit status events (#33320) #33493
  * Fix unnecessary comment when moving issue on the same project column (#33496) #33499
  * Add timetzdata build tag to binary releases (#33463) #33503
* MISC
  * Use ProtonMail/go-crypto to replace keybase/go-crypto (#33402) (#33410)
  * Update katex to latest version (#33361)
  * Update go tool dependencies (#32916) (#33355)

## [1.23.1](https://github.com/go-gitea/gitea/releases/tag/v1.23.1) - 2025-01-09

* ENHANCEMENTS
  * Move repo size to sidebar (#33155) (#33182)
* BUGFIXES
  * Use updated path to s6-svscan after alpine upgrade (#33185) (#33188)
  * Fix fuzz test (#33156) (#33158)
  * Fix raw file API ref handling (#33172) (#33189)
  * Fix ACME panic (#33178) (#33186)
  * Fix branch dropdown not display ref name (#33159) (#33183)
  * Fix assignee list overlapping in Issue sidebar (#33176) (#33181)
  * Fix sync fork for consistency (#33147) #33192
  * Fix editor markdown not incrementing in a numbered list (#33187) #33193

## [1.23.0](https://github.com/go-gitea/gitea/releases/tag/v1.23.0) - 2025-01-08

* BREAKING
  * Rename config option `[camo].Allways` to `[camo].Always` (#32097)
  * Remove SHA1 for support for ssh rsa signing (#31857)
  * Use UTC as default timezone when schedule Actions cron tasks (#31742)
  * Delete Actions logs older than 1 year by default (#31735)
  * Make OIDC introspection authentication strictly require Client ID and secret (#31632)

* SECURITY
  * Include file extension checks in attachment API (#32151)
  * Include all security fixes which have been backported to v1.22

* FEATURES
  * Allow to fork repository into the same owner (#32819)
  * Support "merge upstream branch" (Sync fork) (#32741)
  * Add Arch package registry (#32692)
  * Allow to disable the password-based login (sign-in) form (#32687)
  * Allow cropping an avatar before setting it (#32565)
  * Support quote selected comments to reply (#32431)
  * Add reviewers selection to new pull request (#32403)
  * Suggestions for issues (#32327)
  * Add priority to protected branch (#32286)
  * Included tag search capabilities (#32045)
  * Add option to filter board cards by labels and assignees (#31999)
  * Add automatic light/dark option for the colorblind theme (#31997)
  * Support migration from AWS CodeCommit (#31981)
  * Introduce globallock as distributed locks (#31908 & #31813)
  * Support compression for Actions logs & enable by default (#31761 & #32013)
  * Add pure SSH LFS support (#31516)
  * Add Passkey login support (#31504)
  * Actions support workflow dispatch event (#28163)
  * Support repo license (#24872)
  * Issue time estimate, meaningful time tracking (#23113)
  * GitHub like repo home page (#32213 & #32847)
  * Rearrange Clone Panel (#31142)
  * Enhancing Gitea OAuth2 Provider with Granular Scopes for Resource Access (#32573)
  * Use env GITEA_RUNNER_REGISTRATION_TOKEN as global runner token (#32946) #32964
  * Update i18n.go - Language Picker (#32933) #32935

* PERFORMANCE
  * Perf: add extra index to notification table (#32395)
  * Introduce OrgList and add LoadTeams, optimaze Load teams for orgs (#32543)
  * Improve performance of diffs (#32393)
  * Make LFS http_client parallel within a batch. (#32369)
  * Add new index for action to resolve the performance problem (#32333)
  * Improve get feed with pagination (#31821)
  * Performance improvements for pull request list API (#30490)
  * Use batch database operations instead of one by one to optimze api pulls (#32680)
  * Use gitrepo.GetTreePathLatestCommit to get file lastest commit instead from latest commit cache (#32987) #33046

* ENHANCEMENTS
  * Code
    * Remove unnecessary border in repo home page sidebar (#32767)
    * Add 'Copy path' button to file view (#32584)
    * Improve diff file tree (#32658)
    * Add new [lfs_client].BATCH_SIZE and [server].LFS_MAX_BATCH_SIZE config settings. (#32307)
    * Updated tokenizer to better matching when search for code snippets (#32261)
    * Change the code search to sort results by relevance (#32134)
    * Support migrating GitHub/GitLab PR draft status (#32242)
    * Move lock icon position and add additional tooltips to branch list page (#31839)
    * Add tag name in the commits list (#31082)
    * Add `MAX_ROWS` option for CSV rendering (#30268)
    * Allow code search by filename (#32210)
    * Make git push options accept short name (#32245)
    * Repo file list enhancements (#32835)

  * Markdown & Editor
    * Refactor markdown math render, add dollor-backquote syntax support (#32831)
    * Make Monaco theme follow browser, fully type codeeditor.ts (#32756)
    * Refactor markdown editor and use it for milestone description editor (#32688)
    * Add some handy markdown editor features (#32400)
    * Improve markdown textarea for indentation and lists (#31406)

  * Issue
    * Add label/author/assignee filters to the user/org home issue list (#32779)
    * Refactor issue filter (labels, poster, assignee) (#32771)
    * Style unification for the issue_management area (#32605)
    * Add "View all branches/tags" entry to Branch Selector (#32653)
    * Improve textarea paste (#31948)
    * Add avif image file support (#32508)
    * Prevent from submitting issue/comment on uploading (#32263)
    * Issue Templates: add option to have dropdown printed list (#31577)
    * Allow searching issues by ID (#31479)
    * Add `is_archived` option for issue indexer (#32735)
    * Improve attachment upload methods (#30513)
    * Support issue template assignees (#31083)
    * Prevent simultaneous editing of comments and issues (#31053)
    * Add issue comment when moving issues from one column to another of the project (#29311)

  * Pull Request
    * Display head branch more comfortable on pull request view (#32000)
    * Simplify review UI (#31062)
    * Allow force push to protected branches (#28086)
    * Add line-through for deleted branch on pull request view page (#32500)
    * Support requested_reviewers data in comment webhook events (#26178)
    * Allow maintainers to view and edit files of private repos when "Allow maintainers to edit" is enabled (#32215)
    * Allow including `Reviewed-on`/`Reviewed-by` lines for custom merge messages (#31211)

  * Actions
    * Render job title as commit message (#32748)
    * Refactor RepoActionView.vue, add `::group::` support (#32713)
    * Make RepoActionView.vue support `##[group]` (#32770)
    * Support `pull_request_target` event for commit status (#31703)
    * Detect whether action view branch was deleted (#32764)
    * Allow users with write permission to run actions (#32644)
    * Show latest run when visit /run/latest (#31808)

  * Packages
    * Improve rubygems package registry (#31357)
    * Add support for npm bundleDependencies (#30751)
    * Add signature support for the RPM module (#27069)
    * Extract and display readme and comments for Composer packages (#30927)

  * Project
    * Add title to project view page (#32747)
    * Set the columns height to hug all its contents (#31726)
    * Rename project `board` -> `column` to make the UI less confusing (#30170)

  * User & Organazition
    * Use better name for userinfo structure (#32544)
    * Use user.FullName in Oauth2 id_token response (#32542)
    * Limit org member view of restricted users (#32211)
    * Allow disabling authentication related user features (#31535)
    * Add option to change mail from user display name (#31528)
    * Use FullName in Emails to address the recipient if possible (#31527)

  * Administration
    * Add support for a credentials chain for minio access (#31051)
    * Move admin routers from /admin to /-/admin (#32189)
    * Add cache test for admins (#31265)
    * Add option for mailer to override mail headers (#27860)
    * Azure blob storage support (#30995)
    * Supports forced use of S3 virtual-hosted style (#30969)
    * Move repository visibility to danger zone in the settings area (#31126)

  * Others
    * Remove urls from translations (#31950)
    * Simplify 404/500 page (#31409)
    * Optimize installation-page experience (#32558)
    * Refactor login page (#31530)
    * Add new event commit status creation and webhook implementation (#27151)
    * Repo Activity: count new issues that were closed (#31776)
    * Set manual `tabindex`es on login page (#31689)
    * Add `YEAR`, `MONTH`, `MONTH_ENGLISH`, `DAY` variables for template repos (#31584)
    * Add typescript guideline and typescript-specific eslint plugins and fix issues (#31521)
    * Make toast support preventDuplicates (#31501)
    * Fix tautological conditions (#30735)
    * Issue change title notifications (#33050) #33065

* API
  * Implement update branch API (#32433)
  * Fix missing outputs for jobs with matrix (#32823)
  * Make API "compare" accept commit IDs (#32801)
  * Add github compatible tarball download API endpoints (#32572)
  * Harden runner updateTask and updateLog api (#32462)
  * Add `DISABLE_ORGANIZATIONS_PAGE` and `DISABLE_CODE_PAGE` settings for explore pages and fix an issue related to user search (#32288)
  * Make admins adhere to branch protection rules (#32248)
  * Calculate `PublicOnly` for org membership only once (#32234)
  * Allow filtering PRs by poster in the ListPullRequests API (#32209)
  * Return 404 instead of error when commit not exist (#31977)
  * Save initial signup information for users to aid in spam prevention (#31852)
  * Fix upload maven pacakge parallelly (#31851)
  * Fix null requested_reviewer from API (#31773)
  * Add permission description for API to add repo collaborator (#31744)
  * Add return type to GetRawFileOrLFS and GetRawFile (#31680)
  * Add skip secondary authorization option for public oauth2 clients (#31454)
  * Add tag protection via rest api #17862 (#31295)
  * Document possible action types for the user activity feed API (#31196)
  * Add topics for repository API (#31127)
  * Add support for searching users by email (#30908)
  * Add API endpoints for getting action jobs status (#26673)

* REFACTOR
  * Update JS and PY dependencies (#31940)
  * Enable `no-jquery/no-parse-html-literal` and fix violation (#31684)
  * Refactor image diff (#31444)
  * Refactor CSRF token (#32216)
  * Fix some typescript issues (#32586)
  * Refactor names (#31405)
  * Use per package global lock for container uploads instead of memory lock (#31860)
  * Move team related functions to service layer (#32537)
  * Move GetFeeds to service layer (#32526)
  * Resolve lint for unused parameter and unnecessary type arguments (#30750)
  * Reimplement GetUserOrgsList to make it simple and clear (#32486)
  * Move some functions from issue.go to standalone files (#32468)
  * Refactor sidebar assignee&milestone&project selectors (#32465)
  * Refactor sidebar label selector (#32460)
  * Fix a number of typescript issues (#32459)
  * Refactor language menu and dom utils (#32450)
  * Refactor issue page info (#32445)
  * Split issue sidebar into small templates (#32444)
  * Refactor template ctx and render utils (#32422)
  * Refactor repo legacy (#32404)
  * Refactor markup package (#32399)
  * Refactor markup render system (#32533 & #32589 & #32612)
  * Refactor the DB migration system slightly (#32344)
  * Remove jQuery import from some files (#32512)
  * Strict pagination check (#32548)
  * Split mail sender sub package from mailer service package (#32618)
  * Remove outdated code about fixture generation (#32708)
  * Refactor RepoBranchTagSelector (#32681)
  * Refactor issue list (#32755)
  * Refactor LabelEdit (#32752)
  * Split issue/pull view router function as multiple smaller functions (#32749)
  * Refactor some LDAP code (#32849)
  * Unify repo search order by logic (#30876)
  * Remove duplicate empty repo check in delete branch API (#32569)
  * Replace deprecated `math/rand` functions (#30733)
  * Remove fomantic dimmer module (#30723)
  * Add types to fetch,toast,bootstrap,svg (#31627)
  * Refactor webhook (#31587)
  * Move AddCollabrator and CreateRepositoryByExample to service layer (#32419)
  * Refactor RepoRefByType (#32413)
  * Refactor: remove redundant err declarations (#32381)
  * Refactor markup code (#31399)
  * Refactor render system (orgmode) (#32671)
  * Refactor render system (#32492)
  * Refactor markdown render (#32736 & #32728)
  * Refactor repo unit "disabled" check (#31389)
  * Refactor route path normalization (#31381)
  * Refactor to use UnsafeStringToBytes (#31358)
  * Migrate vue components to setup (#32329)
  * Refactor globallock (#31933)
  * Use correct function name (#31887)
  * Use a common message template instead of a special one (#31878)
  * Fix a number of Typescript issues (#31877)
  * Refactor dropzone (#31482)
  * Move custom `tw-` helpers to tailwind plugin (#31184)
  * Replace `gt-word-break` with `tw-break-anywhere` (#31183)
  * Drop `IDOrderDesc` for listing Actions task and always order by `id DESC` (#31150)
  * Split common-global.js into separate files (#31438)
  * Improve detecting empty files (#31332)
  * Use `querySelector` over alternative DOM methods (#31280)
  * Remove jQuery `.text()` (#30506)
  * Use repo as of renderctx's member rather than a repoPath on metas (#29222)
  * Refactor some frontend problems (#32646)
  * Refactor DateUtils and merge TimeSince (#32409)
  * Replace DateTime with proper functions (#32402)
  * Replace DateTime with DateUtils (#32383)
  * Convert frontend code to typescript (#31559)
  * Refactor maven package registry (#33049) #33057
  * Refactor testfixtures #33028

* BUGFIXES
  * Fix issues with inconsistent spacing in areas (#32607)
  * Fix incomplete Actions status aggregations (#32859)
  * In some lfs server implementations, they require the ref attribute. (#32838)
  * Update the list of watchers and stargazers when clicking watch/unwatch or star/unstar (#32570)
  * Fix `recentupdate` sorting bugs (#32505)
  * Fix incorrect "Target branch does not exist" in PR title (#32222)
  * Handle "close" actionable references for manual merges (#31879)
  * render plain text file if the LFS object doesn't exist (#31812)
  * Fix Null Pointer error for CommitStatusesHideActionsURL (#31731)
  * Fix loadRepository error when access user dashboard (#31719)
  * Hide the "Details" link of commit status when the user cannot access actions (#30156)
  * Fix duplicate dropdown dividers (#32760)
  * Fix SSPI button visibility when SSPI is the only enabled method (#32841)
  * Fix overflow on org header (#32837)
  * Exclude protected branches from recently pushed (#31748)
  * Fix large image overflow in comment page (#31740)
  * Fix milestone deadline and date related problems (#32339)
  * Fix markdown preview $$ support (#31514)
  * Fix a compilation error in the Gitpod environment (#32559)
  * Fix PR diff review form submit (#32596)
  * Fix a number of typescript issues (#32308)
  * Fix some function names in comment (#32300)
  * Fix absolute-date (#32375)
  * Clarify Actions resources ownership (#31724)
  * Try to fix ACME directory problem (#33072) #33077
  * Inherit submodules from template repository content (#16237) #33068
  * Use project's redirect url instead of composing url (#33058) #33064
  * Fix toggle commit body button ui when latest commit message is long (#32997) #33034
  * Fix package error handling and npm meta and empty repo guide #33112
  * Fix empty git repo handling logic and fix mobile view (#33101) #33102
  * Fix line-number and scroll bugs (#33094) #33095
  * Fix bleve fuzziness search (#33078) #33087
  * Fix broken forms #33082
  * Fix empty repo updated time (#33120) #33124
  * Add missing transaction when set merge #33113
  * Fix issue comment number (#30556) #33055
  * Fix duplicate co-author in squashed merge commit messages (#33020) #33054
  * Fix Agit pull request permission check (#32999) #33005
  * Fix scoped label ui when contains emoji (#33007) #33014
  * Fix bug on activities (#33008) #33016
  * Fix review code comment avatar alignment (#33031) #33032
  * Fix templating in pull request comparison (#33025) #33038
  * Fix bug automerge cannot be chosed when there is only 1 merge style (#33040) #33043
  * Fix settings not being loaded at CLI (#26402) #33048
  * Support for email addresses containing uppercase characters when activating user account (#32998) #33001
  * Support org labels when adding labels by label names (#32988) #32996
  * Do not render truncated links in markdown (#32980) #32983
  * Demilestone should not include milestone (#32923) #32979
  * Fix Azure blob object Seek (#32974) #32975
  * Fix maven pom inheritance (#32943) #32976
  * Fix textarea newline handle (#32966) #32977
  * Fix outdated tmpl code (#32953) #32961
  * Fix commit range paging (#32944) #32962
  * Fix repo avatar conflict (#32958) #32960
  * Fix trailing comma not matched in the case of alphanumeric issue (#32945)
  * Relax the version checking for Arch packages (#32908) #32913
  * Add more load functions to make sure the reference object loaded (#32901) #32912
  * Filter reviews of one pull request in memory instead of database to reduce slow response because of lacking database index (#33106) #33128
  * Fix git remote error check, fix dependencies, fix js error (#33129) #33133

* MISC
  * Optimize branch protection rule loading (#32280)
  * Bump to go 1.23 (#31855)
  * Remove unused call to $.HeadRepo in view_title template (#32317)
  * Do not display `attestation-manifest` and use short sha256 instead of full sha256 (#32851)
  * Upgrade htmx to 2.0.4 (#32834)
  * Improve JSX/TSX support in code editor (#32833)
  * Add User-Agent for gitea's self-implemented lfs client. (#32832)
  * Use errors.New to replace fmt.Errorf with no parameters (#32800)
  * Add "n commits" link to contributors in contributors graph page (#32799)
  * Update dependencies, tweak eslint (#32719)
  * Remove all "floated" CSS styles (#32691)
  * Show tag name on branch/tag selector if repo shown from tag ref (#32689)
  * Use new mail package instead of an unmintained one (#32682)
  * Optimize the styling of icon buttons within file-header-right (#32675)
  * Validate OAuth Redirect URIs (#32643)
  * Support optional/configurable IAMEndpoint for Minio Client (#32581) (#32581)
  * Make search box in issue sidebar dropdown list always show when scrolling (#32576)
  * Bump CI,Flake and Snap to Node 22 (#32487)
  * Update `github.com/meilisearch/meilisearch-go` (#32484)
  * Add `DEFAULT_MIRROR_REPO_UNITS` and `DEFAULT_TEMPLATE_REPO_UNITS` options (#32416)
  * Update go dependencies (#32389)
  * Update JS and PY dependencies (#32388)
  * Upgrade rollup to 4.24.0 (#32312)
  * Upgrade vue to 3.5.12 (#32311)
  * Improve the maintainblity of the reserved username list (#32229)
  * Upgrade htmx to 2.0.3 (#32192)
  * Count typescript files as frontend for labeling (#32088)
  * Only use Host header from reverse proxy (#32060)
  * Failed authentications are logged to level Warning (#32016)
  * Enhance USER_DISABLED_FEATURES to allow disabling change username or full name (#31959)
  * Distinguish official vs non-official reviews, add tool tips, and upgr… (#31924)
  * Update mermaid to v11 (#31913)
  * Bump relative-time-element to v4.4.3 (#31910)
  * Upgrade `htmx` to `2.0.2` (#31847)
  * Add warning message in merge instructions when `AutodetectManualMerge` was not enabled (#31805)
  * Add types to various low-level functions (#31781)
  * Update JS dependencies (#31766)
  * Remove unused code from models/repos/release.go (#31756)
  * Support delete user email in admin panel (#31690)
  * Add `username` to OIDC introspection response (#31688)
  * Use GetDisplayName() instead of DisplayName() to generate rss feeds (#31687)
  * Code editor theme enhancements (#31629)
  * Update JS dependencies (#31616)
  * Add types for js globals (#31586)
  * Add back esbuild-loader for .js files (#31585)
  * Don't show hidden labels when filling out an issue template (#31576)
  * Allow synchronizing user status from OAuth2 login providers (#31572)
  * Display app name in the registration email title (#31562)
  * Use stable version of fabric (#31526)
  * Support legacy _links LFS batch responses (#31513)
  * Fix JS error with disabled attachment and easymde (#31511)
  * Always use HTML attributes for avatar size (#31509)
  * Use nolyfill to remove some polyfills (#31468)
  * Disable issue/PR comment button given empty input (#31463)
  * Add simple JS init performance trace (#31459)
  * Bump htmx to 2.0.0 (#31413)
  * Update JS dependencies, remove `eslint-plugin-jquery` (#31402)
  * Split org Propfile README to a new tab `overview` (#31373)
  * Update nix flake and add gofumpt (#31320)
  * Code optimization (#31315)
  * Enable poetry non-package mode (#31282)
  * Optimize profile layout to enhance visual experience (#31278)
  * Update `golang.org/x/net` (#31260)
  * Bump `@github/relative-time-element` to v4.4.1 (#31232)
  * Remove unnecessary inline style for tab-size (#31224)
  * Update golangci-lint to v1.59.0 (#31221)
  * Update chroma to v2.14.0 (#31177)
  * Update JS dependencies (#31120)
  * Improve the handling of `jobs.<job_id>.if` (#31070)
  * Clean up revive linter config, tweak golangci output (#30980)
  * Use CSS `inset` shorthand (#30939)
  * Forbid deprecated `break-word` in CSS (#30934)
  * Remove obsolete monaco workaround (#30893)
  * Update JS dependencies, add new eslint rules (#30840)
  * Fix body margin shifting with modals, fix error on project column edit (#30831)
  * Remove disk-clean workflow (#30741)
  * Bump `github.com/google/go-github` to v61 (#30738)
  * Add built js files to eslint ignore (#30737)
  * Use `ProtonMail/go-crypto` for `opengpg` in tests (#30736)
  * Upgrade xorm to v1.3.9 and improve some migrations Sync (#29899)
  * Added default sorting milestones by name (#27084)
  * Enable `unparam` linter (#31277)
  * Use Alpine 3.21 for the docker images (#32924) #32951
  * Bump x/net (#32896) #32899
  * Use -s -w ldflags for release artifacts (#33041) #33042
  * Remove aws go sdk package dependency (#33029) #33047

## [1.22.6](https://github.com/go-gitea/gitea/releases/tag/v1.22.6) - 2024-12-12

* SECURITY
  * Fix misuse of PublicKeyCallback(#32810)
* BUGFIXES
  * Fix lfs migration (#32812) (#32818)
  * Add missing two sync feed for refs/pull (#32815)
* TESTING
  * Avoid MacOS keychain dialog in integration tests (#32813) (#32816)

## [1.22.5](https://github.com/go-gitea/gitea/releases/tag/v1.22.5) - 2024-12-11

* SECURITY
  * Upgrade crypto library (#32791)
  * Fix delete branch perm checking (#32654) (#32707)
* BUGFIXES
  * Add standard-compliant route to serve outdated R packages (#32783) (#32789)
  * Fix internal server error when updating labels without write permission (#32776) (#32785)
  * Add Swift login endpoint (#32693) (#32701)
  * Fix fork page branch selection (#32711) (#32725)
  * Fix word overflow in file search page (#32695) (#32699)
  * Fix gogit `GetRefCommitID` (#32705) (#32712)
  * Fix race condition in mermaid observer (#32599) (#32673)
  * Fixe a keystring misuse and refactor duplicates keystrings (#32668) (#32792)
  * Bump relative-time-element to v4.4.4 (#32739)
* PERFORMANCE
  * Make wiki pages visit fast (#32732) (#32745)
* MISC
  * Don't create action when syncing mirror pull refs (#32659) (#32664)

## [1.22.4](https://github.com/go-gitea/gitea/releases/tag/v1.22.4) - 2024-11-14

* SECURITY
  * Fix basic auth with webauthn (#32531) (#32536)
  * Refactor internal routers (partial backport, auth token const time comparing) (#32473) (#32479)
* PERFORMANCE
  * Remove transaction for archive download (#32186) (#32520)
* BUGFIXES
  * Fix `missing signature key` error when pulling Docker images with `SERVE_DIRECT` enabled (#32365) (#32397)
  * Fix get reviewers fails when selecting user without pull request permissions unit (#32415) (#32616)
  * Fix adding index files to tmp directory (#32360) (#32593)
  * Fix PR creation on forked repositories via API (#31863) (#32591)
  * Fix missing menu tabs in organization project view page (#32313) (#32592)
  * Support HTTP POST requests to `/userinfo`, aligning to OpenID Core specification (#32578) (#32594)
  * Fix debian package clean up cron job (#32351) (#32590)
  * Fix GetInactiveUsers (#32540) (#32588)
  * Allow the actions user to login via the jwt token (#32527) (#32580)
  * Fix submodule parsing (#32571) (#32577)
  * Refactor find forks and fix possible bugs that weaken permissions check (#32528) (#32547)
  * Fix some places that don't respect org full name setting (#32243) (#32550)
  * Refactor push mirror find and add check for updating push mirror (#32539) (#32549)
  * Fix basic auth with webauthn (#32531) (#32536)
  * Fix artifact v4 upload above 8MB (#31664) (#32523)
  * Fix oauth2 error handle not return immediately (#32514) (#32516)
  * Fix action not triggered when commit message is too long (#32498) (#32507)
  * Fix `GetRepoLink` nil pointer dereference on dashboard feed page when repo is deleted with actions enabled (#32501) (#32502)
  * Fix `missing signature key` error when pulling Docker images with `SERVE_DIRECT` enabled (#32397) (#32397)
  * Fix the permission check for user search API and limit the number of returned users for `/user/search` (#32310)
  * Fix SearchIssues swagger docs (#32208) (#32298)
  * Fix dropdown content overflow (#31610) (#32250)
  * Disable Oauth check if oauth disabled (#32368) (#32480)
  * Respect renamed dependencies of Cargo registry (#32430) (#32478)
  * Fix mermaid diagram height when initially hidden (#32457) (#32464)
  * Fix broken releases when re-pushing tags (#32435) (#32449)
  * Only provide the commit summary for Discord webhook push events (#32432) (#32447)
  * Only query team tables if repository is under org when getting assignees (#32414) (#32426)
  * Fix created_unix for mirroring (#32342) (#32406)
  * Respect UI.ExploreDefaultSort setting again (#32357) (#32385)
  * Fix broken image when editing comment with non-image attachments (#32319) (#32345)
  * Fix disable 2fa bug (#32320) (#32330)
  * Always update expiration time when creating an artifact (#32281) (#32285)
  * Fix null errors on conversation holder (#32258) (#32266) (#32282)
  * Only rename a user when they should receive a different name (#32247) (#32249)
  * Fix checkbox bug on private/archive filter (#32236) (#32240)
  * Add a doctor check to disable the "Actions" unit for mirrors (#32424) (#32497)
  * Quick fix milestone deadline 9999 (#32423)
  * Make `show stats` work when only one file changed (#32244) (#32268)
  * Make `owner/repo/pulls` handlers use "PR reader" permission (#32254) (#32265)
  * Update scheduled tasks even if changes are pushed by "ActionsUser" (#32246) (#32252)
* MISC
  * Remove unnecessary code: `GetPushMirrorsByRepoID` called on all repo pages (#32560) (#32567)
  * Improve some sanitizer rules (#32534)
  * Update nix development environment vor v1.22.x (#32495)
  * Add warn log when deleting inactive users (#32318) (#32321)
  * Update github.com/go-enry/go-enry to v2.9.1 (#32295) (#32296)
  * Warn users when they try to use a non-root-url to sign in/up (#32272) (#32273)

## [1.22.3](https://github.com/go-gitea/gitea/releases/tag/v1.22.3) - 2024-10-08

* SECURITY
  * Fix bug when a token is given public only (#32204) (#32218)
* PERFORMANCE
  * Increase `cacheContextLifetime` to reduce false reports (#32011) (#32023)
  * Don't join repository when loading action table data (#32127) (#32143)
* BUGFIXES
  * Fix javascript error when an anonymous user visits migration page (#32144) (#32179)
  * Don't init signing keys if oauth2 provider is disabled (#32177)
  * Fix wrong status of `Set up Job` when first step is skipped (#32120) (#32125)
  * Fix bug when deleting a migrated branch (#32075) (#32123)
  * Truncate commit message during Discord webhook push events (#31970) (#32121)
  * Allow to set branch protection in an empty repository (#32095) (#32119)
  * Fix panic when cloning with wrong ssh format. (#32076) (#32118)
  * Fix rename branch permission bug (#32066) (#32108)
  * Fix: database not update release when using `git push --tags --force` (#32040) (#32074)
  * Add missing comment reply handling (#32050) (#32065)
  * Do not escape relative path in RPM primary index (#32038) (#32054)
  * Fix `/repos/{owner}/{repo}/pulls/{index}/files` endpoint not populating `previous_filename` (#32017) (#32028)
  * Support allowed hosts for migrations to work with proxy (#32025) (#32026)
  * Fix the logic of finding the latest pull review commit ID (#32139) (#32165)
  * Fix bug in getting merged pull request by commit (#32079) (#32117)
  * Fix wrong last modify time (#32102) (#32104)
  * Fix incorrect `/tokens` api (#32085) (#32092)
  * Handle invalid target when creating releases using API (#31841) (#32043)
  * Check if the `due_date` is nil when editing issues (#32035) (#32042)
  * Fix container parallel upload bugs (#32022)
  * Fixed race condition when deleting documents by repoId in ElasticSearch (#32185) (#32188)
  * Refactor CSRF protector (#32057) (#32069)
  * Fix Bug in Issue/pulls list (#32081) (#32115)
  * Include collaboration repositories on dashboard source/forks/mirrors list (#31946) (#32122)
  * Add null check for responseData.invalidTopics (#32212) (#32217)
* TESTING
  * Fix mssql ci with a new mssql version on ci (#32094)
* MISC
  * Upgrade some dependencies include minio-go (#32166)
  * Add bin to Composer Metadata (#32099) (#32106)
  * Lazy load avatar images (#32051) (#32063)
  * Upgrade cache to v0.2.1 (#32003) (#32009)

## [1.22.2](https://github.com/go-gitea/gitea/releases/tag/v1.22.2) - 2024-08-28

* Security
  * Replace v-html with v-text in search inputbox (#31966) (#31973)
  * Fix nuget/conan/container packages upload bugs (#31967) (#31982)
* PERFORMANCE
  * Refactor the usage of batch catfile (#31754) (#31889)
* BUGFIXES
  * Fix overflowing content in action run log (#31842) (#31853)
  * Scroll images in project issues separately from the remaining issue (#31683) (#31823)
  * Add `:focus-visible` style to buttons (#31799) (#31819)
  * Fix the display of project type for deleted projects (#31732) (#31734)
  * Fix API owner ID should be zero when created repo secret (#31715) (#31811)
  * Set owner id to zero when GetRegistrationToken for repo (#31725) (#31729)
  * Fix API endpoint for registration-token (#31722) (#31728)
  * Add permission check when creating PR (#31033) (#31720)
  * Don't return 500 if mirror url contains special chars (#31859) (#31895)
  * Fix agit automerge (#31207) (#31881)
  * Add CfTurnstileSitekey context data to all captcha templates (#31874) (#31876)
  * Avoid returning without written ctx when posting PR (#31843) (#31848)
  * Fix raw wiki links (#31825) (#31845)
  * Fix panic of ssh public key page after deletion of auth source (#31829) (#31836)
  * Fixes for unreachable project issues when transfer repository from organization (#31770) (#31828)
  * Show lock owner instead of repo owner on LFS setting page (#31788) (#31817)
  * Fix `IsObjectExist` with gogit (#31790) (#31806)
  * Fix protected branch files detection on pre_receive hook (#31778) (#31796)
  * Add `TAGS` to `TEST_TAGS` and fix bugs found with gogit (#31791) (#31795)
  * Rename head branch of pull requests when renaming a branch (#31759) (#31774)
  * Fix wiki revision pagination (#31760) (#31772)
  * Bump vue-bar-graph (#31705) (#31753)
  * Distinguish LFS object errors to ignore missing objects during migration (#31702) (#31745)
  * Make GetRepositoryByName more safer (#31712) (#31718)
  * Fix a branch divergence cache bug (#31659) (#31661)
  * Allow org team names of length 255 in create team form (#31564) (#31603)
  * Use old behavior for telegram webhook (#31588)
  * Bug fix for translation in ru (#31892)
  * Fix actions notify bug (#31866) (#31875)
  * Fix the component of access token list not mounted (#31824) (#31868)
  * Add missing repository type filter parameters to pager  (#31832) (#31837)
  * Fix dates displaying in a wrong manner when we're close to the end of… (#31750)
  * Fix "Filter by commit" Dropdown (#31695) (#31696)
  * Properly filter issue list given no assignees filter (#31522) (#31685)
  * Prevent update pull refs manually and will not affect other refs update (#31931)(#31955)
  * Fix sort order for organization home and user profile page (#31921) (#31922)
  * Fix search team (#31923) (#31942)
  * Fix 500 error when state params is set when editing issue/PR by API (#31880) (#31952)
  * Fix index too many file names bug (#31903) (#31953)
  * Add lock for parallel maven upload (#31851) (#31954)
* MISC
  * Remove "dsa-1024" testcases from Test_SSHParsePublicKey and Test_calcFingerprint (#31905) (#31914)
  * Upgrade bleve to 2.4.2 (#31894)
  * Remove unneccessary uses of `word-break: break-all` (#31637) (#31652)
  * Return an empty string when a repo has no avatar in the repo API (#31187) (#31567)
  * Upgrade micromatch to 4.0.8 (#31944)
  * Update webpack to 5.94.0 (#31941)

## [1.22.1](https://github.com/go-gitea/gitea/releases/tag/v1.22.1) - 2024-07-04

* SECURITY
  * Add replacement module for `mholt/archiver` (#31267) (#31270)
* API
  * Fix missing images in editor preview due to wrong links (#31299) (#31393)
  * Fix duplicate sub-path for avatars (#31365) (#31368)
  * Reduce memory usage for chunked artifact uploads to MinIO (#31325) (#31338)
  * Remove sub-path from container registry realm (#31293) (#31300)
  * Fix NuGet Package API for $filter with Id equality (#31188) (#31242)
  * Add an immutable tarball link to archive download headers for Nix (#31139) (#31145)
  * Add missed return after `ctx.ServerError` (#31130) (#31133)
* BUGFIXES
  * Fix avatar radius problem on the new issue page (#31506) (#31508)
  * Fix overflow menu flickering on mobile (#31484) (#31488)
  * Fix poor table column width due to breaking words (#31473) (#31477)
  * Support relative paths to videos from Wiki pages (#31061) (#31453)
  * Fix new issue/pr avatar (#31419) (#31424)
  * Increase max length of org team names from 30 to 255 characters (#31410) (#31421)
  * Fix line number width in code preview (#31307) (#31316)
  * Optimize runner-tags layout to enhance visual experience (#31258) (#31263)
  * Fix overflow on push notification (#31179) (#31238)
  * Fix overflow on notifications (#31178) (#31237)
  * Fix overflow in issue card (#31203) (#31225)
  * Split sanitizer functions and fine-tune some tests (#31192) (#31200)
  * use correct l10n string (#31487) (#31490)
  * Fix dropzone JS error when attachment is disabled (#31486)
  * Fix web notification icon not updated once you read all notifications (#31447) (#31466)
  * Switch to "Write" tab when edit comment again (#31445) (#31461)
  * Fix the link for .git-blame-ignore-revs bypass (#31432) (#31442)
  * Fix the wrong line number in the diff view page when expanded twice. (#31431) (#31440)
  * Fix labels and projects menu overflow on issue page (#31435) (#31439)
  * Fix Account Linking UpdateMigrationsByType  (#31428) (#31434)
  * Fix markdown math brackets render problem (#31420) (#31430)
  * Fix rendered wiki page link (#31398) (#31407)
  * Fix natural sort (#31384) (#31394)
  * Allow downloading attachments of draft releases (#31369) (#31380)
  * Fix repo graph JS (#31377)
  * Fix incorrect localization `explorer.go` (#31348) (#31350)
  * Fix hash render end with colon (#31319) (#31346)
  * Fix line number widths (#31341) (#31343)
  * Fix navbar `+` menu flashing on page load (#31281) (#31342)
  * Fix adopt repository has empty object name in database (#31333) (#31335)
  * Delete legacy cookie before setting new cookie (#31306) (#31317)
  * Fix some URLs whose sub-path is missing (#31289) (#31292)
  * Fix admin oauth2 custom URL settings (#31246) (#31247)
  * Make pasted "img" tag has the same behavior as markdown image (#31235) (#31243)
  * Fix agit checkout command line hint & fix ShowMergeInstructions checking (#31219) (#31222)
  * Fix the possible migration failure on 286 with postgres 16 (#31209) (#31218)
  * Fix branch order (#31174) (#31193)
  * Fix markup preview (#31158) (#31166)
  * Fix push multiple branches error with tests (#31151) (#31153)
  * Fix API repository object format missed (#31118) (#31132)
  * Fix missing memcache import (#31105) (#31109)
  * Upgrade `github.com/hashicorp/go-retryablehttp` (#31499)
  * Fix double border in system status table (#31363) (#31401)
  * Fix bug filtering issues which have no project (#31337) (#31367)
  * Fix #31185 try fix lfs download from bitbucket failed (#31201) (#31329)
  * Add nix flake for dev shell (#30967) (#31310)
  * Fix and clean up `ConfirmModal` (#31283) (#31291)
  * Optimize repo-list layout to enhance visual experience (#31272) (#31276)
  * fixed the dropdown menu for the top New button to expand to the left (#31273) (#31275)
  * Fix Activity Page Contributors dropdown (#31264) (#31269)
  * fix: allow actions artifacts storage migration to complete succesfully (#31251) (#31257)
  * Make blockquote attention recognize more syntaxes (#31240) (#31250)
  * Remove .segment from .project-column (#31204) (#31239)
  * Ignore FindRecentlyPushedNewBranches err (#31164) (#31171)
  * Use vertical layout for multiple code expander buttons (#31122) (#31152)
  * Remove duplicate `ProxyPreserveHost` in Apache httpd doc (#31143) (#31147)
  * Improve mobile review ui (#31091) (#31136)
  * Fix DashboardRepoList margin (#31121) (#31128)
  * Update pip related commands for docker (#31106) (#31111)

## [1.22.0](https://github.com/go-gitea/gitea/releases/tag/v1.22.0) - 2024-05-27

This release stands as a monumental milestone in our development journey with a record-breaking incorporation of [1528](https://github.com/go-gitea/gitea/pulls?q=is%3Apr+milestone%3A1.22.0+is%3Amerged) pull requests. It marks the most extensive update in Gitea's history, showcasing a plethora of new features and infrastructure improvements.

Noteworthy advancements in this release include the introduction of `HTMX` and `Tailwind`, signaling a strategic shift as we gradually phase out `jquery` and `Fomantic UI`. These changes reflect our commitment to embracing modern technologies and enhancing the user experience.

Key highlights of this release encompass significant changes categorized under `BREAKING`, `FEATURES`, `ENHANCEMENTS`, and `PERFORMANCE`, each contributing to a more robust and efficient Gitea platform.

* BREAKING
  * Improve reverse proxy documents and clarify the AppURL guessing behavior (#31003) (#31020)
  * Remember log in for a month by default (#30150)
  * Breaking summary for template refactoring (#29395)
    * All custom templates need to follow these changes
  * Recommend/convert to use case-sensitive collation for MySQL/MSSQL (#28662)
  * Make offline mode as default to not connect external avatar service by default (#28548)
  * Include public repos in the doer's dashboard for issue search (#28304)
  * Use restricted sanitizer for repository description (#28141)
  * Support storage base path as prefix (#27827)
  * Enhanced auth token / remember me (#27606)
  * Rename the default themes to `gitea-light`, `gitea-dark`, `gitea-auto` (#27419)
    * If you didn't see the new themes, please remove the `[ui].THEMES` config option from `app.ini`
  * Require MySQL 8.0, PostgreSQL 12, MSSQL 2012 (#27337)
* FEATURES
  * Allow everyone to read or write a wiki by a repo unit setting (#30495)
  * Use raw Wiki links for non-renderable Wiki files (#30273)
  * Render embedded code preview by permalink in markdown (#30234) (#30249)
  * Support repo code search without setting up an indexer (#29998)
  * Support pasting URLs over markdown text (#29566)
  * Allow to change primary email before account activation (#29412)
  * Customizable "Open with" applications for repository clone (#29320)
  * Allow options to disable user deletion from the interface on app.ini (#29275)
  * Extend issue template YAML engine (#29274)
  * Add support for `linguist-detectable` and `linguist-documentation` (#29267)
  * Implement code frequency graph (#29191)
  * Show commit status for releases (#29149)
  * Add user blocking (#29028)
  * Actions Artifacts v4 backend (#28965)
  * Add merge style `fast-forward-only` (#28954)
  * Retarget depending pulls when the parent branch is deleted (#28686)
  * Add global setting on how timestamps should be rendered (#28657)
  * Implement actions badge SVGs (#28102)
  * Add skip ci functionality (#28075)
  * Show latest commit for file (#28067)
  * Allow to sync tags from the admin dashboard (#28045)
  * Add Profile Readme for Organisations (#27955)
  * Implement contributors graph (#27882)
  * Artifact deletion in actions ui (#27172)
  * Add API routes to get runner registration token (#27144)
  * Add support for forking single branch (#25821)
  * Add support for sha256 repositories (#23894)
  * Add admin API route for managing user's badges (#23106)
* ENHANCEMENTS
  * Make gitea webhooks openproject compatible (#28435) (#31081)
  * Support using label names when changing issue labels (#30943) (#30958)
  * Fix various problems around project board view (#30696) (#30902)
  * Improve context popup rendering (#30824) (#30829)
  * Allow to save empty comment (#30706)
  * Prevent allow/reject reviews on merged/closed PRs (#30686)
  * Initial support for colorblindness-friendly themes (#30625)
  * Some NuGet package enhancements (#30280) (#30324)
  * Markup color and font size fixes (#30282) (#30310)
  * Show 12 lines in markup code preview (#30255) (#30257)
  * Add `[other].SHOW_FOOTER_POWERED_BY` setting to hide `Powered by` (#30253)
  * Pulse page improvements (#30149)
  * Render code tags in commit messages (#30146)
  * Prevent re-review and dismiss review actions on closed and merged PRs (#30065)
  * Cancel previous runs of the same PR automatically (#29961)
  * Drag-and-drop improvements for projects and issue pins (#29875)
  * Add default board to new projects, remove uncategorized pseudo-board (#29874)
  * Prevent layout shift in `<overflow-menu>` items (#29831)
  * Add skip ci support for pull request title (#29774)
  * Add more stats tables (#29730)
  * Update API to return 'source_id' for users (#29718)
  * Determine fuzziness of bleve indexer by keyword length (#29706)
  * Expose fuzzy search for issues/pulls (#29701)
  * Put an edit file button on pull request files to allow a quick operation (#29697)
  * Fix action runner offline label padding (#29691)
  * Update allowed attachment types (#29688)
  * Completely style the webkit autofill (#29683)
  * Highlight archived labels (#29680)
  * Add a warning for disallowed email domains (#29658)
  * Set user's 24h preference from their current OS locale (#29651)
  * Add setting to disable user features when user login type is not plain (#29615)
  * Improve natural sort (#29611)
  * Make wiki default branch name changeable (#29603)
  * Unify search boxes (#29530)
  * Add support for API blob upload of release attachments (#29507)
  * Detect broken git hooks (#29494)
  * Sync branches to DB immediately when handling git hook calling (#29493)
  * Allow options to disable user GPG key configuration from the interface on app.ini (#29486)
  * Allow options to disable user SSH key configuration from the interface on app.ini (#29447)
  * Use relative links for commits, mentions, and issues in markdown (#29427)
  * Add `<overflow-menu>`, rename webcomponents (#29400)
  * Include resource state events in Gitlab downloads (#29382)
  * Properly migrate target branch change GitLab comment (#29340)
  * Recolor dark theme to blue shade (#29283)
  * Partially enable MSSQL case-sensitive collation support (#29238)
  * Auto-update the system status in the admin dashboard (#29163)
  * Integrate alpine `noarch` packages into other architectures index (#29137)
  * Document how the TOC election process works (#29135)
  * Tweak repo header (#29134)
  * Make blockquote border size less aggressive (#29124)
  * Downscale pasted PNG images based on metadata (#29123)
  * Show `View at this point in history` for every commit (#29122)
  * Add support for action artifact serve direct (#29120)
  * Change webhook-type in create-view (#29114)
  * Drop "@" from the email sender to avoid spam filters (#29109)
  * Allow non-admin users to delete review requests (#29057)
  * Improve user search display name (#29002)
  * Include username in email headers (#28981)
  * Show whether a PR is WIP inside popups (#28975)
  * Also match weakly validated ETags (#28957)
  * Support nuspec manifest download for Nuget packages (#28921)
  * Fix hardcoded GitHub icon used as migrated release avatar (#28910)
  * Propagate install_if and provider_priority to APKINDEX (#28899)
  * Add artifacts v4 JWT to job message and accept it (#28885)
  * Enable/disable owner and repo projects independently (#28805)
  * Add non-JS fallback for reaction tooltips (#28785)
  * Add the ability to see open and closed issues at the same time (#28757)
  * Move sign-in labels to be above inputs (#28753)
  * Display the latest sync time for pull mirrors on the repo page (#28712)
  * Show in Web UI if the file is vendored and generated (#28620)
  * Add orphaned topic consistency check (#28507)
  * Add branch protection setting for ignoring stale approvals (#28498)
  * Add option to set language in admin user view (#28449)
  * Fix incorrect run order of action jobs (#28367)
  * Add missing exclusive in advanced label options (#28322)
  * Added instance-level variables (#28115)
  * Add edit option for README.md (#28071)
  * Fix link to `Code` tab on wiki commits (#28041)
  * Allow to set explore page default sort (#27951)
  * Improve PR diff view on mobile (#27883)
  * Properly migrate automatic merge GitLab comments (#27873)
  * Display issue task list on project cards (#27865)
  * Add Index to pull_auto_merge.doer_id (#27811)
  * Fix display member unit in the menu bar if there are no hidden members in public org (#27795)
  * List all Debian package versions in `Packages` (#27786)
  * Allow pull requests Manually Merged option to be used by non-admins (#27780)
  * Only show diff file tree when more than one file changed (#27775)
  * Show placeholder email in privacy popup (#27770)
  * Revamp repo header (#27760)
  * Add `must-change-password` command line parameter (#27626)
  * Unify password changing and invalidate auth tokens (#27625)
  * Add border to file tree 'sub-items' and add padding to 'item-file' (#27593)
  * Add slow SQL query warning (#27545)
  * Pre-register OAuth application for tea (#27509)
  * Differentiate between `push` and `pull` `mirror sync in progress` (#27390)
  * Link to file from its history (#27354)
  * Add a shortcut to user's profile page to admin user details (#27299)
  * Doctor: delete action entries without existing user (#27292)
  * Show total TrackedTime on issue/pull/milestone lists (#26672)
  * Don't show the new pull request button when the page is not compare pull (#26431)
  * Add `Hide/Show all checks` button to commit status check (#26284)
  * Improvements of releases list and tags list (#25859)
* PERFORMANCE
  * Fix package list performance (#30520) (#30616)
  * Add commit status summary table to reduce query from commit status table (#30223)
  * Refactor markup/csv: don't read all to memory (#29760)
  * Lazy load object format with command line and don't do it in OpenRepository (#29712)
  * Add cache for branch divergence on branch list page (#29577)
  * Do some performance optimization for issues list and view issue/pull (#29515)
  * Cache repository default branch commit status to reduce query on commit status table (#29444)
  * Use `crypto/sha256` (#29386)
  * Some performance optimization on the dashboard and issues page (#29010)
  * Add combined index for issue_user.uid and issue_id (#28080)

## [1.21.11](https://github.com/go-gitea/gitea/releases/tag/v1.21.11) - 2024-04-07

* SECURITY
  * Use go1.21.9 to include Golang security fix
  * Fix possible renderer security problem (#30136) (#30315)
  * Performance optimization for git push and check permissions for push options (#30104) (#30354)
* BUGFIXES
  * Fix close file in the Upload func (#30262) (#30269)
  * Fix inline math blocks can't be preceeded/followed by alphanumerical characters (#30175) (#30250)
  * Fix missing 0 prefix of GPG key id (#30245) (#30247)
  * Include encoding in signature payload (#30174) (#30181)
  * Move from `max( id )` to `max( index )` for latest commit statuses (#30076) (#30155)
  * Load attachments for code comments (#30124) (#30126)
  * Fix gitea doctor will remove repo-avatar files when executing command storage-archives (#30094) (#30120)
  * Fix possible data race on tests (#30093) (#30108)
  * Fix duplicate migrated milestones (#30102) (#30105)
  * Fix panic for fixBrokenRepoUnits16961 (#30068) (#30100)
  * Fix incorrect SVGs (#30086) (#30087)
  * Fix create commit status (#30225) (#30340)
  * Fix misuse of unsupported global variables (#30402)
  * Fix to delete the cookie when AppSubURL is non-empty (#30375) (#30468)
  * Avoid user does not exist error when detecting schedule actions when the commit author is an external user (#30357) (#30408)
  * Change the default maxPerPage for gitbucket (#30392) (#30471)
  * Check the token's owner and repository when registering a runner (#30406) (#30412)
  * Avoid losing token when updating mirror settings (#30429) (#30466)
  * Fix commit status cache which missed target_url (#30426) (#30445)
  * Fix rename branch 500 when the target branch is deleted but exist in database (#30430) (#30437)
  * Fix mirror error when mirror repo is empty (#30432) (#30467)
  * Use db.ListOptions directly instead of Paginator interface to make it easier to use and fix performance of /pulls and /issues (#29990) (#30447)
  * Fix code owners will not be mentioned when a pull request comes from a forked repository (#30476) (#30497)
* DOCS
  * Update actions variables documents (#30394) (#30405)
* MISC
  * Update katex to 0.16.10 (#30089)
  * Upgrade go-sqlite to v1.14.22 (#30462)

## [1.21.10](https://github.com/go-gitea/gitea/releases/tag/v1.21.10) - 2024-03-25

* BUGFIXES
  * Fix Add/Remove WIP on pull request title failure (#29999) (#30066)
  * Fix misuse of `TxContext` (#30061) (#30062)
  * Respect DEFAULT_ORG_MEMBER_VISIBLE setting when adding creator to org (#30013) (#30035)
  * Escape paths for find file correctly (#30026) (#30031)
  * Remove duplicate option in admin screen and now-unused translation keys (#28492) (#30024)
  * Fix manual merge form and 404 page templates (#30000)

## [1.21.9](https://github.com/go-gitea/gitea/releases/tag/v1.21.9) - 2024-03-21

* PERFORMANCE
  * Only do counting when count_only=true for repo dashboard (#29884) (#29905)
  * Add cache for dashboard commit status (#29932)
* ENHANCEMENT
  * Make runs-on support variable expression (#29468) (#29782)
  * Show Actions post step when it's running (#29926) (#29928)
* BUGFIXES
  * Fix PR creation via API between branches of the same repo with head field namespaced (#26986) (#29857)
  * Fix and rewrite markup anchor processing (#29931) (#29946)
  * Notify reviewers added via CODEOWNERS (#29842) (#29902)
  * Fix template error when comment review doesn't exist (#29888) (#29889)
  * Fix user id column case (#29863) (#29867)
  * Make meilisearch do exact search for issues (#29740 & #29671) (#29846)
  * Fix the `for` attribute not pointing to the ID of the color picker (#29813) (#29815)
  * Fix codeowner detected diff base branch to mergebase (#29783) (#29807)
  * Fix Safari spinner rendering (#29801) (#29802)
  * Fix missing translation on milestones (#29785) (#29789)
  * Fix user router possible panic (#29751) (#29786)
  * Fix possible NPE in ToPullReviewList (#29759) (#29775)
  * Fix the wrong default value of ENABLE_OPENID_SIGNIN on docs (#29925) (#29927)
  * Solving the issue of UI disruption when the review is deleted without refreshing (#29951) (#29968)
  * Fix loadOneBranch panic (#29938) (#29939)
  * Fix invalid link of the commit status when ref is tagged (#29752) (#29908)
  * Editor error message misleading due to re-used key. (#29859) (#29876)
  * Fix double border and border-radius on empty action steps (#29845) (#29850)
  * Use `Temporal.PlainDate` for absolute dates (#29804) (#29808)
  * Fix incorrect package link method calls in templates (#29580) (#29764)
  * Fix the bug that the user may log out if GetUserByID returns unknown error (#29962) (#29964)
  * Performance improvements for pull request list page (#29900) (#29972)
  * Fix bugs in rerunning jobs (#29983) (#29955)

## [1.21.8](https://github.com/go-gitea/gitea/releases/tag/v1.21.8) - 2024-03-12

* SECURITY
  * Only use supported sort orders for "/explore/users" page (#29430) (#29443)
* ENHANCEMENTS
  * Fix wrong line number in code search result (#29260) (#29623)
* BUGFIXES
  * Use Get but not Post to get actions artifacts (#29734) (#29737)
  * Fix inconsistent rendering of block mathematical expressions (#29677) (#29711)
  * Fix rendering internal file links in org (#29669) (#29705)
  * Don't show AbortErrors on logout (#29639) (#29667)
  * Fix user-defined markup links targets (#29305) (#29666)
  * Fix incorrect rendering csv file when file size is larger than UI.CSV.MaxFileSize (#29653) (#29663)
  * Fix hidden test's failure (#29254) (#29662)
  * Add empty repo check-in DetectAndHandleSchedules (#29606) (#29659)
  * Fix 500 when deleting an account with an incorrect password or unsupported login type (#29579) (#29656)
  * Use strict protocol check when redirect (#29642) (#29644)
  * Avoid issue info panic (#29625) (#29632)
  * Avoid unexpected panic in graceful manager (#29629) (#29630)
  * Make "/user/login" page redirect if the current user has signed in (#29583) (#29599)
  * Fix workflow trigger event IssueChangeXXX bug (#29559) (#29565)
  * Fix incorrect cookie path for AppSubURL (#29534) (#29552)
  * Fix queue worker incorrectly stopped when there are still more items in the queue (#29532) (#29546)
  * Fix incorrect redirection when creating a PR fails (#29537) (#29543)
  * Fix incorrect subpath in links (#29535) (#29541)
  * Fix issue link does not support quotes (#29484) (#29487) (#29536)
  * Fix issue & comment history bugs (#29525) (#29527)
  * Set pre-step status to `skipped` if the job is skipped (#29489) (#29523)
  * Fix/Improve `processWindowErrorEvent` (#29407) (#29480)
  * Fix counter display number incorrectly displayed on the page (#29448) (#29478)
  * Fix workflow trigger event bugs (#29467) (#29475)
  * Fix URL calculation in the clone input box (#29470) (#29473)
  * The job should always run when `if` is `always()` (#29464) (#29469)
  * Fix template bug (#27581) (#29446)
  * Not trigger all jobs anymore when re-running the first job (#29439) (#29441)
  * Ignore empty repo for CreateRepository in action notifier (#29416) (#29424)
  * Fix incorrect tree path value for patch editor (#29377) (#29421)
  * Add missing database transaction for new issues (#29490) (#29607)
  * Fix 500 when pushing release to an empty repo (#29554) (#29564)
  * Fix incorrect relative/absolute URL usages (#29531) (#29547)
  * Fix wrong test usage of `AppSubURL` (#29459) (#29488)
  * Fix missed return (#29450) (#29453)
  * Fixing the issue when status checks per rule matches multiple actions (#29631) (#29655)
  * Improve contrast on blame timestamp, fix double border (#29482) (#29485)

## [1.21.7](https://github.com/go-gitea/gitea/releases/tag/v1.21.7) - 2024-02-26

* ENHANCEMENTS
  * Users with `read` permission of pull requests can be assigned too (#27263) (#29372)
* BUGFIXES
  * Do not double close reader (#29354) (#29370)
  * Display friendly error message (#29105) (#29363)
  * Fix project counter in organization/individual profile (#28068) (#29361)
  * Fix validity of the FROM email address not being checked (#29347) (#29360)
  * Fix tarball/zipball download bug (#29342) (#29352)
* DOCS
  * Docker Tag Information in Docs (#29047) (#29362)
* MISC
  * Enforce maxlength in frontend (#29389) (#29396)

## [1.21.6](https://github.com/go-gitea/gitea/releases/tag/v1.21.6) - 2024-02-22

* SECURITY
  * Fix XSS vulnerabilities (#29336)
  * Use general token signing secret (#29205) (#29325)
* ENHANCEMENTS
  * Refactor git version functions and check compatibility (#29155) (#29157)
  * Improve user experience for outdated comments (#29050) (#29086)
  * Hide code links on release page if user cannot read code (#29064) (#29066)
  * Wrap contained tags and branches again (#29021) (#29026)
  * Fix incorrect button CSS usages (#29015) (#29023)
  * Strip trailing newline in markdown code copy (#29019) (#29022)
  * Implement some action notifier functions (#29173) (#29308)
  * Load outdated comments when (un)resolving conversation on PR timeline (#29203) (#29221)
* BUGFIXES
  * Refactor issue template parsing and fix API endpoint (#29069) (#29140)
  * Fix swift packages not resolving (#29095) (#29102)
  * Remove SSH workaround (#27893) (#29332)
  * Only log error when tag sync fails (#29295) (#29327)
  * Fix SSPI user creation (#28948) (#29323)
  * Improve the `issue_comment` workflow trigger event (#29277) (#29322)
  * Discard unread data of `git cat-file` (#29297) (#29310)
  * Fix error display when merging PRs (#29288) (#29309)
  * Prevent double use of `git cat-file` session. (#29298) (#29301)
  * Fix missing link on outgoing new release notifications (#29079) (#29300)
  * Fix debian InRelease Acquire-By-Hash newline (#29204) (#29299)
  * Always write proc-receive hook for all git versions (#29287) (#29291)
  * Do not show delete button when time tracker is disabled (#29257) (#29279)
  * Workaround to clean up old reviews on creating a new one (#28554) (#29264)
  * Fix bug when the linked account was disactived and list the linked accounts (#29263)
  * Do not use lower tag names to find releases/tags (#29261) (#29262)
  * Fix missed edit issues event for actions (#29237) (#29251)
  * Only delete scheduled workflows when needed (#29091) (#29235)
  * Make submit event code work with both jQuery event and native event (#29223) (#29234)
  * Fix push to create with capitalize repo name (#29090) (#29206)
  * Use ghost user if user was not found (#29161) (#29169)
  * Dont load Review if Comment is CommentTypeReviewRequest (#28551) (#29160)
  * Refactor parseSignatureFromCommitLine (#29054) (#29108)
  * Avoid showing unnecessary JS errors when there are elements with different origin on the page (#29081) (#29089)
  * Fix gitea-origin-url with default ports (#29085) (#29088)
  * Fix orgmode link resolving (#29024) (#29076)
  * Fix Elasticsearh Request Entity Too Large #28117 (#29062) (#29075)
  * Do not render empty comments (#29039) (#29049)
  * Avoid sending update/delete release notice when it is draft (#29008) (#29025)
  * Fix gitea-action user avatar broken on edited menu (#29190) (#29307)
  * Disallow merge when required checked are missing (#29143) (#29268)
  * Fix incorrect link to swift doc and swift package-registry login command (#29096) (#29103)
  * Convert visibility to number (#29226) (#29244)
* DOCS
  * Remove outdated docs from some languages (#27530) (#29208)
  * Fix typos in the documentation (#29048) (#29056)
  * Explained where create issue/PR template (#29035)

## [1.21.5](https://github.com/go-gitea/gitea/releases/tag/v1.21.5) - 2024-01-31

* SECURITY
  * Prevent anonymous container access if `RequireSignInView` is enabled (#28877) (#28882)
  * Update go dependencies and fix go-git (#28893) (#28934)
* BUGFIXES
  * Revert "Speed up loading the dashboard on mysql/mariadb (#28546)" (#29006) (#29007)
  * Fix an actions schedule bug (#28942) (#28999)
  * Fix update enable_prune even if mirror_interval is not provided (#28905) (#28929)
  * Fix uploaded artifacts should be overwritten (#28726) backport v1.21 (#28832)
  * Preserve BOM in web editor (#28935) (#28959)
  * Strip `/` from relative links (#28932) (#28952)
  * Don't remove all mirror repository's releases when mirroring (#28817) (#28939)
  * Implement `MigrateRepository` for the actions notifier (#28920) (#28923)
  * Respect branch info for relative links (#28909) (#28922)
  * Don't reload timeline page when (un)resolving or replying conversation (#28654) (#28917)
  * Only migrate the first 255 chars of a Github issue title (#28902) (#28912)
  * Fix sort bug on repository issues list (#28897) (#28901)
  * Fix `DeleteCollaboration` transaction behaviour (#28886) (#28889)
  * Fix schedule not trigger bug because matching full ref name with short ref name (#28874) (#28888)
  * Fix migrate storage bug (#28830) (#28867)
  * Fix archive creating LFS hooks and breaking pull requests (#28848) (#28851)
  * Fix reverting a merge commit failing (#28794) (#28825)
  * Upgrade xorm to v1.3.7 to fix a resource leak problem caused by Iterate (#28891) (#28895)
  * Fix incorrect PostgreSQL connection string for Unix sockets (#28865) (#28870)
* ENHANCEMENTS
  * Make loading animation less aggressive (#28955) (#28956)
  * Avoid duplicate JS error messages on UI (#28873) (#28881)
  * Bump `@github/relative-time-element` to 4.3.1 (#28819) (#28826)
* MISC
  * Warn that `DISABLE_QUERY_AUTH_TOKEN` is false only if it's explicitly defined (#28783) (#28868)
  * Remove duplicated checkinit on git module (#28824) (#28831)

## [1.21.4](https://github.com/go-gitea/gitea/releases/tag/v1.21.4) - 2024-01-16

* SECURITY
  * Update github.com/cloudflare/circl (#28789) (#28790)
  * Require token for GET subscription endpoint (#28765) (#28768)
* BUGFIXES
  * Use refname:strip-2 instead of refname:short when syncing tags (#28797) (#28811)
  * Fix links in issue card (#28806) (#28807)
  * Fix nil pointer panic when exec some gitea cli command (#28791) (#28795)
  * Require token for GET subscription endpoint (#28765) (#28778)
  * Fix button size in "attached header right" (#28770) (#28774)
  * Fix `convert.ToTeams` on empty input (#28426) (#28767)
  * Hide code related setting options in repository when code unit is disabled (#28631) (#28749)
  * Fix incorrect URL for "Reference in New Issue" (#28716) (#28723)
  * Fix panic when parsing empty pgsql host (#28708) (#28709)
  * Upgrade xorm to new version which supported update join for all supported databases (#28590) (#28668)
  * Fix alpine package files are not rebuilt (#28638) (#28665)
  * Avoid cycle-redirecting user/login page (#28636) (#28658)
  * Fix empty ref for cron workflow runs (#28640) (#28647)
  * Remove unnecessary syncbranchToDB with tests (#28624) (#28629)
  * Use known issue IID to generate new PR index number when migrating from GitLab (#28616) (#28618)
  * Fix flex container width (#28603) (#28605)
  * Fix the scroll behavior for emoji/mention list (#28597) (#28601)
  * Fix wrong due date rendering in issue list page (#28588) (#28591)
  * Fix `status_check_contexts` matching bug (#28582) (#28589)
  * Fix 500 error of searching commits (#28576) (#28579)
  * Use information from previous blame parts (#28572) (#28577)
  * Update mermaid for 1.21 (#28571)
  * Fix 405 method not allowed CORS / OIDC (#28583) (#28586) (#28587) (#28611)
  * Fix `GetCommitStatuses` (#28787) (#28804)
  * Forbid removing the last admin user (#28337) (#28793)
  * Fix schedule tasks bugs (#28691) (#28780)
  * Fix issue dependencies (#27736) (#28776)
  * Fix system webhooks API bug (#28531) (#28666)
  * Fix when private user following user, private user will not be counted in his own view (#28037) (#28792)
  * Render code block in activity tab (#28816) (#28818)
* ENHANCEMENTS
  * Rework markup link rendering (#26745) (#28803)
  * Modernize merge button (#28140) (#28786)
  * Speed up loading the dashboard on mysql/mariadb (#28546) (#28784)
  * Assign pull request to project during creation (#28227) (#28775)
  * Show description as tooltip instead of title for labels (#28754) (#28766)
  * Make template `DateTime` show proper tooltip (#28677) (#28683)
  * Switch destination directory for apt signing keys (#28639) (#28642)
  * Include heap pprof in diagnosis report to help debugging memory leaks (#28596) (#28599)
* DOCS
  * Suggest to use Type=simple for systemd service (#28717) (#28722)
  * Extend description for ARTIFACT_RETENTION_DAYS (#28626) (#28630)
* MISC
  * Add -F to commit search to treat keywords as strings (#28744) (#28748)
  * Add download attribute to release attachments (#28739) (#28740)
  * Concatenate error in `checkIfPRContentChanged` (#28731) (#28737)
  * Improve 1.21 document for Database Preparation (#28643) (#28644)

## [1.21.3](https://github.com/go-gitea/gitea/releases/tag/v1.21.3) - 2023-12-21

* SECURITY
  * Update golang.org/x/crypto (#28519)
* API
  * chore(api): support ignore password if login source type is LDAP for creating user API (#28491) (#28525)
  * Add endpoint for not implemented Docker auth (#28457) (#28462)
* ENHANCEMENTS
  * Add option to disable ambiguous unicode characters detection (#28454) (#28499)
  * Refactor SSH clone URL generation code (#28421) (#28480)
  * Polyfill SubmitEvent for PaleMoon (#28441) (#28478)
* BUGFIXES
  * Fix the issue ref rendering for wiki (#28556) (#28559)
  * Fix duplicate ID when deleting repo (#28520) (#28528)
  * Only check online runner when detecting matching runners in workflows (#28286) (#28512)
  * Initialize stroage for orphaned repository doctor (#28487) (#28490)
  * Fix possible nil pointer access (#28428) (#28440)
  * Don't show unnecessary citation JS error on UI (#28433) (#28437)
* DOCS
  * Update actions document about comparison as Github Actions (#28560) (#28564)
  * Fix documents for "custom/public/assets/" (#28465) (#28467)
* MISC
  * Fix inperformant query on retrifing review from database. (#28552) (#28562)
  * Improve the prompt for "ssh-keygen sign" (#28509) (#28510)
  * Update docs for DISABLE_QUERY_AUTH_TOKEN (#28485) (#28488)
  * Fix Chinese translation of config cheat sheet[API] (#28472) (#28473)
  * Retry SSH key verification with additional CRLF if it failed (#28392) (#28464)

## [1.21.2](https://github.com/go-gitea/gitea/releases/tag/v1.21.2) - 2023-12-12

* SECURITY
  * Rebuild with recently released golang version
  * Fix missing check (#28406) (#28411)
  * Do some missing checks (#28423) (#28432)
* BUGFIXES
  * Fix margin in server signed signature verification view (#28379) (#28381)
  * Fix object does not exist error when checking citation file (#28314) (#28369)
  * Use `filepath` instead of `path` to create SQLite3 database file (#28374) (#28378)
  * Fix the runs will not be displayed bug when the main branch have no workflows but other branches have (#28359) (#28365)
  * Handle repository.size column being NULL in migration v263 (#28336) (#28363)
  * Convert git commit summary to valid UTF8. (#28356) (#28358)
  * Fix migration panic due to an empty review comment diff (#28334) (#28362)
  * Add `HEAD` support for rpm repo files (#28309) (#28360)
  * Fix RPM/Debian signature key creation (#28352) (#28353)
  * Keep profile tab when clicking on Language (#28320) (#28331)
  * Fix missing issue search index update when changing status (#28325) (#28330)
  * Fix wrong link in `protect_branch_name_pattern_desc` (#28313) (#28315)
  * Read `previous` info from git blame (#28306) (#28310)
  * Ignore "non-existing" errors when getDirectorySize calculates the size (#28276) (#28285)
  * Use appSubUrl for OAuth2 callback URL tip (#28266) (#28275)
  * Meilisearch: require all query terms to be matched (#28293) (#28296)
  * Fix required error for token name (#28267) (#28284)
  * Fix issue will be detected as pull request when checking `First-time contributor` (#28237) (#28271)
  * Use full width for project boards (#28225) (#28245)
  * Increase "version" when update the setting value to a same value as before (#28243) (#28244)
  * Also sync DB branches on push if necessary (#28361) (#28403)
  * Make gogit Repository.GetBranchNames consistent (#28348) (#28386)
  * Recover from panic in cron task (#28409) (#28425)
  * Deprecate query string auth tokens (#28390) (#28430)
* ENHANCEMENTS
  * Improve doctor cli behavior (#28422) (#28424)
  * Fix margin in server signed signature verification view (#28379) (#28381)
  * Refactor template empty checks (#28351) (#28354)
  * Read `previous` info from git blame (#28306) (#28310)
  * Use full width for project boards (#28225) (#28245)
  * Enable system users search via the API (#28013) (#28018)

## [1.21.1](https://github.com/go-gitea/gitea/releases/tag/v1.21.1) - 2023-11-26

* SECURITY
  * Fix comment permissions (#28213) (#28216)
* BUGFIXES
  * Fix delete-orphaned-repos (#28200) (#28202)
  * Make CORS work for oauth2 handlers (#28184) (#28185)
  * Fix missing buttons (#28179) (#28181)
  * Fix no ActionTaskOutput table waring (#28149) (#28152)
  * Fix empty action run title (#28113) (#28148)
  * Use "is-loading" to avoid duplicate form submit for code comment (#28143) (#28147)
  * Fix Matrix and MSTeams nil dereference (#28089) (#28105)
  * Fix incorrect pgsql conn builder behavior (#28085) (#28098)
  * Fix system config cache expiration timing (#28072) (#28090)
  * Restricted users only see repos in orgs which their team was assigned to (#28025) (#28051)
* API
  * Fix permissions for Token DELETE endpoint to match GET and POST (#27610) (#28099)
* ENHANCEMENTS
  * Do not display search box when there's no packages yet (#28146) (#28159)
  * Add missing `packages.cleanup.success` (#28129) (#28132)
* DOCS
  * Docs: Replace deprecated IS_TLS_ENABLED mailer setting in email setup (#28205) (#28208)
  * Fix the description about the default setting for action in quick start document (#28160) (#28168)
  * Add guide page to actions when there's no workflows (#28145) (#28153)
* MISC
  * Use full width for PR comparison (#28182) (#28186)

## [1.21.0](https://github.com/go-gitea/gitea/releases/tag/v1.21.0) - 2023-11-14

* BREAKING
  * Restrict certificate type for builtin SSH server (#26789)
  * Refactor to use urfave/cli/v2 (#25959)
  * Move public asset files to the proper directory (#25907)
  * Remove commit status running and warning to align GitHub (#25839) (partially reverted: Restore warning commit status (#27504) (#27529))
  * Remove "CHARSET" config option for MySQL, always use "utf8mb4" (#25413)
  * Set SSH_AUTHORIZED_KEYS_BACKUP to false (#25412)
* FEATURES
  * User details page (#26713)
  * Chore(actions): support cron schedule task (#26655)
  * Support rebuilding issue indexer manually (#26546)
  * Allow to archive labels (#26478)
  * Add disable workflow feature (#26413)
  * Support `.git-blame-ignore-revs` file (#26395)
  * Pre-register OAuth2 applications for git credential helpers (#26291)
  * Add `Retry` button when creating a mirror-repo fails (#26228)
  * Artifacts retention and auto clean up (#26131)
  * Serve pre-defined files in "public", add "security.txt", add CORS header for ".well-known" (#25974)
  * Implement auto-cancellation of concurrent jobs if the event is push (#25716)
  * Newly pushed branches hints on repository home page (#25715)
  * Display branch commit status (#25608)
  * Add direct serving of package content (#25543)
  * Add commits dropdown in PR files view and allow commit by commit review (#25528)
  * Allow package cleanup from admin page (#25307)
  * Batch delete issue and improve tippy opts (#25253)
  * Show branches and tags that contain a commit (#25180)
  * Add actor and status dropdowns to run list (#25118)
  * Allow Organisations to have a E-Mail (#25082)
  * Add codeowners feature (#24910)
  * Actions Artifacts support uploading multiple files and directories (#24874)
  * Support configuration variables on Gitea Actions (#24724)
  * Support downloading raw task logs (#24451)
* API
  * Unify two factor check (#27915) (#27929)
  * Fix package webhook (#27839) (#27855)
  * Fix/upload artifact error windows (#27802) (#27840)
  * Fix bad method call when deleting user secrets via API (#27829) (#27831)
  * Do not force creation of _cargo-index repo on publish (#27266) (#27765)
  * Delete repos of org when purge delete user (#27273) (#27728)
  * Fix org team endpoint (#27721) (#27727)
  * Api: GetPullRequestCommits: return file list (#27483) (#27539)
  * Don't let API add 2 exclusive labels from same scope (#27433) (#27460)
  * Redefine the meaning of column is_active to make Actions Registration Token generation easier (#27143) (#27304)
  * Fix PushEvent NullPointerException jenkinsci/github-plugin (#27203) (#27251)
  * Fix organization field being null in POST /orgs/{orgid}/teams (#27150) (#27163)
  * Allow empty Conan files (#27092)
  * Fix token endpoints ignore specified account (#27080)
  * Reduce usage of `db.DefaultContext` (#27073) (#27083) (#27089) (#27103) (#27262) (#27265) (#27347) (#26076)
  * Make SSPI auth mockable (#27036)
  * Extract auth middleware from service (#27028)
  * Add `RemoteAddress` to mirrors (#26952)
  * Feat(API): add routes and functions for managing user's secrets (#26909)
  * Feat(API): add secret deletion functionality for repository (#26808)
  * Feat(API): add route and implementation for creating/updating repository secret (#26766)
  * Add Upload URL to release API (#26663)
  * Feat(API): update and delete secret for managing organization secrets (#26660)
  * Feat: implement organization secret creation API (#26566)
  * Add API route to list org secrets (#26485)
  * Set commit id when ref used explicitly (#26447)
  * PATCH branch-protection updates check list even when checks are disabled (#26351)
  * Add file status for API "Get a single commit from a repository" (#16205) (#25831)
  * Add API for changing Avatars (#25369)
* BUGFIXES
  * Fix viewing wiki commit on empty repo (#28040) (#28044)
  * Enable system users for comment.LoadPoster (#28014) (#28032)
  * Fixed duplicate attachments on dump on windows (#28019) (#28031)
  * Fix wrong xorm Delete usage(backport for 1.21) (#28002)
  * Add word-break to repo description in home page (#27924) (#27957)
  * Fix rendering assignee changed comments without assignee (#27927) (#27952)
  * Add word break to release title (#27942) (#27947)
  * Fix JS NPE when viewing specific range of PR commits (#27912) (#27923)
  * Show correct commit sha when viewing single commit diff (#27916) (#27921)
  * Fix 500 when deleting a dismissed review (#27903) (#27910)
  * Fix DownloadFunc when migrating releases (#27887) (#27890)
  * Fix http protocol auth (#27875) (#27876)
  * Refactor postgres connection string building (#27723) (#27869)
  * Close all hashed buffers (#27787) (#27790)
  * Fix label render containing invalid HTML (#27752) (#27762)
  * Fix duplicate project board when hitting `enter` key (#27746) (#27751)
  * Fix `link-action` redirect network error (#27734) (#27749)
  * Fix sticky diff header background (#27697) (#27712)
  * Always delete existing scheduled action tasks (#27662) (#27688)
  * Support allowed hosts for webhook to work with proxy (#27655) (#27675)
  * Fix poster is not loaded in get default merge message (#27657) (#27666)
  * Improve dropdown button alignment and fix hover bug (#27632) (#27637)
  * Improve retrying index issues (#27554) (#27634)
  * Fix 404 when deleting Docker package with an internal version (#27615) (#27630)
  * Backport manually for a tmpl issue in v1.21 (#27612)
  * Don't show Link to TOTP if not set up (#27585) (#27588)
  * Fix data-race bug when accessing task.LastRun (#27584) (#27586)
  * Fix attachment download bug (#27486) (#27571)
  * Respect SSH.KeygenPath option when calculating ssh key fingerprints (#27536) (#27551)
  * Improve dropdown's behavior when there is a search input in menu (#27526) (#27534)
  * Fix panic in storageHandler (#27446) (#27479)
  * When comparing with an non-exist repository, return 404 but 500 (#27437) (#27442)
  * Fix pr template (#27436) (#27440)
  * Fix git 2.11 error when checking IsEmpty (#27393) (#27397)
  * Allow get release download files and lfs files with oauth2 token format (#26430) (#27379)
  * Fix missing ctx for GetRepoLink in dashboard (#27372) (#27375)
  * Absolute positioned checkboxes  overlay floated elements (#26870) (#27366)
  * Introduce fixes and more rigorous tests for 'Show on a map' feature (#26803) (#27365)
  * Fix repo count in org action settings (#27245) (#27353)
  * Add logs for data broken of comment review (#27326) (#27345)
  * Fix the approval count of PR when there is no protection branch rule (#27272) (#27343)
  * Fix Bug in Issue Config when only contact links are set (#26521) (#27334)
  * Improve issue history dialog and make poster can delete their own history (#27323) (#27327)
  * Fix orphan check for deleted branch (#27310) (#27321)
  * Fix protected branch icon location (#26576) (#27317)
  * Fix yaml test (#27297) (#27303)
  * Fix some animation bugs (#27287) (#27294)
  * Fix incorrect change from #27231 (#27275) (#27282)
  * Add missing public user visibility in user details page (#27246) (#27250)
  * Fix EOL handling in web editor (#27141) (#27234)
  * Fix issues on action runners page (#27226) (#27233)
  * Quote table `release` in sql queries (#27205) (#27218)
  * Fix release URL in webhooks (#27182) (#27185)
  * Fix review request number and add more tests (#27104) (#27168)
  * Fix the variable regexp pattern on web page (#27161) (#27164)
  * Fix: treat tab "overview" as "repositories" in user profiles without readme (#27124)
  * Fix NPE when editing OAuth2 applications (#27078)
  * Fix the incorrect route path in the user edit page. (#27007)
  * Fix the secret regexp pattern on web page (#26910)
  * Allow users with write permissions for issues to add attachments with API (#26837)
  * Make "link-action" backend code respond correct JSON content (#26680)
  * Use line-height: normal by default (#26635)
  * Fix NPM packages name validation (#26595)
  * Rewrite the DiffFileTreeItem and fix misalignment (#26565)
  * Return empty when searching issues with no repos (#26545)
  * Explain SearchOptions and fix ToSearchOptions (#26542)
  * Add missing triggers to update issue indexer (#26539)
  * Handle base64 decoding correctly to avoid panic (#26483)
  * Avoiding accessing undefined mentionValues (#26461)
  * Fix incorrect redirection in new issue using references (#26440)
  * Fix the bug when getting files changed for `pull_request_target` event (#26320)
  * Remove IsWarning in  tmpl (#26120)
  * Fix loading `LFS_JWT_SECRET` from wrong section (#26109)
  * Fixing redirection issue for logged-in users (#26105)
  * Improve "gitea doctor" sub-command and fix "help" commands (#26072)
  * Fix the truncate and alignment problem for some admin tables (#26042)
  * Update minimum password length requirements (#25946)
  * Do not "guess" the file encoding/BOM when using API to upload files (#25828)
  * Restructure issue list template, styles (#25750)
  * Fix `ref` for workflows triggered by `pull_request_target` (#25743)
  * Fix issues indexer document mapping (#25619)
  * Use JSON response for "user/logout" (#25522)
  * Fix migrate page layout on mobile (#25507)
  * Link to existing PR when trying to open a new PR on the same branches (#25494)
  * Do not publish docker release images on `-dev` tags (#25471)
  * Support `pull_request_target` event (#25229)
  * Modify the content format of the Feishu webhook (#25106)
* ENHANCEMENTS
  * Render email addresses as such if followed by punctuation (#27987) (#27992)
  * Show error toast when file size exceeds the limits (#27985) (#27986)
  * Fix citation error when the file size is larger than 1024 bytes (#27958) (#27965)
  * Remove action runners on user deletion (#27902) (#27908)
  * Remove set tabindex on view issue (#27892) (#27896)
  * Reduce margin/padding on flex-list items and divider (#27872) (#27874)
  * Change katex limits (#27823) (#27868)
  * Clean up template locale usage (#27856) (#27857)
  * Add dedicated class for empty placeholders (#27788) (#27792)
  * Add gap between diff boxes (#27776) (#27781)
  * Fix incorrect "tab" parameter for repo search sub-template (#27755) (#27764)
  * Enable followCursor for language stats bar (#27713) (#27739)
  * Improve diff tree spacing (#27714) (#27719)
  * Feed UI Improvements (#27356) (#27717)
  * Improve feed icons and feed merge text color (#27498) (#27716)
  * [FIX] resolve confusing colors in languages stats by insert a gap (#27704) (#27715)
  * Add doctor dbconsistency fix to delete repos with no owner (#27290) (#27693)
  * Fix required checkboxes in issue forms (#27592) (#27692)
  * Hide archived labels by default from the suggestions when assigning labels for an issue (#27451) (#27661)
  * Cleanup repo details icons/labels (#27644) (#27654)
  * Keep filter when showing unfiltered results on explore page (#27192) (#27589)
  * Show manual cron run's last time (#27544) (#27577)
  * Revert "Fix pr template (#27436)" (#27567)
  * Increase queue length (#27555) (#27562)
  * Avoid run change title process when the title is same (#27467) (#27558)
  * Remove max-width and add hide text overflow (#27359) (#27550)
  * Add hover background to wiki list page (#27507) (#27521)
  * Fix mermaid flowchart margin issue (#27503) (#27516)
  * Refactor system setting (#27000) (#27452)
  * Fix  missing `ctx`  in new_form.tmpl  (#27434) (#27438)
  * Add Index to `action.user_id` (#27403) (#27425)
  * Don't use subselect in `DeleteIssuesByRepoID` (#27332) (#27408)
  * Add support for HEAD ref in /src/branch and /src/commit routes (#27384) (#27407)
  * Make Actions tasks/jobs timeouts configurable by the user (#27400) (#27402)
  * Hide archived labels when filtering by labels on the issue list (#27115) (#27381)
  * Highlight user details link (#26998) (#27376)
  * Add protected branch name description (#27257) (#27351)
  * Improve tree not found page (#26570) (#27346)
  * Add Index to `comment.dependent_issue_id` (#27325) (#27340)
  * Improve branch list UI (#27319) (#27324)
  * Fix divider in subscription page (#27298) (#27301)
  * Add missed return to actions view fetch (#27289) (#27293)
  * Backport ctx locale refactoring manually (#27231) (#27259) (#27260)
  * Disable `Test Delivery` and `Replay` webhook buttons when webhook is inactive (#27211) (#27253)
  * Use mask-based fade-out effect for `.new-menu` (#27181) (#27243)
  * Cleanup locale function usage (#27227) (#27240)
  * Fix z-index on markdown completion (#27237) (#27239)
  * Fix Fomantic UI dropdown icon bug when there is a search input in menu (#27225) (#27228)
  * Allow copying issue comment link on archived repos and when not logged in (#27193) (#27210)
  * Fix: text decorator on issue sidebar menu label (#27206) (#27209)
  * Fix dropdown icon position (#27175) (#27177)
  * Add index to `issue_user.issue_id` (#27154) (#27158)
  * Increase auth provider icon size on login page (#27122)
  * Remove a `gt-float-right` and some unnecessary helpers (#27110)
  * Change green buttons to primary color (#27099)
  * Use db.WithTx for AddTeamMember to avoid ctx abuse (#27095)
  * Use `print` instead of `printf` (#27093)
  * Remove the useless function `GetUserIssueStats` and move relevant tests to `indexer_test.go` (#27067)
  * Search branches (#27055)
  * Display all user types and org types on admin management UI (#27050)
  * Ui correction in mobile view nav bar left aligned items. (#27046)
  * Chroma color tweaks (#26978)
  * Move some functions to service layer (#26969)
  * Improve "language stats" UI (#26968)
  * Replace `util.SliceXxx`  with `slices.Xxx` (#26958)
  * Refactor dashboard/feed.tmpl (#26956)
  * Move repository deletion to service layer (#26948)
  * Fix the missing repo count (#26942)
  * Improve hint when uploading a too large avatar (#26935)
  * Extract common code to new template (#26933)
  * Move createrepository from module to service layer (#26927)
  * Move notification interface to services layer (#26915)
  * Move feed notification service layer (#26908)
  * Move ui notification to service layer (#26907)
  * Move indexer notification to service layer (#26906)
  * Move mail notification logic to service layer (#26905)
  * Extract common code to new template (#26903)
  * Show queue's active worker number (#26896)
  * Fix media description render for orgmode (#26895)
  * Remove CSS `has` selector and improve various styles (#26891)
  * Relocate the `RSS user feed` button (#26882)
  * Refactor "shortsha" (#26877)
  * Refactor `og:description` to limit the max length (#26876)
  * Move web/api context related testing function into a separate package (#26859)
  * Redable error on S3 storage connection failure (#26856)
  * Improve opengraph previews (#26851)
  * Add more descriptive error on forgot password page (#26848)
  * Show always repo count in header (#26842)
  * Remove "TODO" tasks from CSS file (#26835)
  * Render code blocks in repo description (#26830)
  * Minor dashboard tweaks, fix flex-list margins (#26829)
  * Remove polluted `.ui.right` (#26825)
  * Display archived labels specially when listing labels (#26820)
  * Remove polluted ".ui.left" style (#26809)
  * Make it posible to customize nav text color via css var (#26807)
  * Refactor lfs requests (#26783)
  * Improve flex list item padding (#26779)
  * Remove fomantic `text` module (#26777)
  * Remove fomantic `item` module (#26775)
  * Remove redundant nil check in `WalkGitLog` (#26773)
  * Reduce some allocations in type conversion (#26772)
  * Refactor some CSS styles and simplify code (#26771)
  * Unify `border-radius` behavior (#26770)
  * Improve modal dialog UI (#26764)
  * Allow "latest" to be used in release vTag when downloading file (#26748)
  * Adding hint `Archived` to archive label. (#26741)
  * Move `modules/mirror` to `services` (#26737)
  * Add "dir=auto" for input/textarea elements by default (#26735)
  * Add auth-required to config.json for Cargo http registry (#26729)
  * Simplify helper CSS classes and avoid abuse (#26728)
  * Make web context initialize correctly for different cases (#26726)
  * Focus editor on "Write" tab click (#26714)
  * Remove incorrect CSS helper classes (#26712)
  * Fix review bar misalignment (#26711)
  * Add reverseproxy auth for API back with default disabled (#26703)
  * Add default label in branch select list (#26697)
  * Improve Image Diff UI (#26696)
  * Fixed text overflow in dropdown menu (#26694)
  * [Refactor] getIssueStatsChunk to move inner function into own one (#26671)
  * Remove fomantic loader module (#26670)
  * Add `member`, `collaborator`, `contributor`, and `first-time contributor` roles and tooltips (#26658)
  * Improve some flex layouts (#26649)
  * Improve the branch selector tab UI (#26631)
  * Improve show role (#26621)
  * Remove avatarHTML from template helpers (#26598)
  * Allow text selection in actions step header (#26588)
  * Improve translation of milestone filters (#26569)
  * Add optimistic lock to ActionRun table (#26563)
  * Update team invitation email link (#26550)
  * Differentiate better between user settings and admin settings (#26538)
  * Check disabled workflow when rerun jobs (#26535)
  * Improve deadline icon location in milestone list page (#26532)
  * Improve repo sub menu (#26531)
  * Fix the display of org level badges (#26504)
  * Rename `Sync2` -> `Sync` (#26479)
  * Fix stderr usages (#26477)
  * Remove fomantic transition module (#26469)
  * Refactor tests (#26464)
  * Refactor project templates (#26448)
  * Fall back to esbuild for css minify (#26445)
  * Always show usernames in reaction tooltips (#26444)
  * Use correct pull request commit link instead of a generic commit link (#26434)
  * Refactor "editorconfig" (#26391)
  * Make `user-content-* ` consistent with github (#26388)
  * Remove unnecessary template helper repoAvatar (#26387)
  * Remove unnecessary template helper DisableGravatar (#26386)
  * Use template context function for avatar rendering (#26385)
  * Rename code_langauge.go to code_language.go (#26377)
  * Use more `IssueList` instead of `[]*Issue` (#26369)
  * Do not highlight `#number` in documents (#26365)
  * Fix display problems of members and teams unit (#26363)
  * Fix 404 error when remove self from an organization (#26362)
  * Improve CLI and messages (#26341)
  * Refactor backend SVG package and add tests (#26335)
  * Add link to job details and tooltip to commit status in repo list in dashboard (#26326)
  * Use yellow if an approved review is stale (#26312)
  * Remove commit load branches and tags in wiki repo (#26304)
  * Add highlight to selected repos in milestone dashboard (#26300)
  * Delete `issue_service.CreateComment` (#26298)
  * Do not show Profile README when repository is private (#26295)
  * Tweak actions menu (#26278)
  * Start using template context function (#26254)
  * Use calendar icon for `Joined on...` in profiles (#26215)
  * Add 'Show on a map' button to Location in profile, fix layout (#26214)
  * Render plaintext task list items for markdown files (#26186)
  * Add tooltip to describe LFS table column and color `delete LFS file` button red (#26181)
  * Release attachments duplicated check (#26176)
  * De-emphasize issue sidebar buttons (#26171)
  * Fixing the align of commit stats in commit_page template. (#26161)
  * Allow editing push mirrors after creation (#26151)
  * Move web JSON functions to web context and simplify code (#26132)
  * Refactor improve NoBetterThan (#26126)
  * Improve clickable area in repo action view page (#26115)
  * Add context parameter to some database functions (#26055)
  * Docusaurus-ify (#26051)
  * Improve text for empty issue/pr description (#26047)
  * Categorize admin settings sidebar panel (#26030)
  * Remove redundant "RouteMethods" method (#26024)
  * Refactor and enhance issue indexer to support both searching, filtering and paging (#26012)
  * Add a link to OpenID Issuer URL in WebFinger response (#26000)
  * Fix UI for release tag page / wiki page / subscription page (#25948)
  * Support copy protected branch from template repository (#25889)
  * Improve display of Labels/Projects/Assignees sort options (#25886)
  * Fix margin on the new/edit project page. (#25885)
  * Show image size on view page (#25884)
  * Remove ref name in PR commits page (#25876)
  * Allow the use of alternative net.Listener implementations by downstreams (#25855)
  * Refactor "Content" for file uploading (#25851)
  * Add error info if no user can fork the repo (#25820)
  * Show edit title button on commits tab of PR, too (#25791)
  * Introduce `flex-list` & `flex-item` elements for Gitea UI (#25790)
  * Don't stack PR tab menu on small screens (#25789)
  * Repository Archived text title center align (#25767)
  * Make route middleware/handler mockable (#25766)
  * Move issue filters to shared template (#25729)
  * Use frontend fetch for branch dropdown component (#25719)
  * Add open/closed field support for issue index (#25708)
  * Some less naked returns (#25682)
  * Fix inconsistent user profile layout across tabs (#25625)
  * Get latest commit statuses from database instead of git data on dashboard for repositories (#25605)
  * Adding  branch-name copy  to clipboard branches screen. (#25596)
  * Update emoji set to Unicode 15 (#25595)
  * Move some files under repo/setting (#25585)
  * Add custom ansi colors and CSS variables for them (#25546)
  * Add log line anchor for action logs (#25532)
  * Use flex instead of float for sort button and search input (#25519)
  * Update octicons and use `octicon-file-directory-symlink` (#25453)
  * Add toasts to UI (#25449)
  * Fine tune project board label colors and modal content background (#25419)
  * Import additional secrets via file uri (#25408)
  * Switch to ansi_up for ansi rendering in actions (#25401)
  * Store and use seconds for timeline time comments (#25392)
  * Support displaying diff stats in PR tab bar (#25387)
  * Use fetch form action for lock/unlock/pin/unpin on sidebar (#25380)
  * Refactor: TotalTimes return seconds (#25370)
  * Navbar styling rework (#25343)
  * Introduce shared template for search inputs (#25338)
  * Only show 'Manage Account Links' when necessary (#25311)
  * Improve 'Privacy' section in profile settings (#25309)
  * Substitute variables in path names of template repos too (#25294)
  * Fix tags line no margin see #25255 (#25280)
  * Use fetch to send requests to create issues/comments (#25258)
  * Change form actions to fetch for submit review box (#25219)
  * Improve AJAX link and modal confirm dialog (#25210)
  * Reduce unnecessary DB queries for Actions tasks (#25199)
  * Disable `Create column` button while the column name is empty (#25192)
  * Refactor indexer (#25174)
  * Adjust style for action run list (align icons, adjust padding) (#25170)
  * Remove duplicated functions when deleting a branch (#25128)
  * Make confusable character warning less jarring (#25069)
  * Highlight viewed files differently in the PR filetree (#24956)
  * Support changing labels of Actions runner without re-registration (#24806)
  * Fix duplicate Reviewed-by trailers (#24796)
  * Resolve issue with sort icons on admin/users and admin/runners (#24360)
  * Split lfs size from repository size (#22900)
  * Sync branches into databases (#22743)
  * Disable run user change in installation page (#22499)
  * Add merge files files to GetCommitFileStatus (#20515)
  * Show OpenID Connect and OAuth on signup page (#20242)
* SECURITY
  * Dont leak private users via extensions (#28023) (#28029)
  * Expanded minimum RSA Keylength to 3072 (#26604)
* TESTING
  * Add user secrets API integration tests (#27832) (#27852)
  * Add tests for db indexer in indexer_test.go (#27087)
  * Speed up TestEventSourceManagerRun (#26262)
  * Add unit test for user renaming (#26261)
  * Add some Wiki unit tests (#26260)
  * Improve unit test for caching (#26185)
  * Add unit test for `HashAvatar` (#25662)
* TRANSLATION
  * Backport translations to v1.21 (#27899)
  * Fix issues in translation file (#27699) (#27737)
  * Add locale for deleted head branch (#26296)
  * Improve multiple strings in en-US locale (#26213)
  * Fix broken translations for package documantion (#25742)
  * Correct translation wrong format (#25643)
* BUILD
  * Dockerfile small refactor (#27757) (#27826)
  * Fix build errors on BSD (in BSDMakefile) (#27594) (#27608)
  * Fully replace drone with actions (#27556) (#27575)
  * Enable markdownlint `no-duplicate-header` (#27500) (#27506)
  * Enable production source maps for index.js, fix CSS sourcemaps (#27291) (#27295)
  * Update snap package (#27021)
  * Bump go to 1.21 (#26608)
  * Bump xgo to go-1.21.x and node to 20 in release-version (#26589)
  * Add template linting via djlint (#25212)
* DOCS
  * Change default size of issue/pr attachments and repo file (#27946) (#28017)
  * Remove `known issue` section in Gitea Actions Doc (#27930) (#27938)
  * Remove outdated paragraphs when comparing Gitea Actions to GitHub Actions (#27119)
  * Update brew installation documentation since gitea moved to brew core package (#27070)
  * Actions are no longer experimental, so enable them by default (#27054)
  * Add a documentation note for Windows Service (#26938)
  * Add sparse url in cargo package guide (#26937)
  * Update nginx recommendations (#26924)
  * Update backup instructions to align with archive structure (#26902)
  * Expanding documentation in queue.go (#26889)
  * Update info regarding internet connection for build (#26776)
  * Docs: template variables (#26547)
  * Update index doc (#26455)
  * Update zh-cn documentation (#26406)
  * Fix typos and grammar problems for actions documentation (#26328)
  * Update documentation for 1.21 actions (#26317)
  * Doc update swagger doc for POST /orgs/{org}/teams (#26155)
  * Doc sync authentication.md to zh-cn (#26117)
  * Doc guide the user to create the appropriate level runner (#26091)
  * Make organization redirect warning more clear (#26077)
  * Update blog links (#25843)
  * Fix default value for LocalURL (#25426)
  * Update `from-source.zh-cn.md` & `from-source.en-us.md` - Cross Compile Using Zig (#25194)
* MISC
  * Replace deprecated `elliptic.Marshal` (#26800)
  * Add elapsed time on debug for slow git commands (#25642)

## [1.20.5](https://github.com/go-gitea/gitea/releases/tag/v1.20.5) - 2023-10-03

* ENHANCEMENTS
  * Fix z-index on markdown completion (#27237) (#27242 & #27238)
  * Use secure cookie for HTTPS sites (#26999) (#27013)
* BUGFIXES
  * Fix git 2.11 error when checking IsEmpty (#27393) (#27396)
  * Allow get release download files and lfs files with oauth2 token format (#26430) (#27378)
  * Fix orphan check for deleted branch (#27310) (#27320)
  * Quote table `release` in sql queries (#27205) (#27219)
  * Fix release URL in webhooks (#27182) (#27184)
  * Fix successful return value for `SyncAndGetUserSpecificDiff` (#27152) (#27156)
  * fix pagination for followers and following (#27127) (#27138)
  * Fix issue templates when blank isses are disabled (#27061) (#27082)
  * Fix context cache bug & enable context cache for dashabord commits' authors(#26991) (#27017)
  * Fix INI parsing for value with trailing slash (#26995) (#27001)
  * Fix PushEvent NullPointerException jenkinsci/github-plugin (#27203) (#27249)
  * Fix organization field being null in POST /orgs/{orgid}/teams (#27150) (#27167 & #27162)
  * Fix bug of review request number (#27406) (#27104)
* TESTING
  * services/wiki: Close() after error handling (#27129) (#27137)
* DOCS
  * Improve actions docs related to `pull_request` event (#27126) (#27145)
* MISC
  * Add logs for data broken of comment review (#27326) (#27344)
  * Load reviewer before sending notification (#27063) (#27064)

## [1.20.4](https://github.com/go-gitea/gitea/releases/tag/v1.20.4) - 2023-09-08

* SECURITY
  * Check blocklist for emails when adding them to account (#26812) (#26831)
* ENHANCEMENTS
  * Add `branch_filter` to hooks API endpoints (#26599) (#26632)
  * Fix incorrect "tabindex" attributes (#26733) (#26734)
  * Use line-height: normal by default (#26635) (#26708)
  * Fix unable to display individual-level project (#26198) (#26636)
* BUGFIXES
  * Fix wrong review requested number (#26784) (#26880)
  * Avoid double-unescaping of form value (#26853) (#26863)
  * Redirect from `{repo}/issues/new` to `{repo}/issues/new/choose` when blank issues are disabled (#26813) (#26847)
  * Sync tags when adopting repos (#26816) (#26834)
  * Fix verifyCommits error when push a new branch (#26664) (#26810)
  * Include the GITHUB_TOKEN/GITEA_TOKEN secret for fork pull requests (#26759) (#26806)
  * Fix some slice append usages (#26778) (#26798)
  * Add fix incorrect can_create_org_repo for org owner team (#26683) (#26791)
  * Fix bug for ctx usage (#26763)
  * Make issue template field template access correct template data (#26698) (#26709)
  * Use correct minio error (#26634) (#26639)
  * Ignore the trailing slashes when comparing oauth2 redirect_uri (#26597) (#26618)
  * Set errwriter for urfave/cli v1 (#26616)
  * Fix reopen logic for agit flow pull request (#26399) (#26613)
  * Fix context filter has no effect in dashboard (#26695) (#26811)
  * Fix being unable to use a repo that prohibits accepting PRs as a PR source. (#26785) (#26790)
  * Fix Page Not Found error (#26768)

## [1.20.3](https://github.com/go-gitea/gitea/releases/tag/v1.20.3) - 2023-08-20

* BREAKING
  * Fix the wrong derive path (#26271) (#26318)
* SECURITY
  * Fix API leaking Usermail if not logged in (#25097) (#26350)
* FEATURES
  * Add ThreadID parameter for Telegram webhooks (#25996) (#26480)
* ENHANCEMENTS
  * Add minimum polyfill to support "relative-time-element" in PaleMoon (#26575) (#26578)
  * Fix dark theme highlight for "NameNamespace" (#26519) (#26527)
  * Detect ogg mime-type as audio or video (#26494) (#26505)
  * Use `object-fit: contain` for oauth2 custom icons (#26493) (#26498)
  * Move dropzone progress bar to bottom to show filename when uploading (#26492) (#26497)
  * Remove last newline from config file (#26468) (#26471)
  * Minio: add missing region on client initialization (#26412) (#26438)
  * Add pull request review request webhook event (#26401) (#26407)
  * Fix text truncate (#26354) (#26384)
  * Fix incorrect color of selected assignees when create issue (#26324) (#26372)
  * Display human-readable text instead of cryptic filemodes (#26352) (#26358)
  * Hide `last indexed SHA` when a repo could not be indexed yet (#26340) (#26345)
  * Fix the topic validation rule and support dots (#26286) (#26303)
  * Fix due date rendering the wrong date in issue (#26268) (#26274)
  * Don't autosize textarea in diff view (#26233) (#26244)
  * Fix commit compare style (#26209) (#26226)
  * Warn instead of reporting an error when a webhook cannot be found (#26039) (#26211)
* BUGFIXES
  * Use "input" event instead of "keyup" event for migration form (#26602) (#26605)
  * Do not use deprecated log config options by default (#26592) (#26600)
  * Fix "issueReposQueryPattern does not match query" (#26556) (#26564)
  * Sync repo's IsEmpty status correctly (#26517) (#26560)
  * Fix project filter bugs (#26490) (#26558)
  * Use `hidden` over `clip` for text truncation (#26520) (#26522)
  * Set "type=button" for editor's toolbar buttons (#26510) (#26518)
  * Fix NuGet search endpoints (#25613) (#26499)
  * Fix storage path logic especially for relative paths (#26441) (#26481)
  * Close stdout correctly for "git blame" (#26470) (#26473)
  * Check first if minio bucket exists before trying to create it (#26420) (#26465)
  * Avoiding accessing undefined tributeValues #26461 (#26462)
  * Call git.InitSimple for runRepoSyncReleases (#26396) (#26450)
  * Add transaction when creating pull request created dirty data (#26259) (#26437)
  * Fix wrong middleware sequence (#26428) (#26436)
  * Fix admin queue page title and fix CI failures (#26409) (#26421)
  * Introduce ctx.PathParamRaw to avoid incorrect unescaping (#26392) (#26405)
  * Bypass MariaDB performance bug of the "IN" sub-query, fix incorrect IssueIndex (#26279) (#26368)
  * Fix incorrect CLI exit code and duplicate error message (#26346) (#26347)
  * Prevent newline errors with Debian packages (#26332) (#26342)
  * Fix bug with sqlite load read (#26305) (#26339)
  * Make git batch operations use parent context timeout instead of default timeout (#26325) (#26330)
  * Support getting changed files when commit ID is `EmptySHA` (#26290) (#26316)
  * Clarify the logger's MODE config option (#26267) (#26281)
  * Use shared template for webhook icons (#26242) (#26246)
  * Fix pull request check list is limited (#26179) (#26245)
  * Fix attachment clipboard copy on insecure origin (#26224) (#26231)
  * Fix access check for org-level project (#26182) (#26223)
* MISC
  * Improve profile readme rendering (#25988) (#26453)
  * [docs] Add missing backtick in quickstart.zh-cn.md (#26349) (#26357)
  * Upgrade x/net to 0.13.0 (#26301)

## [1.20.2](https://github.com/go-gitea/gitea/releases/tag/v1.20.2) - 2023-07-29

* ENHANCEMENTS
  * Calculate MAX_WORKERS default value by CPU number (#26177) (#26183)
  * Display deprecated warning in admin panel pages as well as in the log file (#26094) (#26154)
* BUGFIXES
  * Fix allowed user types setting problem (#26200) (#26206)
  * Fix handling of plenty Nuget package versions (#26075) (#26173)
  * Fix UI regression of asciinema player (#26159) (#26162)
  * Fix LFS object list style (#26133) (#26147)
  * Fix allowed user types setting problem (#26200) (#26206)
  * Prevent primary key update on migration (#26192) (#26199)
  * Fix bug when pushing to a pull request which enabled dismiss approval automatically (#25882) (#26158)
  * Fix bugs in LFS meta garbage collection (#26122) (#26157)
  * Update xorm version (#26128) (#26150)
  * Remove "misc" scope check from public API endpoints (#26134) (#26149)
  * Fix CLI allowing creation of access tokens with existing name (#26071) (#26144)
  * Fix incorrect router logger (#26137) (#26143)
  * Improve commit graph alignment and truncating (#26112) (#26127)
  * Avoid writing config file if not installed (#26107) (#26113)
  * Fix escape problems in the branch selector (#25875) (#26103)
  * Fix handling of Debian files with trailing slash (#26087) (#26098)
  * Fix Missing 404 swagger response docs for /admin/users/{username} (#26086) (#26089)
  * Use stderr as fallback if the log file can't be opened (#26074) (#26083)
  * Increase table cell horizontal padding (#26140) (#26142)
  * Fix wrong workflow status when rerun a job in an already finished workflow (#26119) (#26124)
  * Fix duplicated url prefix on issue context menu (#26066) (#26067)

## [1.20.1](https://github.com/go-gitea/gitea/releases/tag/v1.20.1) - 2023-07-22

* SECURITY
  * Disallow dangerous URL schemes (#25960) (#25964)
* ENHANCEMENTS
  * Show the mismatched ROOT_URL warning on the sign-in page if OAuth2 is enabled (#25947) (#25972)
  * Make pending commit status yellow again (#25935) (#25968)
* BUGFIXES
  * Fix version in rpm repodata/primary.xml.gz (#26009) (#26048)
  * Fix env config parsing for "GITEA____APP_NAME" (#26001) (#26013)
  * ParseScope with owner/repo always sets owner to zero (#25987) (#25989)
  * Fix SSPI auth panic (#25955) (#25969)
  * Avoid creating directories when loading config (#25944) (#25957)
  * Make environment-to-ini work with INSTALL_LOCK=true (#25926) (#25937)
  * Ignore `runs-on` with expressions when warning no matched runners (#25917) (#25933)
  * Avoid opening/closing PRs which are already merged (#25883) (#25903)
* DOCS
  * RPM Registry: Show zypper commands for SUSE based distros as well (#25981) (#26020)
  * Correctly refer to dev tags as nightly in the docker docs (#26004) (#26019)
  * Update path related documents (#25417) (#25982)
* MISC
  * Adding remaining enum for migration repo model type. (#26021) (#26034)
  * Fix the route for pull-request's authors (#26016) (#26018)
  * Fix commit status color on dashboard repolist (#25993) (#25998)
  * Avoid hard-coding height in language dropdown menu (#25986) (#25997)
  * Add shutting down notice (#25920) (#25922)
  * Fix incorrect milestone count when provide a keyword (#25880) (#25904)

## [1.20.0](https://github.com/go-gitea/gitea/releases/tag/v1.20.0) - 2023-07-16

* BREAKING
  * Fix WORK_DIR for docker (root) image (#25738) (#25811)
  * Restrict `[actions].DEFAULT_ACTIONS_URL` to only `github` or `self` (#25581) (#25604)
  * Refactor path & config system (#25330) (#25416)
  * Fix all possible setting error related storages and added some tests (#23911) (#25244)
  * Use a separate admin page to show global stats, remove `actions` stat (#25062)
  * Remove the service worker (#25010)
  * Remove meta tags `theme-color` and `default-theme` (#24960)
  * Use `[git.config]` for reflog cleaning up (#24958)
  * Allow all URL schemes in Markdown links by default (#24805)
  * Redesign Scoped Access Tokens (#24767)
  * Fix team members API endpoint pagination (#24754)
  * Rewrite logger system (#24726)
  * Increase default LFS auth timeout from 20m to 24h (#24628)
  * Rewrite queue (#24505)
  * Remove unused setting `time.FORMAT` (#24430)
  * Refactor `setting.Other` and remove unused `SHOW_FOOTER_BRANDING` (#24270)
  * Correct the access log format (#24085)
  * Reserve ".png" suffix for user/org names (#23992)
  * Prefer native parser for SSH public key parsing (#23798)
  * Editor preview support for external renderers (#23333)
  * Add Gitea Profile Readmes (#23260)
  * Refactor `ctx` in templates (#23105)
* SECURITY
  * Test if container blob is accessible before mounting (#22759) (#25784)
  * Set type="password" on all auth_token fields (#22175)
* FEATURES
  * Add button on diff header to copy file name, misc diff header tweaks (#24986)
  * API endpoint for changing/creating/deleting multiple files (#24887)
  * Support changing git config through `app.ini`, use `diff.algorithm=histogram` by default (#24860)
  * Add up and down arrows to selected lookup repositories (#24727)
  * Add Go package registry (#24687)
  * Add status indicator on main home screen for each repo (#24638)
  * Support for status check pattern (#24633)
  * Implement Cargo HTTP index (#24452)
  * Add Debian package registry (#24426)
  * Add the ability to pin Issues (#24406)
  * Add follow organization and fix the logic of following page (#24345)
  * Allow `webp` images as avatars (#24248)
  * Support upload `outputs` and use `needs` context on Actions (#24230)
  * Allow adding new files to an empty repo (#24164)
  * Make wiki title supports dashes and improve wiki name related features (#24143)
  * Add monospace toggle button to textarea (#24034)
  * Use auto-updating, natively hoverable, localized time elements (#23988)
  * Add ntlm authentication support for mail (#23811)
  * Add CLI command to register runner tokens (#23762)
  * Add Alpine package registry (#23714)
  * Expand/Collapse all changed files (#23639)
  * Add unset default project column (#23531)
  * Add activity feeds API (#23494)
  * Add RPM registry (#23380)
  * Add meilisearch support (#23136)
  * Add API for License templates (#23009)
  * Add admin API email endpoints (#22792)
  * Add user rename endpoint to admin api (#22789)
  * Add API for gitignore templates (#22783)
  * Implement actions artifacts (#22738)
  * Add RSS Feeds for branches and files (#22719)
  * Display when a repo was archived (#22664)
  * Add Swift package registry (#22404)
  * Add CRAN package registry (#22331)
  * Add user webhooks (#21563)
  * Implement systemd-notify protocol (#21151)
  * Implement Issue Config (#20956)
  * Add API to manage issue dependencies (#17935)
* API
  * Use correct response code in push mirror creation response in v1_json.tmpl (#25476) (#25571)
  * Fix `Permission` in API returned repository struct (#25388) (#25441)
  * Add API for Label templates (#24602)
  * Filters for GetAllCommits (#24568)
  * Add ability to specify '--not' from GetAllCommits (#24409)
  * Support uploading file to empty repo by API (#24357)
  * Add absent repounits to create/edit repo API (#23500)
  * Add login name and source id for admin user searching API (#23376)
  * Create a branch directly from commit on the create branch API (#22956)
* ENHANCEMENTS
  * Make `add line comment` buttons focusable (#25894) (#25896)
  * Always pass 6-digit hex color to monaco (#25780) (#25782)
  * Clarify "text-align" CSS helpers, fix clone button padding (#25763) (#25764)
  * Hide `add file` button for pull mirrors (#25748) (#25751)
  * Allow/fix review (approve/reject) of empty PRs (#25690) (#25732)
  * Fix tags header and pretty format numbers (#25624) (#25694)
  * Actions list enhancements (#25601) (#25678)
  * Fix show more for image on diff page (#25672) (#25673)
  * Prevent SVG shrinking (#25652) (#25669)
  * Fix UI misalignment on user setting page (#25629) (#25656)
  * Use css on labels (#25626) (#25636)
  * Read-only checkboxes don't appear and don't entirely act the way one might expect (#25573) (#25602)
  * Redirect to package after version deletion (#25594) (#25599)
  * Reduce table padding globally (#25568) (#25577)
  * Change `Regenerate Secret` button display (#25534) (#25541)
  * Fix rerun icon on action view component (#25531) (#25536)
  * Move some regexp out of functions (#25430) (#25445)
  * Diff page enhancements (#25398) (#25437)
  * Various UI fixes (#25264) (#25431)
  * Fix label list divider (#25312) (#25372)
  * Fix UI on mobile view (#25315) (#25340)
  * When viewing a file, hide the add button (#25320) (#25339)
  * Show if File is Executable (#25287) (#25300)
  * Fix edit OAuth application width (#25262) (#25263)
  * Use flex to align SVG and text (#25163) (#25260)
  * Revert overflow: overlay (revert #21850) (#25231) (#25239)
  * Use inline SVG for built-in OAuth providers (#25171) (#25234)
  * Change access token UI to select dropdowns (#25109) (#25230)
  * Remove hacky patch for "safari emoji glitch fix"  (#25208) (#25211)
  * Minor arc-green color tweaks (#25175) (#25205)
  * Button and color enhancements (#24989) (#25176)
  * Fix mobile navbar and misc cleanups (#25134) (#25169)
  * Modify OAuth login ui and fix display name, iconurl related logic (#25030) (#25161)
  * Improve notification icon and navbar  (#25111) (#25124)
  * Add details summary for vertical menus in settings to allow toggling (#25098)
  * Don't display `select all issues` checkbox when no issues are available (#25086)
  * Use RepositoryList instead of []*Repository (#25074)
  * Add ability to set multiple redirect URIs in OAuth application UI (#25072)
  * Use git command instead of the ini package to remove the `origin` remote (#25066)
  * Remove cancel button from branch protection form (#25063)
  * Show file tree by default (#25052)
  * Add Progressbar to Milestone Page (#25050)
  * Minor UI improvements: logo alignment, auth map editor, auth name display (#25043)
  * Allow for PKCE flow without client secret + add docs (#25033)
  * Refactor INI package (first step) (#25024)
  * Various style fixes (#25008)
  * Fix delete user account modal (#25004)
  * Refactor diffFileInfo / DiffTreeStore (#24998)
  * Add user level action runners (#24995)
  * Rename NotifyPullReviewRequest to NotifyPullRequestReviewRequest (#24988)
  * Add step start time to `ViewStepLog` (#24980)
  * Add dark mode to API Docs (#24971)
  * Display file mode for new file and file mode changes (#24966)
  * Make the 500 page load themes (#24953)
  * Show `bot` label next to username when rendering author link if the user is a bot (#24943)
  * Repo list improvements, fix bold helper classes (#24935)
  * Improve queue and logger context (#24924)
  * Improve RunMode / dev mode (#24886)
  * Improve some Forms (#24878)
  * Add show timestamp/seconds and fullscreen options to action page (#24876)
  * Fix double border and adjust width for user profile page (#24870)
  * Improve Actions CSS (#24864)
  * Fix `@font-face` overrides (#24855)
  * Remove `In your repositories` link in milestones dashboard (#24853)
  * Fix missing yes/no in delete time log modal (#24851)
  * Show new pull request button also on subdirectories and files (#24842)
  * Make environment-to-ini  support loading key value from file (#24832)
  * Support wildcard in email domain allow/block list (#24831)
  * Use `CommentList` instead of `[]*Comment` (#24828)
  * Add RTL rendering support to Markdown (#24816)
  * Rework notifications list (#24812)
  * Mute repo names in dashboard repo list (#24811)
  * Fix max width and margin of comment box on conversation page (#24809)
  * Some refactors for issues stats (#24793)
  * Rework label colors (#24790)
  * Fix OAuth login loading state (#24788)
  * Remove duplicated issues options and some more refactors (#24787)
  * Decouple the different contexts from each other (#24786)
  * Remove background on user dashboard filter bar (#24779)
  * Improve and fix bugs surrounding reactions (#24760)
  * Make the color of zero-contribution-squares in the activity heatmap more subtle (#24758)
  * Fix WEBP image copying (#24743)
  * Rework OAuth login buttons, swap github logo to monocolor (#24740)
  * Consolidate the two review boxes into one (#24738)
  * Unification of registration fields order (#24737)
  * Refactor Pull Mirror and fix out-of-sync bugs (#24732)
  * Improvements for action detail page (#24718)
  * Fix flash of unstyled content in action view page (#24712)
  * Don't filter action runs based on state (#24711)
  * Optimize actions list by removing an unnecessary `git` call (#24710)
  * Support no label/assignee filter and batch clearing labels/assignees (#24707)
  * Add icon support for safari (#24697)
  * Use standard HTTP library to serve files (#24693)
  * Improve button-ghost, remove tertiary button (#24692)
  * Only hide tooltip tippy instances (#24688)
  * Support migrating storage for actions log via command line (#24679)
  * Remove highlight in repo list (#24675)
  * Add markdown preview to Submit Review Textarea (#24672)
  * Update pin and add pin-slash (#24669)
  * Improve empty notifications display (#24668)
  * Support SSH for go get (#24664)
  * Improve avatar uploading / resizing / compressing, remove Fomantic card module (#24653)
  * Only show one tippy at a time (#24648)
  * Notification list enhancements, fix striped tables on dark theme (#24639)
  * Improve queue & process & stacktrace (#24636)
  * Use the type RefName for all the needed places and fix pull mirror sync bugs (#24634)
  * Remove fluid on compare diff page (#24627)
  * Add a tooltip to the job rerun button (#24617)
  * Attach a tooltip to the action status icon (#24614)
  * Make the actions control button look like an actual button (#24611)
  * Remove unnecessary code (#24610)
  * Make repo migration cancelable and fix various bugs (#24605)
  * Improve updating Actions tasks (#24600)
  * Attach a tooltip to the action control button (#24595)
  * Make repository response support HTTP range request (#24592)
  * Improve Gitea's web context, decouple "issue template" code into service package (#24590)
  * Modify luminance calculation and extract related functions into single files (#24586)
  * Simplify template helper functions (#24570)
  * Split "modules/context.go" to separate files (#24569)
  * Add org visibility label to non-organization's dashboard (#24558)
  * Update LDAP filters to include both username and email address (#24547)
  * Review fixes and enhancements (#24526)
  * Display warning when user try to rename default branch (#24512)
  * Fix color for transfer related buttons when having no permission to act (#24510)
  * Rework button coloring, add focus and active colors (#24507)
  * New webhook trigger for receiving Pull Request review requests (#24481)
  * Add goto issue id function (#24479)
  * Fix incorrect webhook time and use relative-time to display it (#24477)
  * RSS icon fixes (#24476)
  * Replace `N/A` with `-` everywhere (#24474)
  * Pass 'not' to commit count (#24473)
  * Enhance stylelint rule config, remove dead CSS (#24472)
  * Remove `font-awesome` and fomantic `icon` module (#24471)
  * Improve "new-menu" (#24465)
  * Remove fomantic breadcrumb module (#24463)
  * Improve template system and panic recovery (#24461)
  * Make Issue/PR/projects more compact, misc CSS tweaks (#24459)
  * Replace remaining fontawesome dropdown icons with SVG (#24455)
  * Remove all direct references to font-awesome (#24448)
  * Move links out of translation (#24446)
  * Add `ui-monospace` and `SF Mono` to `--fonts-monospace` (#24442)
  * Hide 'Mirror Settings' when unneeded, improve hints (#24433)
  * Add "Updated" column for admin repositories list (#24429)
  * Improve issue list filter (#24425)
  * Rework header bar on issue, pull requests and milestone (#24420)
  * Improve template helper (#24417)
  * Make repo size style matches others (commits/branches/tags) (#24408)
  * Support markdown editor for issue template (#24400)
  * Improve commit date in commit graph (#24399)
  * Start cleaning the messy ".ui.left / .ui.right", improve label list page, fix stackable menu (#24393)
  * Merge setting.InitXXX into one function with options (#24389)
  * Move `Rename branch` from repo settings page to the page of branches list (#24380)
  * Improve protected branch setting page (#24379)
  * Display 'Unknown' when runner.version is empty (#24378)
  * Display owner of a runner as a tooltip instead of static text (#24377)
  * Fix incorrect last online time in runner_edit.tmpl (#24376)
  * Fix unclear `IsRepositoryExist` logic (#24374)
  * Add custom helm repo name generated from url (#24363)
  * Replace placeholders in licenses (#24354)
  * Add rerun workflow button and refactor to use SVG octicons (#24350)
  * Fix runner button height (#24338)
  * Restore bold on repolist (#24337)
  * Improve RSS (#24335)
  * Refactor "route" related code, fix Safari cookie bug (#24330)
  * Alert error message if open dependencies are included in the issues that try to batch close (#24329)
  * Add missed column title in runner management page (#24328)
  * Automatically select the org when click create repo from org dashboard (#24325)
  * Modify width of ui container, fine tune css for settings pages and org header (#24315)
  * Fix config list overflow and layout (#24312)
  * Improve some modal action buttons (#24289)
  * Move code from module to service (#24287)
  * Sort users and orgs on explore by recency by default (#24279)
  * Allow using localized absolute date times within phrases with place holders and localize issue due date events (#24275)
  * Show workflow config error on file view also (#24267)
  * Improve template helper functions: string/slice (#24266)
  * Use more specific test methods (#24265)
  * Add `DumpVar` helper function to help debugging templates (#24262)
  * Limit avatar upload to valid image files (#24258)
  * Improve emoji and mention matching (#24255)
  * Change to vertical navbar layout for secondary navbar for repo/user/admin settings (#24246)
  * Refactor config provider (#24245)
  * Improve test logger (#24235)
  * Default show closed actions list if all actions was closed (#24234)
  * Add missing badges in user profile for /projects and /packages (#24232)
  * Add repository counter badge to repository tab (#24205)
  * Move secrets and runners settings to actions settings (#24200)
  * Require at least one unit to be enabled (#24189)
  * Use same action status svg icons on actions list as on action page (#24178)
  * Use secondary pointing menu for tabs on user/organization home page (#24162)
  * Improve Wiki TOC (#24137)
  * Refactor locale number (#24134)
  * Localize activity heatmap (except tooltip) (#24131)
  * Fix duplicate modals when clicking on "remove all" repository button (#24129)
  * Add runner check in repo action page (#24124)
  * Support triggering workflows by wiki related events (#24119)
  * Refactor cookie (#24107)
  * Remove untranslatable `on_date` key (#24106)
  * Refactor delete_modal_actions template and use it for project column related actions (#24097)
  * Improve git log for debugging (#24095)
  * Add option to search for users is active join a team (#24093)
  * Add PDF rendering via PDFObject (#24086)
  * Refactor web route (#24080)
  * Make HTML template functions support context (#24056)
  * Refactor rename user and rename organization (#24052)
  * Localize milestone related time strings (#24051)
  * Expand selected file when clicking file tree (#24041)
  * Add popup to hashed comments/pull requests/issues in file editing/adding preview tab (#24040)
  * Add placeholder and aria attributes to release and wiki edit page (#24031)
  * Add new user types `reserved`, `bot`, and `remote` (#24026)
  * Allow adding SSH keys even if SSH server is disabled (#24025)
  * Use a general approach to access custom/static/builtin assets (#24022)
  * Update github.com/google/go-github to v52 (#24004)
  * Replace tribute with text-expander-element for textarea (#23985)
  * Group template helper functions, remove `Printf`, improve template error messages (#23982)
  * Drop "unrolled/render" package (#23965)
  * Add job.duration in web ui (#23963)
  * Tweak pull request branch delete ui (#23951)
  * Merge template functions "dict/Dict/mergeinto" (#23932)
  * Use a general Eval function for expressions in templates. (#23927)
  * Clean template/helper.go (#23922)
  * Actions: Use default branch as ref when a branch/tag delete occurs (#23910)
  * Add tooltips for MD editor buttons and add `muted` class for buttons (#23896)
  * Improve markdown editor: width, height, preferred (#23895)
  * Make Release Download URLs predictable (#23891)
  * Remove fomantic ".link" selector and styles (#23888)
  * Added close/open button to details page of milestone (#23877)
  * Introduce GitHub markdown editor, keep EasyMDE as fallback (#23876)
  * Introduce GiteaLocaleNumber custom element to handle number localization on pages. (#23861)
  * Make first section on home page full width (#23854)
  * Use different SVG for pending and running actions (#23836)
  * Display image size for multiarch container images (#23821)
  * Improve action log display with control chars (#23820)
  * Fix dropdown direction behavior (#23806)
  * Fix incorrect/Improve error handle in edit user page (#23805)
  * Use clippie module to copy to clipboard (#23801)
  * Make minio package support legacy MD5 checksum (#23768)
  * Add ONLY_SHOW_RELEVANT_REPOS back, fix explore page bug, make code more strict (#23766)
  * Refactor docs (#23752)
  * Fix markup background, improve wiki rendering (#23750)
  * Make label templates have consistent behavior and priority (#23749)
  * Improve LoadUnitConfig to handle invalid or duplicate units (#23736)
  * Append `(comment)` when a link points at a comment rather than the whole issue (#23734)
  * Clean some legacy files and move some build files (#23699)
  * Refactor repo commit list (#23690)
  * Refactor internal API for git commands, use meaningful messages instead of "Internal Server Error" (#23687)
  * Add aria attributes to interactive time tooltips. (#23661)
  * Fix long project name display in issue list and in related dropdown (#23653)
  * Use data-tooltip-content for tippy tooltip (#23649)
  * Fix new issue/pull request btn margin when it is next to sort (#23647)
  * Fine tune more downdrop settings, use SVG for labels, improve Repo Topic Edit form (#23626)
  * Allow new file and edit file preview if it has editable extension (#23624)
  * Replace a few fontawesome icons with svg (#23602)
  * `Publish Review` buttons should indicate why they are disabled (#23598)
  * Convert issue list checkboxes to native (#23596)
  * Set opaque background on markup and images (#23578)
  * Use a general approach to show tooltip, fix temporary tooltip bug (#23574)
  * Improve `<SvgIcon>` to make it output `svg` node and optimize performance (#23570)
  * Enable color for consistency checks diffs (#23563)
  * Fix dropdown icon misalignment when using fomantic icon (#23558)
  * Decouple the issue-template code from comment_tab.tmpl (#23556)
  * Remove `id="comment-form"` dead code, fix tag (#23555)
  * Diff improvements (#23553)
  * Sort Python package descriptors by version to mimic PyPI format (#23550)
  * Use a general approch to improve a11y for all checkboxes and dropdowns. (#23542)
  * Fix long name ui issues and label ui issue (#23541)
  * Return `repository` in npm package metadata endpoint (#23539)
  * Use `project.IconName` instead of repeated unreadable `if-else` chains (#23538)
  * Remove stars in dashboard repo list (#23530)
  * Update mini-css-extract-plugin, remove postcss (#23520)
  * Change `Close` to either `Close issue` or `Close pull request` (#23506)
  * Fix theme-auto loading (#23504)
  * Fix tags sort by creation time (descending) on branch/tag dropdowns (#23491)
  * Display the version of runner in the runner list (#23490)
  * Replace Less with CSS (#23481)
  * Fix `.locale.Tr` function not found in delete modal (#23468)
  * Allow both fullname and username search when `DEFAULT_SHOW_FULL_NAME` is true (#23463)
  * Add project type descriptions in issue badge and improve project icons (#23437)
  * Use context for `RepositoryList.LoadAttributes` (#23435)
  * Refactor branch/tag selector to Vue SFC (#23421)
  * Keep (add if not existing) xmlns attribute for generated SVG images (#23410)
  * Refactor dashboard repo list to Vue SFC (#23405)
  * Add workflow error notification in ui (#23404)
  * Refactor branch/tag selector dropdown (first step) (#23394)
  * Reduce duplicate and useless code in options (#23369)
  * Convert `<div class="button">` to `<button class="button">` (#23337)
  * Add path prefix to ObjectStorage.Iterator (#23332)
  * Improve cache context (#23330)
  * Move pidfile creation from setting to web cmd package (#23285)
  * Fix tags view (#23243)
  * Add commit info in action page (#23210)
  * Support paste treepath when creating a new file or updating the file name (#23209)
  * Allow skipping forks and mirrors from being indexed (#23187)
  * Use context parameter in services/repository (#23186)
  * Hide target selector if tag exists when creating new release (#23171)
  * Improve FindProjects (#23085)
  * Clean Path in Options (#23006)
  * Add margin top to the top of branches (#23002)
  * Remove unnecessary and incorrect `find('.menu').toggle()` (#22987)
  * Improve GetBoards and getDefaultBoard (#22981)
  * Improve squash merge commit author and co-author with private emails (#22977)
  * Add --quiet option to gitea dump (#22969)
  * Add pagination for dashboard and user activity feeds (#22937)
  * Handle files starting with colons in WalkGitLog (#22935)
  * Add "Reviewed by you" filter for pull requests (#22927)
  * Parse external request id from request headers, and print it in access log (#22906)
  * Replace `repo.namedBlob` by `git.TreeEntry`. (#22898)
  * Pull Requests: add button to compare force pushed commits (#22857)
  * Fix pull request update showing too many commits with multiple branches (#22856)
  * Require approval to run actions for fork pull request (#22803)
  * Projects: rename Board to Column in interface and improve consistency (#22767)
  * Add user visibility in dashboard navbar (#22747)
  * Add .livemd as a markdown extension (#22730)
  * Clean up WebAuthn javascript code and remove JQuery code (#22697)
  * Merge message template support for rebase without merge commit (#22669)
  * Show editorconfig warnings when viewing a malformed editorconfig (#21257)
  * Npm packages: set repository link based on the url in package.json (#20379)
* BUGFIXES
  * Add support for different Maven POM encoding (#25873) (#25890)
  * Fix incorrect repo url when changed the case of ownername (#25733) (#25881)
  * Fix empty project displayed in issue sidebar (#25802) (#25854)
  * Show correct SSL Mode on "install page" (#25818) (#25838)
  * Fix the error message when the token is incorrect (#25701) (#25836)
  * Fix incorrect oldest sort in project list (#25806) (#25835)
  * For API attachments, use API URL (#25639) (#25814)
  * Avoid amending the Rebase and Fast-forward merge if there is no message template (#25779) (#25809)
  * Make "install page" respect environment config (#25648) (#25799)
  * Fix activity type match in `matchPullRequestEvent` (#25746) (#25796)
  * Fix notification list bugs (#25781) (#25787)
  * Revert package access change from #23879 (#25707) (#25785)
  * Check `ctx.Written()` for `GetActionIssue` (#25698) (#25711)
  * Fix position of org follow button (#25688) (#25692)
  * Fix the nil pointer when assigning issues to projects (#25665) (#25677)
  * Log the real reason when authentication fails (but don't show the user) (#25414) (#25660)
  * Fix bug when change user name (#25637) (#25646)
  * Make "cancel" buttons have proper type in modal forms (#25618) (#25641)
  * Use AfterCommitId to get commit for Viewed functionality (#25529) (#25612)
  * Fix bug of branches API with tests(#25578) (#25579)
  * Fix content holes in Actions task logs file (#25560) (#25566)
  * Fix bugs related to notification endpoints (#25548) (#25562)
  * Add Adopt repository event and handler (#25497) (#25518)
  * Improve wiki sidebar and TOC (#25460) (#25477)
  * Make "dismiss" content shown correctly (#25461) (#25465)
  * Change default email domain for LDAP users (#25425) (#25434)
  * Fix missing commit message body when the message has leading newlines (#25418) (#25422)
  * Fix LDAP sync when Username Attribute is empty (#25278) (#25379)
  * Fetch all git data for embedding correct version in docker image (#25361) (#25373)
  * Fix incorrect actions ref_name (#25358) (#25367)
  * Write absolute AppDataPath to app.ini when installing (#25331) (#25347)
  * Fix incorrect config argument position for builtin SSH server (#25341)
  * Remove EasyMDE focus outline on text (#25328) (#25332)
  * Fix displayed RPM repo url (#25310) (#25313)
  * Fix index generation parallelly failure (#25235) (#25269)
  * Fix panic when migrating a repo from GitHub with issues (#25246) (#25247)
  * Fix task list checkbox toggle to work with YAML front matter (#25184) (#25227)
  * Fix compatible for webhook ref type (#25195) (#25223)
  * Hide limited users if viewed by anonymous ghost (#25214) (#25220)
  * Do not overwrite the log mode when installing (#25203) (#25209)
  * Fix fullscreen for action  (#25200) (#25207)
  * Add `WithPullRequest` for `actionsNotifier` (#25144) (#25197)
  * Fix `MilestoneIDs` when querying issues (#25125) (#25141)
  * Fix incorrect git ignore rule and add missing license files (#25135) (#25138)
  * Remove incorrect element ID on "post-install" page (#25104) (#25129)
  * Fix 500 error caused by notifications without an issue such as repo transfers (#25101)
  * Help to recover from corrupted levelqueue (#24912)
  * Fix 500 error when select `No assignee` filter in issue list page (#24854)
  * Add validations.required check to dropdown field (#24849)
  * Reenable creating default webhooks. (#24626)
  * Fix incorrect user visibility (#24557)
  * Fix commits pushed with deploy keys not shown in dashboard (#24521)
  * Check length of `LogIndexes` in case it is outdated (#24516)
  * Fix incorrect CurrentUser check for docker rootless (#24441)
  * Fix some mistakes when using `ignSignIn` (#24415)
  * Fix incorrect CORS response in Http Git handler (#24303)
  * Fix issue attachment handling (#24202)
  * Make mention autocomplete case insensitive in new markdown editor (#24190)
  * Use 1.18's aria role for dropdown menus (#24144)
  * Fix internal sever error when visiting a PR that bound to the deleted team (#24127)
  * Add migration to fix external unit access mode of owner/admin team (#24117)
  * Show friendly 500 error page to users and developers (#24110)
  * Fix meilisearch not working when searching across multiple repositories (#24109)
  * Fix math and mermaid rendering bugs (#24049)
  * Remove "inverted" class on creating new label and cancel buttons (#24030)
  * Allow repo admins too to delete the repo (#23940)
  * Disable editing tags (#23883)
  * Fix review conversation reply (#23846)
  * Fix incorrect CORS failure detection logic (#23844)
  * Remove incorrect HTML self close tag (#23748)
  * Fix incorrect `toggle` buttons (#23676)
  * Introduce path Clean/Join helper functions (#23495)
  * Fix missed migration in #22235 (#23482)
  * Do not store user projects as organization projects (#23353)
  * Fix incorrect display for comment context menu (#23343)
  * Make Ctrl+Enter submit a pending comment (starting review) instead of submitting a single comment (#23245)
  * Fix submit button won't refresh in New Repository Fork page (#22994)
  * Remove stars when repo goes private (#19904)
* TESTING
  * Add unit test for repository collaboration (#25640) (#25658)
  * Add missing test case and fix typo in tests (#24915)
  * Kd/fix redis unit test (#24650)
  * Add owner team permission check test (#24096)
  * Test renderReadmeFile (#23185)
  * Add default owner team to privated_org and limited_org in unit test (#23109)
  * Speed up HasUserStopwatch & GetActiveStopwatch (#23051)
  * Remove all package data after tests (#22984)
* TRANSLATION
  * Backport locales to v1.20 (#25899)
  * Translate untranslated string in issues list (#25759) (#25761)
  * Remove broken translations (#25737)
  * Show correct naming for 1 comment (#25704) (#25712)
  * Add Chinese documentations for Actions (#24902)
  * Change `valid_until` translation to `valid_until_date` and include placeholder for the date (#24563)
  * Change `add_on` translation to `added_on` and include placeholder for the date (#24562)
  * Change `join_on` translation to `joined_on` and include placeholder for the date (#24550)
  * Use double quotes consistently in en-US (#24141)
  * Clarify Gitea/Crowdin locale behaviors, add tests for LocaleStore, fix some strings with semicolons (#23819)
  * Update localization.zh-cn.md (#23448)
  * Fix grammar in error message (#23273)
* BUILD
  * Correct permissions for `.ssh` and `authorized_keys` (#25721) (#25730)
  * Upgrade snap to node 20 (#24990)
  * Use Go 1.20 for next release (#24859)
  * Ignore build for docs only (#24761)
  * Update cron-translations.yml (#24708)
  * Update to Alpine 3.18 (#24700)
  * Check latest version on CI (#24556)
  * Upgrade to Node 20 on CI, enable actions cancellation (#24524)
  * Mark `/templates/swagger/v1_json.tmpl` as generated file (#24306)
  * Enable forbidigo linter (#24278)
  * Introduce lint-md and compliance-docs pipeline (#24021)
  * Add eslint-plugin-custom-elements (#23991)
  * Update eslints for Vue 3 (#23935)
  * Improve backport-locales.go (#23807)
  * Don't run unnecessary steps when only docs changed (#23103)
* DOCS
  * Docs: rootless docker ssh's default port is 2222 (#25771) (#25772)
  * Add documentation about supported workflow trigger events (#25582) (#25589)
  * Document creating an API key from the CLI (#25504)
  * Use the new download domain replace the old (#25405) (#25409)
  * Add Exoscale to installation on cloud provider docs (#25342) (#25346)
  * Improve some documents: release version, logging, NFS lock (#25202) (#25204)
  * Change branch name from master to main in some documents' links (#25126) (#25140)
  * Introduce how to configure cache when starting a Runner with Docker (#25077)
  * Docs: remove an extraneous whitespace (#24949)
  * Update Asciidoc markup example with safe defaults (#24920)
  * Fix \<empty\> in administration/config-cheat-sheet.en-us.md (#24905)
  * Rename docs packages title from xxx Packages Repository -> xxx Package Registry (#24895)
  * Replace `drone exec` to `act_runner exec` in test README.md (#24791)
  * Update packages overview page (#24730)
  * Docs for creating a user to run Gitea on Fedora/RHEL/CentOS (#24725)
  * Move actions as usage's subdirectory and update comparison zh-cn version (#24719)
  * Document `redis-cluster` explicitly in config (#24717)
  * Improve reverse-proxy document and fix nginx config bug (#24616)
  * Fix broken `README` link (#24546)
  * Update `CONTRIBUTING.md` (#24492)
  * Docs for Gitea Actions (#24405)
  * Zh-cn support on doc pages (#24166)
  * Fix https setup doc zh-cn (#24015)
  * Adjust some documentations titles (#23941)
  * More specific and unique feed name for NuGet install command template. (#23889)
  * Clarify that Gitea requires JavaScript (#23677)
  * Rename develop -> development, contribute -> contributing, administer -> administration (#23662)
  * Update PR documentation (#23620)
  * Add package registry architecture overview (#23445)
  * Add gradle samples in maven doc of packages (#23374)
  * Improve the frontend guideline (#23298)
  * Add document for `webcomponents` (#23261)
  * Add Gitea Community Code of Conduct (#23188)
  * Avoid Hugo from adding quote to actions url (#23097)
  * Improve reverse proxies documentation (#23068)
  * Docs: HTTPS configuration for zh-cn (#23039)
* MISC
  * Do not prepare oauth2 config if it is not enabled, do not write config in some sub-commands (#25567) (#25576)
  * Align language menu icon and fit the footer area (#25556) (#25563)
  * Fix sub-command log level (#25537) (#25553)
  * Fix admin-dl-horizontal (#25512) (#25535)
  * Fix input `line-height` cutting off `g` (#25334) (#25533)
  * Clarify the reason why the user can't add a new email if there is a pending activation (#25509) (#25514)
  * Improve loadprojects for issue list (#25468) (#25493)
  * Use "utf8mb4" for MySQL by default (#25432)
  * Show outdated comments in files changed tab (#24936) (#25428)
  * Avoid polluting config file when "save" (#25395) (#25406)
  * Fix blank dir message when uploading files from web editor (#25391) (#25400)
  * Fix issue filters on mobile view (#25368) (#25371)
  * Avoid polluting the config (#25345) (#25354)
  * Fix action runner last online state on edit page (#25337)
  * Remove fomantic inverted variations (#25286) (#25289)
  * Show OAuth2 errors to end users (#25261) (#25271)
  * Fix profile render when the README.md size is larger than 1024 bytes (#25270)
  * Fix strange UI behavior of cancelling dismiss review modal (#25172)
  * Update js dependencies (#25137) (#25151)
  * Fix swagger documentation for multiple files API endpoint (#25110)
  * Fix link to customizing-gitea (#25056)
  * Add Link to Stars and Forks Page to Repo List (#24931)
  * Improve confusable character string (#24911)
  * Fix install page context, make the install page tests really test (#24858)
  * Add gitea manager reload-templates command (#24843)
  * Create pull request for base after editing file, if not enabled on fork (#24841)
  * Fix video width overflow in markdown, and other changes to match img (#24834)
  * Support Copy Link for video attachments (#24833)
  * Improve accessibility when (re-)viewing files (#24817)
  * Update JS dependencies (#24815)
  * Bump vm2 from 3.9.17 to 3.9.18 (#24742)
  * Add IsErrRepoFilesAlreadyExist check when fork repo (#24678)
  * Fix typo in act-runner file (#24652)
  * Do not send "registration success email" for external auth sources (#24632)
  * Filter get single commit (#24613)
  * Make diff view full width again (#24598)
  * Add permission check for moving issue action in project view page (#24589)
  * Revert "Prevent a user with a different email from accepting the team invite" (#24531)
  * Temporarily disable PATs until next release (#24527)
  * Clean up polluted styles and remove dead CSS code (#24497)
  * Faster git.GetDivergingCommits (#24482)
  * Fix test delivery button in repo webhook settings page (#24478)
  * Use globally shared HTMLRender (#24436)
  * Changelog 1.19.2 (#24365) (#24403)
  * Fix layouts of admin table / adapt repo / email test (#24370)
  * Gitea Actions add `base_ref`, `head_ref`, `api_url`, `ref_type` fields (#24356)
  * Fix 404 error when leaving the last private org team (#24322)
  * Improve External Wiki in Repo Header (#24304)
  * Updated upgrade script that is informing user that Gitea service has to be running in order to upgrade it (#24260)
  * Add run status in action view page (#24223)
  * Update JS dependencies (#24218)
  * Bump vm2 from 3.9.15 to 3.9.16 (#24089)
  * Update github.com/google/go-github to v51 (#23946)
  * Show visibility status of email in own profile (#23900)
  * Refactor authors dropdown (send get request from frontend to avoid long wait time) (#23890)
  * Add self to maintainers (#23644)
  * Upgrade to npm lockfile v3 and explicitly set it (#23561)
  * Improve indices for `action` table (#23532)
  * Update JS dependencies, Require Node.js 16 (#23528)
  * Add init file for Ubuntu (#23362)
  * Update go.mod dependencies (#23126)
  * Use minio/sha256-simd for accelerated SHA256 (#23052)
  * More detailed branch delete message (#22696)
  * Add tooltips to `Hide comment type` settings where necessary (#21306)

## [1.19.4](https://github.com/go-gitea/gitea/releases/tag/v1.19.4) - 2023-07-04

* SECURITY
  * Fix open redirect check for more cases (#25143) (#25155)
* API
  * Return `404` in the API if the requested webhooks were not found (#24823) (#24830)
  * Fix `organization` field being `null` in `GET /api/v1/teams/{id}` (#24694) (#24696)
* ENHANCEMENTS
  * Set `--font-weight-bold` to 600 (#24840)
  * Make mailer SMTP check have timed context (#24751) (#24759)
  * Do not select line numbers when selecting text from the action run logs (#24594) (#24596)
* BUGFIXES
  * Fix bug when change user name (#25637) (#25645)
  * Fix task list checkbox toggle to work with YAML front matter (#25184) (#25236)
  * Hide limited users if viewed by anonymous ghost (#25214) (#25224)
  * Add `WithPullRequest` for `actionsNotifier` (#25144) (#25196)
  * Fix parallelly generating index failure with Mysql (#24567) (#25081)
  * GitLab migration: Sanitize response for reaction list (#25054) (#25059)
  * Fix users cannot visit issue attachment bug (#25019) (#25027)
  * Fix missing reference prefix of commits when sync mirror repository (#24994)
  * Only validate changed columns when update user (#24867) (#24903)
  * Make DeleteIssue use correct context (#24885)
  * Fix topics deleted via API not being deleted in org page (#24825) (#24829)
  * Fix Actions being enabled accidentally (#24802) (#24810)
  * Fix missed table name on iterate lfs meta objects (#24768) (#24774)
  * Fix safari cookie session bug (#24772)
  * Respect original content when creating secrets (#24745) (#24746)
  * Fix Pull Mirror out-of-sync bugs (#24732) (#24733)
  * Fix run list broken when trigger user deleted (#24706) (#24709)
  * Fix issues list page multiple selection update milestones (#24660) (#24663)
  * Fix: release page for empty or non-existing target (#24659)
  * Fix close org projects (#24588) (#24591)
  * Refresh the references of the closed PR when reopening (#24231) (#24587)
  * Fix the permission of team's `Actions` unit issue (#24536) (#24545)
  * Bump go.etcd.io/bbolt and blevesearch deps (#23062) (#24519)
  * Fix new wiki page mirror (#24518)
  * Match unqualified references when syncing pulls as well (#23070)
* DOCS
  * Change branch name from master to main in some documents' links (#25126) (#25139)
  * Remove unnecessary content on docs (#24976) (#25001)
  * Unify doc links to use paths relative to doc folder (#24979) (#25000)
  * Fix docs documenting invalid `@every` for `OLDER_THAN` cron settings (#24695) (#24698)
* MISC
  * Merge different languages for language stats (#24900) (#24921)
  * Hiding Secrets options when Actions feature is disabled (#24792)
  * Improve decryption failure message (#24573) (#24575)
  * Makefile: Use portable !, not GNUish -not, with find(1). (#24565) (#24572)

## [1.19.3](https://github.com/go-gitea/gitea/releases/tag/v1.19.3) - 2023-05-03

* SECURITY
  * Use golang 1.20.4 to fix CVE-2023-24539, CVE-2023-24540, and CVE-2023-29400
* ENHANCEMENTS
  * Enable whitespace rendering on selection in Monaco (#24444) (#24485)
  * Improve milestone filter on issues page (#22423) (#24440)
* BUGFIXES
  * Fix api error message if fork exists (#24487) (#24493)
  * Fix user-cards format (#24428) (#24431)
  * Fix incorrect CurrentUser check for docker rootless (#24435)
  * Getting the tag list does not require being signed in (#24413) (#24416)

## [1.19.2](https://github.com/go-gitea/gitea/releases/tag/v1.19.2) - 2023-04-26

* SECURITY
  * Require repo scope for PATs for private repos and basic authentication (#24362) (#24364)
  * Only delete secrets belonging to its owner (#24284) (#24286)
* API
  * Fix typo in API route (#24310) (#24332)
  * Fix access token issue on some public endpoints (#24194) (#24259)
* ENHANCEMENTS
  * Fix broken clone script on an empty archived repo (#24339) (#24348)
  * Fix Monaco IOS keyboard button (#24341) (#24347)
  * Don't set meta `theme-color` by default (#24340) (#24346)
  * Wrap too long push mirror addresses (#21120) (#24334)
  * Add --font-weight-bold and set previous bold to 601 (#24307) (#24331)
  * Unify nightly naming across binaries and docker images (#24116) (#24308)
  * Fix footer display (#24251) (#24269)
  * Fix label color, fix divider in dropdown (#24215) (#24244)
  * Vertical widths of containers removed (#24184) (#24211)
  * Use correct locale key for forks page (#24172) (#24175)
  * Sort repo topic labels by name (#24123) (#24153)
  * Highlight selected file in the PR file tree (#23947) (#24126)
* BUGFIXES
  * Fix auth check bug (#24382) (#24387)
  * Add tags list for repos whose release setting is disabled (#23465) (#24369)
  * Fix wrong error info in RepoRefForAPI (#24344) (#24351)
  * Fix no edit/close/delete button in org repo project view page (#24349)
  * Respect the REGISTER_MANUAL_CONFIRM setting when registering via OIDC (#24035) (#24333)
  * Remove org users who belong to no teams (#24247) (#24313)
  * Fix bug when deleting wiki with no code write permission (#24274) (#24295)
  * Handle canceled workflow as a warning instead of a fail (#24282) (#24292)
  * Load reviewer for comments when dismissing a review (#24281) (#24288)
  * Show commit history for closed/merged PRs (#24238) (#24261)
  * Fix owner team access mode value in team_unit table (#24224)
  * Fix issue attachment handling (#24202) (#24221)
  * Fix incorrect CORS default values (#24206) (#24217)
  * Fix template error in pull request with deleted head repo (#24192) (#24216)
  * Don't list root repository on compare page if pulls not allowed (#24183) (#24210)
  * Fix calReleaseNumCommitsBehind (#24148) (#24197)
  * Fix Org edit page bugs: renaming detection, maxlength (#24161) (#24171)
  * Update redis library to support redis v7 (#24114) (#24156)
  * Use 1.18's aria role for dropdown menus (#24144) (#24155)
  * Fix 2-dot direct compare to use the right base commit (#24133) (#24150)
  * Fix incorrect server error content in RunnersList (#24118) (#24121)
  * Fix mismatch between hook events and github event types (#24048) (#24091)
* BUILD
  * Support converting varchar to nvarchar for mssql database (#24105) (#24168)

## [1.19.1](https://github.com/go-gitea/gitea/releases/tag/v1.19.1) - 2023-04-12

* BREAKING
  * Rename actions unit to `repo.actions` and add docs for it (#23733) (#23881)
* ENHANCEMENTS
  * Add card type to org/user level project on creation, edit and view (#24043) (#24066)
  * Refactor commit status for Actions jobs (#23786) (#24060)
  * Show errors for KaTeX and mermaid on the preview tab (#24009) (#24019)
  * Show protected branch rule names again (#23907) (#24018)
  * Adjust sticky PR header to cover background (#23956) (#23999)
  * Discolor pull request tab labels (#23950) (#23987)
  * Treat PRs with agit flow as fork PRs when triggering actions. (#23884) (#23967)
  * Left-align review comments (#23937)
  * Fix image border-radius (#23886) (#23930)
  * Scroll collapsed file into view (#23702) (#23929)
  * Fix code view (diff) broken layout (#23096) (#23918)
  * Org pages style fixes (#23901) (#23914)
  * Fix user profile description rendering (#23882) (#23902)
  * Fix review box viewport overflow issue (#23800) (#23898)
  * Prefill input values in OAuth settings as intended (#23829) (#23871)
  * CSS color tweaks (#23828) (#23842)
  * Fix incorrect visibility dropdown list in add/edit user page (#23804) (#23833)
  * Add CSS rules for basic colored labels (#23774) (#23777)
  * Add creation time in tag list page (#23693) (#23773)
  * Fix br display for packages curls (#23737) (#23764)
  * Fix issue due date edit toggle bug (#23723) (#23758)
  * Improve commit graph page UI alignment (#23751) (#23754)
  * Use GitHub Actions compatible globbing for `branches`, `tag`, `path` filter (#22804) (#23740)
  * Redirect to project again after editing it (#23326) (#23739)
  * Remove row clicking from notification table (#22695) (#23706)
  * Remove conflicting CSS rules on notifications, improve notifications table (#23565) (#23621)
  * Fix diff tree height and adjust target file style (#23616)
* BUGFIXES
  * Improve error logging for LFS (#24072) (#24082)
  * Fix custom mailer template on Windows platform (#24081)
  * Update the value of `diffEnd` when clicking the `Show More` button in the DiffFileTree (#24069) (#24078)
  * Make label templates have consistent behavior and priority (#23749)
  * Fix accidental overwriting of LDAP team memberships (#24050) (#24065)
  * Fix branch protection priority (#24045) (#24061)
  * Use actions job link as commit status URL instead of run link (#24023) (#24032)
  * Add actions support to package auth verification (#23729) (#24028)
  * Fix protected branch for API (#24013) (#24027)
  * Do not escape space between PyPI repository URL and package name… (#23981) (#24008)
  * Fix redirect bug when creating issue from a project (#23971) (#23997)
  * Set `ref` to fully-formed of the tag when trigger event is `release` (#23944) (#23989)
  * Use Get/Set instead of Rename when regenerating session ID (#23975) (#23983)
  * Ensure RSS icon is present on all repo tabs (#23904) (#23973)
  * Remove `Repository.getFilesChanged` to fix Actions `paths` and `paths-ignore` filter (#23920) (#23969)
  * Delete deleted release attachments immediately from storage (#23913) (#23958)
  * Use ghost user if package creator does not exist (#23822) (#23915)
  * User/Org Feed render description as per web (#23887) (#23906)
  * Fix `cases.Title` crash for concurrency (#23885) (#23903)
  * Convert .Source.SkipVerify to $cfg.SkipVerify (#23839) (#23899)
  * Support "." char as user name for User/Orgs in RSS/ATOM/GPG/KEYS path ... (#23874) (#23878)
  * Fix JS error when changing PR's target branch (#23862) (#23864)
  * Fix 500 error if there is a name conflict when editing authentication source (#23832) (#23852)
  * Fix closed PR also triggers Webhooks and actions (#23782) (#23834)
  * Fix checks for `needs` in Actions (#23789) (#23831)
  * Fix "Updating branch by merge" bug in "update_branch_by_merge.tmpl" (#23790) (#23825)
  * Fix cancel button in the page of project edit not work (#23655) (#23813)
  * Don't apply the group filter when listing LDAP group membership if it is empty (#23745) (#23788)
  * Fix profile page email display, respect settings (#23747) (#23756)
  * Fix project card preview select and template select (#23684) (#23731)
  * Check LFS/Packages settings in dump and doctor command (#23631) (#23730)
  * Add git dashes separator to some "log" and "diff" commands (#23606) (#23720)
  * Create commit status when event is `pull_request_sync` (#23683) (#23691)
  * Fix incorrect `HookEventType` of pull request review comments (#23650) (#23678)
  * Fix incorrect `show-modal` and `show-panel` class (#23660) (#23663)
  * Improve workflow event triggers (#23613) (#23648)
  * Introduce path Clean/Join helper functions, partially backport&refactor (#23495) (#23607)
  * Fix pagination on `/notifications/watching` (#23564) (#23603)
  * Fix submodule is nil panic (#23588) (#23601)
  * Polyfill the window.customElements (#23592) (#23595)
  * Avoid too long names for actions (#23162) (#23190)
* TRANSLATION
  * Backport locales (with manual fixes) (#23808, #23634, #24083)
* BUILD
  * Hardcode the path to docker images (#23955) (#23968)
* DOCS
  * Update documentation to explain which projects allow Gitea to host static pages (#23993) (#24058)
  * Merge `push to create`, `open PR from push`, and `push options` docs articles into one (#23744) (#23959)
  * Fix code blocks in the cheat sheet (#23664) (#23669)
* MISC
  * Do not crash when parsing an invalid workflow file (#23972) (#23976)
  * Remove assertion debug code for show/hide refactoring (#23576) (#23868)
  * Add ONLY_SHOW_RELEVANT_REPOS back, fix explore page bug, make code more strict (#23766) (#23791)
  * Make minio package support legacy MD5 checksum (#23768) (#23770)
  * Improve template error reporting (#23396) (#23600)

## [1.19.0](https://github.com/go-gitea/gitea/releases/tag/v1.19.0) - 2023-03-19

* BREAKING
  * Add loading yaml label template files (#22976) (#23232)
  * Make issue and code search support camel case for Bleve (#22829)
  * Repositories: by default disable all units except code and pulls on forks (#22541)
  * Support template for merge message description (#22248)
  * Remove ONLY_SHOW_RELEVANT_REPOS setting (#21962)
  * Implement actions (#21937)
  * Remove deprecated DSA host key from Docker Container (#21522)
  * Improve valid user name check (#20136)
* SECURITY
  * Return 404 instead of 403 if user can not access the repo (#23155) (#23158)
  * Support scoped access tokens (#20908)
* FEATURES
  * Add support for commit cross references (#22645)
  * Scoped labels (#22585)
  * Add Chef package registry (#22554)
  * Support asciicast files as new markup (#22448)
  * cgo cross-compile for freebsd (#22397)
  * Add cron method to gc LFS MetaObjects (#22385)
  * Add new captcha: cloudflare turnstile (#22369)
  * Enable `@<user>`- completion popup on the release description textarea (#22359)
  * make /{username}.png redirect to user/org avatar (#22356)
  * Add Conda package registry (#22262)
  * Support org/user level projects (#22235)
  * Add Mermaid copy button (#22225)
  * Add user secrets (#22191)
  * Secrets storage with SecretKey encrypted (#22142)
  * Preview images for Issue cards in Project Board view (#22112)
  * Add support for incoming emails (#22056)
  * Add Cargo package registry (#21888)
  * Add option to prohibit fork if user reached maximum limit of repositories (#21848)
  * Add attention blocks within quote blocks for `Note` and `Warning` (#21711)
  * Add Feed for Releases and Tags (#21696)
  * Add package registry cleanup rules (#21658)
  * Add "Copy" button to file view of raw text (#21629)
  * Allow disable sitemap (#21617)
  * Add package registry quota limits (#21584)
  * Map OIDC groups to Orgs/Teams (#21441)
  * Keep languages defined in .gitattributes (#21403)
  * Add Webhook authorization header (#20926)
  * Supports wildcard protected branch (#20825)
  * Copy citation file content, in APA and BibTex format, on repo home page (#19999)
* API
  * Match api migration behavior to web behavior (#23552) (#23573)
  * Purge API comment (#23451) (#23452)
  * User creation API: allow custom "created" timestamps (#22549)
  * Add `updated_at` field to PullReview API object (#21812)
  * Add API management for issue/pull and comment attachments (#21783)
  * Add API endpoint to get latest release (#21267)
  * Support system hook API (#14537)
* ENHANCEMENTS
  * Add `.patch` to `attachment.ALLOWED_TYPES` (#23580) (#23582)
  * Fix sticky header in diff view (#23554) (#23568)
  * Refactor merge/update git command calls (#23366) (#23544)
  * Fix review comment context menu clipped bug (#23523) (#23543)
  * Imrove scroll behavior to hash issuecomment(scroll position, auto expand if file is folded, and on refreshing) (#23513) (#23540)
  * Increase horizontal page padding (#23507) (#23537)
  * Use octicon-verified for gpg signatures (#23529) (#23536)
  * Make time tooltips interactive (#23526) (#23527)
  * Replace Less with CSS (#23508)
  * Fix 'View File' button in code search (#23478) (#23483)
  * Convert GitHub event on actions and fix some pull_request events. (#23037) (#23471)
  * Support reflogs (#22451) (#23438)
  * Fix actions frontend bugs (pagination, long name alignment) and small simplify (#23370) (#23436)
  * Scoped label display and documentation tweaks (#23430) (#23433)
  * Add missing tabs to org projects page (#22705) (#23412)
  * Fix and move "Use this template" button (#23398) (#23408)
  * Handle OpenID discovery URL errors a little nicer when creating/editing sources (#23397) (#23403)
  * Rename `canWriteUnit` to `canWriteProjects` (#23386) (#23399)
  * Refactor and tidy-up the merge/update branch code (#22568) (#23365)
  * Refactor `setting.Database.UseXXX` to methods (#23354) (#23356)
  * Fix incorrect project links and use symlink icon for org-wide projects (#23325) (#23336)
  * Fix PR view misalignment caused by long name file (#23321) (#23335)
  * Scoped labels: don't require holding alt key to remove (#23303) (#23331)
  * Add context when rendering labels or emojis (#23281) (#23319)
  * Change interactiveBorder to fix popup preview  (#23169) (#23314)
  * Scoped labels: set aria-disabled on muted Exclusive option for a11y (#23306) (#23311)
  * update to mermaid v10 (#23178) (#23299)
  * Fix code wrap for unbroken lines (#23268) (#23293)
  * Use async await to fix empty quote reply at first time (#23168) (#23256)
  * Fix switched citation format (#23250) (#23253)
  * Allow `<video>` in MarkDown (#22892) (#23236)
  * Order pull request conflict checking by recently updated, for each push (#23220) (#23225)
  * Fix Fomantic UI's `touchstart` fastclick, always use `click` for click events (#23065) (#23195)
  * Add word-break to sidebar-item-link (#23146) (#23180)
  * Add InsecureSkipVerify to Minio Client for Storage (#23166) (#23177)
  * Fix height for sticky head on large screen on PR page (#23111) (#23123)
  * Change style to improve whitespaces trimming inside inline markdown code (#23093) (#23120)
  * Avoid warning for system setting when start up (#23054) (#23116)
  * Add accessibility to the menu on the navbar (#23059) (#23095)
  * Improve accessibility for issue comments (#22612) (#23083)
  * Remove delete button for review comment (#23036)
  * Remove dashes between organization member avatars on hover (#23034)
  * Use `gt-relative` class instead of the ambiguous `gt-pr` class  (#23008)
  * handle deprecated settings (#22992)
  * Add scopes to API to create token and display them (#22989)
  * Improve PR Review Box UI (#22986)
  * Improve issues.LoadProject (#22982)
  * Add all units to the units permission list in org team members sidebar (#22971)
  * Rename `GetUnits` to `LoadUnits` (#22970)
  * Rename `repo.GetOwner` to `repo.LoadOwner` (#22967)
  * Rename "People" to "Members" in organization page and use a better icon (#22960)
  * Fix avatar misalignment (#22955)
  * Sort issues and pulls by recently updated in user and organization home (#22925)
  * Add `title` to PR file tree items (#22918)
  * First step to refactor the `.hide` to `.gt-hidden` (#22916)
  * Add tooltip to issue reference (#22913)
  * Always show the `command line instructions` button even if there are conflicts (#22909)
  * Fix dark-colored description text in arc-green theme (#22908)
  * Remove Fomantic-UI's `.hidden` CSS class for menu elements (#22895)
  * Move helpers to be prefixed with `gt-` (#22879)
  * Move `IsReadmeFile*` from `modules/markup/` to `modules/util` (#22877)
  * Highlight focused diff file (#22870)
  * Add some headings to repo views (#22869)
  * Fix milestone title font problem (#22863)
  * Pull Requests: setting to allow edits by maintainers by default, tweak UI (#22862)
  * Introduce customized HTML elements, fix incorrect AppUrl usages in templates (#22861)
  * Add `/$count` endpoints for NuGet v2 (#22855)
  * Remove Fomantic-UI's `.hidden` CSS class for checkbox elements (#22851)
  * Fix notification and stopwatch empty states (#22845)
  * Always go full width in PR view (#22844)
  * Improve AppUrl/ROOT_URL checking (#22836)
  * Fix style of actions rerun button (#22835)
  * Fix more HTMLURL in templates (#22831)
  * Fix inconsistent Filter Project name in issue list (#22827)
  * include build info in Prometheus metrics (#22819)
  * Make clone URL use current page's host (#22808)
  * Refactor legacy strange git operations (#22756)
  * Improve error report when user passes a private key (#22726)
  * set user dashboard org visibility to basic (#22706)
  * Fix diff UI for unexpandable items (#22700)
  * Remove 'primary' class from tab counter labels (#22687)
  * Add more events details supports for actions (#22680)
  * Refactor git command package to improve security and maintainability (#22678)
  * Use relative url in actions view (#22675)
  * set user visibility class to basic (#22674)
  * Add repository setting to enable/disable releases unit (#22671)
  * Remove label color from global issue filters (#22660)
  * Fix poor alignment of organization description on organization home page (#22656)
  * Small refactor for loading PRs (#22652)
  * Allow setting access token scope by CLI (#22648)
  * Improve accessibility of navigation bar and footer (#22635)
  * Fixes accessibility behavior of Watching, Staring and Fork buttons (#22634)
  * Fixes accessibility of empty repository commit status (#22632)
  * Pull request yaml template support for including commit body in a field (#22629)
  * Show migration validation error (#22619)
  * set org visibility class to basic in header (#22605)
  * Fix cache-control header clearing comment text when editing issue (#22604)
  * Add ARIA support for Fomantic UI checkboxes (#22599)
  * Add templates to customize text when creating and migrating repositories (#22597)
  * Allow setting `redirect_to` cookie on OAuth login (#22594)
  * Improve checkbox accessibility a bit by adding the title attribute (#22593)
  * Allow issue templates to not render title (#22589)
  * Webhooks: for issue close/reopen action, add commit ID that caused it (#22583)
  * Fix missing title and filter in issue sidebar project menu (#22557)
  * Issues: support setting issue template field values with query (#22545)
  * Issues: add Project filter to issues list and search (#22544)
  * Pull Requests: add color to approved/reject icon in pull requests list (#22543)
  * Mute all links in issue timeline (#22533)
  * Dropzone: Add "Copy link" button for new uploads (#22517)
  * Support importing comment types (#22510)
  * Load asciicast css async (#22502)
  * Move delete user to service (#22478)
  * Change use of Walk to WalkDir to improve disk performance (#22462)
  * Add reply hint to mail text (#22459)
  * fix wrong theme class when logged out if default theme is changed (#22408)
  * Refactor the setting to make unit test easier (#22405)
  * Improve utils of slices (#22379)
  * Use context parameter in models/git (#22367)
  * Always reuse transaction (#22362)
  * Fix unstable emoji sort (#22346)
  * Add context cache as a request level cache (#22294)
  * Reminder for no more logs to console (#22282)
  * Support estimated count with multiple schemas (#22276)
  * Move `convert` package to services (#22264)
  * Use dynamic package type list (#22263)
  * Hide file borders on sticky diff box (#22217)
  * Improve notification and stopwatch styles (#22169)
  * Fixed Project view .board-column height for tall screens. (#22108)
  * Use multi reader instead to concat strings (#22099)
  * Use git command instead of exec.Cmd in blame (#22098)
  * Fix autofilled text visibility in dark mode (#22088)
  * Rename almost all Ctx functions (#22071)
  * Rename actions to operations on UI (#22067)
  * refactor bind functions based on generics (#22055)
  * Support disabling database auto migration (#22053)
  * remove duplicated read file code (#22042)
  * Use link in UI which returned a relative url but not html_url which contains an absolute url (#21986)
  * Skip initing disabled storages (#21985)
  * Add doctor command for full GC of LFS (#21978)
  * Util type to parse ref name (#21969)
  * Replace fmt.Sprintf with hex.EncodeToString (#21960)
  * Use random bytes to generate access token (#21959)
  * Add index for access_token (#21908)
  * Move all remaining colors into CSS variables (#21903)
  * Webhook list enhancements (#21893)
  * Embed Matrix icon as SVG (#21890)
  * Remove useless "Cancel" buttons (#21872)
  * fix(web): keep the pages of the navigation in the center (#21867)
  * fix(web): reduce page jitter on browsers that support overlay scrollbar (#21850)
  * Improvements for Content Copy (#21842)
  * Tweak katex options (#21828)
  * Show syntax lexer name in file view/blame (#21814)
  * Remove `href="javascript:;"` in "save topics (Done)" button (#21813)
  * Render number of commits in repo page in a user friendly way (#21786)
  * Adjust clone timeout error to suggest increasing timeout (#21769)
  * Update message of reach_limit_of_creation (#21757)
  * Allow detect whether it's in a database transaction for a context.Context (#21756)
  * Add configuration for CORS allowed headers (#21747)
  * Move svg html render to modules/svg (#21716)
  * Release and Tag List tweaks (#21712)
  * Remove template previewer (#21701)
  * Clean up formatting on install page (#21668)
  * Configure update checker on installation page (#21655)
  * Merge db.Iterate and IterateObjects (#21641)
  * Add option to enable CAPTCHA validation for login (#21638)
  * Allow disable RSS/Atom feed (#21622)
  * Use CSS color-scheme instead of invert (#21616)
  * Localize time units on activity heatmap (#21570)
  * Fix UI column width, button overflow Fomantic's grid (#21559)
  * feat: notify doers of a merge when automerging (#21553)
  * Split migrations folder (#21549)
  * feat: add button to quickly clear merge message (#21548)
  * Add `context.Context` to more methods (#21546)
  * Add index for hook_task table (#21545)
  * Allow disable code tab (#20805)
* BUGFIXES
  * Fix template error when reference Project (#23584)
  * Fix dropdown icon misalignment when using fomantic icon (#23558) (#23577)
  * Fix diff detail buttons wrapping, use tippy for review box (#23271) (#23546)
  * Handle missing `README` in create repos API (#23387) (#23510)
  * Disable sending email after push a commit to a closed PR (#23462) (#23492)
  * Fix aria.js bugs: incorrect role element problem, mobile focus problem, tippy problem (#23450) (#23486)
  * Fix due date being wrong on issue list (#23475) (#23477)
  * Remove wrongly added column on migration test fixtures (#23456) (#23470)
  * Make branches list page operations remember current page (#23420) (#23460)
  * Fix missing commit status in PR which from forked repo (#23351) (#23453)
  * Show edit/close/delete button on organization wide repositories (#23388) (#23429)
  * Preserve file size when creating attachments (#23406) (#23426)
  * Fix broken Chroma CSS styles (#23174) (#23402)
  * Fix incorrect NotFound conditions in org/projects.go (#23384) (#23395)
  * Set `X-Gitea-Debug` header once (#23361) (#23381)
  * Pass context to avatar for projects view (#23359) (#23378)
  * Fix panic when getting notes by ref (#23372) (#23377)
  * Do not recognize text files as audio (#23355) (#23368)
  * Fix adding of empty class name (#23352) (#23360)
  * Fix various ImageDiff/SVG bugs (#23312) (#23358)
  * Fix incorrect display for comment context menu (#23343) (#23344)
  * Remove unnecessary space on link (#23334) (#23340)
  * Fix incorrect redirect link of delete org project (#23327) (#23339)
  * Fix cannot reopen after pushing commits to a closed PR (#23189) (#23324)
  * Fix broken code editor diff preview (#23307) (#23320)
  * Support sanitising the URL by removing extra slashes in the URL (#21333) (#23300)
  * Avoid panic caused by broken payload when creating commit status (#23216) (#23294)
  * Fill head commit to in payload when notifying push commits for mirroring (#23215) (#23292)
  * Fix various bugs for "install" page (#23194) (#23286)
  * Fix GetFilesChangedBetween if the file name may be escaped (#23272) (#23279)
  * Revert relative links to absolute links in mail templates (#23267) (#23269)
  * Fix commit retrieval by tag (#21804) (#23266)
  * Use correct README link to render the README (#23152) (#23264)
  * Close the temp file when dumping database to make the temp file can be deleted on Windows (#23249) (#23251)
  * Use the correct selector to hide the checkmark of selected labels on clear (#23224) (#23228)
  * Fix incorrect checkbox behaviors in the dashboard repolist's filter (#23147) (#23205)
  * Properly flush unique queues on startup (#23154) (#23201)
  * Pass `--global` when calling `git config --get`, for consistency with `git config --set` (#23157) (#23199)
  * Make `gitea serv` respect git binary home (#23138) (#23197)
  * Change button text for commenting and closing an issue at the same time (#23135) (#23182)
  * Fix DBConsistency checks on MSSQL (#23132) (#23134)
  * Show empty repos in Admin Repository Management page (#23114) (#23130)
  * Redirect to the commit page after applying patch (#23056) (#23127)
  * Fix nil context in RenderMarkdownToHtml (#23092) (#23108)
  * Make issue meta dropdown support Enter, confirm before reloading (#23014) (#23102)
  * Fix SyncOnCommit always return false in API of push_mirrors (#23088) (#23100)
  * Fix commit name in Apply Patch page (#23086) (#23099)
  * Fix some more hidden problems (#23074) (#23075)
  * Bump golang.org/x/net from 0.4.0 to 0.7.0 (#22980)
  * Get rules by id when editing branch protection rule (#22932)
  * Fix panic when call api (/repos/{owner}/{repo}/pulls/{index}/files) (#22921)
  * Increase Content field size of gpg_import_key to MEDIUMTEXT (#22897)
  * Fix hidden commit status on multiple checks (#22889)
  * Fix update by rebase being wrongly disabled by protected base branch (#22825)
  * Make issue title edit buttons focusable and fix incorrect ajax requests (#22807)
  * Fix rerun button of Actions (#22798)
  * remove update language in ProfilePost (#22748)
  * Do not overwrite empty DefaultBranch (#22708)
  * Fix ref to trigger Actions (#22679)
  * Fix time to NotifyPullRequestSynchronized (#22650)
  * Show all projects, not just repo projects and open/closed projects  (#22640)
  * Project links should use parent link methods (#22587)
  * Fix group filter for ldap source sync (#22506)
  * Check quota limits for container uploads (#22450)
  * Fix halfCommitter and WithTx (#22366)
  * Attempt to fix TestExportUserGPGKeys (#22159)
  * Fix heatmap first color being unused (#22157)
  * Fix scroll over mermaid frame (#21925)
  * Move migration test fixtures to the correct directories (#21901)
  * fix(web): add `alt` for logo in home page (#21887)
  * Fix webhook attachment text is not set in review comment (#21763)
  * Alter package_version.metadata_json to LONGTEXT (#21667)
  * Ensure that Webhook tasks are not double delivered (#21558)
* TESTING
  * Make CI use a dummy password hasher for all tests (#22983)
  * Disable test for incoming email (#22686)
  * Move fuzz tests into tests/fuzz (#22376)
  * Test views of LFS files (#22196)
  * Specify ID in `TestAPITeam` (#22192)
  * verify nodeinfo response by schema  (#22137)
  * Skip GitHub migration tests if the API token is undefined (#21824)
  * Add a simple test for external renderer (#20033)
* TRANSLATION
  * Use "Title Case" for text "Reference in new issue" (#22936)
* BUILD
  * Wrap unless-check in docker manifests (#23079) (#23081)
  * Adjust manifest to prevent tagging latest on rcs (#22811)
  * update to build with go1.20 (#22732)
  * Add Bash and Zsh completion scripts (#22646)
  * Add Contributed backport command (#22643)
  * Remove deprecated packages & staticcheck fixes (#22012)
  * Update to Alpine 3.17 (#21904)
  * Fix webpack license warning (#21815)
* DOCS
  * Update documentation for the new YAML label file format  (#23020) (#23341)
  * Update hacking-on-gitea-zh_cn documentation (#23315) (#23323)
  * Add basic documentation for labels, including scoped labels (#23304) (#23309)
  * Re-add accidentally removed `hacking-on-gitea.zh-cn.md` (#23297) (#23305)
  * Fix secrets overview page missing from docs sidebar (#23143) (#23145)
  * Add some guidelines for refactoring (#22880)
  * Explain that the no-access team unit does not affect public repositories (#22661)
  * Fix incorrect Redis URL snippets in the example app.ini (#22573)
  * docs: add swagger.json file location to FAQ (#22489)
  * Update index.de-de.md (#22363)
  * Update Gmail mailer configuration (#22291)
  * Add missed reverse proxy authentication documentation (#22250)
  * Add plural definitions for German translations (#21802)
  * Attempt clarify AppWorkPath etc. (#21656)
  * Add some documentation to packages (#21648)
* MISC
  * Use `<nav>` instead of `<div>` in the global navbar (#23125) (#23533)
  * Do not create commit graph for temporary repos (#23219) (#23229)
  * Update button is shown when a Pull Request is marked WIP - Issue #21740 (#22683)
  * Add main landmark to templates and adjust titles (#22670)
  * Fix error on account activation with wrong passwd (#22609)
  * Update JS dependencies (#22538)
  * Display unreferenced packages total size in package admin panel (#22498)
  * Mobile fix for Project view: Add delay to Sortable.js on mobile, to ensure scrolling is possible. (#22152)
  * Update chroma to v2.4.0 (#22000)
  * Hide collapse icon in diff with no lines (#21094)

## [1.18.5](https://github.com/go-gitea/gitea/releases/tag/v1.18.5) - 2023-02-21

* ENHANCEMENTS
  * Hide 2FA status from other members in organization members list (#22999) (#23023)
* BUGFIXES
  * Add force_merge to merge request and fix checking mergable (#23010) (#23032)
  * Use `--message=%s` for git commit message (#23028) (#23029)
  * Render access log template as text instead of HTML (#23013) (#23025)
  * Fix the Manually Merged form (#23015) (#23017)
  * Use beforeCommit instead of baseCommit (#22949) (#22996)
  * Display attachments of review comment when comment content is blank (#23035) (#23046)
  * Return empty url for submodule tree entries (#23043) (#23048)

## [1.18.4](https://github.com/go-gitea/gitea/releases/tag/v1.18.4) - 2023-02-20

* SECURITY
  * Provide the ability to set password hash algorithm parameters (#22942) (#22943)
  * Add command to bulk set must-change-password (#22823) (#22928)
* ENHANCEMENTS
  * Use import of OCI structs (#22765) (#22805)
  * Fix color of tertiary button on dark theme (#22739) (#22744)
  * Link issue and pull requests status change in UI notifications directly to their event in the timelined view. (#22627) (#22642)
* BUGFIXES
  * Notify on container image create (#22806) (#22965)
  * Fix blame view missing lines (#22826) (#22929)
  * Fix incorrect role labels for migrated issues and comments (#22914) (#22923)
  * Fix PR file tree folders no longer collapsing (#22864) (#22872)
  * Escape filename when assemble URL (#22850) (#22871)
  * Fix isAllowed of escapeStreamer (#22814) (#22837)
  * Load issue before accessing index in merge message (#22822) (#22830)
  * Improve trace logging for pulls and processes (#22633) (#22812)
  * Fix restore repo bug, clarify the problem of ForeignIndex (#22776) (#22794)
  * Add default user visibility to cli command "admin user create" (#22750) (#22760)
  * Escape path for the file list (#22741) (#22757)
  * Fix bugs with WebAuthn preventing sign in and registration. (#22651) (#22721)
  * Add missing close bracket in imagediff (#22710) (#22712)
  * Move code comments to a standalone file and fix the bug when adding a reply to an outdated review appears to not post(#20821) (#22707)
  * Fix line spacing for plaintext previews (#22699) (#22701)
  * Fix wrong hint when deleting a branch successfully from pull request UI (#22673) (#22698)
  * Fix README TOC links (#22577) (#22677)
  * Fix missing message in git hook when pull requests disabled on fork (#22625) (#22658)
  * Improve checkIfPRContentChanged (#22611) (#22644)
  * Prevent duplicate labels when importing more than 99 (#22591) (#22598)
  * Don't return duplicated users who can create org repo (#22560) (#22562)
* BUILD
  * Upgrade golangcilint to v1.51.0 (#22764)
* MISC
  * Use proxy for pull mirror (#22771) (#22772)
  * Use `--index-url` in PyPi description (#22620) (#22636)

## [1.18.3](https://github.com/go-gitea/gitea/releases/tag/v1.18.3) - 2023-01-23

* SECURITY
  * Prevent multiple `To` recipients (#22566) (#22569)
* BUGFIXES
  * Truncate commit summary on repo files table. (#22551) (#22552)
  * Mute all links in issue timeline (#22534)

## [1.18.2](https://github.com/go-gitea/gitea/releases/tag/v1.18.2) - 2023-01-19

* BUGFIXES
  * Fix issue not auto-closing when it includes a reference to a branch (#22514) (#22521)
  * Fix invalid issue branch reference if not specified in template (#22513) (#22520)
  * Fix 500 error viewing pull request when fork has pull requests disabled (#22512) (#22515)
  * Reliable selection of admin user (#22509) (#22511)
  * Set disable_gravatar/enable_federated_avatar when offline mode is true (#22479) (#22496)
* BUILD
  * cgo cross-compile for freebsd (#22397) (#22519)

## [1.18.1](https://github.com/go-gitea/gitea/releases/tag/v1.18.1) - 2023-01-17

* API
  * Add `sync_on_commit` option for push mirrors api (#22271) (#22292)
* BUGFIXES
  * Update `github.com/zeripath/zapx/v15` (#22485)
  * Fix pull request API field `closed_at` always being `null` (#22482) (#22483)
  * Fix container blob mount (#22226) (#22476)
  * Fix error when calculating repository size (#22392) (#22474)
  * Fix Operator does not exist bug on explore page with ONLY_SHOW_RELEVANT_REPOS (#22454) (#22472)
  * Fix environments for KaTeX and error reporting (#22453) (#22473)
  * Remove the netgo tag for Windows build (#22467) (#22468)
  * Fix migration from GitBucket (#22477) (#22465)
  * Prevent panic on looking at api "git" endpoints for empty repos (#22457) (#22458)
  * Fix PR status layout on mobile (#21547) (#22441)
  * Fix wechatwork webhook sends empty content in PR review (#21762) (#22440)
  * Remove duplicate "Actions" label in mobile view (#21974) (#22439)
  * Fix leaving organization bug on user settings -> orgs (#21983) (#22438)
  * Fixed colour transparency regex matching in project board sorting (#22092) (#22437)
  * Correctly handle select on multiple channels in Queues (#22146) (#22428)
  * Prepend refs/heads/ to issue template refs (#20461) (#22427)
  * Restore function to "Show more" buttons (#22399) (#22426)
  * Continue GCing other repos on error in one repo (#22422) (#22425)
  * Allow HOST has no port (#22280) (#22409)
  * Fix omit avatar_url in discord payload when empty (#22393) (#22394)
  * Don't display stop watch top bar icon when disabled and hidden when click other place (#22374) (#22387)
  * Don't lookup mail server when using sendmail (#22300) (#22383)
  * Fix gravatar disable bug (#22337)
  * Fix update settings table on install (#22326) (#22327)
  * Fix sitemap (#22272) (#22320)
  * Fix code search title translation (#22285) (#22316)
  * Fix due date rendering the wrong date in issue (#22302) (#22306)
  * Fix get system setting bug when enabled redis cache (#22298)
  * Fix bug of DisableGravatar default value (#22297)
  * Fix key signature error page (#22229) (#22230)
* TESTING
  * Remove test session cache to reduce possible concurrent problem (#22199) (#22429)
* MISC
  * Restore previous official review when an official review is deleted (#22449) (#22460)
  * Log STDERR of external renderer when it fails (#22442) (#22444)

## [1.18.0](https://github.com/go-gitea/gitea/releases/tag/v1.18.0) - 2022-12-29

* SECURITY
  * Remove ReverseProxy authentication from the API (#22219) (#22251)
  * Support Go Vulnerability Management (#21139)
  * Forbid HTML string tooltips (#20935)
* BREAKING
  * Rework mailer settings (#18982)
  * Remove U2F support (#20141)
  * Refactor `i18n` to `locale` (#20153)
  * Enable contenthash in filename for dynamic assets (#20813)
* FEATURES
  * Add color previews in markdown (#21474)
  * Allow package version sorting (#21453)
  * Add support for Chocolatey/NuGet v2 API (#21393)
  * Add API endpoint to get changed files of a PR (#21177)
  * Add filetree on left of diff view (#21012)
  * Support Issue forms and PR forms (#20987)
  * Add support for Vagrant packages (#20930)
  * Add support for `npm unpublish` (#20688)
  * Add badge capabilities to users (#20607)
  * Add issue filter for Author (#20578)
  * Add KaTeX rendering to Markdown. (#20571)
  * Add support for Pub packages (#20560)
  * Support localized README (#20508)
  * Add support mCaptcha as captcha provider (#20458)
  * Add team member invite by email (#20307)
  * Added email notification option to receive all own messages (#20179)
  * Switch Unicode Escaping to a VSCode-like system (#19990)
  * Add user/organization code search (#19977)
  * Only show relevant repositories on explore page (#19361)
  * User keypairs and HTTP signatures for ActivityPub federation using go-ap (#19133)
  * Add sitemap support (#18407)
  * Allow creation of OAuth2 applications for orgs (#18084)
  * Add system setting table with cache and also add cache supports for user setting (#18058)
  * Add pages to view watched repos and subscribed issues/PRs (#17156)
  * Support Proxy protocol (#12527)
  * Implement sync push mirror on commit (#19411)
* API
  * Allow empty assignees on pull request edit (#22150) (#22214)
  * Make external issue tracker regexp configurable via API (#21338)
  * Add name field for org api (#21270)
  * Show teams with no members if user is admin (#21204)
  * Add latest commit's SHA to content response (#20398)
  * Add allow_rebase_update, default_delete_branch_after_merge to repository api response (#20079)
  * Add new endpoints for push mirrors management (#19841)
* ENHANCEMENTS
  * Add setting to disable the git apply step in test patch (#22130) (#22170)
  * Multiple improvements for comment edit diff (#21990) (#22007)
  * Fix button in branch list, avoid unexpected page jump before restore branch actually done (#21562) (#21928)
  * Fix flex layout for repo list icons (#21896) (#21920)
  * Fix vertical align of committer avatar rendered by email address (#21884) (#21918)
  * Fix setting HTTP headers after write (#21833) (#21877)
  * Color and Style enhancements (#21784, #21799) (#21868)
  * Ignore line anchor links with leading zeroes (#21728) (#21776)
  * Quick fixes monaco-editor error: "vs.editor.nullLanguage" (#21734) (#21738)
  * Use CSS color-scheme instead of invert (#21616) (#21623)
  * Respect user's locale when rendering the date range in the repo activity page (#21410)
  * Change `commits-table` column width (#21564)
  * Refactor git command arguments and make all arguments to be safe to be used (#21535)
  * CSS color enhancements (#21534)
  * Add link to user profile in markdown mention only if user exists (#21533, #21554)
  * Add option to skip index dirs (#21501)
  * Diff file tree tweaks (#21446)
  * Localize all timestamps (#21440)
  * Add `code` highlighting in issue titles (#21432)
  * Use Name instead of DisplayName in LFS Lock (#21415)
  * Consolidate more CSS colors into variables (#21402)
  * Redirect to new repository owner (#21398)
  * Use ISO date format instead of hard-coded English date format for date range in repo activity page (#21396)
  * Use weighted algorithm for string matching when finding files in repo (#21370)
  * Show private data in feeds (#21369)
  * Refactor parseTreeEntries, speed up tree list (#21368)
  * Add GET and DELETE endpoints for Docker blob uploads (#21367)
  * Add nicer error handling on template compile errors (#21350)
  * Add `stat` to `ToCommit` function for speed (#21337)
  * Support instance-wide OAuth2 applications (#21335)
  * Record OAuth client type at registration (#21316)
  * Add new CSS variables --color-accent and --color-small-accent (#21305)
  * Improve error descriptions for unauthorized_client (#21292)
  * Case-insensitive "find files in repo" (#21269)
  * Consolidate more CSS rules, fix inline code on arc-green (#21260)
  * Log real ip of requests from ssh (#21216)
  * Save files in local storage as group readable (#21198)
  * Enable fluid page layout on medium size viewports (#21178)
  * File header tweaks (#21175)
  * Added missing headers on user packages page (#21172)
  * Display image digest for container packages (#21170)
  * Skip dirty check for team forms (#21154)
  * Keep path when creating a new branch (#21153)
  * Remove fomantic image module (#21145)
  * Make labels clickable in the comments section. (#21137)
  * Sort branches and tags by date descending (#21136)
  * Better repo API unit checks (#21130)
  * Improve commit status icons (#21124)
  * Limit length of repo description and repo url input fields (#21119)
  * Show .editorconfig errors in frontend (#21088)
  * Allow poster to choose reviewers (#21084)
  * Remove black labels and CSS cleanup (#21003)
  * Make e-mail sanity check more precise (#20991)
  * Use native inputs in whitespace dropdown (#20980)
  * Enhance package date display (#20928)
  * Display total blob size of a package version (#20927)
  * Show language name on hover (#20923)
  * Show instructions for all generic package files (#20917)
  * Refactor AssertExistsAndLoadBean to use generics (#20797)
  * Move the official website link at the footer of gitea (#20777)
  * Add support for full name in reverse proxy auth (#20776)
  * Remove useless JS operation for relative time tooltips (#20756)
  * Replace some icons with SVG (#20741)
  * Change commit status icons to SVG (#20736)
  * Improve single repo action for issue and pull requests (#20730)
  * Allow multiple files in generic packages (#20661)
  * Add option to create new issue from /issues page (#20650)
  * Background color of private list-items updated (#20630)
  * Added search input field to issue filter (#20623)
  * Increase default item listing size `ISSUE_PAGING_NUM` to 20 (#20547)
  * Modify milestone search keywords to be case insensitive again (#20513)
  * Show hint to link package to repo when viewing empty repo package list (#20504)
  * Add Tar ZSTD support (#20493)
  * Make code review checkboxes clickable (#20481)
  * Add "X-Gitea-Object-Type" header for GET `/raw/` & `/media/` API (#20438)
  * Display project in issue list (#20434)
  * Prepend commit message to template content when opening a new PR (#20429)
  * Replace fomantic popup module with tippy.js (#20428)
  * Allow to specify colors for text in markup (#20363)
  * Allow access to the Public Organization Member lists with minimal permissions (#20330)
  * Use default values when provided values are empty (#20318)
  * Vertical align navbar avatar at middle (#20302)
  * Delete cancel button in repo creation page (#21381)
  * Include login_name in adminCreateUser response (#20283)
  * fix: icon margin in user/settings/repos (#20281)
  * Remove blue text on migrate page (#20273)
  * Modify milestone search keywords to be case insensitive (#20266)
  * Move some files into models' sub packages (#20262)
  * Add tooltip to repo icons in explore page (#20241)
  * Remove deprecated licenses (#20222)
  * Webhook for Wiki changes (#20219)
  * Share HTML template renderers and create a watcher framework (#20218)
  * Allow enable LDAP source and disable user sync via CLI (#20206)
  * Adds a checkbox to select all issues/PRs (#20177)
  * Refactor `i18n` to `locale` (#20153)
  * Disable status checks in template if none found (#20088)
  * Allow manager logging to set SQL (#20064)
  * Add order by for assignee no sort issue (#20053)
  * Take a stab at porting existing components to Vue3 (#20044)
  * Add doctor command to write commit-graphs (#20007)
  * Add support for authentication based on reverse proxy email (#19949)
  * Enable spellcheck for EasyMDE, use contenteditable mode (#19776)
  * Allow specifying SECRET_KEY_URI, similar to INTERNAL_TOKEN_URI (#19663)
  * Rework mailer settings (#18982)
  * Add option to purge users (#18064)
  * Add author search input (#21246)
  * Make rss/atom identifier globally unique (#21550)
* BUGFIXES
  * Auth interface return error when verify failure (#22119) (#22259)
  * Use complete SHA to create and query commit status (#22244) (#22257)
  * Update bleve and zapx to fix unaligned atomic (#22031) (#22218)
  * Prevent panic in doctor command when running default checks (#21791) (#21807)
  * Load GitRepo in API before deleting issue (#21720) (#21796)
  * Ignore line anchor links with leading zeroes (#21728) (#21776)
  * Set last login when activating account (#21731) (#21755)
  * Fix UI language switching bug (#21597) (#21749)
  * Quick fixes monaco-editor error: "vs.editor.nullLanguage" (#21734) (#21738)
  * Allow local package identifiers for PyPI packages (#21690) (#21727)
  * Deal with markdown template without metadata (#21639) (#21654)
  * Fix opaque background on mermaid diagrams (#21642) (#21652)
  * Fix repository adoption on Windows (#21646) (#21650)
  * Sync git hooks when config file path changed (#21619) (#21626)
  * Fix 500 on PR files API (#21602) (#21607)
  * Fix `Timestamp.IsZero` (#21593) (#21603)
  * Fix viewing user subscriptions (#21482)
  * Fix mermaid-related bugs (#21431)
  * Fix branch dropdown shifting on page load (#21428)
  * Fix default theme-auto selector when nologin (#21346)
  * Fix and improve incorrect error messages (#21342)
  * Fix formatted link for PR review notifications to matrix (#21319)
  * Center-aligning content of WebAuthN page (#21127)
  * Remove follow from commits by file (#20765)
  * Fix commit status popup (#20737)
  * Fix init mail render logic (#20704)
  * Use correct page size for link header pagination (#20546)
  * Preserve unix socket file (#20499)
  * Use tippy.js for context popup (#20393)
  * Add missing parameter for error in log message (#20144)
  * Do not allow organisation owners add themselves as collaborator (#20043)
  * Rework file highlight rendering and fix yaml copy-paste (#19967)
  * Improve code diff highlight, fix incorrect rendered diff result (#19958)
* TESTING
  * Improve OAuth integration tests (#21390)
  * Add playwright tests (#20123)
* BUILD
  * Switch to building with go1.19 (#20695)
  * Update JS dependencies, adjust eslint (#20659)
  * Add more linters to improve code readability (#19989)

## [1.17.4](https://github.com/go-gitea/gitea/releases/tag/v1.17.4) - 2022-12-21

* SECURITY
  * Do not allow Ghost access to limited visible user/org (#21849) (#21875)
  * Fix package access for admins and inactive users (#21580) (#21592)
* ENHANCEMENTS
  * Fix button in branch list, avoid unexpected page jump before restore branch actually done (#21562) (#21927)
  * Fix vertical align of committer avatar rendered by email address (#21884) (#21919)
  * Fix setting HTTP headers after write (#21833) (#21874)
  * Ignore line anchor links with leading zeroes (#21728) (#21777)
  * Enable Monaco automaticLayout (#21516)
* BUGFIXES
  * Do not list active repositories as unadopted (#22034) (#22167)
  * Correctly handle moved files in apply patch (#22118) (#22136)
  * Fix condition for is_internal (#22095) (#22131)
  * Fix permission check on issue/pull lock (#22114)
  * Fix sorting admin user list by last login (#22081) (#22106)
  * Workaround for container registry push/pull errors (#21862) (#22069)
  * Fix issue/PR numbers (#22037) (#22045)
  * Handle empty author names (#21902) (#22028)
  * Fix ListBranches to handle empty case (#21921) (#22025)
  * Fix enabling partial clones on 1.17 (#21809)
  * Prevent panic in doctor command when running default checks (#21791) (#21808)
  * Upgrade golang.org/x/crypto (#21792) (#21794)
  * Init git module before database migration (#21764) (#21766)
  * Set last login when activating account (#21731) (#21754)
  * Add HEAD fix to gitea doctor (#21352) (#21751)
  * Fix UI language switching bug (#21597) (#21748)
  * Remove semver compatible flag and change pypi to an array of test cases (#21708) (#21729)
  * Allow local package identifiers for PyPI packages (#21690) (#21726)
  * Fix repository adoption on Windows (#21646) (#21651)
  * Sync git hooks when config file path changed (#21619) (#21625)
  * Added check for disabled Packages (#21540) (#21614)
  * Fix `Timestamp.IsZero` (#21593) (#21604)
  * Fix issues count bug (#21600)
  * Support binary deploy in npm packages (#21589)
  * Update milestone counters when issue is deleted (#21459) (#21586)
  * SessionUser protection against nil pointer dereference (#21581)
  * Case-insensitive NuGet symbol file GUID (#21409) (#21575)
  * Suppress `ExternalLoginUserNotExist` error (#21504) (#21572)
  * Prevent Authorization header for presigned LFS urls (#21531) (#21569)
  * Update binding to fix bugs (#21560)
  * Fix generating compare link (#21519) (#21530)
  * Ignore error when retrieving changed PR review files (#21487) (#21524)
  * Fix incorrect notification commit url (#21479) (#21483)
  * Display total commit count in hook message (#21400) (#21481)
  * Enforce grouped NuGet search results (#21442) (#21480)
  * Return 404 when user is not found on avatar (#21476) (#21477)
  * Normalize NuGet package version on upload (#22186) (#22201)
* MISC
  * Check for zero time instant in TimeStamp.IsZero() (#22171) (#22173)
  * Fix warn in database structs sync (#22111)
  * Allow for resolution of NPM registry paths that match upstream (#21568) (#21723)

## [1.17.3](https://github.com/go-gitea/gitea/releases/tag/v1.17.3) - 2022-10-15

* SECURITY
  * Sanitize and Escape refs in git backend (#21464) (#21463)
  * Bump `golang.org/x/text` (#21412) (#21413)
  * Update bluemonday (#21281) (#21287)
* ENHANCEMENTS
  * Fix empty container layer history and UI (#21251) (#21278)
  * Use en-US as fallback when using other default language (#21200) (#21256)
  * Make the vscode clone link respect transport protocol (#20557) (#21128)
* BUGFIXES
  * Do DB update after merge in hammer context (#21401) (#21416)
  * Add Num{Issues,Pulls} stats checks (#21404) (#21414)
  * Stop logging CheckPath returns error: context canceled (#21064) (#21405)
  * Parse OAuth Authorization header when request omits client secret (#21351) (#21374)
  * Ignore port for loopback redirect URIs (#21293) (#21373)
  * Set SemverCompatible to false for Conan packages (#21275) (#21366)
  * Tag list should include draft releases with existing tags (#21263) (#21365)
  * Fix linked account translation (#21331) (#21334)
  * Make NuGet service index publicly accessible (#21242) (#21277)
  * Foreign ID conflicts if ID is 0 for each item (#21271) (#21272)
  * Use absolute links in feeds (#21229) (#21265)
  * Prevent invalid behavior for file reviewing when loading more files (#21230) (#21234)
  * Respect `REQUIRE_SIGNIN_VIEW` for packages (#20873) (#21232)
  * Treat git object mode 40755 as directory (#21195) (#21218)
  * Allow uppercase ASCII alphabet in PyPI package names (#21095) (#21217)
  * Fix limited user cannot view himself's profile (#21212)
  * Fix template bug of admin monitor (#21209)
  * Fix reaction of issues (#21185) (#21196)
  * Fix CSV diff for added/deleted files (#21189) (#21193)
  * Fix pagination limit parameter problem (#21111)
* TESTING
  * Fix missing m.Run() in TestMain (#21341)
* BUILD
  * Use Go 1.19 fmt for Gitea 1.17, sync emoji data (#21239)

## [1.17.2](https://github.com/go-gitea/gitea/releases/tag/v1.17.2) - 2022-09-06

* SECURITY
  * Double check CloneURL is acceptable (#20869) (#20892)
  * Add more checks in migration code (#21011) (#21050)
* ENHANCEMENTS
  * Fix hard-coded timeout and error panic in API archive download endpoint (#20925) (#21051)
  * Improve arc-green code theme (#21039) (#21042)
  * Enable contenthash in filename for dynamic assets (#20813) (#20932)
  * Don't open new page for ext wiki on same repository (#20725) (#20910)
  * Disable doctor logging on panic (#20847) (#20898)
  * Remove calls to load Mirrors in user.Dashboard (#20855) (#20897)
  * Update codemirror to 5.65.8 (#20875)
  * Rework repo buttons (#20602, #20718) (#20719)
* BUGFIXES
  * Ensure delete user deletes all comments (#21067) (#21068)
  * Delete unreferenced packages when deleting a package version (#20977) (#21060)
  * Redirect if user does not exist on admin pages (#20981) (#21059)
  * Set uploadpack.allowFilter etc on gitea serv to enable partial clones with ssh (#20902) (#21058)
  * Fix 500 on time in timeline API (#21052) (#21057)
  * Fill the specified ref in webhook test payload (#20961) (#21055)
  * Add another index for Action table on postgres (#21033) (#21054)
  * Fix broken insecureskipverify handling in redis connection uris (#20967) (#21053)
  * Add Dev, Peer and Optional dependencies to npm PackageMetadataVersion (#21017) (#21044)
  * Do not add links to Posters or Assignees with ID < 0 (#20577) (#21037)
  * Fix modified due date message (#20388) (#21032)
  * Fix missed sort bug (#21006)
  * Fix input.value attr for RequiredClaimName/Value (#20946) (#21001)
  * Change review buttons to icons to make space for text (#20934) (#20978)
  * Fix download archiver of a commit (#20962) (#20971)
  * Return 404 NotFound if requested attachment does not exist (#20886) (#20941)
  * Set no-tags in git fetch on compare (#20893) (#20936)
  * Allow multiple metadata files for Maven packages (#20674) (#20916)
  * Increase Content field size of gpg_key and public_key to MEDIUMTEXT (#20896) (#20911)
  * Fix mirror address setting not working (#20850) (#20904)
  * Fix push mirror address backend get error Address cause setting page display error (#20593) (#20901)
  * Fix panic when an invalid oauth2 name is passed (#20820) (#20900)
  * In PushMirrorsIterate and MirrorsIterate if limit is negative do not set it (#20837) (#20899)
  * Ensure that graceful start-up is informed of unused SSH listener (#20877) (#20888)
  * Pad GPG Key ID with preceding zeroes (#20878) (#20885)
  * Fix SQL Query for `SearchTeam` (#20844) (#20872)
  * Fix the mode of custom dir to 0700 in docker-rootless (#20861) (#20867)
  * Fix UI mis-align for PR commit history (#20845) (#20859)

## [1.17.1](https://github.com/go-gitea/gitea/releases/tag/v1.17.1) - 2022-08-17

* SECURITY
  * Correctly escape within tribute.js (#20831) (#20832)
* ENHANCEMENTS
  * Add support for NuGet API keys (#20721) (#20734)
  * Display project in issue list (#20583)
  * Add disable download source configuration (#20548) (#20579)
  * Add username check to doctor (#20140) (#20671)
  * Enable Wire 2 for Internal SSH Server (#20616) (#20617)
* BUGFIXES
  * Use the total issue count for UI (#20785) (#20827)
  * Add proxy host into allow list (#20798) (#20819)
  * Add missing translation for queue flush workers (#20791) (#20792)
  * Improve comment header for mobile (#20781) (#20789)
  * Fix git.Init for doctor sub-command (#20782) (#20783)
  * Check webhooks slice length before calling xorm (#20642) (#20768)
  * Remove manual rollback for failed generated repositories (#20639) (#20762)
  * Use correct field name in npm template (#20675) (#20760)
  * Keep download count on Container tag overwrite (#20728) (#20735)
  * Fix v220 migration to be compatible for MSSQL 2008 r2 (#20702) (#20707)
  * Use request timeout for git service rpc (#20689) (#20693)
  * Send correct NuGet status codes (#20647) (#20677)
  * Use correct context to get package content (#20673) (#20676)
  * Fix the JS error "EventSource is not defined" caused by some non-standard browsers (#20584) (#20663)
  * Add default commit messages to PR for squash merge (#20618) (#20645)
  * Fix package upload for files >32mb (#20622) (#20635)
  * Fix the new-line copy-paste for rendered code (#20612)
  * Clean up and fix clone button script (#20415 & #20600) (#20599)
  * Fix default merge style (#20564) (#20565)
  * Add repository condition for issue count (#20454) (#20496)
  * Make branch icon stand out more (#20726) (#20774)
  * Fix loading button with invalid form (#20754) (#20759)
  * Fix SecToTime edge-cases (#20610) (#20611)
  * Executable check always returns true for windows (#20637) (#20835)
  * Check issue labels slice length before calling xorm Insert (#20655) (#20836)
  * Fix owners cannot create organization repos bug (#20841) (#20854)
  * Prevent 500 is head repo does not have PullRequest unit in IsUserAllowedToUpdate (#20839) (#20848)

## [1.17.0](https://github.com/go-gitea/gitea/releases/tag/v1.17.0) - 2022-07-30

* BREAKING
  * Require go1.18 for Gitea 1.17 (#19918)
  * Make AppDataPath absolute against the AppWorkPath if it is not (#19815)
  * Nuke the incorrect permission report on /api/v1/notifications (#19761)
  * Refactor git module, make Gitea use internal git config (#19732)
  * Remove `RequireHighlightJS` field, update plantuml example. (#19615)
  * Increase minimal required git version to 2.0 (#19577)
  * Add a directory prefix `gitea-src-VERSION` to release-tar-file (#19396)
  * Use "main" as default branch name (#19354)
  * Make cron task no notice on success (#19221)
  * Add pam account authorization check (#19040)
  * Show messages for users if the ROOT_URL is wrong, show JavaScript errors (#18971)
  * Refactor mirror code & fix StartToMirror (#18904)
  * Remove deprecated SSH ciphers from default (#18697)
  * Add the possibility to allow the user to have a favicon which differs from the main logo (#18542)
  * Update reserved usernames list (#18438)
  * Support custom ACME provider (#18340)
  * Change initial TrustModel to committer (#18335)
  * Update HTTP status codes (#18063)
  * Upgrade Alpine from 3.13 to 3.15 (#18050)
  * Restrict email address validation (#17688)
  * Refactor Router Logger (#17308)
* SECURITY
  * Use git.HOME_PATH for Git HOME directory (#20114) (#20293)
  * Add write check for creating Commit Statuses (#20332) (#20333)
  * Remove deprecated SSH ciphers from default (#18697)
* FEDERATION
  * Return statistic information for nodeinfo (#19561)
  * Add Webfinger endpoint (#19462)
  * Store the foreign ID of issues during migration (#18446)
* FEATURES
  * Automatically render wiki TOC (#19873)
  * Adding button to link accounts from user settings (#19792)
  * Allow set default merge style while creating repo (#19751)
  * Auto merge pull requests when all checks succeeded (#9307 & #19648)
  * Improve reviewing PR UX (#19612)
  * Add support for rendering console output with colors (#19497)
  * Add Helm Chart registry (#19406)
  * Add Goroutine stack inspector to admin/monitor (#19207)
  * RSS/Atom support for Orgs & Repos (#17714 & #19055)
  * Add button for issue deletion (#19032)
  * Allow to mark files in a PR as viewed (#19007)
  * Add Index to comment for migrations and mirroring (#18806)
  * Add health check endpoint (#18465)
  * Add packagist webhook (#18224)
  * Add "Allow edits from maintainer" feature (#18002)
  * Add apply-patch, basic revert and cherry-pick functionality (#17902)
  * Add Package Registry (#16510)
  * Add LDAP group sync to Teams (#16299)
  * Pause queues (#15928)
  * Added auto-save whitespace behavior if it changed manually (#15566)
  * Find files in repo (#15028)
  * Provide configuration to allow camo-media proxying (#12802)
* API
  * Add endpoint to serve blob or LFS file content (#19689)
  * Add endpoint to check if team has repo access (#19540)
  * More commit info (#19252)
  * Allow to create file on empty repo (#19224)
  * Allow removing issues (#18879)
  * Add endpoint to query collaborators permission for a repository (#18761)
  * Return primary language and repository language stats API URL (#18396)
  * Implement http signatures support for the API (#17565)
* ENHANCEMENTS
  * Make notification bell more prominent on mobile (#20108, #20236, #20251) (#20269)
  * Adjust max-widths for the repository file table (#20243) (#20247)
  * Display full name (#20171) (#20246)
  * Add dbconsistency checks for Stopwatches (#20010)
  * Add fetch.writeCommitGraph to gitconfig (#20006)
  * Add fgprof pprof profiler (#20005)
  * Move agit dependency (#19998)
  * Empty log queue on flush and close (#19994)
  * Remove tab/TabName usage where it's not needed (#19973)
  * Improve file header on mobile (#19945)
  * Move issues related files into models/issues (#19931)
  * Add breaking email restrictions checker in doctor (#19903)
  * Improve UX on modal for deleting an access token (#19894)
  * Add alt text to logo (#19892)
  * Move some code into models/git (#19879)
  * Remove customized (unmaintained) dropdown, improve aria a11y for dropdown (#19861)
  * Make user profile image show full image on mobile (#19840)
  * Replace blue button and label classes with primary (#19763)
  * Remove fomantic progress module (#19760)
  * Allows repo search to match against "owner/repo" pattern strings (#19754)
  * Move org functions (#19753)
  * Move almost all functions' parameter db.Engine to context.Context (#19748)
  * Show source/target branches on PR's list (#19747)
  * Use http.StatusTemporaryRedirect(307) when serve avatar directly (#19739)
  * Add doctor orphan check for orphaned pull requests without an existing base repo  (#19731)
  * Make Ctrl+Enter (quick submit) work for issue comment and wiki editor (#19729)
  * Update go-chi/cache to utilize Ping() (#19719)
  * Improve commit list/view on mobile (#19712)
  * Move some repository related code into sub package (#19711)
  * Use a better OlderThan for DeleteInactiveUsers (#19693)
  * Introduce eslint-plugin-jquery (#19690)
  * Tidy up `<head>` template (#19678)
  * Calculate filename hash only once (#19654)
  * Simplify `IsVendor` (#19626)
  * Add "Reference" section to Issue view sidebar (#19609)
  * Only set CanColorStdout / CanColorStderr to true if the stdout/stderr is a terminal (#19581)
  * Use for a repo action one database transaction (#19576)
  * Simplify loops to copy (#19569)
  * Added X-Mailer header to outgoing emails (#19562)
  * use middleware to open gitRepo (#19559)
  * Mute link in diff header (#19556)
  * Improve UI on mobile (#19546)
  * Fix Pull Request comment filename word breaks (#19535)
  * Permalink files In PR diff (#19534)
  * PullService lock via pullID (#19520)
  * Make repository file list useable on mobile (#19515)
  * more context for models  (#19511)
  * Refactor readme file renderer (#19502)
  * By default force vertical tabs on mobile (#19486)
  * Github style following followers (#19482)
  * Improve action table indices (#19472)
  * Use horizontal tabs for repo header on mobile (#19468)
  * pass gitRepo down since its used for main repo and wiki (#19461)
  * Admin should not delete himself (#19423)
  * Use queue instead of memory queue in webhook send service (#19390)
  * Simplify the code to get issue count (#19380)
  * Add commit status popup to issuelist (#19375)
  * Add RSS Feed buttons to Repo, User and Org pages (#19370)
  * Add logic to switch between source/rendered on Markdown (#19356)
  * Move some helper files out of models (#19355)
  * Move access and repo permission to models/perm/access (#19350)
  * Disallow selecting the text of buttons (#19330)
  * Allow custom redirect for landing page (#19324)
  * Remove dependent on session auth for api/v1 routers (#19321)
  * Never use /api/v1 from Gitea UI Pages (#19318)
  * Remove legacy unmaintained packages, refactor to support change default locale (#19308)
  * Move milestone to models/issues/ (#19278)
  * Configure OpenSSH log level via Environment in Docker (#19274)
  * Move reaction to models/issues/ (#19264)
  * Make git.OpenRepository accept Context (#19260)
  * Move some issue methods as functions (#19255)
  * Show last cron messages on monitor page (#19223)
  * New cron task: delete old system notices (#19219)
  * Add Redis Sentinel Authentication Support (#19213)
  * Add auto logging of goroutine pid label (#19212)
  * Set OpenGraph title to DisplayName in profile pages  (#19206)
  * Add pprof labels in processes and for lifecycles (#19202)
  * Let web and API routes have different auth methods group (#19168)
  * Move init repository related functions to modules (#19159)
  * Feeds: render markdown to html (#19058)
  * Allow users to self-request a PR review (#19030)
  * Allow render HTML with css/js external links (#19017)
  * Fix script compatible with OpenWrt (#19000)
  * Support ignore all santize for external renderer (#18984)
  * Add note to GPG key response if user has no keys (#18961)
  * Improve Stopwatch behavior (#18930)
  * Improve mirror iterator (#18928)
  * Uncapitalize errors (#18915)
  * Prevent Stats Indexer reporting error if repo dir missing (#18870)
  * Refactor SecToTime() function (#18863)
  * Replace deprecated String.prototype.substr() with String.prototype.slice() (#18796)
  * Move deletebeans into models/db (#18781)
  * Fix display time of milestones (#18753)
  * Add config option to disable "Update branch by rebase" (#18745)
  * Display template path of current page in dev mode (#18717)
  * Add number in queue status to monitor page (#18712)
  * Change git.cmd to RunWithContext (#18693)
  * Refactor i18n, use Locale to provide i18n/translation related functions (#18648)
  * Delete old git.NewCommand() and use it as git.NewCommandContext() (#18552)
  * Move organization related structs into sub package (#18518)
  * Warn at startup if the provided `SCRIPT_TYPE` is not on the PATH (#18467)
  * Use `CryptoRandomBytes` instead of `CryptoRandomString` (#18439)
  * Use explicit jQuery import, remove unused eslint globals (#18435)
  * Allow to filter repositories by language in explore, user and organization repositories lists (#18430)
  * Use base32 for 2FA scratch token (#18384)
  * Unexport var git.GlobalCommandArgs (#18376)
  * Don't underline commit status icon on hover (#18372)
  * Always use git command but not os.Command (#18363)
  * Switch to non-deprecation setting (#18358)
  * Set the LastModified header for raw files (#18356)
  * Refactor jwt.StandardClaims to RegisteredClaims (#18344)
  * Enable deprecation error for v1.17.0 (#18341)
  * Refactor httplib (#18338)
  * Limit max-height of CodeMirror editors for issue comment and wiki (#18271)
  * Validate migration files (#18203)
  * Format with gofumpt (#18184)
  * Allow custom default merge message with .gitea/default_merge_message/<merge_style>_TEMPLATE.md (#18177)
  * Prettify number of issues (#17760)
  * Add a "admin user generate-access-token" subcommand (#17722)
  * Custom regexp external issues (#17624)
  * Add smtp password to install page (#17564)
  * Add config options to hide issue events (#17414)
  * Prevent double click new issue/pull/comment button (#16157)
  * Show issue assignee on project board (#15232)
* BUGFIXES
  * WebAuthn CredentialID field needs to be increased in size (#20530) (#20555)
  * Ensure that all unmerged files are merged when conflict checking (#20528) (#20536)
  * Stop logging EOFs and exit(1)s in ssh handler (#20476) (#20529)
  * Add labels to two buttons that were missing them (#20419) (#20524)
  * Fix ROOT_URL detection for URLs without trailing slash (#20502) (#20503)
  * Dismiss prior pull reviews if done via web in review dismiss (#20197) (#20407)
  * Allow RSA 2047 bit keys (#20272) (#20396)
  * Add missing return for when topic isn't found (#20351) (#20395)
  * Fix commit status icon when in subdirectory (#20285) (#20385)
  * Initialize cron last (#20373) (#20384)
  * Set target on create release with existing tag (#20381) (#20382)
  * Update xorm.io/xorm to fix a interpreting db column sizes issue on 32bit systems (#20371) (#20372)
  * Make sure `repo_dir` is an empty directory or doesn't exist before 'dump-repo' (#20205) (#20370)
  * Prevent context deadline error propagation in GetCommitsInfo (#20346) (#20361)
  * Correctly handle draft releases without a tag (#20314) (#20335)
  * Prevent "empty" scrollbars on Firefox (#20294) (#20308)
  * Refactor SSH init code, fix directory creation for TrustedUserCAKeys file (#20299) (#20306)
  * Bump goldmark to v1.4.13 (#20300) (#20301)
  * Do not create empty ".ssh" directory when loading config (#20289) (#20298)
  * Fix NPE when using non-numeric (#20277) (#20278)
  * Store read access in access for team repositories (#20275) (#20276)
  * EscapeFilter the group dn membership (#20200) (#20254)
  * Only show Followers that current user can access (#20220) (#20252)
  * Update Bluemonday to v1.0.19 (#20199) (#20209)
  * Refix indices on actions table (#20158) (#20198)
  * Check if project has the same repository id with issue when assign project to issue (#20133) (#20188)
  * Fix remove file on initial comment (#20127) (#20128)
  * Catch the error before the response is processed by goth (#20000) (#20102)
  * Dashboard feed respect setting.UI.FeedPagingNum again (#20094) (#20099)
  * Alter hook_task TEXT fields to LONGTEXT (#20038) (#20041)
  * Respond with a 401 on git push when password isn't changed yet (#20026) (#20027)
  * Return 404 when tag is broken (#20017) (#20024)
  * Alter hook_task TEXT fields to LONGTEXT (#20038) (#20041)
  * Respond with a 401 on git push when password isn't changed yet (#20026) (#20027)
  * Return 404 when tag is broken (#20017) (#20024)
  * Write Commit-Graphs in RepositoryDumper (#20004)
  * Use DisplayName() instead of FullName in Oauth Provider (#19991)
  * Don't buffer doctor logger (#19982)
  * Always try to fetch repo for mirrors (#19975)
  * Uppercase first languages letters (#19965)
  * Fix cli command restore-repo: "units" should be parsed as StringSlice (#19953)
  * Ensure minimum mirror interval is reported on settings page (#19895)
  * Exclude Archived repos from Dashboard Milestones (#19882)
  * gitconfig: set safe.directory = * (#19870)
  * Prevent NPE on update mirror settings (#19864)
  * Only return valid stopwatches to the EventSource (#19863)
  * Prevent NPE whilst migrating if there is a team request review (#19855)
  * Fix inconsistency in doctor output (#19836)
  * Fix release tag for webhook (#19830)
  * Add title attribute to dependencies in sidebar (#19807)
  * Estimate Action Count in Statistics (#19775)
  * Do not update user stars numbers unless fix is specified (#19750)
  * Improved ref comment link when origin is body/title (#19741)
  * Fix nodeinfo caching and prevent NPE if cache non-existent (#19721)
  * Fix duplicate entry error when add team member (#19702)
  * Fix sending empty notifications (#19589)
  * Update image URL for Discord webhook (#19536)
  * Don't let repo clone URL overflow (#19517)
  * Allow commit status popup on /pulls page (#19507)
  * Fix two UI bugs: JS error in imagediff.js, 500 error in diff/compare.tmpl (#19494)
  * Fix logging of Transfer API (#19456)
  * Fix panic in teams API when requesting members (#19360)
  * Refactor CSRF protection modules, make sure CSRF tokens can be up-to-date. (#19337)
  * An attempt to sync a non-mirror repo must give 400 (Bad Request) (#19300)
  * Move checks for pulls before merge into own function (#19271)
  * Fix `contrib/upgrade.sh` (#19222)
  * Set the default branch for repositories generated from templates (#19136)
  * Fix EasyMDE error when input Enter (#19004)
  * Don't clean up hardcoded `tmp` (#18983)
  * Delete related notifications on issue deletion too (#18953)
  * Fix trace log to show value instead of pointers (#18926)
  * Fix behavior or checkbox submission. (#18851)
  * Add `ContextUser` (#18798)
  * Fix some mirror bugs (#18649)
  * Quote MAKE to prevent path expansion with space error (#18622)
  * Preserve users if restoring a repository on the same Gitea instance (#18604)
  * Fix non-ASCII search on database  (#18437)
  * Automatically pause queue if index service is unavailable (#15066)
* TESTING
  * Allow postgres integration tests to run over unix pipe (#19875)
  * Prevent intermittent NPE in queue tests (#19301)
  * Add test for importing pull requests in gitea uploader for migrations (#18752)
  * Remove redundant comparison in repo dump/restore (#18660)
  * More repo dump/restore tests, including pull requests  (#18621)
  * Add test coverage for original author conversion during migrations (#18506)
* TRANSLATION
  * Update issue_no_dependencies description (#19112)
  * Refactor webhooks i18n (#18380)
* BUILD
  * Use alpine 3.16 (#19797)
  * Require node 14.0 (#19451)
* DOCS
  * Update documents (git/fomantic/db, etc) (#19868)
  * Update the ROOT documentation and error messages (#19832)
  * Update document to use FHS `/usr/local/bin/gitea` instead of `/app/...` for Docker (#19794)
  * Update documentation to disable duration settings with -1 instead of 0 (#19647)
  * Add warning to set SENDMAIL_ARGS to --  (#19102)
  * Update nginx reverse proxy docs (#18922)
  * Add example to render html files (#18736)
  * Make SSH passtrough documentation better (#18687)
  * Changelog 1.16.0 & 1.15.11 (#18468 & #18455)  (#18470)
  * Update the SSH passthrough documentation (#18366)
  * Add `contrib/upgrade.sh` (#18286)
* MISC
  * Fix aria for logo (#19955)
  * In code search, get code unit accessible repos in one (main) query (#19764)
  * Add tooltip to pending PR comments (#19662)
  * Improve sync performance for pull-mirrors (#19125)
  * Improve dashboard's repo list performance (#18963)
  * Avoid database lookups for `DescriptionHTML` (#18924)
  * Remove CodeMirror dependencies (#18911)
  * Disable unnecessary mirroring elements (#18527)
  * Disable unnecessary OpenID/OAuth2 elements (#18491)
  * Disable unnecessary GitHooks elements (#18485)
  * Change some logging levels (#18421)
  * Prevent showing webauthn error for every time visiting `/user/settings/security` (#18385)
  * Use correct translation key for errors (#18342)

## [1.16.9](https://github.com/go-gitea/gitea/releases/tag/v1.16.9) - 2022-07-12

* SECURITY
  * Add write check for creating Commit status (#20332) (#20334)
  * Check for permission when fetching user controlled issues (#20133) (#20196)
* BUGFIXES
  * Hide notify mail setting ui if not enabled (#20138) (#20337)
  * Add write check for creating Commit status (#20332) (#20334)
  * Only show Followers that current user can access (#20220) (#20253)
  * Release page show all tags in compare dropdown (#20070) (#20071)
  * Fix permission check for delete tag (#19985) (#20001)
  * Only log non ErrNotExist errors in git.GetNote  (#19884) (#19905)
  * Use exact search instead of fuzzy search for branch filter dropdown (#19885) (#19893)
  * Set Setpgid on child git processes (#19865) (#19881)
  * Import git from alpine 3.16 repository as 2.30.4 is needed for `safe.directory = '*'` to work but alpine 3.13 has 2.30.3 (#19876)
  * Ensure responses are context.ResponseWriters (#19843) (#19859)
  * Fix incorrect usage of `Count` function (#19850)
  * Fix raw endpoint PDF file headers (#19825) (#19826)
  * Make WIP prefixes case insensitive, e.g. allow `Draft` as a WIP prefix (#19780) (#19811)
  * Don't return 500 on NotificationUnreadCount (#19802)
  * Prevent NPE when cache service is disabled (#19703) (#19783)
  * Detect truncated utf-8 characters at the end of content as still representing utf-8 (#19773) (#19774)
  * Fix doctor pq: syntax error at or near "." quote user table name (#19765) (#19770)
  * Fix bug with assigneees (#19757)

## [1.16.8](https://github.com/go-gitea/gitea/releases/tag/v1.16.8) - 2022-05-16

* ENHANCEMENTS
  * Add doctor check/fix for bogus action rows (#19656) (#19669)
  * Make .cs highlighting legible on dark themes. (#19604) (#19605)
* BUGFIXES
  * Fix oauth setting list bug (#19681)
  * Delete user related oauth stuff on user deletion too (#19677) (#19680)
  * Fix new release from tags list UI (#19670) (#19673)
  * Prevent NPE when checking repo units if the user is nil (#19625) (#19630)
  * GetFeeds must always discard actions with dangling repo_id (#19598) (#19629)
  * Call MultipartForm.RemoveAll when request finishes (#19606) (#19607)
  * Avoid MoreThanOne error when creating a branch whose name conflicts with other ref names (#19557) (#19591)
  * Fix sending empty notifications (#19589) (#19590)
  * Ignore DNS error when doing migration allow/block check (#19566) (#19567)
  * Fix issue overview for teams (#19652) (#19653)

## [1.16.7](https://github.com/go-gitea/gitea/releases/tag/v1.16.7) - 2022-05-02

* SECURITY
  * Escape git fetch remote (#19487) (#19490)
* BUGFIXES
  * Don't overwrite err with nil (#19572) (#19574)
  * On Migrations, only write commit-graph if wiki clone was successful (#19563) (#19568)
  * Respect DefaultUserIsRestricted system default when creating new user (#19310) (#19560)
  * Don't error when branch's commit doesn't exist (#19547) (#19548)
  * Support `hostname:port` to pass host matcher's check (#19543) (#19544)
  * Prevent intermittent race in attribute reader close (#19537) (#19539)
  * Fix 64-bit atomic operations on 32-bit machines (#19531) (#19532)
  * Prevent dangling archiver goroutine (#19516) (#19526)
  * Fix migrate release from github (#19510) (#19523)
  * When view _Siderbar or _Footer, just display once (#19501) (#19522)
  * Fix blame page select range error and some typos (#19503)
  * Fix name of doctor fix "authorized-keys" in hints (#19464) (#19484)
  * User specific repoID or xorm builder conditions for issue search (#19475) (#19476)
  * Prevent dangling cat-file calls (goroutine alternative) (#19454) (#19466)
  * RepoAssignment ensure to close before overwrite (#19449) (#19460)
  * Set correct PR status on 3way on conflict checking (#19457) (#19458)
  * Mark TemplateLoading error as "UnprocessableEntity" (#19445) (#19446)

## [1.16.6](https://github.com/go-gitea/gitea/releases/tag/v1.16.6) - 2022-04-20

* ENHANCEMENTS
  * Only request write when necessary (#18657) (#19422)
  * Disable service worker by default (#18914) (#19342)
* BUGFIXES
  * When dumping trim the standard suffices instead of a random suffix (#19440) (#19447)
  * Fix DELETE request for non-existent public key (#19443) (#19444)
  * Don't panic on ErrEmailInvalid (#19441) (#19442)
  * Add uploadpack.allowAnySHA1InWant to allow --filter=blob:none with older git clients (#19430) (#19438)
  * Warn on SSH connection for incorrect configuration (#19317) (#19437)
  * Search Issues via API, dont show 500 if filter result in empty list (#19244) (#19436)
  * When updating mirror repo intervals by API reschedule next update too (#19429) (#19433)
  * Fix nil error when some pages are rendered outside request context (#19427) (#19428)
  * Fix double blob-hunk on diff page (#19404) (#19405)
  * Don't allow merging PR's which are being conflict checked (#19357) (#19358)
  * Fix middleware function's placements (#19377) (#19378)
  * Fix invalid CSRF token bug, make sure CSRF tokens can be up-to-date (#19338)
  * Restore user autoregistration with email addresses (#19261) (#19312)
  * Move checks for pulls before merge into own function (#19271) (#19277)
  * Granular webhook events in editHook (#19251) (#19257)
  * Only send webhook events to active system webhooks and only deliver to active hooks (#19234) (#19248)
  * Use full output of git show-ref --tags to get tags for PushUpdateAddTag (#19235) (#19236)
  * Touch mirrors on even on fail to update (#19217) (#19233)
  * Hide sensitive content on admin panel progress monitor (#19218 & #19226) (#19231)
  * Fix clone url JS error for the empty repo page (#19209)
  * Bump goldmark to v1.4.11 (#19201) (#19203)
* TESTING
  * Prevent intermittent failures in RepoIndexerTest (#19225 #19229) (#19228)
* BUILD
  * Revert the minimal golang version requirement from 1.17 to 1.16 and add a warning in Makefile (#19319)
* MISC
  * Performance improvement for add team user when org has more than 1000 repositories (#19227) (#19289)
  * Check go and nodejs version by go.mod and package.json (#19197) (#19254)

## [1.16.5](https://github.com/go-gitea/gitea/releases/tag/v1.16.5) - 2022-03-23

* BREAKING
  * Bump to build with go1.18 (#19120 et al) (#19127)
* SECURITY
  * Prevent redirect to Host (2) (#19175) (#19186)
  * Try to prevent autolinking of displaynames by email readers (#19169) (#19183)
  * Clean paths when looking in Storage (#19124) (#19179)
  * Do not send notification emails to inactive users (#19131) (#19139)
  * Do not send activation email if manual confirm is set (#19119) (#19122)
* ENHANCEMENTS
  * Use the new/choose link for New Issue on project page (#19172) (#19176)
* BUGFIXES
  * Fix showing issues in your repositories (#18916) (#19191)
  * Fix compare link in active feeds for new branch (#19149) (#19185)
  * Redirect .wiki/* ui link to /wiki (#18831) (#19184)
  * Ensure deploy keys with write access can push (#19010) (#19182)
  * Ensure that setting.LocalURL always has a trailing slash (#19171) (#19177)
  * Cleanup protected branches when deleting users & teams (#19158) (#19174)
  * Use IterateBufferSize whilst querying repositories during adoption check (#19140) (#19160)
  * Fix NPE /repos/issues/search when not signed in (#19154) (#19155)
  * Use custom favicon when viewing static files if it exists (#19130) (#19152)
  * Fix the editor height in review box (#19003) (#19147)
  * Ensure isSSH is set whenever DISABLE_HTTP_GIT is set (#19028) (#19146)
  * Fix wrong scopes caused by empty scope input (#19029) (#19145)
  * Make migrations SKIP_TLS_VERIFY apply to git too (#19132) (#19141)
  * Handle email address not exist (#19089) (#19121)
* MISC
  * Update json-iterator to allow compilation with go1.18 (#18644) (#19100)
  * Update golang.org/x/crypto (#19097) (#19098)

## [1.16.4](https://github.com/go-gitea/gitea/releases/tag/v1.16.4) - 2022-03-14

* SECURITY
  * Restrict email address validation (#17688) (#19085)
  * Fix lfs bug (#19072) (#19080)
* ENHANCEMENTS
  * Improve SyncMirrors logging (#19045) (#19050)
* BUGFIXES
  * Refactor mirror code & fix `StartToMirror` (#18904) (#19075)
  * Update the webauthn_credential_id_sequence in Postgres (#19048) (#19060)
  * Prevent 500 when there is an error during new auth source post (#19041) (#19059)
  * If rendering has failed due to a net.OpError stop rendering (attempt 2) (#19049) (#19056)
  * Fix flag validation (#19046) (#19051)
  * Add pam account authorization check (#19040) (#19047)
  * Ignore missing comment for user notifications (#18954) (#19043)
  * Set `rel="nofollow noindex"` on new issue links (#19023) (#19042)
  * Upgrading binding package (#19034) (#19035)
  * Don't show context cancelled errors in attribute reader (#19006) (#19027)
  * Fix update hint bug (#18996) (#19002)
* MISC
  * Fix potential assignee query for repo (#18994) (#18999)

## [1.16.3](https://github.com/go-gitea/gitea/releases/tag/v1.16.3) - 2022-03-02

* SECURITY
  * Git backend ignore replace objects (#18979) (#18980)
* ENHANCEMENTS
  * Adjust error for already locked db and prevent level db lock on malformed connstr (#18923) (#18938)
* BUGFIXES
  * Set max text height to prevent overflow (#18862) (#18977)
  * Fix newAttachmentPaths deletion for DeleteRepository() (#18973) (#18974)
  * Accounts with WebAuthn only (no TOTP) now exist ... fix code to handle that case (#18897) (#18964)
  * Send 404 on `/{org}.gpg` (#18959) (#18962)
  * Fix admin user list pagination (#18957) (#18960)
  * Fix lfs management setting (#18947) (#18946)
  * Fix login with email panic when email is not exist (#18942)
  * Update go-org to v1.6.1 (#18932) (#18933)
  * Fix `<strong>` html in translation (#18929) (#18931)
  * Fix page and missing return on unadopted repos API (#18848) (#18927)
  * Allow administrator teams members to see other teams (#18918) (#18919)
  * Don't treat BOM escape sequence as hidden character. (#18909) (#18910)
  * Correctly link URLs to users/repos with dashes, dots or underscores (… (#18908)
  * Fix redirect when using lowercase repo name (#18775) (#18902)
  * Fix migration v210 (#18893) (#18892)
  * Fix team management UI (#18887) (18886)
  * BeforeSourcePath should point to base commit (#18880) (#18799)
* TRANSLATION
  * Backport locales from master (#18944)
* MISC
  * Don't update email for organisation (#18905) (#18906)

## [1.16.2](https://github.com/go-gitea/gitea/releases/tag/v1.16.2) - 2022-02-24

* ENHANCEMENTS
  * Show fullname on issue edits and gpg/ssh signing info (#18828)
  * Immediately Hammer if second kill is sent (#18823) (#18826)
  * Allow mermaid render error to wrap (#18791)
* BUGFIXES
  * Fix ldap user sync missed email in email_address table (#18786) (#18876)
  * Update assignees check to include any writing team and change org sidebar (#18680) (#18873)
  * Don't report signal: killed errors in serviceRPC (#18850) (#18865)
  * Fix bug where certain LDAP settings were reverted (#18859)
  * Update go-org to 1.6.0 (#18824) (#18839)
  * Fix login with email for ldap users (#18800) (#18836)
  * Fix bug for get user by email (#18834)
  * Fix panic in EscapeReader (#18820) (#18821)
  * Fix ldap loginname (#18789) (#18804)
  * Remove redundant call to UpdateRepoStats during migration (#18591) (#18794)
  * In disk_channel queues synchronously push to disk on shutdown (#18415) (#18788)
  * Fix template bug of LFS lock (#18784) (#18787)
  * Attempt to fix the webauthn migration again - part 3 (#18770) (#18771)
  * Send mail to issue/pr assignee/reviewer also when OnMention is set (#18707) (#18765)
  * Fix a broken link in commits_list_small.tmpl (#18763) (#18764)
  * Increase the size of the webauthn_credential credential_id field (#18739) (#18756)
  * Prevent dangling GetAttribute calls (#18754) (#18755)
  * Fix isempty detection of git repository (#18746) (#18750)
  * Fix source code line highlighting on external tracker (#18729) (#18740)
  * Prevent double encoding of branch names in delete branch (#18714) (#18738)
  * Always set PullRequestWorkInProgressPrefixes in PrepareViewPullInfo (#18713) (#18737)
  * Fix forked repositories missed tags (#18719) (#18735)
  * Fix release typo (#18728) (#18731)
  * Separate the details links of commit-statuses in headers (#18661) (#18730)
  * Update object repo with the migrated repository (#18684) (#18726)
  * Fix bug for version update hint (#18701) (#18705)
  * Fix issue with docker-rootless shimming script (#18690) (#18699)
  * Let `MinUnitAccessMode` return correct perm (#18675) (#18689)
  * Prevent security failure due to bad APP_ID (#18678) (#18682)
  * Restart zero worker if there is still work to do (#18658) (#18672)
  * If rendering has failed due to a net.OpError stop rendering (#18642) (#18645)
* TESTING
  * Ensure git tag tests and others create test repos in tmpdir (#18447) (#18767)
* BUILD
  * Reduce CI go module downloads, add make targets (#18708, #18475, #18443) (#18741)
* MISC
  * Put buttons back in org dashboard (#18817) (#18825)
  * Various Mermaid improvements (#18776) (#18780)
  * C preprocessor colors improvement (#18671) (#18696)
  * Fix the missing i18n key for update checker (#18646) (#18665)

## [1.16.1](https://github.com/go-gitea/gitea/releases/tag/v1.16.1) - 2022-02-06

* SECURITY
  * Update JS dependencies, fix lint (#18389) (#18540)
* ENHANCEMENTS
  * Add dropdown icon to label set template dropdown (#18564) (#18571)
* BUGFIXES
  * comments on migrated issues/prs must link to the comment ID (#18630) (#18637)
  * Stop logging an error when notes are not found (#18626) (#18635)
  * Ensure that blob-excerpt links work for wiki (#18587) (#18624)
  * Only attempt to flush queue if the underlying worker pool is not finished (#18593) (#18620)
  * Ensure commit-statuses box is sized correctly in headers (#18538) (#18606)
  * Prevent merge messages from being sorted to the top of email chains (#18566) (#18588)
  * Prevent panic on prohibited user login with oauth2 (#18562) (#18563)
  * Collaborator trust model should trust collaborators (#18539) (#18557)
  * Detect conflicts with 3way merge (#18536) (#18537)
  * In docker rootless use $GITEA_APP_INI if provided (#18524) (#18535)
  * Add `GetUserTeams` (#18499) (#18531)
  * Fix review excerpt (#18502) (#18530)
  * Fix for AvatarURL database type (#18487) (#18529)
  * Use `ImagedProvider` for gplus oauth2 provider (#18504) (#18505)
  * Fix OAuth Source Edit Page (#18495) (#18503)
  * Use "read" value for General Access (#18496) (#18500)
  * Prevent NPE on partial match of compare URL and allow short SHA1 compare URLs (#18472) (#18473)
* BUILD
  * Make docker gitea/gitea:v1.16-dev etc refer to the latest build on that branch (#18551) (#18569)
* DOCS
  * Update 1.16.0 changelog to set #17846 as breaking (#18533) (#18534)

## [1.16.0](https://github.com/go-gitea/gitea/releases/tag/v1.16.0) - 2022-01-30

* BREAKING
  * Remove golang vendored directory (#18277)
  * Paginate releases page & set default page size to 10 (#16857)
  * Use shadowing script for docker (#17846)
  * Only allow webhook to send requests to allowed hosts (#17482)
* SECURITY
  * Disable content sniffing on `PlainTextBytes` (#18359) (#18365)
  * Only view milestones from current repo (#18414) (#18417)
  * Sanitize user-input on file name (#17666)
  * Use `hostmatcher` to replace `matchlist` to improve blocking of bad hosts in Webhooks (#17605)
* FEATURES
  * Add/update SMTP auth providers via cli (#18197)
  * Support webauthn (#17957)
  * Team permission allow different unit has different permission (#17811)
  * Implement Well-Known URL for password change (#17777)
  * Add support for ssh commit signing (#17743)
  * Allow Loading of Diffs that are too large (#17739)
  * Add copy button to markdown code blocks (#17638)
  * Add .gitattribute assisted language detection to blame, diff and render (#17590)
  * Add `PULL_LIMIT` and `PUSH_LIMIT` to cron.update_mirror task (#17568)
  * Add Reindex buttons to repository settings page (#17494)
  * Make SSL cipher suite configurable (#17440)
  * Add groups scope/claim to OIDC/OAuth2 Provider (#17367)
  * Add simple update checker to Gitea (#17212)
  * Migrated Repository will show modifications when possible (#17191)
  * Create pub/priv keypair for federation (#17071)
  * Make LDAP be able to skip local 2FA (#16954)
  * Add nodeinfo endpoint for federation purposes (#16953)
  * Save and view issue/comment content history (#16909)
  * Use git attributes to determine generated and vendored status for language stats and diffs (#16773)
  * Add migrate from Codebase (#16768)
  * Add migration from GitBucket (#16767)
  * Add OAuth2 introspection endpoint (#16752)
  * Add proxy settings and support for migration and webhook (#16704)
  * Add microsoft oauth2 providers (#16544)
  * Send registration email on user autoregistration (#16523)
  * Defer Last Commit Info (#16467)
  * Support unprotected file patterns (#16395)
  * Add migrate from OneDev (#16356)
  * Add option to update pull request by `rebase` (#16125)
  * Add RSS/Atom feed support for user actions (#16002)
  * Add support for corporate WeChat webhooks (#15910)
  * Add a simple way to rename branch like gh (#15870)
  * Add bundle download for repository (#14538)
  * Add agit flow support in gitea (#14295)
* API
  * Add MirrorUpdated field to Repository API type (#18267)
  * Adjust Fork API to allow setting a custom repository name (#18066)
  * Add API to manage repo tranfers (#17963)
  * Add API to get file commit history (#17652)
  * Add API to get issue/pull comments and events (timeline) (#17403)
  * Add API to get/edit wiki (#17278)
  * Add API for get user org permissions (#17232)
  * Add HTML urls to notification API (#17178)
  * Add API to get commit diff/patch (#17095)
  * Respond with updated notifications in API (#17064)
  * Add API to fetch git notes (#16649)
  * Generalize list header for API (#16551)
  * Add API Token Cache (#16547)
  * Allow Token API calls be authorized using the reverse-proxy header (#15119)
* ENHANCEMENTS
  * Make the height of the editor in Review Box smaller (4 lines as GitHub) (#18319)
  * Return nicer error if trying to pull from non-existent user (#18288)
  * Show pull link for agit pull request also (#18235)
  * Enable partial clone by default (#18195)
  * Added replay of webhooks (#18191)
  * Show OAuth callback error message (#18185)
  * Increase Salt randomness (#18179)
  * Add MP4 as default allowed attachment type (#18170)
  * Include folders into size cost (#18158)
  * Remove `/email2user` endpoint (#18127)
  * Handle invalid issues (#18111)
  * Load EasyMDE/CodeMirror dynamically, remove RequireEasyMDE (#18069)
  * Support open compare page directly (#17975)
  * Prefer "Hiragino Kaku Gothic ProN" in system-ui-ja (#17954)
  * Clean legacy SimpleMDE code (#17926)
  * Refactor install page (db type) (#17919)
  * Improve interface when comparing a branch which has created a pull request (#17911)
  * Allow default branch to be inferred on compare page (#17908)
  * Display issue/comment role even if repo archived (#17907)
  * Always set a message-id on mails (#17900)
  * Change `<a>` elements to underline on hover (#17898)
  * Render issue references in file table (#17897)
  * Handle relative unix socket paths (#17836)
  * Move accessmode into models/perm (#17828)
  * Fix some org style problems (#17807)
  * Add List-Unsubscribe header (#17804)
  * Create menus for organization pages (#17802)
  * Switch archive URL code back to href attributes (#17796)
  * Refactor "refs/*" string usage by using constants (#17784)
  * Allow forks to org if you can create repos (#17783)
  * Improve install code to avoid low-level mistakes. (#17779)
  * Improve ellipsis buttons (#17773)
  * Add restrict and no-user-rc to authorized_keys (#17772)
  * Add copy Commit ID button in commits list (#17759)
  * Make `bind` error more readable (#17750)
  * Fix navbar on project view (#17749)
  * More pleasantly handle broken or missing git repositories (#17747)
  * Use `*PushUpdateOptions` as receiver (#17724)
  * Remove unused `user` paramater (#17723)
  * Better builtin avatar generator (#17707)
  * Cleanup and use global style on popups (#17674)
  * Move user/org deletion to services (#17673)
  * Added comment for changing issue ref (#17672)
  * Allow admins to change user avatars (#17661)
  * Only set `data-path` once for each file in diff pages (#17657)
  * Add icon to vscode clone link (#17641)
  * Add download button for file viewer (#17640)
  * Add pagination to fork list (#17639)
  * Use a standalone struct name for Organization (#17632)
  * Minor readability patch. (#17627)
  * Add context support for GetUserByID (#17602)
  * Move merge-section to `> .content` (#17582)
  * Remove NewSession method from db.Engine interface (#17577)
  * Move unit into models/unit/ (#17576)
  * Restrict GetDeletedBranchByID to the repositories deleted branches (#17570)
  * Refactor commentTags functionality (#17558)
  * Make Repo Code Indexer an Unique Queue (#17515)
  * Simplify Gothic to use our session store instead of creating a different store (#17507)
  * Add settings to allow different SMTP envelope from address (#17479)
  * Properly determine CSV delimiter (#17459)
  * Hide label comments if labels were added and removed immediately (#17455)
  * Tune UI alignment for nav bar notification icon, avatar image, issue label (#17438)
  * Add appearance section in settings (#17433)
  * Move key forms before list and add cancel button (#17432)
  * When copying executables to the docker chmod them (#17423)
  * Remove deprecated `extendDefaultPlugins` method of svgo (#17399)
  * Fix the click behavior for <tr> and <td> with [data-href] (#17388)
  * Refactor update checker to use AppState (#17387)
  * Improve async/await usage, and sort init calls in `index.js` (#17386)
  * Use a variable but a function for IsProd because of a slight performance increment (#17368)
  * Frontend refactor, PascalCase to camelCase, remove unused code (#17365)
  * Hide command line merge instructions when user can't push (#17339)
  * Move session to models/login (#17338)
  * Sync gitea app path for git hooks and authorized keys when starting (#17335)
  * Make the Mirror Queue a queue (#17326)
  * Add "Copy branch name" button to pull request page (#17323)
  * Fix repository summary on mobile (#17322)
  * Split `index.js` to separate files (#17315)
  * Show direct match on top for user search (#17303)
  * Frontend refactor: move Vue related code from `index.js` to `components` dir, and remove unused codes. (#17301)
  * Upgrade chi to v5 (#17298)
  * Disable form autofill (#17291)
  * Improve behavior of "Fork" button (#17288)
  * Open markdown image links in new window (#17287)
  * Add hints for special Wiki pages (#17283)
  * Move add deploy key form before the list and add a cancel button (#17228)
  * Allow adding multiple issues to a project  (#17226)
  * Add metrics to get issues by repository (#17225)
  * Add specific event type to header (#17222)
  * Redirect on project after issue created (#17211)
  * Reference in new issue modal: dont pre-populate issue title (#17208)
  * Always set a unique Message-ID header (#17206)
  * Add projects and project boards in exposed metrics (#17202)
  * Add metrics to get issues by label (#17201)
  * Add protection to disable Gitea when run as root (#17168)
  * Don't return binary file changes in raw PR diffs by default (#17158)
  * Support sorting for project board issuses (#17152)
  * Force color-adjust for markdown checkboxes (#17146)
  * Add option to copy line permalink (#17145)
  * Move twofactor to models/login (#17143)
  * Multiple tokens support for migrating from github (#17134)
  * Unify issue and PR subtitles (#17133)
  * Make Requests Processes and create process hierarchy. Associate OpenRepository with context. (#17125)
  * Fix problem when database id is not increment as expected (#17124)
  * Avatar refactor, move avatar code from `models` to `models.avatars`, remove duplicated code (#17123)
  * Re-allow clipboard copy on non-https sites (#17118)
  * DBContext is just a Context (#17100)
  * Move login related structs and functions to models/login (#17093)
  * Add SkipLocal2FA option to pam and smtp sources (#17078)
  * Move db related basic functions to models/db (#17075)
  * Fixes username tagging in "Reference in new issue" (#17074)
  * Use light/dark theme based on system preference (#17051)
  * Always emit the configuration path (#17036)
  * Add `AbsoluteListOptions` (#17028)
  * Use common sessioner for API and Web (#17027)
  * Fix overflow label in small view (#17020)
  * Report the associated filter if there is an error in LDAP (#17014)
  * Add "new issue" btn on project (#17001)
  * Add doctor dbconsistency check for release and attachment (#16978)
  * Disable Fomantic's CSS tooltips (#16974)
  * Add Cache-Control to avatar redirects (#16973)
  * Make mirror feature more configurable (#16957)
  * Add skip and limit to git.GetTags (#16897)
  * Remove ParseQueueConnStr as it is unused (#16878)
  * Remove unused Fomantic sidebar module (#16853)
  * Allow LDAP Sources to provide Avatars (#16851)
  * Remove Dashboard/Home button from the navbar (#16844)
  * Use conditions but not repo ids as query condition (#16839)
  * Add user settings key/value DB table (#16834)
  * Add buttons to allow loading of incomplete diffs (#16829)
  * Add information for migrate failure (#16803)
  * Add EdDSA JWT signing algorithm (#16786)
  * Add user status filter to admin user management page (#16770)
  * Add Option to synchronize Admin & Restricted states from OIDC/OAuth2 along with Setting Scopes (#16766)
  * Do not use thin scrollbars on Firefox (#16738)
  * Download LFS in git and web workflow from minio/s3 directly (SERVE_DIRECT) (#16731)
  * Compute proper foreground color for labels (#16729)
  * Add edit button to wiki sidebar and footer (#16719)
  * Fix migration svg color (#16715)
  * Add link to vscode to repo header (#16664)
  * Add filter by owner and team to issue/pulls search endpoint (#16662)
  * Kanban colored boards (#16647)
  * Allow setting X-FRAME-OPTIONS (#16643)
  * Separate open and closed issue in metrics (#16637)
  * Support direct comparison (git diff a..b) as well merge comparison (a…b) (#16635)
  * Add setting to OAuth handlers to skip local 2FA authentication (#16594)
  * Make PR merge options more intuitive (#16582)
  * Show correct text when comparing commits on empty pull request (#16569)
  * Pre-fill suggested New File 'name' and 'content' with Query Params (#16556)
  * Add an abstract json layout to make it's easier to change json library (#16528)
  * Make Mermaid.js limit configurable (#16519)
  * Improve 2FA autofill (#16473)
  * Add modals to Organization and Team remove/leave (#16471)
  * Show tag name on dashboard items list (#16466)
  * Change default cron schedules from @every 24h to @midnight (#16431)
  * Prevent double sanitize (#16386)
  * Replace `list.List` with slices (#16311)
  * Add configuration option to restrict users by default (#16256)
  * Move login out of models (#16199)
  * Support pagination of organizations on user settings pages (#16083)
  * Switch migration icon to svg (#15954)
  * Add left padding for chunk header of split diff view (#13397)
  * Allow U2F 2FA without TOTP (#11573)
* BUGFIXES
  * GitLab reviews may not have the updated_at field set (#18450) (#18461)
  * Fix detection of no commits when the default branch is not master (#18422) (#18423)
  * Fix broken oauth2 authentication source edit page (#18412) (#18419)
  * Place inline diff comment dialogs on split diff in 4th and 8th columns (#18403) (#18404)
  * Fix restore without topic failure (#18387) (#18400)
  * Fix commit's time (#18375) (#18392)
  * Fix partial cloning a repo (#18373) (#18377)
  * Stop trimming preceding and suffixing spaces from editor filenames (#18334)
  * Prevent showing webauthn error for every time visiting `/user/settings/security` (#18386)
  * Fix mime-type detection for HTTP server (#18370) (#18371)
  * Stop trimming preceding and suffixing spaces from editor filenames (#18334)
  * Restore propagation of ErrDependenciesLeft (#18325)
  * Fix PR comments UI (#18323)
  * Use indirect comparison when showing pull requests (#18313)
  * Replace satori/go.uuid with gofrs/uuid (#18311)
  * Fix commit links on compare page (#18310)
  * Don't show double error response in git hook (#18292)
  * Handle missing default branch better in owner/repo/branches page (#18290)
  * Fix CheckRepoStats and reuse it during migration (#18264)
  * Prevent underline hover on cards (#18259)
  * Don't delete branch if other PRs with this branch are open (#18164)
  * Require codereview to have content (#18156)
  * Allow admin to associate missing LFS objects for repositories (#18143)
  * When attempting to subscribe other user to issue report why access denied (#18091)
  * Add option to convert CRLF to LF line endings for sendmail (#18075)
  * Only create pprof files for gitea serv if explicitly asked for (#18068)
  * Abort merge if head has been updated before pressing merge (#18032)
  * Improve TestPatch to use git read-tree -m and implement git-merge-one-file functionality (#18004)
  * Use JSON module instead of stdlib json (#18003)
  * Fixed issue merged/closed wording (#17973)
  * Return nicer error for ForcePrivate (#17971)
  * Fix overflow in commit graph (#17947)
  * Prevent services/mailer/mailer_test.go tests from deleting data directory (#17941)
  * Use disable_form_autofill on Codebase and Gitbucket (#17936)
  * Fix a panic in NotifyCreateIssueComment (caused by string truncation) (#17928)
  * Fix markdown URL parsing (#17924)
  * Apply CSS Variables to all message elements (#17920)
  * Improve checkBranchName (#17901)
  * Update chi/middleware to chi/v5/middleware (#17888)
  * Fix position of label color picker colors (#17866)
  * Fix ListUnadoptedRepositories incorrect total count (#17865)
  * Remove whitespace inside rendered code `<td>` (#17859)
  * Make Co-committed-by and co-authored-by trailers optional (#17848)
  * Fix value of User.IsRestricted when oauth2 user registration (#17839)
  * Use new OneDev /milestones endpoint (#17782)
  * Prevent deadlock in TestPersistableChannelQueue (#17717)
  * Simplify code for writing SHA to name-rev (#17696)
  * Fix database deadlock when update issue labels (#17649)
  * Add warning for BIDI characters in page renders and in diffs (#17562)
  * Fix ipv6 parsing for builtin ssh server (#17561)
  * Multiple Escaping Improvements (#17551)
  * Fixes #16559 - Do not trim leading spaces for tab delimited (#17442)
  * Show client-side error if wiki page is empty (#17415)
  * Fix context popup error (#17398)
  * Stop sanitizing full name in API (#17396)
  * Fix issue close/comment buttons on mobile (#17317)
  * Fix navbar UI (#17235)
  * Fix problem when database id is not increment as expected (#17229)
  * Open the DingTalk link in browser (#17084)
  * Remove heads pointing to missing old refs (#17076)
  * Fix commit status index problem (#17061)
  * Handle broken references in mirror sync (#17013)
  * Fix for create repo page layout (#17012)
  * Improve LDAP synchronization efficiency (#16994)
  * Add repo_id for attachment (#16958)
  * Clean-up HookPreReceive and restore functionality for pushing non-standard refs (#16705)
  * Remove duplicate csv import in modules/csv/csv.go (#16631)
  * Improve SMTP authentication and Fix user creation bugs  (#16612)
  * Fixed emoji alias not parsed in links (#16221)
  * Calculate label URL on API  (#16186)
* TRANSLATION
  * Fix misspelling of starred as stared (#17465)
  * Re-separate the color translation strings (#17390)
  * Enable Malayalam, Greek, Persian, Hungarian & Indonesian by default (#16998)
* BUILD
  * Add lockfile-check (#18285)
  * Don't store assets modified time into generated files (#18193)
* MISC
  * Update JS dependencies (#17611)

## Archived releases

* [CHANGELOG-archived.md](CHANGELOG-archived.md)
