#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2777
#define LARGE_STATE_COUNT 181
#define SYMBOL_COUNT 272
#define ALIAS_COUNT 2
#define TOKEN_COUNT 108
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 142

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_type = 43,
  anon_sym_EQ = 44,
  anon_sym_class = 45,
  anon_sym_LBRACK = 46,
  anon_sym_RBRACK = 47,
  anon_sym_AT = 48,
  anon_sym_DASH = 49,
  anon_sym__ = 50,
  anon_sym_PIPE = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  anon_sym_PLUS = 54,
  anon_sym_not = 55,
  anon_sym_and = 56,
  anon_sym_or = 57,
  anon_sym_SLASH = 58,
  anon_sym_PERCENT = 59,
  anon_sym_SLASH_SLASH = 60,
  anon_sym_AMP = 61,
  anon_sym_CARET = 62,
  anon_sym_LT_LT = 63,
  anon_sym_TILDE = 64,
  anon_sym_is = 65,
  anon_sym_LT = 66,
  anon_sym_LT_EQ = 67,
  anon_sym_EQ_EQ = 68,
  anon_sym_BANG_EQ = 69,
  anon_sym_GT_EQ = 70,
  anon_sym_GT = 71,
  anon_sym_LT_GT = 72,
  anon_sym_lambda = 73,
  anon_sym_PLUS_EQ = 74,
  anon_sym_DASH_EQ = 75,
  anon_sym_STAR_EQ = 76,
  anon_sym_SLASH_EQ = 77,
  anon_sym_AT_EQ = 78,
  anon_sym_SLASH_SLASH_EQ = 79,
  anon_sym_PERCENT_EQ = 80,
  anon_sym_STAR_STAR_EQ = 81,
  anon_sym_GT_GT_EQ = 82,
  anon_sym_LT_LT_EQ = 83,
  anon_sym_AMP_EQ = 84,
  anon_sym_CARET_EQ = 85,
  anon_sym_PIPE_EQ = 86,
  anon_sym_yield = 87,
  sym_ellipsis = 88,
  sym_escape_sequence = 89,
  anon_sym_BSLASH = 90,
  aux_sym_format_specifier_token1 = 91,
  sym_type_conversion = 92,
  sym_integer = 93,
  sym_float = 94,
  anon_sym_await = 95,
  sym_true = 96,
  sym_false = 97,
  sym_none = 98,
  sym_comment = 99,
  sym_line_continuation = 100,
  sym__newline = 101,
  sym__indent = 102,
  sym__dedent = 103,
  sym_string_start = 104,
  sym__string_content = 105,
  sym_escape_interpolation = 106,
  sym_string_end = 107,
  sym_module = 108,
  sym__statement = 109,
  sym__simple_statements = 110,
  sym_import_statement = 111,
  sym_import_prefix = 112,
  sym_relative_import = 113,
  sym_future_import_statement = 114,
  sym_import_from_statement = 115,
  sym__import_list = 116,
  sym_aliased_import = 117,
  sym_wildcard_import = 118,
  sym_print_statement = 119,
  sym_chevron = 120,
  sym_assert_statement = 121,
  sym_expression_statement = 122,
  sym_named_expression = 123,
  sym__named_expression_lhs = 124,
  sym_return_statement = 125,
  sym_delete_statement = 126,
  sym_raise_statement = 127,
  sym_pass_statement = 128,
  sym_break_statement = 129,
  sym_continue_statement = 130,
  sym_if_statement = 131,
  sym_elif_clause = 132,
  sym_else_clause = 133,
  sym_match_statement = 134,
  sym__match_block = 135,
  sym_case_clause = 136,
  sym_for_statement = 137,
  sym_while_statement = 138,
  sym_try_statement = 139,
  sym_except_clause = 140,
  sym_except_group_clause = 141,
  sym_finally_clause = 142,
  sym_with_statement = 143,
  sym_with_clause = 144,
  sym_with_item = 145,
  sym_function_definition = 146,
  sym_parameters = 147,
  sym_lambda_parameters = 148,
  sym_list_splat = 149,
  sym_dictionary_splat = 150,
  sym_global_statement = 151,
  sym_nonlocal_statement = 152,
  sym_exec_statement = 153,
  sym_type_alias_statement = 154,
  sym_class_definition = 155,
  sym_type_parameter = 156,
  sym_parenthesized_list_splat = 157,
  sym_argument_list = 158,
  sym_decorated_definition = 159,
  sym_decorator = 160,
  sym_block = 161,
  sym_expression_list = 162,
  sym_dotted_name = 163,
  sym_case_pattern = 164,
  sym__simple_pattern = 165,
  sym__as_pattern = 166,
  sym_union_pattern = 167,
  sym__list_pattern = 168,
  sym__tuple_pattern = 169,
  sym_dict_pattern = 170,
  sym__key_value_pattern = 171,
  sym_keyword_pattern = 172,
  sym_splat_pattern = 173,
  sym_class_pattern = 174,
  sym_complex_pattern = 175,
  sym__parameters = 176,
  sym__patterns = 177,
  sym_parameter = 178,
  sym_pattern = 179,
  sym_tuple_pattern = 180,
  sym_list_pattern = 181,
  sym_default_parameter = 182,
  sym_typed_default_parameter = 183,
  sym_list_splat_pattern = 184,
  sym_dictionary_splat_pattern = 185,
  sym_as_pattern = 186,
  sym__expression_within_for_in_clause = 187,
  sym_expression = 188,
  sym_primary_expression = 189,
  sym_not_operator = 190,
  sym_boolean_operator = 191,
  sym_binary_operator = 192,
  sym_unary_operator = 193,
  sym__not_in = 194,
  sym__is_not = 195,
  sym_comparison_operator = 196,
  sym_lambda = 197,
  sym_lambda_within_for_in_clause = 198,
  sym_assignment = 199,
  sym_augmented_assignment = 200,
  sym_pattern_list = 201,
  sym__right_hand_side = 202,
  sym_yield = 203,
  sym_attribute = 204,
  sym_subscript = 205,
  sym_slice = 206,
  sym_call = 207,
  sym_typed_parameter = 208,
  sym_type = 209,
  sym_splat_type = 210,
  sym_generic_type = 211,
  sym_union_type = 212,
  sym_constrained_type = 213,
  sym_member_type = 214,
  sym_keyword_argument = 215,
  sym_list = 216,
  sym_set = 217,
  sym_tuple = 218,
  sym_dictionary = 219,
  sym_pair = 220,
  sym_list_comprehension = 221,
  sym_dictionary_comprehension = 222,
  sym_set_comprehension = 223,
  sym_generator_expression = 224,
  sym__comprehension_clauses = 225,
  sym_parenthesized_expression = 226,
  sym__collection_elements = 227,
  sym_for_in_clause = 228,
  sym_if_clause = 229,
  sym_conditional_expression = 230,
  sym_concatenated_string = 231,
  sym_string = 232,
  sym_string_content = 233,
  sym_interpolation = 234,
  sym__f_expression = 235,
  sym__not_escape_sequence = 236,
  sym_format_specifier = 237,
  sym_await = 238,
  sym_positional_separator = 239,
  sym_keyword_separator = 240,
  aux_sym_module_repeat1 = 241,
  aux_sym__simple_statements_repeat1 = 242,
  aux_sym_import_prefix_repeat1 = 243,
  aux_sym__import_list_repeat1 = 244,
  aux_sym_print_statement_repeat1 = 245,
  aux_sym_assert_statement_repeat1 = 246,
  aux_sym_if_statement_repeat1 = 247,
  aux_sym_match_statement_repeat1 = 248,
  aux_sym__match_block_repeat1 = 249,
  aux_sym_case_clause_repeat1 = 250,
  aux_sym_try_statement_repeat1 = 251,
  aux_sym_with_clause_repeat1 = 252,
  aux_sym_global_statement_repeat1 = 253,
  aux_sym_type_parameter_repeat1 = 254,
  aux_sym_argument_list_repeat1 = 255,
  aux_sym_decorated_definition_repeat1 = 256,
  aux_sym_dotted_name_repeat1 = 257,
  aux_sym_union_pattern_repeat1 = 258,
  aux_sym_dict_pattern_repeat1 = 259,
  aux_sym__parameters_repeat1 = 260,
  aux_sym__patterns_repeat1 = 261,
  aux_sym_comparison_operator_repeat1 = 262,
  aux_sym_subscript_repeat1 = 263,
  aux_sym_dictionary_repeat1 = 264,
  aux_sym__comprehension_clauses_repeat1 = 265,
  aux_sym__collection_elements_repeat1 = 266,
  aux_sym_for_in_clause_repeat1 = 267,
  aux_sym_concatenated_string_repeat1 = 268,
  aux_sym_string_repeat1 = 269,
  aux_sym_string_content_repeat1 = 270,
  aux_sym_format_specifier_repeat1 = 271,
  alias_sym_as_pattern_target = 272,
  alias_sym_format_expression = 273,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_class] = "class",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_is] = "is",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_alias_statement] = "type_alias_statement",
  [sym_class_definition] = "class_definition",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym__not_in] = "not in",
  [sym__is_not] = "is not",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_alias_statement] = sym_type_alias_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym__not_in] = sym__not_in,
  [sym__is_not] = sym__is_not,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__not_in] = {
    .visible = true,
    .named = false,
  },
  [sym__is_not] = {
    .visible = true,
    .named = false,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_return_type = 24,
  field_right = 25,
  field_subject = 26,
  field_subscript = 27,
  field_superclasses = 28,
  field_type = 29,
  field_type_conversion = 30,
  field_type_parameters = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 17, .length = 1},
  [19] = {.index = 18, .length = 2},
  [20] = {.index = 20, .length = 2},
  [21] = {.index = 22, .length = 2},
  [22] = {.index = 24, .length = 3},
  [23] = {.index = 27, .length = 1},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 1},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 1},
  [28] = {.index = 34, .length = 1},
  [29] = {.index = 35, .length = 2},
  [30] = {.index = 37, .length = 2},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 2},
  [33] = {.index = 42, .length = 1},
  [35] = {.index = 43, .length = 1},
  [36] = {.index = 44, .length = 2},
  [37] = {.index = 46, .length = 1},
  [38] = {.index = 47, .length = 2},
  [39] = {.index = 49, .length = 1},
  [40] = {.index = 50, .length = 3},
  [41] = {.index = 53, .length = 2},
  [42] = {.index = 55, .length = 2},
  [43] = {.index = 57, .length = 2},
  [44] = {.index = 59, .length = 1},
  [45] = {.index = 60, .length = 2},
  [46] = {.index = 62, .length = 2},
  [47] = {.index = 64, .length = 2},
  [48] = {.index = 66, .length = 1},
  [49] = {.index = 67, .length = 2},
  [50] = {.index = 69, .length = 2},
  [52] = {.index = 71, .length = 2},
  [53] = {.index = 73, .length = 2},
  [54] = {.index = 75, .length = 1},
  [55] = {.index = 76, .length = 3},
  [56] = {.index = 79, .length = 3},
  [57] = {.index = 82, .length = 3},
  [58] = {.index = 85, .length = 3},
  [59] = {.index = 88, .length = 4},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 3},
  [62] = {.index = 96, .length = 3},
  [63] = {.index = 99, .length = 2},
  [64] = {.index = 101, .length = 3},
  [65] = {.index = 104, .length = 3},
  [66] = {.index = 107, .length = 3},
  [67] = {.index = 110, .length = 3},
  [68] = {.index = 113, .length = 3},
  [69] = {.index = 18, .length = 2},
  [70] = {.index = 116, .length = 1},
  [71] = {.index = 117, .length = 3},
  [72] = {.index = 120, .length = 2},
  [73] = {.index = 122, .length = 2},
  [74] = {.index = 124, .length = 2},
  [75] = {.index = 126, .length = 3},
  [76] = {.index = 129, .length = 1},
  [77] = {.index = 130, .length = 2},
  [78] = {.index = 132, .length = 4},
  [79] = {.index = 136, .length = 2},
  [80] = {.index = 138, .length = 4},
  [81] = {.index = 142, .length = 4},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 4},
  [84] = {.index = 151, .length = 2},
  [85] = {.index = 153, .length = 3},
  [86] = {.index = 156, .length = 3},
  [87] = {.index = 159, .length = 4},
  [89] = {.index = 163, .length = 4},
  [90] = {.index = 167, .length = 4},
  [91] = {.index = 171, .length = 4},
  [92] = {.index = 175, .length = 4},
  [93] = {.index = 179, .length = 4},
  [94] = {.index = 183, .length = 3},
  [95] = {.index = 186, .length = 3},
  [96] = {.index = 189, .length = 2},
  [97] = {.index = 191, .length = 3},
  [98] = {.index = 194, .length = 5},
  [99] = {.index = 199, .length = 3},
  [100] = {.index = 202, .length = 4},
  [101] = {.index = 206, .length = 4},
  [102] = {.index = 210, .length = 4},
  [103] = {.index = 214, .length = 4},
  [104] = {.index = 218, .length = 1},
  [106] = {.index = 219, .length = 4},
  [107] = {.index = 223, .length = 5},
  [108] = {.index = 228, .length = 5},
  [109] = {.index = 233, .length = 3},
  [110] = {.index = 236, .length = 2},
  [111] = {.index = 238, .length = 1},
  [112] = {.index = 239, .length = 4},
  [113] = {.index = 243, .length = 4},
  [114] = {.index = 247, .length = 4},
  [115] = {.index = 251, .length = 5},
  [116] = {.index = 256, .length = 5},
  [117] = {.index = 218, .length = 1},
  [118] = {.index = 261, .length = 5},
  [119] = {.index = 266, .length = 5},
  [120] = {.index = 271, .length = 4},
  [121] = {.index = 275, .length = 4},
  [122] = {.index = 279, .length = 2},
  [123] = {.index = 281, .length = 1},
  [124] = {.index = 282, .length = 2},
  [125] = {.index = 284, .length = 2},
  [126] = {.index = 286, .length = 5},
  [127] = {.index = 291, .length = 5},
  [128] = {.index = 296, .length = 5},
  [129] = {.index = 301, .length = 2},
  [131] = {.index = 303, .length = 6},
  [132] = {.index = 309, .length = 2},
  [133] = {.index = 311, .length = 2},
  [134] = {.index = 313, .length = 3},
  [135] = {.index = 316, .length = 1},
  [136] = {.index = 317, .length = 6},
  [137] = {.index = 301, .length = 2},
  [138] = {.index = 323, .length = 3},
  [139] = {.index = 326, .length = 2},
  [140] = {.index = 328, .length = 2},
  [141] = {.index = 330, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_alias, 2},
  [28] =
    {field_attribute, 2},
    {field_object, 0},
  [30] =
    {field_operators, 0},
  [31] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [33] =
    {field_expression, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_cause, 3},
  [47] =
    {field_condition, 1},
    {field_consequence, 3},
  [49] =
    {field_subject, 1},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [53] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [55] =
    {field_body, 3},
    {field_condition, 1},
  [57] =
    {field_body, 2},
    {field_body, 3},
  [59] =
    {field_body, 3},
  [60] =
    {field_left, 1},
    {field_right, 3},
  [62] =
    {field_body, 3},
    {field_name, 1},
  [64] =
    {field_key, 0},
    {field_value, 2},
  [66] =
    {field_type, 2},
  [67] =
    {field_body, 3},
    {field_parameters, 1},
  [69] =
    {field_subscript, 2},
    {field_value, 0},
  [71] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [73] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [75] =
    {field_alternative, 0},
  [76] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [79] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [82] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [85] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [88] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [92] =
    {field_body, 4},
  [93] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [96] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [99] =
    {field_body, 3},
    {field_body, 4},
  [101] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [104] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [107] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [110] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [113] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [116] =
    {field_subscript, 1},
  [117] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [120] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [122] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [124] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [126] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [129] =
    {field_name, 4, .inherited = true},
  [130] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [132] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [136] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [138] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [142] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_alternative, 1, .inherited = true},
  [147] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [151] =
    {field_body, 4},
    {field_body, 5},
  [153] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [156] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [163] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [167] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [171] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [175] =
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [179] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [183] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [186] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [189] =
    {field_left, 2},
    {field_right, 4},
  [191] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [194] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [199] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [202] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [206] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [210] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [214] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [218] =
    {field_value, 1},
  [219] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [223] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [228] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [233] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [236] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [238] =
    {field_consequence, 3},
  [239] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [243] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [247] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [251] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [256] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [261] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [266] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [271] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [275] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [279] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [281] =
    {field_consequence, 4},
  [282] =
    {field_consequence, 3},
    {field_consequence, 4},
  [284] =
    {field_consequence, 4},
    {field_guard, 2},
  [286] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [291] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [296] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [301] =
    {field_alias, 3},
    {field_value, 1},
  [303] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [309] =
    {field_consequence, 4},
    {field_consequence, 5},
  [311] =
    {field_consequence, 5},
    {field_guard, 3},
  [313] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [316] =
    {field_consequence, 5},
  [317] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [323] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [326] =
    {field_consequence, 5},
    {field_consequence, 6},
  [328] =
    {field_consequence, 6},
    {field_guard, 4},
  [330] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [17] = {
    [2] = sym_block,
  },
  [23] = {
    [2] = alias_sym_as_pattern_target,
  },
  [34] = {
    [1] = sym_parenthesized_expression,
  },
  [38] = {
    [3] = sym_block,
  },
  [42] = {
    [3] = sym_block,
  },
  [44] = {
    [3] = sym_block,
  },
  [46] = {
    [3] = sym_block,
  },
  [51] = {
    [0] = alias_sym_format_expression,
  },
  [55] = {
    [3] = sym_block,
  },
  [56] = {
    [3] = sym_block,
  },
  [60] = {
    [4] = sym_block,
  },
  [61] = {
    [3] = sym_block,
  },
  [64] = {
    [4] = sym_block,
  },
  [66] = {
    [4] = sym_block,
  },
  [67] = {
    [4] = sym_block,
  },
  [69] = {
    [0] = sym_identifier,
  },
  [78] = {
    [3] = sym_block,
  },
  [85] = {
    [5] = sym_block,
  },
  [86] = {
    [5] = sym_block,
  },
  [88] = {
    [2] = sym_block,
  },
  [90] = {
    [5] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [99] = {
    [6] = sym_block,
  },
  [101] = {
    [6] = sym_block,
  },
  [102] = {
    [5] = sym_block,
  },
  [104] = {
    [3] = sym_block,
  },
  [105] = {
    [3] = sym_block,
  },
  [106] = {
    [6] = sym_block,
  },
  [111] = {
    [3] = sym_block,
  },
  [112] = {
    [6] = sym_block,
  },
  [114] = {
    [7] = sym_block,
  },
  [119] = {
    [7] = sym_block,
  },
  [123] = {
    [4] = sym_block,
  },
  [125] = {
    [4] = sym_block,
  },
  [128] = {
    [8] = sym_block,
  },
  [129] = {
    [5] = sym_block,
  },
  [130] = {
    [5] = sym_block,
  },
  [133] = {
    [5] = sym_block,
  },
  [135] = {
    [5] = sym_block,
  },
  [140] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 27,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 13,
  [35] = 19,
  [36] = 20,
  [37] = 29,
  [38] = 38,
  [39] = 39,
  [40] = 30,
  [41] = 39,
  [42] = 3,
  [43] = 4,
  [44] = 5,
  [45] = 6,
  [46] = 7,
  [47] = 8,
  [48] = 9,
  [49] = 10,
  [50] = 11,
  [51] = 12,
  [52] = 14,
  [53] = 15,
  [54] = 16,
  [55] = 17,
  [56] = 18,
  [57] = 21,
  [58] = 22,
  [59] = 24,
  [60] = 25,
  [61] = 38,
  [62] = 62,
  [63] = 63,
  [64] = 62,
  [65] = 65,
  [66] = 65,
  [67] = 62,
  [68] = 62,
  [69] = 62,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 72,
  [77] = 75,
  [78] = 74,
  [79] = 73,
  [80] = 80,
  [81] = 80,
  [82] = 82,
  [83] = 82,
  [84] = 84,
  [85] = 85,
  [86] = 84,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 89,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 91,
  [99] = 90,
  [100] = 96,
  [101] = 97,
  [102] = 102,
  [103] = 102,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 104,
  [109] = 109,
  [110] = 105,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 106,
  [115] = 115,
  [116] = 116,
  [117] = 107,
  [118] = 85,
  [119] = 119,
  [120] = 120,
  [121] = 109,
  [122] = 92,
  [123] = 123,
  [124] = 111,
  [125] = 125,
  [126] = 93,
  [127] = 113,
  [128] = 115,
  [129] = 129,
  [130] = 120,
  [131] = 88,
  [132] = 95,
  [133] = 119,
  [134] = 134,
  [135] = 135,
  [136] = 135,
  [137] = 134,
  [138] = 134,
  [139] = 135,
  [140] = 135,
  [141] = 134,
  [142] = 134,
  [143] = 135,
  [144] = 144,
  [145] = 145,
  [146] = 145,
  [147] = 147,
  [148] = 148,
  [149] = 148,
  [150] = 150,
  [151] = 147,
  [152] = 145,
  [153] = 147,
  [154] = 148,
  [155] = 148,
  [156] = 148,
  [157] = 147,
  [158] = 150,
  [159] = 148,
  [160] = 160,
  [161] = 160,
  [162] = 162,
  [163] = 148,
  [164] = 160,
  [165] = 145,
  [166] = 150,
  [167] = 145,
  [168] = 162,
  [169] = 169,
  [170] = 150,
  [171] = 150,
  [172] = 147,
  [173] = 147,
  [174] = 148,
  [175] = 150,
  [176] = 150,
  [177] = 150,
  [178] = 169,
  [179] = 147,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 182,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 185,
  [188] = 182,
  [189] = 189,
  [190] = 185,
  [191] = 189,
  [192] = 185,
  [193] = 182,
  [194] = 189,
  [195] = 182,
  [196] = 185,
  [197] = 182,
  [198] = 189,
  [199] = 199,
  [200] = 189,
  [201] = 185,
  [202] = 182,
  [203] = 189,
  [204] = 185,
  [205] = 182,
  [206] = 189,
  [207] = 185,
  [208] = 182,
  [209] = 189,
  [210] = 185,
  [211] = 182,
  [212] = 182,
  [213] = 186,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 217,
  [219] = 217,
  [220] = 220,
  [221] = 220,
  [222] = 217,
  [223] = 220,
  [224] = 220,
  [225] = 216,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 228,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 214,
  [235] = 235,
  [236] = 215,
  [237] = 237,
  [238] = 238,
  [239] = 235,
  [240] = 240,
  [241] = 241,
  [242] = 232,
  [243] = 228,
  [244] = 244,
  [245] = 245,
  [246] = 235,
  [247] = 235,
  [248] = 248,
  [249] = 235,
  [250] = 227,
  [251] = 227,
  [252] = 235,
  [253] = 228,
  [254] = 235,
  [255] = 235,
  [256] = 256,
  [257] = 226,
  [258] = 226,
  [259] = 226,
  [260] = 240,
  [261] = 241,
  [262] = 248,
  [263] = 227,
  [264] = 264,
  [265] = 264,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 266,
  [273] = 267,
  [274] = 268,
  [275] = 269,
  [276] = 264,
  [277] = 266,
  [278] = 267,
  [279] = 270,
  [280] = 271,
  [281] = 268,
  [282] = 269,
  [283] = 264,
  [284] = 266,
  [285] = 267,
  [286] = 270,
  [287] = 271,
  [288] = 268,
  [289] = 269,
  [290] = 264,
  [291] = 267,
  [292] = 270,
  [293] = 271,
  [294] = 268,
  [295] = 269,
  [296] = 264,
  [297] = 266,
  [298] = 267,
  [299] = 270,
  [300] = 271,
  [301] = 268,
  [302] = 269,
  [303] = 268,
  [304] = 266,
  [305] = 267,
  [306] = 270,
  [307] = 271,
  [308] = 268,
  [309] = 269,
  [310] = 269,
  [311] = 266,
  [312] = 267,
  [313] = 270,
  [314] = 271,
  [315] = 270,
  [316] = 271,
  [317] = 266,
  [318] = 318,
  [319] = 319,
  [320] = 169,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 319,
  [326] = 322,
  [327] = 318,
  [328] = 319,
  [329] = 323,
  [330] = 330,
  [331] = 324,
  [332] = 323,
  [333] = 333,
  [334] = 321,
  [335] = 335,
  [336] = 324,
  [337] = 322,
  [338] = 318,
  [339] = 321,
  [340] = 256,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 342,
  [345] = 343,
  [346] = 256,
  [347] = 256,
  [348] = 341,
  [349] = 341,
  [350] = 342,
  [351] = 351,
  [352] = 341,
  [353] = 342,
  [354] = 341,
  [355] = 342,
  [356] = 341,
  [357] = 342,
  [358] = 342,
  [359] = 341,
  [360] = 343,
  [361] = 341,
  [362] = 342,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 364,
  [367] = 364,
  [368] = 363,
  [369] = 369,
  [370] = 370,
  [371] = 333,
  [372] = 147,
  [373] = 373,
  [374] = 374,
  [375] = 364,
  [376] = 363,
  [377] = 369,
  [378] = 378,
  [379] = 335,
  [380] = 364,
  [381] = 363,
  [382] = 369,
  [383] = 364,
  [384] = 364,
  [385] = 363,
  [386] = 369,
  [387] = 363,
  [388] = 369,
  [389] = 363,
  [390] = 364,
  [391] = 363,
  [392] = 369,
  [393] = 364,
  [394] = 363,
  [395] = 369,
  [396] = 364,
  [397] = 363,
  [398] = 369,
  [399] = 369,
  [400] = 369,
  [401] = 401,
  [402] = 402,
  [403] = 169,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 333,
  [408] = 408,
  [409] = 401,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 335,
  [415] = 413,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 402,
  [420] = 420,
  [421] = 405,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 169,
  [426] = 417,
  [427] = 405,
  [428] = 418,
  [429] = 429,
  [430] = 422,
  [431] = 411,
  [432] = 420,
  [433] = 420,
  [434] = 434,
  [435] = 435,
  [436] = 411,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 410,
  [441] = 333,
  [442] = 147,
  [443] = 378,
  [444] = 401,
  [445] = 422,
  [446] = 401,
  [447] = 447,
  [448] = 401,
  [449] = 335,
  [450] = 401,
  [451] = 401,
  [452] = 401,
  [453] = 401,
  [454] = 401,
  [455] = 169,
  [456] = 439,
  [457] = 424,
  [458] = 458,
  [459] = 459,
  [460] = 402,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 462,
  [468] = 333,
  [469] = 469,
  [470] = 463,
  [471] = 469,
  [472] = 335,
  [473] = 473,
  [474] = 461,
  [475] = 464,
  [476] = 473,
  [477] = 477,
  [478] = 466,
  [479] = 477,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 484,
  [496] = 485,
  [497] = 486,
  [498] = 487,
  [499] = 488,
  [500] = 500,
  [501] = 501,
  [502] = 491,
  [503] = 492,
  [504] = 504,
  [505] = 491,
  [506] = 484,
  [507] = 485,
  [508] = 486,
  [509] = 487,
  [510] = 488,
  [511] = 491,
  [512] = 492,
  [513] = 484,
  [514] = 485,
  [515] = 486,
  [516] = 487,
  [517] = 488,
  [518] = 491,
  [519] = 492,
  [520] = 484,
  [521] = 484,
  [522] = 485,
  [523] = 486,
  [524] = 487,
  [525] = 488,
  [526] = 491,
  [527] = 492,
  [528] = 484,
  [529] = 485,
  [530] = 486,
  [531] = 487,
  [532] = 488,
  [533] = 491,
  [534] = 492,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 500,
  [542] = 538,
  [543] = 504,
  [544] = 544,
  [545] = 544,
  [546] = 485,
  [547] = 547,
  [548] = 494,
  [549] = 537,
  [550] = 486,
  [551] = 487,
  [552] = 552,
  [553] = 488,
  [554] = 535,
  [555] = 489,
  [556] = 536,
  [557] = 537,
  [558] = 544,
  [559] = 559,
  [560] = 492,
  [561] = 561,
  [562] = 562,
  [563] = 535,
  [564] = 489,
  [565] = 536,
  [566] = 537,
  [567] = 567,
  [568] = 484,
  [569] = 535,
  [570] = 544,
  [571] = 485,
  [572] = 486,
  [573] = 487,
  [574] = 488,
  [575] = 536,
  [576] = 537,
  [577] = 489,
  [578] = 536,
  [579] = 579,
  [580] = 580,
  [581] = 491,
  [582] = 536,
  [583] = 537,
  [584] = 584,
  [585] = 536,
  [586] = 492,
  [587] = 482,
  [588] = 536,
  [589] = 480,
  [590] = 480,
  [591] = 480,
  [592] = 489,
  [593] = 480,
  [594] = 480,
  [595] = 480,
  [596] = 480,
  [597] = 481,
  [598] = 567,
  [599] = 599,
  [600] = 552,
  [601] = 601,
  [602] = 580,
  [603] = 501,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 607,
  [609] = 609,
  [610] = 610,
  [611] = 609,
  [612] = 612,
  [613] = 613,
  [614] = 606,
  [615] = 605,
  [616] = 613,
  [617] = 610,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 624,
  [629] = 629,
  [630] = 621,
  [631] = 631,
  [632] = 632,
  [633] = 627,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 626,
  [638] = 625,
  [639] = 639,
  [640] = 618,
  [641] = 620,
  [642] = 636,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 639,
  [647] = 644,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 643,
  [653] = 648,
  [654] = 649,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 656,
  [659] = 659,
  [660] = 660,
  [661] = 660,
  [662] = 662,
  [663] = 663,
  [664] = 629,
  [665] = 663,
  [666] = 634,
  [667] = 635,
  [668] = 622,
  [669] = 643,
  [670] = 660,
  [671] = 656,
  [672] = 643,
  [673] = 214,
  [674] = 618,
  [675] = 618,
  [676] = 215,
  [677] = 621,
  [678] = 621,
  [679] = 656,
  [680] = 660,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 682,
  [690] = 685,
  [691] = 691,
  [692] = 681,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 693,
  [697] = 697,
  [698] = 688,
  [699] = 695,
  [700] = 686,
  [701] = 687,
  [702] = 697,
  [703] = 694,
  [704] = 691,
  [705] = 684,
  [706] = 683,
  [707] = 707,
  [708] = 708,
  [709] = 707,
  [710] = 710,
  [711] = 710,
  [712] = 708,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 714,
  [751] = 718,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 717,
  [757] = 727,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 719,
  [763] = 742,
  [764] = 743,
  [765] = 765,
  [766] = 765,
  [767] = 767,
  [768] = 767,
  [769] = 769,
  [770] = 215,
  [771] = 771,
  [772] = 738,
  [773] = 769,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 214,
  [778] = 778,
  [779] = 732,
  [780] = 780,
  [781] = 746,
  [782] = 748,
  [783] = 753,
  [784] = 784,
  [785] = 760,
  [786] = 761,
  [787] = 776,
  [788] = 778,
  [789] = 780,
  [790] = 784,
  [791] = 791,
  [792] = 713,
  [793] = 752,
  [794] = 771,
  [795] = 795,
  [796] = 791,
  [797] = 797,
  [798] = 715,
  [799] = 725,
  [800] = 726,
  [801] = 749,
  [802] = 802,
  [803] = 803,
  [804] = 723,
  [805] = 735,
  [806] = 740,
  [807] = 741,
  [808] = 716,
  [809] = 720,
  [810] = 721,
  [811] = 722,
  [812] = 724,
  [813] = 728,
  [814] = 729,
  [815] = 730,
  [816] = 731,
  [817] = 802,
  [818] = 734,
  [819] = 797,
  [820] = 736,
  [821] = 803,
  [822] = 737,
  [823] = 739,
  [824] = 795,
  [825] = 758,
  [826] = 774,
  [827] = 733,
  [828] = 759,
  [829] = 754,
  [830] = 744,
  [831] = 745,
  [832] = 747,
  [833] = 755,
  [834] = 774,
  [835] = 733,
  [836] = 775,
  [837] = 837,
  [838] = 837,
  [839] = 837,
  [840] = 837,
  [841] = 837,
  [842] = 837,
  [843] = 843,
  [844] = 843,
  [845] = 845,
  [846] = 846,
  [847] = 846,
  [848] = 846,
  [849] = 846,
  [850] = 846,
  [851] = 846,
  [852] = 846,
  [853] = 846,
  [854] = 854,
  [855] = 855,
  [856] = 854,
  [857] = 845,
  [858] = 858,
  [859] = 855,
  [860] = 860,
  [861] = 854,
  [862] = 862,
  [863] = 862,
  [864] = 864,
  [865] = 865,
  [866] = 864,
  [867] = 858,
  [868] = 860,
  [869] = 869,
  [870] = 870,
  [871] = 870,
  [872] = 862,
  [873] = 854,
  [874] = 860,
  [875] = 875,
  [876] = 862,
  [877] = 860,
  [878] = 878,
  [879] = 878,
  [880] = 862,
  [881] = 865,
  [882] = 855,
  [883] = 865,
  [884] = 864,
  [885] = 885,
  [886] = 864,
  [887] = 885,
  [888] = 858,
  [889] = 860,
  [890] = 869,
  [891] = 862,
  [892] = 854,
  [893] = 845,
  [894] = 858,
  [895] = 885,
  [896] = 855,
  [897] = 865,
  [898] = 864,
  [899] = 870,
  [900] = 878,
  [901] = 845,
  [902] = 864,
  [903] = 860,
  [904] = 860,
  [905] = 858,
  [906] = 870,
  [907] = 865,
  [908] = 860,
  [909] = 875,
  [910] = 870,
  [911] = 878,
  [912] = 858,
  [913] = 869,
  [914] = 854,
  [915] = 855,
  [916] = 860,
  [917] = 862,
  [918] = 869,
  [919] = 864,
  [920] = 870,
  [921] = 865,
  [922] = 870,
  [923] = 885,
  [924] = 885,
  [925] = 878,
  [926] = 878,
  [927] = 854,
  [928] = 869,
  [929] = 878,
  [930] = 855,
  [931] = 865,
  [932] = 858,
  [933] = 858,
  [934] = 869,
  [935] = 869,
  [936] = 855,
  [937] = 864,
  [938] = 865,
  [939] = 860,
  [940] = 870,
  [941] = 860,
  [942] = 860,
  [943] = 860,
  [944] = 862,
  [945] = 878,
  [946] = 869,
  [947] = 854,
  [948] = 855,
  [949] = 845,
  [950] = 845,
  [951] = 951,
  [952] = 845,
  [953] = 845,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 954,
  [959] = 959,
  [960] = 951,
  [961] = 951,
  [962] = 962,
  [963] = 845,
  [964] = 955,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 955,
  [969] = 954,
  [970] = 951,
  [971] = 955,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 954,
  [976] = 976,
  [977] = 956,
  [978] = 955,
  [979] = 962,
  [980] = 980,
  [981] = 951,
  [982] = 972,
  [983] = 972,
  [984] = 954,
  [985] = 954,
  [986] = 986,
  [987] = 659,
  [988] = 632,
  [989] = 845,
  [990] = 962,
  [991] = 974,
  [992] = 955,
  [993] = 973,
  [994] = 845,
  [995] = 954,
  [996] = 657,
  [997] = 959,
  [998] = 951,
  [999] = 956,
  [1000] = 655,
  [1001] = 965,
  [1002] = 1002,
  [1003] = 966,
  [1004] = 965,
  [1005] = 959,
  [1006] = 951,
  [1007] = 845,
  [1008] = 959,
  [1009] = 973,
  [1010] = 967,
  [1011] = 972,
  [1012] = 1012,
  [1013] = 955,
  [1014] = 974,
  [1015] = 957,
  [1016] = 957,
  [1017] = 623,
  [1018] = 1018,
  [1019] = 662,
  [1020] = 974,
  [1021] = 957,
  [1022] = 956,
  [1023] = 962,
  [1024] = 966,
  [1025] = 967,
  [1026] = 966,
  [1027] = 965,
  [1028] = 967,
  [1029] = 631,
  [1030] = 973,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 655,
  [1034] = 659,
  [1035] = 662,
  [1036] = 631,
  [1037] = 632,
  [1038] = 612,
  [1039] = 651,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1031,
  [1043] = 1002,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 986,
  [1047] = 1047,
  [1048] = 976,
  [1049] = 1031,
  [1050] = 1002,
  [1051] = 959,
  [1052] = 986,
  [1053] = 980,
  [1054] = 1018,
  [1055] = 1012,
  [1056] = 974,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 976,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 986,
  [1070] = 959,
  [1071] = 974,
  [1072] = 976,
  [1073] = 956,
  [1074] = 965,
  [1075] = 973,
  [1076] = 957,
  [1077] = 962,
  [1078] = 966,
  [1079] = 967,
  [1080] = 972,
  [1081] = 954,
  [1082] = 980,
  [1083] = 1018,
  [1084] = 1012,
  [1085] = 956,
  [1086] = 955,
  [1087] = 965,
  [1088] = 951,
  [1089] = 973,
  [1090] = 957,
  [1091] = 962,
  [1092] = 966,
  [1093] = 967,
  [1094] = 972,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 605,
  [1109] = 607,
  [1110] = 645,
  [1111] = 650,
  [1112] = 980,
  [1113] = 1018,
  [1114] = 1012,
  [1115] = 959,
  [1116] = 974,
  [1117] = 1117,
  [1118] = 1064,
  [1119] = 1065,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 623,
  [1123] = 956,
  [1124] = 965,
  [1125] = 973,
  [1126] = 957,
  [1127] = 962,
  [1128] = 966,
  [1129] = 967,
  [1130] = 972,
  [1131] = 657,
  [1132] = 966,
  [1133] = 1040,
  [1134] = 1095,
  [1135] = 1097,
  [1136] = 1103,
  [1137] = 1041,
  [1138] = 1044,
  [1139] = 605,
  [1140] = 1057,
  [1141] = 1031,
  [1142] = 1096,
  [1143] = 1002,
  [1144] = 1066,
  [1145] = 1104,
  [1146] = 1105,
  [1147] = 1098,
  [1148] = 1100,
  [1149] = 1067,
  [1150] = 1068,
  [1151] = 1040,
  [1152] = 1041,
  [1153] = 1044,
  [1154] = 1057,
  [1155] = 1106,
  [1156] = 976,
  [1157] = 1107,
  [1158] = 607,
  [1159] = 1120,
  [1160] = 1096,
  [1161] = 1104,
  [1162] = 1105,
  [1163] = 1106,
  [1164] = 1107,
  [1165] = 1117,
  [1166] = 1121,
  [1167] = 1060,
  [1168] = 1061,
  [1169] = 1063,
  [1170] = 1117,
  [1171] = 1101,
  [1172] = 1102,
  [1173] = 1121,
  [1174] = 1060,
  [1175] = 1061,
  [1176] = 1063,
  [1177] = 1101,
  [1178] = 1102,
  [1179] = 623,
  [1180] = 1099,
  [1181] = 624,
  [1182] = 980,
  [1183] = 625,
  [1184] = 1018,
  [1185] = 626,
  [1186] = 645,
  [1187] = 650,
  [1188] = 657,
  [1189] = 655,
  [1190] = 659,
  [1191] = 662,
  [1192] = 631,
  [1193] = 632,
  [1194] = 651,
  [1195] = 986,
  [1196] = 651,
  [1197] = 1047,
  [1198] = 980,
  [1199] = 1018,
  [1200] = 1012,
  [1201] = 959,
  [1202] = 974,
  [1203] = 623,
  [1204] = 612,
  [1205] = 627,
  [1206] = 976,
  [1207] = 1067,
  [1208] = 1068,
  [1209] = 1095,
  [1210] = 956,
  [1211] = 965,
  [1212] = 973,
  [1213] = 957,
  [1214] = 962,
  [1215] = 1098,
  [1216] = 1100,
  [1217] = 972,
  [1218] = 1097,
  [1219] = 1103,
  [1220] = 645,
  [1221] = 650,
  [1222] = 986,
  [1223] = 645,
  [1224] = 650,
  [1225] = 605,
  [1226] = 607,
  [1227] = 1012,
  [1228] = 980,
  [1229] = 651,
  [1230] = 651,
  [1231] = 657,
  [1232] = 1018,
  [1233] = 1066,
  [1234] = 1064,
  [1235] = 1065,
  [1236] = 1120,
  [1237] = 655,
  [1238] = 659,
  [1239] = 662,
  [1240] = 1012,
  [1241] = 1095,
  [1242] = 1098,
  [1243] = 1100,
  [1244] = 1040,
  [1245] = 1041,
  [1246] = 1044,
  [1247] = 631,
  [1248] = 632,
  [1249] = 623,
  [1250] = 1057,
  [1251] = 1097,
  [1252] = 1103,
  [1253] = 612,
  [1254] = 986,
  [1255] = 1096,
  [1256] = 1104,
  [1257] = 1105,
  [1258] = 1106,
  [1259] = 1047,
  [1260] = 1107,
  [1261] = 1117,
  [1262] = 1121,
  [1263] = 1031,
  [1264] = 1002,
  [1265] = 657,
  [1266] = 1060,
  [1267] = 1061,
  [1268] = 976,
  [1269] = 1063,
  [1270] = 655,
  [1271] = 659,
  [1272] = 1067,
  [1273] = 1068,
  [1274] = 662,
  [1275] = 1101,
  [1276] = 1102,
  [1277] = 631,
  [1278] = 632,
  [1279] = 1099,
  [1280] = 1099,
  [1281] = 1066,
  [1282] = 651,
  [1283] = 1047,
  [1284] = 967,
  [1285] = 1041,
  [1286] = 1040,
  [1287] = 1041,
  [1288] = 1044,
  [1289] = 1066,
  [1290] = 1095,
  [1291] = 1098,
  [1292] = 1100,
  [1293] = 1040,
  [1294] = 1041,
  [1295] = 1060,
  [1296] = 1057,
  [1297] = 1097,
  [1298] = 655,
  [1299] = 659,
  [1300] = 662,
  [1301] = 1047,
  [1302] = 631,
  [1303] = 632,
  [1304] = 1096,
  [1305] = 1104,
  [1306] = 1105,
  [1307] = 1106,
  [1308] = 1107,
  [1309] = 1117,
  [1310] = 1121,
  [1311] = 1060,
  [1312] = 1061,
  [1313] = 1063,
  [1314] = 1101,
  [1315] = 1102,
  [1316] = 1101,
  [1317] = 1067,
  [1318] = 1068,
  [1319] = 1103,
  [1320] = 1047,
  [1321] = 1057,
  [1322] = 1058,
  [1323] = 1032,
  [1324] = 1059,
  [1325] = 645,
  [1326] = 650,
  [1327] = 619,
  [1328] = 623,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1099,
  [1332] = 1102,
  [1333] = 657,
  [1334] = 655,
  [1335] = 659,
  [1336] = 662,
  [1337] = 631,
  [1338] = 632,
  [1339] = 986,
  [1340] = 624,
  [1341] = 624,
  [1342] = 651,
  [1343] = 625,
  [1344] = 976,
  [1345] = 624,
  [1346] = 625,
  [1347] = 626,
  [1348] = 626,
  [1349] = 651,
  [1350] = 627,
  [1351] = 623,
  [1352] = 625,
  [1353] = 645,
  [1354] = 1096,
  [1355] = 1104,
  [1356] = 1105,
  [1357] = 1106,
  [1358] = 1107,
  [1359] = 1117,
  [1360] = 1121,
  [1361] = 650,
  [1362] = 651,
  [1363] = 1060,
  [1364] = 1061,
  [1365] = 1063,
  [1366] = 626,
  [1367] = 1066,
  [1368] = 627,
  [1369] = 1063,
  [1370] = 1067,
  [1371] = 1068,
  [1372] = 1047,
  [1373] = 1101,
  [1374] = 1102,
  [1375] = 1067,
  [1376] = 1068,
  [1377] = 1099,
  [1378] = 651,
  [1379] = 1098,
  [1380] = 1100,
  [1381] = 1099,
  [1382] = 1095,
  [1383] = 1097,
  [1384] = 657,
  [1385] = 1103,
  [1386] = 1066,
  [1387] = 645,
  [1388] = 650,
  [1389] = 1098,
  [1390] = 1100,
  [1391] = 980,
  [1392] = 1040,
  [1393] = 1061,
  [1394] = 1044,
  [1395] = 1018,
  [1396] = 1057,
  [1397] = 1012,
  [1398] = 1095,
  [1399] = 1097,
  [1400] = 627,
  [1401] = 1103,
  [1402] = 1096,
  [1403] = 1104,
  [1404] = 1105,
  [1405] = 1106,
  [1406] = 1107,
  [1407] = 1117,
  [1408] = 1121,
  [1409] = 619,
  [1410] = 1044,
  [1411] = 1044,
  [1412] = 1061,
  [1413] = 1120,
  [1414] = 1063,
  [1415] = 650,
  [1416] = 1068,
  [1417] = 1066,
  [1418] = 1101,
  [1419] = 1102,
  [1420] = 1067,
  [1421] = 1064,
  [1422] = 1098,
  [1423] = 1064,
  [1424] = 1100,
  [1425] = 1065,
  [1426] = 1095,
  [1427] = 1120,
  [1428] = 1040,
  [1429] = 1041,
  [1430] = 645,
  [1431] = 1060,
  [1432] = 657,
  [1433] = 655,
  [1434] = 659,
  [1435] = 662,
  [1436] = 631,
  [1437] = 632,
  [1438] = 1097,
  [1439] = 1057,
  [1440] = 1103,
  [1441] = 1099,
  [1442] = 1065,
  [1443] = 1120,
  [1444] = 1047,
  [1445] = 619,
  [1446] = 619,
  [1447] = 1096,
  [1448] = 1104,
  [1449] = 651,
  [1450] = 1105,
  [1451] = 1064,
  [1452] = 1065,
  [1453] = 1121,
  [1454] = 1106,
  [1455] = 1107,
  [1456] = 1117,
  [1457] = 623,
  [1458] = 651,
  [1459] = 662,
  [1460] = 631,
  [1461] = 632,
  [1462] = 650,
  [1463] = 1329,
  [1464] = 626,
  [1465] = 645,
  [1466] = 627,
  [1467] = 1330,
  [1468] = 623,
  [1469] = 657,
  [1470] = 655,
  [1471] = 651,
  [1472] = 651,
  [1473] = 651,
  [1474] = 659,
  [1475] = 624,
  [1476] = 625,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1485,
  [1489] = 1480,
  [1490] = 1479,
  [1491] = 1481,
  [1492] = 1482,
  [1493] = 1483,
  [1494] = 1484,
  [1495] = 1487,
  [1496] = 1486,
  [1497] = 1487,
  [1498] = 1480,
  [1499] = 1479,
  [1500] = 1481,
  [1501] = 1482,
  [1502] = 1480,
  [1503] = 1479,
  [1504] = 1486,
  [1505] = 1487,
  [1506] = 1481,
  [1507] = 1483,
  [1508] = 1484,
  [1509] = 1483,
  [1510] = 1484,
  [1511] = 1482,
  [1512] = 1485,
  [1513] = 1486,
  [1514] = 1485,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1516,
  [1518] = 1516,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1523,
  [1525] = 1525,
  [1526] = 1521,
  [1527] = 1525,
  [1528] = 1522,
  [1529] = 1523,
  [1530] = 1520,
  [1531] = 1521,
  [1532] = 1521,
  [1533] = 1525,
  [1534] = 1522,
  [1535] = 1523,
  [1536] = 1520,
  [1537] = 1520,
  [1538] = 1525,
  [1539] = 1522,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1541,
  [1543] = 1543,
  [1544] = 1541,
  [1545] = 1545,
  [1546] = 1543,
  [1547] = 1543,
  [1548] = 1541,
  [1549] = 1543,
  [1550] = 1550,
  [1551] = 1550,
  [1552] = 1545,
  [1553] = 1550,
  [1554] = 1545,
  [1555] = 1545,
  [1556] = 1550,
  [1557] = 1550,
  [1558] = 1545,
  [1559] = 1545,
  [1560] = 1545,
  [1561] = 1550,
  [1562] = 1550,
  [1563] = 1330,
  [1564] = 1550,
  [1565] = 627,
  [1566] = 1566,
  [1567] = 625,
  [1568] = 1545,
  [1569] = 624,
  [1570] = 1570,
  [1571] = 626,
  [1572] = 1329,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 645,
  [1576] = 1576,
  [1577] = 650,
  [1578] = 1578,
  [1579] = 651,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 627,
  [1583] = 1329,
  [1584] = 1584,
  [1585] = 1330,
  [1586] = 624,
  [1587] = 625,
  [1588] = 1581,
  [1589] = 624,
  [1590] = 1581,
  [1591] = 1330,
  [1592] = 627,
  [1593] = 1593,
  [1594] = 627,
  [1595] = 625,
  [1596] = 1329,
  [1597] = 1597,
  [1598] = 1581,
  [1599] = 651,
  [1600] = 1581,
  [1601] = 626,
  [1602] = 1602,
  [1603] = 1581,
  [1604] = 624,
  [1605] = 1578,
  [1606] = 1581,
  [1607] = 1581,
  [1608] = 1581,
  [1609] = 1329,
  [1610] = 1580,
  [1611] = 625,
  [1612] = 626,
  [1613] = 650,
  [1614] = 626,
  [1615] = 645,
  [1616] = 1573,
  [1617] = 1330,
  [1618] = 1581,
  [1619] = 1619,
  [1620] = 1576,
  [1621] = 1619,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1623,
  [1625] = 1584,
  [1626] = 1597,
  [1627] = 1622,
  [1628] = 1622,
  [1629] = 1622,
  [1630] = 1602,
  [1631] = 1622,
  [1632] = 1622,
  [1633] = 1622,
  [1634] = 1634,
  [1635] = 1622,
  [1636] = 1593,
  [1637] = 1619,
  [1638] = 1574,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1640,
  [1643] = 1641,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1646,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1650,
  [1656] = 1650,
  [1657] = 1650,
  [1658] = 1658,
  [1659] = 1650,
  [1660] = 1650,
  [1661] = 1650,
  [1662] = 1650,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1667,
  [1670] = 1648,
  [1671] = 1663,
  [1672] = 1666,
  [1673] = 1653,
  [1674] = 1664,
  [1675] = 1667,
  [1676] = 1665,
  [1677] = 1668,
  [1678] = 1665,
  [1679] = 1667,
  [1680] = 1654,
  [1681] = 1666,
  [1682] = 1667,
  [1683] = 1665,
  [1684] = 1668,
  [1685] = 1685,
  [1686] = 1666,
  [1687] = 1687,
  [1688] = 1668,
  [1689] = 1667,
  [1690] = 1668,
  [1691] = 1666,
  [1692] = 1667,
  [1693] = 1665,
  [1694] = 1658,
  [1695] = 1668,
  [1696] = 1666,
  [1697] = 1697,
  [1698] = 1667,
  [1699] = 1665,
  [1700] = 1668,
  [1701] = 1668,
  [1702] = 1666,
  [1703] = 1667,
  [1704] = 1651,
  [1705] = 1705,
  [1706] = 1666,
  [1707] = 1705,
  [1708] = 1666,
  [1709] = 1705,
  [1710] = 1649,
  [1711] = 1652,
  [1712] = 1705,
  [1713] = 1705,
  [1714] = 1705,
  [1715] = 1705,
  [1716] = 1705,
  [1717] = 1665,
  [1718] = 1665,
  [1719] = 1663,
  [1720] = 1720,
  [1721] = 1648,
  [1722] = 1649,
  [1723] = 1649,
  [1724] = 1724,
  [1725] = 1658,
  [1726] = 1651,
  [1727] = 1653,
  [1728] = 1652,
  [1729] = 1664,
  [1730] = 1654,
  [1731] = 1653,
  [1732] = 1658,
  [1733] = 1724,
  [1734] = 1734,
  [1735] = 1663,
  [1736] = 1651,
  [1737] = 1652,
  [1738] = 1664,
  [1739] = 1648,
  [1740] = 1654,
  [1741] = 1663,
  [1742] = 1652,
  [1743] = 1664,
  [1744] = 1664,
  [1745] = 1658,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1649,
  [1749] = 1654,
  [1750] = 1654,
  [1751] = 1648,
  [1752] = 1653,
  [1753] = 1663,
  [1754] = 1649,
  [1755] = 1648,
  [1756] = 1724,
  [1757] = 1653,
  [1758] = 1663,
  [1759] = 1648,
  [1760] = 1658,
  [1761] = 1651,
  [1762] = 1724,
  [1763] = 1658,
  [1764] = 1652,
  [1765] = 1664,
  [1766] = 1654,
  [1767] = 1767,
  [1768] = 1651,
  [1769] = 1649,
  [1770] = 1770,
  [1771] = 1651,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1652,
  [1775] = 1775,
  [1776] = 1653,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1777,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1779,
  [1785] = 1773,
  [1786] = 1777,
  [1787] = 1746,
  [1788] = 1663,
  [1789] = 1789,
  [1790] = 1648,
  [1791] = 1791,
  [1792] = 1777,
  [1793] = 1734,
  [1794] = 1651,
  [1795] = 1652,
  [1796] = 1664,
  [1797] = 1654,
  [1798] = 1779,
  [1799] = 1799,
  [1800] = 1777,
  [1801] = 1801,
  [1802] = 1782,
  [1803] = 1777,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1746,
  [1807] = 1649,
  [1808] = 1658,
  [1809] = 1777,
  [1810] = 1653,
  [1811] = 1777,
  [1812] = 1777,
  [1813] = 1777,
  [1814] = 1814,
  [1815] = 1746,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1817,
  [1820] = 1814,
  [1821] = 1782,
  [1822] = 1814,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1767,
  [1829] = 1829,
  [1830] = 1747,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1829,
  [1834] = 1772,
  [1835] = 1772,
  [1836] = 1829,
  [1837] = 1791,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1840,
  [1844] = 1747,
  [1845] = 1845,
  [1846] = 1842,
  [1847] = 1847,
  [1848] = 1848,
  [1849] = 1849,
  [1850] = 1826,
  [1851] = 1848,
  [1852] = 1824,
  [1853] = 1791,
  [1854] = 1849,
  [1855] = 1829,
  [1856] = 1829,
  [1857] = 1734,
  [1858] = 1838,
  [1859] = 1838,
  [1860] = 1829,
  [1861] = 1772,
  [1862] = 1734,
  [1863] = 1767,
  [1864] = 1767,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1848,
  [1868] = 1829,
  [1869] = 1829,
  [1870] = 1747,
  [1871] = 1840,
  [1872] = 1824,
  [1873] = 1791,
  [1874] = 1772,
  [1875] = 1875,
  [1876] = 1876,
  [1877] = 1877,
  [1878] = 1878,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1878,
  [1885] = 1881,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1574,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1888,
  [1895] = 1895,
  [1896] = 1789,
  [1897] = 1897,
  [1898] = 1770,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 1832,
  [1906] = 1875,
  [1907] = 1892,
  [1908] = 1878,
  [1909] = 1909,
  [1910] = 1839,
  [1911] = 1576,
  [1912] = 1912,
  [1913] = 1773,
  [1914] = 1895,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1832,
  [1920] = 1903,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1773,
  [1924] = 1924,
  [1925] = 1747,
  [1926] = 1921,
  [1927] = 1770,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1876,
  [1931] = 1895,
  [1932] = 1912,
  [1933] = 1879,
  [1934] = 1934,
  [1935] = 1928,
  [1936] = 1936,
  [1937] = 1912,
  [1938] = 1773,
  [1939] = 1921,
  [1940] = 1940,
  [1941] = 1839,
  [1942] = 1875,
  [1943] = 1929,
  [1944] = 1944,
  [1945] = 1895,
  [1946] = 1946,
  [1947] = 1818,
  [1948] = 1948,
  [1949] = 1818,
  [1950] = 1880,
  [1951] = 1951,
  [1952] = 1952,
  [1953] = 1892,
  [1954] = 1882,
  [1955] = 1929,
  [1956] = 1956,
  [1957] = 1888,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1901,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 1818,
  [1966] = 1961,
  [1967] = 1883,
  [1968] = 1882,
  [1969] = 1936,
  [1970] = 1970,
  [1971] = 1901,
  [1972] = 1839,
  [1973] = 1922,
  [1974] = 1879,
  [1975] = 1958,
  [1976] = 1832,
  [1977] = 1956,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1767,
  [1981] = 1909,
  [1982] = 1770,
  [1983] = 1983,
  [1984] = 1964,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1883,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1989,
  [1991] = 1991,
  [1992] = 1989,
  [1993] = 1993,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1881,
  [1997] = 1997,
  [1998] = 1998,
  [1999] = 1999,
  [2000] = 1934,
  [2001] = 2001,
  [2002] = 1989,
  [2003] = 2003,
  [2004] = 1964,
  [2005] = 2005,
  [2006] = 1989,
  [2007] = 2007,
  [2008] = 1840,
  [2009] = 1909,
  [2010] = 1956,
  [2011] = 1961,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 1998,
  [2018] = 2018,
  [2019] = 1921,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 1818,
  [2025] = 1887,
  [2026] = 1909,
  [2027] = 2027,
  [2028] = 1970,
  [2029] = 1989,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 1887,
  [2033] = 2033,
  [2034] = 2016,
  [2035] = 1989,
  [2036] = 2027,
  [2037] = 2013,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2031,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 2045,
  [2046] = 1922,
  [2047] = 1978,
  [2048] = 1978,
  [2049] = 1944,
  [2050] = 1918,
  [2051] = 1944,
  [2052] = 2005,
  [2053] = 1593,
  [2054] = 1934,
  [2055] = 2014,
  [2056] = 1964,
  [2057] = 1999,
  [2058] = 2031,
  [2059] = 2059,
  [2060] = 2022,
  [2061] = 2031,
  [2062] = 2062,
  [2063] = 1944,
  [2064] = 1602,
  [2065] = 2005,
  [2066] = 2014,
  [2067] = 1887,
  [2068] = 1597,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 1989,
  [2072] = 2072,
  [2073] = 1879,
  [2074] = 1922,
  [2075] = 2072,
  [2076] = 1889,
  [2077] = 2077,
  [2078] = 1918,
  [2079] = 2023,
  [2080] = 1876,
  [2081] = 1956,
  [2082] = 1961,
  [2083] = 1876,
  [2084] = 1883,
  [2085] = 1881,
  [2086] = 2020,
  [2087] = 1918,
  [2088] = 1584,
  [2089] = 2089,
  [2090] = 1978,
  [2091] = 2091,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2072,
  [2095] = 1924,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2098,
  [2099] = 1901,
  [2100] = 2100,
  [2101] = 1934,
  [2102] = 2102,
  [2103] = 2102,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2105,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 1993,
  [2121] = 1998,
  [2122] = 2018,
  [2123] = 2044,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 1983,
  [2127] = 2093,
  [2128] = 2097,
  [2129] = 1995,
  [2130] = 1997,
  [2131] = 2007,
  [2132] = 2132,
  [2133] = 1994,
  [2134] = 2012,
  [2135] = 2033,
  [2136] = 2059,
  [2137] = 2077,
  [2138] = 1986,
  [2139] = 2030,
  [2140] = 2089,
  [2141] = 2062,
  [2142] = 2043,
  [2143] = 1985,
  [2144] = 2001,
  [2145] = 2102,
  [2146] = 2015,
  [2147] = 2147,
  [2148] = 2118,
  [2149] = 2119,
  [2150] = 2150,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2125,
  [2154] = 2154,
  [2155] = 1993,
  [2156] = 1998,
  [2157] = 2018,
  [2158] = 2044,
  [2159] = 1988,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2118,
  [2164] = 2119,
  [2165] = 1983,
  [2166] = 2093,
  [2167] = 2097,
  [2168] = 1995,
  [2169] = 1997,
  [2170] = 2125,
  [2171] = 2007,
  [2172] = 2100,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2012,
  [2177] = 2033,
  [2178] = 2059,
  [2179] = 2077,
  [2180] = 1986,
  [2181] = 2030,
  [2182] = 2089,
  [2183] = 2062,
  [2184] = 2043,
  [2185] = 1985,
  [2186] = 2001,
  [2187] = 2102,
  [2188] = 2118,
  [2189] = 2015,
  [2190] = 2119,
  [2191] = 1993,
  [2192] = 2018,
  [2193] = 2044,
  [2194] = 2091,
  [2195] = 1983,
  [2196] = 2093,
  [2197] = 2097,
  [2198] = 1995,
  [2199] = 1997,
  [2200] = 2007,
  [2201] = 1994,
  [2202] = 2012,
  [2203] = 2033,
  [2204] = 2059,
  [2205] = 2077,
  [2206] = 1986,
  [2207] = 2030,
  [2208] = 2089,
  [2209] = 2062,
  [2210] = 2043,
  [2211] = 1985,
  [2212] = 2001,
  [2213] = 2015,
  [2214] = 2214,
  [2215] = 2110,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 2104,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2222,
  [2223] = 2223,
  [2224] = 2224,
  [2225] = 2038,
  [2226] = 2045,
  [2227] = 2218,
  [2228] = 2107,
  [2229] = 2125,
  [2230] = 2230,
  [2231] = 1994,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2232,
  [2243] = 1960,
  [2244] = 1915,
  [2245] = 2233,
  [2246] = 1951,
  [2247] = 986,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2236,
  [2254] = 2150,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 2262,
  [2263] = 2263,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 1893,
  [2268] = 2240,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 2271,
  [2272] = 1979,
  [2273] = 2273,
  [2274] = 2113,
  [2275] = 2275,
  [2276] = 2234,
  [2277] = 1959,
  [2278] = 2278,
  [2279] = 2237,
  [2280] = 2280,
  [2281] = 976,
  [2282] = 2240,
  [2283] = 2283,
  [2284] = 2234,
  [2285] = 2241,
  [2286] = 2232,
  [2287] = 2280,
  [2288] = 2233,
  [2289] = 2283,
  [2290] = 2248,
  [2291] = 1889,
  [2292] = 2250,
  [2293] = 2293,
  [2294] = 2251,
  [2295] = 2252,
  [2296] = 2296,
  [2297] = 2236,
  [2298] = 2298,
  [2299] = 1891,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2258,
  [2304] = 2260,
  [2305] = 2150,
  [2306] = 2261,
  [2307] = 2307,
  [2308] = 2262,
  [2309] = 2263,
  [2310] = 2257,
  [2311] = 2230,
  [2312] = 2175,
  [2313] = 2106,
  [2314] = 2264,
  [2315] = 1970,
  [2316] = 2273,
  [2317] = 2317,
  [2318] = 2238,
  [2319] = 2270,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2273,
  [2323] = 2323,
  [2324] = 2234,
  [2325] = 2239,
  [2326] = 2326,
  [2327] = 2237,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2240,
  [2331] = 2258,
  [2332] = 2241,
  [2333] = 2232,
  [2334] = 2334,
  [2335] = 2233,
  [2336] = 2248,
  [2337] = 2248,
  [2338] = 2250,
  [2339] = 2174,
  [2340] = 2251,
  [2341] = 2252,
  [2342] = 2250,
  [2343] = 2328,
  [2344] = 2344,
  [2345] = 2334,
  [2346] = 2346,
  [2347] = 2320,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2321,
  [2351] = 2251,
  [2352] = 2273,
  [2353] = 2264,
  [2354] = 2252,
  [2355] = 2150,
  [2356] = 2234,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 2240,
  [2360] = 2258,
  [2361] = 2241,
  [2362] = 2362,
  [2363] = 2233,
  [2364] = 2248,
  [2365] = 2260,
  [2366] = 2250,
  [2367] = 2367,
  [2368] = 2232,
  [2369] = 2252,
  [2370] = 2261,
  [2371] = 2161,
  [2372] = 2280,
  [2373] = 2262,
  [2374] = 2263,
  [2375] = 2162,
  [2376] = 2248,
  [2377] = 2175,
  [2378] = 2273,
  [2379] = 2234,
  [2380] = 2259,
  [2381] = 2240,
  [2382] = 2250,
  [2383] = 2241,
  [2384] = 2232,
  [2385] = 2251,
  [2386] = 2233,
  [2387] = 2252,
  [2388] = 2248,
  [2389] = 2367,
  [2390] = 2250,
  [2391] = 2264,
  [2392] = 2251,
  [2393] = 2252,
  [2394] = 2230,
  [2395] = 2175,
  [2396] = 2302,
  [2397] = 2346,
  [2398] = 1584,
  [2399] = 2362,
  [2400] = 2400,
  [2401] = 2273,
  [2402] = 2402,
  [2403] = 2234,
  [2404] = 2241,
  [2405] = 2232,
  [2406] = 2270,
  [2407] = 2240,
  [2408] = 2241,
  [2409] = 2232,
  [2410] = 2410,
  [2411] = 2233,
  [2412] = 2248,
  [2413] = 2250,
  [2414] = 2106,
  [2415] = 2251,
  [2416] = 2252,
  [2417] = 2233,
  [2418] = 2237,
  [2419] = 2275,
  [2420] = 2317,
  [2421] = 2233,
  [2422] = 2251,
  [2423] = 2252,
  [2424] = 2424,
  [2425] = 2296,
  [2426] = 2233,
  [2427] = 2251,
  [2428] = 2252,
  [2429] = 1576,
  [2430] = 2329,
  [2431] = 2431,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2346,
  [2435] = 2435,
  [2436] = 2436,
  [2437] = 2437,
  [2438] = 2249,
  [2439] = 2437,
  [2440] = 2440,
  [2441] = 2400,
  [2442] = 2260,
  [2443] = 2271,
  [2444] = 1889,
  [2445] = 2235,
  [2446] = 2261,
  [2447] = 2265,
  [2448] = 2301,
  [2449] = 2402,
  [2450] = 1889,
  [2451] = 2270,
  [2452] = 2262,
  [2453] = 2437,
  [2454] = 2400,
  [2455] = 1948,
  [2456] = 2273,
  [2457] = 2263,
  [2458] = 2221,
  [2459] = 2270,
  [2460] = 2222,
  [2461] = 2234,
  [2462] = 1970,
  [2463] = 1576,
  [2464] = 2237,
  [2465] = 1574,
  [2466] = 2238,
  [2467] = 2239,
  [2468] = 1970,
  [2469] = 2431,
  [2470] = 2432,
  [2471] = 2334,
  [2472] = 2236,
  [2473] = 2240,
  [2474] = 2474,
  [2475] = 1576,
  [2476] = 2273,
  [2477] = 2410,
  [2478] = 2436,
  [2479] = 2241,
  [2480] = 2251,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 1597,
  [2488] = 618,
  [2489] = 2489,
  [2490] = 2490,
  [2491] = 2491,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2484,
  [2501] = 2501,
  [2502] = 2486,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2483,
  [2507] = 2507,
  [2508] = 2486,
  [2509] = 2509,
  [2510] = 2489,
  [2511] = 2484,
  [2512] = 2512,
  [2513] = 2486,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2489,
  [2518] = 2323,
  [2519] = 660,
  [2520] = 2520,
  [2521] = 2496,
  [2522] = 2496,
  [2523] = 2021,
  [2524] = 2524,
  [2525] = 2482,
  [2526] = 2526,
  [2527] = 2021,
  [2528] = 2528,
  [2529] = 2507,
  [2530] = 2530,
  [2531] = 1602,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 643,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 1593,
  [2543] = 2543,
  [2544] = 2503,
  [2545] = 1584,
  [2546] = 1597,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2021,
  [2550] = 2494,
  [2551] = 2543,
  [2552] = 2548,
  [2553] = 2540,
  [2554] = 2514,
  [2555] = 2555,
  [2556] = 2496,
  [2557] = 2557,
  [2558] = 1602,
  [2559] = 2559,
  [2560] = 656,
  [2561] = 2561,
  [2562] = 621,
  [2563] = 2563,
  [2564] = 2433,
  [2565] = 1593,
  [2566] = 2566,
  [2567] = 2489,
  [2568] = 2440,
  [2569] = 2569,
  [2570] = 2482,
  [2571] = 2569,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2507,
  [2575] = 2575,
  [2576] = 2515,
  [2577] = 2569,
  [2578] = 2497,
  [2579] = 2579,
  [2580] = 2484,
  [2581] = 2572,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2588,
  [2589] = 2589,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2584,
  [2596] = 2596,
  [2597] = 2597,
  [2598] = 2598,
  [2599] = 2584,
  [2600] = 2590,
  [2601] = 2591,
  [2602] = 2589,
  [2603] = 2598,
  [2604] = 2582,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2584,
  [2608] = 2608,
  [2609] = 2593,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2613,
  [2614] = 2592,
  [2615] = 2615,
  [2616] = 2585,
  [2617] = 2617,
  [2618] = 2598,
  [2619] = 2619,
  [2620] = 2617,
  [2621] = 2593,
  [2622] = 2590,
  [2623] = 2623,
  [2624] = 2608,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2612,
  [2629] = 2596,
  [2630] = 2598,
  [2631] = 2631,
  [2632] = 2596,
  [2633] = 2633,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2585,
  [2639] = 2597,
  [2640] = 2598,
  [2641] = 2589,
  [2642] = 2588,
  [2643] = 2643,
  [2644] = 2596,
  [2645] = 2585,
  [2646] = 2598,
  [2647] = 2589,
  [2648] = 2648,
  [2649] = 2610,
  [2650] = 2585,
  [2651] = 2651,
  [2652] = 2597,
  [2653] = 2590,
  [2654] = 2654,
  [2655] = 2615,
  [2656] = 2637,
  [2657] = 2592,
  [2658] = 2658,
  [2659] = 2589,
  [2660] = 2593,
  [2661] = 2591,
  [2662] = 2662,
  [2663] = 2623,
  [2664] = 2648,
  [2665] = 2596,
  [2666] = 2592,
  [2667] = 2667,
  [2668] = 2597,
  [2669] = 2669,
  [2670] = 2598,
  [2671] = 2662,
  [2672] = 2593,
  [2673] = 2611,
  [2674] = 2674,
  [2675] = 2594,
  [2676] = 2676,
  [2677] = 2606,
  [2678] = 2648,
  [2679] = 2587,
  [2680] = 2631,
  [2681] = 2590,
  [2682] = 2591,
  [2683] = 2596,
  [2684] = 2597,
  [2685] = 2591,
  [2686] = 2591,
  [2687] = 2593,
  [2688] = 2598,
  [2689] = 2592,
  [2690] = 2667,
  [2691] = 2617,
  [2692] = 2582,
  [2693] = 2590,
  [2694] = 2694,
  [2695] = 2669,
  [2696] = 2605,
  [2697] = 2591,
  [2698] = 2585,
  [2699] = 2593,
  [2700] = 2592,
  [2701] = 2584,
  [2702] = 2676,
  [2703] = 2669,
  [2704] = 2582,
  [2705] = 2587,
  [2706] = 2605,
  [2707] = 2707,
  [2708] = 2582,
  [2709] = 2615,
  [2710] = 2605,
  [2711] = 2711,
  [2712] = 2589,
  [2713] = 2582,
  [2714] = 2714,
  [2715] = 2584,
  [2716] = 2585,
  [2717] = 2658,
  [2718] = 2648,
  [2719] = 2592,
  [2720] = 2720,
  [2721] = 2593,
  [2722] = 2722,
  [2723] = 2605,
  [2724] = 2605,
  [2725] = 2596,
  [2726] = 2615,
  [2727] = 2608,
  [2728] = 2597,
  [2729] = 2585,
  [2730] = 2654,
  [2731] = 2731,
  [2732] = 2598,
  [2733] = 2584,
  [2734] = 2582,
  [2735] = 2617,
  [2736] = 2720,
  [2737] = 2589,
  [2738] = 2598,
  [2739] = 2590,
  [2740] = 2596,
  [2741] = 2588,
  [2742] = 2635,
  [2743] = 2589,
  [2744] = 2605,
  [2745] = 2745,
  [2746] = 2658,
  [2747] = 2747,
  [2748] = 2651,
  [2749] = 2749,
  [2750] = 2608,
  [2751] = 2597,
  [2752] = 2590,
  [2753] = 2591,
  [2754] = 2617,
  [2755] = 2755,
  [2756] = 2615,
  [2757] = 2582,
  [2758] = 2605,
  [2759] = 2759,
  [2760] = 2707,
  [2761] = 2658,
  [2762] = 2762,
  [2763] = 2584,
  [2764] = 2597,
  [2765] = 2636,
  [2766] = 2731,
  [2767] = 2767,
  [2768] = 2613,
  [2769] = 2634,
  [2770] = 2749,
  [2771] = 2588,
  [2772] = 2674,
  [2773] = 2749,
  [2774] = 2648,
  [2775] = 2592,
  [2776] = 2707,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(54);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(86);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(155);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(127);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') ADVANCE(132);
      if (lookahead == '#') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '}') ADVANCE(86);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(132);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(95);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(83);
      if (lookahead == '}') ADVANCE(86);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(21);
      if (lookahead == '&') ADVANCE(22);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '@') ADVANCE(23);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(24);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(25);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(86);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '|') ADVANCE(84);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      END_STATE();
    case 10:
      if (lookahead == '\r') ADVANCE(1);
      if ((!eof && lookahead == 00) ||
          lookahead == '\n') ADVANCE(155);
      END_STATE();
    case 11:
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(11);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(95);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(83);
      if (lookahead == '}') ADVANCE(86);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(95);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '|') ADVANCE(83);
      if (lookahead == '}') ADVANCE(86);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(14);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(95);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '|') ADVANCE(83);
      if (lookahead == '}') ADVANCE(86);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(14);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(126);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 18:
      if (lookahead == '<') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(107);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(29);
      END_STATE();
    case 32:
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 33:
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 34:
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(50);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(127);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 38:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(36);
      END_STATE();
    case 51:
      if (eof) ADVANCE(54);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '%') ADVANCE(92);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '@') ADVANCE(79);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(86);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 52:
      if (eof) ADVANCE(54);
      if (lookahead == '\r') SKIP(52);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(55);
      if (lookahead == '<') ADVANCE(104);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(109);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(83);
      if (lookahead == '}') ADVANCE(86);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(52);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 53:
      if (eof) ADVANCE(54);
      if (lookahead == '\r') SKIP(53);
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(53);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(153);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(114);
      if (lookahead == '>') ADVANCE(71);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(93);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(65);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        0, 155,
        '\n', 127,
        '\r', 2,
        'N', 35,
        'U', 49,
        'u', 45,
        'x', 43,
        '"', 127,
        '\'', 127,
        '\\', 127,
        'a', 127,
        'b', 127,
        'f', 127,
        'n', 127,
        'r', 127,
        't', 127,
        'v', 127,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if ((!eof && lookahead == 00)) ADVANCE(133);
      if (lookahead == '\r') ADVANCE(133);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(133);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      ADVANCE_MAP(
        '\r', 132,
        '#', 133,
        '\\', 131,
        '\t', 132,
        0x0b, 132,
        '\f', 132,
        ' ', 132,
        0x200b, 132,
        0x2060, 132,
        0xfeff, 132,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 145,
        '_', 138,
        'B', 32,
        'b', 32,
        'E', 37,
        'e', 37,
        'O', 33,
        'o', 33,
        'X', 34,
        'x', 34,
        'J', 135,
        'L', 135,
        'j', 135,
        'l', 135,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 145,
        '_', 138,
        'E', 37,
        'e', 37,
        'J', 135,
        'L', 135,
        'j', 135,
        'l', 135,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(135);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(145);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(146);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(70);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(149);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(150);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(151);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(147);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(148);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(53);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(61);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(73);
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(76);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(79);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(80);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(88);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(90);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(96);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 71:
      if (lookahead == 'f') ADVANCE(104);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(107);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(109);
      END_STATE();
    case 78:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(111);
      END_STATE();
    case 80:
      if (lookahead == 'b') ADVANCE(112);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(113);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(114);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 87:
      if (lookahead == 'u') ADVANCE(118);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 91:
      if (lookahead == 'h') ADVANCE(121);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(126);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(128);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 106:
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(133);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(135);
      END_STATE();
    case 113:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 114:
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(140);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 122:
      if (lookahead == 'd') ADVANCE(142);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(150);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 137:
      if (lookahead == 'c') ADVANCE(151);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 145:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_except);
      END_STATE();
    case 147:
      if (lookahead == 'y') ADVANCE(155);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 157:
      if (lookahead == '_') ADVANCE(160);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 160:
      if (lookahead == '_') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 52, .external_lex_state = 2},
  [2] = {.lex_state = 52, .external_lex_state = 3},
  [3] = {.lex_state = 52, .external_lex_state = 3},
  [4] = {.lex_state = 52, .external_lex_state = 3},
  [5] = {.lex_state = 52, .external_lex_state = 3},
  [6] = {.lex_state = 52, .external_lex_state = 3},
  [7] = {.lex_state = 52, .external_lex_state = 3},
  [8] = {.lex_state = 52, .external_lex_state = 3},
  [9] = {.lex_state = 52, .external_lex_state = 3},
  [10] = {.lex_state = 52, .external_lex_state = 3},
  [11] = {.lex_state = 52, .external_lex_state = 3},
  [12] = {.lex_state = 52, .external_lex_state = 3},
  [13] = {.lex_state = 52, .external_lex_state = 3},
  [14] = {.lex_state = 52, .external_lex_state = 3},
  [15] = {.lex_state = 52, .external_lex_state = 3},
  [16] = {.lex_state = 52, .external_lex_state = 3},
  [17] = {.lex_state = 52, .external_lex_state = 3},
  [18] = {.lex_state = 52, .external_lex_state = 3},
  [19] = {.lex_state = 52, .external_lex_state = 3},
  [20] = {.lex_state = 52, .external_lex_state = 3},
  [21] = {.lex_state = 52, .external_lex_state = 3},
  [22] = {.lex_state = 52, .external_lex_state = 3},
  [23] = {.lex_state = 52, .external_lex_state = 3},
  [24] = {.lex_state = 52, .external_lex_state = 3},
  [25] = {.lex_state = 52, .external_lex_state = 3},
  [26] = {.lex_state = 52, .external_lex_state = 3},
  [27] = {.lex_state = 52, .external_lex_state = 3},
  [28] = {.lex_state = 52, .external_lex_state = 3},
  [29] = {.lex_state = 52, .external_lex_state = 3},
  [30] = {.lex_state = 52, .external_lex_state = 3},
  [31] = {.lex_state = 52, .external_lex_state = 3},
  [32] = {.lex_state = 52, .external_lex_state = 3},
  [33] = {.lex_state = 52, .external_lex_state = 3},
  [34] = {.lex_state = 52, .external_lex_state = 3},
  [35] = {.lex_state = 52, .external_lex_state = 3},
  [36] = {.lex_state = 52, .external_lex_state = 3},
  [37] = {.lex_state = 52, .external_lex_state = 3},
  [38] = {.lex_state = 52, .external_lex_state = 3},
  [39] = {.lex_state = 52, .external_lex_state = 3},
  [40] = {.lex_state = 52, .external_lex_state = 3},
  [41] = {.lex_state = 52, .external_lex_state = 3},
  [42] = {.lex_state = 52, .external_lex_state = 3},
  [43] = {.lex_state = 52, .external_lex_state = 3},
  [44] = {.lex_state = 52, .external_lex_state = 3},
  [45] = {.lex_state = 52, .external_lex_state = 3},
  [46] = {.lex_state = 52, .external_lex_state = 3},
  [47] = {.lex_state = 52, .external_lex_state = 3},
  [48] = {.lex_state = 52, .external_lex_state = 3},
  [49] = {.lex_state = 52, .external_lex_state = 3},
  [50] = {.lex_state = 52, .external_lex_state = 3},
  [51] = {.lex_state = 52, .external_lex_state = 3},
  [52] = {.lex_state = 52, .external_lex_state = 3},
  [53] = {.lex_state = 52, .external_lex_state = 3},
  [54] = {.lex_state = 52, .external_lex_state = 3},
  [55] = {.lex_state = 52, .external_lex_state = 3},
  [56] = {.lex_state = 52, .external_lex_state = 3},
  [57] = {.lex_state = 52, .external_lex_state = 3},
  [58] = {.lex_state = 52, .external_lex_state = 3},
  [59] = {.lex_state = 52, .external_lex_state = 3},
  [60] = {.lex_state = 52, .external_lex_state = 3},
  [61] = {.lex_state = 52, .external_lex_state = 3},
  [62] = {.lex_state = 52, .external_lex_state = 3},
  [63] = {.lex_state = 52, .external_lex_state = 2},
  [64] = {.lex_state = 52, .external_lex_state = 3},
  [65] = {.lex_state = 52, .external_lex_state = 3},
  [66] = {.lex_state = 52, .external_lex_state = 2},
  [67] = {.lex_state = 52, .external_lex_state = 3},
  [68] = {.lex_state = 52, .external_lex_state = 3},
  [69] = {.lex_state = 52, .external_lex_state = 3},
  [70] = {.lex_state = 4, .external_lex_state = 4},
  [71] = {.lex_state = 4, .external_lex_state = 4},
  [72] = {.lex_state = 5, .external_lex_state = 5},
  [73] = {.lex_state = 5, .external_lex_state = 5},
  [74] = {.lex_state = 5, .external_lex_state = 5},
  [75] = {.lex_state = 5, .external_lex_state = 5},
  [76] = {.lex_state = 5, .external_lex_state = 5},
  [77] = {.lex_state = 5, .external_lex_state = 5},
  [78] = {.lex_state = 5, .external_lex_state = 5},
  [79] = {.lex_state = 5, .external_lex_state = 5},
  [80] = {.lex_state = 4, .external_lex_state = 4},
  [81] = {.lex_state = 4, .external_lex_state = 4},
  [82] = {.lex_state = 4, .external_lex_state = 4},
  [83] = {.lex_state = 4, .external_lex_state = 4},
  [84] = {.lex_state = 52, .external_lex_state = 5},
  [85] = {.lex_state = 52, .external_lex_state = 5},
  [86] = {.lex_state = 52, .external_lex_state = 5},
  [87] = {.lex_state = 52, .external_lex_state = 5},
  [88] = {.lex_state = 52, .external_lex_state = 5},
  [89] = {.lex_state = 52, .external_lex_state = 5},
  [90] = {.lex_state = 52, .external_lex_state = 5},
  [91] = {.lex_state = 52, .external_lex_state = 5},
  [92] = {.lex_state = 52, .external_lex_state = 5},
  [93] = {.lex_state = 52, .external_lex_state = 5},
  [94] = {.lex_state = 52, .external_lex_state = 5},
  [95] = {.lex_state = 52, .external_lex_state = 5},
  [96] = {.lex_state = 52, .external_lex_state = 5},
  [97] = {.lex_state = 52, .external_lex_state = 5},
  [98] = {.lex_state = 52, .external_lex_state = 5},
  [99] = {.lex_state = 52, .external_lex_state = 5},
  [100] = {.lex_state = 52, .external_lex_state = 5},
  [101] = {.lex_state = 52, .external_lex_state = 5},
  [102] = {.lex_state = 52, .external_lex_state = 5},
  [103] = {.lex_state = 52, .external_lex_state = 5},
  [104] = {.lex_state = 52, .external_lex_state = 5},
  [105] = {.lex_state = 52, .external_lex_state = 5},
  [106] = {.lex_state = 52, .external_lex_state = 5},
  [107] = {.lex_state = 52, .external_lex_state = 5},
  [108] = {.lex_state = 52, .external_lex_state = 5},
  [109] = {.lex_state = 52, .external_lex_state = 5},
  [110] = {.lex_state = 52, .external_lex_state = 5},
  [111] = {.lex_state = 52, .external_lex_state = 5},
  [112] = {.lex_state = 52, .external_lex_state = 5},
  [113] = {.lex_state = 52, .external_lex_state = 5},
  [114] = {.lex_state = 52, .external_lex_state = 5},
  [115] = {.lex_state = 52, .external_lex_state = 5},
  [116] = {.lex_state = 52, .external_lex_state = 5},
  [117] = {.lex_state = 52, .external_lex_state = 5},
  [118] = {.lex_state = 52, .external_lex_state = 5},
  [119] = {.lex_state = 52, .external_lex_state = 5},
  [120] = {.lex_state = 52, .external_lex_state = 5},
  [121] = {.lex_state = 52, .external_lex_state = 5},
  [122] = {.lex_state = 52, .external_lex_state = 5},
  [123] = {.lex_state = 52, .external_lex_state = 5},
  [124] = {.lex_state = 52, .external_lex_state = 5},
  [125] = {.lex_state = 52, .external_lex_state = 5},
  [126] = {.lex_state = 52, .external_lex_state = 5},
  [127] = {.lex_state = 52, .external_lex_state = 5},
  [128] = {.lex_state = 52, .external_lex_state = 5},
  [129] = {.lex_state = 52, .external_lex_state = 5},
  [130] = {.lex_state = 52, .external_lex_state = 5},
  [131] = {.lex_state = 52, .external_lex_state = 5},
  [132] = {.lex_state = 52, .external_lex_state = 5},
  [133] = {.lex_state = 52, .external_lex_state = 5},
  [134] = {.lex_state = 52, .external_lex_state = 4},
  [135] = {.lex_state = 52, .external_lex_state = 4},
  [136] = {.lex_state = 52, .external_lex_state = 4},
  [137] = {.lex_state = 52, .external_lex_state = 4},
  [138] = {.lex_state = 52, .external_lex_state = 4},
  [139] = {.lex_state = 52, .external_lex_state = 4},
  [140] = {.lex_state = 52, .external_lex_state = 4},
  [141] = {.lex_state = 52, .external_lex_state = 4},
  [142] = {.lex_state = 52, .external_lex_state = 4},
  [143] = {.lex_state = 52, .external_lex_state = 4},
  [144] = {.lex_state = 52, .external_lex_state = 2},
  [145] = {.lex_state = 4, .external_lex_state = 4},
  [146] = {.lex_state = 4, .external_lex_state = 4},
  [147] = {.lex_state = 11, .external_lex_state = 4},
  [148] = {.lex_state = 5, .external_lex_state = 4},
  [149] = {.lex_state = 5, .external_lex_state = 6},
  [150] = {.lex_state = 12, .external_lex_state = 4},
  [151] = {.lex_state = 12, .external_lex_state = 6},
  [152] = {.lex_state = 5, .external_lex_state = 6},
  [153] = {.lex_state = 12, .external_lex_state = 4},
  [154] = {.lex_state = 5, .external_lex_state = 7},
  [155] = {.lex_state = 5, .external_lex_state = 2},
  [156] = {.lex_state = 5, .external_lex_state = 8},
  [157] = {.lex_state = 12, .external_lex_state = 8},
  [158] = {.lex_state = 12, .external_lex_state = 6},
  [159] = {.lex_state = 5, .external_lex_state = 6},
  [160] = {.lex_state = 5, .external_lex_state = 6},
  [161] = {.lex_state = 5, .external_lex_state = 7},
  [162] = {.lex_state = 5, .external_lex_state = 8},
  [163] = {.lex_state = 5, .external_lex_state = 8},
  [164] = {.lex_state = 5, .external_lex_state = 8},
  [165] = {.lex_state = 5, .external_lex_state = 7},
  [166] = {.lex_state = 12, .external_lex_state = 2},
  [167] = {.lex_state = 5, .external_lex_state = 8},
  [168] = {.lex_state = 5, .external_lex_state = 8},
  [169] = {.lex_state = 11, .external_lex_state = 4},
  [170] = {.lex_state = 12, .external_lex_state = 6},
  [171] = {.lex_state = 12, .external_lex_state = 7},
  [172] = {.lex_state = 12, .external_lex_state = 2},
  [173] = {.lex_state = 12, .external_lex_state = 7},
  [174] = {.lex_state = 5, .external_lex_state = 7},
  [175] = {.lex_state = 12, .external_lex_state = 8},
  [176] = {.lex_state = 5, .external_lex_state = 8},
  [177] = {.lex_state = 12, .external_lex_state = 7},
  [178] = {.lex_state = 11, .external_lex_state = 2},
  [179] = {.lex_state = 11, .external_lex_state = 2},
  [180] = {.lex_state = 5, .external_lex_state = 7},
  [181] = {.lex_state = 52, .external_lex_state = 2},
  [182] = {.lex_state = 52, .external_lex_state = 7},
  [183] = {.lex_state = 52, .external_lex_state = 7},
  [184] = {.lex_state = 52, .external_lex_state = 2},
  [185] = {.lex_state = 52, .external_lex_state = 8},
  [186] = {.lex_state = 52, .external_lex_state = 8},
  [187] = {.lex_state = 52, .external_lex_state = 8},
  [188] = {.lex_state = 52, .external_lex_state = 7},
  [189] = {.lex_state = 5, .external_lex_state = 6},
  [190] = {.lex_state = 52, .external_lex_state = 8},
  [191] = {.lex_state = 5, .external_lex_state = 6},
  [192] = {.lex_state = 52, .external_lex_state = 8},
  [193] = {.lex_state = 52, .external_lex_state = 7},
  [194] = {.lex_state = 5, .external_lex_state = 6},
  [195] = {.lex_state = 52, .external_lex_state = 7},
  [196] = {.lex_state = 52, .external_lex_state = 8},
  [197] = {.lex_state = 52, .external_lex_state = 7},
  [198] = {.lex_state = 5, .external_lex_state = 6},
  [199] = {.lex_state = 52, .external_lex_state = 2},
  [200] = {.lex_state = 5, .external_lex_state = 6},
  [201] = {.lex_state = 52, .external_lex_state = 8},
  [202] = {.lex_state = 52, .external_lex_state = 7},
  [203] = {.lex_state = 5, .external_lex_state = 6},
  [204] = {.lex_state = 52, .external_lex_state = 8},
  [205] = {.lex_state = 52, .external_lex_state = 7},
  [206] = {.lex_state = 5, .external_lex_state = 6},
  [207] = {.lex_state = 52, .external_lex_state = 8},
  [208] = {.lex_state = 52, .external_lex_state = 7},
  [209] = {.lex_state = 5, .external_lex_state = 6},
  [210] = {.lex_state = 52, .external_lex_state = 8},
  [211] = {.lex_state = 52, .external_lex_state = 7},
  [212] = {.lex_state = 52, .external_lex_state = 7},
  [213] = {.lex_state = 52, .external_lex_state = 8},
  [214] = {.lex_state = 6, .external_lex_state = 4},
  [215] = {.lex_state = 6, .external_lex_state = 4},
  [216] = {.lex_state = 52, .external_lex_state = 2},
  [217] = {.lex_state = 5, .external_lex_state = 7},
  [218] = {.lex_state = 5, .external_lex_state = 7},
  [219] = {.lex_state = 5, .external_lex_state = 7},
  [220] = {.lex_state = 5, .external_lex_state = 7},
  [221] = {.lex_state = 5, .external_lex_state = 7},
  [222] = {.lex_state = 5, .external_lex_state = 7},
  [223] = {.lex_state = 5, .external_lex_state = 7},
  [224] = {.lex_state = 5, .external_lex_state = 7},
  [225] = {.lex_state = 52, .external_lex_state = 2},
  [226] = {.lex_state = 5, .external_lex_state = 2},
  [227] = {.lex_state = 5, .external_lex_state = 2},
  [228] = {.lex_state = 5, .external_lex_state = 2},
  [229] = {.lex_state = 5, .external_lex_state = 2},
  [230] = {.lex_state = 5, .external_lex_state = 2},
  [231] = {.lex_state = 5, .external_lex_state = 8},
  [232] = {.lex_state = 5, .external_lex_state = 2},
  [233] = {.lex_state = 52, .external_lex_state = 8},
  [234] = {.lex_state = 6, .external_lex_state = 2},
  [235] = {.lex_state = 5, .external_lex_state = 8},
  [236] = {.lex_state = 6, .external_lex_state = 2},
  [237] = {.lex_state = 5, .external_lex_state = 2},
  [238] = {.lex_state = 5, .external_lex_state = 2},
  [239] = {.lex_state = 5, .external_lex_state = 8},
  [240] = {.lex_state = 5, .external_lex_state = 2},
  [241] = {.lex_state = 5, .external_lex_state = 2},
  [242] = {.lex_state = 5, .external_lex_state = 2},
  [243] = {.lex_state = 5, .external_lex_state = 2},
  [244] = {.lex_state = 5, .external_lex_state = 2},
  [245] = {.lex_state = 5, .external_lex_state = 2},
  [246] = {.lex_state = 5, .external_lex_state = 8},
  [247] = {.lex_state = 5, .external_lex_state = 8},
  [248] = {.lex_state = 5, .external_lex_state = 2},
  [249] = {.lex_state = 5, .external_lex_state = 8},
  [250] = {.lex_state = 5, .external_lex_state = 2},
  [251] = {.lex_state = 5, .external_lex_state = 2},
  [252] = {.lex_state = 5, .external_lex_state = 8},
  [253] = {.lex_state = 5, .external_lex_state = 2},
  [254] = {.lex_state = 5, .external_lex_state = 8},
  [255] = {.lex_state = 5, .external_lex_state = 8},
  [256] = {.lex_state = 52, .external_lex_state = 6},
  [257] = {.lex_state = 5, .external_lex_state = 2},
  [258] = {.lex_state = 5, .external_lex_state = 2},
  [259] = {.lex_state = 5, .external_lex_state = 2},
  [260] = {.lex_state = 5, .external_lex_state = 2},
  [261] = {.lex_state = 5, .external_lex_state = 2},
  [262] = {.lex_state = 5, .external_lex_state = 2},
  [263] = {.lex_state = 5, .external_lex_state = 2},
  [264] = {.lex_state = 52, .external_lex_state = 8},
  [265] = {.lex_state = 52, .external_lex_state = 8},
  [266] = {.lex_state = 5, .external_lex_state = 8},
  [267] = {.lex_state = 5, .external_lex_state = 8},
  [268] = {.lex_state = 52, .external_lex_state = 8},
  [269] = {.lex_state = 52, .external_lex_state = 7},
  [270] = {.lex_state = 5, .external_lex_state = 8},
  [271] = {.lex_state = 5, .external_lex_state = 8},
  [272] = {.lex_state = 5, .external_lex_state = 8},
  [273] = {.lex_state = 5, .external_lex_state = 8},
  [274] = {.lex_state = 52, .external_lex_state = 8},
  [275] = {.lex_state = 52, .external_lex_state = 7},
  [276] = {.lex_state = 52, .external_lex_state = 8},
  [277] = {.lex_state = 5, .external_lex_state = 8},
  [278] = {.lex_state = 5, .external_lex_state = 8},
  [279] = {.lex_state = 5, .external_lex_state = 8},
  [280] = {.lex_state = 5, .external_lex_state = 8},
  [281] = {.lex_state = 52, .external_lex_state = 8},
  [282] = {.lex_state = 52, .external_lex_state = 7},
  [283] = {.lex_state = 52, .external_lex_state = 8},
  [284] = {.lex_state = 5, .external_lex_state = 8},
  [285] = {.lex_state = 5, .external_lex_state = 8},
  [286] = {.lex_state = 5, .external_lex_state = 8},
  [287] = {.lex_state = 5, .external_lex_state = 8},
  [288] = {.lex_state = 52, .external_lex_state = 8},
  [289] = {.lex_state = 52, .external_lex_state = 7},
  [290] = {.lex_state = 52, .external_lex_state = 8},
  [291] = {.lex_state = 5, .external_lex_state = 8},
  [292] = {.lex_state = 5, .external_lex_state = 8},
  [293] = {.lex_state = 5, .external_lex_state = 8},
  [294] = {.lex_state = 52, .external_lex_state = 8},
  [295] = {.lex_state = 52, .external_lex_state = 7},
  [296] = {.lex_state = 52, .external_lex_state = 8},
  [297] = {.lex_state = 5, .external_lex_state = 8},
  [298] = {.lex_state = 5, .external_lex_state = 8},
  [299] = {.lex_state = 5, .external_lex_state = 8},
  [300] = {.lex_state = 5, .external_lex_state = 8},
  [301] = {.lex_state = 52, .external_lex_state = 8},
  [302] = {.lex_state = 52, .external_lex_state = 7},
  [303] = {.lex_state = 52, .external_lex_state = 8},
  [304] = {.lex_state = 5, .external_lex_state = 8},
  [305] = {.lex_state = 5, .external_lex_state = 8},
  [306] = {.lex_state = 5, .external_lex_state = 8},
  [307] = {.lex_state = 5, .external_lex_state = 8},
  [308] = {.lex_state = 52, .external_lex_state = 8},
  [309] = {.lex_state = 52, .external_lex_state = 7},
  [310] = {.lex_state = 52, .external_lex_state = 7},
  [311] = {.lex_state = 5, .external_lex_state = 8},
  [312] = {.lex_state = 5, .external_lex_state = 8},
  [313] = {.lex_state = 5, .external_lex_state = 8},
  [314] = {.lex_state = 5, .external_lex_state = 8},
  [315] = {.lex_state = 5, .external_lex_state = 8},
  [316] = {.lex_state = 5, .external_lex_state = 8},
  [317] = {.lex_state = 5, .external_lex_state = 8},
  [318] = {.lex_state = 52, .external_lex_state = 8},
  [319] = {.lex_state = 52, .external_lex_state = 8},
  [320] = {.lex_state = 12, .external_lex_state = 6},
  [321] = {.lex_state = 52, .external_lex_state = 8},
  [322] = {.lex_state = 52, .external_lex_state = 8},
  [323] = {.lex_state = 52, .external_lex_state = 8},
  [324] = {.lex_state = 52, .external_lex_state = 8},
  [325] = {.lex_state = 52, .external_lex_state = 7},
  [326] = {.lex_state = 52, .external_lex_state = 6},
  [327] = {.lex_state = 52, .external_lex_state = 6},
  [328] = {.lex_state = 52, .external_lex_state = 6},
  [329] = {.lex_state = 52, .external_lex_state = 6},
  [330] = {.lex_state = 5, .external_lex_state = 2},
  [331] = {.lex_state = 52, .external_lex_state = 7},
  [332] = {.lex_state = 52, .external_lex_state = 7},
  [333] = {.lex_state = 52, .external_lex_state = 6},
  [334] = {.lex_state = 52, .external_lex_state = 7},
  [335] = {.lex_state = 52, .external_lex_state = 6},
  [336] = {.lex_state = 52, .external_lex_state = 6},
  [337] = {.lex_state = 52, .external_lex_state = 7},
  [338] = {.lex_state = 52, .external_lex_state = 7},
  [339] = {.lex_state = 52, .external_lex_state = 6},
  [340] = {.lex_state = 52, .external_lex_state = 4},
  [341] = {.lex_state = 5, .external_lex_state = 6},
  [342] = {.lex_state = 5, .external_lex_state = 6},
  [343] = {.lex_state = 52, .external_lex_state = 2},
  [344] = {.lex_state = 5, .external_lex_state = 6},
  [345] = {.lex_state = 52, .external_lex_state = 2},
  [346] = {.lex_state = 52, .external_lex_state = 8},
  [347] = {.lex_state = 52, .external_lex_state = 7},
  [348] = {.lex_state = 5, .external_lex_state = 6},
  [349] = {.lex_state = 5, .external_lex_state = 6},
  [350] = {.lex_state = 5, .external_lex_state = 6},
  [351] = {.lex_state = 52, .external_lex_state = 4},
  [352] = {.lex_state = 5, .external_lex_state = 6},
  [353] = {.lex_state = 5, .external_lex_state = 6},
  [354] = {.lex_state = 5, .external_lex_state = 6},
  [355] = {.lex_state = 5, .external_lex_state = 6},
  [356] = {.lex_state = 5, .external_lex_state = 6},
  [357] = {.lex_state = 5, .external_lex_state = 6},
  [358] = {.lex_state = 5, .external_lex_state = 6},
  [359] = {.lex_state = 5, .external_lex_state = 6},
  [360] = {.lex_state = 52, .external_lex_state = 2},
  [361] = {.lex_state = 5, .external_lex_state = 6},
  [362] = {.lex_state = 5, .external_lex_state = 6},
  [363] = {.lex_state = 52, .external_lex_state = 7},
  [364] = {.lex_state = 52, .external_lex_state = 7},
  [365] = {.lex_state = 52, .external_lex_state = 7},
  [366] = {.lex_state = 52, .external_lex_state = 7},
  [367] = {.lex_state = 52, .external_lex_state = 7},
  [368] = {.lex_state = 52, .external_lex_state = 7},
  [369] = {.lex_state = 52, .external_lex_state = 7},
  [370] = {.lex_state = 52, .external_lex_state = 7},
  [371] = {.lex_state = 52, .external_lex_state = 4},
  [372] = {.lex_state = 12, .external_lex_state = 8},
  [373] = {.lex_state = 5, .external_lex_state = 2},
  [374] = {.lex_state = 52, .external_lex_state = 4},
  [375] = {.lex_state = 52, .external_lex_state = 7},
  [376] = {.lex_state = 52, .external_lex_state = 7},
  [377] = {.lex_state = 52, .external_lex_state = 7},
  [378] = {.lex_state = 12, .external_lex_state = 8},
  [379] = {.lex_state = 52, .external_lex_state = 4},
  [380] = {.lex_state = 52, .external_lex_state = 7},
  [381] = {.lex_state = 52, .external_lex_state = 7},
  [382] = {.lex_state = 52, .external_lex_state = 7},
  [383] = {.lex_state = 52, .external_lex_state = 7},
  [384] = {.lex_state = 52, .external_lex_state = 7},
  [385] = {.lex_state = 52, .external_lex_state = 7},
  [386] = {.lex_state = 52, .external_lex_state = 7},
  [387] = {.lex_state = 52, .external_lex_state = 7},
  [388] = {.lex_state = 52, .external_lex_state = 7},
  [389] = {.lex_state = 52, .external_lex_state = 7},
  [390] = {.lex_state = 52, .external_lex_state = 7},
  [391] = {.lex_state = 52, .external_lex_state = 7},
  [392] = {.lex_state = 52, .external_lex_state = 7},
  [393] = {.lex_state = 52, .external_lex_state = 7},
  [394] = {.lex_state = 52, .external_lex_state = 7},
  [395] = {.lex_state = 52, .external_lex_state = 7},
  [396] = {.lex_state = 52, .external_lex_state = 7},
  [397] = {.lex_state = 52, .external_lex_state = 7},
  [398] = {.lex_state = 52, .external_lex_state = 7},
  [399] = {.lex_state = 52, .external_lex_state = 7},
  [400] = {.lex_state = 52, .external_lex_state = 7},
  [401] = {.lex_state = 52, .external_lex_state = 2},
  [402] = {.lex_state = 52, .external_lex_state = 2},
  [403] = {.lex_state = 5, .external_lex_state = 2},
  [404] = {.lex_state = 52, .external_lex_state = 7},
  [405] = {.lex_state = 52, .external_lex_state = 2},
  [406] = {.lex_state = 52, .external_lex_state = 4},
  [407] = {.lex_state = 52, .external_lex_state = 7},
  [408] = {.lex_state = 52, .external_lex_state = 2},
  [409] = {.lex_state = 52, .external_lex_state = 2},
  [410] = {.lex_state = 53, .external_lex_state = 9},
  [411] = {.lex_state = 52, .external_lex_state = 2},
  [412] = {.lex_state = 52, .external_lex_state = 2},
  [413] = {.lex_state = 53, .external_lex_state = 9},
  [414] = {.lex_state = 52, .external_lex_state = 8},
  [415] = {.lex_state = 53, .external_lex_state = 10},
  [416] = {.lex_state = 52, .external_lex_state = 7},
  [417] = {.lex_state = 53, .external_lex_state = 10},
  [418] = {.lex_state = 53, .external_lex_state = 10},
  [419] = {.lex_state = 52, .external_lex_state = 2},
  [420] = {.lex_state = 52, .external_lex_state = 2},
  [421] = {.lex_state = 52, .external_lex_state = 2},
  [422] = {.lex_state = 52, .external_lex_state = 2},
  [423] = {.lex_state = 52, .external_lex_state = 8},
  [424] = {.lex_state = 52, .external_lex_state = 2},
  [425] = {.lex_state = 5, .external_lex_state = 8},
  [426] = {.lex_state = 53, .external_lex_state = 9},
  [427] = {.lex_state = 52, .external_lex_state = 2},
  [428] = {.lex_state = 53, .external_lex_state = 9},
  [429] = {.lex_state = 52, .external_lex_state = 4},
  [430] = {.lex_state = 52, .external_lex_state = 2},
  [431] = {.lex_state = 52, .external_lex_state = 2},
  [432] = {.lex_state = 52, .external_lex_state = 2},
  [433] = {.lex_state = 52, .external_lex_state = 2},
  [434] = {.lex_state = 52, .external_lex_state = 7},
  [435] = {.lex_state = 52, .external_lex_state = 8},
  [436] = {.lex_state = 52, .external_lex_state = 2},
  [437] = {.lex_state = 52, .external_lex_state = 4},
  [438] = {.lex_state = 52, .external_lex_state = 2},
  [439] = {.lex_state = 52, .external_lex_state = 2},
  [440] = {.lex_state = 53, .external_lex_state = 10},
  [441] = {.lex_state = 52, .external_lex_state = 8},
  [442] = {.lex_state = 12, .external_lex_state = 2},
  [443] = {.lex_state = 12, .external_lex_state = 2},
  [444] = {.lex_state = 52, .external_lex_state = 2},
  [445] = {.lex_state = 52, .external_lex_state = 2},
  [446] = {.lex_state = 52, .external_lex_state = 2},
  [447] = {.lex_state = 52, .external_lex_state = 4},
  [448] = {.lex_state = 52, .external_lex_state = 2},
  [449] = {.lex_state = 52, .external_lex_state = 7},
  [450] = {.lex_state = 52, .external_lex_state = 2},
  [451] = {.lex_state = 52, .external_lex_state = 2},
  [452] = {.lex_state = 52, .external_lex_state = 2},
  [453] = {.lex_state = 52, .external_lex_state = 2},
  [454] = {.lex_state = 52, .external_lex_state = 2},
  [455] = {.lex_state = 5, .external_lex_state = 7},
  [456] = {.lex_state = 52, .external_lex_state = 2},
  [457] = {.lex_state = 52, .external_lex_state = 2},
  [458] = {.lex_state = 52, .external_lex_state = 4},
  [459] = {.lex_state = 52, .external_lex_state = 4},
  [460] = {.lex_state = 52, .external_lex_state = 2},
  [461] = {.lex_state = 52, .external_lex_state = 2},
  [462] = {.lex_state = 7, .external_lex_state = 4},
  [463] = {.lex_state = 52, .external_lex_state = 2},
  [464] = {.lex_state = 52, .external_lex_state = 2},
  [465] = {.lex_state = 52, .external_lex_state = 2},
  [466] = {.lex_state = 52, .external_lex_state = 2},
  [467] = {.lex_state = 7, .external_lex_state = 4},
  [468] = {.lex_state = 52, .external_lex_state = 2},
  [469] = {.lex_state = 52, .external_lex_state = 2},
  [470] = {.lex_state = 52, .external_lex_state = 2},
  [471] = {.lex_state = 52, .external_lex_state = 2},
  [472] = {.lex_state = 52, .external_lex_state = 2},
  [473] = {.lex_state = 52, .external_lex_state = 2},
  [474] = {.lex_state = 52, .external_lex_state = 2},
  [475] = {.lex_state = 52, .external_lex_state = 2},
  [476] = {.lex_state = 52, .external_lex_state = 2},
  [477] = {.lex_state = 7, .external_lex_state = 11},
  [478] = {.lex_state = 52, .external_lex_state = 2},
  [479] = {.lex_state = 7, .external_lex_state = 11},
  [480] = {.lex_state = 52, .external_lex_state = 2},
  [481] = {.lex_state = 52, .external_lex_state = 2},
  [482] = {.lex_state = 53, .external_lex_state = 9},
  [483] = {.lex_state = 52, .external_lex_state = 2},
  [484] = {.lex_state = 52, .external_lex_state = 2},
  [485] = {.lex_state = 52, .external_lex_state = 2},
  [486] = {.lex_state = 52, .external_lex_state = 2},
  [487] = {.lex_state = 52, .external_lex_state = 2},
  [488] = {.lex_state = 52, .external_lex_state = 2},
  [489] = {.lex_state = 52, .external_lex_state = 2},
  [490] = {.lex_state = 52, .external_lex_state = 2},
  [491] = {.lex_state = 52, .external_lex_state = 2},
  [492] = {.lex_state = 52, .external_lex_state = 2},
  [493] = {.lex_state = 52, .external_lex_state = 2},
  [494] = {.lex_state = 52, .external_lex_state = 2},
  [495] = {.lex_state = 52, .external_lex_state = 2},
  [496] = {.lex_state = 52, .external_lex_state = 2},
  [497] = {.lex_state = 52, .external_lex_state = 2},
  [498] = {.lex_state = 52, .external_lex_state = 2},
  [499] = {.lex_state = 52, .external_lex_state = 2},
  [500] = {.lex_state = 52, .external_lex_state = 2},
  [501] = {.lex_state = 52, .external_lex_state = 2},
  [502] = {.lex_state = 52, .external_lex_state = 2},
  [503] = {.lex_state = 52, .external_lex_state = 2},
  [504] = {.lex_state = 52, .external_lex_state = 2},
  [505] = {.lex_state = 52, .external_lex_state = 2},
  [506] = {.lex_state = 52, .external_lex_state = 2},
  [507] = {.lex_state = 52, .external_lex_state = 2},
  [508] = {.lex_state = 52, .external_lex_state = 2},
  [509] = {.lex_state = 52, .external_lex_state = 2},
  [510] = {.lex_state = 52, .external_lex_state = 2},
  [511] = {.lex_state = 52, .external_lex_state = 2},
  [512] = {.lex_state = 52, .external_lex_state = 2},
  [513] = {.lex_state = 52, .external_lex_state = 2},
  [514] = {.lex_state = 52, .external_lex_state = 2},
  [515] = {.lex_state = 52, .external_lex_state = 2},
  [516] = {.lex_state = 52, .external_lex_state = 2},
  [517] = {.lex_state = 52, .external_lex_state = 2},
  [518] = {.lex_state = 52, .external_lex_state = 2},
  [519] = {.lex_state = 52, .external_lex_state = 2},
  [520] = {.lex_state = 52, .external_lex_state = 2},
  [521] = {.lex_state = 52, .external_lex_state = 2},
  [522] = {.lex_state = 52, .external_lex_state = 2},
  [523] = {.lex_state = 52, .external_lex_state = 2},
  [524] = {.lex_state = 52, .external_lex_state = 2},
  [525] = {.lex_state = 52, .external_lex_state = 2},
  [526] = {.lex_state = 52, .external_lex_state = 2},
  [527] = {.lex_state = 52, .external_lex_state = 2},
  [528] = {.lex_state = 52, .external_lex_state = 2},
  [529] = {.lex_state = 52, .external_lex_state = 2},
  [530] = {.lex_state = 52, .external_lex_state = 2},
  [531] = {.lex_state = 52, .external_lex_state = 2},
  [532] = {.lex_state = 52, .external_lex_state = 2},
  [533] = {.lex_state = 52, .external_lex_state = 2},
  [534] = {.lex_state = 52, .external_lex_state = 2},
  [535] = {.lex_state = 52, .external_lex_state = 2},
  [536] = {.lex_state = 52, .external_lex_state = 2},
  [537] = {.lex_state = 52, .external_lex_state = 2},
  [538] = {.lex_state = 52, .external_lex_state = 2},
  [539] = {.lex_state = 52, .external_lex_state = 2},
  [540] = {.lex_state = 52, .external_lex_state = 2},
  [541] = {.lex_state = 52, .external_lex_state = 2},
  [542] = {.lex_state = 52, .external_lex_state = 2},
  [543] = {.lex_state = 52, .external_lex_state = 2},
  [544] = {.lex_state = 52, .external_lex_state = 2},
  [545] = {.lex_state = 52, .external_lex_state = 2},
  [546] = {.lex_state = 52, .external_lex_state = 2},
  [547] = {.lex_state = 52, .external_lex_state = 2},
  [548] = {.lex_state = 52, .external_lex_state = 2},
  [549] = {.lex_state = 52, .external_lex_state = 2},
  [550] = {.lex_state = 52, .external_lex_state = 2},
  [551] = {.lex_state = 52, .external_lex_state = 2},
  [552] = {.lex_state = 52, .external_lex_state = 2},
  [553] = {.lex_state = 52, .external_lex_state = 2},
  [554] = {.lex_state = 52, .external_lex_state = 2},
  [555] = {.lex_state = 52, .external_lex_state = 2},
  [556] = {.lex_state = 52, .external_lex_state = 2},
  [557] = {.lex_state = 52, .external_lex_state = 2},
  [558] = {.lex_state = 52, .external_lex_state = 2},
  [559] = {.lex_state = 52, .external_lex_state = 2},
  [560] = {.lex_state = 52, .external_lex_state = 2},
  [561] = {.lex_state = 52, .external_lex_state = 2},
  [562] = {.lex_state = 52, .external_lex_state = 2},
  [563] = {.lex_state = 52, .external_lex_state = 2},
  [564] = {.lex_state = 52, .external_lex_state = 2},
  [565] = {.lex_state = 52, .external_lex_state = 2},
  [566] = {.lex_state = 52, .external_lex_state = 2},
  [567] = {.lex_state = 52, .external_lex_state = 2},
  [568] = {.lex_state = 52, .external_lex_state = 2},
  [569] = {.lex_state = 52, .external_lex_state = 2},
  [570] = {.lex_state = 52, .external_lex_state = 2},
  [571] = {.lex_state = 52, .external_lex_state = 2},
  [572] = {.lex_state = 52, .external_lex_state = 2},
  [573] = {.lex_state = 52, .external_lex_state = 2},
  [574] = {.lex_state = 52, .external_lex_state = 2},
  [575] = {.lex_state = 52, .external_lex_state = 2},
  [576] = {.lex_state = 52, .external_lex_state = 2},
  [577] = {.lex_state = 52, .external_lex_state = 2},
  [578] = {.lex_state = 52, .external_lex_state = 2},
  [579] = {.lex_state = 52, .external_lex_state = 2},
  [580] = {.lex_state = 52, .external_lex_state = 2},
  [581] = {.lex_state = 52, .external_lex_state = 2},
  [582] = {.lex_state = 52, .external_lex_state = 2},
  [583] = {.lex_state = 52, .external_lex_state = 2},
  [584] = {.lex_state = 52, .external_lex_state = 2},
  [585] = {.lex_state = 52, .external_lex_state = 2},
  [586] = {.lex_state = 52, .external_lex_state = 2},
  [587] = {.lex_state = 53, .external_lex_state = 10},
  [588] = {.lex_state = 52, .external_lex_state = 2},
  [589] = {.lex_state = 52, .external_lex_state = 2},
  [590] = {.lex_state = 52, .external_lex_state = 2},
  [591] = {.lex_state = 52, .external_lex_state = 2},
  [592] = {.lex_state = 52, .external_lex_state = 2},
  [593] = {.lex_state = 52, .external_lex_state = 2},
  [594] = {.lex_state = 52, .external_lex_state = 2},
  [595] = {.lex_state = 52, .external_lex_state = 2},
  [596] = {.lex_state = 52, .external_lex_state = 2},
  [597] = {.lex_state = 52, .external_lex_state = 2},
  [598] = {.lex_state = 52, .external_lex_state = 2},
  [599] = {.lex_state = 52, .external_lex_state = 2},
  [600] = {.lex_state = 52, .external_lex_state = 2},
  [601] = {.lex_state = 52, .external_lex_state = 2},
  [602] = {.lex_state = 52, .external_lex_state = 2},
  [603] = {.lex_state = 52, .external_lex_state = 2},
  [604] = {.lex_state = 7, .external_lex_state = 11},
  [605] = {.lex_state = 7, .external_lex_state = 11},
  [606] = {.lex_state = 52, .external_lex_state = 2},
  [607] = {.lex_state = 7, .external_lex_state = 11},
  [608] = {.lex_state = 7, .external_lex_state = 11},
  [609] = {.lex_state = 52, .external_lex_state = 3},
  [610] = {.lex_state = 52, .external_lex_state = 2},
  [611] = {.lex_state = 52, .external_lex_state = 2},
  [612] = {.lex_state = 7, .external_lex_state = 11},
  [613] = {.lex_state = 52, .external_lex_state = 3},
  [614] = {.lex_state = 52, .external_lex_state = 3},
  [615] = {.lex_state = 7, .external_lex_state = 11},
  [616] = {.lex_state = 52, .external_lex_state = 2},
  [617] = {.lex_state = 52, .external_lex_state = 3},
  [618] = {.lex_state = 53, .external_lex_state = 10},
  [619] = {.lex_state = 8, .external_lex_state = 11},
  [620] = {.lex_state = 53, .external_lex_state = 10},
  [621] = {.lex_state = 53, .external_lex_state = 9},
  [622] = {.lex_state = 53, .external_lex_state = 10},
  [623] = {.lex_state = 8, .external_lex_state = 11},
  [624] = {.lex_state = 8, .external_lex_state = 11},
  [625] = {.lex_state = 8, .external_lex_state = 11},
  [626] = {.lex_state = 8, .external_lex_state = 11},
  [627] = {.lex_state = 8, .external_lex_state = 11},
  [628] = {.lex_state = 8, .external_lex_state = 11},
  [629] = {.lex_state = 53, .external_lex_state = 9},
  [630] = {.lex_state = 53, .external_lex_state = 10},
  [631] = {.lex_state = 8, .external_lex_state = 11},
  [632] = {.lex_state = 8, .external_lex_state = 11},
  [633] = {.lex_state = 8, .external_lex_state = 11},
  [634] = {.lex_state = 53, .external_lex_state = 9},
  [635] = {.lex_state = 53, .external_lex_state = 9},
  [636] = {.lex_state = 53, .external_lex_state = 9},
  [637] = {.lex_state = 8, .external_lex_state = 11},
  [638] = {.lex_state = 8, .external_lex_state = 11},
  [639] = {.lex_state = 53, .external_lex_state = 10},
  [640] = {.lex_state = 53, .external_lex_state = 9},
  [641] = {.lex_state = 53, .external_lex_state = 9},
  [642] = {.lex_state = 53, .external_lex_state = 10},
  [643] = {.lex_state = 53, .external_lex_state = 10},
  [644] = {.lex_state = 53, .external_lex_state = 10},
  [645] = {.lex_state = 8, .external_lex_state = 11},
  [646] = {.lex_state = 53, .external_lex_state = 9},
  [647] = {.lex_state = 53, .external_lex_state = 9},
  [648] = {.lex_state = 53, .external_lex_state = 9},
  [649] = {.lex_state = 53, .external_lex_state = 9},
  [650] = {.lex_state = 8, .external_lex_state = 11},
  [651] = {.lex_state = 8, .external_lex_state = 11},
  [652] = {.lex_state = 53, .external_lex_state = 9},
  [653] = {.lex_state = 53, .external_lex_state = 10},
  [654] = {.lex_state = 53, .external_lex_state = 10},
  [655] = {.lex_state = 8, .external_lex_state = 11},
  [656] = {.lex_state = 53, .external_lex_state = 10},
  [657] = {.lex_state = 8, .external_lex_state = 11},
  [658] = {.lex_state = 53, .external_lex_state = 9},
  [659] = {.lex_state = 8, .external_lex_state = 11},
  [660] = {.lex_state = 53, .external_lex_state = 9},
  [661] = {.lex_state = 53, .external_lex_state = 10},
  [662] = {.lex_state = 8, .external_lex_state = 11},
  [663] = {.lex_state = 52, .external_lex_state = 3},
  [664] = {.lex_state = 53, .external_lex_state = 10},
  [665] = {.lex_state = 52, .external_lex_state = 2},
  [666] = {.lex_state = 53, .external_lex_state = 10},
  [667] = {.lex_state = 53, .external_lex_state = 10},
  [668] = {.lex_state = 53, .external_lex_state = 9},
  [669] = {.lex_state = 52, .external_lex_state = 3},
  [670] = {.lex_state = 52, .external_lex_state = 3},
  [671] = {.lex_state = 52, .external_lex_state = 3},
  [672] = {.lex_state = 52, .external_lex_state = 2},
  [673] = {.lex_state = 52, .external_lex_state = 6},
  [674] = {.lex_state = 52, .external_lex_state = 2},
  [675] = {.lex_state = 52, .external_lex_state = 3},
  [676] = {.lex_state = 52, .external_lex_state = 6},
  [677] = {.lex_state = 52, .external_lex_state = 3},
  [678] = {.lex_state = 52, .external_lex_state = 2},
  [679] = {.lex_state = 52, .external_lex_state = 2},
  [680] = {.lex_state = 52, .external_lex_state = 2},
  [681] = {.lex_state = 52, .external_lex_state = 2},
  [682] = {.lex_state = 52, .external_lex_state = 3},
  [683] = {.lex_state = 52, .external_lex_state = 2},
  [684] = {.lex_state = 52, .external_lex_state = 3},
  [685] = {.lex_state = 52, .external_lex_state = 3},
  [686] = {.lex_state = 52, .external_lex_state = 2},
  [687] = {.lex_state = 52, .external_lex_state = 2},
  [688] = {.lex_state = 52, .external_lex_state = 2},
  [689] = {.lex_state = 52, .external_lex_state = 2},
  [690] = {.lex_state = 52, .external_lex_state = 2},
  [691] = {.lex_state = 52, .external_lex_state = 3},
  [692] = {.lex_state = 52, .external_lex_state = 3},
  [693] = {.lex_state = 52, .external_lex_state = 3},
  [694] = {.lex_state = 52, .external_lex_state = 2},
  [695] = {.lex_state = 52, .external_lex_state = 3},
  [696] = {.lex_state = 52, .external_lex_state = 2},
  [697] = {.lex_state = 52, .external_lex_state = 2},
  [698] = {.lex_state = 52, .external_lex_state = 3},
  [699] = {.lex_state = 52, .external_lex_state = 2},
  [700] = {.lex_state = 52, .external_lex_state = 3},
  [701] = {.lex_state = 52, .external_lex_state = 3},
  [702] = {.lex_state = 52, .external_lex_state = 3},
  [703] = {.lex_state = 52, .external_lex_state = 3},
  [704] = {.lex_state = 52, .external_lex_state = 2},
  [705] = {.lex_state = 52, .external_lex_state = 2},
  [706] = {.lex_state = 52, .external_lex_state = 3},
  [707] = {.lex_state = 52, .external_lex_state = 2},
  [708] = {.lex_state = 52, .external_lex_state = 8},
  [709] = {.lex_state = 52, .external_lex_state = 3},
  [710] = {.lex_state = 52, .external_lex_state = 2},
  [711] = {.lex_state = 52, .external_lex_state = 3},
  [712] = {.lex_state = 52, .external_lex_state = 8},
  [713] = {.lex_state = 52, .external_lex_state = 2},
  [714] = {.lex_state = 52, .external_lex_state = 3},
  [715] = {.lex_state = 52, .external_lex_state = 2},
  [716] = {.lex_state = 52, .external_lex_state = 2},
  [717] = {.lex_state = 52, .external_lex_state = 3},
  [718] = {.lex_state = 52, .external_lex_state = 3},
  [719] = {.lex_state = 52, .external_lex_state = 3},
  [720] = {.lex_state = 52, .external_lex_state = 2},
  [721] = {.lex_state = 52, .external_lex_state = 2},
  [722] = {.lex_state = 52, .external_lex_state = 2},
  [723] = {.lex_state = 52, .external_lex_state = 2},
  [724] = {.lex_state = 52, .external_lex_state = 2},
  [725] = {.lex_state = 52, .external_lex_state = 2},
  [726] = {.lex_state = 52, .external_lex_state = 2},
  [727] = {.lex_state = 52, .external_lex_state = 3},
  [728] = {.lex_state = 52, .external_lex_state = 2},
  [729] = {.lex_state = 52, .external_lex_state = 2},
  [730] = {.lex_state = 52, .external_lex_state = 2},
  [731] = {.lex_state = 52, .external_lex_state = 2},
  [732] = {.lex_state = 52, .external_lex_state = 8},
  [733] = {.lex_state = 52, .external_lex_state = 2},
  [734] = {.lex_state = 52, .external_lex_state = 2},
  [735] = {.lex_state = 52, .external_lex_state = 2},
  [736] = {.lex_state = 52, .external_lex_state = 2},
  [737] = {.lex_state = 52, .external_lex_state = 2},
  [738] = {.lex_state = 52, .external_lex_state = 2},
  [739] = {.lex_state = 52, .external_lex_state = 2},
  [740] = {.lex_state = 52, .external_lex_state = 2},
  [741] = {.lex_state = 52, .external_lex_state = 2},
  [742] = {.lex_state = 52, .external_lex_state = 3},
  [743] = {.lex_state = 52, .external_lex_state = 3},
  [744] = {.lex_state = 52, .external_lex_state = 2},
  [745] = {.lex_state = 52, .external_lex_state = 2},
  [746] = {.lex_state = 52, .external_lex_state = 2},
  [747] = {.lex_state = 52, .external_lex_state = 2},
  [748] = {.lex_state = 52, .external_lex_state = 2},
  [749] = {.lex_state = 52, .external_lex_state = 2},
  [750] = {.lex_state = 52, .external_lex_state = 2},
  [751] = {.lex_state = 52, .external_lex_state = 2},
  [752] = {.lex_state = 52, .external_lex_state = 2},
  [753] = {.lex_state = 52, .external_lex_state = 2},
  [754] = {.lex_state = 52, .external_lex_state = 2},
  [755] = {.lex_state = 52, .external_lex_state = 2},
  [756] = {.lex_state = 52, .external_lex_state = 2},
  [757] = {.lex_state = 52, .external_lex_state = 2},
  [758] = {.lex_state = 52, .external_lex_state = 2},
  [759] = {.lex_state = 52, .external_lex_state = 2},
  [760] = {.lex_state = 52, .external_lex_state = 2},
  [761] = {.lex_state = 52, .external_lex_state = 2},
  [762] = {.lex_state = 52, .external_lex_state = 2},
  [763] = {.lex_state = 52, .external_lex_state = 2},
  [764] = {.lex_state = 52, .external_lex_state = 2},
  [765] = {.lex_state = 52, .external_lex_state = 3},
  [766] = {.lex_state = 52, .external_lex_state = 2},
  [767] = {.lex_state = 52, .external_lex_state = 2},
  [768] = {.lex_state = 52, .external_lex_state = 3},
  [769] = {.lex_state = 52, .external_lex_state = 2},
  [770] = {.lex_state = 52, .external_lex_state = 2},
  [771] = {.lex_state = 52, .external_lex_state = 2},
  [772] = {.lex_state = 52, .external_lex_state = 2},
  [773] = {.lex_state = 52, .external_lex_state = 3},
  [774] = {.lex_state = 52, .external_lex_state = 2},
  [775] = {.lex_state = 52, .external_lex_state = 7},
  [776] = {.lex_state = 52, .external_lex_state = 2},
  [777] = {.lex_state = 52, .external_lex_state = 2},
  [778] = {.lex_state = 52, .external_lex_state = 2},
  [779] = {.lex_state = 52, .external_lex_state = 7},
  [780] = {.lex_state = 52, .external_lex_state = 2},
  [781] = {.lex_state = 52, .external_lex_state = 3},
  [782] = {.lex_state = 52, .external_lex_state = 3},
  [783] = {.lex_state = 52, .external_lex_state = 3},
  [784] = {.lex_state = 52, .external_lex_state = 2},
  [785] = {.lex_state = 52, .external_lex_state = 3},
  [786] = {.lex_state = 52, .external_lex_state = 3},
  [787] = {.lex_state = 52, .external_lex_state = 3},
  [788] = {.lex_state = 52, .external_lex_state = 3},
  [789] = {.lex_state = 52, .external_lex_state = 3},
  [790] = {.lex_state = 52, .external_lex_state = 3},
  [791] = {.lex_state = 52, .external_lex_state = 3},
  [792] = {.lex_state = 52, .external_lex_state = 3},
  [793] = {.lex_state = 52, .external_lex_state = 2},
  [794] = {.lex_state = 52, .external_lex_state = 3},
  [795] = {.lex_state = 52, .external_lex_state = 3},
  [796] = {.lex_state = 52, .external_lex_state = 2},
  [797] = {.lex_state = 52, .external_lex_state = 3},
  [798] = {.lex_state = 52, .external_lex_state = 3},
  [799] = {.lex_state = 52, .external_lex_state = 3},
  [800] = {.lex_state = 52, .external_lex_state = 3},
  [801] = {.lex_state = 52, .external_lex_state = 3},
  [802] = {.lex_state = 52, .external_lex_state = 3},
  [803] = {.lex_state = 52, .external_lex_state = 3},
  [804] = {.lex_state = 52, .external_lex_state = 3},
  [805] = {.lex_state = 52, .external_lex_state = 3},
  [806] = {.lex_state = 52, .external_lex_state = 3},
  [807] = {.lex_state = 52, .external_lex_state = 3},
  [808] = {.lex_state = 52, .external_lex_state = 3},
  [809] = {.lex_state = 52, .external_lex_state = 3},
  [810] = {.lex_state = 52, .external_lex_state = 3},
  [811] = {.lex_state = 52, .external_lex_state = 3},
  [812] = {.lex_state = 52, .external_lex_state = 3},
  [813] = {.lex_state = 52, .external_lex_state = 3},
  [814] = {.lex_state = 52, .external_lex_state = 3},
  [815] = {.lex_state = 52, .external_lex_state = 3},
  [816] = {.lex_state = 52, .external_lex_state = 3},
  [817] = {.lex_state = 52, .external_lex_state = 2},
  [818] = {.lex_state = 52, .external_lex_state = 3},
  [819] = {.lex_state = 52, .external_lex_state = 2},
  [820] = {.lex_state = 52, .external_lex_state = 3},
  [821] = {.lex_state = 52, .external_lex_state = 2},
  [822] = {.lex_state = 52, .external_lex_state = 3},
  [823] = {.lex_state = 52, .external_lex_state = 3},
  [824] = {.lex_state = 52, .external_lex_state = 2},
  [825] = {.lex_state = 52, .external_lex_state = 3},
  [826] = {.lex_state = 52, .external_lex_state = 2},
  [827] = {.lex_state = 52, .external_lex_state = 2},
  [828] = {.lex_state = 52, .external_lex_state = 3},
  [829] = {.lex_state = 52, .external_lex_state = 3},
  [830] = {.lex_state = 52, .external_lex_state = 3},
  [831] = {.lex_state = 52, .external_lex_state = 3},
  [832] = {.lex_state = 52, .external_lex_state = 3},
  [833] = {.lex_state = 52, .external_lex_state = 3},
  [834] = {.lex_state = 52, .external_lex_state = 2},
  [835] = {.lex_state = 52, .external_lex_state = 2},
  [836] = {.lex_state = 52, .external_lex_state = 8},
  [837] = {.lex_state = 52, .external_lex_state = 2},
  [838] = {.lex_state = 52, .external_lex_state = 2},
  [839] = {.lex_state = 52, .external_lex_state = 2},
  [840] = {.lex_state = 52, .external_lex_state = 2},
  [841] = {.lex_state = 52, .external_lex_state = 2},
  [842] = {.lex_state = 52, .external_lex_state = 2},
  [843] = {.lex_state = 52, .external_lex_state = 8},
  [844] = {.lex_state = 52, .external_lex_state = 2},
  [845] = {.lex_state = 13, .external_lex_state = 11},
  [846] = {.lex_state = 52, .external_lex_state = 2},
  [847] = {.lex_state = 52, .external_lex_state = 2},
  [848] = {.lex_state = 52, .external_lex_state = 2},
  [849] = {.lex_state = 52, .external_lex_state = 2},
  [850] = {.lex_state = 52, .external_lex_state = 2},
  [851] = {.lex_state = 52, .external_lex_state = 2},
  [852] = {.lex_state = 52, .external_lex_state = 2},
  [853] = {.lex_state = 52, .external_lex_state = 2},
  [854] = {.lex_state = 52, .external_lex_state = 2},
  [855] = {.lex_state = 52, .external_lex_state = 2},
  [856] = {.lex_state = 52, .external_lex_state = 2},
  [857] = {.lex_state = 13, .external_lex_state = 12},
  [858] = {.lex_state = 52, .external_lex_state = 2},
  [859] = {.lex_state = 52, .external_lex_state = 2},
  [860] = {.lex_state = 52, .external_lex_state = 2},
  [861] = {.lex_state = 52, .external_lex_state = 2},
  [862] = {.lex_state = 52, .external_lex_state = 2},
  [863] = {.lex_state = 52, .external_lex_state = 2},
  [864] = {.lex_state = 52, .external_lex_state = 2},
  [865] = {.lex_state = 52, .external_lex_state = 2},
  [866] = {.lex_state = 52, .external_lex_state = 2},
  [867] = {.lex_state = 52, .external_lex_state = 2},
  [868] = {.lex_state = 52, .external_lex_state = 2},
  [869] = {.lex_state = 52, .external_lex_state = 2},
  [870] = {.lex_state = 52, .external_lex_state = 2},
  [871] = {.lex_state = 52, .external_lex_state = 2},
  [872] = {.lex_state = 52, .external_lex_state = 2},
  [873] = {.lex_state = 52, .external_lex_state = 2},
  [874] = {.lex_state = 52, .external_lex_state = 2},
  [875] = {.lex_state = 52, .external_lex_state = 2},
  [876] = {.lex_state = 52, .external_lex_state = 2},
  [877] = {.lex_state = 52, .external_lex_state = 2},
  [878] = {.lex_state = 52, .external_lex_state = 2},
  [879] = {.lex_state = 52, .external_lex_state = 2},
  [880] = {.lex_state = 52, .external_lex_state = 2},
  [881] = {.lex_state = 52, .external_lex_state = 2},
  [882] = {.lex_state = 52, .external_lex_state = 2},
  [883] = {.lex_state = 52, .external_lex_state = 2},
  [884] = {.lex_state = 52, .external_lex_state = 2},
  [885] = {.lex_state = 52, .external_lex_state = 2},
  [886] = {.lex_state = 52, .external_lex_state = 2},
  [887] = {.lex_state = 52, .external_lex_state = 2},
  [888] = {.lex_state = 52, .external_lex_state = 2},
  [889] = {.lex_state = 52, .external_lex_state = 2},
  [890] = {.lex_state = 52, .external_lex_state = 2},
  [891] = {.lex_state = 52, .external_lex_state = 2},
  [892] = {.lex_state = 52, .external_lex_state = 2},
  [893] = {.lex_state = 13, .external_lex_state = 13},
  [894] = {.lex_state = 52, .external_lex_state = 2},
  [895] = {.lex_state = 52, .external_lex_state = 2},
  [896] = {.lex_state = 52, .external_lex_state = 2},
  [897] = {.lex_state = 52, .external_lex_state = 2},
  [898] = {.lex_state = 52, .external_lex_state = 2},
  [899] = {.lex_state = 52, .external_lex_state = 2},
  [900] = {.lex_state = 52, .external_lex_state = 2},
  [901] = {.lex_state = 13, .external_lex_state = 13},
  [902] = {.lex_state = 52, .external_lex_state = 2},
  [903] = {.lex_state = 52, .external_lex_state = 2},
  [904] = {.lex_state = 52, .external_lex_state = 2},
  [905] = {.lex_state = 52, .external_lex_state = 2},
  [906] = {.lex_state = 52, .external_lex_state = 2},
  [907] = {.lex_state = 52, .external_lex_state = 2},
  [908] = {.lex_state = 52, .external_lex_state = 2},
  [909] = {.lex_state = 52, .external_lex_state = 2},
  [910] = {.lex_state = 52, .external_lex_state = 2},
  [911] = {.lex_state = 52, .external_lex_state = 2},
  [912] = {.lex_state = 52, .external_lex_state = 2},
  [913] = {.lex_state = 52, .external_lex_state = 2},
  [914] = {.lex_state = 52, .external_lex_state = 2},
  [915] = {.lex_state = 52, .external_lex_state = 2},
  [916] = {.lex_state = 52, .external_lex_state = 2},
  [917] = {.lex_state = 52, .external_lex_state = 2},
  [918] = {.lex_state = 52, .external_lex_state = 2},
  [919] = {.lex_state = 52, .external_lex_state = 2},
  [920] = {.lex_state = 52, .external_lex_state = 2},
  [921] = {.lex_state = 52, .external_lex_state = 2},
  [922] = {.lex_state = 52, .external_lex_state = 2},
  [923] = {.lex_state = 52, .external_lex_state = 2},
  [924] = {.lex_state = 52, .external_lex_state = 2},
  [925] = {.lex_state = 52, .external_lex_state = 2},
  [926] = {.lex_state = 52, .external_lex_state = 2},
  [927] = {.lex_state = 52, .external_lex_state = 2},
  [928] = {.lex_state = 52, .external_lex_state = 2},
  [929] = {.lex_state = 52, .external_lex_state = 2},
  [930] = {.lex_state = 52, .external_lex_state = 2},
  [931] = {.lex_state = 52, .external_lex_state = 2},
  [932] = {.lex_state = 52, .external_lex_state = 2},
  [933] = {.lex_state = 52, .external_lex_state = 2},
  [934] = {.lex_state = 52, .external_lex_state = 2},
  [935] = {.lex_state = 52, .external_lex_state = 2},
  [936] = {.lex_state = 52, .external_lex_state = 2},
  [937] = {.lex_state = 52, .external_lex_state = 2},
  [938] = {.lex_state = 52, .external_lex_state = 2},
  [939] = {.lex_state = 52, .external_lex_state = 2},
  [940] = {.lex_state = 52, .external_lex_state = 2},
  [941] = {.lex_state = 52, .external_lex_state = 2},
  [942] = {.lex_state = 52, .external_lex_state = 2},
  [943] = {.lex_state = 52, .external_lex_state = 2},
  [944] = {.lex_state = 52, .external_lex_state = 2},
  [945] = {.lex_state = 52, .external_lex_state = 2},
  [946] = {.lex_state = 52, .external_lex_state = 2},
  [947] = {.lex_state = 52, .external_lex_state = 2},
  [948] = {.lex_state = 52, .external_lex_state = 2},
  [949] = {.lex_state = 13, .external_lex_state = 11},
  [950] = {.lex_state = 13, .external_lex_state = 14},
  [951] = {.lex_state = 13, .external_lex_state = 4},
  [952] = {.lex_state = 13, .external_lex_state = 15},
  [953] = {.lex_state = 13, .external_lex_state = 14},
  [954] = {.lex_state = 13, .external_lex_state = 4},
  [955] = {.lex_state = 13, .external_lex_state = 4},
  [956] = {.lex_state = 13, .external_lex_state = 11},
  [957] = {.lex_state = 13, .external_lex_state = 11},
  [958] = {.lex_state = 13, .external_lex_state = 6},
  [959] = {.lex_state = 13, .external_lex_state = 11},
  [960] = {.lex_state = 13, .external_lex_state = 6},
  [961] = {.lex_state = 13, .external_lex_state = 7},
  [962] = {.lex_state = 13, .external_lex_state = 11},
  [963] = {.lex_state = 13, .external_lex_state = 12},
  [964] = {.lex_state = 13, .external_lex_state = 6},
  [965] = {.lex_state = 13, .external_lex_state = 11},
  [966] = {.lex_state = 13, .external_lex_state = 11},
  [967] = {.lex_state = 13, .external_lex_state = 11},
  [968] = {.lex_state = 13, .external_lex_state = 7},
  [969] = {.lex_state = 13, .external_lex_state = 7},
  [970] = {.lex_state = 13, .external_lex_state = 6},
  [971] = {.lex_state = 13, .external_lex_state = 6},
  [972] = {.lex_state = 13, .external_lex_state = 11},
  [973] = {.lex_state = 13, .external_lex_state = 11},
  [974] = {.lex_state = 13, .external_lex_state = 11},
  [975] = {.lex_state = 13, .external_lex_state = 6},
  [976] = {.lex_state = 13, .external_lex_state = 4},
  [977] = {.lex_state = 13, .external_lex_state = 13},
  [978] = {.lex_state = 13, .external_lex_state = 8},
  [979] = {.lex_state = 13, .external_lex_state = 13},
  [980] = {.lex_state = 14, .external_lex_state = 11},
  [981] = {.lex_state = 13, .external_lex_state = 8},
  [982] = {.lex_state = 13, .external_lex_state = 12},
  [983] = {.lex_state = 13, .external_lex_state = 13},
  [984] = {.lex_state = 13, .external_lex_state = 2},
  [985] = {.lex_state = 13, .external_lex_state = 8},
  [986] = {.lex_state = 13, .external_lex_state = 4},
  [987] = {.lex_state = 13, .external_lex_state = 13},
  [988] = {.lex_state = 13, .external_lex_state = 13},
  [989] = {.lex_state = 13, .external_lex_state = 13},
  [990] = {.lex_state = 13, .external_lex_state = 13},
  [991] = {.lex_state = 13, .external_lex_state = 12},
  [992] = {.lex_state = 13, .external_lex_state = 8},
  [993] = {.lex_state = 13, .external_lex_state = 13},
  [994] = {.lex_state = 13, .external_lex_state = 14},
  [995] = {.lex_state = 13, .external_lex_state = 8},
  [996] = {.lex_state = 13, .external_lex_state = 13},
  [997] = {.lex_state = 13, .external_lex_state = 12},
  [998] = {.lex_state = 13, .external_lex_state = 8},
  [999] = {.lex_state = 13, .external_lex_state = 12},
  [1000] = {.lex_state = 13, .external_lex_state = 13},
  [1001] = {.lex_state = 13, .external_lex_state = 12},
  [1002] = {.lex_state = 14, .external_lex_state = 12},
  [1003] = {.lex_state = 13, .external_lex_state = 13},
  [1004] = {.lex_state = 13, .external_lex_state = 13},
  [1005] = {.lex_state = 13, .external_lex_state = 13},
  [1006] = {.lex_state = 13, .external_lex_state = 2},
  [1007] = {.lex_state = 13, .external_lex_state = 12},
  [1008] = {.lex_state = 13, .external_lex_state = 13},
  [1009] = {.lex_state = 13, .external_lex_state = 12},
  [1010] = {.lex_state = 13, .external_lex_state = 13},
  [1011] = {.lex_state = 13, .external_lex_state = 13},
  [1012] = {.lex_state = 14, .external_lex_state = 11},
  [1013] = {.lex_state = 13, .external_lex_state = 2},
  [1014] = {.lex_state = 13, .external_lex_state = 13},
  [1015] = {.lex_state = 13, .external_lex_state = 13},
  [1016] = {.lex_state = 13, .external_lex_state = 12},
  [1017] = {.lex_state = 13, .external_lex_state = 13},
  [1018] = {.lex_state = 14, .external_lex_state = 11},
  [1019] = {.lex_state = 13, .external_lex_state = 13},
  [1020] = {.lex_state = 13, .external_lex_state = 13},
  [1021] = {.lex_state = 13, .external_lex_state = 13},
  [1022] = {.lex_state = 13, .external_lex_state = 13},
  [1023] = {.lex_state = 13, .external_lex_state = 12},
  [1024] = {.lex_state = 13, .external_lex_state = 12},
  [1025] = {.lex_state = 13, .external_lex_state = 12},
  [1026] = {.lex_state = 13, .external_lex_state = 13},
  [1027] = {.lex_state = 13, .external_lex_state = 13},
  [1028] = {.lex_state = 13, .external_lex_state = 13},
  [1029] = {.lex_state = 13, .external_lex_state = 13},
  [1030] = {.lex_state = 13, .external_lex_state = 13},
  [1031] = {.lex_state = 14, .external_lex_state = 12},
  [1032] = {.lex_state = 14, .external_lex_state = 14},
  [1033] = {.lex_state = 13, .external_lex_state = 11},
  [1034] = {.lex_state = 13, .external_lex_state = 11},
  [1035] = {.lex_state = 13, .external_lex_state = 11},
  [1036] = {.lex_state = 13, .external_lex_state = 11},
  [1037] = {.lex_state = 13, .external_lex_state = 11},
  [1038] = {.lex_state = 14, .external_lex_state = 13},
  [1039] = {.lex_state = 13, .external_lex_state = 11},
  [1040] = {.lex_state = 13, .external_lex_state = 11},
  [1041] = {.lex_state = 13, .external_lex_state = 11},
  [1042] = {.lex_state = 14, .external_lex_state = 14},
  [1043] = {.lex_state = 14, .external_lex_state = 14},
  [1044] = {.lex_state = 13, .external_lex_state = 11},
  [1045] = {.lex_state = 14, .external_lex_state = 12},
  [1046] = {.lex_state = 13, .external_lex_state = 7},
  [1047] = {.lex_state = 13, .external_lex_state = 11},
  [1048] = {.lex_state = 13, .external_lex_state = 7},
  [1049] = {.lex_state = 14, .external_lex_state = 11},
  [1050] = {.lex_state = 14, .external_lex_state = 11},
  [1051] = {.lex_state = 13, .external_lex_state = 14},
  [1052] = {.lex_state = 13, .external_lex_state = 6},
  [1053] = {.lex_state = 14, .external_lex_state = 12},
  [1054] = {.lex_state = 14, .external_lex_state = 12},
  [1055] = {.lex_state = 14, .external_lex_state = 12},
  [1056] = {.lex_state = 13, .external_lex_state = 14},
  [1057] = {.lex_state = 13, .external_lex_state = 11},
  [1058] = {.lex_state = 14, .external_lex_state = 14},
  [1059] = {.lex_state = 14, .external_lex_state = 14},
  [1060] = {.lex_state = 13, .external_lex_state = 11},
  [1061] = {.lex_state = 13, .external_lex_state = 11},
  [1062] = {.lex_state = 13, .external_lex_state = 6},
  [1063] = {.lex_state = 13, .external_lex_state = 11},
  [1064] = {.lex_state = 14, .external_lex_state = 12},
  [1065] = {.lex_state = 14, .external_lex_state = 12},
  [1066] = {.lex_state = 13, .external_lex_state = 11},
  [1067] = {.lex_state = 13, .external_lex_state = 11},
  [1068] = {.lex_state = 13, .external_lex_state = 11},
  [1069] = {.lex_state = 13, .external_lex_state = 6},
  [1070] = {.lex_state = 13, .external_lex_state = 14},
  [1071] = {.lex_state = 13, .external_lex_state = 14},
  [1072] = {.lex_state = 13, .external_lex_state = 6},
  [1073] = {.lex_state = 13, .external_lex_state = 14},
  [1074] = {.lex_state = 13, .external_lex_state = 14},
  [1075] = {.lex_state = 13, .external_lex_state = 14},
  [1076] = {.lex_state = 13, .external_lex_state = 14},
  [1077] = {.lex_state = 13, .external_lex_state = 14},
  [1078] = {.lex_state = 13, .external_lex_state = 14},
  [1079] = {.lex_state = 13, .external_lex_state = 14},
  [1080] = {.lex_state = 13, .external_lex_state = 14},
  [1081] = {.lex_state = 13, .external_lex_state = 7},
  [1082] = {.lex_state = 14, .external_lex_state = 13},
  [1083] = {.lex_state = 14, .external_lex_state = 13},
  [1084] = {.lex_state = 14, .external_lex_state = 13},
  [1085] = {.lex_state = 13, .external_lex_state = 14},
  [1086] = {.lex_state = 13, .external_lex_state = 7},
  [1087] = {.lex_state = 13, .external_lex_state = 14},
  [1088] = {.lex_state = 13, .external_lex_state = 7},
  [1089] = {.lex_state = 13, .external_lex_state = 14},
  [1090] = {.lex_state = 13, .external_lex_state = 14},
  [1091] = {.lex_state = 13, .external_lex_state = 14},
  [1092] = {.lex_state = 13, .external_lex_state = 14},
  [1093] = {.lex_state = 13, .external_lex_state = 14},
  [1094] = {.lex_state = 13, .external_lex_state = 14},
  [1095] = {.lex_state = 13, .external_lex_state = 11},
  [1096] = {.lex_state = 13, .external_lex_state = 11},
  [1097] = {.lex_state = 13, .external_lex_state = 11},
  [1098] = {.lex_state = 13, .external_lex_state = 11},
  [1099] = {.lex_state = 13, .external_lex_state = 11},
  [1100] = {.lex_state = 13, .external_lex_state = 11},
  [1101] = {.lex_state = 13, .external_lex_state = 11},
  [1102] = {.lex_state = 13, .external_lex_state = 11},
  [1103] = {.lex_state = 13, .external_lex_state = 11},
  [1104] = {.lex_state = 13, .external_lex_state = 11},
  [1105] = {.lex_state = 13, .external_lex_state = 11},
  [1106] = {.lex_state = 13, .external_lex_state = 11},
  [1107] = {.lex_state = 13, .external_lex_state = 11},
  [1108] = {.lex_state = 14, .external_lex_state = 13},
  [1109] = {.lex_state = 14, .external_lex_state = 13},
  [1110] = {.lex_state = 13, .external_lex_state = 11},
  [1111] = {.lex_state = 13, .external_lex_state = 11},
  [1112] = {.lex_state = 14, .external_lex_state = 13},
  [1113] = {.lex_state = 14, .external_lex_state = 13},
  [1114] = {.lex_state = 14, .external_lex_state = 13},
  [1115] = {.lex_state = 13, .external_lex_state = 15},
  [1116] = {.lex_state = 13, .external_lex_state = 15},
  [1117] = {.lex_state = 13, .external_lex_state = 11},
  [1118] = {.lex_state = 14, .external_lex_state = 13},
  [1119] = {.lex_state = 14, .external_lex_state = 13},
  [1120] = {.lex_state = 14, .external_lex_state = 13},
  [1121] = {.lex_state = 13, .external_lex_state = 11},
  [1122] = {.lex_state = 13, .external_lex_state = 11},
  [1123] = {.lex_state = 13, .external_lex_state = 15},
  [1124] = {.lex_state = 13, .external_lex_state = 15},
  [1125] = {.lex_state = 13, .external_lex_state = 15},
  [1126] = {.lex_state = 13, .external_lex_state = 15},
  [1127] = {.lex_state = 13, .external_lex_state = 15},
  [1128] = {.lex_state = 13, .external_lex_state = 15},
  [1129] = {.lex_state = 13, .external_lex_state = 15},
  [1130] = {.lex_state = 13, .external_lex_state = 15},
  [1131] = {.lex_state = 13, .external_lex_state = 11},
  [1132] = {.lex_state = 13, .external_lex_state = 12},
  [1133] = {.lex_state = 13, .external_lex_state = 12},
  [1134] = {.lex_state = 13, .external_lex_state = 13},
  [1135] = {.lex_state = 13, .external_lex_state = 13},
  [1136] = {.lex_state = 13, .external_lex_state = 13},
  [1137] = {.lex_state = 13, .external_lex_state = 12},
  [1138] = {.lex_state = 13, .external_lex_state = 12},
  [1139] = {.lex_state = 14, .external_lex_state = 14},
  [1140] = {.lex_state = 13, .external_lex_state = 12},
  [1141] = {.lex_state = 14, .external_lex_state = 15},
  [1142] = {.lex_state = 13, .external_lex_state = 12},
  [1143] = {.lex_state = 14, .external_lex_state = 15},
  [1144] = {.lex_state = 13, .external_lex_state = 13},
  [1145] = {.lex_state = 13, .external_lex_state = 12},
  [1146] = {.lex_state = 13, .external_lex_state = 12},
  [1147] = {.lex_state = 13, .external_lex_state = 13},
  [1148] = {.lex_state = 13, .external_lex_state = 13},
  [1149] = {.lex_state = 13, .external_lex_state = 12},
  [1150] = {.lex_state = 13, .external_lex_state = 12},
  [1151] = {.lex_state = 13, .external_lex_state = 13},
  [1152] = {.lex_state = 13, .external_lex_state = 13},
  [1153] = {.lex_state = 13, .external_lex_state = 13},
  [1154] = {.lex_state = 13, .external_lex_state = 13},
  [1155] = {.lex_state = 13, .external_lex_state = 12},
  [1156] = {.lex_state = 13, .external_lex_state = 8},
  [1157] = {.lex_state = 13, .external_lex_state = 12},
  [1158] = {.lex_state = 14, .external_lex_state = 14},
  [1159] = {.lex_state = 14, .external_lex_state = 12},
  [1160] = {.lex_state = 13, .external_lex_state = 13},
  [1161] = {.lex_state = 13, .external_lex_state = 13},
  [1162] = {.lex_state = 13, .external_lex_state = 13},
  [1163] = {.lex_state = 13, .external_lex_state = 13},
  [1164] = {.lex_state = 13, .external_lex_state = 13},
  [1165] = {.lex_state = 13, .external_lex_state = 13},
  [1166] = {.lex_state = 13, .external_lex_state = 13},
  [1167] = {.lex_state = 13, .external_lex_state = 13},
  [1168] = {.lex_state = 13, .external_lex_state = 13},
  [1169] = {.lex_state = 13, .external_lex_state = 13},
  [1170] = {.lex_state = 13, .external_lex_state = 12},
  [1171] = {.lex_state = 13, .external_lex_state = 13},
  [1172] = {.lex_state = 13, .external_lex_state = 13},
  [1173] = {.lex_state = 13, .external_lex_state = 12},
  [1174] = {.lex_state = 13, .external_lex_state = 12},
  [1175] = {.lex_state = 13, .external_lex_state = 12},
  [1176] = {.lex_state = 13, .external_lex_state = 12},
  [1177] = {.lex_state = 13, .external_lex_state = 12},
  [1178] = {.lex_state = 13, .external_lex_state = 12},
  [1179] = {.lex_state = 13, .external_lex_state = 13},
  [1180] = {.lex_state = 13, .external_lex_state = 13},
  [1181] = {.lex_state = 13, .external_lex_state = 13},
  [1182] = {.lex_state = 14, .external_lex_state = 14},
  [1183] = {.lex_state = 13, .external_lex_state = 13},
  [1184] = {.lex_state = 14, .external_lex_state = 14},
  [1185] = {.lex_state = 13, .external_lex_state = 13},
  [1186] = {.lex_state = 13, .external_lex_state = 13},
  [1187] = {.lex_state = 13, .external_lex_state = 13},
  [1188] = {.lex_state = 13, .external_lex_state = 13},
  [1189] = {.lex_state = 13, .external_lex_state = 13},
  [1190] = {.lex_state = 13, .external_lex_state = 13},
  [1191] = {.lex_state = 13, .external_lex_state = 13},
  [1192] = {.lex_state = 13, .external_lex_state = 13},
  [1193] = {.lex_state = 13, .external_lex_state = 13},
  [1194] = {.lex_state = 13, .external_lex_state = 12},
  [1195] = {.lex_state = 13, .external_lex_state = 8},
  [1196] = {.lex_state = 13, .external_lex_state = 13},
  [1197] = {.lex_state = 13, .external_lex_state = 13},
  [1198] = {.lex_state = 14, .external_lex_state = 14},
  [1199] = {.lex_state = 14, .external_lex_state = 14},
  [1200] = {.lex_state = 14, .external_lex_state = 14},
  [1201] = {.lex_state = 13, .external_lex_state = 12},
  [1202] = {.lex_state = 13, .external_lex_state = 12},
  [1203] = {.lex_state = 13, .external_lex_state = 14},
  [1204] = {.lex_state = 14, .external_lex_state = 14},
  [1205] = {.lex_state = 13, .external_lex_state = 13},
  [1206] = {.lex_state = 13, .external_lex_state = 8},
  [1207] = {.lex_state = 13, .external_lex_state = 13},
  [1208] = {.lex_state = 13, .external_lex_state = 13},
  [1209] = {.lex_state = 13, .external_lex_state = 13},
  [1210] = {.lex_state = 13, .external_lex_state = 12},
  [1211] = {.lex_state = 13, .external_lex_state = 12},
  [1212] = {.lex_state = 13, .external_lex_state = 12},
  [1213] = {.lex_state = 13, .external_lex_state = 12},
  [1214] = {.lex_state = 13, .external_lex_state = 12},
  [1215] = {.lex_state = 13, .external_lex_state = 12},
  [1216] = {.lex_state = 13, .external_lex_state = 12},
  [1217] = {.lex_state = 13, .external_lex_state = 12},
  [1218] = {.lex_state = 13, .external_lex_state = 13},
  [1219] = {.lex_state = 13, .external_lex_state = 13},
  [1220] = {.lex_state = 13, .external_lex_state = 12},
  [1221] = {.lex_state = 13, .external_lex_state = 12},
  [1222] = {.lex_state = 13, .external_lex_state = 8},
  [1223] = {.lex_state = 13, .external_lex_state = 13},
  [1224] = {.lex_state = 13, .external_lex_state = 13},
  [1225] = {.lex_state = 14, .external_lex_state = 12},
  [1226] = {.lex_state = 14, .external_lex_state = 12},
  [1227] = {.lex_state = 14, .external_lex_state = 14},
  [1228] = {.lex_state = 14, .external_lex_state = 15},
  [1229] = {.lex_state = 13, .external_lex_state = 12},
  [1230] = {.lex_state = 13, .external_lex_state = 13},
  [1231] = {.lex_state = 13, .external_lex_state = 14},
  [1232] = {.lex_state = 14, .external_lex_state = 15},
  [1233] = {.lex_state = 13, .external_lex_state = 13},
  [1234] = {.lex_state = 14, .external_lex_state = 14},
  [1235] = {.lex_state = 14, .external_lex_state = 14},
  [1236] = {.lex_state = 14, .external_lex_state = 14},
  [1237] = {.lex_state = 13, .external_lex_state = 14},
  [1238] = {.lex_state = 13, .external_lex_state = 14},
  [1239] = {.lex_state = 13, .external_lex_state = 14},
  [1240] = {.lex_state = 14, .external_lex_state = 15},
  [1241] = {.lex_state = 13, .external_lex_state = 12},
  [1242] = {.lex_state = 13, .external_lex_state = 13},
  [1243] = {.lex_state = 13, .external_lex_state = 13},
  [1244] = {.lex_state = 13, .external_lex_state = 13},
  [1245] = {.lex_state = 13, .external_lex_state = 13},
  [1246] = {.lex_state = 13, .external_lex_state = 13},
  [1247] = {.lex_state = 13, .external_lex_state = 14},
  [1248] = {.lex_state = 13, .external_lex_state = 14},
  [1249] = {.lex_state = 13, .external_lex_state = 12},
  [1250] = {.lex_state = 13, .external_lex_state = 13},
  [1251] = {.lex_state = 13, .external_lex_state = 12},
  [1252] = {.lex_state = 13, .external_lex_state = 12},
  [1253] = {.lex_state = 14, .external_lex_state = 12},
  [1254] = {.lex_state = 13, .external_lex_state = 2},
  [1255] = {.lex_state = 13, .external_lex_state = 13},
  [1256] = {.lex_state = 13, .external_lex_state = 13},
  [1257] = {.lex_state = 13, .external_lex_state = 13},
  [1258] = {.lex_state = 13, .external_lex_state = 13},
  [1259] = {.lex_state = 13, .external_lex_state = 13},
  [1260] = {.lex_state = 13, .external_lex_state = 13},
  [1261] = {.lex_state = 13, .external_lex_state = 13},
  [1262] = {.lex_state = 13, .external_lex_state = 13},
  [1263] = {.lex_state = 14, .external_lex_state = 12},
  [1264] = {.lex_state = 14, .external_lex_state = 12},
  [1265] = {.lex_state = 13, .external_lex_state = 12},
  [1266] = {.lex_state = 13, .external_lex_state = 13},
  [1267] = {.lex_state = 13, .external_lex_state = 13},
  [1268] = {.lex_state = 13, .external_lex_state = 2},
  [1269] = {.lex_state = 13, .external_lex_state = 13},
  [1270] = {.lex_state = 13, .external_lex_state = 12},
  [1271] = {.lex_state = 13, .external_lex_state = 12},
  [1272] = {.lex_state = 13, .external_lex_state = 13},
  [1273] = {.lex_state = 13, .external_lex_state = 13},
  [1274] = {.lex_state = 13, .external_lex_state = 12},
  [1275] = {.lex_state = 13, .external_lex_state = 13},
  [1276] = {.lex_state = 13, .external_lex_state = 13},
  [1277] = {.lex_state = 13, .external_lex_state = 12},
  [1278] = {.lex_state = 13, .external_lex_state = 12},
  [1279] = {.lex_state = 13, .external_lex_state = 13},
  [1280] = {.lex_state = 13, .external_lex_state = 12},
  [1281] = {.lex_state = 13, .external_lex_state = 12},
  [1282] = {.lex_state = 13, .external_lex_state = 13},
  [1283] = {.lex_state = 13, .external_lex_state = 12},
  [1284] = {.lex_state = 13, .external_lex_state = 12},
  [1285] = {.lex_state = 13, .external_lex_state = 15},
  [1286] = {.lex_state = 13, .external_lex_state = 14},
  [1287] = {.lex_state = 13, .external_lex_state = 14},
  [1288] = {.lex_state = 13, .external_lex_state = 14},
  [1289] = {.lex_state = 13, .external_lex_state = 14},
  [1290] = {.lex_state = 13, .external_lex_state = 14},
  [1291] = {.lex_state = 13, .external_lex_state = 14},
  [1292] = {.lex_state = 13, .external_lex_state = 14},
  [1293] = {.lex_state = 13, .external_lex_state = 14},
  [1294] = {.lex_state = 13, .external_lex_state = 14},
  [1295] = {.lex_state = 13, .external_lex_state = 15},
  [1296] = {.lex_state = 13, .external_lex_state = 14},
  [1297] = {.lex_state = 13, .external_lex_state = 14},
  [1298] = {.lex_state = 13, .external_lex_state = 15},
  [1299] = {.lex_state = 13, .external_lex_state = 15},
  [1300] = {.lex_state = 13, .external_lex_state = 15},
  [1301] = {.lex_state = 13, .external_lex_state = 14},
  [1302] = {.lex_state = 13, .external_lex_state = 15},
  [1303] = {.lex_state = 13, .external_lex_state = 15},
  [1304] = {.lex_state = 13, .external_lex_state = 14},
  [1305] = {.lex_state = 13, .external_lex_state = 14},
  [1306] = {.lex_state = 13, .external_lex_state = 14},
  [1307] = {.lex_state = 13, .external_lex_state = 14},
  [1308] = {.lex_state = 13, .external_lex_state = 14},
  [1309] = {.lex_state = 13, .external_lex_state = 14},
  [1310] = {.lex_state = 13, .external_lex_state = 14},
  [1311] = {.lex_state = 13, .external_lex_state = 14},
  [1312] = {.lex_state = 13, .external_lex_state = 14},
  [1313] = {.lex_state = 13, .external_lex_state = 14},
  [1314] = {.lex_state = 13, .external_lex_state = 14},
  [1315] = {.lex_state = 13, .external_lex_state = 14},
  [1316] = {.lex_state = 13, .external_lex_state = 15},
  [1317] = {.lex_state = 13, .external_lex_state = 14},
  [1318] = {.lex_state = 13, .external_lex_state = 14},
  [1319] = {.lex_state = 13, .external_lex_state = 14},
  [1320] = {.lex_state = 13, .external_lex_state = 14},
  [1321] = {.lex_state = 13, .external_lex_state = 14},
  [1322] = {.lex_state = 14, .external_lex_state = 14},
  [1323] = {.lex_state = 14, .external_lex_state = 14},
  [1324] = {.lex_state = 14, .external_lex_state = 14},
  [1325] = {.lex_state = 13, .external_lex_state = 14},
  [1326] = {.lex_state = 13, .external_lex_state = 14},
  [1327] = {.lex_state = 13, .external_lex_state = 14},
  [1328] = {.lex_state = 13, .external_lex_state = 14},
  [1329] = {.lex_state = 8, .external_lex_state = 11},
  [1330] = {.lex_state = 8, .external_lex_state = 11},
  [1331] = {.lex_state = 13, .external_lex_state = 14},
  [1332] = {.lex_state = 13, .external_lex_state = 15},
  [1333] = {.lex_state = 13, .external_lex_state = 14},
  [1334] = {.lex_state = 13, .external_lex_state = 14},
  [1335] = {.lex_state = 13, .external_lex_state = 14},
  [1336] = {.lex_state = 13, .external_lex_state = 14},
  [1337] = {.lex_state = 13, .external_lex_state = 14},
  [1338] = {.lex_state = 13, .external_lex_state = 14},
  [1339] = {.lex_state = 13, .external_lex_state = 7},
  [1340] = {.lex_state = 13, .external_lex_state = 14},
  [1341] = {.lex_state = 13, .external_lex_state = 12},
  [1342] = {.lex_state = 13, .external_lex_state = 14},
  [1343] = {.lex_state = 13, .external_lex_state = 14},
  [1344] = {.lex_state = 13, .external_lex_state = 7},
  [1345] = {.lex_state = 8, .external_lex_state = 11},
  [1346] = {.lex_state = 8, .external_lex_state = 11},
  [1347] = {.lex_state = 8, .external_lex_state = 11},
  [1348] = {.lex_state = 13, .external_lex_state = 14},
  [1349] = {.lex_state = 13, .external_lex_state = 14},
  [1350] = {.lex_state = 8, .external_lex_state = 11},
  [1351] = {.lex_state = 13, .external_lex_state = 15},
  [1352] = {.lex_state = 13, .external_lex_state = 12},
  [1353] = {.lex_state = 13, .external_lex_state = 15},
  [1354] = {.lex_state = 13, .external_lex_state = 14},
  [1355] = {.lex_state = 13, .external_lex_state = 14},
  [1356] = {.lex_state = 13, .external_lex_state = 14},
  [1357] = {.lex_state = 13, .external_lex_state = 14},
  [1358] = {.lex_state = 13, .external_lex_state = 14},
  [1359] = {.lex_state = 13, .external_lex_state = 14},
  [1360] = {.lex_state = 13, .external_lex_state = 14},
  [1361] = {.lex_state = 13, .external_lex_state = 15},
  [1362] = {.lex_state = 13, .external_lex_state = 14},
  [1363] = {.lex_state = 13, .external_lex_state = 14},
  [1364] = {.lex_state = 13, .external_lex_state = 14},
  [1365] = {.lex_state = 13, .external_lex_state = 14},
  [1366] = {.lex_state = 13, .external_lex_state = 12},
  [1367] = {.lex_state = 13, .external_lex_state = 14},
  [1368] = {.lex_state = 13, .external_lex_state = 12},
  [1369] = {.lex_state = 13, .external_lex_state = 15},
  [1370] = {.lex_state = 13, .external_lex_state = 15},
  [1371] = {.lex_state = 13, .external_lex_state = 15},
  [1372] = {.lex_state = 13, .external_lex_state = 15},
  [1373] = {.lex_state = 13, .external_lex_state = 14},
  [1374] = {.lex_state = 13, .external_lex_state = 14},
  [1375] = {.lex_state = 13, .external_lex_state = 14},
  [1376] = {.lex_state = 13, .external_lex_state = 14},
  [1377] = {.lex_state = 13, .external_lex_state = 15},
  [1378] = {.lex_state = 13, .external_lex_state = 15},
  [1379] = {.lex_state = 13, .external_lex_state = 14},
  [1380] = {.lex_state = 13, .external_lex_state = 14},
  [1381] = {.lex_state = 13, .external_lex_state = 14},
  [1382] = {.lex_state = 13, .external_lex_state = 15},
  [1383] = {.lex_state = 13, .external_lex_state = 15},
  [1384] = {.lex_state = 13, .external_lex_state = 15},
  [1385] = {.lex_state = 13, .external_lex_state = 15},
  [1386] = {.lex_state = 13, .external_lex_state = 15},
  [1387] = {.lex_state = 13, .external_lex_state = 14},
  [1388] = {.lex_state = 13, .external_lex_state = 14},
  [1389] = {.lex_state = 13, .external_lex_state = 15},
  [1390] = {.lex_state = 13, .external_lex_state = 15},
  [1391] = {.lex_state = 14, .external_lex_state = 12},
  [1392] = {.lex_state = 13, .external_lex_state = 15},
  [1393] = {.lex_state = 13, .external_lex_state = 15},
  [1394] = {.lex_state = 13, .external_lex_state = 15},
  [1395] = {.lex_state = 14, .external_lex_state = 12},
  [1396] = {.lex_state = 13, .external_lex_state = 15},
  [1397] = {.lex_state = 14, .external_lex_state = 12},
  [1398] = {.lex_state = 13, .external_lex_state = 14},
  [1399] = {.lex_state = 13, .external_lex_state = 14},
  [1400] = {.lex_state = 13, .external_lex_state = 14},
  [1401] = {.lex_state = 13, .external_lex_state = 14},
  [1402] = {.lex_state = 13, .external_lex_state = 15},
  [1403] = {.lex_state = 13, .external_lex_state = 15},
  [1404] = {.lex_state = 13, .external_lex_state = 15},
  [1405] = {.lex_state = 13, .external_lex_state = 15},
  [1406] = {.lex_state = 13, .external_lex_state = 15},
  [1407] = {.lex_state = 13, .external_lex_state = 15},
  [1408] = {.lex_state = 13, .external_lex_state = 15},
  [1409] = {.lex_state = 13, .external_lex_state = 11},
  [1410] = {.lex_state = 13, .external_lex_state = 14},
  [1411] = {.lex_state = 13, .external_lex_state = 12},
  [1412] = {.lex_state = 13, .external_lex_state = 12},
  [1413] = {.lex_state = 14, .external_lex_state = 13},
  [1414] = {.lex_state = 13, .external_lex_state = 12},
  [1415] = {.lex_state = 13, .external_lex_state = 12},
  [1416] = {.lex_state = 13, .external_lex_state = 12},
  [1417] = {.lex_state = 13, .external_lex_state = 12},
  [1418] = {.lex_state = 13, .external_lex_state = 12},
  [1419] = {.lex_state = 13, .external_lex_state = 12},
  [1420] = {.lex_state = 13, .external_lex_state = 12},
  [1421] = {.lex_state = 14, .external_lex_state = 14},
  [1422] = {.lex_state = 13, .external_lex_state = 12},
  [1423] = {.lex_state = 14, .external_lex_state = 12},
  [1424] = {.lex_state = 13, .external_lex_state = 12},
  [1425] = {.lex_state = 14, .external_lex_state = 12},
  [1426] = {.lex_state = 13, .external_lex_state = 12},
  [1427] = {.lex_state = 14, .external_lex_state = 12},
  [1428] = {.lex_state = 13, .external_lex_state = 12},
  [1429] = {.lex_state = 13, .external_lex_state = 12},
  [1430] = {.lex_state = 13, .external_lex_state = 12},
  [1431] = {.lex_state = 13, .external_lex_state = 12},
  [1432] = {.lex_state = 13, .external_lex_state = 12},
  [1433] = {.lex_state = 13, .external_lex_state = 12},
  [1434] = {.lex_state = 13, .external_lex_state = 12},
  [1435] = {.lex_state = 13, .external_lex_state = 12},
  [1436] = {.lex_state = 13, .external_lex_state = 12},
  [1437] = {.lex_state = 13, .external_lex_state = 12},
  [1438] = {.lex_state = 13, .external_lex_state = 12},
  [1439] = {.lex_state = 13, .external_lex_state = 12},
  [1440] = {.lex_state = 13, .external_lex_state = 12},
  [1441] = {.lex_state = 13, .external_lex_state = 12},
  [1442] = {.lex_state = 14, .external_lex_state = 14},
  [1443] = {.lex_state = 14, .external_lex_state = 14},
  [1444] = {.lex_state = 13, .external_lex_state = 12},
  [1445] = {.lex_state = 13, .external_lex_state = 12},
  [1446] = {.lex_state = 13, .external_lex_state = 15},
  [1447] = {.lex_state = 13, .external_lex_state = 12},
  [1448] = {.lex_state = 13, .external_lex_state = 12},
  [1449] = {.lex_state = 13, .external_lex_state = 12},
  [1450] = {.lex_state = 13, .external_lex_state = 12},
  [1451] = {.lex_state = 14, .external_lex_state = 13},
  [1452] = {.lex_state = 14, .external_lex_state = 13},
  [1453] = {.lex_state = 13, .external_lex_state = 12},
  [1454] = {.lex_state = 13, .external_lex_state = 12},
  [1455] = {.lex_state = 13, .external_lex_state = 12},
  [1456] = {.lex_state = 13, .external_lex_state = 12},
  [1457] = {.lex_state = 13, .external_lex_state = 12},
  [1458] = {.lex_state = 13, .external_lex_state = 12},
  [1459] = {.lex_state = 8, .external_lex_state = 15},
  [1460] = {.lex_state = 8, .external_lex_state = 15},
  [1461] = {.lex_state = 8, .external_lex_state = 15},
  [1462] = {.lex_state = 8, .external_lex_state = 15},
  [1463] = {.lex_state = 8, .external_lex_state = 15},
  [1464] = {.lex_state = 8, .external_lex_state = 15},
  [1465] = {.lex_state = 8, .external_lex_state = 15},
  [1466] = {.lex_state = 8, .external_lex_state = 15},
  [1467] = {.lex_state = 8, .external_lex_state = 15},
  [1468] = {.lex_state = 8, .external_lex_state = 15},
  [1469] = {.lex_state = 8, .external_lex_state = 15},
  [1470] = {.lex_state = 8, .external_lex_state = 15},
  [1471] = {.lex_state = 8, .external_lex_state = 15},
  [1472] = {.lex_state = 13, .external_lex_state = 14},
  [1473] = {.lex_state = 13, .external_lex_state = 13},
  [1474] = {.lex_state = 8, .external_lex_state = 15},
  [1475] = {.lex_state = 8, .external_lex_state = 15},
  [1476] = {.lex_state = 8, .external_lex_state = 15},
  [1477] = {.lex_state = 12, .external_lex_state = 2},
  [1478] = {.lex_state = 12, .external_lex_state = 2},
  [1479] = {.lex_state = 5, .external_lex_state = 7},
  [1480] = {.lex_state = 5, .external_lex_state = 8},
  [1481] = {.lex_state = 5, .external_lex_state = 8},
  [1482] = {.lex_state = 5, .external_lex_state = 8},
  [1483] = {.lex_state = 5, .external_lex_state = 8},
  [1484] = {.lex_state = 5, .external_lex_state = 7},
  [1485] = {.lex_state = 5, .external_lex_state = 8},
  [1486] = {.lex_state = 5, .external_lex_state = 8},
  [1487] = {.lex_state = 5, .external_lex_state = 7},
  [1488] = {.lex_state = 5, .external_lex_state = 8},
  [1489] = {.lex_state = 5, .external_lex_state = 8},
  [1490] = {.lex_state = 5, .external_lex_state = 7},
  [1491] = {.lex_state = 5, .external_lex_state = 8},
  [1492] = {.lex_state = 5, .external_lex_state = 8},
  [1493] = {.lex_state = 5, .external_lex_state = 8},
  [1494] = {.lex_state = 5, .external_lex_state = 7},
  [1495] = {.lex_state = 5, .external_lex_state = 7},
  [1496] = {.lex_state = 5, .external_lex_state = 8},
  [1497] = {.lex_state = 5, .external_lex_state = 7},
  [1498] = {.lex_state = 5, .external_lex_state = 8},
  [1499] = {.lex_state = 5, .external_lex_state = 7},
  [1500] = {.lex_state = 5, .external_lex_state = 8},
  [1501] = {.lex_state = 5, .external_lex_state = 8},
  [1502] = {.lex_state = 5, .external_lex_state = 8},
  [1503] = {.lex_state = 5, .external_lex_state = 7},
  [1504] = {.lex_state = 5, .external_lex_state = 8},
  [1505] = {.lex_state = 5, .external_lex_state = 7},
  [1506] = {.lex_state = 5, .external_lex_state = 8},
  [1507] = {.lex_state = 5, .external_lex_state = 8},
  [1508] = {.lex_state = 5, .external_lex_state = 7},
  [1509] = {.lex_state = 5, .external_lex_state = 8},
  [1510] = {.lex_state = 5, .external_lex_state = 7},
  [1511] = {.lex_state = 5, .external_lex_state = 8},
  [1512] = {.lex_state = 5, .external_lex_state = 8},
  [1513] = {.lex_state = 5, .external_lex_state = 8},
  [1514] = {.lex_state = 5, .external_lex_state = 8},
  [1515] = {.lex_state = 5, .external_lex_state = 2},
  [1516] = {.lex_state = 5, .external_lex_state = 2},
  [1517] = {.lex_state = 5, .external_lex_state = 2},
  [1518] = {.lex_state = 5, .external_lex_state = 2},
  [1519] = {.lex_state = 5, .external_lex_state = 2},
  [1520] = {.lex_state = 5, .external_lex_state = 6},
  [1521] = {.lex_state = 5, .external_lex_state = 6},
  [1522] = {.lex_state = 5, .external_lex_state = 6},
  [1523] = {.lex_state = 5, .external_lex_state = 6},
  [1524] = {.lex_state = 5, .external_lex_state = 6},
  [1525] = {.lex_state = 5, .external_lex_state = 6},
  [1526] = {.lex_state = 5, .external_lex_state = 6},
  [1527] = {.lex_state = 5, .external_lex_state = 6},
  [1528] = {.lex_state = 5, .external_lex_state = 6},
  [1529] = {.lex_state = 5, .external_lex_state = 6},
  [1530] = {.lex_state = 5, .external_lex_state = 6},
  [1531] = {.lex_state = 5, .external_lex_state = 6},
  [1532] = {.lex_state = 5, .external_lex_state = 6},
  [1533] = {.lex_state = 5, .external_lex_state = 6},
  [1534] = {.lex_state = 5, .external_lex_state = 6},
  [1535] = {.lex_state = 5, .external_lex_state = 6},
  [1536] = {.lex_state = 5, .external_lex_state = 6},
  [1537] = {.lex_state = 5, .external_lex_state = 6},
  [1538] = {.lex_state = 5, .external_lex_state = 6},
  [1539] = {.lex_state = 5, .external_lex_state = 6},
  [1540] = {.lex_state = 5, .external_lex_state = 2},
  [1541] = {.lex_state = 5, .external_lex_state = 2},
  [1542] = {.lex_state = 5, .external_lex_state = 2},
  [1543] = {.lex_state = 5, .external_lex_state = 2},
  [1544] = {.lex_state = 5, .external_lex_state = 2},
  [1545] = {.lex_state = 8, .external_lex_state = 11},
  [1546] = {.lex_state = 5, .external_lex_state = 2},
  [1547] = {.lex_state = 5, .external_lex_state = 2},
  [1548] = {.lex_state = 5, .external_lex_state = 2},
  [1549] = {.lex_state = 5, .external_lex_state = 2},
  [1550] = {.lex_state = 8, .external_lex_state = 11},
  [1551] = {.lex_state = 8, .external_lex_state = 12},
  [1552] = {.lex_state = 8, .external_lex_state = 12},
  [1553] = {.lex_state = 8, .external_lex_state = 14},
  [1554] = {.lex_state = 8, .external_lex_state = 15},
  [1555] = {.lex_state = 8, .external_lex_state = 14},
  [1556] = {.lex_state = 8, .external_lex_state = 15},
  [1557] = {.lex_state = 52, .external_lex_state = 13},
  [1558] = {.lex_state = 52, .external_lex_state = 13},
  [1559] = {.lex_state = 8, .external_lex_state = 12},
  [1560] = {.lex_state = 52, .external_lex_state = 13},
  [1561] = {.lex_state = 52, .external_lex_state = 13},
  [1562] = {.lex_state = 8, .external_lex_state = 12},
  [1563] = {.lex_state = 13, .external_lex_state = 13},
  [1564] = {.lex_state = 52, .external_lex_state = 14},
  [1565] = {.lex_state = 13, .external_lex_state = 13},
  [1566] = {.lex_state = 52, .external_lex_state = 2},
  [1567] = {.lex_state = 13, .external_lex_state = 13},
  [1568] = {.lex_state = 52, .external_lex_state = 14},
  [1569] = {.lex_state = 13, .external_lex_state = 13},
  [1570] = {.lex_state = 52, .external_lex_state = 2},
  [1571] = {.lex_state = 13, .external_lex_state = 13},
  [1572] = {.lex_state = 13, .external_lex_state = 13},
  [1573] = {.lex_state = 13, .external_lex_state = 14},
  [1574] = {.lex_state = 11, .external_lex_state = 11},
  [1575] = {.lex_state = 13, .external_lex_state = 14},
  [1576] = {.lex_state = 11, .external_lex_state = 11},
  [1577] = {.lex_state = 13, .external_lex_state = 14},
  [1578] = {.lex_state = 13, .external_lex_state = 14},
  [1579] = {.lex_state = 13, .external_lex_state = 14},
  [1580] = {.lex_state = 13, .external_lex_state = 14},
  [1581] = {.lex_state = 13, .external_lex_state = 15},
  [1582] = {.lex_state = 13, .external_lex_state = 12},
  [1583] = {.lex_state = 13, .external_lex_state = 12},
  [1584] = {.lex_state = 11, .external_lex_state = 11},
  [1585] = {.lex_state = 13, .external_lex_state = 12},
  [1586] = {.lex_state = 13, .external_lex_state = 12},
  [1587] = {.lex_state = 13, .external_lex_state = 12},
  [1588] = {.lex_state = 13, .external_lex_state = 15},
  [1589] = {.lex_state = 13, .external_lex_state = 14},
  [1590] = {.lex_state = 13, .external_lex_state = 15},
  [1591] = {.lex_state = 13, .external_lex_state = 15},
  [1592] = {.lex_state = 13, .external_lex_state = 15},
  [1593] = {.lex_state = 11, .external_lex_state = 11},
  [1594] = {.lex_state = 13, .external_lex_state = 14},
  [1595] = {.lex_state = 13, .external_lex_state = 14},
  [1596] = {.lex_state = 13, .external_lex_state = 14},
  [1597] = {.lex_state = 11, .external_lex_state = 11},
  [1598] = {.lex_state = 13, .external_lex_state = 15},
  [1599] = {.lex_state = 13, .external_lex_state = 15},
  [1600] = {.lex_state = 13, .external_lex_state = 15},
  [1601] = {.lex_state = 13, .external_lex_state = 14},
  [1602] = {.lex_state = 11, .external_lex_state = 11},
  [1603] = {.lex_state = 13, .external_lex_state = 15},
  [1604] = {.lex_state = 13, .external_lex_state = 15},
  [1605] = {.lex_state = 13, .external_lex_state = 15},
  [1606] = {.lex_state = 13, .external_lex_state = 15},
  [1607] = {.lex_state = 13, .external_lex_state = 15},
  [1608] = {.lex_state = 13, .external_lex_state = 15},
  [1609] = {.lex_state = 13, .external_lex_state = 15},
  [1610] = {.lex_state = 13, .external_lex_state = 15},
  [1611] = {.lex_state = 13, .external_lex_state = 15},
  [1612] = {.lex_state = 13, .external_lex_state = 12},
  [1613] = {.lex_state = 13, .external_lex_state = 15},
  [1614] = {.lex_state = 13, .external_lex_state = 15},
  [1615] = {.lex_state = 13, .external_lex_state = 15},
  [1616] = {.lex_state = 13, .external_lex_state = 15},
  [1617] = {.lex_state = 13, .external_lex_state = 14},
  [1618] = {.lex_state = 13, .external_lex_state = 15},
  [1619] = {.lex_state = 12, .external_lex_state = 15},
  [1620] = {.lex_state = 11, .external_lex_state = 15},
  [1621] = {.lex_state = 12, .external_lex_state = 15},
  [1622] = {.lex_state = 12, .external_lex_state = 15},
  [1623] = {.lex_state = 11, .external_lex_state = 15},
  [1624] = {.lex_state = 11, .external_lex_state = 15},
  [1625] = {.lex_state = 11, .external_lex_state = 15},
  [1626] = {.lex_state = 11, .external_lex_state = 15},
  [1627] = {.lex_state = 12, .external_lex_state = 15},
  [1628] = {.lex_state = 12, .external_lex_state = 15},
  [1629] = {.lex_state = 12, .external_lex_state = 15},
  [1630] = {.lex_state = 11, .external_lex_state = 15},
  [1631] = {.lex_state = 12, .external_lex_state = 15},
  [1632] = {.lex_state = 12, .external_lex_state = 15},
  [1633] = {.lex_state = 12, .external_lex_state = 15},
  [1634] = {.lex_state = 11, .external_lex_state = 11},
  [1635] = {.lex_state = 12, .external_lex_state = 15},
  [1636] = {.lex_state = 11, .external_lex_state = 15},
  [1637] = {.lex_state = 12, .external_lex_state = 15},
  [1638] = {.lex_state = 11, .external_lex_state = 15},
  [1639] = {.lex_state = 5, .external_lex_state = 14},
  [1640] = {.lex_state = 5, .external_lex_state = 14},
  [1641] = {.lex_state = 5, .external_lex_state = 14},
  [1642] = {.lex_state = 12, .external_lex_state = 15},
  [1643] = {.lex_state = 12, .external_lex_state = 15},
  [1644] = {.lex_state = 11, .external_lex_state = 15},
  [1645] = {.lex_state = 8, .external_lex_state = 12},
  [1646] = {.lex_state = 5, .external_lex_state = 15},
  [1647] = {.lex_state = 5, .external_lex_state = 15},
  [1648] = {.lex_state = 8, .external_lex_state = 11},
  [1649] = {.lex_state = 8, .external_lex_state = 11},
  [1650] = {.lex_state = 52, .external_lex_state = 13},
  [1651] = {.lex_state = 8, .external_lex_state = 11},
  [1652] = {.lex_state = 8, .external_lex_state = 11},
  [1653] = {.lex_state = 8, .external_lex_state = 11},
  [1654] = {.lex_state = 8, .external_lex_state = 11},
  [1655] = {.lex_state = 52, .external_lex_state = 13},
  [1656] = {.lex_state = 52, .external_lex_state = 13},
  [1657] = {.lex_state = 52, .external_lex_state = 13},
  [1658] = {.lex_state = 8, .external_lex_state = 11},
  [1659] = {.lex_state = 52, .external_lex_state = 13},
  [1660] = {.lex_state = 52, .external_lex_state = 13},
  [1661] = {.lex_state = 52, .external_lex_state = 13},
  [1662] = {.lex_state = 52, .external_lex_state = 13},
  [1663] = {.lex_state = 8, .external_lex_state = 11},
  [1664] = {.lex_state = 8, .external_lex_state = 11},
  [1665] = {.lex_state = 52, .external_lex_state = 14},
  [1666] = {.lex_state = 0, .external_lex_state = 16},
  [1667] = {.lex_state = 0, .external_lex_state = 16},
  [1668] = {.lex_state = 52, .external_lex_state = 14},
  [1669] = {.lex_state = 0, .external_lex_state = 16},
  [1670] = {.lex_state = 8, .external_lex_state = 12},
  [1671] = {.lex_state = 8, .external_lex_state = 12},
  [1672] = {.lex_state = 0, .external_lex_state = 16},
  [1673] = {.lex_state = 8, .external_lex_state = 12},
  [1674] = {.lex_state = 8, .external_lex_state = 12},
  [1675] = {.lex_state = 0, .external_lex_state = 16},
  [1676] = {.lex_state = 52, .external_lex_state = 14},
  [1677] = {.lex_state = 52, .external_lex_state = 14},
  [1678] = {.lex_state = 52, .external_lex_state = 14},
  [1679] = {.lex_state = 0, .external_lex_state = 16},
  [1680] = {.lex_state = 8, .external_lex_state = 12},
  [1681] = {.lex_state = 0, .external_lex_state = 16},
  [1682] = {.lex_state = 0, .external_lex_state = 16},
  [1683] = {.lex_state = 52, .external_lex_state = 14},
  [1684] = {.lex_state = 52, .external_lex_state = 14},
  [1685] = {.lex_state = 8, .external_lex_state = 11},
  [1686] = {.lex_state = 0, .external_lex_state = 16},
  [1687] = {.lex_state = 52, .external_lex_state = 14},
  [1688] = {.lex_state = 52, .external_lex_state = 14},
  [1689] = {.lex_state = 0, .external_lex_state = 16},
  [1690] = {.lex_state = 52, .external_lex_state = 14},
  [1691] = {.lex_state = 0, .external_lex_state = 16},
  [1692] = {.lex_state = 0, .external_lex_state = 16},
  [1693] = {.lex_state = 52, .external_lex_state = 14},
  [1694] = {.lex_state = 8, .external_lex_state = 12},
  [1695] = {.lex_state = 52, .external_lex_state = 14},
  [1696] = {.lex_state = 0, .external_lex_state = 16},
  [1697] = {.lex_state = 0, .external_lex_state = 16},
  [1698] = {.lex_state = 0, .external_lex_state = 16},
  [1699] = {.lex_state = 52, .external_lex_state = 14},
  [1700] = {.lex_state = 52, .external_lex_state = 14},
  [1701] = {.lex_state = 52, .external_lex_state = 14},
  [1702] = {.lex_state = 0, .external_lex_state = 16},
  [1703] = {.lex_state = 0, .external_lex_state = 16},
  [1704] = {.lex_state = 8, .external_lex_state = 12},
  [1705] = {.lex_state = 52, .external_lex_state = 12},
  [1706] = {.lex_state = 0, .external_lex_state = 16},
  [1707] = {.lex_state = 52, .external_lex_state = 12},
  [1708] = {.lex_state = 0, .external_lex_state = 16},
  [1709] = {.lex_state = 52, .external_lex_state = 12},
  [1710] = {.lex_state = 8, .external_lex_state = 12},
  [1711] = {.lex_state = 8, .external_lex_state = 12},
  [1712] = {.lex_state = 52, .external_lex_state = 12},
  [1713] = {.lex_state = 52, .external_lex_state = 12},
  [1714] = {.lex_state = 52, .external_lex_state = 12},
  [1715] = {.lex_state = 52, .external_lex_state = 12},
  [1716] = {.lex_state = 52, .external_lex_state = 12},
  [1717] = {.lex_state = 52, .external_lex_state = 14},
  [1718] = {.lex_state = 52, .external_lex_state = 14},
  [1719] = {.lex_state = 8, .external_lex_state = 14},
  [1720] = {.lex_state = 52, .external_lex_state = 13},
  [1721] = {.lex_state = 8, .external_lex_state = 14},
  [1722] = {.lex_state = 8, .external_lex_state = 14},
  [1723] = {.lex_state = 8, .external_lex_state = 15},
  [1724] = {.lex_state = 8, .external_lex_state = 11},
  [1725] = {.lex_state = 8, .external_lex_state = 15},
  [1726] = {.lex_state = 8, .external_lex_state = 15},
  [1727] = {.lex_state = 8, .external_lex_state = 14},
  [1728] = {.lex_state = 8, .external_lex_state = 15},
  [1729] = {.lex_state = 8, .external_lex_state = 15},
  [1730] = {.lex_state = 8, .external_lex_state = 15},
  [1731] = {.lex_state = 8, .external_lex_state = 15},
  [1732] = {.lex_state = 8, .external_lex_state = 14},
  [1733] = {.lex_state = 8, .external_lex_state = 14},
  [1734] = {.lex_state = 52, .external_lex_state = 13},
  [1735] = {.lex_state = 8, .external_lex_state = 15},
  [1736] = {.lex_state = 8, .external_lex_state = 14},
  [1737] = {.lex_state = 8, .external_lex_state = 14},
  [1738] = {.lex_state = 8, .external_lex_state = 14},
  [1739] = {.lex_state = 8, .external_lex_state = 15},
  [1740] = {.lex_state = 8, .external_lex_state = 14},
  [1741] = {.lex_state = 52, .external_lex_state = 13},
  [1742] = {.lex_state = 52, .external_lex_state = 13},
  [1743] = {.lex_state = 52, .external_lex_state = 13},
  [1744] = {.lex_state = 8, .external_lex_state = 12},
  [1745] = {.lex_state = 8, .external_lex_state = 12},
  [1746] = {.lex_state = 8, .external_lex_state = 15},
  [1747] = {.lex_state = 8, .external_lex_state = 15},
  [1748] = {.lex_state = 8, .external_lex_state = 12},
  [1749] = {.lex_state = 52, .external_lex_state = 13},
  [1750] = {.lex_state = 8, .external_lex_state = 12},
  [1751] = {.lex_state = 8, .external_lex_state = 12},
  [1752] = {.lex_state = 52, .external_lex_state = 13},
  [1753] = {.lex_state = 8, .external_lex_state = 12},
  [1754] = {.lex_state = 52, .external_lex_state = 13},
  [1755] = {.lex_state = 52, .external_lex_state = 13},
  [1756] = {.lex_state = 8, .external_lex_state = 12},
  [1757] = {.lex_state = 52, .external_lex_state = 13},
  [1758] = {.lex_state = 52, .external_lex_state = 13},
  [1759] = {.lex_state = 52, .external_lex_state = 13},
  [1760] = {.lex_state = 52, .external_lex_state = 13},
  [1761] = {.lex_state = 52, .external_lex_state = 13},
  [1762] = {.lex_state = 8, .external_lex_state = 15},
  [1763] = {.lex_state = 52, .external_lex_state = 13},
  [1764] = {.lex_state = 52, .external_lex_state = 13},
  [1765] = {.lex_state = 52, .external_lex_state = 13},
  [1766] = {.lex_state = 52, .external_lex_state = 13},
  [1767] = {.lex_state = 8, .external_lex_state = 15},
  [1768] = {.lex_state = 52, .external_lex_state = 13},
  [1769] = {.lex_state = 52, .external_lex_state = 13},
  [1770] = {.lex_state = 52, .external_lex_state = 13},
  [1771] = {.lex_state = 8, .external_lex_state = 12},
  [1772] = {.lex_state = 8, .external_lex_state = 15},
  [1773] = {.lex_state = 52, .external_lex_state = 13},
  [1774] = {.lex_state = 8, .external_lex_state = 12},
  [1775] = {.lex_state = 52, .external_lex_state = 11},
  [1776] = {.lex_state = 8, .external_lex_state = 12},
  [1777] = {.lex_state = 52, .external_lex_state = 12},
  [1778] = {.lex_state = 52, .external_lex_state = 11},
  [1779] = {.lex_state = 52, .external_lex_state = 14},
  [1780] = {.lex_state = 52, .external_lex_state = 12},
  [1781] = {.lex_state = 52, .external_lex_state = 11},
  [1782] = {.lex_state = 52, .external_lex_state = 12},
  [1783] = {.lex_state = 0, .external_lex_state = 16},
  [1784] = {.lex_state = 52, .external_lex_state = 12},
  [1785] = {.lex_state = 52, .external_lex_state = 11},
  [1786] = {.lex_state = 52, .external_lex_state = 12},
  [1787] = {.lex_state = 7, .external_lex_state = 13},
  [1788] = {.lex_state = 52, .external_lex_state = 14},
  [1789] = {.lex_state = 52, .external_lex_state = 13},
  [1790] = {.lex_state = 52, .external_lex_state = 14},
  [1791] = {.lex_state = 52, .external_lex_state = 2},
  [1792] = {.lex_state = 52, .external_lex_state = 12},
  [1793] = {.lex_state = 52, .external_lex_state = 11},
  [1794] = {.lex_state = 52, .external_lex_state = 14},
  [1795] = {.lex_state = 52, .external_lex_state = 14},
  [1796] = {.lex_state = 52, .external_lex_state = 14},
  [1797] = {.lex_state = 52, .external_lex_state = 14},
  [1798] = {.lex_state = 52, .external_lex_state = 13},
  [1799] = {.lex_state = 52, .external_lex_state = 11},
  [1800] = {.lex_state = 52, .external_lex_state = 12},
  [1801] = {.lex_state = 52, .external_lex_state = 11},
  [1802] = {.lex_state = 52, .external_lex_state = 14},
  [1803] = {.lex_state = 52, .external_lex_state = 12},
  [1804] = {.lex_state = 0, .external_lex_state = 16},
  [1805] = {.lex_state = 52, .external_lex_state = 11},
  [1806] = {.lex_state = 7, .external_lex_state = 12},
  [1807] = {.lex_state = 52, .external_lex_state = 14},
  [1808] = {.lex_state = 52, .external_lex_state = 14},
  [1809] = {.lex_state = 52, .external_lex_state = 12},
  [1810] = {.lex_state = 52, .external_lex_state = 14},
  [1811] = {.lex_state = 52, .external_lex_state = 12},
  [1812] = {.lex_state = 52, .external_lex_state = 12},
  [1813] = {.lex_state = 52, .external_lex_state = 12},
  [1814] = {.lex_state = 52, .external_lex_state = 12},
  [1815] = {.lex_state = 7, .external_lex_state = 14},
  [1816] = {.lex_state = 52, .external_lex_state = 11},
  [1817] = {.lex_state = 52, .external_lex_state = 15},
  [1818] = {.lex_state = 8, .external_lex_state = 15},
  [1819] = {.lex_state = 52, .external_lex_state = 15},
  [1820] = {.lex_state = 52, .external_lex_state = 13},
  [1821] = {.lex_state = 52, .external_lex_state = 13},
  [1822] = {.lex_state = 52, .external_lex_state = 14},
  [1823] = {.lex_state = 52, .external_lex_state = 11},
  [1824] = {.lex_state = 52, .external_lex_state = 12},
  [1825] = {.lex_state = 52, .external_lex_state = 11},
  [1826] = {.lex_state = 52, .external_lex_state = 15},
  [1827] = {.lex_state = 52, .external_lex_state = 14},
  [1828] = {.lex_state = 7, .external_lex_state = 13},
  [1829] = {.lex_state = 52, .external_lex_state = 13},
  [1830] = {.lex_state = 7, .external_lex_state = 14},
  [1831] = {.lex_state = 52, .external_lex_state = 15},
  [1832] = {.lex_state = 52, .external_lex_state = 15},
  [1833] = {.lex_state = 52, .external_lex_state = 13},
  [1834] = {.lex_state = 7, .external_lex_state = 14},
  [1835] = {.lex_state = 7, .external_lex_state = 13},
  [1836] = {.lex_state = 52, .external_lex_state = 13},
  [1837] = {.lex_state = 52, .external_lex_state = 7},
  [1838] = {.lex_state = 52, .external_lex_state = 13},
  [1839] = {.lex_state = 52, .external_lex_state = 15},
  [1840] = {.lex_state = 52, .external_lex_state = 12},
  [1841] = {.lex_state = 7, .external_lex_state = 15},
  [1842] = {.lex_state = 52, .external_lex_state = 15},
  [1843] = {.lex_state = 52, .external_lex_state = 14},
  [1844] = {.lex_state = 7, .external_lex_state = 13},
  [1845] = {.lex_state = 52, .external_lex_state = 12},
  [1846] = {.lex_state = 52, .external_lex_state = 15},
  [1847] = {.lex_state = 52, .external_lex_state = 11},
  [1848] = {.lex_state = 52, .external_lex_state = 14},
  [1849] = {.lex_state = 52, .external_lex_state = 15},
  [1850] = {.lex_state = 52, .external_lex_state = 15},
  [1851] = {.lex_state = 52, .external_lex_state = 12},
  [1852] = {.lex_state = 52, .external_lex_state = 14},
  [1853] = {.lex_state = 52, .external_lex_state = 8},
  [1854] = {.lex_state = 52, .external_lex_state = 15},
  [1855] = {.lex_state = 52, .external_lex_state = 13},
  [1856] = {.lex_state = 52, .external_lex_state = 13},
  [1857] = {.lex_state = 52, .external_lex_state = 14},
  [1858] = {.lex_state = 52, .external_lex_state = 12},
  [1859] = {.lex_state = 52, .external_lex_state = 14},
  [1860] = {.lex_state = 52, .external_lex_state = 13},
  [1861] = {.lex_state = 7, .external_lex_state = 12},
  [1862] = {.lex_state = 52, .external_lex_state = 12},
  [1863] = {.lex_state = 7, .external_lex_state = 12},
  [1864] = {.lex_state = 7, .external_lex_state = 14},
  [1865] = {.lex_state = 52, .external_lex_state = 12},
  [1866] = {.lex_state = 52, .external_lex_state = 12},
  [1867] = {.lex_state = 52, .external_lex_state = 13},
  [1868] = {.lex_state = 52, .external_lex_state = 13},
  [1869] = {.lex_state = 52, .external_lex_state = 13},
  [1870] = {.lex_state = 7, .external_lex_state = 12},
  [1871] = {.lex_state = 52, .external_lex_state = 13},
  [1872] = {.lex_state = 52, .external_lex_state = 13},
  [1873] = {.lex_state = 52, .external_lex_state = 6},
  [1874] = {.lex_state = 7, .external_lex_state = 11},
  [1875] = {.lex_state = 52, .external_lex_state = 13},
  [1876] = {.lex_state = 8, .external_lex_state = 11},
  [1877] = {.lex_state = 52, .external_lex_state = 12},
  [1878] = {.lex_state = 52, .external_lex_state = 12},
  [1879] = {.lex_state = 8, .external_lex_state = 14},
  [1880] = {.lex_state = 52, .external_lex_state = 15},
  [1881] = {.lex_state = 8, .external_lex_state = 14},
  [1882] = {.lex_state = 52, .external_lex_state = 14},
  [1883] = {.lex_state = 8, .external_lex_state = 11},
  [1884] = {.lex_state = 52, .external_lex_state = 14},
  [1885] = {.lex_state = 8, .external_lex_state = 11},
  [1886] = {.lex_state = 52, .external_lex_state = 15},
  [1887] = {.lex_state = 52, .external_lex_state = 15},
  [1888] = {.lex_state = 52, .external_lex_state = 12},
  [1889] = {.lex_state = 52, .external_lex_state = 13},
  [1890] = {.lex_state = 52, .external_lex_state = 13},
  [1891] = {.lex_state = 0, .external_lex_state = 16},
  [1892] = {.lex_state = 52, .external_lex_state = 12},
  [1893] = {.lex_state = 0, .external_lex_state = 16},
  [1894] = {.lex_state = 52, .external_lex_state = 14},
  [1895] = {.lex_state = 8, .external_lex_state = 12},
  [1896] = {.lex_state = 52, .external_lex_state = 13},
  [1897] = {.lex_state = 52, .external_lex_state = 15},
  [1898] = {.lex_state = 52, .external_lex_state = 11},
  [1899] = {.lex_state = 52, .external_lex_state = 11},
  [1900] = {.lex_state = 52, .external_lex_state = 12},
  [1901] = {.lex_state = 8, .external_lex_state = 11},
  [1902] = {.lex_state = 52, .external_lex_state = 15},
  [1903] = {.lex_state = 52, .external_lex_state = 14},
  [1904] = {.lex_state = 52, .external_lex_state = 15},
  [1905] = {.lex_state = 52, .external_lex_state = 12},
  [1906] = {.lex_state = 52, .external_lex_state = 12},
  [1907] = {.lex_state = 52, .external_lex_state = 14},
  [1908] = {.lex_state = 52, .external_lex_state = 13},
  [1909] = {.lex_state = 8, .external_lex_state = 11},
  [1910] = {.lex_state = 52, .external_lex_state = 13},
  [1911] = {.lex_state = 52, .external_lex_state = 13},
  [1912] = {.lex_state = 52, .external_lex_state = 13},
  [1913] = {.lex_state = 52, .external_lex_state = 12},
  [1914] = {.lex_state = 8, .external_lex_state = 12},
  [1915] = {.lex_state = 0, .external_lex_state = 16},
  [1916] = {.lex_state = 52, .external_lex_state = 14},
  [1917] = {.lex_state = 52, .external_lex_state = 14},
  [1918] = {.lex_state = 52, .external_lex_state = 15},
  [1919] = {.lex_state = 52, .external_lex_state = 14},
  [1920] = {.lex_state = 52, .external_lex_state = 13},
  [1921] = {.lex_state = 8, .external_lex_state = 14},
  [1922] = {.lex_state = 8, .external_lex_state = 14},
  [1923] = {.lex_state = 52, .external_lex_state = 15},
  [1924] = {.lex_state = 8, .external_lex_state = 14},
  [1925] = {.lex_state = 7, .external_lex_state = 11},
  [1926] = {.lex_state = 8, .external_lex_state = 11},
  [1927] = {.lex_state = 52, .external_lex_state = 14},
  [1928] = {.lex_state = 52, .external_lex_state = 14},
  [1929] = {.lex_state = 52, .external_lex_state = 12},
  [1930] = {.lex_state = 8, .external_lex_state = 14},
  [1931] = {.lex_state = 8, .external_lex_state = 12},
  [1932] = {.lex_state = 52, .external_lex_state = 12},
  [1933] = {.lex_state = 8, .external_lex_state = 15},
  [1934] = {.lex_state = 52, .external_lex_state = 15},
  [1935] = {.lex_state = 52, .external_lex_state = 15},
  [1936] = {.lex_state = 52, .external_lex_state = 15},
  [1937] = {.lex_state = 52, .external_lex_state = 14},
  [1938] = {.lex_state = 52, .external_lex_state = 14},
  [1939] = {.lex_state = 8, .external_lex_state = 15},
  [1940] = {.lex_state = 8, .external_lex_state = 11},
  [1941] = {.lex_state = 52, .external_lex_state = 14},
  [1942] = {.lex_state = 52, .external_lex_state = 14},
  [1943] = {.lex_state = 52, .external_lex_state = 13},
  [1944] = {.lex_state = 52, .external_lex_state = 15},
  [1945] = {.lex_state = 8, .external_lex_state = 12},
  [1946] = {.lex_state = 52, .external_lex_state = 11},
  [1947] = {.lex_state = 7, .external_lex_state = 13},
  [1948] = {.lex_state = 0, .external_lex_state = 16},
  [1949] = {.lex_state = 7, .external_lex_state = 12},
  [1950] = {.lex_state = 52, .external_lex_state = 14},
  [1951] = {.lex_state = 0, .external_lex_state = 16},
  [1952] = {.lex_state = 52, .external_lex_state = 14},
  [1953] = {.lex_state = 52, .external_lex_state = 13},
  [1954] = {.lex_state = 52, .external_lex_state = 12},
  [1955] = {.lex_state = 52, .external_lex_state = 14},
  [1956] = {.lex_state = 8, .external_lex_state = 11},
  [1957] = {.lex_state = 52, .external_lex_state = 13},
  [1958] = {.lex_state = 52, .external_lex_state = 14},
  [1959] = {.lex_state = 0, .external_lex_state = 16},
  [1960] = {.lex_state = 0, .external_lex_state = 16},
  [1961] = {.lex_state = 8, .external_lex_state = 11},
  [1962] = {.lex_state = 8, .external_lex_state = 15},
  [1963] = {.lex_state = 52, .external_lex_state = 12},
  [1964] = {.lex_state = 52, .external_lex_state = 15},
  [1965] = {.lex_state = 7, .external_lex_state = 14},
  [1966] = {.lex_state = 8, .external_lex_state = 14},
  [1967] = {.lex_state = 8, .external_lex_state = 14},
  [1968] = {.lex_state = 52, .external_lex_state = 13},
  [1969] = {.lex_state = 52, .external_lex_state = 15},
  [1970] = {.lex_state = 52, .external_lex_state = 13},
  [1971] = {.lex_state = 8, .external_lex_state = 14},
  [1972] = {.lex_state = 52, .external_lex_state = 12},
  [1973] = {.lex_state = 8, .external_lex_state = 11},
  [1974] = {.lex_state = 8, .external_lex_state = 11},
  [1975] = {.lex_state = 52, .external_lex_state = 15},
  [1976] = {.lex_state = 52, .external_lex_state = 13},
  [1977] = {.lex_state = 8, .external_lex_state = 14},
  [1978] = {.lex_state = 52, .external_lex_state = 15},
  [1979] = {.lex_state = 0, .external_lex_state = 16},
  [1980] = {.lex_state = 7, .external_lex_state = 11},
  [1981] = {.lex_state = 8, .external_lex_state = 14},
  [1982] = {.lex_state = 52, .external_lex_state = 12},
  [1983] = {.lex_state = 52, .external_lex_state = 15},
  [1984] = {.lex_state = 52, .external_lex_state = 14},
  [1985] = {.lex_state = 52, .external_lex_state = 15},
  [1986] = {.lex_state = 52, .external_lex_state = 15},
  [1987] = {.lex_state = 8, .external_lex_state = 15},
  [1988] = {.lex_state = 52, .external_lex_state = 11},
  [1989] = {.lex_state = 52, .external_lex_state = 15},
  [1990] = {.lex_state = 52, .external_lex_state = 15},
  [1991] = {.lex_state = 8, .external_lex_state = 11},
  [1992] = {.lex_state = 52, .external_lex_state = 15},
  [1993] = {.lex_state = 52, .external_lex_state = 15},
  [1994] = {.lex_state = 52, .external_lex_state = 15},
  [1995] = {.lex_state = 52, .external_lex_state = 15},
  [1996] = {.lex_state = 8, .external_lex_state = 15},
  [1997] = {.lex_state = 52, .external_lex_state = 15},
  [1998] = {.lex_state = 52, .external_lex_state = 13},
  [1999] = {.lex_state = 52, .external_lex_state = 13},
  [2000] = {.lex_state = 52, .external_lex_state = 12},
  [2001] = {.lex_state = 52, .external_lex_state = 15},
  [2002] = {.lex_state = 52, .external_lex_state = 15},
  [2003] = {.lex_state = 52, .external_lex_state = 11},
  [2004] = {.lex_state = 52, .external_lex_state = 12},
  [2005] = {.lex_state = 52, .external_lex_state = 13},
  [2006] = {.lex_state = 52, .external_lex_state = 15},
  [2007] = {.lex_state = 52, .external_lex_state = 15},
  [2008] = {.lex_state = 52, .external_lex_state = 15},
  [2009] = {.lex_state = 8, .external_lex_state = 12},
  [2010] = {.lex_state = 8, .external_lex_state = 12},
  [2011] = {.lex_state = 8, .external_lex_state = 12},
  [2012] = {.lex_state = 52, .external_lex_state = 15},
  [2013] = {.lex_state = 52, .external_lex_state = 15},
  [2014] = {.lex_state = 52, .external_lex_state = 12},
  [2015] = {.lex_state = 52, .external_lex_state = 15},
  [2016] = {.lex_state = 52, .external_lex_state = 15},
  [2017] = {.lex_state = 52, .external_lex_state = 15},
  [2018] = {.lex_state = 52, .external_lex_state = 15},
  [2019] = {.lex_state = 8, .external_lex_state = 12},
  [2020] = {.lex_state = 52, .external_lex_state = 15},
  [2021] = {.lex_state = 52, .external_lex_state = 13},
  [2022] = {.lex_state = 52, .external_lex_state = 15},
  [2023] = {.lex_state = 52, .external_lex_state = 15},
  [2024] = {.lex_state = 7, .external_lex_state = 11},
  [2025] = {.lex_state = 52, .external_lex_state = 14},
  [2026] = {.lex_state = 8, .external_lex_state = 15},
  [2027] = {.lex_state = 52, .external_lex_state = 15},
  [2028] = {.lex_state = 52, .external_lex_state = 11},
  [2029] = {.lex_state = 52, .external_lex_state = 15},
  [2030] = {.lex_state = 52, .external_lex_state = 15},
  [2031] = {.lex_state = 52, .external_lex_state = 13},
  [2032] = {.lex_state = 52, .external_lex_state = 13},
  [2033] = {.lex_state = 52, .external_lex_state = 15},
  [2034] = {.lex_state = 52, .external_lex_state = 15},
  [2035] = {.lex_state = 52, .external_lex_state = 15},
  [2036] = {.lex_state = 52, .external_lex_state = 15},
  [2037] = {.lex_state = 52, .external_lex_state = 15},
  [2038] = {.lex_state = 52, .external_lex_state = 11},
  [2039] = {.lex_state = 52, .external_lex_state = 15},
  [2040] = {.lex_state = 8, .external_lex_state = 12},
  [2041] = {.lex_state = 3, .external_lex_state = 13},
  [2042] = {.lex_state = 52, .external_lex_state = 13},
  [2043] = {.lex_state = 52, .external_lex_state = 15},
  [2044] = {.lex_state = 52, .external_lex_state = 15},
  [2045] = {.lex_state = 52, .external_lex_state = 11},
  [2046] = {.lex_state = 8, .external_lex_state = 12},
  [2047] = {.lex_state = 52, .external_lex_state = 14},
  [2048] = {.lex_state = 52, .external_lex_state = 13},
  [2049] = {.lex_state = 52, .external_lex_state = 14},
  [2050] = {.lex_state = 52, .external_lex_state = 13},
  [2051] = {.lex_state = 52, .external_lex_state = 13},
  [2052] = {.lex_state = 52, .external_lex_state = 12},
  [2053] = {.lex_state = 52, .external_lex_state = 13},
  [2054] = {.lex_state = 52, .external_lex_state = 13},
  [2055] = {.lex_state = 52, .external_lex_state = 14},
  [2056] = {.lex_state = 52, .external_lex_state = 13},
  [2057] = {.lex_state = 52, .external_lex_state = 13},
  [2058] = {.lex_state = 52, .external_lex_state = 13},
  [2059] = {.lex_state = 52, .external_lex_state = 15},
  [2060] = {.lex_state = 52, .external_lex_state = 15},
  [2061] = {.lex_state = 52, .external_lex_state = 13},
  [2062] = {.lex_state = 52, .external_lex_state = 15},
  [2063] = {.lex_state = 52, .external_lex_state = 12},
  [2064] = {.lex_state = 52, .external_lex_state = 13},
  [2065] = {.lex_state = 52, .external_lex_state = 14},
  [2066] = {.lex_state = 52, .external_lex_state = 13},
  [2067] = {.lex_state = 52, .external_lex_state = 12},
  [2068] = {.lex_state = 52, .external_lex_state = 13},
  [2069] = {.lex_state = 52, .external_lex_state = 15},
  [2070] = {.lex_state = 52, .external_lex_state = 15},
  [2071] = {.lex_state = 52, .external_lex_state = 15},
  [2072] = {.lex_state = 52, .external_lex_state = 12},
  [2073] = {.lex_state = 8, .external_lex_state = 12},
  [2074] = {.lex_state = 8, .external_lex_state = 15},
  [2075] = {.lex_state = 52, .external_lex_state = 14},
  [2076] = {.lex_state = 52, .external_lex_state = 11},
  [2077] = {.lex_state = 52, .external_lex_state = 15},
  [2078] = {.lex_state = 52, .external_lex_state = 12},
  [2079] = {.lex_state = 52, .external_lex_state = 15},
  [2080] = {.lex_state = 8, .external_lex_state = 15},
  [2081] = {.lex_state = 8, .external_lex_state = 15},
  [2082] = {.lex_state = 8, .external_lex_state = 15},
  [2083] = {.lex_state = 8, .external_lex_state = 12},
  [2084] = {.lex_state = 8, .external_lex_state = 12},
  [2085] = {.lex_state = 8, .external_lex_state = 12},
  [2086] = {.lex_state = 52, .external_lex_state = 15},
  [2087] = {.lex_state = 52, .external_lex_state = 14},
  [2088] = {.lex_state = 52, .external_lex_state = 13},
  [2089] = {.lex_state = 52, .external_lex_state = 15},
  [2090] = {.lex_state = 52, .external_lex_state = 12},
  [2091] = {.lex_state = 52, .external_lex_state = 11},
  [2092] = {.lex_state = 3, .external_lex_state = 13},
  [2093] = {.lex_state = 52, .external_lex_state = 15},
  [2094] = {.lex_state = 52, .external_lex_state = 13},
  [2095] = {.lex_state = 8, .external_lex_state = 15},
  [2096] = {.lex_state = 52, .external_lex_state = 15},
  [2097] = {.lex_state = 52, .external_lex_state = 15},
  [2098] = {.lex_state = 3, .external_lex_state = 13},
  [2099] = {.lex_state = 8, .external_lex_state = 12},
  [2100] = {.lex_state = 8, .external_lex_state = 14},
  [2101] = {.lex_state = 52, .external_lex_state = 14},
  [2102] = {.lex_state = 52, .external_lex_state = 15},
  [2103] = {.lex_state = 52, .external_lex_state = 13},
  [2104] = {.lex_state = 52, .external_lex_state = 13},
  [2105] = {.lex_state = 52, .external_lex_state = 17},
  [2106] = {.lex_state = 52, .external_lex_state = 15},
  [2107] = {.lex_state = 52, .external_lex_state = 15},
  [2108] = {.lex_state = 52, .external_lex_state = 11},
  [2109] = {.lex_state = 52, .external_lex_state = 11},
  [2110] = {.lex_state = 52, .external_lex_state = 17},
  [2111] = {.lex_state = 52, .external_lex_state = 11},
  [2112] = {.lex_state = 52, .external_lex_state = 11},
  [2113] = {.lex_state = 52, .external_lex_state = 11},
  [2114] = {.lex_state = 52, .external_lex_state = 17},
  [2115] = {.lex_state = 52, .external_lex_state = 11},
  [2116] = {.lex_state = 52, .external_lex_state = 13},
  [2117] = {.lex_state = 52, .external_lex_state = 11},
  [2118] = {.lex_state = 52, .external_lex_state = 14},
  [2119] = {.lex_state = 52, .external_lex_state = 12},
  [2120] = {.lex_state = 52, .external_lex_state = 12},
  [2121] = {.lex_state = 52, .external_lex_state = 12},
  [2122] = {.lex_state = 52, .external_lex_state = 12},
  [2123] = {.lex_state = 52, .external_lex_state = 12},
  [2124] = {.lex_state = 8, .external_lex_state = 15},
  [2125] = {.lex_state = 52, .external_lex_state = 14},
  [2126] = {.lex_state = 52, .external_lex_state = 12},
  [2127] = {.lex_state = 52, .external_lex_state = 12},
  [2128] = {.lex_state = 52, .external_lex_state = 12},
  [2129] = {.lex_state = 52, .external_lex_state = 12},
  [2130] = {.lex_state = 52, .external_lex_state = 12},
  [2131] = {.lex_state = 52, .external_lex_state = 12},
  [2132] = {.lex_state = 7, .external_lex_state = 15},
  [2133] = {.lex_state = 52, .external_lex_state = 12},
  [2134] = {.lex_state = 52, .external_lex_state = 12},
  [2135] = {.lex_state = 52, .external_lex_state = 12},
  [2136] = {.lex_state = 52, .external_lex_state = 12},
  [2137] = {.lex_state = 52, .external_lex_state = 12},
  [2138] = {.lex_state = 52, .external_lex_state = 12},
  [2139] = {.lex_state = 52, .external_lex_state = 12},
  [2140] = {.lex_state = 52, .external_lex_state = 12},
  [2141] = {.lex_state = 52, .external_lex_state = 12},
  [2142] = {.lex_state = 52, .external_lex_state = 12},
  [2143] = {.lex_state = 52, .external_lex_state = 12},
  [2144] = {.lex_state = 52, .external_lex_state = 12},
  [2145] = {.lex_state = 52, .external_lex_state = 12},
  [2146] = {.lex_state = 52, .external_lex_state = 12},
  [2147] = {.lex_state = 52, .external_lex_state = 11},
  [2148] = {.lex_state = 52, .external_lex_state = 14},
  [2149] = {.lex_state = 52, .external_lex_state = 12},
  [2150] = {.lex_state = 52, .external_lex_state = 15},
  [2151] = {.lex_state = 52, .external_lex_state = 15},
  [2152] = {.lex_state = 52, .external_lex_state = 17},
  [2153] = {.lex_state = 52, .external_lex_state = 14},
  [2154] = {.lex_state = 52, .external_lex_state = 11},
  [2155] = {.lex_state = 52, .external_lex_state = 14},
  [2156] = {.lex_state = 52, .external_lex_state = 14},
  [2157] = {.lex_state = 52, .external_lex_state = 14},
  [2158] = {.lex_state = 52, .external_lex_state = 14},
  [2159] = {.lex_state = 52, .external_lex_state = 14},
  [2160] = {.lex_state = 52, .external_lex_state = 15},
  [2161] = {.lex_state = 52, .external_lex_state = 11},
  [2162] = {.lex_state = 52, .external_lex_state = 11},
  [2163] = {.lex_state = 52, .external_lex_state = 14},
  [2164] = {.lex_state = 52, .external_lex_state = 12},
  [2165] = {.lex_state = 52, .external_lex_state = 14},
  [2166] = {.lex_state = 52, .external_lex_state = 14},
  [2167] = {.lex_state = 52, .external_lex_state = 14},
  [2168] = {.lex_state = 52, .external_lex_state = 14},
  [2169] = {.lex_state = 52, .external_lex_state = 14},
  [2170] = {.lex_state = 52, .external_lex_state = 14},
  [2171] = {.lex_state = 52, .external_lex_state = 14},
  [2172] = {.lex_state = 8, .external_lex_state = 15},
  [2173] = {.lex_state = 7, .external_lex_state = 15},
  [2174] = {.lex_state = 52, .external_lex_state = 14},
  [2175] = {.lex_state = 52, .external_lex_state = 15},
  [2176] = {.lex_state = 52, .external_lex_state = 14},
  [2177] = {.lex_state = 52, .external_lex_state = 14},
  [2178] = {.lex_state = 52, .external_lex_state = 14},
  [2179] = {.lex_state = 52, .external_lex_state = 14},
  [2180] = {.lex_state = 52, .external_lex_state = 14},
  [2181] = {.lex_state = 52, .external_lex_state = 14},
  [2182] = {.lex_state = 52, .external_lex_state = 14},
  [2183] = {.lex_state = 52, .external_lex_state = 14},
  [2184] = {.lex_state = 52, .external_lex_state = 14},
  [2185] = {.lex_state = 52, .external_lex_state = 14},
  [2186] = {.lex_state = 52, .external_lex_state = 14},
  [2187] = {.lex_state = 52, .external_lex_state = 14},
  [2188] = {.lex_state = 52, .external_lex_state = 14},
  [2189] = {.lex_state = 52, .external_lex_state = 14},
  [2190] = {.lex_state = 52, .external_lex_state = 12},
  [2191] = {.lex_state = 52, .external_lex_state = 13},
  [2192] = {.lex_state = 52, .external_lex_state = 13},
  [2193] = {.lex_state = 52, .external_lex_state = 13},
  [2194] = {.lex_state = 52, .external_lex_state = 14},
  [2195] = {.lex_state = 52, .external_lex_state = 13},
  [2196] = {.lex_state = 52, .external_lex_state = 13},
  [2197] = {.lex_state = 52, .external_lex_state = 13},
  [2198] = {.lex_state = 52, .external_lex_state = 13},
  [2199] = {.lex_state = 52, .external_lex_state = 13},
  [2200] = {.lex_state = 52, .external_lex_state = 13},
  [2201] = {.lex_state = 52, .external_lex_state = 13},
  [2202] = {.lex_state = 52, .external_lex_state = 13},
  [2203] = {.lex_state = 52, .external_lex_state = 13},
  [2204] = {.lex_state = 52, .external_lex_state = 13},
  [2205] = {.lex_state = 52, .external_lex_state = 13},
  [2206] = {.lex_state = 52, .external_lex_state = 13},
  [2207] = {.lex_state = 52, .external_lex_state = 13},
  [2208] = {.lex_state = 52, .external_lex_state = 13},
  [2209] = {.lex_state = 52, .external_lex_state = 13},
  [2210] = {.lex_state = 52, .external_lex_state = 13},
  [2211] = {.lex_state = 52, .external_lex_state = 13},
  [2212] = {.lex_state = 52, .external_lex_state = 13},
  [2213] = {.lex_state = 52, .external_lex_state = 13},
  [2214] = {.lex_state = 52, .external_lex_state = 11},
  [2215] = {.lex_state = 52, .external_lex_state = 17},
  [2216] = {.lex_state = 52, .external_lex_state = 11},
  [2217] = {.lex_state = 52, .external_lex_state = 11},
  [2218] = {.lex_state = 52, .external_lex_state = 15},
  [2219] = {.lex_state = 52, .external_lex_state = 13},
  [2220] = {.lex_state = 52, .external_lex_state = 11},
  [2221] = {.lex_state = 52, .external_lex_state = 11},
  [2222] = {.lex_state = 52, .external_lex_state = 11},
  [2223] = {.lex_state = 52, .external_lex_state = 15},
  [2224] = {.lex_state = 52, .external_lex_state = 15},
  [2225] = {.lex_state = 52, .external_lex_state = 14},
  [2226] = {.lex_state = 52, .external_lex_state = 14},
  [2227] = {.lex_state = 52, .external_lex_state = 15},
  [2228] = {.lex_state = 52, .external_lex_state = 15},
  [2229] = {.lex_state = 52, .external_lex_state = 14},
  [2230] = {.lex_state = 52, .external_lex_state = 15},
  [2231] = {.lex_state = 52, .external_lex_state = 14},
  [2232] = {.lex_state = 52, .external_lex_state = 14},
  [2233] = {.lex_state = 52, .external_lex_state = 12},
  [2234] = {.lex_state = 52, .external_lex_state = 13},
  [2235] = {.lex_state = 8, .external_lex_state = 15},
  [2236] = {.lex_state = 52, .external_lex_state = 12},
  [2237] = {.lex_state = 52, .external_lex_state = 11},
  [2238] = {.lex_state = 52, .external_lex_state = 14},
  [2239] = {.lex_state = 52, .external_lex_state = 14},
  [2240] = {.lex_state = 52, .external_lex_state = 13},
  [2241] = {.lex_state = 52, .external_lex_state = 14},
  [2242] = {.lex_state = 52, .external_lex_state = 14},
  [2243] = {.lex_state = 3, .external_lex_state = 13},
  [2244] = {.lex_state = 3, .external_lex_state = 13},
  [2245] = {.lex_state = 52, .external_lex_state = 12},
  [2246] = {.lex_state = 3, .external_lex_state = 13},
  [2247] = {.lex_state = 52, .external_lex_state = 11},
  [2248] = {.lex_state = 52, .external_lex_state = 14},
  [2249] = {.lex_state = 52, .external_lex_state = 15},
  [2250] = {.lex_state = 52, .external_lex_state = 14},
  [2251] = {.lex_state = 52, .external_lex_state = 12},
  [2252] = {.lex_state = 52, .external_lex_state = 12},
  [2253] = {.lex_state = 52, .external_lex_state = 12},
  [2254] = {.lex_state = 52, .external_lex_state = 14},
  [2255] = {.lex_state = 52, .external_lex_state = 14},
  [2256] = {.lex_state = 52, .external_lex_state = 15},
  [2257] = {.lex_state = 52, .external_lex_state = 14},
  [2258] = {.lex_state = 52, .external_lex_state = 13},
  [2259] = {.lex_state = 52, .external_lex_state = 15},
  [2260] = {.lex_state = 52, .external_lex_state = 14},
  [2261] = {.lex_state = 52, .external_lex_state = 12},
  [2262] = {.lex_state = 52, .external_lex_state = 13},
  [2263] = {.lex_state = 52, .external_lex_state = 13},
  [2264] = {.lex_state = 52, .external_lex_state = 14},
  [2265] = {.lex_state = 8, .external_lex_state = 15},
  [2266] = {.lex_state = 52, .external_lex_state = 11},
  [2267] = {.lex_state = 3, .external_lex_state = 13},
  [2268] = {.lex_state = 52, .external_lex_state = 13},
  [2269] = {.lex_state = 52, .external_lex_state = 14},
  [2270] = {.lex_state = 52, .external_lex_state = 11},
  [2271] = {.lex_state = 52, .external_lex_state = 18},
  [2272] = {.lex_state = 3, .external_lex_state = 13},
  [2273] = {.lex_state = 52, .external_lex_state = 14},
  [2274] = {.lex_state = 52, .external_lex_state = 14},
  [2275] = {.lex_state = 52, .external_lex_state = 15},
  [2276] = {.lex_state = 52, .external_lex_state = 13},
  [2277] = {.lex_state = 3, .external_lex_state = 13},
  [2278] = {.lex_state = 52, .external_lex_state = 11},
  [2279] = {.lex_state = 52, .external_lex_state = 11},
  [2280] = {.lex_state = 52, .external_lex_state = 12},
  [2281] = {.lex_state = 52, .external_lex_state = 11},
  [2282] = {.lex_state = 52, .external_lex_state = 13},
  [2283] = {.lex_state = 52, .external_lex_state = 12},
  [2284] = {.lex_state = 52, .external_lex_state = 13},
  [2285] = {.lex_state = 52, .external_lex_state = 14},
  [2286] = {.lex_state = 52, .external_lex_state = 14},
  [2287] = {.lex_state = 52, .external_lex_state = 14},
  [2288] = {.lex_state = 52, .external_lex_state = 12},
  [2289] = {.lex_state = 52, .external_lex_state = 14},
  [2290] = {.lex_state = 52, .external_lex_state = 14},
  [2291] = {.lex_state = 52, .external_lex_state = 12},
  [2292] = {.lex_state = 52, .external_lex_state = 14},
  [2293] = {.lex_state = 52, .external_lex_state = 13},
  [2294] = {.lex_state = 52, .external_lex_state = 12},
  [2295] = {.lex_state = 52, .external_lex_state = 12},
  [2296] = {.lex_state = 52, .external_lex_state = 15},
  [2297] = {.lex_state = 52, .external_lex_state = 12},
  [2298] = {.lex_state = 52, .external_lex_state = 12},
  [2299] = {.lex_state = 3, .external_lex_state = 13},
  [2300] = {.lex_state = 52, .external_lex_state = 11},
  [2301] = {.lex_state = 8, .external_lex_state = 15},
  [2302] = {.lex_state = 52, .external_lex_state = 15},
  [2303] = {.lex_state = 52, .external_lex_state = 13},
  [2304] = {.lex_state = 52, .external_lex_state = 14},
  [2305] = {.lex_state = 52, .external_lex_state = 12},
  [2306] = {.lex_state = 52, .external_lex_state = 12},
  [2307] = {.lex_state = 52, .external_lex_state = 13},
  [2308] = {.lex_state = 52, .external_lex_state = 13},
  [2309] = {.lex_state = 52, .external_lex_state = 13},
  [2310] = {.lex_state = 52, .external_lex_state = 15},
  [2311] = {.lex_state = 52, .external_lex_state = 14},
  [2312] = {.lex_state = 52, .external_lex_state = 14},
  [2313] = {.lex_state = 52, .external_lex_state = 14},
  [2314] = {.lex_state = 52, .external_lex_state = 14},
  [2315] = {.lex_state = 52, .external_lex_state = 12},
  [2316] = {.lex_state = 52, .external_lex_state = 14},
  [2317] = {.lex_state = 52, .external_lex_state = 18},
  [2318] = {.lex_state = 52, .external_lex_state = 14},
  [2319] = {.lex_state = 52, .external_lex_state = 11},
  [2320] = {.lex_state = 52, .external_lex_state = 14},
  [2321] = {.lex_state = 52, .external_lex_state = 14},
  [2322] = {.lex_state = 52, .external_lex_state = 14},
  [2323] = {.lex_state = 52, .external_lex_state = 14},
  [2324] = {.lex_state = 52, .external_lex_state = 13},
  [2325] = {.lex_state = 52, .external_lex_state = 14},
  [2326] = {.lex_state = 52, .external_lex_state = 13},
  [2327] = {.lex_state = 52, .external_lex_state = 11},
  [2328] = {.lex_state = 52, .external_lex_state = 18},
  [2329] = {.lex_state = 52, .external_lex_state = 13},
  [2330] = {.lex_state = 52, .external_lex_state = 13},
  [2331] = {.lex_state = 52, .external_lex_state = 13},
  [2332] = {.lex_state = 52, .external_lex_state = 14},
  [2333] = {.lex_state = 52, .external_lex_state = 14},
  [2334] = {.lex_state = 52, .external_lex_state = 13},
  [2335] = {.lex_state = 52, .external_lex_state = 12},
  [2336] = {.lex_state = 52, .external_lex_state = 14},
  [2337] = {.lex_state = 52, .external_lex_state = 14},
  [2338] = {.lex_state = 52, .external_lex_state = 14},
  [2339] = {.lex_state = 52, .external_lex_state = 15},
  [2340] = {.lex_state = 52, .external_lex_state = 12},
  [2341] = {.lex_state = 52, .external_lex_state = 12},
  [2342] = {.lex_state = 52, .external_lex_state = 14},
  [2343] = {.lex_state = 52, .external_lex_state = 18},
  [2344] = {.lex_state = 52, .external_lex_state = 15},
  [2345] = {.lex_state = 52, .external_lex_state = 14},
  [2346] = {.lex_state = 52, .external_lex_state = 14},
  [2347] = {.lex_state = 52, .external_lex_state = 15},
  [2348] = {.lex_state = 52, .external_lex_state = 12},
  [2349] = {.lex_state = 52, .external_lex_state = 15},
  [2350] = {.lex_state = 52, .external_lex_state = 15},
  [2351] = {.lex_state = 52, .external_lex_state = 12},
  [2352] = {.lex_state = 52, .external_lex_state = 14},
  [2353] = {.lex_state = 52, .external_lex_state = 14},
  [2354] = {.lex_state = 52, .external_lex_state = 12},
  [2355] = {.lex_state = 52, .external_lex_state = 13},
  [2356] = {.lex_state = 52, .external_lex_state = 13},
  [2357] = {.lex_state = 3, .external_lex_state = 13},
  [2358] = {.lex_state = 52, .external_lex_state = 15},
  [2359] = {.lex_state = 52, .external_lex_state = 13},
  [2360] = {.lex_state = 52, .external_lex_state = 13},
  [2361] = {.lex_state = 52, .external_lex_state = 14},
  [2362] = {.lex_state = 52, .external_lex_state = 14},
  [2363] = {.lex_state = 52, .external_lex_state = 12},
  [2364] = {.lex_state = 52, .external_lex_state = 14},
  [2365] = {.lex_state = 52, .external_lex_state = 14},
  [2366] = {.lex_state = 52, .external_lex_state = 14},
  [2367] = {.lex_state = 52, .external_lex_state = 13},
  [2368] = {.lex_state = 52, .external_lex_state = 14},
  [2369] = {.lex_state = 52, .external_lex_state = 12},
  [2370] = {.lex_state = 52, .external_lex_state = 12},
  [2371] = {.lex_state = 52, .external_lex_state = 14},
  [2372] = {.lex_state = 52, .external_lex_state = 13},
  [2373] = {.lex_state = 52, .external_lex_state = 13},
  [2374] = {.lex_state = 52, .external_lex_state = 13},
  [2375] = {.lex_state = 52, .external_lex_state = 14},
  [2376] = {.lex_state = 52, .external_lex_state = 14},
  [2377] = {.lex_state = 52, .external_lex_state = 13},
  [2378] = {.lex_state = 52, .external_lex_state = 14},
  [2379] = {.lex_state = 52, .external_lex_state = 13},
  [2380] = {.lex_state = 52, .external_lex_state = 14},
  [2381] = {.lex_state = 52, .external_lex_state = 13},
  [2382] = {.lex_state = 52, .external_lex_state = 14},
  [2383] = {.lex_state = 52, .external_lex_state = 14},
  [2384] = {.lex_state = 52, .external_lex_state = 14},
  [2385] = {.lex_state = 52, .external_lex_state = 12},
  [2386] = {.lex_state = 52, .external_lex_state = 12},
  [2387] = {.lex_state = 52, .external_lex_state = 12},
  [2388] = {.lex_state = 52, .external_lex_state = 14},
  [2389] = {.lex_state = 52, .external_lex_state = 13},
  [2390] = {.lex_state = 52, .external_lex_state = 14},
  [2391] = {.lex_state = 52, .external_lex_state = 14},
  [2392] = {.lex_state = 52, .external_lex_state = 12},
  [2393] = {.lex_state = 52, .external_lex_state = 12},
  [2394] = {.lex_state = 52, .external_lex_state = 12},
  [2395] = {.lex_state = 52, .external_lex_state = 12},
  [2396] = {.lex_state = 52, .external_lex_state = 15},
  [2397] = {.lex_state = 52, .external_lex_state = 12},
  [2398] = {.lex_state = 52, .external_lex_state = 14},
  [2399] = {.lex_state = 52, .external_lex_state = 12},
  [2400] = {.lex_state = 52, .external_lex_state = 15},
  [2401] = {.lex_state = 52, .external_lex_state = 14},
  [2402] = {.lex_state = 8, .external_lex_state = 15},
  [2403] = {.lex_state = 52, .external_lex_state = 13},
  [2404] = {.lex_state = 52, .external_lex_state = 14},
  [2405] = {.lex_state = 52, .external_lex_state = 14},
  [2406] = {.lex_state = 52, .external_lex_state = 11},
  [2407] = {.lex_state = 52, .external_lex_state = 13},
  [2408] = {.lex_state = 52, .external_lex_state = 14},
  [2409] = {.lex_state = 52, .external_lex_state = 14},
  [2410] = {.lex_state = 52, .external_lex_state = 15},
  [2411] = {.lex_state = 52, .external_lex_state = 12},
  [2412] = {.lex_state = 52, .external_lex_state = 14},
  [2413] = {.lex_state = 52, .external_lex_state = 14},
  [2414] = {.lex_state = 52, .external_lex_state = 12},
  [2415] = {.lex_state = 52, .external_lex_state = 12},
  [2416] = {.lex_state = 52, .external_lex_state = 12},
  [2417] = {.lex_state = 52, .external_lex_state = 12},
  [2418] = {.lex_state = 52, .external_lex_state = 11},
  [2419] = {.lex_state = 52, .external_lex_state = 14},
  [2420] = {.lex_state = 52, .external_lex_state = 18},
  [2421] = {.lex_state = 52, .external_lex_state = 12},
  [2422] = {.lex_state = 52, .external_lex_state = 12},
  [2423] = {.lex_state = 52, .external_lex_state = 12},
  [2424] = {.lex_state = 52, .external_lex_state = 15},
  [2425] = {.lex_state = 52, .external_lex_state = 14},
  [2426] = {.lex_state = 52, .external_lex_state = 12},
  [2427] = {.lex_state = 52, .external_lex_state = 12},
  [2428] = {.lex_state = 52, .external_lex_state = 12},
  [2429] = {.lex_state = 52, .external_lex_state = 14},
  [2430] = {.lex_state = 52, .external_lex_state = 13},
  [2431] = {.lex_state = 52, .external_lex_state = 18},
  [2432] = {.lex_state = 52, .external_lex_state = 15},
  [2433] = {.lex_state = 52, .external_lex_state = 11},
  [2434] = {.lex_state = 52, .external_lex_state = 13},
  [2435] = {.lex_state = 52, .external_lex_state = 11},
  [2436] = {.lex_state = 52, .external_lex_state = 15},
  [2437] = {.lex_state = 52, .external_lex_state = 15},
  [2438] = {.lex_state = 52, .external_lex_state = 15},
  [2439] = {.lex_state = 52, .external_lex_state = 15},
  [2440] = {.lex_state = 52, .external_lex_state = 11},
  [2441] = {.lex_state = 52, .external_lex_state = 15},
  [2442] = {.lex_state = 52, .external_lex_state = 14},
  [2443] = {.lex_state = 52, .external_lex_state = 18},
  [2444] = {.lex_state = 52, .external_lex_state = 14},
  [2445] = {.lex_state = 8, .external_lex_state = 15},
  [2446] = {.lex_state = 52, .external_lex_state = 12},
  [2447] = {.lex_state = 8, .external_lex_state = 15},
  [2448] = {.lex_state = 8, .external_lex_state = 15},
  [2449] = {.lex_state = 8, .external_lex_state = 15},
  [2450] = {.lex_state = 52, .external_lex_state = 15},
  [2451] = {.lex_state = 52, .external_lex_state = 11},
  [2452] = {.lex_state = 52, .external_lex_state = 13},
  [2453] = {.lex_state = 52, .external_lex_state = 15},
  [2454] = {.lex_state = 52, .external_lex_state = 15},
  [2455] = {.lex_state = 3, .external_lex_state = 13},
  [2456] = {.lex_state = 52, .external_lex_state = 14},
  [2457] = {.lex_state = 52, .external_lex_state = 13},
  [2458] = {.lex_state = 52, .external_lex_state = 14},
  [2459] = {.lex_state = 52, .external_lex_state = 11},
  [2460] = {.lex_state = 52, .external_lex_state = 14},
  [2461] = {.lex_state = 52, .external_lex_state = 13},
  [2462] = {.lex_state = 52, .external_lex_state = 15},
  [2463] = {.lex_state = 52, .external_lex_state = 12},
  [2464] = {.lex_state = 52, .external_lex_state = 11},
  [2465] = {.lex_state = 52, .external_lex_state = 15},
  [2466] = {.lex_state = 52, .external_lex_state = 14},
  [2467] = {.lex_state = 52, .external_lex_state = 14},
  [2468] = {.lex_state = 52, .external_lex_state = 14},
  [2469] = {.lex_state = 52, .external_lex_state = 18},
  [2470] = {.lex_state = 52, .external_lex_state = 15},
  [2471] = {.lex_state = 52, .external_lex_state = 12},
  [2472] = {.lex_state = 52, .external_lex_state = 12},
  [2473] = {.lex_state = 52, .external_lex_state = 13},
  [2474] = {.lex_state = 52, .external_lex_state = 14},
  [2475] = {.lex_state = 52, .external_lex_state = 15},
  [2476] = {.lex_state = 52, .external_lex_state = 14},
  [2477] = {.lex_state = 52, .external_lex_state = 15},
  [2478] = {.lex_state = 52, .external_lex_state = 15},
  [2479] = {.lex_state = 52, .external_lex_state = 14},
  [2480] = {.lex_state = 52, .external_lex_state = 12},
  [2481] = {.lex_state = 52, .external_lex_state = 11},
  [2482] = {.lex_state = 52, .external_lex_state = 14},
  [2483] = {.lex_state = 52, .external_lex_state = 14},
  [2484] = {.lex_state = 52, .external_lex_state = 15},
  [2485] = {.lex_state = 52, .external_lex_state = 11},
  [2486] = {.lex_state = 52, .external_lex_state = 15},
  [2487] = {.lex_state = 52, .external_lex_state = 12},
  [2488] = {.lex_state = 52, .external_lex_state = 17},
  [2489] = {.lex_state = 52, .external_lex_state = 15},
  [2490] = {.lex_state = 52, .external_lex_state = 11},
  [2491] = {.lex_state = 52, .external_lex_state = 17},
  [2492] = {.lex_state = 52, .external_lex_state = 17},
  [2493] = {.lex_state = 52, .external_lex_state = 17},
  [2494] = {.lex_state = 9, .external_lex_state = 15},
  [2495] = {.lex_state = 52, .external_lex_state = 17},
  [2496] = {.lex_state = 52, .external_lex_state = 15},
  [2497] = {.lex_state = 52, .external_lex_state = 15},
  [2498] = {.lex_state = 52, .external_lex_state = 13},
  [2499] = {.lex_state = 52, .external_lex_state = 17},
  [2500] = {.lex_state = 52, .external_lex_state = 15},
  [2501] = {.lex_state = 52, .external_lex_state = 17},
  [2502] = {.lex_state = 52, .external_lex_state = 15},
  [2503] = {.lex_state = 52, .external_lex_state = 15},
  [2504] = {.lex_state = 52, .external_lex_state = 17},
  [2505] = {.lex_state = 52, .external_lex_state = 11},
  [2506] = {.lex_state = 52, .external_lex_state = 15},
  [2507] = {.lex_state = 52, .external_lex_state = 14},
  [2508] = {.lex_state = 52, .external_lex_state = 15},
  [2509] = {.lex_state = 52, .external_lex_state = 11},
  [2510] = {.lex_state = 52, .external_lex_state = 15},
  [2511] = {.lex_state = 52, .external_lex_state = 15},
  [2512] = {.lex_state = 52, .external_lex_state = 14},
  [2513] = {.lex_state = 52, .external_lex_state = 15},
  [2514] = {.lex_state = 52, .external_lex_state = 15},
  [2515] = {.lex_state = 52, .external_lex_state = 15},
  [2516] = {.lex_state = 52, .external_lex_state = 14},
  [2517] = {.lex_state = 52, .external_lex_state = 15},
  [2518] = {.lex_state = 52, .external_lex_state = 15},
  [2519] = {.lex_state = 52, .external_lex_state = 17},
  [2520] = {.lex_state = 52, .external_lex_state = 17},
  [2521] = {.lex_state = 52, .external_lex_state = 15},
  [2522] = {.lex_state = 52, .external_lex_state = 15},
  [2523] = {.lex_state = 52, .external_lex_state = 11},
  [2524] = {.lex_state = 52, .external_lex_state = 17},
  [2525] = {.lex_state = 52, .external_lex_state = 13},
  [2526] = {.lex_state = 52, .external_lex_state = 13},
  [2527] = {.lex_state = 52, .external_lex_state = 12},
  [2528] = {.lex_state = 52, .external_lex_state = 17},
  [2529] = {.lex_state = 52, .external_lex_state = 13},
  [2530] = {.lex_state = 9, .external_lex_state = 15},
  [2531] = {.lex_state = 52, .external_lex_state = 14},
  [2532] = {.lex_state = 52, .external_lex_state = 17},
  [2533] = {.lex_state = 52, .external_lex_state = 17},
  [2534] = {.lex_state = 52, .external_lex_state = 11},
  [2535] = {.lex_state = 52, .external_lex_state = 11},
  [2536] = {.lex_state = 52, .external_lex_state = 11},
  [2537] = {.lex_state = 52, .external_lex_state = 17},
  [2538] = {.lex_state = 52, .external_lex_state = 11},
  [2539] = {.lex_state = 52, .external_lex_state = 12},
  [2540] = {.lex_state = 9, .external_lex_state = 15},
  [2541] = {.lex_state = 52, .external_lex_state = 11},
  [2542] = {.lex_state = 52, .external_lex_state = 14},
  [2543] = {.lex_state = 9, .external_lex_state = 15},
  [2544] = {.lex_state = 52, .external_lex_state = 14},
  [2545] = {.lex_state = 52, .external_lex_state = 12},
  [2546] = {.lex_state = 52, .external_lex_state = 14},
  [2547] = {.lex_state = 52, .external_lex_state = 11},
  [2548] = {.lex_state = 9, .external_lex_state = 15},
  [2549] = {.lex_state = 52, .external_lex_state = 14},
  [2550] = {.lex_state = 9, .external_lex_state = 15},
  [2551] = {.lex_state = 9, .external_lex_state = 15},
  [2552] = {.lex_state = 9, .external_lex_state = 15},
  [2553] = {.lex_state = 9, .external_lex_state = 15},
  [2554] = {.lex_state = 52, .external_lex_state = 14},
  [2555] = {.lex_state = 52, .external_lex_state = 11},
  [2556] = {.lex_state = 52, .external_lex_state = 15},
  [2557] = {.lex_state = 52, .external_lex_state = 11},
  [2558] = {.lex_state = 52, .external_lex_state = 12},
  [2559] = {.lex_state = 52, .external_lex_state = 11},
  [2560] = {.lex_state = 52, .external_lex_state = 17},
  [2561] = {.lex_state = 9, .external_lex_state = 15},
  [2562] = {.lex_state = 52, .external_lex_state = 17},
  [2563] = {.lex_state = 52, .external_lex_state = 11},
  [2564] = {.lex_state = 52, .external_lex_state = 14},
  [2565] = {.lex_state = 52, .external_lex_state = 12},
  [2566] = {.lex_state = 52, .external_lex_state = 11},
  [2567] = {.lex_state = 52, .external_lex_state = 15},
  [2568] = {.lex_state = 52, .external_lex_state = 14},
  [2569] = {.lex_state = 52, .external_lex_state = 12},
  [2570] = {.lex_state = 52, .external_lex_state = 12},
  [2571] = {.lex_state = 52, .external_lex_state = 13},
  [2572] = {.lex_state = 52, .external_lex_state = 15},
  [2573] = {.lex_state = 52, .external_lex_state = 11},
  [2574] = {.lex_state = 52, .external_lex_state = 12},
  [2575] = {.lex_state = 52, .external_lex_state = 17},
  [2576] = {.lex_state = 52, .external_lex_state = 15},
  [2577] = {.lex_state = 52, .external_lex_state = 14},
  [2578] = {.lex_state = 52, .external_lex_state = 15},
  [2579] = {.lex_state = 52, .external_lex_state = 15},
  [2580] = {.lex_state = 52, .external_lex_state = 15},
  [2581] = {.lex_state = 52, .external_lex_state = 14},
  [2582] = {.lex_state = 52, .external_lex_state = 13},
  [2583] = {.lex_state = 52, .external_lex_state = 14},
  [2584] = {.lex_state = 52, .external_lex_state = 14},
  [2585] = {.lex_state = 4, .external_lex_state = 15},
  [2586] = {.lex_state = 52, .external_lex_state = 15},
  [2587] = {.lex_state = 52, .external_lex_state = 15},
  [2588] = {.lex_state = 52, .external_lex_state = 15},
  [2589] = {.lex_state = 52, .external_lex_state = 14},
  [2590] = {.lex_state = 52, .external_lex_state = 14},
  [2591] = {.lex_state = 52, .external_lex_state = 12},
  [2592] = {.lex_state = 52, .external_lex_state = 12},
  [2593] = {.lex_state = 52, .external_lex_state = 13},
  [2594] = {.lex_state = 52, .external_lex_state = 15},
  [2595] = {.lex_state = 52, .external_lex_state = 14},
  [2596] = {.lex_state = 52, .external_lex_state = 13},
  [2597] = {.lex_state = 52, .external_lex_state = 15},
  [2598] = {.lex_state = 52, .external_lex_state = 15},
  [2599] = {.lex_state = 52, .external_lex_state = 14},
  [2600] = {.lex_state = 52, .external_lex_state = 14},
  [2601] = {.lex_state = 52, .external_lex_state = 12},
  [2602] = {.lex_state = 52, .external_lex_state = 14},
  [2603] = {.lex_state = 52, .external_lex_state = 15},
  [2604] = {.lex_state = 52, .external_lex_state = 13},
  [2605] = {.lex_state = 52, .external_lex_state = 13},
  [2606] = {.lex_state = 52, .external_lex_state = 15},
  [2607] = {.lex_state = 52, .external_lex_state = 14},
  [2608] = {.lex_state = 52, .external_lex_state = 15},
  [2609] = {.lex_state = 52, .external_lex_state = 13},
  [2610] = {.lex_state = 52, .external_lex_state = 15},
  [2611] = {.lex_state = 52, .external_lex_state = 15},
  [2612] = {.lex_state = 52, .external_lex_state = 13},
  [2613] = {.lex_state = 52, .external_lex_state = 15},
  [2614] = {.lex_state = 52, .external_lex_state = 12},
  [2615] = {.lex_state = 52, .external_lex_state = 14},
  [2616] = {.lex_state = 4, .external_lex_state = 15},
  [2617] = {.lex_state = 52, .external_lex_state = 15},
  [2618] = {.lex_state = 52, .external_lex_state = 15},
  [2619] = {.lex_state = 52, .external_lex_state = 15},
  [2620] = {.lex_state = 52, .external_lex_state = 15},
  [2621] = {.lex_state = 52, .external_lex_state = 13},
  [2622] = {.lex_state = 52, .external_lex_state = 14},
  [2623] = {.lex_state = 52, .external_lex_state = 15},
  [2624] = {.lex_state = 52, .external_lex_state = 15},
  [2625] = {.lex_state = 52, .external_lex_state = 15},
  [2626] = {.lex_state = 52, .external_lex_state = 14},
  [2627] = {.lex_state = 52, .external_lex_state = 15},
  [2628] = {.lex_state = 52, .external_lex_state = 13},
  [2629] = {.lex_state = 52, .external_lex_state = 13},
  [2630] = {.lex_state = 52, .external_lex_state = 15},
  [2631] = {.lex_state = 52, .external_lex_state = 15},
  [2632] = {.lex_state = 52, .external_lex_state = 13},
  [2633] = {.lex_state = 52, .external_lex_state = 15},
  [2634] = {.lex_state = 52, .external_lex_state = 15},
  [2635] = {.lex_state = 52, .external_lex_state = 15},
  [2636] = {.lex_state = 52, .external_lex_state = 15},
  [2637] = {.lex_state = 52, .external_lex_state = 15},
  [2638] = {.lex_state = 4, .external_lex_state = 15},
  [2639] = {.lex_state = 52, .external_lex_state = 15},
  [2640] = {.lex_state = 52, .external_lex_state = 15},
  [2641] = {.lex_state = 52, .external_lex_state = 14},
  [2642] = {.lex_state = 52, .external_lex_state = 15},
  [2643] = {.lex_state = 52, .external_lex_state = 15},
  [2644] = {.lex_state = 52, .external_lex_state = 13},
  [2645] = {.lex_state = 4, .external_lex_state = 15},
  [2646] = {.lex_state = 52, .external_lex_state = 15},
  [2647] = {.lex_state = 52, .external_lex_state = 14},
  [2648] = {.lex_state = 52, .external_lex_state = 12},
  [2649] = {.lex_state = 52, .external_lex_state = 15},
  [2650] = {.lex_state = 4, .external_lex_state = 15},
  [2651] = {.lex_state = 52, .external_lex_state = 13},
  [2652] = {.lex_state = 52, .external_lex_state = 15},
  [2653] = {.lex_state = 52, .external_lex_state = 14},
  [2654] = {.lex_state = 52, .external_lex_state = 13},
  [2655] = {.lex_state = 52, .external_lex_state = 14},
  [2656] = {.lex_state = 52, .external_lex_state = 15},
  [2657] = {.lex_state = 52, .external_lex_state = 12},
  [2658] = {.lex_state = 52, .external_lex_state = 15},
  [2659] = {.lex_state = 52, .external_lex_state = 14},
  [2660] = {.lex_state = 52, .external_lex_state = 13},
  [2661] = {.lex_state = 52, .external_lex_state = 12},
  [2662] = {.lex_state = 52, .external_lex_state = 15},
  [2663] = {.lex_state = 52, .external_lex_state = 15},
  [2664] = {.lex_state = 52, .external_lex_state = 12},
  [2665] = {.lex_state = 52, .external_lex_state = 13},
  [2666] = {.lex_state = 52, .external_lex_state = 12},
  [2667] = {.lex_state = 52, .external_lex_state = 15},
  [2668] = {.lex_state = 52, .external_lex_state = 15},
  [2669] = {.lex_state = 52, .external_lex_state = 15},
  [2670] = {.lex_state = 52, .external_lex_state = 15},
  [2671] = {.lex_state = 52, .external_lex_state = 15},
  [2672] = {.lex_state = 52, .external_lex_state = 13},
  [2673] = {.lex_state = 52, .external_lex_state = 15},
  [2674] = {.lex_state = 52, .external_lex_state = 15},
  [2675] = {.lex_state = 52, .external_lex_state = 15},
  [2676] = {.lex_state = 52, .external_lex_state = 13},
  [2677] = {.lex_state = 52, .external_lex_state = 15},
  [2678] = {.lex_state = 52, .external_lex_state = 12},
  [2679] = {.lex_state = 52, .external_lex_state = 15},
  [2680] = {.lex_state = 52, .external_lex_state = 15},
  [2681] = {.lex_state = 52, .external_lex_state = 14},
  [2682] = {.lex_state = 52, .external_lex_state = 12},
  [2683] = {.lex_state = 52, .external_lex_state = 13},
  [2684] = {.lex_state = 52, .external_lex_state = 15},
  [2685] = {.lex_state = 52, .external_lex_state = 12},
  [2686] = {.lex_state = 52, .external_lex_state = 12},
  [2687] = {.lex_state = 52, .external_lex_state = 13},
  [2688] = {.lex_state = 52, .external_lex_state = 15},
  [2689] = {.lex_state = 52, .external_lex_state = 12},
  [2690] = {.lex_state = 52, .external_lex_state = 15},
  [2691] = {.lex_state = 52, .external_lex_state = 15},
  [2692] = {.lex_state = 52, .external_lex_state = 13},
  [2693] = {.lex_state = 52, .external_lex_state = 14},
  [2694] = {.lex_state = 52, .external_lex_state = 15},
  [2695] = {.lex_state = 52, .external_lex_state = 15},
  [2696] = {.lex_state = 52, .external_lex_state = 13},
  [2697] = {.lex_state = 52, .external_lex_state = 12},
  [2698] = {.lex_state = 4, .external_lex_state = 15},
  [2699] = {.lex_state = 52, .external_lex_state = 13},
  [2700] = {.lex_state = 52, .external_lex_state = 12},
  [2701] = {.lex_state = 52, .external_lex_state = 14},
  [2702] = {.lex_state = 52, .external_lex_state = 13},
  [2703] = {.lex_state = 52, .external_lex_state = 15},
  [2704] = {.lex_state = 52, .external_lex_state = 13},
  [2705] = {.lex_state = 52, .external_lex_state = 15},
  [2706] = {.lex_state = 52, .external_lex_state = 13},
  [2707] = {.lex_state = 52, .external_lex_state = 15},
  [2708] = {.lex_state = 52, .external_lex_state = 13},
  [2709] = {.lex_state = 52, .external_lex_state = 14},
  [2710] = {.lex_state = 52, .external_lex_state = 13},
  [2711] = {.lex_state = 52, .external_lex_state = 15},
  [2712] = {.lex_state = 52, .external_lex_state = 14},
  [2713] = {.lex_state = 52, .external_lex_state = 13},
  [2714] = {.lex_state = 52, .external_lex_state = 15},
  [2715] = {.lex_state = 52, .external_lex_state = 14},
  [2716] = {.lex_state = 4, .external_lex_state = 15},
  [2717] = {.lex_state = 52, .external_lex_state = 15},
  [2718] = {.lex_state = 52, .external_lex_state = 12},
  [2719] = {.lex_state = 52, .external_lex_state = 12},
  [2720] = {.lex_state = 52, .external_lex_state = 15},
  [2721] = {.lex_state = 52, .external_lex_state = 13},
  [2722] = {.lex_state = 52, .external_lex_state = 15},
  [2723] = {.lex_state = 52, .external_lex_state = 13},
  [2724] = {.lex_state = 52, .external_lex_state = 13},
  [2725] = {.lex_state = 52, .external_lex_state = 13},
  [2726] = {.lex_state = 52, .external_lex_state = 14},
  [2727] = {.lex_state = 52, .external_lex_state = 15},
  [2728] = {.lex_state = 52, .external_lex_state = 15},
  [2729] = {.lex_state = 4, .external_lex_state = 15},
  [2730] = {.lex_state = 52, .external_lex_state = 13},
  [2731] = {.lex_state = 52, .external_lex_state = 15},
  [2732] = {.lex_state = 52, .external_lex_state = 15},
  [2733] = {.lex_state = 52, .external_lex_state = 14},
  [2734] = {.lex_state = 52, .external_lex_state = 13},
  [2735] = {.lex_state = 52, .external_lex_state = 15},
  [2736] = {.lex_state = 52, .external_lex_state = 15},
  [2737] = {.lex_state = 52, .external_lex_state = 14},
  [2738] = {.lex_state = 52, .external_lex_state = 15},
  [2739] = {.lex_state = 52, .external_lex_state = 14},
  [2740] = {.lex_state = 52, .external_lex_state = 13},
  [2741] = {.lex_state = 52, .external_lex_state = 15},
  [2742] = {.lex_state = 52, .external_lex_state = 15},
  [2743] = {.lex_state = 52, .external_lex_state = 14},
  [2744] = {.lex_state = 52, .external_lex_state = 13},
  [2745] = {.lex_state = 52, .external_lex_state = 15},
  [2746] = {.lex_state = 52, .external_lex_state = 15},
  [2747] = {.lex_state = 52, .external_lex_state = 15},
  [2748] = {.lex_state = 52, .external_lex_state = 13},
  [2749] = {.lex_state = 52, .external_lex_state = 15},
  [2750] = {.lex_state = 52, .external_lex_state = 15},
  [2751] = {.lex_state = 52, .external_lex_state = 15},
  [2752] = {.lex_state = 52, .external_lex_state = 14},
  [2753] = {.lex_state = 52, .external_lex_state = 12},
  [2754] = {.lex_state = 52, .external_lex_state = 15},
  [2755] = {.lex_state = 52, .external_lex_state = 15},
  [2756] = {.lex_state = 52, .external_lex_state = 14},
  [2757] = {.lex_state = 52, .external_lex_state = 13},
  [2758] = {.lex_state = 52, .external_lex_state = 13},
  [2759] = {.lex_state = 52, .external_lex_state = 14},
  [2760] = {.lex_state = 52, .external_lex_state = 15},
  [2761] = {.lex_state = 52, .external_lex_state = 15},
  [2762] = {.lex_state = 52, .external_lex_state = 15},
  [2763] = {.lex_state = 52, .external_lex_state = 14},
  [2764] = {.lex_state = 52, .external_lex_state = 15},
  [2765] = {.lex_state = 52, .external_lex_state = 15},
  [2766] = {.lex_state = 52, .external_lex_state = 15},
  [2767] = {.lex_state = 52, .external_lex_state = 15},
  [2768] = {.lex_state = 52, .external_lex_state = 15},
  [2769] = {.lex_state = 52, .external_lex_state = 15},
  [2770] = {.lex_state = 52, .external_lex_state = 15},
  [2771] = {.lex_state = 52, .external_lex_state = 15},
  [2772] = {.lex_state = 52, .external_lex_state = 15},
  [2773] = {.lex_state = 52, .external_lex_state = 15},
  [2774] = {.lex_state = 52, .external_lex_state = 12},
  [2775] = {.lex_state = 52, .external_lex_state = 12},
  [2776] = {.lex_state = 52, .external_lex_state = 15},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2755),
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1817),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1817),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [2] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2495),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [3] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(696),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [4] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [5] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(725),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [6] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(740),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [7] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(724),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [8] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(729),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [9] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(731),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [10] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(736),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [11] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(697),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [12] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(710),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [13] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(634),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [14] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(744),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [15] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(750),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [16] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(751),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [17] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(683),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [18] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(756),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [19] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(641),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [20] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(668),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [21] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(758),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [22] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(689),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [23] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2499),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [24] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(763),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [25] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(766),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [26] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2492),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [27] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(768),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [28] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(767),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [29] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(648),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [30] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(426),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [31] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2520),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [32] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2524),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [33] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(2532),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [34] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(666),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [35] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(620),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [36] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(622),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [37] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(653),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [38] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(654),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [39] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(606),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [40] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(417),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [41] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(614),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [42] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(693),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [43] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(797),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [44] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(799),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [45] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(806),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [46] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(812),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [47] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(814),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [48] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(816),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [49] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(820),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [50] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(702),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [51] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(711),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [52] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(830),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [53] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(714),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [54] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(718),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [55] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(706),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [56] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(717),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [57] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(825),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [58] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(682),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [59] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(742),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [60] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(765),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [61] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1819),
    [sym_block] = STATE(649),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [62] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [63] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1817),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1817),
    [ts_builtin_sym_end] = ACTIONS(113),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [64] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [65] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(120),
    [anon_sym_from] = ACTIONS(123),
    [anon_sym_LPAREN] = ACTIONS(126),
    [anon_sym_STAR] = ACTIONS(129),
    [anon_sym_print] = ACTIONS(132),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_del] = ACTIONS(141),
    [anon_sym_raise] = ACTIONS(144),
    [anon_sym_pass] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(156),
    [anon_sym_match] = ACTIONS(159),
    [anon_sym_async] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(168),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(174),
    [anon_sym_def] = ACTIONS(177),
    [anon_sym_global] = ACTIONS(180),
    [anon_sym_nonlocal] = ACTIONS(183),
    [anon_sym_exec] = ACTIONS(186),
    [anon_sym_type] = ACTIONS(189),
    [anon_sym_class] = ACTIONS(192),
    [anon_sym_LBRACK] = ACTIONS(195),
    [anon_sym_AT] = ACTIONS(198),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_LBRACE] = ACTIONS(204),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_not] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(201),
    [anon_sym_lambda] = ACTIONS(210),
    [anon_sym_yield] = ACTIONS(213),
    [sym_ellipsis] = ACTIONS(216),
    [sym_integer] = ACTIONS(219),
    [sym_float] = ACTIONS(216),
    [anon_sym_await] = ACTIONS(222),
    [sym_true] = ACTIONS(219),
    [sym_false] = ACTIONS(219),
    [sym_none] = ACTIONS(219),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(225),
    [sym_string_start] = ACTIONS(227),
  },
  [66] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1817),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1817),
    [ts_builtin_sym_end] = ACTIONS(225),
    [sym_identifier] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(120),
    [anon_sym_from] = ACTIONS(123),
    [anon_sym_LPAREN] = ACTIONS(126),
    [anon_sym_STAR] = ACTIONS(129),
    [anon_sym_print] = ACTIONS(132),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_del] = ACTIONS(141),
    [anon_sym_raise] = ACTIONS(144),
    [anon_sym_pass] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_match] = ACTIONS(233),
    [anon_sym_async] = ACTIONS(236),
    [anon_sym_for] = ACTIONS(239),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(245),
    [anon_sym_with] = ACTIONS(248),
    [anon_sym_def] = ACTIONS(251),
    [anon_sym_global] = ACTIONS(180),
    [anon_sym_nonlocal] = ACTIONS(183),
    [anon_sym_exec] = ACTIONS(186),
    [anon_sym_type] = ACTIONS(189),
    [anon_sym_class] = ACTIONS(254),
    [anon_sym_LBRACK] = ACTIONS(195),
    [anon_sym_AT] = ACTIONS(198),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_LBRACE] = ACTIONS(204),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_not] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(201),
    [anon_sym_lambda] = ACTIONS(210),
    [anon_sym_yield] = ACTIONS(213),
    [sym_ellipsis] = ACTIONS(216),
    [sym_integer] = ACTIONS(219),
    [sym_float] = ACTIONS(216),
    [anon_sym_await] = ACTIONS(222),
    [sym_true] = ACTIONS(219),
    [sym_false] = ACTIONS(219),
    [sym_none] = ACTIONS(219),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(227),
  },
  [67] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(257),
    [sym_string_start] = ACTIONS(81),
  },
  [68] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(259),
    [sym_string_start] = ACTIONS(81),
  },
  [69] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1819),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1819),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(261),
    [sym_string_start] = ACTIONS(81),
  },
  [70] = {
    [sym_named_expression] = STATE(1723),
    [sym__named_expression_lhs] = STATE(2729),
    [sym_type_parameter] = STATE(2081),
    [sym_list_splat_pattern] = STATE(1372),
    [sym_as_pattern] = STATE(1723),
    [sym_expression] = STATE(1762),
    [sym_primary_expression] = STATE(952),
    [sym_not_operator] = STATE(1723),
    [sym_boolean_operator] = STATE(1723),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_comparison_operator] = STATE(1723),
    [sym_lambda] = STATE(1723),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_type] = STATE(2124),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1723),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(263),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(275),
    [anon_sym_print] = ACTIONS(278),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_match] = ACTIONS(285),
    [anon_sym_async] = ACTIONS(278),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(278),
    [anon_sym_type] = ACTIONS(290),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(294),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(296),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(296),
    [anon_sym_not] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(306),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(314),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(316),
  },
  [71] = {
    [sym_named_expression] = STATE(1723),
    [sym__named_expression_lhs] = STATE(2729),
    [sym_list_splat_pattern] = STATE(1372),
    [sym_as_pattern] = STATE(1723),
    [sym_expression] = STATE(1762),
    [sym_primary_expression] = STATE(952),
    [sym_not_operator] = STATE(1723),
    [sym_boolean_operator] = STATE(1723),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_comparison_operator] = STATE(1723),
    [sym_lambda] = STATE(1723),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_type] = STATE(2124),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1723),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(263),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(275),
    [anon_sym_print] = ACTIONS(278),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(292),
    [anon_sym_match] = ACTIONS(285),
    [anon_sym_async] = ACTIONS(278),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(278),
    [anon_sym_type] = ACTIONS(290),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(318),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(296),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(296),
    [anon_sym_not] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(306),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(314),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(316),
  },
  [72] = {
    [sym__simple_statements] = STATE(832),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(343),
    [sym__indent] = ACTIONS(345),
    [sym_string_start] = ACTIONS(81),
  },
  [73] = {
    [sym__simple_statements] = STATE(759),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__indent] = ACTIONS(349),
    [sym_string_start] = ACTIONS(81),
  },
  [74] = {
    [sym__simple_statements] = STATE(833),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(351),
    [sym__indent] = ACTIONS(353),
    [sym_string_start] = ACTIONS(81),
  },
  [75] = {
    [sym__simple_statements] = STATE(743),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym_string_start] = ACTIONS(81),
  },
  [76] = {
    [sym__simple_statements] = STATE(747),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym_string_start] = ACTIONS(81),
  },
  [77] = {
    [sym__simple_statements] = STATE(764),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym_string_start] = ACTIONS(81),
  },
  [78] = {
    [sym__simple_statements] = STATE(755),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym_string_start] = ACTIONS(81),
  },
  [79] = {
    [sym__simple_statements] = STATE(828),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(624),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1685),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_call] = STATE(1099),
    [sym_type] = STATE(1987),
    [sym_splat_type] = STATE(2074),
    [sym_generic_type] = STATE(2074),
    [sym_union_type] = STATE(2074),
    [sym_constrained_type] = STATE(2074),
    [sym_member_type] = STATE(2074),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_print] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(329),
    [anon_sym_async] = ACTIONS(331),
    [anon_sym_STAR_STAR] = ACTIONS(333),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(335),
    [anon_sym_type] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(341),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym_string_start] = ACTIONS(81),
  },
  [80] = {
    [sym_chevron] = STATE(2147),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_list_splat_pattern] = STATE(1047),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1801),
    [sym_primary_expression] = STATE(845),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(380),
    [anon_sym_print] = ACTIONS(383),
    [anon_sym_GT_GT] = ACTIONS(385),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_match] = ACTIONS(387),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(383),
    [anon_sym_type] = ACTIONS(387),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(392),
    [anon_sym_not] = ACTIONS(395),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(398),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [81] = {
    [sym_chevron] = STATE(2147),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_list_splat_pattern] = STATE(1047),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1801),
    [sym_primary_expression] = STATE(845),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(380),
    [anon_sym_print] = ACTIONS(383),
    [anon_sym_GT_GT] = ACTIONS(385),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(292),
    [anon_sym_match] = ACTIONS(387),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(383),
    [anon_sym_type] = ACTIONS(387),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(392),
    [anon_sym_not] = ACTIONS(395),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(398),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [82] = {
    [sym_named_expression] = STATE(1723),
    [sym__named_expression_lhs] = STATE(2729),
    [sym_list_splat_pattern] = STATE(1372),
    [sym_as_pattern] = STATE(1723),
    [sym_expression] = STATE(1842),
    [sym_primary_expression] = STATE(952),
    [sym_not_operator] = STATE(1723),
    [sym_boolean_operator] = STATE(1723),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_comparison_operator] = STATE(1723),
    [sym_lambda] = STATE(1723),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1723),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(402),
    [anon_sym_print] = ACTIONS(278),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(292),
    [anon_sym_match] = ACTIONS(285),
    [anon_sym_async] = ACTIONS(278),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(278),
    [anon_sym_type] = ACTIONS(285),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(318),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(296),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(296),
    [anon_sym_not] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(306),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(314),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(316),
  },
  [83] = {
    [sym_named_expression] = STATE(1723),
    [sym__named_expression_lhs] = STATE(2729),
    [sym_list_splat_pattern] = STATE(1372),
    [sym_as_pattern] = STATE(1723),
    [sym_expression] = STATE(1846),
    [sym_primary_expression] = STATE(952),
    [sym_not_operator] = STATE(1723),
    [sym_boolean_operator] = STATE(1723),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_comparison_operator] = STATE(1723),
    [sym_lambda] = STATE(1723),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1723),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(402),
    [anon_sym_print] = ACTIONS(278),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(292),
    [anon_sym_match] = ACTIONS(285),
    [anon_sym_async] = ACTIONS(278),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(278),
    [anon_sym_type] = ACTIONS(285),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(318),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(296),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(296),
    [anon_sym_not] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_lambda] = ACTIONS(306),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(314),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(316),
  },
  [84] = {
    [sym__simple_statements] = STATE(700),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(409),
    [sym__indent] = ACTIONS(411),
    [sym_string_start] = ACTIONS(81),
  },
  [85] = {
    [sym__simple_statements] = STATE(635),
    [sym_import_statement] = STATE(2451),
    [sym_future_import_statement] = STATE(2451),
    [sym_import_from_statement] = STATE(2451),
    [sym_print_statement] = STATE(2451),
    [sym_assert_statement] = STATE(2451),
    [sym_expression_statement] = STATE(2451),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2451),
    [sym_delete_statement] = STATE(2451),
    [sym_raise_statement] = STATE(2451),
    [sym_pass_statement] = STATE(2451),
    [sym_break_statement] = STATE(2451),
    [sym_continue_statement] = STATE(2451),
    [sym_global_statement] = STATE(2451),
    [sym_nonlocal_statement] = STATE(2451),
    [sym_exec_statement] = STATE(2451),
    [sym_type_alias_statement] = STATE(2451),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(413),
    [sym__indent] = ACTIONS(415),
    [sym_string_start] = ACTIONS(81),
  },
  [86] = {
    [sym__simple_statements] = STATE(686),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym__indent] = ACTIONS(419),
    [sym_string_start] = ACTIONS(81),
  },
  [87] = {
    [sym__simple_statements] = STATE(2575),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__indent] = ACTIONS(423),
    [sym_string_start] = ACTIONS(81),
  },
  [88] = {
    [sym__simple_statements] = STATE(440),
    [sym_import_statement] = STATE(2270),
    [sym_future_import_statement] = STATE(2270),
    [sym_import_from_statement] = STATE(2270),
    [sym_print_statement] = STATE(2270),
    [sym_assert_statement] = STATE(2270),
    [sym_expression_statement] = STATE(2270),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2270),
    [sym_delete_statement] = STATE(2270),
    [sym_raise_statement] = STATE(2270),
    [sym_pass_statement] = STATE(2270),
    [sym_break_statement] = STATE(2270),
    [sym_continue_statement] = STATE(2270),
    [sym_global_statement] = STATE(2270),
    [sym_nonlocal_statement] = STATE(2270),
    [sym_exec_statement] = STATE(2270),
    [sym_type_alias_statement] = STATE(2270),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__indent] = ACTIONS(427),
    [sym_string_start] = ACTIONS(81),
  },
  [89] = {
    [sym__simple_statements] = STATE(609),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(429),
    [sym__indent] = ACTIONS(431),
    [sym_string_start] = ACTIONS(81),
  },
  [90] = {
    [sym__simple_statements] = STATE(684),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(433),
    [sym__indent] = ACTIONS(435),
    [sym_string_start] = ACTIONS(81),
  },
  [91] = {
    [sym__simple_statements] = STATE(715),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(437),
    [sym__indent] = ACTIONS(439),
    [sym_string_start] = ACTIONS(81),
  },
  [92] = {
    [sym__simple_statements] = STATE(785),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(441),
    [sym__indent] = ACTIONS(443),
    [sym_string_start] = ACTIONS(81),
  },
  [93] = {
    [sym__simple_statements] = STATE(786),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(445),
    [sym__indent] = ACTIONS(447),
    [sym_string_start] = ACTIONS(81),
  },
  [94] = {
    [sym__simple_statements] = STATE(611),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(449),
    [sym__indent] = ACTIONS(451),
    [sym_string_start] = ACTIONS(81),
  },
  [95] = {
    [sym__simple_statements] = STATE(791),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__indent] = ACTIONS(455),
    [sym_string_start] = ACTIONS(81),
  },
  [96] = {
    [sym__simple_statements] = STATE(726),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__indent] = ACTIONS(459),
    [sym_string_start] = ACTIONS(81),
  },
  [97] = {
    [sym__simple_statements] = STATE(749),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(461),
    [sym__indent] = ACTIONS(463),
    [sym_string_start] = ACTIONS(81),
  },
  [98] = {
    [sym__simple_statements] = STATE(798),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(465),
    [sym__indent] = ACTIONS(467),
    [sym_string_start] = ACTIONS(81),
  },
  [99] = {
    [sym__simple_statements] = STATE(705),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__indent] = ACTIONS(471),
    [sym_string_start] = ACTIONS(81),
  },
  [100] = {
    [sym__simple_statements] = STATE(800),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(473),
    [sym__indent] = ACTIONS(475),
    [sym_string_start] = ACTIONS(81),
  },
  [101] = {
    [sym__simple_statements] = STATE(801),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(477),
    [sym__indent] = ACTIONS(479),
    [sym_string_start] = ACTIONS(81),
  },
  [102] = {
    [sym__simple_statements] = STATE(741),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(481),
    [sym__indent] = ACTIONS(483),
    [sym_string_start] = ACTIONS(81),
  },
  [103] = {
    [sym__simple_statements] = STATE(807),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(485),
    [sym__indent] = ACTIONS(487),
    [sym_string_start] = ACTIONS(81),
  },
  [104] = {
    [sym__simple_statements] = STATE(698),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__indent] = ACTIONS(491),
    [sym_string_start] = ACTIONS(81),
  },
  [105] = {
    [sym__simple_statements] = STATE(709),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(493),
    [sym__indent] = ACTIONS(495),
    [sym_string_start] = ACTIONS(81),
  },
  [106] = {
    [sym__simple_statements] = STATE(664),
    [sym_import_statement] = STATE(2270),
    [sym_future_import_statement] = STATE(2270),
    [sym_import_from_statement] = STATE(2270),
    [sym_print_statement] = STATE(2270),
    [sym_assert_statement] = STATE(2270),
    [sym_expression_statement] = STATE(2270),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2270),
    [sym_delete_statement] = STATE(2270),
    [sym_raise_statement] = STATE(2270),
    [sym_pass_statement] = STATE(2270),
    [sym_break_statement] = STATE(2270),
    [sym_continue_statement] = STATE(2270),
    [sym_global_statement] = STATE(2270),
    [sym_nonlocal_statement] = STATE(2270),
    [sym_exec_statement] = STATE(2270),
    [sym_type_alias_statement] = STATE(2270),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(497),
    [sym__indent] = ACTIONS(499),
    [sym_string_start] = ACTIONS(81),
  },
  [107] = {
    [sym__simple_statements] = STATE(809),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(501),
    [sym__indent] = ACTIONS(503),
    [sym_string_start] = ACTIONS(81),
  },
  [108] = {
    [sym__simple_statements] = STATE(688),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(505),
    [sym__indent] = ACTIONS(507),
    [sym_string_start] = ACTIONS(81),
  },
  [109] = {
    [sym__simple_statements] = STATE(813),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(509),
    [sym__indent] = ACTIONS(511),
    [sym_string_start] = ACTIONS(81),
  },
  [110] = {
    [sym__simple_statements] = STATE(707),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(513),
    [sym__indent] = ACTIONS(515),
    [sym_string_start] = ACTIONS(81),
  },
  [111] = {
    [sym__simple_statements] = STATE(815),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(517),
    [sym__indent] = ACTIONS(519),
    [sym_string_start] = ACTIONS(81),
  },
  [112] = {
    [sym__simple_statements] = STATE(2491),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(521),
    [sym__indent] = ACTIONS(523),
    [sym_string_start] = ACTIONS(81),
  },
  [113] = {
    [sym__simple_statements] = STATE(703),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(525),
    [sym__indent] = ACTIONS(527),
    [sym_string_start] = ACTIONS(81),
  },
  [114] = {
    [sym__simple_statements] = STATE(629),
    [sym_import_statement] = STATE(2451),
    [sym_future_import_statement] = STATE(2451),
    [sym_import_from_statement] = STATE(2451),
    [sym_print_statement] = STATE(2451),
    [sym_assert_statement] = STATE(2451),
    [sym_expression_statement] = STATE(2451),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2451),
    [sym_delete_statement] = STATE(2451),
    [sym_raise_statement] = STATE(2451),
    [sym_pass_statement] = STATE(2451),
    [sym_break_statement] = STATE(2451),
    [sym_continue_statement] = STATE(2451),
    [sym_global_statement] = STATE(2451),
    [sym_nonlocal_statement] = STATE(2451),
    [sym_exec_statement] = STATE(2451),
    [sym_type_alias_statement] = STATE(2451),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(529),
    [sym__indent] = ACTIONS(531),
    [sym_string_start] = ACTIONS(81),
  },
  [115] = {
    [sym__simple_statements] = STATE(822),
    [sym_import_statement] = STATE(2459),
    [sym_future_import_statement] = STATE(2459),
    [sym_import_from_statement] = STATE(2459),
    [sym_print_statement] = STATE(2459),
    [sym_assert_statement] = STATE(2459),
    [sym_expression_statement] = STATE(2459),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2459),
    [sym_delete_statement] = STATE(2459),
    [sym_raise_statement] = STATE(2459),
    [sym_pass_statement] = STATE(2459),
    [sym_break_statement] = STATE(2459),
    [sym_continue_statement] = STATE(2459),
    [sym_global_statement] = STATE(2459),
    [sym_nonlocal_statement] = STATE(2459),
    [sym_exec_statement] = STATE(2459),
    [sym_type_alias_statement] = STATE(2459),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(533),
    [sym__indent] = ACTIONS(535),
    [sym_string_start] = ACTIONS(81),
  },
  [116] = {
    [sym__simple_statements] = STATE(2504),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(537),
    [sym__indent] = ACTIONS(539),
    [sym_string_start] = ACTIONS(81),
  },
  [117] = {
    [sym__simple_statements] = STATE(720),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(541),
    [sym__indent] = ACTIONS(543),
    [sym_string_start] = ACTIONS(81),
  },
  [118] = {
    [sym__simple_statements] = STATE(667),
    [sym_import_statement] = STATE(2270),
    [sym_future_import_statement] = STATE(2270),
    [sym_import_from_statement] = STATE(2270),
    [sym_print_statement] = STATE(2270),
    [sym_assert_statement] = STATE(2270),
    [sym_expression_statement] = STATE(2270),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2270),
    [sym_delete_statement] = STATE(2270),
    [sym_raise_statement] = STATE(2270),
    [sym_pass_statement] = STATE(2270),
    [sym_break_statement] = STATE(2270),
    [sym_continue_statement] = STATE(2270),
    [sym_global_statement] = STATE(2270),
    [sym_nonlocal_statement] = STATE(2270),
    [sym_exec_statement] = STATE(2270),
    [sym_type_alias_statement] = STATE(2270),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(545),
    [sym__indent] = ACTIONS(547),
    [sym_string_start] = ACTIONS(81),
  },
  [119] = {
    [sym__simple_statements] = STATE(642),
    [sym_import_statement] = STATE(2270),
    [sym_future_import_statement] = STATE(2270),
    [sym_import_from_statement] = STATE(2270),
    [sym_print_statement] = STATE(2270),
    [sym_assert_statement] = STATE(2270),
    [sym_expression_statement] = STATE(2270),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2270),
    [sym_delete_statement] = STATE(2270),
    [sym_raise_statement] = STATE(2270),
    [sym_pass_statement] = STATE(2270),
    [sym_break_statement] = STATE(2270),
    [sym_continue_statement] = STATE(2270),
    [sym_global_statement] = STATE(2270),
    [sym_nonlocal_statement] = STATE(2270),
    [sym_exec_statement] = STATE(2270),
    [sym_type_alias_statement] = STATE(2270),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(549),
    [sym__indent] = ACTIONS(551),
    [sym_string_start] = ACTIONS(81),
  },
  [120] = {
    [sym__simple_statements] = STATE(646),
    [sym_import_statement] = STATE(2451),
    [sym_future_import_statement] = STATE(2451),
    [sym_import_from_statement] = STATE(2451),
    [sym_print_statement] = STATE(2451),
    [sym_assert_statement] = STATE(2451),
    [sym_expression_statement] = STATE(2451),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2451),
    [sym_delete_statement] = STATE(2451),
    [sym_raise_statement] = STATE(2451),
    [sym_pass_statement] = STATE(2451),
    [sym_break_statement] = STATE(2451),
    [sym_continue_statement] = STATE(2451),
    [sym_global_statement] = STATE(2451),
    [sym_nonlocal_statement] = STATE(2451),
    [sym_exec_statement] = STATE(2451),
    [sym_type_alias_statement] = STATE(2451),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(553),
    [sym__indent] = ACTIONS(555),
    [sym_string_start] = ACTIONS(81),
  },
  [121] = {
    [sym__simple_statements] = STATE(728),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(557),
    [sym__indent] = ACTIONS(559),
    [sym_string_start] = ACTIONS(81),
  },
  [122] = {
    [sym__simple_statements] = STATE(760),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(561),
    [sym__indent] = ACTIONS(563),
    [sym_string_start] = ACTIONS(81),
  },
  [123] = {
    [sym__simple_statements] = STATE(2493),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(565),
    [sym__indent] = ACTIONS(567),
    [sym_string_start] = ACTIONS(81),
  },
  [124] = {
    [sym__simple_statements] = STATE(730),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(569),
    [sym__indent] = ACTIONS(571),
    [sym_string_start] = ACTIONS(81),
  },
  [125] = {
    [sym__simple_statements] = STATE(2501),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(573),
    [sym__indent] = ACTIONS(575),
    [sym_string_start] = ACTIONS(81),
  },
  [126] = {
    [sym__simple_statements] = STATE(761),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(577),
    [sym__indent] = ACTIONS(579),
    [sym_string_start] = ACTIONS(81),
  },
  [127] = {
    [sym__simple_statements] = STATE(694),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(581),
    [sym__indent] = ACTIONS(583),
    [sym_string_start] = ACTIONS(81),
  },
  [128] = {
    [sym__simple_statements] = STATE(737),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(585),
    [sym__indent] = ACTIONS(587),
    [sym_string_start] = ACTIONS(81),
  },
  [129] = {
    [sym__simple_statements] = STATE(2528),
    [sym_import_statement] = STATE(2319),
    [sym_future_import_statement] = STATE(2319),
    [sym_import_from_statement] = STATE(2319),
    [sym_print_statement] = STATE(2319),
    [sym_assert_statement] = STATE(2319),
    [sym_expression_statement] = STATE(2319),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2319),
    [sym_delete_statement] = STATE(2319),
    [sym_raise_statement] = STATE(2319),
    [sym_pass_statement] = STATE(2319),
    [sym_break_statement] = STATE(2319),
    [sym_continue_statement] = STATE(2319),
    [sym_global_statement] = STATE(2319),
    [sym_nonlocal_statement] = STATE(2319),
    [sym_exec_statement] = STATE(2319),
    [sym_type_alias_statement] = STATE(2319),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(589),
    [sym__indent] = ACTIONS(591),
    [sym_string_start] = ACTIONS(81),
  },
  [130] = {
    [sym__simple_statements] = STATE(639),
    [sym_import_statement] = STATE(2270),
    [sym_future_import_statement] = STATE(2270),
    [sym_import_from_statement] = STATE(2270),
    [sym_print_statement] = STATE(2270),
    [sym_assert_statement] = STATE(2270),
    [sym_expression_statement] = STATE(2270),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2270),
    [sym_delete_statement] = STATE(2270),
    [sym_raise_statement] = STATE(2270),
    [sym_pass_statement] = STATE(2270),
    [sym_break_statement] = STATE(2270),
    [sym_continue_statement] = STATE(2270),
    [sym_global_statement] = STATE(2270),
    [sym_nonlocal_statement] = STATE(2270),
    [sym_exec_statement] = STATE(2270),
    [sym_type_alias_statement] = STATE(2270),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(593),
    [sym__indent] = ACTIONS(595),
    [sym_string_start] = ACTIONS(81),
  },
  [131] = {
    [sym__simple_statements] = STATE(410),
    [sym_import_statement] = STATE(2451),
    [sym_future_import_statement] = STATE(2451),
    [sym_import_from_statement] = STATE(2451),
    [sym_print_statement] = STATE(2451),
    [sym_assert_statement] = STATE(2451),
    [sym_expression_statement] = STATE(2451),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2451),
    [sym_delete_statement] = STATE(2451),
    [sym_raise_statement] = STATE(2451),
    [sym_pass_statement] = STATE(2451),
    [sym_break_statement] = STATE(2451),
    [sym_continue_statement] = STATE(2451),
    [sym_global_statement] = STATE(2451),
    [sym_nonlocal_statement] = STATE(2451),
    [sym_exec_statement] = STATE(2451),
    [sym_type_alias_statement] = STATE(2451),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(597),
    [sym__indent] = ACTIONS(599),
    [sym_string_start] = ACTIONS(81),
  },
  [132] = {
    [sym__simple_statements] = STATE(796),
    [sym_import_statement] = STATE(2406),
    [sym_future_import_statement] = STATE(2406),
    [sym_import_from_statement] = STATE(2406),
    [sym_print_statement] = STATE(2406),
    [sym_assert_statement] = STATE(2406),
    [sym_expression_statement] = STATE(2406),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2406),
    [sym_delete_statement] = STATE(2406),
    [sym_raise_statement] = STATE(2406),
    [sym_pass_statement] = STATE(2406),
    [sym_break_statement] = STATE(2406),
    [sym_continue_statement] = STATE(2406),
    [sym_global_statement] = STATE(2406),
    [sym_nonlocal_statement] = STATE(2406),
    [sym_exec_statement] = STATE(2406),
    [sym_type_alias_statement] = STATE(2406),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(601),
    [sym__indent] = ACTIONS(603),
    [sym_string_start] = ACTIONS(81),
  },
  [133] = {
    [sym__simple_statements] = STATE(636),
    [sym_import_statement] = STATE(2451),
    [sym_future_import_statement] = STATE(2451),
    [sym_import_from_statement] = STATE(2451),
    [sym_print_statement] = STATE(2451),
    [sym_assert_statement] = STATE(2451),
    [sym_expression_statement] = STATE(2451),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2451),
    [sym_delete_statement] = STATE(2451),
    [sym_raise_statement] = STATE(2451),
    [sym_pass_statement] = STATE(2451),
    [sym_break_statement] = STATE(2451),
    [sym_continue_statement] = STATE(2451),
    [sym_global_statement] = STATE(2451),
    [sym_nonlocal_statement] = STATE(2451),
    [sym_exec_statement] = STATE(2451),
    [sym_type_alias_statement] = STATE(2451),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(605),
    [sym__indent] = ACTIONS(607),
    [sym_string_start] = ACTIONS(81),
  },
  [134] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(609),
    [sym_string_start] = ACTIONS(81),
  },
  [135] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(611),
    [sym_string_start] = ACTIONS(81),
  },
  [136] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(613),
    [sym_string_start] = ACTIONS(81),
  },
  [137] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(615),
    [sym_string_start] = ACTIONS(81),
  },
  [138] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(617),
    [sym_string_start] = ACTIONS(81),
  },
  [139] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(619),
    [sym_string_start] = ACTIONS(81),
  },
  [140] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(621),
    [sym_string_start] = ACTIONS(81),
  },
  [141] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(623),
    [sym_string_start] = ACTIONS(81),
  },
  [142] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(625),
    [sym_string_start] = ACTIONS(81),
  },
  [143] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(627),
    [sym_string_start] = ACTIONS(81),
  },
  [144] = {
    [sym_import_statement] = STATE(2509),
    [sym_future_import_statement] = STATE(2509),
    [sym_import_from_statement] = STATE(2509),
    [sym_print_statement] = STATE(2509),
    [sym_assert_statement] = STATE(2509),
    [sym_expression_statement] = STATE(2509),
    [sym_named_expression] = STATE(1649),
    [sym__named_expression_lhs] = STATE(2616),
    [sym_return_statement] = STATE(2509),
    [sym_delete_statement] = STATE(2509),
    [sym_raise_statement] = STATE(2509),
    [sym_pass_statement] = STATE(2509),
    [sym_break_statement] = STATE(2509),
    [sym_continue_statement] = STATE(2509),
    [sym_global_statement] = STATE(2509),
    [sym_nonlocal_statement] = STATE(2509),
    [sym_exec_statement] = STATE(2509),
    [sym_type_alias_statement] = STATE(2509),
    [sym_pattern] = STATE(1624),
    [sym_tuple_pattern] = STATE(1626),
    [sym_list_pattern] = STATE(1626),
    [sym_list_splat_pattern] = STATE(628),
    [sym_as_pattern] = STATE(1649),
    [sym_expression] = STATE(1799),
    [sym_primary_expression] = STATE(949),
    [sym_not_operator] = STATE(1649),
    [sym_boolean_operator] = STATE(1649),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_comparison_operator] = STATE(1649),
    [sym_lambda] = STATE(1649),
    [sym_assignment] = STATE(2566),
    [sym_augmented_assignment] = STATE(2566),
    [sym_pattern_list] = STATE(1644),
    [sym_yield] = STATE(2566),
    [sym_attribute] = STATE(638),
    [sym_subscript] = STATE(638),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_conditional_expression] = STATE(1649),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(407),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [145] = {
    [sym_list_splat_pattern] = STATE(1047),
    [sym_primary_expression] = STATE(974),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(629),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_print] = ACTIONS(633),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_match] = ACTIONS(635),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(633),
    [anon_sym_type] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(639),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(639),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(641),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [146] = {
    [sym_list_splat_pattern] = STATE(1047),
    [sym_primary_expression] = STATE(974),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(629),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_print] = ACTIONS(633),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(292),
    [anon_sym_match] = ACTIONS(635),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(633),
    [anon_sym_type] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(639),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(639),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(641),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [147] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(660),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(660),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_SLASH_SLASH] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [anon_sym_PLUS_EQ] = ACTIONS(643),
    [anon_sym_DASH_EQ] = ACTIONS(643),
    [anon_sym_STAR_EQ] = ACTIONS(643),
    [anon_sym_SLASH_EQ] = ACTIONS(643),
    [anon_sym_AT_EQ] = ACTIONS(643),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(643),
    [anon_sym_PERCENT_EQ] = ACTIONS(643),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(643),
    [anon_sym_GT_GT_EQ] = ACTIONS(643),
    [anon_sym_LT_LT_EQ] = ACTIONS(643),
    [anon_sym_AMP_EQ] = ACTIONS(643),
    [anon_sym_CARET_EQ] = ACTIONS(643),
    [anon_sym_PIPE_EQ] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(643),
    [sym_string_start] = ACTIONS(316),
  },
  [148] = {
    [sym_list_splat_pattern] = STATE(1047),
    [sym_primary_expression] = STATE(974),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_from] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(629),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_print] = ACTIONS(633),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(635),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(633),
    [anon_sym_type] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(641),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [149] = {
    [sym_list_splat_pattern] = STATE(1197),
    [sym_primary_expression] = STATE(1020),
    [sym_binary_operator] = STATE(1279),
    [sym_unary_operator] = STATE(1279),
    [sym_attribute] = STATE(1279),
    [sym_subscript] = STATE(1279),
    [sym_call] = STATE(1279),
    [sym_list] = STATE(1279),
    [sym_set] = STATE(1279),
    [sym_tuple] = STATE(1279),
    [sym_dictionary] = STATE(1279),
    [sym_list_comprehension] = STATE(1279),
    [sym_dictionary_comprehension] = STATE(1279),
    [sym_set_comprehension] = STATE(1279),
    [sym_generator_expression] = STATE(1279),
    [sym_parenthesized_expression] = STATE(1279),
    [sym_concatenated_string] = STATE(1279),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1279),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(666),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(668),
    [anon_sym_print] = ACTIONS(670),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(672),
    [anon_sym_async] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(670),
    [anon_sym_type] = ACTIONS(672),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(680),
    [sym_type_conversion] = ACTIONS(265),
    [sym_integer] = ACTIONS(664),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(664),
    [sym_false] = ACTIONS(664),
    [sym_none] = ACTIONS(664),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(684),
  },
  [150] = {
    [sym_list_splat_pattern] = STATE(1047),
    [sym_primary_expression] = STATE(974),
    [sym_binary_operator] = STATE(1099),
    [sym_unary_operator] = STATE(1099),
    [sym_attribute] = STATE(1099),
    [sym_subscript] = STATE(1099),
    [sym_call] = STATE(1099),
    [sym_list] = STATE(1099),
    [sym_set] = STATE(1099),
    [sym_tuple] = STATE(1099),
    [sym_dictionary] = STATE(1099),
    [sym_list_comprehension] = STATE(1099),
    [sym_dictionary_comprehension] = STATE(1099),
    [sym_set_comprehension] = STATE(1099),
    [sym_generator_expression] = STATE(1099),
    [sym_parenthesized_expression] = STATE(1099),
    [sym_concatenated_string] = STATE(1099),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1099),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_from] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(629),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_print] = ACTIONS(633),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(635),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(633),
    [anon_sym_type] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(641),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [151] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_type_conversion] = ACTIONS(643),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [152] = {
    [sym_list_splat_pattern] = STATE(1197),
    [sym_primary_expression] = STATE(1020),
    [sym_binary_operator] = STATE(1279),
    [sym_unary_operator] = STATE(1279),
    [sym_attribute] = STATE(1279),
    [sym_subscript] = STATE(1279),
    [sym_call] = STATE(1279),
    [sym_list] = STATE(1279),
    [sym_set] = STATE(1279),
    [sym_tuple] = STATE(1279),
    [sym_dictionary] = STATE(1279),
    [sym_list_comprehension] = STATE(1279),
    [sym_dictionary_comprehension] = STATE(1279),
    [sym_set_comprehension] = STATE(1279),
    [sym_generator_expression] = STATE(1279),
    [sym_parenthesized_expression] = STATE(1279),
    [sym_concatenated_string] = STATE(1279),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1279),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(666),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(668),
    [anon_sym_print] = ACTIONS(670),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(672),
    [anon_sym_async] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(670),
    [anon_sym_type] = ACTIONS(672),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(680),
    [sym_type_conversion] = ACTIONS(265),
    [sym_integer] = ACTIONS(664),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(664),
    [sym_false] = ACTIONS(664),
    [sym_none] = ACTIONS(664),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(684),
  },
  [153] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_from] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(643),
    [sym_string_start] = ACTIONS(316),
  },
  [154] = {
    [sym_list_splat_pattern] = STATE(1283),
    [sym_primary_expression] = STATE(991),
    [sym_binary_operator] = STATE(1280),
    [sym_unary_operator] = STATE(1280),
    [sym_attribute] = STATE(1280),
    [sym_subscript] = STATE(1280),
    [sym_call] = STATE(1280),
    [sym_list] = STATE(1280),
    [sym_set] = STATE(1280),
    [sym_tuple] = STATE(1280),
    [sym_dictionary] = STATE(1280),
    [sym_list_comprehension] = STATE(1280),
    [sym_dictionary_comprehension] = STATE(1280),
    [sym_set_comprehension] = STATE(1280),
    [sym_generator_expression] = STATE(1280),
    [sym_parenthesized_expression] = STATE(1280),
    [sym_concatenated_string] = STATE(1280),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1280),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(691),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(693),
    [anon_sym_print] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(697),
    [anon_sym_async] = ACTIONS(695),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(695),
    [anon_sym_type] = ACTIONS(697),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(703),
    [anon_sym_PLUS] = ACTIONS(701),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(701),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(705),
    [sym_integer] = ACTIONS(689),
    [sym_float] = ACTIONS(705),
    [anon_sym_await] = ACTIONS(707),
    [sym_true] = ACTIONS(689),
    [sym_false] = ACTIONS(689),
    [sym_none] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(709),
  },
  [155] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_else] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [156] = {
    [sym_list_splat_pattern] = STATE(1301),
    [sym_primary_expression] = STATE(1071),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(995),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(711),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(715),
    [anon_sym_print] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(719),
    [anon_sym_async] = ACTIONS(717),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(717),
    [anon_sym_type] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(721),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(723),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(725),
    [anon_sym_PLUS] = ACTIONS(723),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(723),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(727),
    [sym_integer] = ACTIONS(711),
    [sym_float] = ACTIONS(727),
    [anon_sym_await] = ACTIONS(729),
    [sym_true] = ACTIONS(711),
    [sym_false] = ACTIONS(711),
    [sym_none] = ACTIONS(711),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(731),
  },
  [157] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_RPAREN] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [158] = {
    [sym_list_splat_pattern] = STATE(1197),
    [sym_primary_expression] = STATE(1020),
    [sym_binary_operator] = STATE(1279),
    [sym_unary_operator] = STATE(1279),
    [sym_attribute] = STATE(1279),
    [sym_subscript] = STATE(1279),
    [sym_call] = STATE(1279),
    [sym_list] = STATE(1279),
    [sym_set] = STATE(1279),
    [sym_tuple] = STATE(1279),
    [sym_dictionary] = STATE(1279),
    [sym_list_comprehension] = STATE(1279),
    [sym_dictionary_comprehension] = STATE(1279),
    [sym_set_comprehension] = STATE(1279),
    [sym_generator_expression] = STATE(1279),
    [sym_parenthesized_expression] = STATE(1279),
    [sym_concatenated_string] = STATE(1279),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1279),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(666),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(668),
    [anon_sym_print] = ACTIONS(670),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(672),
    [anon_sym_async] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(670),
    [anon_sym_type] = ACTIONS(672),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(680),
    [sym_type_conversion] = ACTIONS(265),
    [sym_integer] = ACTIONS(664),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(664),
    [sym_false] = ACTIONS(664),
    [sym_none] = ACTIONS(664),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(684),
  },
  [159] = {
    [sym_list_splat_pattern] = STATE(1259),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1180),
    [sym_unary_operator] = STATE(1180),
    [sym_attribute] = STATE(1180),
    [sym_subscript] = STATE(1180),
    [sym_call] = STATE(1180),
    [sym_list] = STATE(1180),
    [sym_set] = STATE(1180),
    [sym_tuple] = STATE(1180),
    [sym_dictionary] = STATE(1180),
    [sym_list_comprehension] = STATE(1180),
    [sym_dictionary_comprehension] = STATE(1180),
    [sym_set_comprehension] = STATE(1180),
    [sym_generator_expression] = STATE(1180),
    [sym_parenthesized_expression] = STATE(1180),
    [sym_concatenated_string] = STATE(1180),
    [sym_string] = STATE(958),
    [sym_await] = STATE(1180),
    [sym_identifier] = ACTIONS(733),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(735),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(737),
    [anon_sym_print] = ACTIONS(739),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(741),
    [anon_sym_async] = ACTIONS(739),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(739),
    [anon_sym_type] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(747),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(745),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(745),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(749),
    [sym_integer] = ACTIONS(733),
    [sym_float] = ACTIONS(749),
    [anon_sym_await] = ACTIONS(751),
    [sym_true] = ACTIONS(733),
    [sym_false] = ACTIONS(733),
    [sym_none] = ACTIONS(733),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(753),
  },
  [160] = {
    [sym_list_splat_pattern] = STATE(1197),
    [sym_primary_expression] = STATE(1020),
    [sym_binary_operator] = STATE(1279),
    [sym_unary_operator] = STATE(1279),
    [sym_attribute] = STATE(1279),
    [sym_subscript] = STATE(1279),
    [sym_call] = STATE(1279),
    [sym_list] = STATE(1279),
    [sym_set] = STATE(1279),
    [sym_tuple] = STATE(1279),
    [sym_dictionary] = STATE(1279),
    [sym_list_comprehension] = STATE(1279),
    [sym_dictionary_comprehension] = STATE(1279),
    [sym_set_comprehension] = STATE(1279),
    [sym_generator_expression] = STATE(1279),
    [sym_parenthesized_expression] = STATE(1279),
    [sym_concatenated_string] = STATE(1279),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1279),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(666),
    [anon_sym_COMMA] = ACTIONS(686),
    [anon_sym_as] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(668),
    [anon_sym_print] = ACTIONS(670),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_match] = ACTIONS(672),
    [anon_sym_async] = ACTIONS(670),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(670),
    [anon_sym_type] = ACTIONS(672),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(686),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_not] = ACTIONS(645),
    [anon_sym_and] = ACTIONS(645),
    [anon_sym_or] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_is] = ACTIONS(645),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(686),
    [anon_sym_EQ_EQ] = ACTIONS(686),
    [anon_sym_BANG_EQ] = ACTIONS(686),
    [anon_sym_GT_EQ] = ACTIONS(686),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_GT] = ACTIONS(686),
    [sym_ellipsis] = ACTIONS(680),
    [sym_integer] = ACTIONS(664),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(664),
    [sym_false] = ACTIONS(664),
    [sym_none] = ACTIONS(664),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(684),
  },
  [161] = {
    [sym_list_splat_pattern] = STATE(1444),
    [sym_primary_expression] = STATE(1202),
    [sym_binary_operator] = STATE(1441),
    [sym_unary_operator] = STATE(1441),
    [sym_attribute] = STATE(1441),
    [sym_subscript] = STATE(1441),
    [sym_call] = STATE(1441),
    [sym_list] = STATE(1441),
    [sym_set] = STATE(1441),
    [sym_tuple] = STATE(1441),
    [sym_dictionary] = STATE(1441),
    [sym_list_comprehension] = STATE(1441),
    [sym_dictionary_comprehension] = STATE(1441),
    [sym_set_comprehension] = STATE(1441),
    [sym_generator_expression] = STATE(1441),
    [sym_parenthesized_expression] = STATE(1441),
    [sym_concatenated_string] = STATE(1441),
    [sym_string] = STATE(1081),
    [sym_await] = STATE(1441),
    [sym_identifier] = ACTIONS(755),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_COMMA] = ACTIONS(686),
    [anon_sym_as] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_print] = ACTIONS(761),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_match] = ACTIONS(763),
    [anon_sym_async] = ACTIONS(761),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(761),
    [anon_sym_type] = ACTIONS(763),
    [anon_sym_LBRACK] = ACTIONS(765),
    [anon_sym_RBRACK] = ACTIONS(686),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(767),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(769),
    [anon_sym_PLUS] = ACTIONS(767),
    [anon_sym_not] = ACTIONS(645),
    [anon_sym_and] = ACTIONS(645),
    [anon_sym_or] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(767),
    [anon_sym_is] = ACTIONS(645),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(686),
    [anon_sym_EQ_EQ] = ACTIONS(686),
    [anon_sym_BANG_EQ] = ACTIONS(686),
    [anon_sym_GT_EQ] = ACTIONS(686),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_GT] = ACTIONS(686),
    [sym_ellipsis] = ACTIONS(771),
    [sym_integer] = ACTIONS(755),
    [sym_float] = ACTIONS(771),
    [anon_sym_await] = ACTIONS(773),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_none] = ACTIONS(755),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(775),
  },
  [162] = {
    [sym_list_splat_pattern] = STATE(1320),
    [sym_primary_expression] = STATE(1056),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(985),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(781),
    [anon_sym_print] = ACTIONS(783),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(785),
    [anon_sym_async] = ACTIONS(783),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(783),
    [anon_sym_type] = ACTIONS(785),
    [anon_sym_EQ] = ACTIONS(787),
    [anon_sym_LBRACK] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(791),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(795),
    [sym_integer] = ACTIONS(777),
    [sym_float] = ACTIONS(795),
    [anon_sym_await] = ACTIONS(797),
    [sym_true] = ACTIONS(777),
    [sym_false] = ACTIONS(777),
    [sym_none] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(799),
  },
  [163] = {
    [sym_list_splat_pattern] = STATE(1320),
    [sym_primary_expression] = STATE(1056),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(985),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(781),
    [anon_sym_print] = ACTIONS(783),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(785),
    [anon_sym_async] = ACTIONS(783),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(783),
    [anon_sym_type] = ACTIONS(785),
    [anon_sym_LBRACK] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(791),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(795),
    [sym_integer] = ACTIONS(777),
    [sym_float] = ACTIONS(795),
    [anon_sym_await] = ACTIONS(797),
    [sym_true] = ACTIONS(777),
    [sym_false] = ACTIONS(777),
    [sym_none] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(799),
  },
  [164] = {
    [sym_list_splat_pattern] = STATE(1301),
    [sym_primary_expression] = STATE(1071),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(995),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(711),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(686),
    [anon_sym_COMMA] = ACTIONS(686),
    [anon_sym_as] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(715),
    [anon_sym_print] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_match] = ACTIONS(719),
    [anon_sym_async] = ACTIONS(717),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(717),
    [anon_sym_type] = ACTIONS(719),
    [anon_sym_LBRACK] = ACTIONS(721),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(723),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(725),
    [anon_sym_PLUS] = ACTIONS(723),
    [anon_sym_not] = ACTIONS(645),
    [anon_sym_and] = ACTIONS(645),
    [anon_sym_or] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(723),
    [anon_sym_is] = ACTIONS(645),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(686),
    [anon_sym_EQ_EQ] = ACTIONS(686),
    [anon_sym_BANG_EQ] = ACTIONS(686),
    [anon_sym_GT_EQ] = ACTIONS(686),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_GT] = ACTIONS(686),
    [sym_ellipsis] = ACTIONS(727),
    [sym_integer] = ACTIONS(711),
    [sym_float] = ACTIONS(727),
    [anon_sym_await] = ACTIONS(729),
    [sym_true] = ACTIONS(711),
    [sym_false] = ACTIONS(711),
    [sym_none] = ACTIONS(711),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(731),
  },
  [165] = {
    [sym_list_splat_pattern] = STATE(1283),
    [sym_primary_expression] = STATE(991),
    [sym_binary_operator] = STATE(1280),
    [sym_unary_operator] = STATE(1280),
    [sym_attribute] = STATE(1280),
    [sym_subscript] = STATE(1280),
    [sym_call] = STATE(1280),
    [sym_list] = STATE(1280),
    [sym_set] = STATE(1280),
    [sym_tuple] = STATE(1280),
    [sym_dictionary] = STATE(1280),
    [sym_list_comprehension] = STATE(1280),
    [sym_dictionary_comprehension] = STATE(1280),
    [sym_set_comprehension] = STATE(1280),
    [sym_generator_expression] = STATE(1280),
    [sym_parenthesized_expression] = STATE(1280),
    [sym_concatenated_string] = STATE(1280),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1280),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(691),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(693),
    [anon_sym_print] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(697),
    [anon_sym_async] = ACTIONS(695),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(695),
    [anon_sym_type] = ACTIONS(697),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(703),
    [anon_sym_PLUS] = ACTIONS(701),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(701),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(705),
    [sym_integer] = ACTIONS(689),
    [sym_float] = ACTIONS(705),
    [anon_sym_await] = ACTIONS(707),
    [sym_true] = ACTIONS(689),
    [sym_false] = ACTIONS(689),
    [sym_none] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(709),
  },
  [166] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [167] = {
    [sym_list_splat_pattern] = STATE(1320),
    [sym_primary_expression] = STATE(1056),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(985),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(781),
    [anon_sym_print] = ACTIONS(783),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(785),
    [anon_sym_async] = ACTIONS(783),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(783),
    [anon_sym_type] = ACTIONS(785),
    [anon_sym_LBRACK] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(791),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(795),
    [sym_integer] = ACTIONS(777),
    [sym_float] = ACTIONS(795),
    [anon_sym_await] = ACTIONS(797),
    [sym_true] = ACTIONS(777),
    [sym_false] = ACTIONS(777),
    [sym_none] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(799),
  },
  [168] = {
    [sym_list_splat_pattern] = STATE(1301),
    [sym_primary_expression] = STATE(1071),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(995),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(711),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(715),
    [anon_sym_print] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(719),
    [anon_sym_async] = ACTIONS(717),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(717),
    [anon_sym_type] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(787),
    [anon_sym_LBRACK] = ACTIONS(721),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(723),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(725),
    [anon_sym_PLUS] = ACTIONS(723),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(723),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(727),
    [sym_integer] = ACTIONS(711),
    [sym_float] = ACTIONS(727),
    [anon_sym_await] = ACTIONS(729),
    [sym_true] = ACTIONS(711),
    [sym_false] = ACTIONS(711),
    [sym_none] = ACTIONS(711),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(731),
  },
  [169] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(308),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(308),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(308),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(660),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(660),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_SLASH_SLASH] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_PLUS_EQ] = ACTIONS(308),
    [anon_sym_DASH_EQ] = ACTIONS(308),
    [anon_sym_STAR_EQ] = ACTIONS(308),
    [anon_sym_SLASH_EQ] = ACTIONS(308),
    [anon_sym_AT_EQ] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(308),
    [anon_sym_PERCENT_EQ] = ACTIONS(308),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(308),
    [anon_sym_GT_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT_EQ] = ACTIONS(308),
    [anon_sym_AMP_EQ] = ACTIONS(308),
    [anon_sym_CARET_EQ] = ACTIONS(308),
    [anon_sym_PIPE_EQ] = ACTIONS(308),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(308),
    [sym_string_start] = ACTIONS(316),
  },
  [170] = {
    [sym_list_splat_pattern] = STATE(1259),
    [sym_primary_expression] = STATE(1014),
    [sym_binary_operator] = STATE(1180),
    [sym_unary_operator] = STATE(1180),
    [sym_attribute] = STATE(1180),
    [sym_subscript] = STATE(1180),
    [sym_call] = STATE(1180),
    [sym_list] = STATE(1180),
    [sym_set] = STATE(1180),
    [sym_tuple] = STATE(1180),
    [sym_dictionary] = STATE(1180),
    [sym_list_comprehension] = STATE(1180),
    [sym_dictionary_comprehension] = STATE(1180),
    [sym_set_comprehension] = STATE(1180),
    [sym_generator_expression] = STATE(1180),
    [sym_parenthesized_expression] = STATE(1180),
    [sym_concatenated_string] = STATE(1180),
    [sym_string] = STATE(958),
    [sym_await] = STATE(1180),
    [sym_identifier] = ACTIONS(733),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(735),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(737),
    [anon_sym_print] = ACTIONS(739),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(741),
    [anon_sym_async] = ACTIONS(739),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(739),
    [anon_sym_type] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(747),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(745),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(745),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(749),
    [sym_integer] = ACTIONS(733),
    [sym_float] = ACTIONS(749),
    [anon_sym_await] = ACTIONS(751),
    [sym_true] = ACTIONS(733),
    [sym_false] = ACTIONS(733),
    [sym_none] = ACTIONS(733),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(753),
  },
  [171] = {
    [sym_list_splat_pattern] = STATE(1283),
    [sym_primary_expression] = STATE(991),
    [sym_binary_operator] = STATE(1280),
    [sym_unary_operator] = STATE(1280),
    [sym_attribute] = STATE(1280),
    [sym_subscript] = STATE(1280),
    [sym_call] = STATE(1280),
    [sym_list] = STATE(1280),
    [sym_set] = STATE(1280),
    [sym_tuple] = STATE(1280),
    [sym_dictionary] = STATE(1280),
    [sym_list_comprehension] = STATE(1280),
    [sym_dictionary_comprehension] = STATE(1280),
    [sym_set_comprehension] = STATE(1280),
    [sym_generator_expression] = STATE(1280),
    [sym_parenthesized_expression] = STATE(1280),
    [sym_concatenated_string] = STATE(1280),
    [sym_string] = STATE(969),
    [sym_await] = STATE(1280),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(691),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(693),
    [anon_sym_print] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(697),
    [anon_sym_async] = ACTIONS(695),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(695),
    [anon_sym_type] = ACTIONS(697),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(703),
    [anon_sym_PLUS] = ACTIONS(701),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(701),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(705),
    [sym_integer] = ACTIONS(689),
    [sym_float] = ACTIONS(705),
    [anon_sym_await] = ACTIONS(707),
    [sym_true] = ACTIONS(689),
    [sym_false] = ACTIONS(689),
    [sym_none] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(709),
  },
  [172] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [173] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_as] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(643),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_in] = ACTIONS(650),
    [anon_sym_STAR_STAR] = ACTIONS(686),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(650),
    [anon_sym_or] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(686),
    [anon_sym_SLASH_SLASH] = ACTIONS(686),
    [anon_sym_AMP] = ACTIONS(686),
    [anon_sym_CARET] = ACTIONS(686),
    [anon_sym_LT_LT] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_is] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_LT_GT] = ACTIONS(643),
    [sym_ellipsis] = ACTIONS(310),
    [sym_integer] = ACTIONS(312),
    [sym_float] = ACTIONS(310),
    [anon_sym_await] = ACTIONS(662),
    [sym_true] = ACTIONS(312),
    [sym_false] = ACTIONS(312),
    [sym_none] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(316),
  },
  [174] = {
    [sym_list_splat_pattern] = STATE(1444),
    [sym_primary_expression] = STATE(1202),
    [sym_binary_operator] = STATE(1441),
    [sym_unary_operator] = STATE(1441),
    [sym_attribute] = STATE(1441),
    [sym_subscript] = STATE(1441),
    [sym_call] = STATE(1441),
    [sym_list] = STATE(1441),
    [sym_set] = STATE(1441),
    [sym_tuple] = STATE(1441),
    [sym_dictionary] = STATE(1441),
    [sym_list_comprehension] = STATE(1441),
    [sym_dictionary_comprehension] = STATE(1441),
    [sym_set_comprehension] = STATE(1441),
    [sym_generator_expression] = STATE(1441),
    [sym_parenthesized_expression] = STATE(1441),
    [sym_concatenated_string] = STATE(1441),
    [sym_string] = STATE(1081),
    [sym_await] = STATE(1441),
    [sym_identifier] = ACTIONS(755),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_print] = ACTIONS(761),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(763),
    [anon_sym_async] = ACTIONS(761),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(761),
    [anon_sym_type] = ACTIONS(763),
    [anon_sym_LBRACK] = ACTIONS(765),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(767),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(769),
    [anon_sym_PLUS] = ACTIONS(767),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(767),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(771),
    [sym_integer] = ACTIONS(755),
    [sym_float] = ACTIONS(771),
    [anon_sym_await] = ACTIONS(773),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_none] = ACTIONS(755),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(775),
  },
  [175] = {
    [sym_list_splat_pattern] = STATE(1301),
    [sym_primary_expression] = STATE(1071),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(995),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(711),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(715),
    [anon_sym_print] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(719),
    [anon_sym_async] = ACTIONS(717),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(717),
    [anon_sym_type] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_LBRACK] = ACTIONS(721),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(723),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(725),
    [anon_sym_PLUS] = ACTIONS(723),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(723),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(727),
    [sym_integer] = ACTIONS(711),
    [sym_float] = ACTIONS(727),
    [anon_sym_await] = ACTIONS(729),
    [sym_true] = ACTIONS(711),
    [sym_false] = ACTIONS(711),
    [sym_none] = ACTIONS(711),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(731),
  },
  [176] = {
    [sym_list_splat_pattern] = STATE(1320),
    [sym_primary_expression] = STATE(1056),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(985),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(777),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(781),
    [anon_sym_print] = ACTIONS(783),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(785),
    [anon_sym_async] = ACTIONS(783),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(783),
    [anon_sym_type] = ACTIONS(785),
    [anon_sym_LBRACK] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(791),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(795),
    [sym_integer] = ACTIONS(777),
    [sym_float] = ACTIONS(795),
    [anon_sym_await] = ACTIONS(797),
    [sym_true] = ACTIONS(777),
    [sym_false] = ACTIONS(777),
    [sym_none] = ACTIONS(777),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(799),
  },
  [177] = {
    [sym_list_splat_pattern] = STATE(1444),
    [sym_primary_expression] = STATE(1202),
    [sym_binary_operator] = STATE(1441),
    [sym_unary_operator] = STATE(1441),
    [sym_attribute] = STATE(1441),
    [sym_subscript] = STATE(1441),
    [sym_call] = STATE(1441),
    [sym_list] = STATE(1441),
    [sym_set] = STATE(1441),
    [sym_tuple] = STATE(1441),
    [sym_dictionary] = STATE(1441),
    [sym_list_comprehension] = STATE(1441),
    [sym_dictionary_comprehension] = STATE(1441),
    [sym_set_comprehension] = STATE(1441),
    [sym_generator_expression] = STATE(1441),
    [sym_parenthesized_expression] = STATE(1441),
    [sym_concatenated_string] = STATE(1441),
    [sym_string] = STATE(1081),
    [sym_await] = STATE(1441),
    [sym_identifier] = ACTIONS(755),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_print] = ACTIONS(761),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_match] = ACTIONS(763),
    [anon_sym_async] = ACTIONS(761),
    [anon_sym_in] = ACTIONS(267),
    [anon_sym_STAR_STAR] = ACTIONS(265),
    [anon_sym_exec] = ACTIONS(761),
    [anon_sym_type] = ACTIONS(763),
    [anon_sym_LBRACK] = ACTIONS(765),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(767),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(769),
    [anon_sym_PLUS] = ACTIONS(767),
    [anon_sym_not] = ACTIONS(267),
    [anon_sym_and] = ACTIONS(267),
    [anon_sym_or] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(767),
    [anon_sym_is] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT_GT] = ACTIONS(265),
    [sym_ellipsis] = ACTIONS(771),
    [sym_integer] = ACTIONS(755),
    [sym_float] = ACTIONS(771),
    [anon_sym_await] = ACTIONS(773),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_none] = ACTIONS(755),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(775),
  },
  [178] = {
    [sym_list_splat_pattern] = STATE(1372),
    [sym_primary_expression] = STATE(1116),
    [sym_binary_operator] = STATE(1377),
    [sym_unary_operator] = STATE(1377),
    [sym_attribute] = STATE(1377),
    [sym_subscript] = STATE(1377),
    [sym_call] = STATE(1377),
    [sym_list] = STATE(1377),
    [sym_set] = STATE(1377),
    [sym_tuple] = STATE(1377),
    [sym_dictionary] = STATE(1377),
    [sym_list_comprehension] = STATE(1377),
    [sym_dictionary_comprehension] = STATE(1377),
    [sym_set_comprehension] = STATE(1377),
    [sym_generator_expression] = STATE(1377),
    [sym_parenthesized_expression] = STATE(1377),
    [sym_concatenated_string] = STATE(1377),
    [sym_string] = STATE(984),
    [sym_await] = STATE(1377),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(308),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(308),
    [anon_sym_match] = ACTIONS(656),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_STAR_STAR] = ACTIONS(267),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_type] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_