// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// GetOneSpoeFileHandlerFunc turns a function with the right signature into a get one spoe file handler
type GetOneSpoeFileHandlerFunc func(GetOneSpoeFileParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn GetOneSpoeFileHandlerFunc) Handle(params GetOneSpoeFileParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// GetOneSpoeFileHandler interface for that can handle valid get one spoe file params
type GetOneSpoeFileHandler interface {
	Handle(GetOneSpoeFileParams, interface{}) middleware.Responder
}

// NewGetOneSpoeFile creates a new http.Handler for the get one spoe file operation
func NewGetOneSpoeFile(ctx *middleware.Context, handler GetOneSpoeFileHandler) *GetOneSpoeFile {
	return &GetOneSpoeFile{Context: ctx, Handler: handler}
}

/*
	GetOneSpoeFile swagger:route GET /services/haproxy/spoe/spoe_files/{name} Spoe getOneSpoeFile

# Return one SPOE file

Returns one SPOE file.
*/
type GetOneSpoeFile struct {
	Context *middleware.Context
	Handler GetOneSpoeFileHandler
}

func (o *GetOneSpoeFile) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetOneSpoeFileParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// GetOneSpoeFileOKBody get one spoe file o k body
//
// swagger:model GetOneSpoeFileOKBody
type GetOneSpoeFileOKBody struct {

	// data
	Data string `json:"data,omitempty"`
}

// Validate validates this get one spoe file o k body
func (o *GetOneSpoeFileOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this get one spoe file o k body based on context it is used
func (o *GetOneSpoeFileOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *GetOneSpoeFileOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetOneSpoeFileOKBody) UnmarshalBinary(b []byte) error {
	var res GetOneSpoeFileOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
