// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteServerRingAcceptedCode is the HTTP code returned for type DeleteServerRingAccepted
const DeleteServerRingAcceptedCode int = 202

/*
DeleteServerRingAccepted Configuration change accepted and reload requested

swagger:response deleteServerRingAccepted
*/
type DeleteServerRingAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteServerRingAccepted creates DeleteServerRingAccepted with default headers values
func NewDeleteServerRingAccepted() *DeleteServerRingAccepted {

	return &DeleteServerRingAccepted{}
}

// WithReloadID adds the reloadId to the delete server ring accepted response
func (o *DeleteServerRingAccepted) WithReloadID(reloadID string) *DeleteServerRingAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete server ring accepted response
func (o *DeleteServerRingAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteServerRingAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteServerRingNoContentCode is the HTTP code returned for type DeleteServerRingNoContent
const DeleteServerRingNoContentCode int = 204

/*
DeleteServerRingNoContent Server deleted

swagger:response deleteServerRingNoContent
*/
type DeleteServerRingNoContent struct {
}

// NewDeleteServerRingNoContent creates DeleteServerRingNoContent with default headers values
func NewDeleteServerRingNoContent() *DeleteServerRingNoContent {

	return &DeleteServerRingNoContent{}
}

// WriteResponse to the client
func (o *DeleteServerRingNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteServerRingNotFoundCode is the HTTP code returned for type DeleteServerRingNotFound
const DeleteServerRingNotFoundCode int = 404

/*
DeleteServerRingNotFound The specified resource was not found

swagger:response deleteServerRingNotFound
*/
type DeleteServerRingNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerRingNotFound creates DeleteServerRingNotFound with default headers values
func NewDeleteServerRingNotFound() *DeleteServerRingNotFound {

	return &DeleteServerRingNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete server ring not found response
func (o *DeleteServerRingNotFound) WithConfigurationVersion(configurationVersion string) *DeleteServerRingNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server ring not found response
func (o *DeleteServerRingNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server ring not found response
func (o *DeleteServerRingNotFound) WithPayload(payload *models.Error) *DeleteServerRingNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server ring not found response
func (o *DeleteServerRingNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerRingNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteServerRingDefault General Error

swagger:response deleteServerRingDefault
*/
type DeleteServerRingDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerRingDefault creates DeleteServerRingDefault with default headers values
func NewDeleteServerRingDefault(code int) *DeleteServerRingDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteServerRingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete server ring default response
func (o *DeleteServerRingDefault) WithStatusCode(code int) *DeleteServerRingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete server ring default response
func (o *DeleteServerRingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete server ring default response
func (o *DeleteServerRingDefault) WithConfigurationVersion(configurationVersion string) *DeleteServerRingDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server ring default response
func (o *DeleteServerRingDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server ring default response
func (o *DeleteServerRingDefault) WithPayload(payload *models.Error) *DeleteServerRingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server ring default response
func (o *DeleteServerRingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerRingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
