// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteServerBackendAcceptedCode is the HTTP code returned for type DeleteServerBackendAccepted
const DeleteServerBackendAcceptedCode int = 202

/*
DeleteServerBackendAccepted Configuration change accepted and reload requested

swagger:response deleteServerBackendAccepted
*/
type DeleteServerBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteServerBackendAccepted creates DeleteServerBackendAccepted with default headers values
func NewDeleteServerBackendAccepted() *DeleteServerBackendAccepted {

	return &DeleteServerBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete server backend accepted response
func (o *DeleteServerBackendAccepted) WithReloadID(reloadID string) *DeleteServerBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete server backend accepted response
func (o *DeleteServerBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteServerBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteServerBackendNoContentCode is the HTTP code returned for type DeleteServerBackendNoContent
const DeleteServerBackendNoContentCode int = 204

/*
DeleteServerBackendNoContent Server deleted

swagger:response deleteServerBackendNoContent
*/
type DeleteServerBackendNoContent struct {
}

// NewDeleteServerBackendNoContent creates DeleteServerBackendNoContent with default headers values
func NewDeleteServerBackendNoContent() *DeleteServerBackendNoContent {

	return &DeleteServerBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteServerBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteServerBackendNotFoundCode is the HTTP code returned for type DeleteServerBackendNotFound
const DeleteServerBackendNotFoundCode int = 404

/*
DeleteServerBackendNotFound The specified resource was not found

swagger:response deleteServerBackendNotFound
*/
type DeleteServerBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerBackendNotFound creates DeleteServerBackendNotFound with default headers values
func NewDeleteServerBackendNotFound() *DeleteServerBackendNotFound {

	return &DeleteServerBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete server backend not found response
func (o *DeleteServerBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteServerBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server backend not found response
func (o *DeleteServerBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server backend not found response
func (o *DeleteServerBackendNotFound) WithPayload(payload *models.Error) *DeleteServerBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server backend not found response
func (o *DeleteServerBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteServerBackendDefault General Error

swagger:response deleteServerBackendDefault
*/
type DeleteServerBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerBackendDefault creates DeleteServerBackendDefault with default headers values
func NewDeleteServerBackendDefault(code int) *DeleteServerBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteServerBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete server backend default response
func (o *DeleteServerBackendDefault) WithStatusCode(code int) *DeleteServerBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete server backend default response
func (o *DeleteServerBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete server backend default response
func (o *DeleteServerBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteServerBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server backend default response
func (o *DeleteServerBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server backend default response
func (o *DeleteServerBackendDefault) WithPayload(payload *models.Error) *DeleteServerBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server backend default response
func (o *DeleteServerBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
