// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package resolver

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetResolversOKCode is the HTTP code returned for type GetResolversOK
const GetResolversOKCode int = 200

/*
GetResolversOK Successful operation

swagger:response getResolversOK
*/
type GetResolversOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Resolvers `json:"body,omitempty"`
}

// NewGetResolversOK creates GetResolversOK with default headers values
func NewGetResolversOK() *GetResolversOK {

	return &GetResolversOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get resolvers o k response
func (o *GetResolversOK) WithConfigurationVersion(configurationVersion string) *GetResolversOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get resolvers o k response
func (o *GetResolversOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get resolvers o k response
func (o *GetResolversOK) WithPayload(payload models.Resolvers) *GetResolversOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get resolvers o k response
func (o *GetResolversOK) SetPayload(payload models.Resolvers) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetResolversOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Resolvers{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetResolversDefault General Error

swagger:response getResolversDefault
*/
type GetResolversDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetResolversDefault creates GetResolversDefault with default headers values
func NewGetResolversDefault(code int) *GetResolversDefault {
	if code <= 0 {
		code = 500
	}

	return &GetResolversDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get resolvers default response
func (o *GetResolversDefault) WithStatusCode(code int) *GetResolversDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get resolvers default response
func (o *GetResolversDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get resolvers default response
func (o *GetResolversDefault) WithConfigurationVersion(configurationVersion string) *GetResolversDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get resolvers default response
func (o *GetResolversDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get resolvers default response
func (o *GetResolversDefault) WithPayload(payload *models.Error) *GetResolversDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get resolvers default response
func (o *GetResolversDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetResolversDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
