// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package mailers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetMailersSectionOKCode is the HTTP code returned for type GetMailersSectionOK
const GetMailersSectionOKCode int = 200

/*
GetMailersSectionOK Successful operation

swagger:response getMailersSectionOK
*/
type GetMailersSectionOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.MailersSection `json:"body,omitempty"`
}

// NewGetMailersSectionOK creates GetMailersSectionOK with default headers values
func NewGetMailersSectionOK() *GetMailersSectionOK {

	return &GetMailersSectionOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get mailers section o k response
func (o *GetMailersSectionOK) WithConfigurationVersion(configurationVersion string) *GetMailersSectionOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get mailers section o k response
func (o *GetMailersSectionOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get mailers section o k response
func (o *GetMailersSectionOK) WithPayload(payload *models.MailersSection) *GetMailersSectionOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get mailers section o k response
func (o *GetMailersSectionOK) SetPayload(payload *models.MailersSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetMailersSectionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetMailersSectionNotFoundCode is the HTTP code returned for type GetMailersSectionNotFound
const GetMailersSectionNotFoundCode int = 404

/*
GetMailersSectionNotFound The specified resource was not found

swagger:response getMailersSectionNotFound
*/
type GetMailersSectionNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetMailersSectionNotFound creates GetMailersSectionNotFound with default headers values
func NewGetMailersSectionNotFound() *GetMailersSectionNotFound {

	return &GetMailersSectionNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get mailers section not found response
func (o *GetMailersSectionNotFound) WithConfigurationVersion(configurationVersion string) *GetMailersSectionNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get mailers section not found response
func (o *GetMailersSectionNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get mailers section not found response
func (o *GetMailersSectionNotFound) WithPayload(payload *models.Error) *GetMailersSectionNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get mailers section not found response
func (o *GetMailersSectionNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetMailersSectionNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetMailersSectionDefault General Error

swagger:response getMailersSectionDefault
*/
type GetMailersSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetMailersSectionDefault creates GetMailersSectionDefault with default headers values
func NewGetMailersSectionDefault(code int) *GetMailersSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &GetMailersSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get mailers section default response
func (o *GetMailersSectionDefault) WithStatusCode(code int) *GetMailersSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get mailers section default response
func (o *GetMailersSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get mailers section default response
func (o *GetMailersSectionDefault) WithConfigurationVersion(configurationVersion string) *GetMailersSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get mailers section default response
func (o *GetMailersSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get mailers section default response
func (o *GetMailersSectionDefault) WithPayload(payload *models.Error) *GetMailersSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get mailers section default response
func (o *GetMailersSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetMailersSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
