// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package defaults

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// AddDefaultsSectionCreatedCode is the HTTP code returned for type AddDefaultsSectionCreated
const AddDefaultsSectionCreatedCode int = 201

/*
AddDefaultsSectionCreated Defaults created

swagger:response addDefaultsSectionCreated
*/
type AddDefaultsSectionCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Defaults `json:"body,omitempty"`
}

// NewAddDefaultsSectionCreated creates AddDefaultsSectionCreated with default headers values
func NewAddDefaultsSectionCreated() *AddDefaultsSectionCreated {

	return &AddDefaultsSectionCreated{}
}

// WithPayload adds the payload to the add defaults section created response
func (o *AddDefaultsSectionCreated) WithPayload(payload *models.Defaults) *AddDefaultsSectionCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add defaults section created response
func (o *AddDefaultsSectionCreated) SetPayload(payload *models.Defaults) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddDefaultsSectionCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddDefaultsSectionAcceptedCode is the HTTP code returned for type AddDefaultsSectionAccepted
const AddDefaultsSectionAcceptedCode int = 202

/*
AddDefaultsSectionAccepted Configuration change accepted and reload requested

swagger:response addDefaultsSectionAccepted
*/
type AddDefaultsSectionAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Defaults `json:"body,omitempty"`
}

// NewAddDefaultsSectionAccepted creates AddDefaultsSectionAccepted with default headers values
func NewAddDefaultsSectionAccepted() *AddDefaultsSectionAccepted {

	return &AddDefaultsSectionAccepted{}
}

// WithReloadID adds the reloadId to the add defaults section accepted response
func (o *AddDefaultsSectionAccepted) WithReloadID(reloadID string) *AddDefaultsSectionAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the add defaults section accepted response
func (o *AddDefaultsSectionAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the add defaults section accepted response
func (o *AddDefaultsSectionAccepted) WithPayload(payload *models.Defaults) *AddDefaultsSectionAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add defaults section accepted response
func (o *AddDefaultsSectionAccepted) SetPayload(payload *models.Defaults) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddDefaultsSectionAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddDefaultsSectionBadRequestCode is the HTTP code returned for type AddDefaultsSectionBadRequest
const AddDefaultsSectionBadRequestCode int = 400

/*
AddDefaultsSectionBadRequest Bad request

swagger:response addDefaultsSectionBadRequest
*/
type AddDefaultsSectionBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddDefaultsSectionBadRequest creates AddDefaultsSectionBadRequest with default headers values
func NewAddDefaultsSectionBadRequest() *AddDefaultsSectionBadRequest {

	return &AddDefaultsSectionBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the add defaults section bad request response
func (o *AddDefaultsSectionBadRequest) WithConfigurationVersion(configurationVersion string) *AddDefaultsSectionBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add defaults section bad request response
func (o *AddDefaultsSectionBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add defaults section bad request response
func (o *AddDefaultsSectionBadRequest) WithPayload(payload *models.Error) *AddDefaultsSectionBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add defaults section bad request response
func (o *AddDefaultsSectionBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddDefaultsSectionBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddDefaultsSectionConflictCode is the HTTP code returned for type AddDefaultsSectionConflict
const AddDefaultsSectionConflictCode int = 409

/*
AddDefaultsSectionConflict The specified resource already exists

swagger:response addDefaultsSectionConflict
*/
type AddDefaultsSectionConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddDefaultsSectionConflict creates AddDefaultsSectionConflict with default headers values
func NewAddDefaultsSectionConflict() *AddDefaultsSectionConflict {

	return &AddDefaultsSectionConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the add defaults section conflict response
func (o *AddDefaultsSectionConflict) WithConfigurationVersion(configurationVersion string) *AddDefaultsSectionConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add defaults section conflict response
func (o *AddDefaultsSectionConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add defaults section conflict response
func (o *AddDefaultsSectionConflict) WithPayload(payload *models.Error) *AddDefaultsSectionConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add defaults section conflict response
func (o *AddDefaultsSectionConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddDefaultsSectionConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
AddDefaultsSectionDefault General Error

swagger:response addDefaultsSectionDefault
*/
type AddDefaultsSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddDefaultsSectionDefault creates AddDefaultsSectionDefault with default headers values
func NewAddDefaultsSectionDefault(code int) *AddDefaultsSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &AddDefaultsSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the add defaults section default response
func (o *AddDefaultsSectionDefault) WithStatusCode(code int) *AddDefaultsSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the add defaults section default response
func (o *AddDefaultsSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the add defaults section default response
func (o *AddDefaultsSectionDefault) WithConfigurationVersion(configurationVersion string) *AddDefaultsSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add defaults section default response
func (o *AddDefaultsSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add defaults section default response
func (o *AddDefaultsSectionDefault) WithPayload(payload *models.Error) *AddDefaultsSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add defaults section default response
func (o *AddDefaultsSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddDefaultsSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
