/*
 * Copyright (c) 2018, 2025, Oracle and/or its affiliates. All rights reserved.
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at https://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.io.File;
import java.util.Collection;
import java.util.Collections;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.ConfigurationRepositoryFactory;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import org.openjdk.jmc.ui.wizards.SimpleImportFromFileWizardPage;

public class TemplateImportWizard extends Wizard implements IImportWizard {
	private static String WIZARD_KEY = "importTemplateFromFile"; //$NON-NLS-1$

	private SimpleImportFromFileWizardPage m_wizardPage;

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDialogSettings(DialogSettings.getOrCreateSection(ControlPanel.getDefault().getDialogSettings(), WIZARD_KEY));
		setWindowTitle(Messages.IMPORT_TEMPLATE_WIZARD_TITLE);

		m_wizardPage = new SimpleImportFromFileWizardPage(WIZARD_KEY, IEventConfiguration.JFC_FILE_EXTENSION);
		// FIXME: Need large icon here, same as for the export wizard
//		m_wizardPage.setImageDescriptor(ControlPanel.getDefault()
//				.getMCImageDescriptor(ImageConstants.ICON_FLIGHT_RECORDING_CONFIGURATION_TEMPLATE));
		m_wizardPage.setTitle(Messages.IMPORT_TEMPLATE_WIZARD_TITLE);

		addPage(m_wizardPage);
	}

	@Override
	public boolean performFinish() {
		File file = m_wizardPage.getFile();
		if (file != null) {
			// To ensure a unique name, must create a repository from the persisted data.
			EventConfigurationRepository repository = ConfigurationRepositoryFactory.create();
			Collection<IEventConfiguration> imported = TemplateToolkit.importFilesTo(repository,
					Collections.singleton(file));
			return !imported.isEmpty();
		}
		return false;
	}
}
