# -*- coding:utf-8 -*-

#  ************************** Copyrights and license ***************************
#
# This file is part of gcovr 8.3, a parsing and reporting tool for gcov.
# https://gcovr.com/en/8.3
#
# _____________________________________________________________________________
#
# Copyright (c) 2013-2025 the gcovr authors
# Copyright (c) 2013 Sandia Corporation.
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# This software is distributed under the 3-clause BSD License.
# For more information, see the README.rst file.
#
# ****************************************************************************

# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/stable/config

# -- Path setup --------------------------------------------------------------
# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

from datetime import datetime
import os
import sys

sys.path.insert(0, os.path.abspath(os.path.join("..", "..", "src")))
import gcovr.version  # noqa # pylint: disable=wrong-import-position
import gcovr.formats.json.versions  # noqa # pylint: disable=wrong-import-position

# -- Project information -----------------------------------------------------

# pylint: disable=invalid-name

project = "gcovr"
copyright = f"{datetime.today().year}, the gcovr authors"  # pylint: disable=redefined-builtin
author = "the gcovr authors"

# The short X.Y version
version = gcovr.version.__version__
# The full version, including alpha/beta/rc tags
release = version

# Define the canonical URL used on Read the Docs
html_baseurl = os.environ.get("READTHEDOCS_CANONICAL_URL", "")

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.todo",
    "sphinx.ext.extlinks",
    "sphinxcontrib.autoprogram",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = list[str]()

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# Disable smart dashes ("--" → "–"; "---" → "—")
# because this interferes with option names like "--foobar".
# q – smartify quotes: ", '
# D – smartify dashes --    (DISABLED)
# e – smartify ellipsis ...
smartquotes_action = "qe"

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "gcovrdoc"


# -- Options for LaTeX output ------------------------------------------------

latex_elements = dict[str, str](
    {
        # The paper size ('letterpaper' or 'a4paper').
        #
        # 'papersize': 'letterpaper',
        # The font size ('10pt', '11pt' or '12pt').
        #
        # 'pointsize': '10pt',
        # Additional stuff for the LaTeX preamble.
        #
        # 'preamble': '',
        # Latex figure (float) alignment
        #
        # 'figure_align': 'htbp',
    }
)

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "gcovr.tex", "gcovr Documentation", author, "manual"),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "gcovr", "gcovr Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "gcovr",
        "gcovr Documentation",
        author,
        "gcovr",
        "One line description of project.",
        "Miscellaneous",
    ),
]


# -- Extension configuration -------------------------------------------------

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for extlinks extension ------------------------------------------

# see http://www.sphinx-doc.org/en/master/ext/extlinks.html
extlinks = {"issue": ("https://github.com/gcovr/gcovr/issues/%s", "#%s")}

# -- linkcheck extenstion ------------------------------------------

linkcheck_anchors_ignore_for_url = [r"https://github.com/.+/blob/.+"]
linkcheck_ignore = [r"https://github.com/gcovr/gcovr/issues/\d+"]

# -- Jinja2 template context ------------------------------------------

# Tell Jinja2 templates the build is running on Read the Docs
if os.environ.get("READTHEDOCS", "") == "True":
    if "html_context" not in globals():
        html_context = {}
    html_context["READTHEDOCS"] = True  # pylint: disable=possibly-used-before-assignment
