/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.indexing.shared.util.zipFs.FileBlockReadOnlyFileChannel;
import com.intellij.indexing.shared.util.zipFs.TraceableFileChannel;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileStore;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystemProvider;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipPath;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UncompressedZipFileSystem
extends FileSystem {
    public static final String PREBUILT_PROP = "prebuilt";
    private static final Logger LOG = Logger.getInstance(UncompressedZipFileSystem.class);
    private volatile ZipTreeNode myRoot;
    @NotNull
    private final Path myUncompressedZipPath;
    @NotNull
    private final UncompressedZipFileSystemProvider myProvider;
    private final boolean myPrebuilt;
    private final Lock myOpenFilePoolLock;
    private final Map<TraceableFileChannel, Set<FileBlockReadOnlyFileChannel>> myOpenFilePool;
    private volatile TraceableFileChannel myCurrentZipChannel;

    UncompressedZipFileSystem(@NotNull Path uncompressedZip, @NotNull Map<String, ?> env, @NotNull UncompressedZipFileSystemProvider provider) throws IOException {
        if (uncompressedZip == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(0);
        }
        if (env == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(2);
        }
        this.myOpenFilePoolLock = new ReentrantLock();
        this.myOpenFilePool = new HashMap<TraceableFileChannel, Set<FileBlockReadOnlyFileChannel>>();
        this.myUncompressedZipPath = uncompressedZip;
        this.myProvider = provider;
        this.myPrebuilt = Boolean.TRUE.equals(env.get(PREBUILT_PROP));
        assert (uncompressedZip.getFileSystem() == FileSystems.getDefault());
        this.sync();
    }

    public boolean isPrebuilt() {
        return this.myPrebuilt;
    }

    public String toString() {
        return "UncompressedZipFileSystem[" + this.myUncompressedZipPath + "]";
    }

    @NotNull
    public static UncompressedZipFileSystem create(@NotNull Path uncompressedZip) throws IOException {
        if (uncompressedZip == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(3);
        }
        return UncompressedZipFileSystem.create(uncompressedZip, false);
    }

    @NotNull
    public static UncompressedZipFileSystem create(@NotNull Path uncompressedZip, boolean prebuilt) throws IOException {
        if (uncompressedZip == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(4);
        }
        if (!Files.exists(uncompressedZip, new LinkOption[0])) {
            throw new FileSystemNotFoundException(uncompressedZip.toString());
        }
        if (Files.isDirectory(uncompressedZip, new LinkOption[0])) {
            throw new UnsupportedOperationException(uncompressedZip + " is a directory");
        }
        FileSystem fileSystem = UncompressedZipFileSystemProvider.INSTANCE.newFileSystem(uncompressedZip, (Map)Map.of(PREBUILT_PROP, prebuilt));
        if (fileSystem == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(5);
        }
        return fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    FileBlockReadOnlyFileChannel openChannel(@NotNull String relPath, @NotNull LightZipEntry entry) throws IOException {
        if (relPath == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(7);
        }
        if (!this.isOpen()) {
            throw new IOException("File system " + this.myUncompressedZipPath + " is already closed");
        }
        this.myOpenFilePoolLock.lock();
        final TraceableFileChannel zipChannel = this.myCurrentZipChannel;
        FileBlockReadOnlyFileChannel channel = new FileBlockReadOnlyFileChannel(relPath, zipChannel, entry.offset, entry.size){

            @Override
            protected void implCloseChannel() throws IOException {
                UncompressedZipFileSystem.this.myOpenFilePoolLock.lock();
                try {
                    Set<FileBlockReadOnlyFileChannel> channels = UncompressedZipFileSystem.this.myOpenFilePool.get(zipChannel);
                    channels.remove(this);
                    if (channels.isEmpty() && zipChannel != UncompressedZipFileSystem.this.myCurrentZipChannel) {
                        UncompressedZipFileSystem.this.myOpenFilePool.remove(zipChannel);
                        zipChannel.close();
                    }
                }
                finally {
                    UncompressedZipFileSystem.this.myOpenFilePoolLock.unlock();
                }
            }
        };
        this.myOpenFilePool.computeIfAbsent(zipChannel, __ -> ConcurrentCollectionFactory.createConcurrentSet()).add(channel);
        FileBlockReadOnlyFileChannel fileBlockReadOnlyFileChannel = channel;
        FileBlockReadOnlyFileChannel fileBlockReadOnlyFileChannel2 = fileBlockReadOnlyFileChannel;
        if (fileBlockReadOnlyFileChannel2 == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(8);
        }
        return fileBlockReadOnlyFileChannel2;
        finally {
            this.myOpenFilePoolLock.unlock();
        }
    }

    public void sync() throws IOException {
        this.reopenZipChannel();
        this.buildTree();
    }

    @Override
    public FileSystemProvider provider() {
        return this.myProvider;
    }

    @Override
    public void close() throws IOException {
        this.closeOpenFiles();
    }

    @NotNull
    Path getUncompressedZipPath() {
        Path path = this.myUncompressedZipPath;
        if (path == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    TraceableFileChannel getCurrentChannel() {
        TraceableFileChannel traceableFileChannel = this.myCurrentZipChannel;
        if (traceableFileChannel == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(10);
        }
        return traceableFileChannel;
    }

    @Override
    public boolean isOpen() {
        return this.myCurrentZipChannel.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @NotNull
    public Path getRootDirectory() {
        return new UncompressedZipPath(this, ArrayUtil.EMPTY_STRING_ARRAY, true);
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.getRootDirectory());
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.singleton(new UncompressedZipFileStore(this));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.singleton("basic");
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        if (first == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(11);
        }
        if (more == null) {
            UncompressedZipFileSystem.$$$reportNull$$$0(12);
        }
        String[] nameElements = ArrayUtil.toStringArray((Collection)ContainerUtil.concat(Collections.singletonList(first), Arrays.asList(more)));
        return new UncompressedZipPath(this, nameElements, true);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Path matcher is not supported for " + this);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("getUserPrincipalLookupService is not supported for " + this);
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("newWatchService is not supported for " + this);
    }

    ZipTreeNode getRoot() {
        return this.myRoot;
    }

    private void reopenZipChannel() throws IOException {
        this.myOpenFilePoolLock.lock();
        try {
            TraceableFileChannel previousZipChannel = this.myCurrentZipChannel;
            this.myCurrentZipChannel = new TraceableFileChannel(this.myUncompressedZipPath, StandardOpenOption.READ);
            if (previousZipChannel != null && ContainerUtil.isEmpty((Collection)this.myOpenFilePool.get(previousZipChannel))) {
                try {
                    this.myOpenFilePool.remove(previousZipChannel);
                    previousZipChannel.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        finally {
            this.myOpenFilePoolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenFiles() throws IOException {
        this.myOpenFilePoolLock.lock();
        try {
            for (Map.Entry<TraceableFileChannel, Set<FileBlockReadOnlyFileChannel>> entry : this.myOpenFilePool.entrySet()) {
                Set<FileBlockReadOnlyFileChannel> channels = entry.getValue();
                if (!channels.isEmpty()) {
                    LOG.error("Dedicated entry channels is not closed for " + this.myUncompressedZipPath);
                }
                for (FileBlockReadOnlyFileChannel channel : channels) {
                    channel.close();
                }
                entry.getKey().close();
            }
            this.myCurrentZipChannel.close();
        }
        finally {
            this.myOpenFilePoolLock.unlock();
        }
    }

    private void buildTree() throws IOException {
        ZipTreeNode root = new ZipTreeNode();
        try (JBZipFile zip = Zip64Util.openZip64File(this.myUncompressedZipPath, true);){
            for (JBZipEntry entry : zip.getEntries()) {
                if (entry.isDirectory()) continue;
                List names = StringUtil.split((String)entry.getName(), (String)this.getSeparator());
                ZipTreeNode current = root;
                for (int i = 0; i < names.size(); ++i) {
                    if (i == names.size() - 1) {
                        current.createEntryChild((String)names.get(i), entry);
                        continue;
                    }
                    current = current.createDirChild((String)names.get(i));
                }
            }
        }
        this.myRoot = root;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uncompressedZip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "more";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "openChannel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncompressedZipPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentChannel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openChannel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static final class LightZipEntry {
        final long size;
        final long offset;

        LightZipEntry(JBZipEntry entry) throws IOException {
            this.size = entry.getCompressedSize();
            this.offset = entry.calcDataOffset();
        }
    }

    static final class ZipTreeNode {
        @Nullable
        private final Map<String, ZipTreeNode> myChildren;
        @Nullable
        private final LightZipEntry myEntry;

        public boolean isDirectory() {
            return this.myChildren != null;
        }

        @NotNull
        LightZipEntry getEntry() {
            assert (this.myEntry != null);
            LightZipEntry lightZipEntry = this.myEntry;
            if (lightZipEntry == null) {
                ZipTreeNode.$$$reportNull$$$0(0);
            }
            return lightZipEntry;
        }

        @NotNull
        @Contract(pure=true)
        Set<String> getChildNames() {
            assert (this.myChildren != null);
            Set<String> set = this.myChildren.keySet();
            if (set == null) {
                ZipTreeNode.$$$reportNull$$$0(1);
            }
            return set;
        }

        ZipTreeNode(@NotNull JBZipEntry entry) throws IOException {
            if (entry == null) {
                ZipTreeNode.$$$reportNull$$$0(2);
            }
            assert (entry.getMethod() == 0);
            this.myEntry = new LightZipEntry(entry);
            this.myChildren = null;
        }

        ZipTreeNode() {
            this.myEntry = null;
            this.myChildren = new ConcurrentHashMap<String, ZipTreeNode>();
        }

        @Nullable
        ZipTreeNode getChild(@NotNull String childName) {
            if (childName == null) {
                ZipTreeNode.$$$reportNull$$$0(3);
            }
            assert (this.myChildren != null);
            return this.myChildren.get(childName);
        }

        @NotNull
        ZipTreeNode createDirChild(@NotNull String childName) {
            if (childName == null) {
                ZipTreeNode.$$$reportNull$$$0(4);
            }
            assert (this.myChildren != null);
            ZipTreeNode zipTreeNode = this.myChildren.computeIfAbsent(childName, __ -> new ZipTreeNode());
            if (zipTreeNode == null) {
                ZipTreeNode.$$$reportNull$$$0(5);
            }
            return zipTreeNode;
        }

        void createEntryChild(@NotNull String childName, @NotNull JBZipEntry entry) throws IOException {
            if (childName == null) {
                ZipTreeNode.$$$reportNull$$$0(6);
            }
            if (entry == null) {
                ZipTreeNode.$$$reportNull$$$0(7);
            }
            assert (this.myChildren != null);
            ZipTreeNode previous = this.myChildren.put(childName, new ZipTreeNode(entry));
            assert (previous == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem$ZipTreeNode";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildNames";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem$ZipTreeNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDirChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChild";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDirChild";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createEntryChild";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

