/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.similarity;

import ai.grazie.nlp.similarity.TextDistance;
import ai.grazie.nlp.similarity.TextSimilarity;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\rH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/grazie/nlp/similarity/Levenshtein;", "Lai/grazie/nlp/similarity/TextDistance;", "Lai/grazie/nlp/similarity/TextSimilarity;", "()V", "WithDamerau", "Lai/grazie/nlp/similarity/Levenshtein$DamerauLevenshtein;", "distance", "", "first", "", "second", "limit", "withTranspositions", "", "initPrevVector", "", "size", "similarity", "", "DamerauLevenshtein", "nlp-similarity"})
public final class Levenshtein
implements TextDistance,
TextSimilarity {
    @NotNull
    public static final Levenshtein INSTANCE = new Levenshtein();
    @JvmField
    @NotNull
    public static final DamerauLevenshtein WithDamerau = new DamerauLevenshtein();

    private Levenshtein() {
    }

    @Override
    public int distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return Levenshtein.distance$default(this, first, second, Integer.MAX_VALUE, false, 8, null);
    }

    @Override
    public double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return Levenshtein.similarity$default(this, first, second, Integer.MAX_VALUE, false, 8, null);
    }

    public final double similarity(@NotNull String first, @NotNull String second, int limit, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        return 1.0 - (double)this.distance(first, second, limit, withTranspositions) / (double)Math.max(first.length(), second.length());
    }

    public static /* synthetic */ double similarity$default(Levenshtein levenshtein, String string2, String string3, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return levenshtein.similarity(string2, string3, n, bl);
    }

    public final int distance(@NotNull String first, @NotNull String second, int limit, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0;
        }
        if (((CharSequence)first).length() == 0) {
            return second.length();
        }
        if (((CharSequence)second).length() == 0) {
            return first.length();
        }
        int[] vCur = new int[second.length() + 1];
        int[] vPrev = this.initPrevVector(second.length() + 1);
        int[] vPrevPrev = withTranspositions ? this.initPrevVector(second.length() + 1) : vPrev;
        int n = first.length();
        for (int i = 0; i < n; ++i) {
            int minCur;
            vCur[0] = minCur = i + 1;
            int n2 = second.length();
            for (int j = 0; j < n2; ++j) {
                int cost = first.charAt(i) == second.charAt(j) ? 0 : 1;
                int cell = Math.min(vCur[j] + 1, Math.min(vPrev[j + 1] + 1, vPrev[j] + cost));
                if (withTranspositions && i > 0 && j > 0 && first.charAt(i) == second.charAt(j - 1) && first.charAt(i - 1) == second.charAt(j)) {
                    cell = Math.min(cell, vPrevPrev[j - 1] + cost);
                }
                vCur[j + 1] = cell;
                minCur = Math.min(minCur, cell);
            }
            if (minCur >= limit) {
                return limit;
            }
            int[] vtemp = null;
            if (withTranspositions) {
                vtemp = vPrevPrev;
                vPrevPrev = vPrev;
            } else {
                vtemp = vPrev;
            }
            vPrev = vCur;
            vCur = vtemp;
        }
        return vPrev[second.length()];
    }

    public static /* synthetic */ int distance$default(Levenshtein levenshtein, String string2, String string3, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return levenshtein.distance(string2, string3, n, bl);
    }

    private final int[] initPrevVector(int size) {
        int[] v = new int[size];
        int n = v.length;
        for (int i = 0; i < n; ++i) {
            v[i] = i;
        }
        return v;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lai/grazie/nlp/similarity/Levenshtein$DamerauLevenshtein;", "Lai/grazie/nlp/similarity/TextDistance;", "Lai/grazie/nlp/similarity/TextSimilarity;", "()V", "distance", "", "first", "", "second", "similarity", "", "nlp-similarity"})
    public static final class DamerauLevenshtein
    implements TextDistance,
    TextSimilarity {
        @Override
        public int distance(@NotNull String first, @NotNull String second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return INSTANCE.distance(first, second, Integer.MAX_VALUE, true);
        }

        @Override
        public double similarity(@NotNull String first, @NotNull String second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return INSTANCE.similarity(first, second, Integer.MAX_VALUE, true);
        }
    }
}

