/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalCopyBlockAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Disabled;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBlocksText", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "blocks", "", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCopyBlockAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCopyBlockAction.kt\norg/jetbrains/plugins/terminal/action/TerminalCopyBlockAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1053#2:46\n*S KotlinDebug\n*F\n+ 1 TerminalCopyBlockAction.kt\norg/jetbrains/plugins/terminal/action/TerminalCopyBlockAction\n*L\n33#1:46\n*E\n"})
public final class TerminalCopyBlockAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController$intellij_terminal(e);
        if (terminalSelectionController == null) {
            return;
        }
        TerminalSelectionController selectionController = terminalSelectionController;
        String selectedText = this.getBlocksText(editor2, selectionController.getSelectedBlocks());
        if (((CharSequence)selectedText).length() > 0) {
            CopyPasteManager.copyTextToClipboard((String)selectedText);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        v0 = e.getPresentation();
        v1 = TerminalDataContextUtils.INSTANCE.getEditor(e);
        v2 = v1 != null ? TerminalDataContextUtils.INSTANCE.isOutputEditor(v1) : false;
        if (!v2) ** GOTO lbl-1000
        v3 = TerminalDataContextUtils.INSTANCE.getSelectionController$intellij_terminal(e);
        if ((v3 != null ? v3.getPrimarySelection() : null) != null) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        v0.setEnabledAndVisible(v4);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final String getBlocksText(Editor editor, List<? extends CommandBlock> blocks) {
        Iterable $this$sortedBy$iv = blocks;
        boolean $i$f$sortedBy = false;
        List sortedBlocks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CommandBlock it = (CommandBlock)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (CommandBlock)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        StringBuilder builder = new StringBuilder();
        int n = ((Collection)sortedBlocks).size();
        for (int index = 0; index < n; ++index) {
            CommandBlock block = (CommandBlock)sortedBlocks.get(index);
            builder.append(editor.getDocument().getText(CommandBlockImplKt.getTextRange(block)));
            if (index == CollectionsKt.getLastIndex((List)sortedBlocks)) continue;
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

