
variable "conf" {
  type    = string
  default = "${env("ONE")}-${env("ANOTHER")}-${env("BACKTICKED")}"
}

variable "manyspaces" {
  type    = string
  default = "${env("ASDFASDF")}"
}

variable "nospaces" {
  type    = string
  default = "${env("SOMETHING")}"
}

locals { timestamp = regex_replace(timestamp(), "[- TZ:]", "") }
# The "legacy_isotime" function has been provided for backwards compatability, but we recommend switching to the timestamp and formatdate functions.

source "null" "autogenerated_1" {
  communicator = "none"
}

build {
  sources = ["source.null.autogenerated_1"]

  provisioner "shell-local" {
    inline = ["echo ${var.conf}-${local.timestamp}-${legacy_isotime("01-02-2006")}"]
  }


  # 1 error occurred upgrading the following block:
  # unhandled "split" call:
  # there is no way to automatically upgrade the "split" call.
  # Please manually upgrade to `split(separator, string)`
  # Visit https://www.packer.io/docs/templates/hcl_templates/functions/string/split for more infos.
  provisioner "shell-local" {
    inline = ["echo {{ split `some-string` `-` 0 }}"]
  }

}
