/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2025 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * superformula Johan Gielis
 * https://bsapubs.onlinelibrary.wiley.com/doi/10.3732/ajb.90.3.333
 * http://paulbourke.net/geometry/supershape/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_supershape_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSSupershapeV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP1)
	{
		if (fractal->transformCommon.functionEnabledAxFalse)
		{
			if (!fractal->transformCommon.functionEnabledBxFalse)
				z.x = fractal->transformCommon.offset000.x - fabs(z.x);
			else
				z.x = sign(z.x) * (fractal->transformCommon.offset000.x - fabs(z.x));
		}

		if (fractal->transformCommon.functionEnabledAyFalse)
		{
			if (!fractal->transformCommon.functionEnabledByFalse)
				z.y = fractal->transformCommon.offset000.y - fabs(z.y);
			else
				z.y = sign(z.y) * (fractal->transformCommon.offset000.y - fabs(z.y));
		}

		if (fractal->transformCommon.functionEnabledAzFalse)
		{
			if (!fractal->transformCommon.functionEnabledBzFalse)
				z.z = fractal->transformCommon.offset000.z - fabs(z.z);
			else
				z.z = sign(z.z) * (fractal->transformCommon.offset000.z - fabs(z.z));
		}

		z *= fractal->transformCommon.scale1;
		aux->DE *= fractal->transformCommon.scale1;
		z += fractal->transformCommon.offsetA000;
	}

	REAL r1;
	REAL phi;
	if (!fractal->transformCommon.functionEnabledAFalse)
		phi = atan2(z.x, z.y);
	else
		phi = atan2(z.y, z.x);

	REAL t1 = fabs(native_cos(fractal->transformCommon.constantMultiplierA111.x * phi)
								 * fractal->transformCommon.constantMultiplierA111.y);
	if (fractal->transformCommon.functionEnabledXFalse)
		t1 = pow(t1, fractal->transformCommon.constantMultiplierB111.x);

	REAL t2 = fabs(native_sin(fractal->transformCommon.constantMultiplierA111.x * phi)
								 * fractal->transformCommon.constantMultiplierA111.z);
	if (fractal->transformCommon.functionEnabledYFalse)
		t2 = pow(t2, fractal->transformCommon.constantMultiplierB111.y);

	if (!fractal->transformCommon.functionEnabledEFalse)
		r1 = t1 + t2;
	else
		r1 = pow(t1 + t2, fractal->transformCommon.constantMultiplierB111.z);

	if (!fractal->transformCommon.functionEnabledFFalse) r1 = 1.0f / r1; // invert

	REAL4 zc = z;
	REAL rb = native_sqrt(z.x * z.x + z.y * z.y);
	zc.x = r1 * native_cos(phi);
	zc.y = r1 * native_sin(phi);

	REAL xyR = native_sqrt(zc.x * zc.x + zc.y * zc.y);

	if (!fractal->transformCommon.functionEnabledMFalse)
		xyR = rb - xyR - fractal->transformCommon.offsetR0;
	else
	{
		if (!fractal->transformCommon.functionEnabledNFalse)
		{
			rb = rb * (1.0f - fractal->transformCommon.scaleA0)
					 + fractal->transformCommon.offsetR0 * fractal->transformCommon.scaleA0;
			xyR = rb - xyR;
		}
		else
		{
			xyR = rb - xyR;
			rb = rb - fractal->transformCommon.offsetR0;
			xyR = min(rb, xyR);
		}
	}

	REAL cylR = xyR;
	if (fractal->transformCommon.functionEnabledFalse)
	{
		cylR = fabs(cylR) - fractal->transformCommon.offsetp01;
		cylR = max(cylR, xyR);
	}

	REAL cylH = fabs(zc.z) - fractal->transformCommon.offsetA1;

	if (fractal->transformCommon.functionEnabledzFalse)
	{
		cylR = cylR + (zc.z * zc.z * fractal->transformCommon.scaleB0);
	}

	cylR = max(cylR, 0.0f);
	cylH = max(cylH, 0.0f);
	REAL cylD = native_sqrt(cylR * cylR + cylH * cylH);
	cylD = min(max(cylR, cylH), 0.0f) + cylD;

	REAL colDist = aux->dist;
	aux->dist = min(aux->dist, cylD / (aux->DE + fractal->analyticDE.offset1));

	if (fractal->foldColor.auxColorEnabledFalse && colDist != aux->dist
			&& aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addCol = fractal->foldColor.difs0000.x;

		if (fractal->foldColor.auxColorEnabledAFalse)
		{
			if (fractal->transformCommon.offsetA1 < fabs(zc.z)) addCol = fractal->foldColor.difs0000.y;
			if (xyR <= -fractal->transformCommon.offsetp01) addCol = fractal->foldColor.difs0000.z;

			addCol += fractal->foldColor.difs0000.w * rb;
		}
		if (!fractal->foldColor.auxColorEnabledBFalse)
		{
			aux->color = addCol;
		}
		else
		{
			aux->color += addCol;
		}
	}
	return z;
}