/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Create and add Cpixel 4D constant to z vector

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_add_cpixel4d.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAddCpixel4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		REAL4 t = aux->const_c;

		if (fractal->transformCommon.functionEnabledAFalse)
		{ // c.w = rad
			t = (REAL4){t.x, t.y, t.z, 0.0f};
			t = (REAL4){t.x, t.y, t.z, length(t)};
		}

		if (fractal->transformCommon.functionEnabledBFalse)
		{ // quadray
			t = (REAL4){t.x + t.y + t.z, -t.x - t.y + t.z, -t.x + t.y - t.z, t.x - t.y - t.z};
		}

		if (fractal->transformCommon.functionEnabledFFalse) t = fabs(t);
		t = t - fractal->transformCommon.offsetA0000;
		if (fractal->transformCommon.functionEnabledCFalse) t = fabs(t);

		aux->const_c = t * fractal->transformCommon.scale1111;
		aux->c = aux->const_c;
	}

	if (fractal->transformCommon.functionEnabledDFalse)
	{
		aux->c.x *= sign(z.x);
		aux->c.y *= sign(z.y);
		aux->c.z *= sign(z.z);
		aux->c.w *= sign(z.w);
	}

	if (fractal->transformCommon.addCpixelEnabledFalse) z += aux->c;

	aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}