/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * formula by TGlad,
 * https://https://fractalforums.org/fractal-mathematics-and-new-theories/28/sphere-inversion-trees/5113

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_spheretree_v4.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 SpheretreeV4Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t = 0.0f;															// temp
	REAL4 tv = (REAL4){0.0f, 0.0f, 0.0f, 0.0f}; // temp vector
	REAL4 oldZ = z;
	REAL col = 0.0f;
	REAL4 ColV = tv;
	if (fractal->transformCommon.functionEnabledJFalse)
	{
		aux->DE = 1.0f;
		z = aux->const_c;
	}

	z *= fractal->transformCommon.scaleG1; // master scale
	aux->DE *= fractal->transformCommon.scaleG1;

	int NumChildren = fractal->transformCommon.int8X;
	int n = NumChildren;
	REAL ang1 = M_PI_F / n;

	REAL o1 = 3.0f;
	if (NumChildren <= 4)
		o1 = 5.0f;
	else if (NumChildren <= 6)
		o1 = 4.0f;
	REAL sec = 1.0f / native_cos(M_PI_F / o1);
	REAL csc = 1.0f / native_sin(M_PI_F / n);
	REAL r = sec / native_sqrt(csc * csc - sec * sec);
	REAL l = native_sqrt(1.0f + r * r);

	REAL o2 = fractal->transformCommon.offset3;
	t = native_sin(M_PI_F - M_PI_F / o2);
	REAL theta = asin(r * t / l);
	REAL L4 = l * native_sin(M_PI_F / o2 - theta) / t;
	REAL minr = L4 * L4 * fractal->transformCommon.scaleD1;
	REAL bend = fractal->transformCommon.scale08;
	REAL omega = 0.0f;
	REAL bigR = 0.0f;
	REAL d = 0.0f;

	if (!fractal->transformCommon.functionEnabledzFalse)
	{
		omega = M_PI_2_F - bend;
		bigR = 1.0f / native_cos(omega);
		d = tan(omega);
	}
	// iteration loop
	bool recurse = true;
	if (fractal->transformCommon.functionEnabledFalse) recurse = false;
	for (int c = 0; c < fractal->transformCommon.int16; c++)
	{
		if (fractal->transformCommon.functionEnabledzFalse)
		{
			omega = M_PI_2_F - bend;
			bigR = 1.0f / native_cos(omega);
			d = tan(omega);
		}

		if (recurse == true && c >= fractal->transformCommon.startIterationsC
				&& c < fractal->transformCommon.stopIterationsC)
		{
			z.z += d + bigR;
			REAL inv = 1.0f / dot(z, z);
			REAL sc = 4.0f * bigR * bigR * inv;
			z *= sc;
			aux->DE *= sc;
			z.z += -2.0f * bigR;
			z.z = -z.z;
			REAL invSize = (bigR + d) / (2.0f * bigR);
			aux->DE *= invSize;
			z *= invSize;
			recurse = false;
		}

		REAL angle = atan2(z.y, z.x);
		if (angle < 0.0f) angle += M_PI_2x_F;
		angle = fmod(angle, M_PI_2x_F / n);
		REAL mag = native_sqrt(z.x * z.x + z.y * z.y);
		z.x = mag * native_cos(angle);
		z.y = mag * native_sin(angle);

		REAL4 circle_centre = l * (REAL4){native_cos(ang1), native_sin(ang1), 0.0f, 0.0f};
		tv = z - circle_centre;
		REAL len = length(tv);
		if (len < r)
		{
			ColV.x += 1.0f;
			REAL sc = r * r / (len * len);
			tv *= sc;
			aux->DE *= sc;
		}
		z = tv + circle_centre;

		o2 = bend / 2.0f;
		REAL R2 = minr / native_cos(o2);
		tv = z;
		tv.z -= minr * tan(o2) * fractal->transformCommon.scaleA1;
		REAL amp = length(tv);
		// REAL mag4 = native_sqrt(z.x * z.x + z.y * z.y};
		if (amp <= R2 - fractal->transformCommon.offsetA0
				&& c >= fractal->transformCommon.startIterationsB
				&& c < fractal->transformCommon.stopIterationsB) // || mag4 <= minr)
		{
			ColV.z += 1.0f;
			t = 1.0f / minr;
			z *= t;
			aux->DE *= t;
			recurse = true;
		}
		else if (length(z) < L4)
		{
			REAL inv = 1.0f / dot(z, z);
			REAL sc = L4 * L4 * inv;
			z *= sc;
			aux->DE *= sc;
		}

		if (c >= fractal->transformCommon.startIterationsA
				&& c < fractal->transformCommon.stopIterationsA)
		{
			bend *= fractal->transformCommon.scaleB1;
			bend += fractal->transformCommon.offsetB0;
		}

		// post scale
		z *= fractal->transformCommon.scaleC1;
		aux->DE *= fabs(fractal->transformCommon.scaleC1);

		// DE tweaks
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

		if (fractal->foldColor.auxColorEnabled && c >= fractal->foldColor.startIterationsA
				&& c < fractal->foldColor.stopIterationsA)
		{
			t = length(z);

			aux->temp1000 = min(aux->temp1000, t);
			ColV.y = aux->temp1000;
			ColV.w = t;

			col += ColV.x * fractal->foldColor.difs0000.x + ColV.y * fractal->foldColor.difs0000.y
						 + ColV.z * fractal->foldColor.difs0000.z + ColV.w * fractal->foldColor.difs0000.w;
		}
	}

	aux->DE = aux->DE + fractal->transformCommon.offsetF0;
	if (fractal->transformCommon.offset0 != 0.0f)
	{
		t = length(z);
		aux->DE *= t / (t - fractal->transformCommon.offset0);
		aux->dist = t / aux->DE;
	}

	if (fractal->analyticDE.enabledFalse) z = oldZ;

	if (!fractal->transformCommon.functionEnabledCFalse)
		aux->color += col;
	else
		aux->color = col;
	return z;
}