/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Mandelbar or Tricorn version based on pow2 code from Davis Makin
 * ref: https://www.facebook.com/david.makin.7

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbar_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelbarV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledFalse)
	{
		if (fractal->transformCommon.functionEnabledAxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledAyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledAzFalse) z.z = fabs(z.z);
	}

	REAL m2 = z.x * z.x + z.y * z.y;
	aux->DE = aux->DE * 2.0f * native_sqrt(m2 + z.z * z.z) + 1.0f;
	if (m2 == 0.0f)
	{
		z.y = -z.z * z.z;
		z.z = 0.0f;
	}
	else
	{
		REAL temp = m2 - z.z * z.z;
		z.z = 2.0f * native_sqrt(m2) * z.z;
		m2 = temp / m2;
		temp = 2.0f * z.x * z.y * m2;

		z.y = (z.y * z.y - z.x * z.x) * m2;
		z.x = -temp;
	}

	// offset (Julia)
	z += fractal->transformCommon.additionConstant000;

	z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);

	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
	return z;
}