/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor.filter;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;

public class KotlinMetadataFilter
implements KotlinMetadataVisitor {
    private final Predicate<KotlinMetadata> predicate;
    private final KotlinMetadataVisitor acceptedVisitor;
    private final KotlinMetadataVisitor rejectedVisitor;

    public KotlinMetadataFilter(KotlinMetadataVisitor acceptedVisitor, KotlinMetadataVisitor rejectedVisitor) {
        this(__ -> true, acceptedVisitor, rejectedVisitor);
    }

    public KotlinMetadataFilter(Predicate<KotlinMetadata> predicate, KotlinMetadataVisitor acceptedVisitor) {
        this(predicate, acceptedVisitor, null);
    }

    public KotlinMetadataFilter(Predicate<KotlinMetadata> predicate, KotlinMetadataVisitor acceptedVisitor, KotlinMetadataVisitor rejectedVisitor) {
        this.predicate = predicate;
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        KotlinMetadataVisitor visitor = this.getDelegateVisitor(kotlinMetadata);
        if (visitor != null) {
            kotlinMetadata.accept(clazz, visitor);
        }
    }

    private KotlinMetadataVisitor getDelegateVisitor(KotlinMetadata kotlinMetadata) {
        return this.predicate.test(kotlinMetadata) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

