/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.BootstrapMethodRemapper;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.Processable;

public class BootstrapMethodsAttributeShrinker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor,
BootstrapMethodInfoVisitor {
    private static final Object USED = new Object();
    private int[] bootstrapMethodIndexMap = new int[16];
    private final BootstrapMethodRemapper bootstrapMethodRemapper = new BootstrapMethodRemapper(true);
    private int referencedBootstrapMethodIndex = -1;
    private boolean modified = false;

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.modified = false;
        this.bootstrapMethodIndexMap = new int[16];
        programClass.accept(new ClassCleaner());
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        if (this.modified) {
            programClass.accept(new ConstantPoolShrinker());
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        if (this.referencedBootstrapMethodIndex > -1) {
            bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.referencedBootstrapMethodIndex, this);
        } else {
            int newBootstrapMethodsCount = this.shrinkBootstrapMethodArray(bootstrapMethodsAttribute.bootstrapMethods, bootstrapMethodsAttribute.u2bootstrapMethodsCount);
            if (newBootstrapMethodsCount < bootstrapMethodsAttribute.u2bootstrapMethodsCount) {
                this.modified = true;
                bootstrapMethodsAttribute.u2bootstrapMethodsCount = newBootstrapMethodsCount;
                if (bootstrapMethodsAttribute.u2bootstrapMethodsCount == 0) {
                    AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, false);
                    attributesEditor.deleteAttribute("BootstrapMethods");
                    clazz.attributesAccept(new MethodHandlesLookupInnerClassRemover(attributesEditor));
                } else {
                    this.bootstrapMethodRemapper.setBootstrapMethodIndexMap(this.bootstrapMethodIndexMap);
                    clazz.constantPoolEntriesAccept(this.bootstrapMethodRemapper);
                }
            }
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -70) {
            ProgramClass programClass = (ProgramClass)clazz;
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)programClass.getConstant(constantInstruction.constantIndex);
            this.referencedBootstrapMethodIndex = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
            programClass.attributesAccept(this);
            this.referencedBootstrapMethodIndex = -1;
        }
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        this.markAsUsed(bootstrapMethodInfo);
    }

    private void markAsUsed(BootstrapMethodInfo bootstrapMethodInfo) {
        bootstrapMethodInfo.setProcessingInfo(USED);
    }

    private boolean isUsed(Processable processable) {
        return processable.getProcessingInfo() == USED;
    }

    private int shrinkBootstrapMethodArray(BootstrapMethodInfo[] bootstrapMethods, int length) {
        if (this.bootstrapMethodIndexMap.length < length) {
            this.bootstrapMethodIndexMap = new int[length];
        }
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            BootstrapMethodInfo bootstrapMethod = bootstrapMethods[index];
            if (this.isUsed(bootstrapMethod)) {
                this.bootstrapMethodIndexMap[index] = counter;
                bootstrapMethods[counter++] = bootstrapMethod;
                continue;
            }
            this.bootstrapMethodIndexMap[index] = -1;
        }
        Arrays.fill(bootstrapMethods, counter, length, null);
        return counter;
    }

    private class MethodHandlesLookupInnerClassRemover
    implements AttributeVisitor,
    InnerClassesInfoVisitor {
        private static final String METHOD_HANDLES_CLASS = "java/lang/invoke/MethodHandles";
        private final Object methodHandleLookupMarker = new Object();
        private final AttributesEditor attributesEditor;

        public MethodHandlesLookupInnerClassRemover(AttributesEditor attributesEditor) {
            this.attributesEditor = attributesEditor;
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
            InnerClassesAttributeEditor editor = new InnerClassesAttributeEditor(innerClassesAttribute);
            for (int index = innerClassesAttribute.u2classesCount - 1; index >= 0; --index) {
                InnerClassesInfo innerClassesInfo = innerClassesAttribute.classes[index];
                if (!this.shouldBeRemoved(innerClassesInfo)) continue;
                editor.removeInnerClassesInfo(innerClassesInfo);
            }
            if (innerClassesAttribute.u2classesCount == 0) {
                this.attributesEditor.deleteAttribute("InnerClasses");
            }
        }

        @Override
        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            ProgramClass programClass = (ProgramClass)clazz;
            ClassConstant innerClass = (ClassConstant)programClass.getConstant(innerClassesInfo.u2innerClassIndex);
            ClassConstant outerClass = (ClassConstant)programClass.getConstant(innerClassesInfo.u2outerClassIndex);
            if (this.isMethodHandleClass(innerClass, clazz) || this.isMethodHandleClass(outerClass, clazz)) {
                this.markForRemoval(innerClassesInfo);
            }
        }

        private void markForRemoval(InnerClassesInfo innerClassesInfo) {
            innerClassesInfo.setProcessingInfo(this.methodHandleLookupMarker);
        }

        private boolean shouldBeRemoved(InnerClassesInfo innerClassesInfo) {
            return innerClassesInfo.getProcessingInfo() == this.methodHandleLookupMarker;
        }

        public boolean isMethodHandleClass(ClassConstant classConstant, Clazz clazz) {
            return classConstant != null && classConstant.getName(clazz).startsWith(METHOD_HANDLES_CLASS);
        }
    }
}

