/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite parent, int style) {
        super(parent, style);
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        int border = GTK.gtk_container_get_border_width(this.handle);
        size.x += 2 * border;
        size.y += 2 * border;
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = this.gtk_box_new(1, false, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = GTK.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
            GTK.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            if (GTK.GTK_VERSION < OS.VERSION(3, 8, 0)) {
                GTK.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
            } else {
                GTK.gtk_container_add(this.scrolledHandle, this.handle);
            }
            long viewport = GTK.gtk_bin_get_child(this.scrolledHandle);
            GTK.gtk_viewport_set_shadow_type(viewport, 0);
        } else {
            GTK.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_container_set_border_width(this.handle, 0);
        this.setFontDescription(this.defaultFont().handle);
    }

    void createItem(ExpandItem item, int style, int index) {
        if (0 > index || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        item.width = Math.max(0, this.getClientAreaInPixels().width - this.spacing * 2);
        this.layoutItems(index, true);
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem item) {
        int index;
        for (index = 0; index < this.itemCount && this.items[index] != item; ++index) {
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item.redraw();
        this.layoutItems(index, true);
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean forceFocus(long focusHandle) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem item = this.items[i];
            if (!item.setFocus()) continue;
            return true;
        }
        return super.forceFocus(focusHandle);
    }

    @Override
    boolean hasFocus() {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem item = this.items[i];
            if (!item.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.scrolledHandle != 0L) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.getClosure(47), true);
        }
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gc = new GC(this);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return Math.max(24, metrics.getHeight());
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getSpacing() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.spacing);
    }

    int getSpacingInPixels() {
        this.checkWidget();
        return this.spacing;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        int offset;
        int index;
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        for (index = 0; index < this.itemCount && !this.items[index].hasFocus(); ++index) {
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
        boolean next = false;
        switch (gdkEvent.keyval) {
            case 65361: 
            case 65362: {
                next = false;
                break;
            }
            case 65363: 
            case 65364: {
                next = true;
                break;
            }
            default: {
                return result;
            }
        }
        int start = index;
        int n = offset = next ? 1 : -1;
        while ((index = (index + offset + this.itemCount) % this.itemCount) != start) {
            ExpandItem item = this.items[index];
            if (!item.setFocus()) continue;
            return result;
        }
        return result;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    void layoutItems(int index, boolean setScrollbar) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem item = this.items[i];
            if (item == null) continue;
            item.resizeControl(this.yCurrentScroll);
        }
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        long result = super.gtk_size_allocate(widget, allocation);
        this.layoutItems(0, false);
        return result;
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void releaseChildren(boolean destroy) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem item = this.items[i];
            if (item == null || item.isDisposed()) continue;
            item.release(false);
        }
        super.releaseChildren(destroy);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                ExpandItem item = this.items[i];
                if (item == null) continue;
                item.reskin(flags);
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setWidgetBackground() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            GdkRGBA rgba = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
            super.setBackgroundGdkRGBA(this.handle, rgba);
        } else {
            super.setWidgetBackground();
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setFontDescription(font);
        }
        this.layoutItems(0, true);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setForegroundRGBA(rgba);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(create);
            }
        }
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int height = this.getClientAreaInPixels().height;
        ExpandItem item = this.items[this.itemCount - 1];
        int maxHeight = item.y + this.getBandHeight() + this.spacing;
        if (item.expanded) {
            maxHeight += item.height;
        }
        long adjustmentHandle = GTK.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(adjustmentHandle, adjustment);
        this.yCurrentScroll = (int)adjustment.value;
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        adjustment.value = Math.min(this.yCurrentScroll, maxHeight += this.yCurrentScroll);
        adjustment.upper = maxHeight;
        adjustment.page_size = height;
        GTK.gtk_adjustment_configure(adjustmentHandle, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        int policy = maxHeight > height ? 0 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, policy);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.fixedHandle, allocation);
        int width = allocation.width - this.spacing * 2;
        if (policy == 0) {
            long vHandle = 0L;
            vHandle = GTK.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(vHandle, requisition);
            width -= requisition.width;
        }
        width = Math.max(0, width);
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem item2 = this.items[i];
            item2.setBounds(0, 0, width, item2.height, false, true);
        }
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        this.setSpacingInPixels(DPIUtil.autoScaleUp(spacing));
    }

    void setSpacingInPixels(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        GTK.gtk_box_set_spacing(this.handle, spacing);
        GTK.gtk_container_set_border_width(this.handle, spacing);
    }

    void showItem(ExpandItem item) {
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item.expanded);
        }
        item.redraw();
        int index = this.indexOf(item);
        this.layoutItems(index + 1, true);
    }

    @Override
    void updateScrollBarValue(ScrollBar bar) {
        this.yCurrentScroll = bar.getSelection();
        this.layoutItems(0, false);
    }
}

