import _extends from "@babel/runtime/helpers/extends";
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { forwardRef } from 'react';

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css, jsx } from '@emotion/react';
import { SurfaceContext } from '../utils/surface-provider';
import { backgroundColorStylesMap, isSurfaceColorToken, paddingStylesMap, surfaceColorStylesMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';

// Can either Exclude or Extract - here we're excluding all SVG-related elements, <button> elements (handled by Pressable), and <a> elements (handled by Anchor)

// Basically just ElementType but without ComponentType, it makes sense to keep the "Type" suffix
// eslint-disable-next-line @repo/internal/react/consistent-types-definitions

/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
export const Box = /*#__PURE__*/forwardRef(({
  as: Component = 'div',
  children,
  backgroundColor,
  padding,
  paddingBlock,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  style,
  testId,
  xcss,
  ...htmlAttributes
}, ref) => {
  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  const {
    className: _spreadClass,
    ...safeHtmlAttributes
  } = htmlAttributes;
  const resolvedStyles = parseXcss(xcss);
  const node =
  // @ts-expect-error Expression produces a union type that is too complex to represent. I think this is unavoidable
  jsx(Component
  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  , _extends({
    style: style
    // @ts-ignore Expression produces a union type that is too complex to represent. We may be able to narrow the type here but unsure.
    ,
    ref: ref
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static
  }, safeHtmlAttributes, {
    css: [baseStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    backgroundColor && backgroundColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    isSurfaceColorToken(backgroundColor) && surfaceColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    padding && paddingStylesMap.padding[padding],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlock && paddingStylesMap.paddingBlock[paddingBlock],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockStart && paddingStylesMap.paddingBlockStart[paddingBlockStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockEnd && paddingStylesMap.paddingBlockEnd[paddingBlockEnd],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInline && paddingStylesMap.paddingInline[paddingInline],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineStart && paddingStylesMap.paddingInlineStart[paddingInlineStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineEnd && paddingStylesMap.paddingInlineEnd[paddingInlineEnd], resolvedStyles.emotion],
    "data-testid": testId
  }), children);
  return backgroundColor ? jsx(SurfaceContext.Provider, {
    value: backgroundColor
  }, node) : node;
}
// @ts-ignore This typescript error has been surpessed while locally enrolling `@atlaskit/primitives` into Jira
// The return type of `BoxComponent` does not match the return type of `forwardRef` in React 18
);
export default Box;
const baseStyles = css({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});