import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { type AnalyticsReactContextInterface } from '@atlaskit/analytics-next-stable-react-context';
interface Props {
    /** Children! */
    children: React.ReactNode;
    /** Arbitrary data. Any events created below this component in the tree will
     * have this added as an item in their context array. */
    data: Object;
}
declare class AnalyticsContext extends Component<Props, AnalyticsReactContextInterface> {
    context: any;
    static contextTypes: {
        getAtlaskitAnalyticsContext: PropTypes.Requireable<(...args: any[]) => any>;
        getAtlaskitAnalyticsEventHandlers: PropTypes.Requireable<(...args: any[]) => any>;
    };
    static childContextTypes: {
        getAtlaskitAnalyticsContext: PropTypes.Requireable<(...args: any[]) => any>;
        getAtlaskitAnalyticsEventHandlers: PropTypes.Requireable<(...args: any[]) => any>;
    };
    contextValue: AnalyticsReactContextInterface;
    constructor(props: Props);
    getChildContext: () => {
        getAtlaskitAnalyticsContext: () => any[];
    };
    getAnalyticsContext: () => any[];
    getAnalyticsEventHandlers: () => any;
    render(): React.JSX.Element;
}
export default AnalyticsContext;
