// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportPartialSuccess represents the details of a partially successful export request.
type ExportTracePartialSuccess struct {
	ErrorMessage  string
	RejectedSpans int64
}

var (
	protoPoolExportTracePartialSuccess = sync.Pool{
		New: func() any {
			return &ExportTracePartialSuccess{}
		},
	}
)

func NewExportTracePartialSuccess() *ExportTracePartialSuccess {
	if !UseProtoPooling.IsEnabled() {
		return &ExportTracePartialSuccess{}
	}
	return protoPoolExportTracePartialSuccess.Get().(*ExportTracePartialSuccess)
}

func DeleteExportTracePartialSuccess(orig *ExportTracePartialSuccess, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExportTracePartialSuccess.Put(orig)
	}
}

func CopyExportTracePartialSuccess(dest, src *ExportTracePartialSuccess) *ExportTracePartialSuccess {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportTracePartialSuccess()
	}
	dest.RejectedSpans = src.RejectedSpans
	dest.ErrorMessage = src.ErrorMessage

	return dest
}

func CopyExportTracePartialSuccessSlice(dest, src []ExportTracePartialSuccess) []ExportTracePartialSuccess {
	var newDest []ExportTracePartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]ExportTracePartialSuccess, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportTracePartialSuccess(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportTracePartialSuccess(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportTracePartialSuccessPtrSlice(dest, src []*ExportTracePartialSuccess) []*ExportTracePartialSuccess {
	var newDest []*ExportTracePartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]*ExportTracePartialSuccess, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportTracePartialSuccess()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportTracePartialSuccess(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportTracePartialSuccess()
		}
	}
	for i := range src {
		CopyExportTracePartialSuccess(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportTracePartialSuccess) Reset() {
	*orig = ExportTracePartialSuccess{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportTracePartialSuccess) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedSpans != int64(0) {
		dest.WriteObjectField("rejectedSpans")
		dest.WriteInt64(orig.RejectedSpans)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportTracePartialSuccess) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "rejectedSpans", "rejected_spans":
			orig.RejectedSpans = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportTracePartialSuccess) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RejectedSpans != int64(0) {
		n += 1 + proto.Sov(uint64(orig.RejectedSpans))
	}

	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExportTracePartialSuccess) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedSpans != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedSpans))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *ExportTracePartialSuccess) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedSpans", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.RejectedSpans = int64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ErrorMessage = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportTracePartialSuccess() *ExportTracePartialSuccess {
	orig := NewExportTracePartialSuccess()
	orig.RejectedSpans = int64(13)
	orig.ErrorMessage = "test_errormessage"
	return orig
}

func GenTestExportTracePartialSuccessPtrSlice() []*ExportTracePartialSuccess {
	orig := make([]*ExportTracePartialSuccess, 5)
	orig[0] = NewExportTracePartialSuccess()
	orig[1] = GenTestExportTracePartialSuccess()
	orig[2] = NewExportTracePartialSuccess()
	orig[3] = GenTestExportTracePartialSuccess()
	orig[4] = NewExportTracePartialSuccess()
	return orig
}

func GenTestExportTracePartialSuccessSlice() []ExportTracePartialSuccess {
	orig := make([]ExportTracePartialSuccess, 5)
	orig[1] = *GenTestExportTracePartialSuccess()
	orig[3] = *GenTestExportTracePartialSuccess()
	return orig
}
