---
title: LocalManager
---

The LocalManager operator is used by the `ig` binary. This operator keeps track
of the containers on the system talking to the different container runtimes and
using the fanotify mechanism to detect when containers are created. This
information is used to:
- Update the eBPF maps used to filter events in eBPF by container name.
- Enrich events with container information (see below).
- Attach networking programs to specific containers according to the filtering
  options passed by the user.

This operator uses the mount or network namespace inode IDs to enrich events
with the following fields:

- runtime
  - runtime name
  - container name
  - container ID
  - container image name
  - container image digest
  - container started time

It also adds some Kubernetes information gathered from the container runtimes,
but it doesn't talk to the kube-apiserver unless the
[`enrich-with-k8s-apiserver`](#enrich-with-k8s-apiserver) parameter is set.
- k8s
  - container name
  - pod name
  - namespace
  - pod labels
  - owner (only when using `enrich-with-k8s-apiserver`)

## Priority

-1

## Global Parameters

### `runtimes`

Comma-separated list of container runtimes. Supported values are: docker,
containerd, cri-o, podman.

Default: `docker,containerd,cri-o,podman`

### `docker-socketpath`

Docker Engine API Unix socket path

Default: `/run/docker.sock`

### `crio-socketpath`

CRI-O CRI Unix socket path

Default: `/run/crio/crio.sock`

### `podman-socketpath`

Podman Unix socket path

Default: `/run/podman/podman.sock`

### `containerd-socketpath`

Containerd CRI Unix socket path

Default: `/run/containerd/containerd.sock`

### `containerd-namespace`

Containerd namespace to use

Default: `k8s.io`

### `runtime-protocol`

Container runtime protocol. Supported values are: internal, cri

Using cri will enrich events with the labels of the Kubernetes pod.

Default: `internal`

### `enrich-with-k8s-apiserver`

Connect to the K8s API server to get further K8s enrichment, like the [owner
reference](https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/).

Default: `false`

## Instance Parameters

### `containername` / `runtime-containername`

Show data only from containers with the runtime-assigned name (not the name defined in the pod spec)

Fully qualified name: `operator.LocalManager.containername` / `operator.LocalManager.runtime-containername`

### `k8s-containername`

Show data only from containers with the name defined in the pod spec

Fully qualified name: `operator.LocalManager.k8s-containername`

### `k8s-namespace`

Show only data from containers in that Kubernetes namespace

Fully qualified name: `operator.LocalManager.k8s-namespace`

### `k8s-podname`

Show only data from containers in that Kubernetes pod

Fully qualified name: `operator.LocalManager.k8s-podname`

### `k8s-selector`

Kubernetes Labels selector to filter on. Only '=' is supported (e.g. key1=value1,key2=value2).

Fully qualified name: `operator.LocalManager.k8s-selector`

### `host`

Show data from both the host and containers

Fully qualified name: `operator.LocalManager.host`

Default: `false`

## Containers datasource

This operator creates the `containers` datasource which publishes events about containers being created or deleted.
It is only activated if the gadget has the following annotations:

```yaml
annotations:
  enable-containers-datasource: true
```

So far, the event published contains the following fields:
- `event_type`: Either "CREATED" or "DELETED".
- `name`: The container name.
- `mntns_id`: The container mount namespace ID.
- `cgroup_id`: The container cgroup ID.
