/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-Studio-CLA-applies
 *
 * MuseScore Studio
 * Music Composition & Notation
 *
 * Copyright (C) 2021 MuseScore Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "restsettingsmodel.h"

using namespace mu::engraving;

namespace mu::inspector {
RestSettingsModel::RestSettingsModel(QObject* parent, IElementRepositoryService* repository)
    : AbstractInspectorModel(parent, repository)
{
    setModelType(InspectorModelType::TYPE_REST_REST);
    createProperties();
}

PropertyItem* RestSettingsModel::alignWithOtherRests() const
{
    return m_alignWithOtherRests;
}

void RestSettingsModel::createProperties()
{
    m_alignWithOtherRests = buildPropertyItem(Pid::ALIGN_WITH_OTHER_RESTS);
}

void RestSettingsModel::requestElements()
{
    m_elementList = m_repository->findElementsByType(ElementType::REST);
}

void RestSettingsModel::loadProperties()
{
    loadPropertyItem(m_alignWithOtherRests);
}

void RestSettingsModel::resetProperties()
{
    m_alignWithOtherRests->resetToDefault();
}
} // namespace mu::inspector
