//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/cttexttab?language=objc)
#[doc(alias = "CTTextTabRef")]
#[repr(C)]
pub struct CTTextTab {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTTextTab {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTTextTab"> for CTTextTab {}
);

unsafe impl ConcreteType for CTTextTab {
    /// Returns the CFType of the text tab object
    #[doc(alias = "CTTextTabGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTTextTabGetTypeID() -> CFTypeID;
        }
        unsafe { CTTextTabGetTypeID() }
    }
}

extern "C" {
    /// Used to specify the terminating character for a tab column
    ///
    ///
    /// The value associated with this attribute is a CFCharacterSet. The
    /// character set is used to determine the terminating character for
    /// a tab column. The tab and newline characters are implied even if
    /// they don't exist in the character set. This attribute can be used
    /// to implement decimal tabs, for instance. This attribute is
    /// optional.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kcttabcolumnterminatorsattributename?language=objc)
    pub static kCTTabColumnTerminatorsAttributeName: &'static CFString;
}

impl CTTextTab {
    /// Creates and initializes a new text tab.
    ///
    ///
    /// Parameter `alignment`: The tab's alignment. This is used to determine the position of
    /// text inside the tab column. This parameter must be set to a valid
    /// CTTextAlignment value or this function will return NULL.
    ///
    ///
    /// Parameter `location`: The tab's ruler location, relative to the back margin.
    ///
    ///
    /// Parameter `options`: Options to pass in when the tab is created. Currently, the only
    /// option available is kCTTabColumnTerminatorsAttributeName. This
    /// parameter is optional and can be set to NULL if not needed.
    ///
    ///
    /// Returns: The new CTTextTab.
    ///
    /// # Safety
    ///
    /// `options` generics must be of the correct type.
    #[doc(alias = "CTTextTabCreate")]
    #[cfg(feature = "CTParagraphStyle")]
    #[inline]
    pub unsafe fn new(
        alignment: CTTextAlignment,
        location: c_double,
        options: Option<&CFDictionary>,
    ) -> CFRetained<CTTextTab> {
        extern "C-unwind" {
            fn CTTextTabCreate(
                alignment: CTTextAlignment,
                location: c_double,
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CTTextTab>>;
        }
        let ret = unsafe { CTTextTabCreate(alignment, location, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the text alignment of the tab.
    ///
    ///
    /// Parameter `tab`: The tab whose text alignment you wish to access.
    ///
    ///
    /// Returns: The tab's text alignment value.
    #[doc(alias = "CTTextTabGetAlignment")]
    #[cfg(feature = "CTParagraphStyle")]
    #[inline]
    pub unsafe fn alignment(&self) -> CTTextAlignment {
        extern "C-unwind" {
            fn CTTextTabGetAlignment(tab: &CTTextTab) -> CTTextAlignment;
        }
        unsafe { CTTextTabGetAlignment(self) }
    }

    /// Returns the tab's ruler location.
    ///
    ///
    /// Parameter `tab`: The tab whose location you wish to access.
    ///
    ///
    /// Returns: The tab's ruler location relative to the back margin.
    #[doc(alias = "CTTextTabGetLocation")]
    #[inline]
    pub unsafe fn location(&self) -> c_double {
        extern "C-unwind" {
            fn CTTextTabGetLocation(tab: &CTTextTab) -> c_double;
        }
        unsafe { CTTextTabGetLocation(self) }
    }

    /// Returns the dictionary of attributes associated with the tab.
    ///
    ///
    /// Parameter `tab`: The tab whose attributes you wish to access.
    ///
    ///
    /// Returns: The dictionary of attributes associated with the tab or NULL if
    /// no dictionary is present.
    #[doc(alias = "CTTextTabGetOptions")]
    #[inline]
    pub unsafe fn options(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CTTextTabGetOptions(tab: &CTTextTab) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CTTextTabGetOptions(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

#[cfg(feature = "CTParagraphStyle")]
#[deprecated = "renamed to `CTTextTab::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CTTextTabCreate(
    alignment: CTTextAlignment,
    location: c_double,
    options: Option<&CFDictionary>,
) -> CFRetained<CTTextTab> {
    extern "C-unwind" {
        fn CTTextTabCreate(
            alignment: CTTextAlignment,
            location: c_double,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CTTextTab>>;
    }
    let ret = unsafe { CTTextTabCreate(alignment, location, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[cfg(feature = "CTParagraphStyle")]
    #[deprecated = "renamed to `CTTextTab::alignment`"]
    pub fn CTTextTabGetAlignment(tab: &CTTextTab) -> CTTextAlignment;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTTextTab::location`"]
    pub fn CTTextTabGetLocation(tab: &CTTextTab) -> c_double;
}

#[deprecated = "renamed to `CTTextTab::options`"]
#[inline]
pub unsafe extern "C-unwind" fn CTTextTabGetOptions(
    tab: &CTTextTab,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CTTextTabGetOptions(tab: &CTTextTab) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CTTextTabGetOptions(tab) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
