/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

class PeerFixer
implements AdjustmentListener,
Serializable {
    private static final long serialVersionUID = 7051237413532574756L;
    private ScrollPane scroller;

    PeerFixer(ScrollPane scrollPane) {
        this.scroller = scrollPane;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.scroller.peer;
        if (scrollPanePeer != null) {
            scrollPanePeer.setValue(adjustable, n);
        }
        Component component = this.scroller.getComponent(0);
        switch (adjustable.getOrientation()) {
            case 1: {
                component.move(component.getLocation().x, -n);
                break;
            }
            case 0: {
                component.move(-n, component.getLocation().y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal adjustable orientation");
            }
        }
    }
}

