#!/usr/bin/env perl

###############################################################################
# Copyright (c) 2025, The OpenBLAS Project
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the OpenBLAS project nor the names of
#    its contributors may be used to endorse or promote products
#    derived from this software without specific prior written permission.
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE OPENBLAS PROJECT OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
###############################################################################

# Changelog
# 2017/09/03 staticfloat
# Added zsymv and csymv into @lapackobjs2 so they are properly renamed
#
# 2017/07/01 Saar
# removed zsymv_ and csymv_ from @blasobs, because these functions
# are now in lapack-3.7.0
# added blas_thread_shutdown_
# added Cblas_cgemm3m and Cblas_zgemm3m
# added somatcopy_, simatcopy_ ...
# added new functions from lapack-3.7.0
# added LAPACKE deprecated objs from lapack-3.7.0
#
# 2017/08/01 Saar
# removed blas_thread_shutdown_
#
@blasobjsc = (
    caxpy,caxpby,ccopy,cdotc,cdotu,cgbmv,cgemm,cgemv,cgerc,cgeru,
    chbmv,chemm,chemv,cher2,cher2k,cher,cherk,scabs1,scamax,
    chpmv,chpr2,chpr,crotg,cscal,csrot,csscal,cswap,scamin,scasum,scnrm2,
    csymm,csyr2k,csyrk,ctbmv,ctbsv,ctpmv,ctpsv,ctrmm,ctrmv,ctrsm,
    ctrsv,icamax,icamin,cimatcopy,comatcopy,cgeadd,scsum,cgemmt,cgemmtr);
    
@blasobjsd = (
    damax,damin,dasum,daxpy,daxpby,dcabs1,dcopy,ddot,dgbmv,dgemm,
    dgemv,dger,dmax,dmin,dnrm2,drot,drotg,drotm,drotmg,dsbmv,
    dscal,dsdot,dspmv,dspr2,dimatcopy,domatcopy,
    dspr,dswap,dsymm,dsymv,dsyr2,dsyr2k,dsyr,dsyrk,dtbmv,dtbsv,
    dtpmv,dtpsv,dtrmm,dtrmv,dtrsm,dtrsv,
        idamax,idamin,idmax,idmin,dgeadd,dsum,dgemmt,dgemmtr);
    
@blasobjss = (
    isamax,isamin,ismax,ismin,
    samax,samin,sasum,saxpy, saxpby, 
    scopy,sdot,sdsdot,sgbmv,sgemm,sgemv,sger,
    smax,smin,snrm2,simatcopy,somatcopy,
    srot,srotg,srotm,srotmg,ssbmv,sscal,sspmv,sspr2,sspr,sswap,
    ssymm,ssymv,ssyr2,ssyr2k,ssyr,ssyrk,stbmv,stbsv,stpmv,stpsv,
    strmm,strmv,strsm,strsv, sgeadd,ssum,sgemmt,sgemmtr);
     
@blasobjsz = (
    izamax,izamin,,
    zaxpy,zaxpby,zcopy,zdotc,zdotu,zdrot,
    zdscal,zgbmv,zgemm,zgemv,zgerc,zgeru,
    zhbmv,zhemm,zhemv,zher2,zher2k,zher,zherk,zhpmv,zhpr2,
    zhpr,zrotg,zscal,zswap,zsymm,zsyr2k,zsyrk,ztbmv,
    ztbsv,ztpmv,ztpsv,ztrmm,ztrmv,ztrsm,ztrsv,
    zomatcopy, zimatcopy,dzamax,dzamin,dzasum,dznrm2,
    zgeadd, dzsum, zgemmt,zgemmtr);

@blasobjs = (lsame, xerbla);
@bfblasobjs = (bgemm, bgemv, sbgemm, sbgemmt, sbgemmtr, sbgemv, sbdot, sbstobf16, sbdtobf16, sbf16tos, dbf16tod);
@hfblasobjs = (shgemm, shgemv);
@cblasobjsc = (
    cblas_caxpy, cblas_ccopy, cblas_cdotc, cblas_cdotu, cblas_cgbmv, cblas_cgemm, cblas_cgemv,
    cblas_cgerc, cblas_cgeru, cblas_chbmv, cblas_chemm, cblas_chemv, cblas_cher2, cblas_cher2k,
    cblas_cher, cblas_cherk,  cblas_chpmv, cblas_chpr2, cblas_chpr, cblas_cscal, cblas_caxpby,
    cblas_csscal, cblas_cswap, cblas_csymm, cblas_csyr2k, cblas_csyrk, cblas_ctbmv, cblas_cgeadd,
    cblas_ctbsv, cblas_ctpmv, cblas_ctpsv, cblas_ctrmm, cblas_ctrmv, cblas_ctrsm, cblas_ctrsv, 
    cblas_scnrm2, cblas_scasum, cblas_cgemmt, cblas_cgemmtr,
    cblas_icamax, cblas_icamin, cblas_icmin, cblas_icmax, cblas_scsum,cblas_cimatcopy,cblas_comatcopy,
    cblas_caxpyc, cblas_crotg, cblas_csrot, cblas_scamax, cblas_scamin, cblas_cgemm_batch);

@cblasobjsd = (
    cblas_dasum, cblas_daxpy, cblas_dcopy, cblas_ddot,
    cblas_dgbmv, cblas_dgemm, cblas_dgemv, cblas_dger, cblas_dnrm2,
    cblas_drot, cblas_drotg, cblas_drotm, cblas_drotmg, cblas_dsbmv, cblas_dscal, cblas_dsdot,
    cblas_dspmv, cblas_dspr2, cblas_dspr, cblas_dswap, cblas_dsymm, cblas_dsymv, cblas_dsyr2,
    cblas_dsyr2k, cblas_dsyr, cblas_dsyrk, cblas_dtbmv, cblas_dtbsv, cblas_dtpmv, cblas_dtpsv,
    cblas_dtrmm, cblas_dtrmv, cblas_dtrsm, cblas_dtrsv, cblas_daxpby, cblas_dgeadd, cblas_dgemmt, cblas_dgemmtr,
    cblas_idamax, cblas_idamin, cblas_idmin, cblas_idmax, cblas_dsum,cblas_dimatcopy,cblas_domatcopy,
    cblas_damax, cblas_damin, cblas_dgemm_batch);
    
@cblasobjss = (
    cblas_sasum, cblas_saxpy, cblas_saxpby,
    cblas_scopy, cblas_sdot, cblas_sdsdot, cblas_sgbmv, cblas_sgemm,
    cblas_sgemv, cblas_sger, cblas_snrm2, cblas_srot, cblas_srotg,
    cblas_srotm, cblas_srotmg, cblas_ssbmv, cblas_sscal, cblas_sspmv, cblas_sspr2, cblas_sspr,
    cblas_sswap, cblas_ssymm, cblas_ssymv, cblas_ssyr2, cblas_ssyr2k, cblas_ssyr, cblas_ssyrk,
    cblas_stbmv, cblas_stbsv, cblas_stpmv, cblas_stpsv, cblas_strmm, cblas_strmv, cblas_strsm,
    cblas_strsv, cblas_sgeadd, cblas_sgemmt, cblas_sgemmtr,
    cblas_isamax, cblas_isamin, cblas_ismin, cblas_ismax, cblas_ssum,cblas_simatcopy,cblas_somatcopy,
    cblas_samax, cblas_samin, cblas_sgemm_batch);

@cblasobjsz = (
    cblas_dzasum, cblas_dznrm2, cblas_zaxpy, cblas_zcopy, cblas_zdotc, cblas_zdotu, cblas_zdscal,
    cblas_zgbmv, cblas_zgemm, cblas_zgemv, cblas_zgerc, cblas_zgeru, cblas_zhbmv, cblas_zhemm,
    cblas_zhemv, cblas_zher2, cblas_zher2k, cblas_zher, cblas_zherk, cblas_zhpmv, cblas_zhpr2,
    cblas_zhpr, cblas_zscal, cblas_zswap, cblas_zsymm, cblas_zsyr2k, cblas_zsyrk,
    cblas_ztbmv, cblas_ztbsv, cblas_ztpmv, cblas_ztpsv, cblas_ztrmm, cblas_ztrmv, cblas_ztrsm,
    cblas_ztrsv, cblas_cdotc_sub, cblas_cdotu_sub, cblas_zdotc_sub, cblas_zdotu_sub,
    cblas_zaxpby, cblas_zgeadd, cblas_zgemmt, cblas_zgemmtr,
    cblas_izamax, cblas_izamin, cblas_izmin, cblas_izmax, cblas_dzsum,cblas_zimatcopy,cblas_zomatcopy,
    cblas_zaxpyc, cblas_zdrot, cblas_zrotg, cblas_dzamax, cblas_dzamin, cblas_zgemm_batch);

@cblasobjs = (  cblas_xerbla );

@bfcblasobjs = (cblas_sbgemm, cblas_sbgemmt, cblas_sbgemmtr, cblas_sbgemv, cblas_sbdot, cblas_sbstobf16, cblas_sbdtobf16, cblas_sbf16tos, cblas_dbf16tod, cblas_sbgemm_batch);
@hfcblasobjs = (cblas_shgemm);
@exblasobjs = (
    qamax,qamin,qasum,qaxpy,qcabs1,qcopy,qdot,qgbmv,qgemm,
    qgemv,qger,qmax,qmin,
    qnrm2,
    qsbmv,qscal,qspmv,qspr2,
    qspr,qswap,qsymm,qsymv,qsyr2,qsyr2k,qsyr,qsyrk,qtbmv,qtbsv,
    qtpmv,qtpsv,qtrmm,qtrmv,qtrsm,qtrsv,
    qxamax,qxamin,qxasum,qxnrm2,
    xaxpy,xcopy,xdotc,xdotu,
    xqscal,xgbmv,xgemm,xgemv,xgerc,xgeru,
    xhbmv,xhemm,xhemv,xher2,xher2k,xher,xherk,xhpmv,xhpr2,
    xhpr,xscal,xswap,xsymm,xsyr2k,xsyrk,xtbmv,
    xtbsv,xtpmv,xtpsv,xtrmm,xtrmv,xtrsm,xtrsv,
#	     qrot,qrotg,qrotm,qrotmg,
#	     xdrot,xrotg,
);

    @gemm3mobjs=();

    @cblasgemm3mobjs=();

@gemm3mobjsc = (
    cgemm3m,
);
@gemm3mobjsz = (    
    zgemm3m
);

@cblasgemm3mobjsc = (
    cblas_cgemm3m
);
@cblasgemm3mobjsz = (
    cblas_zgemm3m
);




#both underscore and no underscore
@misc_common_objs = (
    openblas_get_parallel,
    openblas_get_num_procs,
    openblas_set_num_threads,
    openblas_get_num_threads,
);

@misc_no_underscore_objs = (
    goto_set_num_threads,
    openblas_get_config,
    openblas_get_corename,
    openblas_set_threads_callback_function,
);

@misc_underscore_objs = (
);

@lapackobjss = (
    # These routines are provided by OpenBLAS.
    sgesv, 
    sgetf2,
    sgetrf,
    slaswp,
    sgetrs,
    slauu2,
    slauum,
    spotf2,
    spotrf,
    strti2,
    strtri,
    spotri,
);

@lapackobjsd = (
 dgesv,  
 dgetf2, 
 dgetrf, 
 dlaswp, 
 dgetrs, 
 dlauu2, 
 dlauum, 
 dpotf2, 
 dpotrf, 
 dtrti2, 
 dtrtri, 
 dpotri, 
);

@lapackobjsc = (
cgesv,  
cgetf2, 
cgetrf, 
claswp, 
cgetrs, 
clauu2, 
clauum, 
cpotf2, 
cpotrf, 
ctrti2, 
ctrtri, 
cpotri, 
);

@lapackobjsz = (
zgesv,
zgetf2,
zgetrf,
zlaswp,
zgetrs,
zlauu2,
zlauum,
zpotf2,
zpotrf,
ztrti2,
ztrtri,
zpotri,
);


@lapackobjs2 = (
    # These routines are provided by LAPACK (reference implementation).
    #
    # This list is prepared by copying all routines listed in
    # `lapack-3.4.1/SRC/Makefile` and replacing the '.o' suffix with a comma.
    # Thereafter the following routines should be removed:
    # - those provided by OpenBLAS (see @lapackobjs)
    # - extra precision routines (see @lapack_extendedprecision_objs)
    # Each of these have been marked individually with "already provided" or "excluded".

    # ALLAUX  -- Auxiliary routines called from all precisions
    # already provided by @blasobjs: xerbla, lsame
    ilaenv, ieeeck, lsamen,  iparmq,
    ilaprec, ilatrans, ilauplo, iladiag,
    ilaver, slamch, slamc3,
);

@lapackobjs2sc = (    
    # SCLAUX  -- Auxiliary routines called from both REAL and COMPLEX.
    # excluded: second_$(TIMER)
    sbdsdc,
    sbdsqr, sdisna, slabad, slacpy, sladiv, slae2,  slaebz,
    slaed0, slaed1, slaed2, slaed3, slaed4, slaed5, slaed6,
    slaed7, slaed8, slaed9, slaeda, slaev2, slagtf,
    slagts, slamrg, slanst,
    slapy2, slapy3, slarnv,
    slarra, slarrb, slarrc, slarrd, slarre, slarrf, slarrj,
    slarrk, slarrr, slaneg,
    slartg, slaruv, slas2,  slascl,
    slasd0, slasd1, slasd2, slasd3, slasd4, slasd5, slasd6,
    slasd7, slasd8, slasda, slasdq, slasdt,
    slaset, slasq1, slasq2, slasq3, slasq4, slasq5, slasq6,
    slasr,  slasrt, slassq, slasv2, spttrf, sstebz, sstedc,
    ssteqr, ssterf, slaisnan, sisnan,
    slartgp, slartgs,
);

@lapackobjs2dz = (
    # DZLAUX  -- Auxiliary routines called from both DOUBLE and COMPLEX*16.
    # excluded: dsecnd_$(TIMER)
    dbdsdc,
    dbdsqr, ddisna, dlabad, dlacpy, dladiv, dlae2,  dlaebz,
    dlaed0, dlaed1, dlaed2, dlaed3, dlaed4, dlaed5, dlaed6,
    dlaed7, dlaed8, dlaed9, dlaeda, dlaev2, dlagtf,
    dlagts, dlamrg, dlanst,
    dlapy2, dlapy3, dlarnv,
    dlarra, dlarrb, dlarrc, dlarrd, dlarre, dlarrf, dlarrj,
    dlarrk, dlarrr, dlaneg,
    dlartg, dlaruv, dlas2,  dlascl,
    dlasd0, dlasd1, dlasd2, dlasd3, dlasd4, dlasd5, dlasd6,
    dlasd7, dlasd8, dlasda, dlasdq, dlasdt,
    dlaset, dlasq1, dlasq2, dlasq3, dlasq4, dlasq5, dlasq6,
    dlasr,  dlasrt, dlassq, dlasv2, dpttrf, dstebz, dstedc,
    dsteqr, dsterf, dlaisnan, disnan,
    dlartgp, dlartgs,
    dlamch, dlamc3,
);

@lapackobjs2s = (
    # SLASRC  -- Single precision real LAPACK routines
    # already provided by @lapackobjs:
    #     sgesv, sgetf2, slaswp, slauu2, slauum, spotf2, spotri, strti2, strtri
    sgbbrd, sgbcon, sgbequ, sgbrfs, sgbsv,
    sgbsvx, sgbtf2, sgbtrf, sgbtrs, sgebak, sgebal, sgebd2,
    sgebrd, sgecon, sgeequ, sgees,  sgeesx, sgeev,  sgeevx,
    sgehd2, sgehrd, sgelq2, sgelqf,
    sgels,  sgelsd, sgelss, sgelsy, sgeql2, sgeqlf,
    sgeqp3, sgeqr2, sgeqr2p, sgeqrf, sgeqrfp, sgerfs,
    sgerq2, sgerqf, sgesc2, sgesdd, sgesvd, sgesvx,
    sgetc2, sgetri,
    sggbak, sggbal, sgges,  sggesx, sggev,  sggevx,
    sggglm, sgghrd, sgglse, sggqrf,
    sggrqf, sgtcon, sgtrfs, sgtsv,
    sgtsvx, sgttrf, sgttrs, sgtts2, shgeqz,
    shsein, shseqr, slabrd, slacon, slacn2,
    slaein, slaexc, slag2,  slags2, slagtm, slagv2, slahqr,
    slahr2, slaic1, slaln2, slals0, slalsa, slalsd,
    slangb, slange, slangt, slanhs, slansb, slansp,
    slansy, slantb, slantp, slantr, slanv2,
    slapll, slapmt,
    slaqgb, slaqge, slaqp2, slaqps, slaqsb, slaqsp, slaqsy,
    slaqr0, slaqr1, slaqr2, slaqr3, slaqr4, slaqr5,
    slaqtr, slar1v, slar2v, ilaslr, ilaslc,
    slarf,  slarfb, slarfg, slarfgp, slarft, slarfx, slargv,
    slarrv, slartv,
    slarz,  slarzb, slarzt, slasy2, slasyf,
    slatbs, slatdf, slatps, slatrd, slatrs, slatrz,
    sopgtr, sopmtr, sorg2l, sorg2r,
    sorgbr, sorghr, sorgl2, sorglq, sorgql, sorgqr, sorgr2,
    sorgrq, sorgtr, sorm2l, sorm2r,
    sormbr, sormhr, sorml2, sormlq, sormql, sormqr, sormr2,
    sormr3, sormrq, sormrz, sormtr, spbcon, spbequ, spbrfs,
    spbstf, spbsv,  spbsvx,
    spbtf2, spbtrf, spbtrs, spocon, spoequ, sporfs, sposv,
    sposvx, spstrf, spstf2,
    sppcon, sppequ,
    spprfs, sppsv,  sppsvx, spptrf, spptri, spptrs, sptcon,
    spteqr, sptrfs, sptsv,  sptsvx, spttrs, sptts2, srscl,
    ssbev,  ssbevd, ssbevx, ssbgst, ssbgv,  ssbgvd, ssbgvx,
    ssbtrd, sspcon, sspev,  sspevd, sspevx, sspgst,
    sspgv,  sspgvd, sspgvx, ssprfs, sspsv,  sspsvx, ssptrd,
    ssptrf, ssptri, ssptrs, sstegr, sstein, sstev,  sstevd, sstevr,
    sstevx,
    ssycon, ssyev,  ssyevd, ssyevr, ssyevx, ssygs2,
    ssygst, ssygv,  ssygvd, ssygvx, ssyrfs, ssysv,  ssysvx,
    ssytd2, ssytf2, ssytrd, ssytrf, ssytri, ssytri2, ssytri2x,
    ssyswapr, ssytrs, ssytrs2, ssyconv,
    stbcon,
    stbrfs, stbtrs, stgevc, stgex2, stgexc, stgsen,
    stgsja, stgsna, stgsy2, stgsyl, stpcon, stprfs, stptri,
    stptrs,
    strcon, strevc, strexc, strrfs, strsen, strsna, strsyl,
    strtrs, stzrzf, sstemr,
    slansf, spftrf, spftri, spftrs, ssfrk, stfsm, stftri, stfttp,
    stfttr, stpttf, stpttr, strttf, strttp,
    sgejsv,  sgesvj,  sgsvj0,  sgsvj1,
    sgeequb, ssyequb, spoequb, sgbequb,
    sbbcsd, slapmr, sorbdb, sorbdb1, sorbdb2, sorbdb3, sorbdb4,
    sorbdb5, sorbdb6, sorcsd, sorcsd2by1,
    sgeqrt, sgeqrt2, sgeqrt3, sgemqrt,
    stpqrt, stpqrt2, stpmqrt, stprfb,
);

@lapackobjs2ds = (
    # DSLASRC -- Double-single mixed precision real routines called from
    # single, single-extra and double precision real LAPACK
    # routines (i.e. from SLASRC, SXLASRC, DLASRC).
    #
    # already provided by @lapackobjs:
    #     sgetrs, spotrf, sgetrf
    spotrs,
);

@lapackobjs2c = (
    # CLASRC  -- Single precision complex LAPACK routines
    # already provided by @blasobjs:
    # already provided by @lapackobjs:
    #     cgesv, cgetf2, claswp, clauu2, clauum, cpotf2, cpotri, ctrti2, ctrtri
    cbdsqr, cgbbrd, cgbcon, cgbequ, cgbrfs, cgbsv,  cgbsvx,
    cgbtf2, cgbtrf, cgbtrs, cgebak, cgebal, cgebd2, cgebrd,
    cgecon, cgeequ, cgees,  cgeesx, cgeev,  cgeevx,
    cgehd2, cgehrd, cgelq2, cgelqf,
    cgels,  cgelsd, cgelss, cgelsy, cgeql2, cgeqlf, cgeqp3,
    cgeqr2, cgeqr2p, cgeqrf, cgeqrfp, cgerfs,
    cgerq2, cgerqf, cgesc2, cgesdd, cgesvd,
    cgesvx, cgetc2, cgetri,
    cggbak, cggbal, cgges,  cggesx, cggev,  cggevx, cggglm,
    cgghrd, cgglse, cggqrf, cggrqf,
    cgtcon, cgtrfs, cgtsv,  cgtsvx, cgttrf, cgttrs, cgtts2, chbev,
    chbevd, chbevx, chbgst, chbgv,  chbgvd, chbgvx, chbtrd,
    checon, cheev,  cheevd, cheevr, cheevx, chegs2, chegst,
    chegv,  chegvd, chegvx, cherfs, chesv,  chesvx, chetd2,
    chetf2, chetrd,
    chetrf, chetri, chetri2, chetri2x, cheswapr,
    chetrs, chetrs2, chgeqz, chpcon, chpev,  chpevd,
    chpevx, chpgst, chpgv,  chpgvd, chpgvx, chprfs, chpsv,
    chpsvx,
    chptrd, chptrf, chptri, chptrs, chsein, chseqr, clabrd,
    clacgv, clacon, clacn2, clacp2, clacpy, clacrm, clacrt, cladiv,
    claed0, claed7, claed8,
    claein, claesy, claev2, clags2, clagtm,
    clahef, clahqr,
    clahr2, claic1, clals0, clalsa, clalsd, clangb, clange, clangt,
    clanhb, clanhe,
    clanhp, clanhs, clanht, clansb, clansp, clansy, clantb,
    clantp, clantr, clapll, clapmt, clarcm, claqgb, claqge,
    claqhb, claqhe, claqhp, claqp2, claqps, claqsb,
    claqr0, claqr1, claqr2, claqr3, claqr4, claqr5,
    claqsp, claqsy, clar1v, clar2v, ilaclr, ilaclc,
    clarf,  clarfb, clarfg, clarft, clarfgp,
    clarfx, clargv, clarnv, clarrv, clartg, clartv,
    clarz,  clarzb, clarzt, clascl, claset, clasr,  classq,
    clasyf, clatbs, clatdf, clatps, clatrd, clatrs, clatrz,
    cpbcon, cpbequ, cpbrfs, cpbstf, cpbsv,
    cpbsvx, cpbtf2, cpbtrf, cpbtrs, cpocon, cpoequ, cporfs,
    cposv,  cposvx, cpstrf, cpstf2,
    cppcon, cppequ, cpprfs, cppsv,  cppsvx, cpptrf, cpptri, cpptrs,
    cptcon, cpteqr, cptrfs, cptsv,  cptsvx, cpttrf, cpttrs, cptts2,
    crot,   cspcon, cspmv,  cspr,   csprfs, cspsv,
    cspsvx, csptrf, csptri, csptrs, csrscl, cstedc,
    cstegr, cstein, csteqr,
    csycon,
    csymv,
    csyr, csyrfs, csysv,  csysvx, csytf2, csytrf, csytri, csytri2, csytri2x,
    csyswapr, csytrs, csytrs2, csyconv,
    ctbcon, ctbrfs, ctbtrs, ctgevc, ctgex2,
    ctgexc, ctgsen, ctgsja, ctgsna, ctgsy2, ctgsyl, ctpcon,
    ctprfs, ctptri,
    ctptrs, ctrcon, ctrevc, ctrexc, ctrrfs, ctrsen, ctrsna,
    ctrsyl, ctrtrs, ctzrzf, cung2l, cung2r,
    cungbr, cunghr, cungl2, cunglq, cungql, cungqr, cungr2,
    cungrq, cungtr, cunm2l, cunm2r, cunmbr, cunmhr, cunml2,
    cunmlq, cunmql, cunmqr, cunmr2, cunmr3, cunmrq, cunmrz,
    cunmtr, cupgtr, cupmtr, icmax1, scsum1, cstemr,
    chfrk, ctfttp, clanhf, cpftrf, cpftri, cpftrs, ctfsm, ctftri,
    ctfttr, ctpttf, ctpttr, ctrttf, ctrttp,
    cgeequb, cgbequb, csyequb, cpoequb, cheequb,
    cbbcsd, clapmr, cunbdb, cunbdb1, cunbdb2, cunbdb3, cunbdb4,
    cunbdb5, cunbdb6, cuncsd, cuncsd2by1,
    cgeqrt, cgeqrt2, cgeqrt3, cgemqrt,
    ctpqrt, ctpqrt2, ctpmqrt, ctprfb,
);
@lapackobjs2zc = (
    # ZCLASRC -- Double-single mixed precision complex routines called from
    # single, single-extra and double precision complex LAPACK
    # routines (i.e. from CLASRC, CXLASRC, ZLASRC).
    #
    # already provided by @lapackobjs:
    #     cgetrs, cpotrf, cgetrf
    cpotrs,
);

@lapackobjs2d = (
    # DLASRC  -- Double precision real LAPACK routines
    # already provided by @lapackobjs:
    #     dgesv, dgetf2, dgetrs, dlaswp, dlauu2, dlauum, dpotf2, dpotrf, dpotri,
    #     dtrti2, dtrtri
    dgbbrd, dgbcon, dgbequ, dgbrfs, dgbsv,
    dgbsvx, dgbtf2, dgbtrf, dgbtrs, dgebak, dgebal, dgebd2,
    dgebrd, dgecon, dgeequ, dgees,  dgeesx, dgeev,  dgeevx,
    dgehd2, dgehrd, dgelq2, dgelqf,
    dgels,  dgelsd, dgelss, dgelsy, dgeql2, dgeqlf,
    dgeqp3, dgeqr2, dgeqr2p, dgeqrf, dgeqrfp, dgerfs,
    dgerq2, dgerqf, dgesc2, dgesdd, dgesvd, dgesvx,
    dgetc2, dgetri,
    dggbak, dggbal, dgges,  dggesx, dggev,  dggevx,
    dggglm, dgghrd, dgglse, dggqrf,
    dggrqf, dgtcon, dgtrfs, dgtsv,
    dgtsvx, dgttrf, dgttrs, dgtts2, dhgeqz,
    dhsein, dhseqr, dlabrd, dlacon, dlacn2,
    dlaein, dlaexc, dlag2,  dlags2, dlagtm, dlagv2, dlahqr,
    dlahr2, dlaic1, dlaln2, dlals0, dlalsa, dlalsd,
    dlangb, dlange, dlangt, dlanhs, dlansb, dlansp,
    dlansy, dlantb, dlantp, dlantr, dlanv2,
    dlapll, dlapmt,
    dlaqgb, dlaqge, dlaqp2, dlaqps, dlaqsb, dlaqsp, dlaqsy,
    dlaqr0, dlaqr1, dlaqr2, dlaqr3, dlaqr4, dlaqr5,
    dlaqtr, dlar1v, dlar2v, iladlr, iladlc,
    dlarf,  dlarfb, dlarfg, dlarfgp, dlarft, dlarfx,
    dlargv, dlarrv, dlartv,
    dlarz,  dlarzb, dlarzt, dlasy2, dlasyf,
    dlatbs, dlatdf, dlatps, dlatrd, dlatrs, dlatrz,
    dopgtr, dopmtr, dorg2l, dorg2r,
    dorgbr, dorghr, dorgl2, dorglq, dorgql, dorgqr, dorgr2,
    dorgrq, dorgtr, dorm2l, dorm2r,
    dormbr, dormhr, dorml2, dormlq, dormql, dormqr, dormr2,
    dormr3, dormrq, dormrz, dormtr, dpbcon, dpbequ, dpbrfs,
    dpbstf, dpbsv,  dpbsvx,
    dpbtf2, dpbtrf, dpbtrs, dpocon, dpoequ, dporfs, dposv,
    dposvx, dpotrs, dpstrf, dpstf2,
    dppcon, dppequ,
    dpprfs, dppsv,  dppsvx, dpptrf, dpptri, dpptrs, dptcon,
    dpteqr, dptrfs, dptsv,  dptsvx, dpttrs, dptts2, drscl,
    dsbev,  dsbevd, dsbevx, dsbgst, dsbgv,  dsbgvd, dsbgvx,
    dsbtrd,  dspcon, dspev,  dspevd, dspevx, dspgst,
    dspgv,  dspgvd, dspgvx, dsprfs, dspsv,  dspsvx, dsptrd,
    dsptrf, dsptri, dsptrs, dstegr, dstein, dstev,  dstevd, dstevr,
    dstevx,
    dsycon, dsyev,  dsyevd, dsyevr,
    dsyevx, dsygs2, dsygst, dsygv,  dsygvd, dsygvx, dsyrfs,
    dsysv,  dsysvx,
    dsytd2, dsytf2, dsytrd, dsytrf, dsytri, dsytri2, dsytri2x,
    dsyswapr, dsytrs, dsytrs2, dsyconv,
    dtbcon, dtbrfs, dtbtrs, dtgevc, dtgex2, dtgexc, dtgsen,
    dtgsja, dtgsna, dtgsy2, dtgsyl, dtpcon, dtprfs, dtptri,
    dtptrs,
    dtrcon, dtrevc, dtrexc, dtrrfs, dtrsen, dtrsna, dtrsyl,
    dtrtrs, dtzrzf, dstemr,
    dsgesv, dsposv, dlag2s, slag2d, dlat2s,
    dlansf, dpftrf, dpftri, dpftrs, dsfrk, dtfsm, dtftri, dtfttp,
    dtfttr, dtpttf, dtpttr, dtrttf, dtrttp,
    dgejsv,  dgesvj,  dgsvj0,  dgsvj1,
    dgeequb, dsyequb, dpoequb, dgbequb,
    dbbcsd, dlapmr, dorbdb, dorbdb1, dorbdb2, dorbdb3, dorbdb4,
    dorbdb5, dorbdb6, dorcsd, dorcsd2by1,
    dgeqrt, dgeqrt2, dgeqrt3, dgemqrt,
    dtpqrt, dtpqrt2, dtpmqrt, dtprfb,
);
@lapackobjs2z = (
    # ZLASRC  -- Double precision complex LAPACK routines
    # already provided by @blasobjs:
    # already provided by @lapackobjs:
    #     zgesv, zgetrs, zgetf2, zlaswp, zlauu2, zlauum, zpotf2, zpotrf, zpotri,
    #     ztrti2, ztrtri
    zbdsqr, zgbbrd, zgbcon, zgbequ, zgbrfs, zgbsv,  zgbsvx,
    zgbtf2, zgbtrf, zgbtrs, zgebak, zgebal, zgebd2, zgebrd,
    zgecon, zgeequ, zgees,  zgeesx, zgeev,  zgeevx,
    zgehd2, zgehrd, zgelq2, zgelqf,
    zgels,  zgelsd, zgelss, zgelsy, zgeql2, zgeqlf, zgeqp3,
    zgeqr2, zgeqr2p, zgeqrf, zgeqrfp, zgerfs, zgerq2, zgerqf,
    zgesc2, zgesdd, zgesvd, zgesvx, zgetc2,
    zgetri,
    zggbak, zggbal, zgges,  zggesx, zggev,  zggevx, zggglm,
    zgghrd, zgglse, zggqrf, zggrqf,
    zgtcon, zgtrfs, zgtsv,  zgtsvx, zgttrf, zgttrs, zgtts2, zhbev,
    zhbevd, zhbevx, zhbgst, zhbgv,  zhbgvd, zhbgvx, zhbtrd,
    zhecon, zheev,  zheevd, zheevr, zheevx, zhegs2, zhegst,
    zhegv,  zhegvd, zhegvx, zherfs, zhesv,  zhesvx, zhetd2,
    zhetf2, zhetrd,
    zhetrf, zhetri, zhetri2, zhetri2x, zheswapr,
    zhetrs, zhetrs2, zhgeqz, zhpcon, zhpev,  zhpevd,
    zhpevx, zhpgst, zhpgv,  zhpgvd, zhpgvx, zhprfs, zhpsv,
    zhpsvx,
    zhptrd, zhptrf, zhptri, zhptrs, zhsein, zhseqr, zlabrd,
    zlacgv, zlacon, zlacn2, zlacp2, zlacpy, zlacrm, zlacrt, zladiv,
    zlaed0, zlaed7, zlaed8,
    zlaein, zlaesy, zlaev2, zlags2, zlagtm,
    zlahef, zlahqr,
    zlahr2, zlaic1, zlals0, zlalsa, zlalsd, zlangb, zlange,
    zlangt, zlanhb,
    zlanhe,
    zlanhp, zlanhs, zlanht, zlansb, zlansp, zlansy, zlantb,
    zlantp, zlantr, zlapll, zlapmt, zlaqgb, zlaqge,
    zlaqhb, zlaqhe, zlaqhp, zlaqp2, zlaqps, zlaqsb,
    zlaqr0, zlaqr1, zlaqr2, zlaqr3, zlaqr4, zlaqr5,
    zlaqsp, zlaqsy, zlar1v, zlar2v, ilazlr, ilazlc,
    zlarcm, zlarf,  zlarfb,
    zlarfg, zlarft, zlarfgp,
    zlarfx, zlargv, zlarnv, zlarrv, zlartg, zlartv,
    zlarz,  zlarzb, zlarzt, zlascl, zlaset, zlasr,
    zlassq, zlasyf,
    zlatbs, zlatdf, zlatps, zlatrd, zlatrs, zlatrz,
    zpbcon, zpbequ, zpbrfs, zpbstf, zpbsv,
    zpbsvx, zpbtf2, zpbtrf, zpbtrs, zpocon, zpoequ, zporfs,
    zposv,  zposvx, zpotrs, zpstrf, zpstf2,
    zppcon, zppequ, zpprfs, zppsv,  zppsvx, zpptrf, zpptri, zpptrs,
    zptcon, zpteqr, zptrfs, zptsv,  zptsvx, zpttrf, zpttrs, zptts2,
    zrot,   zspcon, zspmv,  zspr,   zsprfs, zspsv,
    zspsvx, zsptrf, zsptri, zsptrs, zdrscl, zstedc,
    zstegr, zstein, zsteqr,
    zsycon,
    zsymv,
    zsyr, zsyrfs, zsysv,  zsysvx, zsytf2, zsytrf, zsytri, zsytri2, zsytri2x,
    zsyswapr, zsytrs, zsytrs2, zsyconv,
    ztbcon, ztbrfs, ztbtrs, ztgevc, ztgex2,
    ztgexc, ztgsen, ztgsja, ztgsna, ztgsy2, ztgsyl, ztpcon,
    ztprfs, ztptri,
    ztptrs, ztrcon, ztrevc, ztrexc, ztrrfs, ztrsen, ztrsna,
    ztrsyl, ztrtrs, ztzrzf, zung2l,
    zung2r, zungbr, zunghr, zungl2, zunglq, zungql, zungqr, zungr2,
    zungrq, zungtr, zunm2l, zunm2r, zunmbr, zunmhr, zunml2,
    zunmlq, zunmql, zunmqr, zunmr2, zunmr3, zunmrq, zunmrz,
    zunmtr, zupgtr,
    zupmtr, izmax1, dzsum1, zstemr,
    zcgesv, zcposv, zlag2c, clag2z, zlat2c,
    zhfrk, ztfttp, zlanhf, zpftrf, zpftri, zpftrs, ztfsm, ztftri,
    ztfttr, ztpttf, ztpttr, ztrttf, ztrttp,
    zgeequb, zgbequb, zsyequb, zpoequb, zheequb,
    zbbcsd, zlapmr, zunbdb, zunbdb1, zunbdb2, zunbdb3, zunbdb4,
    zunbdb5, zunbdb6, zuncsd, zuncsd2by1,
    zgeqrt, zgeqrt2, zgeqrt3, zgemqrt,
    ztpqrt, ztpqrt2, ztpmqrt, ztprfb,
);
    # functions added for lapack-3.6.0

@lapackobjs2c = ( @lapackobjs2c,
    cgejsv,
    cgesvdx,
    cgesvj,
    cgetrf2,
    cgges3,
    cggev3,
    cgghd3,
    cggsvd3,
    cggsvp3,
    cgsvj0,
    cgsvj1,
    clagge,
    claghe,
    clagsy,
    clahilb,
    clakf2,
    clarge,
    clarnd,
    claror,
    clarot,
    clatm1,
    clatm2,
    clatm3,
    clatm5,
    clatm6,
    clatme,
    clatmr,
    clatms,
    clatmt,
    cpotrf2,
    csbmv,
    cspr2,
    csyr2,
    cunm22,
);
@lapackobjs2d = (@lapackobjs2d,
    dbdsvdx,
    dgesvdx,
    dgetrf2,
    dgges3,
    dggev3,
    dgghd3,
    dggsvd3,
    dggsvp3,
    dladiv2,
    dlagge,
    dlagsy,
    dlahilb,
    dlakf2,
    dlaran,
    dlarge,
    dlarnd,
    dlaror,
    dlarot,
    dlatm1,
    dlatm2,
    dlatm3,
    dlatm5,
    dlatm6,
    dlatm7,
    dlatme,
    dlatmr,
    dlatms,
    dlatmt,
    dorm22,
    dpotrf2,
    dsecnd,
    );
    @lapackobjs2s = (@lapackobjs2s,
    sbdsvdx,
    second,
    sgesvdx,
    sgetrf2,
    sgges3,
    sggev3,
    sgghd3,
    sggsvd3,
    sggsvp3,
    sladiv2,
    slagge,
    slagsy,
    slahilb,
    slakf2,
    slaran,
    slarge,
    slarnd,
    slaror,
    slarot,
    slatm1,
    slatm2,
    slatm3,
    slatm5,
    slatm6,
    slatm7,
    slatme,
    slatmr,
    slatms,
    slatmt,
    sorm22,
    spotrf2,
    );
    @lapackobjs2z = (@lapackobjs2z,
    zgejsv,
    zgesvdx,
    zgesvj,
    zgetrf2,
    zgges3,
    zggev3,
    zgghd3,
    zggsvd3,
    zggsvp3,
    zgsvj0,
    zgsvj1,
    zlagge,
    zlaghe,
    zlagsy,
    zlahilb,
    zlakf2,
    zlarge,
    zlarnd,
    zlaror,
    zlarot,
    zlatm1,
    zlatm2,
    zlatm3,
    zlatm5,
    zlatm6,
    zlatme,
    zlatmr,
    zlatms,
    zlatmt,
    zpotrf2,
    zsbmv,
    zspr2,
    zsyr2,
    zunm22,
);
    # functions added for lapack-3.7.0
@lapackobjs2s = (@lapackobjs2s,
    slarfy,
    ssyconvf,
    strevc3,
    sgelqt,
    sgelqt3,
    sgemlqt,
    sgetsls,
    sgeqr,
    slatsqr,
    slamtsqr,
    sgemqr,
    sgelq,
    slaswlq,
    slamswlq,
    sgemlq,
    stplqt,
    stplqt2,
    stpmlqt,
    );
    @lapackobjs2d = (@lapackobjs2d,
    dlarfy,
    dsyconvf,
    dtrevc3,
    dgelqt,
    dgelqt3,
    dgemlqt,
    dgetsls,
    dgeqr,
    dlatsqr,
    dlamtsqr,
    dgemqr,
    dgelq,
    dlaswlq,
    dlamswlq,
    dgemlq,
    dtplqt,
    dtplqt2,
    dtpmlqt,
    );
    @lapackobjs2c = (@lapackobjs2c,
    clarfy,
    csyconvf,
    ctrevc3,
    cgelqt,
    cgelqt3,
    cgemlqt,
    cgetsls,
    cgeqr,
    clatsqr,
    clamtsqr,
    cgemqr,
    cgelq,
    claswlq,
    clamswlq,
    cgemlq,
    ctplqt,
    ctplqt2,
    ctpmlqt,
    );
    @lapackobjs2z = (@lapackobjs2z,
    zlarfy,
    zsyconvf,
    ztrevc3,
    ztplqt,
    ztplqt2,
    ztpmlqt,
    zgelqt,
    zgelqt3,
    zgemlqt,
    zgetsls,
    zgeqr,
    zlatsqr,
    zlamtsqr,
    zgemqr,
    zgelq,
    zlaswlq,
    zlamswlq,
    zgemlq,
    );
    @lapackobjs2s = (@lapackobjs2s,
    sladiv1);
    @lapackobjs2d = (@lapackobjs2d,
    dladiv1);
    @lapackobjs = (@lapackobjs,
    iparam2stage,
    # functions added for lapack-3.8.0
    ilaenv2stage,
    );
    # functions added for lapack-3.9.0
@lapackobjs2c = (@lapackobjs2c,
    cgesvdq,
    cungtsqr
    );
@lapackobjs2d = (@lapackobjs2d,
    dcombssq,
    dgesvdq,
    dorgtsqr,
    );
@lapackobjs2s = (@lapackobjs2s,
    scombssq,
    sgesvdq,
    sorgtsqr,
    );
@lapackobjs2z = (@lapackobjs2z,
    zgesvdq,
    zungtsqr
);
    #functions added for lapack-3.10
@lapackobjs2c = (@lapackobjs2c,
    cgetsqrhrt,
    cungtsqr_row
    );
@lapackobjs2d = (@lapackobjs2d,
    dgetsqrhrt,
    dorgtsqr_row
    );
@lapackobjs2s = (@lapackobjs2s,
    sgetsqrhrt,
    sorgtsqr_row
    );
@lapackobjs2z = (@lapackobjs2z,
    zgetsqrhrt,
    zungtsqr_row
    );

#functions added for lapack-3.11
@lapackobjs2c = (@lapackobjs2c,
    cgedmd,
    cgedmdq
    );
@lapackobjs2d = (@lapackobjs2d,
    dgedmd,
    dgedmdq
    );
@lapackobjs2s = (@lapackobjs2s,
    sgedmd,
    sgedmdq
    );
@lapackobjs2z = (@lapackobjs2z,
    zgedmd,
    zgedmdq
    );

#functions added post 3.11

@lapackobjs2c = (@lapackobjs2c,
    cgelst,
    cgeqp3rk,
    claqp2rk,
    claqp3rk,
    clatrs3,
    crscl,
    ctrsyl3
    );
#    claqz0
#    claqz1
#    claqz2
#    claqz3
#    clatrs3

@lapackobjs2d = (@lapackobjs2d,
    dgelst,
    dgeqp3rk,
    dlaqp2rk,
    dlaqp3rk,
    dlarmm,
    dlatrs3,
    dtrsyl3
    );

@lapackobjs2s = (@lapackobjs2s,
    sgelst,
    sgeqp3rk,
    slaqp2rk,
    slaqp3rk,
    slarmm,
    slatrs3,
    strsyl3
    );

@lapackobjs2z = (@lapackobjs2z,
    zgelst,
    zgeqp3rk,
    zlaqp2rk,
    zlaqp3rk,
    zlatrs3,
    zrscl,
    ztrsyl3
    );
#    zlaqz0
#    zlaqz1
#    zlaqz2
#    zlaqz3

@lapack_extendedprecision_objs = (
    zposvxx, clagge, clatms, chesvxx, cposvxx, cgesvxx, ssyrfssx, csyrfsx,
    dlagsy, dsysvxx, sporfsx, slatms, zlatms, zherfsx, csysvxx,
);

@lapack_deprecated_objsc = (
    cgelqs,  cgeqrs,
    cgegs,   cggsvd,  
    cgegv,   cggsvp,  
    cgelsx,  clahrd,  
    cgeqpf,  clatzm,  
    ctzrqf,
    );
@lapack_deprecated_objsd = (
    dgelqs,  dgeqrs,
    dgegs,   dgeqpf,
    dgegv,   dggsvd,
    dgelsx,  dggsvp,
             dlahrd,
  dlatzm,  dtzrqf);
  
@lapack_deprecated_objss = (
  sgelqs,
  sgeqrs,
  sgelsx,
  sgegs,
  sgegv,
  sgeqpf,
  sggsvd,
  sggsvp,
  slahrd,
  slatzm,
  stzrqf
  );

@lapack_deprecated_objsz = ( 
  zgelqs,
  zgeqrs,
  zgegs,
  zgegv,
  zgelsx,
  zgeqpf,
  zggsvd,
  zggsvp,
  zlahrd,
  zlatzm,
  ztzrqf
  );

@lapacke_deprecated_objsc = (
    LAPACKE_cggsvp,
    LAPACKE_cggsvp_work,
    LAPACKE_cggsvd,
    LAPACKE_cggsvd_work,
    LAPACKE_cgeqpf,
    LAPACKE_cgeqpf_work,
);  
@lapacke_deprecated_objsd = (    
    LAPACKE_dggsvp,
    LAPACKE_dggsvp_work,
    LAPACKE_dggsvd,
    LAPACKE_dggsvd_work,
    LAPACKE_dgeqpf,
    LAPACKE_dgeqpf_work,
);    
@lapacke_deprecated_objss = (    
    LAPACKE_sggsvp,
    LAPACKE_sggsvp_work,
    LAPACKE_sggsvd,
    LAPACKE_sggsvd_work,
    LAPACKE_sgeqpf,
    LAPACKE_sgeqpf_work,
);    
@lapacke_deprecated_objsz = (    
    LAPACKE_zggsvp,
    LAPACKE_zggsvp_work,
    LAPACKE_zggsvd,
    LAPACKE_zggsvd_work,
    LAPACKE_zgeqpf,
    LAPACKE_zgeqpf_work,
);


@lapackeobjs = (
    # LAPACK C interface routines.
    #
    # This list is prepared in a similar manner to @lapackobjs2, however the
    # functions all begin with an uppercase prefix (with the exception of the
    # make_complex_* routines).
    #
    # The functions corresponding to @(MATGEN_OBJ) and @(SRCX_OBJ) are not
    # exported since the respective LAPACK routines are not built by default.

    # @(OBJ) from `lapack-3.4.1/lapacke/utils/Makefile`
    LAPACKE_lsame,
    LAPACKE_ilaver,
    LAPACKE_xerbla,
    lapack_make_complex_float,
    lapack_make_complex_double,
    LAPACKE_get_nancheck,
    LAPACKE_set_nancheck,
);
@lapackeobjsc = (
    LAPACKE_cgb_nancheck,
    LAPACKE_cgb_trans,
    LAPACKE_cge_nancheck,
    LAPACKE_cge_trans,
    LAPACKE_cgg_nancheck,
    LAPACKE_cgg_trans,
    LAPACKE_cgt_nancheck,
    LAPACKE_chb_nancheck,
    LAPACKE_chb_trans,
    LAPACKE_che_nancheck,
    LAPACKE_che_trans,
    LAPACKE_chp_nancheck,
    LAPACKE_chp_trans,
    LAPACKE_chs_nancheck,
    LAPACKE_chs_trans,
    LAPACKE_c_nancheck,
    LAPACKE_cpb_nancheck,
    LAPACKE_cpb_trans,
    LAPACKE_cpf_nancheck,
    LAPACKE_cpf_trans,
    LAPACKE_cpo_nancheck,
    LAPACKE_cpo_trans,
    LAPACKE_cpp_nancheck,
    LAPACKE_cpp_trans,
    LAPACKE_cpt_nancheck,
    LAPACKE_csp_nancheck,
    LAPACKE_csp_trans,
    LAPACKE_cst_nancheck,
    LAPACKE_csy_nancheck,
    LAPACKE_csy_trans,
    LAPACKE_ctb_nancheck,
    LAPACKE_ctb_trans,
    LAPACKE_ctf_nancheck,
    LAPACKE_ctf_trans,
    LAPACKE_ctp_nancheck,
    LAPACKE_ctp_trans,
    LAPACKE_ctr_nancheck,
    LAPACKE_ctr_trans,
    LAPACKE_cbbcsd,
    LAPACKE_cbbcsd_work,
    LAPACKE_cbdsqr,
    LAPACKE_cbdsqr_work,
    LAPACKE_cgbbrd,
    LAPACKE_cgbbrd_work,
    LAPACKE_cgbcon,
    LAPACKE_cgbcon_work,
    LAPACKE_cgbequ,
    LAPACKE_cgbequ_work,
    LAPACKE_cgbequb,
    LAPACKE_cgbequb_work,
    LAPACKE_cgbrfs,
    LAPACKE_cgbrfs_work,
    LAPACKE_cgbsv,
    LAPACKE_cgbsv_work,
    LAPACKE_cgbsvx,
    LAPACKE_cgbsvx_work,
    LAPACKE_cgbtrf,
    LAPACKE_cgbtrf_work,
    LAPACKE_cgbtrs,
    LAPACKE_cgbtrs_work,
    LAPACKE_cgebak,
    LAPACKE_cgebak_work,
    LAPACKE_cgebal,
    LAPACKE_cgebal_work,
    LAPACKE_cgebrd,
    LAPACKE_cgebrd_work,
    LAPACKE_cgecon,
    LAPACKE_cgecon_work,
    LAPACKE_cgedmd,
    LAPACKE_cgedmd_work,
    LAPACKE_cgedmdq,
    LAPACKE_cgedmdq_work,
    LAPACKE_cgeequ,
    LAPACKE_cgeequ_work,
    LAPACKE_cgeequb,
    LAPACKE_cgeequb_work,
    LAPACKE_cgees,
    LAPACKE_cgees_work,
    LAPACKE_cgeesx,
    LAPACKE_cgeesx_work,
    LAPACKE_cgeev,
    LAPACKE_cgeev_work,
    LAPACKE_cgeevx,
    LAPACKE_cgeevx_work,
    LAPACKE_cgehrd,
    LAPACKE_cgehrd_work,
    LAPACKE_cgelq2,
    LAPACKE_cgelq2_work,
    LAPACKE_cgelqf,
    LAPACKE_cgelqf_work,
    LAPACKE_cgels,
    LAPACKE_cgels_work,
    LAPACKE_cgelsd,
    LAPACKE_cgelsd_work,
    LAPACKE_cgelss,
    LAPACKE_cgelss_work,
    LAPACKE_cgelsy,
    LAPACKE_cgelsy_work,
    LAPACKE_cgemqrt,
    LAPACKE_cgemqrt_work,
    LAPACKE_cgeqlf,
    LAPACKE_cgeqlf_work,
    LAPACKE_cgeqp3,
    LAPACKE_cgeqp3_work,
    LAPACKE_cgeqr2,
    LAPACKE_cgeqr2_work,
    LAPACKE_cgeqrf,
    LAPACKE_cgeqrf_work,
    LAPACKE_cgeqrfp,
    LAPACKE_cgeqrfp_work,
    LAPACKE_cgeqrt,
    LAPACKE_cgeqrt2,
    LAPACKE_cgeqrt2_work,
    LAPACKE_cgeqrt3,
    LAPACKE_cgeqrt3_work,
    LAPACKE_cgeqrt_work,
    LAPACKE_cgerfs,
    LAPACKE_cgerfs_work,
    LAPACKE_cgerqf,
    LAPACKE_cgerqf_work,
    LAPACKE_cgesdd,
    LAPACKE_cgesdd_work,
    LAPACKE_cgesv,
    LAPACKE_cgesv_work,
    LAPACKE_cgesvd,
    LAPACKE_cgesvd_work,
    LAPACKE_cgesvx,
    LAPACKE_cgesvx_work,
    LAPACKE_cgetf2,
    LAPACKE_cgetf2_work,
    LAPACKE_cgetrf,
    LAPACKE_cgetrf_work,
    LAPACKE_cgetri,
    LAPACKE_cgetri_work,
    LAPACKE_cgetrs,
    LAPACKE_cgetrs_work,
    LAPACKE_cggbak,
    LAPACKE_cggbak_work,
    LAPACKE_cggbal,
    LAPACKE_cggbal_work,
    LAPACKE_cgges,
    LAPACKE_cgges_work,
    LAPACKE_cggesx,
    LAPACKE_cggesx_work,
    LAPACKE_cggev,
    LAPACKE_cggev_work,
    LAPACKE_cggevx,
    LAPACKE_cggevx_work,
    LAPACKE_cggglm,
    LAPACKE_cggglm_work,
    LAPACKE_cgghrd,
    LAPACKE_cgghrd_work,
    LAPACKE_cgglse,
    LAPACKE_cgglse_work,
    LAPACKE_cggqrf,
    LAPACKE_cggqrf_work,
    LAPACKE_cggrqf,
    LAPACKE_cggrqf_work,
    LAPACKE_cgtcon,
    LAPACKE_cgtcon_work,
    LAPACKE_cgtrfs,
    LAPACKE_cgtrfs_work,
    LAPACKE_cgtsv,
    LAPACKE_cgtsv_work,
    LAPACKE_cgtsvx,
    LAPACKE_cgtsvx_work,
    LAPACKE_cgttrf,
    LAPACKE_cgttrf_work,
    LAPACKE_cgttrs,
    LAPACKE_cgttrs_work,
    LAPACKE_chbev,
    LAPACKE_chbev_work,
    LAPACKE_chbevd,
    LAPACKE_chbevd_work,
    LAPACKE_chbevx,
    LAPACKE_chbevx_work,
    LAPACKE_chbgst,
    LAPACKE_chbgst_work,
    LAPACKE_chbgv,
    LAPACKE_chbgv_work,
    LAPACKE_chbgvd,
    LAPACKE_chbgvd_work,
    LAPACKE_chbgvx,
    LAPACKE_chbgvx_work,
    LAPACKE_chbtrd,
    LAPACKE_chbtrd_work,
    LAPACKE_checon,
    LAPACKE_checon_work,
    LAPACKE_cheequb,
    LAPACKE_cheequb_work,
    LAPACKE_cheev,
    LAPACKE_cheev_work,
    LAPACKE_cheevd,
    LAPACKE_cheevd_work,
    LAPACKE_cheevr,
    LAPACKE_cheevr_work,
    LAPACKE_cheevx,
    LAPACKE_cheevx_work,
    LAPACKE_chegst,
    LAPACKE_chegst_work,
    LAPACKE_chegv,
    LAPACKE_chegv_work,
    LAPACKE_chegvd,
    LAPACKE_chegvd_work,
    LAPACKE_chegvx,
    LAPACKE_chegvx_work,
    LAPACKE_cherfs,
    LAPACKE_cherfs_work,
    LAPACKE_chesv,
    LAPACKE_chesv_work,
    LAPACKE_chesvx,
    LAPACKE_chesvx_work,
    LAPACKE_cheswapr,
    LAPACKE_cheswapr_work,
    LAPACKE_chetrd,
    LAPACKE_chetrd_work,
    LAPACKE_chetrf,
    LAPACKE_chetrf_work,
    LAPACKE_chetri,
    LAPACKE_chetri2,
    LAPACKE_chetri2_work,
    LAPACKE_chetri2x,
    LAPACKE_chetri2x_work,
    LAPACKE_chetri_work,
    LAPACKE_chetrs,
    LAPACKE_chetrs2,
    LAPACKE_chetrs2_work,
    LAPACKE_chetrs_work,
    LAPACKE_chfrk,
    LAPACKE_chfrk_work,
    LAPACKE_chgeqz,
    LAPACKE_chgeqz_work,
    LAPACKE_chpcon,
    LAPACKE_chpcon_work,
    LAPACKE_chpev,
    LAPACKE_chpev_work,
    LAPACKE_chpevd,
    LAPACKE_chpevd_work,
    LAPACKE_chpevx,
    LAPACKE_chpevx_work,
    LAPACKE_chpgst,
    LAPACKE_chpgst_work,
    LAPACKE_chpgv,
    LAPACKE_chpgv_work,
    LAPACKE_chpgvd,
    LAPACKE_chpgvd_work,
    LAPACKE_chpgvx,
    LAPACKE_chpgvx_work,
    LAPACKE_chprfs,
    LAPACKE_chprfs_work,
    LAPACKE_chpsv,
    LAPACKE_chpsv_work,
    LAPACKE_chpsvx,
    LAPACKE_chpsvx_work,
    LAPACKE_chptrd,
    LAPACKE_chptrd_work,
    LAPACKE_chptrf,
    LAPACKE_chptrf_work,
    LAPACKE_chptri,
    LAPACKE_chptri_work,
    LAPACKE_chptrs,
    LAPACKE_chptrs_work,
    LAPACKE_chsein,
    LAPACKE_chsein_work,
    LAPACKE_chseqr,
    LAPACKE_chseqr_work,
    LAPACKE_clacgv,
    LAPACKE_clacgv_work,
    LAPACKE_clacn2,
    LAPACKE_clacn2_work,
    LAPACKE_clacp2,
    LAPACKE_clacp2_work,
    LAPACKE_clacpy,
    LAPACKE_clacpy_work,
    LAPACKE_clag2z,
    LAPACKE_clag2z_work,
    LAPACKE_clange,
    LAPACKE_clange_work,
    LAPACKE_clanhe,
    LAPACKE_clanhe_work,
    LAPACKE_clansy,
    LAPACKE_clansy_work,
    LAPACKE_clantr,
    LAPACKE_clantr_work,
    LAPACKE_clapmr,
    LAPACKE_clapmr_work,
    LAPACKE_clarfb,
    LAPACKE_clarfb_work,
    LAPACKE_clarfg,
    LAPACKE_clarfg_work,
    LAPACKE_clarft,
    LAPACKE_clarft_work,
    LAPACKE_clarfx,
    LAPACKE_clarfx_work,
    LAPACKE_clarnv,
    LAPACKE_clarnv_work,
    LAPACKE_claset,
    LAPACKE_claset_work,
    LAPACKE_claswp,
    LAPACKE_claswp_work,
    LAPACKE_clauum,
    LAPACKE_clauum_work,
    LAPACKE_cpbcon,
    LAPACKE_cpbcon_work,
    LAPACKE_cpbequ,
    LAPACKE_cpbequ_work,
    LAPACKE_cpbrfs,
    LAPACKE_cpbrfs_work,
    LAPACKE_cpbstf,
    LAPACKE_cpbstf_work,
    LAPACKE_cpbsv,
    LAPACKE_cpbsv_work,
    LAPACKE_cpbsvx,
    LAPACKE_cpbsvx_work,
    LAPACKE_cpbtrf,
    LAPACKE_cpbtrf_work,
    LAPACKE_cpbtrs,
    LAPACKE_cpbtrs_work,
    LAPACKE_cpftrf,
    LAPACKE_cpftrf_work,
    LAPACKE_cpftri,
    LAPACKE_cpftri_work,
    LAPACKE_cpftrs,
    LAPACKE_cpftrs_work,
    LAPACKE_cpocon,
    LAPACKE_cpocon_work,
    LAPACKE_cpoequ,
    LAPACKE_cpoequ_work,
    LAPACKE_cpoequb,
    LAPACKE_cpoequb_work,
    LAPACKE_cporfs,
    LAPACKE_cporfs_work,
    LAPACKE_cposv,
    LAPACKE_cposv_work,
    LAPACKE_cposvx,
    LAPACKE_cposvx_work,
    LAPACKE_cpotrf,
    LAPACKE_cpotrf_work,
    LAPACKE_cpotri,
    LAPACKE_cpotri_work,
    LAPACKE_cpotrs,
    LAPACKE_cpotrs_work,
    LAPACKE_cppcon,
    LAPACKE_cppcon_work,
    LAPACKE_cppequ,
    LAPACKE_cppequ_work,
    LAPACKE_cpprfs,
    LAPACKE_cpprfs_work,
    LAPACKE_cppsv,
    LAPACKE_cppsv_work,
    LAPACKE_cppsvx,
    LAPACKE_cppsvx_work,
    LAPACKE_cpptrf,
    LAPACKE_cpptrf_work,
    LAPACKE_cpptri,
    LAPACKE_cpptri_work,
    LAPACKE_cpptrs,
    LAPACKE_cpptrs_work,
    LAPACKE_cpstrf,
    LAPACKE_cpstrf_work,
    LAPACKE_cptcon,
    LAPACKE_cptcon_work,
    LAPACKE_cpteqr,
    LAPACKE_cpteqr_work,
    LAPACKE_cptrfs,
    LAPACKE_cptrfs_work,
    LAPACKE_cptsv,
    LAPACKE_cptsv_work,
    LAPACKE_cptsvx,
    LAPACKE_cptsvx_work,
    LAPACKE_cpttrf,
    LAPACKE_cpttrf_work,
    LAPACKE_cpttrs,
    LAPACKE_cpttrs_work,
    LAPACKE_cspcon,
    LAPACKE_cspcon_work,
    LAPACKE_csprfs,
    LAPACKE_csprfs_work,
    LAPACKE_cspsv,
    LAPACKE_cspsv_work,
    LAPACKE_cspsvx,
    LAPACKE_cspsvx_work,
    LAPACKE_csptrf,
    LAPACKE_csptrf_work,
    LAPACKE_csptri,
    LAPACKE_csptri_work,
    LAPACKE_csptrs,
    LAPACKE_csptrs_work,
    LAPACKE_cstedc,
    LAPACKE_cstedc_work,
    LAPACKE_cstegr,
    LAPACKE_cstegr_work,
    LAPACKE_cstein,
    LAPACKE_cstein_work,
    LAPACKE_cstemr,
    LAPACKE_cstemr_work,
    LAPACKE_csteqr,
    LAPACKE_csteqr_work,
    LAPACKE_csycon,
    LAPACKE_csycon_work,
    LAPACKE_csyconv,
    LAPACKE_csyconv_work,
    LAPACKE_csyequb,
    LAPACKE_csyequb_work,
    LAPACKE_csyrfs,
    LAPACKE_csyrfs_work,
    LAPACKE_csysv,
    LAPACKE_csysv_rook,
    LAPACKE_csysv_rook_work,
    LAPACKE_csysv_work,
    LAPACKE_csysvx,
    LAPACKE_csysvx_work,
    LAPACKE_csyswapr,
    LAPACKE_csyswapr_work,
    LAPACKE_csytrf,
    LAPACKE_csytrf_work,
    LAPACKE_csytri,
    LAPACKE_csytri2,
    LAPACKE_csytri2_work,
    LAPACKE_csytri2x,
    LAPACKE_csytri2x_work,
    LAPACKE_csytri_work,
    LAPACKE_csytrs,
    LAPACKE_csytrs2,
    LAPACKE_csytrs2_work,
    LAPACKE_csytrs_work,
    LAPACKE_ctbcon,
    LAPACKE_ctbcon_work,
    LAPACKE_ctbrfs,
    LAPACKE_ctbrfs_work,
    LAPACKE_ctbtrs,
    LAPACKE_ctbtrs_work,
    LAPACKE_ctfsm,
    LAPACKE_ctfsm_work,
    LAPACKE_ctftri,
    LAPACKE_ctftri_work,
    LAPACKE_ctfttp,
    LAPACKE_ctfttp_work,
    LAPACKE_ctfttr,
    LAPACKE_ctfttr_work,
    LAPACKE_ctgevc,
    LAPACKE_ctgevc_work,
    LAPACKE_ctgexc,
    LAPACKE_ctgexc_work,
    LAPACKE_ctgsen,
    LAPACKE_ctgsen_work,
    LAPACKE_ctgsja,
    LAPACKE_ctgsja_work,
    LAPACKE_ctgsna,
    LAPACKE_ctgsna_work,
    LAPACKE_ctgsyl,
    LAPACKE_ctgsyl_work,
    LAPACKE_ctpcon,
    LAPACKE_ctpcon_work,
    LAPACKE_ctpmqrt,
    LAPACKE_ctpmqrt_work,
    LAPACKE_ctpqrt,
    LAPACKE_ctpqrt2,
    LAPACKE_ctpqrt2_work,
    LAPACKE_ctpqrt_work,
    LAPACKE_ctprfb,
    LAPACKE_ctprfb_work,
    LAPACKE_ctprfs,
    LAPACKE_ctprfs_work,
    LAPACKE_ctptri,
    LAPACKE_ctptri_work,
    LAPACKE_ctptrs,
    LAPACKE_ctptrs_work,
    LAPACKE_ctpttf,
    LAPACKE_ctpttf_work,
    LAPACKE_ctpttr,
    LAPACKE_ctpttr_work,
    LAPACKE_ctrcon,
    LAPACKE_ctrcon_work,
    LAPACKE_ctrevc,
    LAPACKE_ctrevc_work,
    LAPACKE_ctrexc,
    LAPACKE_ctrexc_work,
    LAPACKE_ctrrfs,
    LAPACKE_ctrrfs_work,
    LAPACKE_ctrsen,
    LAPACKE_ctrsen_work,
    LAPACKE_ctrsna,
    LAPACKE_ctrsna_work,
    LAPACKE_ctrsyl,
    LAPACKE_ctrsyl_work,
    LAPACKE_ctrtri,
    LAPACKE_ctrtri_work,
    LAPACKE_ctrtrs,
    LAPACKE_ctrtrs_work,
    LAPACKE_ctrttf,
    LAPACKE_ctrttf_work,
    LAPACKE_ctrttp,
    LAPACKE_ctrttp_work,
    LAPACKE_ctzrzf,
    LAPACKE_ctzrzf_work,
    LAPACKE_cunbdb,
    LAPACKE_cunbdb_work,
    LAPACKE_cuncsd,
    LAPACKE_cuncsd_work,
    LAPACKE_cungbr,
    LAPACKE_cungbr_work,
    LAPACKE_cunghr,
    LAPACKE_cunghr_work,
    LAPACKE_cunglq,
    LAPACKE_cunglq_work,
    LAPACKE_cungql,
    LAPACKE_cungql_work,
    LAPACKE_cungqr,
    LAPACKE_cungqr_work,
    LAPACKE_cungrq,
    LAPACKE_cungrq_work,
    LAPACKE_cungtr,
    LAPACKE_cungtr_work,
    LAPACKE_cunmbr,
    LAPACKE_cunmbr_work,
    LAPACKE_cunmhr,
    LAPACKE_cunmhr_work,
    LAPACKE_cunmlq,
    LAPACKE_cunmlq_work,
    LAPACKE_cunmql,
    LAPACKE_cunmql_work,
    LAPACKE_cunmqr,
    LAPACKE_cunmqr_work,
    LAPACKE_cunmrq,
    LAPACKE_cunmrq_work,
    LAPACKE_cunmrz,
    LAPACKE_cunmrz_work,
    LAPACKE_cunmtr,
    LAPACKE_cunmtr_work,
    LAPACKE_cupgtr,
    LAPACKE_cupgtr_work,
    LAPACKE_cupmtr,
    LAPACKE_cupmtr_work,
    LAPACKE_csyr,
    LAPACKE_csyr_work,
    LAPACKE_clatms,
    LAPACKE_clatms_work,
    LAPACKE_clagge,
    LAPACKE_clagge_work,
    LAPACKE_claghe,
    LAPACKE_claghe_work,
    LAPACKE_clagsy,
    LAPACKE_clagsy_work,
    LAPACKE_cgejsv,
    LAPACKE_cgejsv_work,
    LAPACKE_cgesvdx,
    LAPACKE_cgesvdx_work,
    LAPACKE_cgesvj,
    LAPACKE_cgesvj_work,
    LAPACKE_cgetrf2,
    LAPACKE_cgetrf2_work,
    LAPACKE_cgges3,
    LAPACKE_cgges3_work,
    LAPACKE_cggev3,
    LAPACKE_cggev3_work,
    LAPACKE_cgghd3,
    LAPACKE_cgghd3_work,
    LAPACKE_cggsvd3,
    LAPACKE_cggsvd3_work,
    LAPACKE_cggsvp3,
    LAPACKE_cggsvp3_work,
    LAPACKE_chetrf_rook,
    LAPACKE_chetrf_rook_work,
    LAPACKE_chetrs_rook,
    LAPACKE_chetrs_rook_work,
    LAPACKE_clapmt,
    LAPACKE_clapmt_work,
    LAPACKE_clascl,
    LAPACKE_clascl_work,
    LAPACKE_cpotrf2,
    LAPACKE_cpotrf2_work,
    LAPACKE_csytrf_rook,
    LAPACKE_csytrf_rook_work,
    LAPACKE_csytrs_rook,
    LAPACKE_csytrs_rook_work,
    LAPACKE_cuncsd2by1,
    LAPACKE_cuncsd2by1_work,
    LAPACKE_cgelq,
    LAPACKE_cgelq_work,
    LAPACKE_cgemlq,
    LAPACKE_cgemlq_work,
    LAPACKE_cgemqr,
    LAPACKE_cgemqr_work,
    LAPACKE_cgeqr,
    LAPACKE_cgeqr_work,
    LAPACKE_cgetsls,
    LAPACKE_cgetsls_work,
    LAPACKE_chbev_2stage,
    LAPACKE_chbev_2stage_work,
    LAPACKE_chbevd_2stage,
    LAPACKE_chbevd_2stage_work,
    LAPACKE_chbevx_2stage,
    LAPACKE_chbevx_2stage_work,
    LAPACKE_checon_3,
    LAPACKE_checon_3_work,
    LAPACKE_cheev_2stage,
    LAPACKE_cheev_2stage_work,
    LAPACKE_cheevd_2stage,
    LAPACKE_cheevd_2stage_work,
    LAPACKE_cheevr_2stage,
    LAPACKE_cheevr_2stage_work,
    LAPACKE_cheevx_2stage,
    LAPACKE_cheevx_2stage_work,
    LAPACKE_chegv_2stage,
    LAPACKE_chegv_2stage_work,
    LAPACKE_chesv_aa,
    LAPACKE_chesv_aa_work,
    LAPACKE_chesv_rk,
    LAPACKE_chesv_rk_work,
    LAPACKE_chetrf_aa,
    LAPACKE_chetrf_aa_work,
    LAPACKE_chetrf_rk,
    LAPACKE_chetrf_rk_work,
    LAPACKE_chetri_3,
    LAPACKE_chetri_3_work,
    LAPACKE_chetrs_aa,
    LAPACKE_chetrs_aa_work,
    LAPACKE_chetrs_3,
    LAPACKE_chetrs_3_work,
    LAPACKE_csycon_3,
    LAPACKE_csycon_3_work,
    LAPACKE_csysv_aa,
    LAPACKE_csysv_aa_work,
    LAPACKE_csysv_rk,
    LAPACKE_csysv_rk_work,
    LAPACKE_csytrf_aa,
    LAPACKE_csytrf_aa_work,
    LAPACKE_csytrf_rk,
    LAPACKE_csytrf_rk_work,
    LAPACKE_csytri_3,
    LAPACKE_csytri_3_work,
    LAPACKE_csytrs_aa,
    LAPACKE_csytrs_aa_work,
    LAPACKE_csytrs_3,
    LAPACKE_csytrs_3_work,
    LAPACKE_chesv_aa_2stage,
    LAPACKE_chesv_aa_2stage_work,
    LAPACKE_chetrf_aa_2stage,
    LAPACKE_chetrf_aa_2stage_work,
    LAPACKE_chetrs_aa_2stage,
    LAPACKE_chetrs_aa_2stage_work,
    LAPACKE_clacrm,
    LAPACKE_clacrm_work,
    LAPACKE_clarcm,
    LAPACKE_clarcm_work,
    LAPACKE_classq,
    LAPACKE_classq_work,
    LAPACKE_csysv_aa_2stage,
    LAPACKE_csysv_aa_2stage_work,
    LAPACKE_csytrf_aa_2stage,
    LAPACKE_csytrf_aa_2stage_work,
    LAPACKE_csytrs_aa_2stage,
    LAPACKE_csytrs_aa_2stage_work,
    LAPACKE_cgesvdq,
    LAPACKE_cgesvdq_work,
    LAPACKE_cgetsqrhrt,
    LAPACKE_cgetsqrhrt_work,
    LAPACKE_cungtsqr_row,
    LAPACKE_cungtsqr_row_work,
    LAPACKE_clangb,
    LAPACKE_clangb_work,
    LAPACKE_ctrsyl3,
    LAPACKE_ctrsyl3_work,
    LAPACKE_ctz_nancheck,
    LAPACKE_ctz_trans,
    LAPACKE_cunhr_col,
    LAPACKE_cunhr_col_work
);
@lapackeobjsd = (
    LAPACKE_dgb_nancheck,
    LAPACKE_dgb_trans,
    LAPACKE_dge_nancheck,
    LAPACKE_dge_trans,
    LAPACKE_dgg_nancheck,
    LAPACKE_dgg_trans,
    LAPACKE_dgt_nancheck,
    LAPACKE_dhs_nancheck,
    LAPACKE_dhs_trans,
    LAPACKE_d_nancheck,
    LAPACKE_dpb_nancheck,
    LAPACKE_dpb_trans,
    LAPACKE_dpf_nancheck,
    LAPACKE_dpf_trans,
    LAPACKE_dpo_nancheck,
    LAPACKE_dpo_trans,
    LAPACKE_dpp_nancheck,
    LAPACKE_dpp_trans,
    LAPACKE_dpt_nancheck,
    LAPACKE_dsb_nancheck,
    LAPACKE_dsb_trans,
    LAPACKE_dsp_nancheck,
    LAPACKE_dsp_trans,
    LAPACKE_dst_nancheck,
    LAPACKE_dsy_nancheck,
    LAPACKE_dsy_trans,
    LAPACKE_dtb_nancheck,
    LAPACKE_dtb_trans,
    LAPACKE_dtf_nancheck,
    LAPACKE_dtf_trans,
    LAPACKE_dtp_nancheck,
    LAPACKE_dtp_trans,
    LAPACKE_dtr_nancheck,
    LAPACKE_dtr_trans,
    LAPACKE_dbbcsd,
    LAPACKE_dbbcsd_work,
    LAPACKE_dbdsdc,
    LAPACKE_dbdsdc_work,
    LAPACKE_dbdsqr,
    LAPACKE_dbdsqr_work,
    LAPACKE_ddisna,
    LAPACKE_ddisna_work,
    LAPACKE_dgbbrd,
    LAPACKE_dgbbrd_work,
    LAPACKE_dgbcon,
    LAPACKE_dgbcon_work,
    LAPACKE_dgbequ,
    LAPACKE_dgbequ_work,
    LAPACKE_dgbequb,
    LAPACKE_dgbequb_work,
    LAPACKE_dgbrfs,
    LAPACKE_dgbrfs_work,
    LAPACKE_dgbsv,
    LAPACKE_dgbsv_work,
    LAPACKE_dgbsvx,
    LAPACKE_dgbsvx_work,
    LAPACKE_dgbtrf,
    LAPACKE_dgbtrf_work,
    LAPACKE_dgbtrs,
    LAPACKE_dgbtrs_work,
    LAPACKE_dgebak,
    LAPACKE_dgebak_work,
    LAPACKE_dgebal,
    LAPACKE_dgebal_work,
    LAPACKE_dgebrd,
    LAPACKE_dgebrd_work,
    LAPACKE_dgecon,
    LAPACKE_dgecon_work,
    LAPACKE_dgedmd,
    LAPACKE_dgedmd_work,
    LAPACKE_dgedmdq,
    LAPACKE_dgedmdq_work,
    LAPACKE_dgeequ,
    LAPACKE_dgeequ_work,
    LAPACKE_dgeequb,
    LAPACKE_dgeequb_work,
    LAPACKE_dgees,
    LAPACKE_dgees_work,
    LAPACKE_dgeesx,
    LAPACKE_dgeesx_work,
    LAPACKE_dgeev,
    LAPACKE_dgeev_work,
    LAPACKE_dgeevx,
    LAPACKE_dgeevx_work,
    LAPACKE_dgehrd,
    LAPACKE_dgehrd_work,
    LAPACKE_dgejsv,
    LAPACKE_dgejsv_work,
    LAPACKE_dgelq2,
    LAPACKE_dgelq2_work,
    LAPACKE_dgelqf,
    LAPACKE_dgelqf_work,
    LAPACKE_dgels,
    LAPACKE_dgels_work,
    LAPACKE_dgelsd,
    LAPACKE_dgelsd_work,
    LAPACKE_dgelss,
    LAPACKE_dgelss_work,
    LAPACKE_dgelsy,
    LAPACKE_dgelsy_work,
    LAPACKE_dgemqrt,
    LAPACKE_dgemqrt_work,
    LAPACKE_dgeqlf,
    LAPACKE_dgeqlf_work,
    LAPACKE_dgeqp3,
    LAPACKE_dgeqp3_work,
    LAPACKE_dgeqr2,
    LAPACKE_dgeqr2_work,
    LAPACKE_dgeqrf,
    LAPACKE_dgeqrf_work,
    LAPACKE_dgeqrfp,
    LAPACKE_dgeqrfp_work,
    LAPACKE_dgeqrt,
    LAPACKE_dgeqrt2,
    LAPACKE_dgeqrt2_work,
    LAPACKE_dgeqrt3,
    LAPACKE_dgeqrt3_work,
    LAPACKE_dgeqrt_work,
    LAPACKE_dgerfs,
    LAPACKE_dgerfs_work,
    LAPACKE_dgerqf,
    LAPACKE_dgerqf_work,
    LAPACKE_dgesdd,
    LAPACKE_dgesdd_work,
    LAPACKE_dgesv,
    LAPACKE_dgesv_work,
    LAPACKE_dgesvd,
    LAPACKE_dgesvd_work,
    LAPACKE_dgesvj,
    LAPACKE_dgesvj_work,
    LAPACKE_dgesvx,
    LAPACKE_dgesvx_work,
    LAPACKE_dgetf2,
    LAPACKE_dgetf2_work,
    LAPACKE_dgetrf,
    LAPACKE_dgetrf_work,
    LAPACKE_dgetri,
    LAPACKE_dgetri_work,
    LAPACKE_dgetrs,
    LAPACKE_dgetrs_work,
    LAPACKE_dggbak,
    LAPACKE_dggbak_work,
    LAPACKE_dggbal,
    LAPACKE_dggbal_work,
    LAPACKE_dgges,
    LAPACKE_dgges_work,
    LAPACKE_dggesx,
    LAPACKE_dggesx_work,
    LAPACKE_dggev,
    LAPACKE_dggev_work,
    LAPACKE_dggevx,
    LAPACKE_dggevx_work,
    LAPACKE_dggglm,
    LAPACKE_dggglm_work,
    LAPACKE_dgghrd,
    LAPACKE_dgghrd_work,
    LAPACKE_dgglse,
    LAPACKE_dgglse_work,
    LAPACKE_dggqrf,
    LAPACKE_dggqrf_work,
    LAPACKE_dggrqf,
    LAPACKE_dggrqf_work,
    LAPACKE_dgtcon,
    LAPACKE_dgtcon_work,
    LAPACKE_dgtrfs,
    LAPACKE_dgtrfs_work,
    LAPACKE_dgtsv,
    LAPACKE_dgtsv_work,
    LAPACKE_dgtsvx,
    LAPACKE_dgtsvx_work,
    LAPACKE_dgttrf,
    LAPACKE_dgttrf_work,
    LAPACKE_dgttrs,
    LAPACKE_dgttrs_work,
    LAPACKE_dhgeqz,
    LAPACKE_dhgeqz_work,
    LAPACKE_dhsein,
    LAPACKE_dhsein_work,
    LAPACKE_dhseqr,
    LAPACKE_dhseqr_work,
    LAPACKE_dlacn2,
    LAPACKE_dlacn2_work,
    LAPACKE_dlacpy,
    LAPACKE_dlacpy_work,
    LAPACKE_dlag2s,
    LAPACKE_dlag2s_work,
    LAPACKE_dlamch,
    LAPACKE_dlamch_work,
    LAPACKE_dlange,
    LAPACKE_dlange_work,
    LAPACKE_dlansy,
    LAPACKE_dlansy_work,
    LAPACKE_dlantr,
    LAPACKE_dlantr_work,
    LAPACKE_dlapmr,
    LAPACKE_dlapmr_work,
    LAPACKE_dlapy2,
    LAPACKE_dlapy2_work,
    LAPACKE_dlapy3,
    LAPACKE_dlapy3_work,
    LAPACKE_dlarfb,
    LAPACKE_dlarfb_work,
    LAPACKE_dlarfg,
    LAPACKE_dlarfg_work,
    LAPACKE_dlarft,
    LAPACKE_dlarft_work,
    LAPACKE_dlarfx,
    LAPACKE_dlarfx_work,
    LAPACKE_dlarnv,
    LAPACKE_dlarnv_work,
    LAPACKE_dlartgp,
    LAPACKE_dlartgp_work,
    LAPACKE_dlartgs,
    LAPACKE_dlartgs_work,
    LAPACKE_dlaset,
    LAPACKE_dlaset_work,
    LAPACKE_dlasrt,
    LAPACKE_dlasrt_work,
    LAPACKE_dlaswp,
    LAPACKE_dlaswp_work,
    LAPACKE_dlauum,
    LAPACKE_dlauum_work,
    LAPACKE_dopgtr,
    LAPACKE_dopgtr_work,
    LAPACKE_dopmtr,
    LAPACKE_dopmtr_work,
    LAPACKE_dorbdb,
    LAPACKE_dorbdb_work,
    LAPACKE_dorcsd,
    LAPACKE_dorcsd_work,
    LAPACKE_dorgbr,
    LAPACKE_dorgbr_work,
    LAPACKE_dorghr,
    LAPACKE_dorghr_work,
    LAPACKE_dorglq,
    LAPACKE_dorglq_work,
    LAPACKE_dorgql,
    LAPACKE_dorgql_work,
    LAPACKE_dorgqr,
    LAPACKE_dorgqr_work,
    LAPACKE_dorgrq,
    LAPACKE_dorgrq_work,
    LAPACKE_dorgtr,
    LAPACKE_dorgtr_work,
    LAPACKE_dormbr,
    LAPACKE_dormbr_work,
    LAPACKE_dormhr,
    LAPACKE_dormhr_work,
    LAPACKE_dormlq,
    LAPACKE_dormlq_work,
    LAPACKE_dormql,
    LAPACKE_dormql_work,
    LAPACKE_dormqr,
    LAPACKE_dormqr_work,
    LAPACKE_dormrq,
    LAPACKE_dormrq_work,
    LAPACKE_dormrz,
    LAPACKE_dormrz_work,
    LAPACKE_dormtr,
    LAPACKE_dormtr_work,
    LAPACKE_dpbcon,
    LAPACKE_dpbcon_work,
    LAPACKE_dpbequ,
    LAPACKE_dpbequ_work,
    LAPACKE_dpbrfs,
    LAPACKE_dpbrfs_work,
    LAPACKE_dpbstf,
    LAPACKE_dpbstf_work,
    LAPACKE_dpbsv,
    LAPACKE_dpbsv_work,
    LAPACKE_dpbsvx,
    LAPACKE_dpbsvx_work,
    LAPACKE_dpbtrf,
    LAPACKE_dpbtrf_work,
    LAPACKE_dpbtrs,
    LAPACKE_dpbtrs_work,
    LAPACKE_dpftrf,
    LAPACKE_dpftrf_work,
    LAPACKE_dpftri,
    LAPACKE_dpftri_work,
    LAPACKE_dpftrs,
    LAPACKE_dpftrs_work,
    LAPACKE_dpocon,
    LAPACKE_dpocon_work,
    LAPACKE_dpoequ,
    LAPACKE_dpoequ_work,
    LAPACKE_dpoequb,
    LAPACKE_dpoequb_work,
    LAPACKE_dporfs,
    LAPACKE_dporfs_work,
    LAPACKE_dposv,
    LAPACKE_dposv_work,
    LAPACKE_dposvx,
    LAPACKE_dposvx_work,
    LAPACKE_dpotrf,
    LAPACKE_dpotrf_work,
    LAPACKE_dpotri,
    LAPACKE_dpotri_work,
    LAPACKE_dpotrs,
    LAPACKE_dpotrs_work,
    LAPACKE_dppcon,
    LAPACKE_dppcon_work,
    LAPACKE_dppequ,
    LAPACKE_dppequ_work,
    LAPACKE_dpprfs,
    LAPACKE_dpprfs_work,
    LAPACKE_dppsv,
    LAPACKE_dppsv_work,
    LAPACKE_dppsvx,
    LAPACKE_dppsvx_work,
    LAPACKE_dpptrf,
    LAPACKE_dpptrf_work,
    LAPACKE_dpptri,
    LAPACKE_dpptri_work,
    LAPACKE_dpptrs,
    LAPACKE_dpptrs_work,
    LAPACKE_dpstrf,
    LAPACKE_dpstrf_work,
    LAPACKE_dptcon,
    LAPACKE_dptcon_work,
    LAPACKE_dpteqr,
    LAPACKE_dpteqr_work,
    LAPACKE_dptrfs,
    LAPACKE_dptrfs_work,
    LAPACKE_dptsv,
    LAPACKE_dptsv_work,
    LAPACKE_dptsvx,
    LAPACKE_dptsvx_work,
    LAPACKE_dpttrf,
    LAPACKE_dpttrf_work,
    LAPACKE_dpttrs,
    LAPACKE_dpttrs_work,
    LAPACKE_dsbev,
    LAPACKE_dsbev_work,
    LAPACKE_dsbevd,
    LAPACKE_dsbevd_work,
    LAPACKE_dsbevx,
    LAPACKE_dsbevx_work,
    LAPACKE_dsbgst,
    LAPACKE_dsbgst_work,
    LAPACKE_dsbgv,
    LAPACKE_dsbgv_work,
    LAPACKE_dsbgvd,
    LAPACKE_dsbgvd_work,
    LAPACKE_dsbgvx,
    LAPACKE_dsbgvx_work,
    LAPACKE_dsbtrd,
    LAPACKE_dsbtrd_work,
    LAPACKE_dsfrk,
    LAPACKE_dsfrk_work,
    LAPACKE_dsgesv,
    LAPACKE_dsgesv_work,
    LAPACKE_dspcon,
    LAPACKE_dspcon_work,
    LAPACKE_dspev,
    LAPACKE_dspev_work,
    LAPACKE_dspevd,
    LAPACKE_dspevd_work,
    LAPACKE_dspevx,
    LAPACKE_dspevx_work,
    LAPACKE_dspgst,
    LAPACKE_dspgst_work,
    LAPACKE_dspgv,
    LAPACKE_dspgv_work,
    LAPACKE_dspgvd,
    LAPACKE_dspgvd_work,
    LAPACKE_dspgvx,
    LAPACKE_dspgvx_work,
    LAPACKE_dsposv,
    LAPACKE_dsposv_work,
    LAPACKE_dsprfs,
    LAPACKE_dsprfs_work,
    LAPACKE_dspsv,
    LAPACKE_dspsv_work,
    LAPACKE_dspsvx,
    LAPACKE_dspsvx_work,
    LAPACKE_dsptrd,
    LAPACKE_dsptrd_work,
    LAPACKE_dsptrf,
    LAPACKE_dsptrf_work,
    LAPACKE_dsptri,
    LAPACKE_dsptri_work,
    LAPACKE_dsptrs,
    LAPACKE_dsptrs_work,
    LAPACKE_dstebz,
    LAPACKE_dstebz_work,
    LAPACKE_dstedc,
    LAPACKE_dstedc_work,
    LAPACKE_dstegr,
    LAPACKE_dstegr_work,
    LAPACKE_dstein,
    LAPACKE_dstein_work,
    LAPACKE_dstemr,
    LAPACKE_dstemr_work,
    LAPACKE_dsteqr,
    LAPACKE_dsteqr_work,
    LAPACKE_dsterf,
    LAPACKE_dsterf_work,
    LAPACKE_dstev,
    LAPACKE_dstev_work,
    LAPACKE_dstevd,
    LAPACKE_dstevd_work,
    LAPACKE_dstevr,
    LAPACKE_dstevr_work,
    LAPACKE_dstevx,
    LAPACKE_dstevx_work,
    LAPACKE_dsycon,
    LAPACKE_dsycon_work,
    LAPACKE_dsyconv,
    LAPACKE_dsyconv_work,
    LAPACKE_dsyequb,
    LAPACKE_dsyequb_work,
    LAPACKE_dsyev,
    LAPACKE_dsyev_work,
    LAPACKE_dsyevd,
    LAPACKE_dsyevd_work,
    LAPACKE_dsyevr,
    LAPACKE_dsyevr_work,
    LAPACKE_dsyevx,
    LAPACKE_dsyevx_work,
    LAPACKE_dsygst,
    LAPACKE_dsygst_work,
    LAPACKE_dsygv,
    LAPACKE_dsygv_work,
    LAPACKE_dsygvd,
    LAPACKE_dsygvd_work,
    LAPACKE_dsygvx,
    LAPACKE_dsygvx_work,
    LAPACKE_dsyrfs,
    LAPACKE_dsyrfs_work,
    LAPACKE_dsysv,
    LAPACKE_dsysv_rook,
    LAPACKE_dsysv_rook_work,
    LAPACKE_dsysv_work,
    LAPACKE_dsysvx,
    LAPACKE_dsysvx_work,
    LAPACKE_dsyswapr,
    LAPACKE_dsyswapr_work,
    LAPACKE_dsytrd,
    LAPACKE_dsytrd_work,
    LAPACKE_dsytrf,
    LAPACKE_dsytrf_work,
    LAPACKE_dsytri,
    LAPACKE_dsytri2,
    LAPACKE_dsytri2_work,
    LAPACKE_dsytri2x,
    LAPACKE_dsytri2x_work,
    LAPACKE_dsytri_work,
    LAPACKE_dsytrs,
    LAPACKE_dsytrs2,
    LAPACKE_dsytrs2_work,
    LAPACKE_dsytrs_work,
    LAPACKE_dtbcon,
    LAPACKE_dtbcon_work,
    LAPACKE_dtbrfs,
    LAPACKE_dtbrfs_work,
    LAPACKE_dtbtrs,
    LAPACKE_dtbtrs_work,
    LAPACKE_dtfsm,
    LAPACKE_dtfsm_work,
    LAPACKE_dtftri,
    LAPACKE_dtftri_work,
    LAPACKE_dtfttp,
    LAPACKE_dtfttp_work,
    LAPACKE_dtfttr,
    LAPACKE_dtfttr_work,
    LAPACKE_dtgevc,
    LAPACKE_dtgevc_work,
    LAPACKE_dtgexc,
    LAPACKE_dtgexc_work,
    LAPACKE_dtgsen,
    LAPACKE_dtgsen_work,
    LAPACKE_dtgsja,
    LAPACKE_dtgsja_work,
    LAPACKE_dtgsna,
    LAPACKE_dtgsna_work,
    LAPACKE_dtgsyl,
    LAPACKE_dtgsyl_work,
    LAPACKE_dtpcon,
    LAPACKE_dtpcon_work,
    LAPACKE_dtpmqrt,
    LAPACKE_dtpmqrt_work,
    LAPACKE_dtpqrt,
    LAPACKE_dtpqrt2,
    LAPACKE_dtpqrt2_work,
    LAPACKE_dtpqrt_work,
    LAPACKE_dtprfb,
    LAPACKE_dtprfb_work,
    LAPACKE_dtprfs,
    LAPACKE_dtprfs_work,
    LAPACKE_dtptri,
    LAPACKE_dtptri_work,
    LAPACKE_dtptrs,
    LAPACKE_dtptrs_work,
    LAPACKE_dtpttf,
    LAPACKE_dtpttf_work,
    LAPACKE_dtpttr,
    LAPACKE_dtpttr_work,
    LAPACKE_dtrcon,
    LAPACKE_dtrcon_work,
    LAPACKE_dtrevc,
    LAPACKE_dtrevc_work,
    LAPACKE_dtrexc,
    LAPACKE_dtrexc_work,
    LAPACKE_dtrrfs,
    LAPACKE_dtrrfs_work,
    LAPACKE_dtrsen,
    LAPACKE_dtrsen_work,
    LAPACKE_dtrsna,
    LAPACKE_dtrsna_work,
    LAPACKE_dtrsyl,
    LAPACKE_dtrsyl_work,
    LAPACKE_dtrtri,
    LAPACKE_dtrtri_work,
    LAPACKE_dtrtrs,
    LAPACKE_dtrtrs_work,
    LAPACKE_dtrttf,
    LAPACKE_dtrttf_work,
    LAPACKE_dtrttp,
    LAPACKE_dtrttp_work,
    LAPACKE_dtzrzf,
    LAPACKE_dtzrzf_work,
    LAPACKE_dlatms,
    LAPACKE_dlatms_work,
    LAPACKE_dlagge,
    LAPACKE_dlagge_work,
    LAPACKE_dlagsy,
    LAPACKE_dlagsy_work,
    LAPACKE_dbdsvdx,
    LAPACKE_dbdsvdx_work,
    LAPACKE_dgesvdx,
    LAPACKE_dgesvdx_work,
    LAPACKE_dgetrf2,
    LAPACKE_dgetrf2_work,
    LAPACKE_dgges3,
    LAPACKE_dgges3_work,
    LAPACKE_dggev3,
    LAPACKE_dggev3_work,
    LAPACKE_dgghd3,
    LAPACKE_dgghd3_work,
    LAPACKE_dggsvd3,
    LAPACKE_dggsvd3_work,
    LAPACKE_dggsvp3,
    LAPACKE_dggsvp3_work,
    LAPACKE_dlapmt,
    LAPACKE_dlapmt_work,
    LAPACKE_dlascl,
    LAPACKE_dlascl_work,
    LAPACKE_dorcsd2by1,
    LAPACKE_dorcsd2by1_work,
    LAPACKE_dpotrf2,
    LAPACKE_dpotrf2_work,
    LAPACKE_dsytrf_rook,
    LAPACKE_dsytrf_rook_work,
    LAPACKE_dsytrs_rook,
    LAPACKE_dsytrs_rook_work,
    LAPACKE_dgelq,
    LAPACKE_dgelq_work,
    LAPACKE_dgemlq,
    LAPACKE_dgemlq_work,
    LAPACKE_dgemqr,
    LAPACKE_dgemqr_work,
    LAPACKE_dgeqr,
    LAPACKE_dgeqr_work,
    LAPACKE_dgetsls,
    LAPACKE_dgetsls_work,
    LAPACKE_dsbev_2stage,
    LAPACKE_dsbev_2stage_work,
    LAPACKE_dsbevd_2stage,
    LAPACKE_dsbevd_2stage_work,
    LAPACKE_dsbevx_2stage,
    LAPACKE_dsbevx_2stage_work,
    LAPACKE_dsycon_3,
    LAPACKE_dsycon_3_work,
    LAPACKE_dsyev_2stage,
    LAPACKE_dsyev_2stage_work,
    LAPACKE_dsyevd_2stage,
    LAPACKE_dsyevd_2stage_work,
    LAPACKE_dsyevr_2stage,
    LAPACKE_dsyevr_2stage_work,
    LAPACKE_dsyevx_2stage,
    LAPACKE_dsyevx_2stage_work,
    LAPACKE_dsygv_2stage,
    LAPACKE_dsygv_2stage_work,
    LAPACKE_dsysv_aa,
    LAPACKE_dsysv_aa_work,
    LAPACKE_dsysv_rk,
    LAPACKE_dsysv_rk_work,
    LAPACKE_dsytrf_aa,
    LAPACKE_dsytrf_aa_work,
    LAPACKE_dsytrf_rk,
    LAPACKE_dsytrf_rk_work,
    LAPACKE_dsytri_3,
    LAPACKE_dsytri_3_work,
    LAPACKE_dsytrs_aa,
    LAPACKE_dsytrs_aa_work,
    LAPACKE_dsytrs_3,
    LAPACKE_dsytrs_3_work,
    LAPACKE_dlassq,
    LAPACKE_dlassq_work,
    LAPACKE_dsysv_aa_2stage,
    LAPACKE_dsysv_aa_2stage_work,
    LAPACKE_dsytrf_aa_2stage,
    LAPACKE_dsytrf_aa_2stage_work,
    LAPACKE_dsytrs_aa_2stage,
    LAPACKE_dsytrs_aa_2stage_work,
    LAPACKE_dgesvdq,
    LAPACKE_dgesvdq_work,
    LAPACKE_slag2d,
    LAPACKE_slag2d_work,
    LAPACKE_dgetsqrhrt,
    LAPACKE_dgetsqrhrt_work,
    LAPACKE_dorgtsqr_row,
    LAPACKE_dorgtsqr_row_work,
    LAPACKE_dlangb,
    LAPACKE_dlangb_work,
    LAPACKE_dorhr_col,
    LAPACKE_dorhr_col_work,
    LAPACKE_dtrsyl3,
    LAPACKE_dtrsyl3_work,
    LAPACKE_dtz_nancheck,
    LAPACKE_dtz_trans,

);
@lapackeobjss = (
    LAPACKE_sgb_nancheck,
    LAPACKE_sgb_trans,
    LAPACKE_sge_nancheck,
    LAPACKE_sge_trans,
    LAPACKE_sgg_nancheck,
    LAPACKE_sgg_trans,
    LAPACKE_sgt_nancheck,
    LAPACKE_shs_nancheck,
    LAPACKE_shs_trans,
    LAPACKE_s_nancheck,
    LAPACKE_spb_nancheck,
    LAPACKE_spb_trans,
    LAPACKE_spf_nancheck,
    LAPACKE_spf_trans,
    LAPACKE_spo_nancheck,
    LAPACKE_spo_trans,
    LAPACKE_spp_nancheck,
    LAPACKE_spp_trans,
    LAPACKE_spt_nancheck,
    LAPACKE_ssb_nancheck,
    LAPACKE_ssb_trans,
    LAPACKE_ssp_nancheck,
    LAPACKE_ssp_trans,
    LAPACKE_sst_nancheck,
    LAPACKE_ssy_nancheck,
    LAPACKE_ssy_trans,
    LAPACKE_stb_nancheck,
    LAPACKE_stb_trans,
    LAPACKE_stf_nancheck,
    LAPACKE_stf_trans,
    LAPACKE_stp_nancheck,
    LAPACKE_stp_trans,
    LAPACKE_str_nancheck,
    LAPACKE_str_trans,
    LAPACKE_sbbcsd,
    LAPACKE_sbbcsd_work,
    LAPACKE_sbdsdc,
    LAPACKE_sbdsdc_work,
    LAPACKE_sbdsqr,
    LAPACKE_sbdsqr_work,
    LAPACKE_sdisna,
    LAPACKE_sdisna_work,
    LAPACKE_sgbbrd,
    LAPACKE_sgbbrd_work,
    LAPACKE_sgbcon,
    LAPACKE_sgbcon_work,
    LAPACKE_sgbequ,
    LAPACKE_sgbequ_work,
    LAPACKE_sgbequb,
    LAPACKE_sgbequb_work,
    LAPACKE_sgbrfs,
    LAPACKE_sgbrfs_work,
    LAPACKE_sgbsv,
    LAPACKE_sgbsv_work,
    LAPACKE_sgbsvx,
    LAPACKE_sgbsvx_work,
    LAPACKE_sgbtrf,
    LAPACKE_sgbtrf_work,
    LAPACKE_sgbtrs,
    LAPACKE_sgbtrs_work,
    LAPACKE_sgebak,
    LAPACKE_sgebak_work,
    LAPACKE_sgebal,
    LAPACKE_sgebal_work,
    LAPACKE_sgebrd,
    LAPACKE_sgebrd_work,
    LAPACKE_sgecon,
    LAPACKE_sgecon_work,
    LAPACKE_sgedmd,
    LAPACKE_sgedmd_work,
    LAPACKE_sgedmdq,
    LAPACKE_sgedmdq_work,
    LAPACKE_sgeequ,
    LAPACKE_sgeequ_work,
    LAPACKE_sgeequb,
    LAPACKE_sgeequb_work,
    LAPACKE_sgees,
    LAPACKE_sgees_work,
    LAPACKE_sgeesx,
    LAPACKE_sgeesx_work,
    LAPACKE_sgeev,
    LAPACKE_sgeev_work,
    LAPACKE_sgeevx,
    LAPACKE_sgeevx_work,
    LAPACKE_sgehrd,
    LAPACKE_sgehrd_work,
    LAPACKE_sgejsv,
    LAPACKE_sgejsv_work,
    LAPACKE_sgelq2,
    LAPACKE_sgelq2_work,
    LAPACKE_sgelqf,
    LAPACKE_sgelqf_work,
    LAPACKE_sgels,
    LAPACKE_sgels_work,
    LAPACKE_sgelsd,
    LAPACKE_sgelsd_work,
    LAPACKE_sgelss,
    LAPACKE_sgelss_work,
    LAPACKE_sgelsy,
    LAPACKE_sgelsy_work,
    LAPACKE_sgemqrt,
    LAPACKE_sgemqrt_work,
    LAPACKE_sgeqlf,
    LAPACKE_sgeqlf_work,
    LAPACKE_sgeqp3,
    LAPACKE_sgeqp3_work,
    LAPACKE_sgeqr2,
    LAPACKE_sgeqr2_work,
    LAPACKE_sgeqrf,
    LAPACKE_sgeqrf_work,
    LAPACKE_sgeqrfp,
    LAPACKE_sgeqrfp_work,
    LAPACKE_sgeqrt,
    LAPACKE_sgeqrt2,
    LAPACKE_sgeqrt2_work,
    LAPACKE_sgeqrt3,
    LAPACKE_sgeqrt3_work,
    LAPACKE_sgeqrt_work,
    LAPACKE_sgerfs,
    LAPACKE_sgerfs_work,
    LAPACKE_sgerqf,
    LAPACKE_sgerqf_work,
    LAPACKE_sgesdd,
    LAPACKE_sgesdd_work,
    LAPACKE_sgesv,
    LAPACKE_sgesv_work,
    LAPACKE_sgesvd,
    LAPACKE_sgesvd_work,
    LAPACKE_sgesvj,
    LAPACKE_sgesvj_work,
    LAPACKE_sgesvx,
    LAPACKE_sgesvx_work,
    LAPACKE_sgetf2,
    LAPACKE_sgetf2_work,
    LAPACKE_sgetrf,
    LAPACKE_sgetrf_work,
    LAPACKE_sgetri,
    LAPACKE_sgetri_work,
    LAPACKE_sgetrs,
    LAPACKE_sgetrs_work,
    LAPACKE_sggbak,
    LAPACKE_sggbak_work,
    LAPACKE_sggbal,
    LAPACKE_sggbal_work,
    LAPACKE_sgges,
    LAPACKE_sgges_work,
    LAPACKE_sggesx,
    LAPACKE_sggesx_work,
    LAPACKE_sggev,
    LAPACKE_sggev_work,
    LAPACKE_sggevx,
    LAPACKE_sggevx_work,
    LAPACKE_sggglm,
    LAPACKE_sggglm_work,
    LAPACKE_sgghrd,
    LAPACKE_sgghrd_work,
    LAPACKE_sgglse,
    LAPACKE_sgglse_work,
    LAPACKE_sggqrf,
    LAPACKE_sggqrf_work,
    LAPACKE_sggrqf,
    LAPACKE_sggrqf_work,
    LAPACKE_sgtcon,
    LAPACKE_sgtcon_work,
    LAPACKE_sgtrfs,
    LAPACKE_sgtrfs_work,
    LAPACKE_sgtsv,
    LAPACKE_sgtsv_work,
    LAPACKE_sgtsvx,
    LAPACKE_sgtsvx_work,
    LAPACKE_sgttrf,
    LAPACKE_sgttrf_work,
    LAPACKE_sgttrs,
    LAPACKE_sgttrs_work,
    LAPACKE_shgeqz,
    LAPACKE_shgeqz_work,
    LAPACKE_shsein,
    LAPACKE_shsein_work,
    LAPACKE_shseqr,
    LAPACKE_shseqr_work,
    LAPACKE_slacn2,
    LAPACKE_slacn2_work,
    LAPACKE_slacpy,
    LAPACKE_slacpy_work,
    LAPACKE_slamch,
    LAPACKE_slamch_work,
    LAPACKE_slange,
    LAPACKE_slange_work,
    LAPACKE_slansy,
    LAPACKE_slansy_work,
    LAPACKE_slantr,
    LAPACKE_slantr_work,
    LAPACKE_slapmr,
    LAPACKE_slapmr_work,
    LAPACKE_slapy2,
    LAPACKE_slapy2_work,
    LAPACKE_slapy3,
    LAPACKE_slapy3_work,
    LAPACKE_slarfb,
    LAPACKE_slarfb_work,
    LAPACKE_slarfg,
    LAPACKE_slarfg_work,
    LAPACKE_slarft,
    LAPACKE_slarft_work,
    LAPACKE_slarfx,
    LAPACKE_slarfx_work,
    LAPACKE_slarnv,
    LAPACKE_slarnv_work,
    LAPACKE_slartgp,
    LAPACKE_slartgp_work,
    LAPACKE_slartgs,
    LAPACKE_slartgs_work,
    LAPACKE_slaset,
    LAPACKE_slaset_work,
    LAPACKE_slasrt,
    LAPACKE_slasrt_work,
    LAPACKE_slaswp,
    LAPACKE_slaswp_work,
    LAPACKE_slauum,
    LAPACKE_slauum_work,
    LAPACKE_sopgtr,
    LAPACKE_sopgtr_work,
    LAPACKE_sopmtr,
    LAPACKE_sopmtr_work,
    LAPACKE_sorbdb,
    LAPACKE_sorbdb_work,
    LAPACKE_sorcsd,
    LAPACKE_sorcsd_work,
    LAPACKE_sorgbr,
    LAPACKE_sorgbr_work,
    LAPACKE_sorghr,
    LAPACKE_sorghr_work,
    LAPACKE_sorglq,
    LAPACKE_sorglq_work,
    LAPACKE_sorgql,
    LAPACKE_sorgql_work,
    LAPACKE_sorgqr,
    LAPACKE_sorgqr_work,
    LAPACKE_sorgrq,
    LAPACKE_sorgrq_work,
    LAPACKE_sorgtr,
    LAPACKE_sorgtr_work,
    LAPACKE_sormbr,
    LAPACKE_sormbr_work,
    LAPACKE_sormhr,
    LAPACKE_sormhr_work,
    LAPACKE_sormlq,
    LAPACKE_sormlq_work,
    LAPACKE_sormql,
    LAPACKE_sormql_work,
    LAPACKE_sormqr,
    LAPACKE_sormqr_work,
    LAPACKE_sormrq,
    LAPACKE_sormrq_work,
    LAPACKE_sormrz,
    LAPACKE_sormrz_work,
    LAPACKE_sormtr,
    LAPACKE_sormtr_work,
    LAPACKE_spbcon,
    LAPACKE_spbcon_work,
    LAPACKE_spbequ,
    LAPACKE_spbequ_work,
    LAPACKE_spbrfs,
    LAPACKE_spbrfs_work,
    LAPACKE_spbstf,
    LAPACKE_spbstf_work,
    LAPACKE_spbsv,
    LAPACKE_spbsv_work,
    LAPACKE_spbsvx,
    LAPACKE_spbsvx_work,
    LAPACKE_spbtrf,
    LAPACKE_spbtrf_work,
    LAPACKE_spbtrs,
    LAPACKE_spbtrs_work,
    LAPACKE_spftrf,
    LAPACKE_spftrf_work,
    LAPACKE_spftri,
    LAPACKE_spftri_work,
    LAPACKE_spftrs,
    LAPACKE_spftrs_work,
    LAPACKE_spocon,
    LAPACKE_spocon_work,
    LAPACKE_spoequ,
    LAPACKE_spoequ_work,
    LAPACKE_spoequb,
    LAPACKE_spoequb_work,
    LAPACKE_sporfs,
    LAPACKE_sporfs_work,
    LAPACKE_sposv,
    LAPACKE_sposv_work,
    LAPACKE_sposvx,
    LAPACKE_sposvx_work,
    LAPACKE_spotrf,
    LAPACKE_spotrf_work,
    LAPACKE_spotri,
    LAPACKE_spotri_work,
    LAPACKE_spotrs,
    LAPACKE_spotrs_work,
    LAPACKE_sppcon,
    LAPACKE_sppcon_work,
    LAPACKE_sppequ,
    LAPACKE_sppequ_work,
    LAPACKE_spprfs,
    LAPACKE_spprfs_work,
    LAPACKE_sppsv,
    LAPACKE_sppsv_work,
    LAPACKE_sppsvx,
    LAPACKE_sppsvx_work,
    LAPACKE_spptrf,
    LAPACKE_spptrf_work,
    LAPACKE_spptri,
    LAPACKE_spptri_work,
    LAPACKE_spptrs,
    LAPACKE_spptrs_work,
    LAPACKE_spstrf,
    LAPACKE_spstrf_work,
    LAPACKE_sptcon,
    LAPACKE_sptcon_work,
    LAPACKE_spteqr,
    LAPACKE_spteqr_work,
    LAPACKE_sptrfs,
    LAPACKE_sptrfs_work,
    LAPACKE_sptsv,
    LAPACKE_sptsv_work,
    LAPACKE_sptsvx,
    LAPACKE_sptsvx_work,
    LAPACKE_spttrf,
    LAPACKE_spttrf_work,
    LAPACKE_spttrs,
    LAPACKE_spttrs_work,
    LAPACKE_ssbev,
    LAPACKE_ssbev_work,
    LAPACKE_ssbevd,
    LAPACKE_ssbevd_work,
    LAPACKE_ssbevx,
    LAPACKE_ssbevx_work,
    LAPACKE_ssbgst,
    LAPACKE_ssbgst_work,
    LAPACKE_ssbgv,
    LAPACKE_ssbgv_work,
    LAPACKE_ssbgvd,
    LAPACKE_ssbgvd_work,
    LAPACKE_ssbgvx,
    LAPACKE_ssbgvx_work,
    LAPACKE_ssbtrd,
    LAPACKE_ssbtrd_work,
    LAPACKE_ssfrk,
    LAPACKE_ssfrk_work,
    LAPACKE_sspcon,
    LAPACKE_sspcon_work,
    LAPACKE_sspev,
    LAPACKE_sspev_work,
    LAPACKE_sspevd,
    LAPACKE_sspevd_work,
    LAPACKE_sspevx,
    LAPACKE_sspevx_work,
    LAPACKE_sspgst,
    LAPACKE_sspgst_work,
    LAPACKE_sspgv,
    LAPACKE_sspgv_work,
    LAPACKE_sspgvd,
    LAPACKE_sspgvd_work,
    LAPACKE_sspgvx,
    LAPACKE_sspgvx_work,
    LAPACKE_ssprfs,
    LAPACKE_ssprfs_work,
    LAPACKE_sspsv,
    LAPACKE_sspsv_work,
    LAPACKE_sspsvx,
    LAPACKE_sspsvx_work,
    LAPACKE_ssptrd,
    LAPACKE_ssptrd_work,
    LAPACKE_ssptrf,
    LAPACKE_ssptrf_work,
    LAPACKE_ssptri,
    LAPACKE_ssptri_work,
    LAPACKE_ssptrs,
    LAPACKE_ssptrs_work,
    LAPACKE_sstebz,
    LAPACKE_sstebz_work,
    LAPACKE_sstedc,
    LAPACKE_sstedc_work,
    LAPACKE_sstegr,
    LAPACKE_sstegr_work,
    LAPACKE_sstein,
    LAPACKE_sstein_work,
    LAPACKE_sstemr,
    LAPACKE_sstemr_work,
    LAPACKE_ssteqr,
    LAPACKE_ssteqr_work,
    LAPACKE_ssterf,
    LAPACKE_ssterf_work,
    LAPACKE_sstev,
    LAPACKE_sstev_work,
    LAPACKE_sstevd,
    LAPACKE_sstevd_work,
    LAPACKE_sstevr,
    LAPACKE_sstevr_work,
    LAPACKE_sstevx,
    LAPACKE_sstevx_work,
    LAPACKE_ssycon,
    LAPACKE_ssycon_work,
    LAPACKE_ssyconv,
    LAPACKE_ssyconv_work,
    LAPACKE_ssyequb,
    LAPACKE_ssyequb_work,
    LAPACKE_ssyev,
    LAPACKE_ssyev_work,
    LAPACKE_ssyevd,
    LAPACKE_ssyevd_work,
    LAPACKE_ssyevr,
    LAPACKE_ssyevr_work,
    LAPACKE_ssyevx,
    LAPACKE_ssyevx_work,
    LAPACKE_ssygst,
    LAPACKE_ssygst_work,
    LAPACKE_ssygv,
    LAPACKE_ssygv_work,
    LAPACKE_ssygvd,
    LAPACKE_ssygvd_work,
    LAPACKE_ssygvx,
    LAPACKE_ssygvx_work,
    LAPACKE_ssyrfs,
    LAPACKE_ssyrfs_work,
    LAPACKE_ssysv,
    LAPACKE_ssysv_rook,
    LAPACKE_ssysv_rook_work,
    LAPACKE_ssysv_work,
    LAPACKE_ssysvx,
    LAPACKE_ssysvx_work,
    LAPACKE_ssyswapr,
    LAPACKE_ssyswapr_work,
    LAPACKE_ssytrd,
    LAPACKE_ssytrd_work,
    LAPACKE_ssytrf,
    LAPACKE_ssytrf_work,
    LAPACKE_ssytri,
    LAPACKE_ssytri2,
    LAPACKE_ssytri2_work,
    LAPACKE_ssytri2x,
    LAPACKE_ssytri2x_work,
    LAPACKE_ssytri_work,
    LAPACKE_ssytrs,
    LAPACKE_ssytrs2,
    LAPACKE_ssytrs2_work,
    LAPACKE_ssytrs_work,
    LAPACKE_stbcon,
    LAPACKE_stbcon_work,
    LAPACKE_stbrfs,
    LAPACKE_stbrfs_work,
    LAPACKE_stbtrs,
    LAPACKE_stbtrs_work,
    LAPACKE_stfsm,
    LAPACKE_stfsm_work,
    LAPACKE_stftri,
    LAPACKE_stftri_work,
    LAPACKE_stfttp,
    LAPACKE_stfttp_work,
    LAPACKE_stfttr,
    LAPACKE_stfttr_work,
    LAPACKE_stgevc,
    LAPACKE_stgevc_work,
    LAPACKE_stgexc,
    LAPACKE_stgexc_work,
    LAPACKE_stgsen,
    LAPACKE_stgsen_work,
    LAPACKE_stgsja,
    LAPACKE_stgsja_work,
    LAPACKE_stgsna,
    LAPACKE_stgsna_work,
    LAPACKE_stgsyl,
    LAPACKE_stgsyl_work,
    LAPACKE_stpcon,
    LAPACKE_stpcon_work,
    LAPACKE_stpmqrt,
    LAPACKE_stpmqrt_work,
    LAPACKE_stpqrt2,
    LAPACKE_stpqrt2_work,
    LAPACKE_stprfb,
    LAPACKE_stprfb_work,
    LAPACKE_stprfs,
    LAPACKE_stprfs_work,
    LAPACKE_stptri,
    LAPACKE_stptri_work,
    LAPACKE_stptrs,
    LAPACKE_stptrs_work,
    LAPACKE_stpttf,
    LAPACKE_stpttf_work,
    LAPACKE_stpttr,
    LAPACKE_stpttr_work,
    LAPACKE_strcon,
    LAPACKE_strcon_work,
    LAPACKE_strevc,
    LAPACKE_strevc_work,
    LAPACKE_strexc,
    LAPACKE_strexc_work,
    LAPACKE_strrfs,
    LAPACKE_strrfs_work,
    LAPACKE_strsen,
    LAPACKE_strsen_work,
    LAPACKE_strsna,
    LAPACKE_strsna_work,
    LAPACKE_strsyl,
    LAPACKE_strsyl_work,
    LAPACKE_strtri,
    LAPACKE_strtri_work,
    LAPACKE_strtrs,
    LAPACKE_strtrs_work,
    LAPACKE_strttf,
    LAPACKE_strttf_work,
    LAPACKE_strttp,
    LAPACKE_strttp_work,
    LAPACKE_stzrzf,
    LAPACKE_stzrzf_work,
    LAPACKE_slatms,
    LAPACKE_slatms_work,
    LAPACKE_slagge,
    LAPACKE_slagge_work,
    LAPACKE_slagsy,
    LAPACKE_slagsy_work,
    LAPACKE_sbdsvdx,
    LAPACKE_sbdsvdx_work,
    LAPACKE_sgesvdx,
    LAPACKE_sgesvdx_work,
    LAPACKE_sgetrf2,
    LAPACKE_sgetrf2_work,
    LAPACKE_sgges3,
    LAPACKE_sgges3_work,
    LAPACKE_sggev3,
    LAPACKE_sggev3_work,
    LAPACKE_sgghd3,
    LAPACKE_sgghd3_work,
    LAPACKE_sggsvd3,
    LAPACKE_sggsvd3_work,
    LAPACKE_sggsvp3,
    LAPACKE_sggsvp3_work,
    LAPACKE_slapmt,
    LAPACKE_slapmt_work,
    LAPACKE_slascl,
    LAPACKE_slascl_work,
    LAPACKE_sorcsd2by1,
    LAPACKE_sorcsd2by1_work,
    LAPACKE_spotrf2,
    LAPACKE_spotrf2_work,
    LAPACKE_ssytrf_rook,
    LAPACKE_ssytrf_rook_work,
    LAPACKE_ssytrs_rook,
    LAPACKE_ssytrs_rook_work,
    LAPACKE_stpqrt,
    LAPACKE_stpqrt_work,
    LAPACKE_sgelq,
    LAPACKE_sgelq_work,
    LAPACKE_sgemlq,
    LAPACKE_sgemlq_work,
    LAPACKE_sgemqr,
    LAPACKE_sgemqr_work,
    LAPACKE_sgeqr,
    LAPACKE_sgeqr_work,
    LAPACKE_sgetsls,
    LAPACKE_sgetsls_work,
    LAPACKE_ssbev_2stage,
    LAPACKE_ssbev_2stage_work,
    LAPACKE_ssbevd_2stage,
    LAPACKE_ssbevd_2stage_work,
    LAPACKE_ssbevx_2stage,
    LAPACKE_ssbevx_2stage_work,
    LAPACKE_ssycon_3,
    LAPACKE_ssycon_3_work,
    LAPACKE_ssyev_2stage,
    LAPACKE_ssyev_2stage_work,
    LAPACKE_ssyevd_2stage,
    LAPACKE_ssyevd_2stage_work,
    LAPACKE_ssyevr_2stage,
    LAPACKE_ssyevr_2stage_work,
    LAPACKE_ssyevx_2stage,
    LAPACKE_ssyevx_2stage_work,
    LAPACKE_ssygv_2stage,
    LAPACKE_ssygv_2stage_work,
    LAPACKE_ssysv_aa,
    LAPACKE_ssysv_aa_work,
    LAPACKE_ssysv_rk,
    LAPACKE_ssysv_rk_work,
    LAPACKE_ssytrf_aa,
    LAPACKE_ssytrf_aa_work,
    LAPACKE_ssytrf_rk,
    LAPACKE_ssytrf_rk_work,
    LAPACKE_ssytri_3,
    LAPACKE_ssytri_3_work,
    LAPACKE_ssytrs_aa,
    LAPACKE_ssytrs_aa_work,
    LAPACKE_ssytrs_3,
    LAPACKE_ssytrs_3_work,
    LAPACKE_slassq,
    LAPACKE_slassq_work,
    LAPACKE_ssysv_aa_2stage,
    LAPACKE_ssysv_aa_2stage_work,
    LAPACKE_ssytrf_aa_2stage,
    LAPACKE_ssytrf_aa_2stage_work,
    LAPACKE_ssytrs_aa_2stage,
    LAPACKE_ssytrs_aa_2stage_work,
    LAPACKE_sgesvdq,
    LAPACKE_sgesvdq_work,
    LAPACKE_sgetsqrhrt,
    LAPACKE_sgetsqrhrt_work,
    LAPACKE_sorgtsqr_row,
    LAPACKE_sorgtsqr_row_work,
    LAPACKE_slangb,
    LAPACKE_slangb_work,
    LAPACKE_sorhr_col,
    LAPACKE_sorhr_col_work,
    LAPACKE_strsyl3,
    LAPACKE_strsyl3_work,
    LAPACKE_stz_nancheck,
    LAPACKE_stz_trans,

);
@lapackeobjsz = (    
    LAPACKE_zgb_nancheck,
    LAPACKE_zgb_trans,
    LAPACKE_zge_nancheck,
    LAPACKE_zge_trans,
    LAPACKE_zgg_nancheck,
    LAPACKE_zgg_trans,
    LAPACKE_zgt_nancheck,
    LAPACKE_zhb_nancheck,
    LAPACKE_zhb_trans,
    LAPACKE_zhe_nancheck,
    LAPACKE_zhe_trans,
    LAPACKE_zhp_nancheck,
    LAPACKE_zhp_trans,
    LAPACKE_zhs_nancheck,
    LAPACKE_zhs_trans,
    LAPACKE_z_nancheck,
    LAPACKE_zpb_nancheck,
    LAPACKE_zpb_trans,
    LAPACKE_zpf_nancheck,
    LAPACKE_zpf_trans,
    LAPACKE_zpo_nancheck,
    LAPACKE_zpo_trans,
    LAPACKE_zpp_nancheck,
    LAPACKE_zpp_trans,
    LAPACKE_zpt_nancheck,
    LAPACKE_zsp_nancheck,
    LAPACKE_zsp_trans,
    LAPACKE_zst_nancheck,
    LAPACKE_zsy_nancheck,
    LAPACKE_zsy_trans,
    LAPACKE_ztb_nancheck,
    LAPACKE_ztb_trans,
    LAPACKE_ztf_nancheck,
    LAPACKE_ztf_trans,
    LAPACKE_ztp_nancheck,
    LAPACKE_ztp_trans,
    LAPACKE_ztr_nancheck,
    LAPACKE_ztr_trans,
    LAPACKE_zbbcsd,
    LAPACKE_zbbcsd_work,
    LAPACKE_zbdsqr,
    LAPACKE_zbdsqr_work,
    LAPACKE_zcgesv,
    LAPACKE_zcgesv_work,
    LAPACKE_zcposv,
    LAPACKE_zcposv_work,
    LAPACKE_zgbbrd,
    LAPACKE_zgbbrd_work,
    LAPACKE_zgbcon,
    LAPACKE_zgbcon_work,
    LAPACKE_zgbequ,
    LAPACKE_zgbequ_work,
    LAPACKE_zgbequb,
    LAPACKE_zgbequb_work,
    LAPACKE_zgbrfs,
    LAPACKE_zgbrfs_work,
    LAPACKE_zgbsv,
    LAPACKE_zgbsv_work,
    LAPACKE_zgbsvx,
    LAPACKE_zgbsvx_work,
    LAPACKE_zgbtrf,
    LAPACKE_zgbtrf_work,
    LAPACKE_zgbtrs,
    LAPACKE_zgbtrs_work,
    LAPACKE_zgebak,
    LAPACKE_zgebak_work,
    LAPACKE_zgebal,
    LAPACKE_zgebal_work,
    LAPACKE_zgebrd,
    LAPACKE_zgebrd_work,
    LAPACKE_zgecon,
    LAPACKE_zgecon_work,
    LAPACKE_zgedmd,
    LAPACKE_zgedmd_work,
    LAPACKE_zgedmdq,
    LAPACKE_zgedmdq_work,
    LAPACKE_zgeequ,
    LAPACKE_zgeequ_work,
    LAPACKE_zgeequb,
    LAPACKE_zgeequb_work,
    LAPACKE_zgees,
    LAPACKE_zgees_work,
    LAPACKE_zgeesx,
    LAPACKE_zgeesx_work,
    LAPACKE_zgeev,
    LAPACKE_zgeev_work,
    LAPACKE_zgeevx,
    LAPACKE_zgeevx_work,
    LAPACKE_zgehrd,
    LAPACKE_zgehrd_work,
    LAPACKE_zgelq2,
    LAPACKE_zgelq2_work,
    LAPACKE_zgelqf,
    LAPACKE_zgelqf_work,
    LAPACKE_zgels,
    LAPACKE_zgels_work,
    LAPACKE_zgelsd,
    LAPACKE_zgelsd_work,
    LAPACKE_zgelss,
    LAPACKE_zgelss_work,
    LAPACKE_zgelsy,
    LAPACKE_zgelsy_work,
    LAPACKE_zgemqrt,
    LAPACKE_zgemqrt_work,
    LAPACKE_zgeqlf,
    LAPACKE_zgeqlf_work,
    LAPACKE_zgeqp3,
    LAPACKE_zgeqp3_work,
    LAPACKE_zgeqr2,
    LAPACKE_zgeqr2_work,
    LAPACKE_zgeqrf,
    LAPACKE_zgeqrf_work,
    LAPACKE_zgeqrfp,
    LAPACKE_zgeqrfp_work,
    LAPACKE_zgeqrt,
    LAPACKE_zgeqrt2,
    LAPACKE_zgeqrt2_work,
    LAPACKE_zgeqrt3,
    LAPACKE_zgeqrt3_work,
    LAPACKE_zgeqrt_work,
    LAPACKE_zgerfs,
    LAPACKE_zgerfs_work,
    LAPACKE_zgerqf,
    LAPACKE_zgerqf_work,
    LAPACKE_zgesdd,
    LAPACKE_zgesdd_work,
    LAPACKE_zgesv,
    LAPACKE_zgesv_work,
    LAPACKE_zgesvd,
    LAPACKE_zgesvd_work,
    LAPACKE_zgesvx,
    LAPACKE_zgesvx_work,
    LAPACKE_zgetf2,
    LAPACKE_zgetf2_work,
    LAPACKE_zgetrf,
    LAPACKE_zgetrf_work,
    LAPACKE_zgetri,
    LAPACKE_zgetri_work,
    LAPACKE_zgetrs,
    LAPACKE_zgetrs_work,
    LAPACKE_zggbak,
    LAPACKE_zggbak_work,
    LAPACKE_zggbal,
    LAPACKE_zggbal_work,
    LAPACKE_zgges,
    LAPACKE_zgges_work,
    LAPACKE_zggesx,
    LAPACKE_zggesx_work,
    LAPACKE_zggev,
    LAPACKE_zggev_work,
    LAPACKE_zggevx,
    LAPACKE_zggevx_work,
    LAPACKE_zggglm,
    LAPACKE_zggglm_work,
    LAPACKE_zgghrd,
    LAPACKE_zgghrd_work,
    LAPACKE_zgglse,
    LAPACKE_zgglse_work,
    LAPACKE_zggqrf,
    LAPACKE_zggqrf_work,
    LAPACKE_zggrqf,
    LAPACKE_zggrqf_work,
    LAPACKE_zgtcon,
    LAPACKE_zgtcon_work,
    LAPACKE_zgtrfs,
    LAPACKE_zgtrfs_work,
    LAPACKE_zgtsv,
    LAPACKE_zgtsv_work,
    LAPACKE_zgtsvx,
    LAPACKE_zgtsvx_work,
    LAPACKE_zgttrf,
    LAPACKE_zgttrf_work,
    LAPACKE_zgttrs,
    LAPACKE_zgttrs_work,
    LAPACKE_zhbev,
    LAPACKE_zhbev_work,
    LAPACKE_zhbevd,
    LAPACKE_zhbevd_work,
    LAPACKE_zhbevx,
    LAPACKE_zhbevx_work,
    LAPACKE_zhbgst,
    LAPACKE_zhbgst_work,
    LAPACKE_zhbgv,
    LAPACKE_zhbgv_work,
    LAPACKE_zhbgvd,
    LAPACKE_zhbgvd_work,
    LAPACKE_zhbgvx,
    LAPACKE_zhbgvx_work,
    LAPACKE_zhbtrd,
    LAPACKE_zhbtrd_work,
    LAPACKE_zhecon,
    LAPACKE_zhecon_work,
    LAPACKE_zheequb,
    LAPACKE_zheequb_work,
    LAPACKE_zheev,
    LAPACKE_zheev_work,
    LAPACKE_zheevd,
    LAPACKE_zheevd_work,
    LAPACKE_zheevr,
    LAPACKE_zheevr_work,
    LAPACKE_zheevx,
    LAPACKE_zheevx_work,
    LAPACKE_zhegst,
    LAPACKE_zhegst_work,
    LAPACKE_zhegv,
    LAPACKE_zhegv_work,
    LAPACKE_zhegvd,
    LAPACKE_zhegvd_work,
    LAPACKE_zhegvx,
    LAPACKE_zhegvx_work,
    LAPACKE_zherfs,
    LAPACKE_zherfs_work,
    LAPACKE_zhesv,
    LAPACKE_zhesv_work,
    LAPACKE_zhesvx,
    LAPACKE_zhesvx_work,
    LAPACKE_zheswapr,
    LAPACKE_zheswapr_work,
    LAPACKE_zhetrd,
    LAPACKE_zhetrd_work,
    LAPACKE_zhetrf,
    LAPACKE_zhetrf_work,
    LAPACKE_zhetri,
    LAPACKE_zhetri2,
    LAPACKE_zhetri2_work,
    LAPACKE_zhetri2x,
    LAPACKE_zhetri2x_work,
    LAPACKE_zhetri_work,
    LAPACKE_zhetrs,
    LAPACKE_zhetrs2,
    LAPACKE_zhetrs2_work,
    LAPACKE_zhetrs_work,
    LAPACKE_zhfrk,
    LAPACKE_zhfrk_work,
    LAPACKE_zhgeqz,
    LAPACKE_zhgeqz_work,
    LAPACKE_zhpcon,
    LAPACKE_zhpcon_work,
    LAPACKE_zhpev,
    LAPACKE_zhpev_work,
    LAPACKE_zhpevd,
    LAPACKE_zhpevd_work,
    LAPACKE_zhpevx,
    LAPACKE_zhpevx_work,
    LAPACKE_zhpgst,
    LAPACKE_zhpgst_work,
    LAPACKE_zhpgv,
    LAPACKE_zhpgv_work,
    LAPACKE_zhpgvd,
    LAPACKE_zhpgvd_work,
    LAPACKE_zhpgvx,
    LAPACKE_zhpgvx_work,
    LAPACKE_zhprfs,
    LAPACKE_zhprfs_work,
    LAPACKE_zhpsv,
    LAPACKE_zhpsv_work,
    LAPACKE_zhpsvx,
    LAPACKE_zhpsvx_work,
    LAPACKE_zhptrd,
    LAPACKE_zhptrd_work,
    LAPACKE_zhptrf,
    LAPACKE_zhptrf_work,
    LAPACKE_zhptri,
    LAPACKE_zhptri_work,
    LAPACKE_zhptrs,
    LAPACKE_zhptrs_work,
    LAPACKE_zhsein,
    LAPACKE_zhsein_work,
    LAPACKE_zhseqr,
    LAPACKE_zhseqr_work,
    LAPACKE_zlacgv,
    LAPACKE_zlacgv_work,
    LAPACKE_zlacn2,
    LAPACKE_zlacn2_work,
    LAPACKE_zlacp2,
    LAPACKE_zlacp2_work,
    LAPACKE_zlacpy,
    LAPACKE_zlacpy_work,
    LAPACKE_zlag2c,
    LAPACKE_zlag2c_work,
    LAPACKE_zlange,
    LAPACKE_zlange_work,
    LAPACKE_zlanhe,
    LAPACKE_zlanhe_work,
    LAPACKE_zlansy,
    LAPACKE_zlansy_work,
    LAPACKE_zlantr,
    LAPACKE_zlantr_work,
    LAPACKE_zlapmr,
    LAPACKE_zlapmr_work,
    LAPACKE_zlarfb,
    LAPACKE_zlarfb_work,
    LAPACKE_zlarfg,
    LAPACKE_zlarfg_work,
    LAPACKE_zlarft,
    LAPACKE_zlarft_work,
    LAPACKE_zlarfx,
    LAPACKE_zlarfx_work,
    LAPACKE_zlarnv,
    LAPACKE_zlarnv_work,
    LAPACKE_zlaset,
    LAPACKE_zlaset_work,
    LAPACKE_zlaswp,
    LAPACKE_zlaswp_work,
    LAPACKE_zlauum,
    LAPACKE_zlauum_work,
    LAPACKE_zpbcon,
    LAPACKE_zpbcon_work,
    LAPACKE_zpbequ,
    LAPACKE_zpbequ_work,
    LAPACKE_zpbrfs,
    LAPACKE_zpbrfs_work,
    LAPACKE_zpbstf,
    LAPACKE_zpbstf_work,
    LAPACKE_zpbsv,
    LAPACKE_zpbsv_work,
    LAPACKE_zpbsvx,
    LAPACKE_zpbsvx_work,
    LAPACKE_zpbtrf,
    LAPACKE_zpbtrf_work,
    LAPACKE_zpbtrs,
    LAPACKE_zpbtrs_work,
    LAPACKE_zpftrf,
    LAPACKE_zpftrf_work,
    LAPACKE_zpftri,
    LAPACKE_zpftri_work,
    LAPACKE_zpftrs,
    LAPACKE_zpftrs_work,
    LAPACKE_zpocon,
    LAPACKE_zpocon_work,
    LAPACKE_zpoequ,
    LAPACKE_zpoequ_work,
    LAPACKE_zpoequb,
    LAPACKE_zpoequb_work,
    LAPACKE_zporfs,
    LAPACKE_zporfs_work,
    LAPACKE_zposv,
    LAPACKE_zposv_work,
    LAPACKE_zposvx,
    LAPACKE_zposvx_work,
    LAPACKE_zpotrf,
    LAPACKE_zpotrf_work,
    LAPACKE_zpotri,
    LAPACKE_zpotri_work,
    LAPACKE_zpotrs,
    LAPACKE_zpotrs_work,
    LAPACKE_zppcon,
    LAPACKE_zppcon_work,
    LAPACKE_zppequ,
    LAPACKE_zppequ_work,
    LAPACKE_zpprfs,
    LAPACKE_zpprfs_work,
    LAPACKE_zppsv,
    LAPACKE_zppsv_work,
    LAPACKE_zppsvx,
    LAPACKE_zppsvx_work,
    LAPACKE_zpptrf,
    LAPACKE_zpptrf_work,
    LAPACKE_zpptri,
    LAPACKE_zpptri_work,
    LAPACKE_zpptrs,
    LAPACKE_zpptrs_work,
    LAPACKE_zpstrf,
    LAPACKE_zpstrf_work,
    LAPACKE_zptcon,
    LAPACKE_zptcon_work,
    LAPACKE_zpteqr,
    LAPACKE_zpteqr_work,
    LAPACKE_zptrfs,
    LAPACKE_zptrfs_work,
    LAPACKE_zptsv,
    LAPACKE_zptsv_work,
    LAPACKE_zptsvx,
    LAPACKE_zptsvx_work,
    LAPACKE_zpttrf,
    LAPACKE_zpttrf_work,
    LAPACKE_zpttrs,
    LAPACKE_zpttrs_work,
    LAPACKE_zspcon,
    LAPACKE_zspcon_work,
    LAPACKE_zsprfs,
    LAPACKE_zsprfs_work,
    LAPACKE_zspsv,
    LAPACKE_zspsv_work,
    LAPACKE_zspsvx,
    LAPACKE_zspsvx_work,
    LAPACKE_zsptrf,
    LAPACKE_zsptrf_work,
    LAPACKE_zsptri,
    LAPACKE_zsptri_work,
    LAPACKE_zsptrs,
    LAPACKE_zsptrs_work,
    LAPACKE_zstedc,
    LAPACKE_zstedc_work,
    LAPACKE_zstegr,
    LAPACKE_zstegr_work,
    LAPACKE_zstein,
    LAPACKE_zstein_work,
    LAPACKE_zstemr,
    LAPACKE_zstemr_work,
    LAPACKE_zsteqr,
    LAPACKE_zsteqr_work,
    LAPACKE_zsycon,
    LAPACKE_zsycon_work,
    LAPACKE_zsyconv,
    LAPACKE_zsyconv_work,
    LAPACKE_zsyequb,
    LAPACKE_zsyequb_work,
    LAPACKE_zsyrfs,
    LAPACKE_zsyrfs_work,
    LAPACKE_zsysv,
    LAPACKE_zsysv_rook,
    LAPACKE_zsysv_rook_work,
    LAPACKE_zsysv_work,
    LAPACKE_zsysvx,
    LAPACKE_zsysvx_work,
    LAPACKE_zsyswapr,
    LAPACKE_zsyswapr_work,
    LAPACKE_zsytrf,
    LAPACKE_zsytrf_work,
    LAPACKE_zsytri,
    LAPACKE_zsytri2,
    LAPACKE_zsytri2_work,
    LAPACKE_zsytri2x,
    LAPACKE_zsytri2x_work,
    LAPACKE_zsytri_work,
    LAPACKE_zsytrs,
    LAPACKE_zsytrs2,
    LAPACKE_zsytrs2_work,
    LAPACKE_zsytrs_work,
    LAPACKE_ztbcon,
    LAPACKE_ztbcon_work,
    LAPACKE_ztbrfs,
    LAPACKE_ztbrfs_work,
    LAPACKE_ztbtrs,
    LAPACKE_ztbtrs_work,
    LAPACKE_ztfsm,
    LAPACKE_ztfsm_work,
    LAPACKE_ztftri,
    LAPACKE_ztftri_work,
    LAPACKE_ztfttp,
    LAPACKE_ztfttp_work,
    LAPACKE_ztfttr,
    LAPACKE_ztfttr_work,
    LAPACKE_ztgevc,
    LAPACKE_ztgevc_work,
    LAPACKE_ztgexc,
    LAPACKE_ztgexc_work,
    LAPACKE_ztgsen,
    LAPACKE_ztgsen_work,
    LAPACKE_ztgsja,
    LAPACKE_ztgsja_work,
    LAPACKE_ztgsna,
    LAPACKE_ztgsna_work,
    LAPACKE_ztgsyl,
    LAPACKE_ztgsyl_work,
    LAPACKE_ztpcon,
    LAPACKE_ztpcon_work,
    LAPACKE_ztpmqrt,
    LAPACKE_ztpmqrt_work,
    LAPACKE_ztpqrt,
    LAPACKE_ztpqrt2,
    LAPACKE_ztpqrt2_work,
    LAPACKE_ztpqrt_work,
    LAPACKE_ztprfb,
    LAPACKE_ztprfb_work,
    LAPACKE_ztprfs,
    LAPACKE_ztprfs_work,
    LAPACKE_ztptri,
    LAPACKE_ztptri_work,
    LAPACKE_ztptrs,
    LAPACKE_ztptrs_work,
    LAPACKE_ztpttf,
    LAPACKE_ztpttf_work,
    LAPACKE_ztpttr,
    LAPACKE_ztpttr_work,
    LAPACKE_ztrcon,
    LAPACKE_ztrcon_work,
    LAPACKE_ztrevc,
    LAPACKE_ztrevc_work,
    LAPACKE_ztrexc,
    LAPACKE_ztrexc_work,
    LAPACKE_ztrrfs,
    LAPACKE_ztrrfs_work,
    LAPACKE_ztrsen,
    LAPACKE_ztrsen_work,
    LAPACKE_ztrsna,
    LAPACKE_ztrsna_work,
    LAPACKE_ztrsyl,
    LAPACKE_ztrsyl_work,
    LAPACKE_ztrtri,
    LAPACKE_ztrtri_work,
    LAPACKE_ztrtrs,
    LAPACKE_ztrtrs_work,
    LAPACKE_ztrttf,
    LAPACKE_ztrttf_work,
    LAPACKE_ztrttp,
    LAPACKE_ztrttp_work,
    LAPACKE_ztzrzf,
    LAPACKE_ztzrzf_work,
    LAPACKE_zunbdb,
    LAPACKE_zunbdb_work,
    LAPACKE_zuncsd,
    LAPACKE_zuncsd_work,
    LAPACKE_zungbr,
    LAPACKE_zungbr_work,
    LAPACKE_zunghr,
    LAPACKE_zunghr_work,
    LAPACKE_zunglq,
    LAPACKE_zunglq_work,
    LAPACKE_zungql,
    LAPACKE_zungql_work,
    LAPACKE_zungqr,
    LAPACKE_zungqr_work,
    LAPACKE_zungrq,
    LAPACKE_zungrq_work,
    LAPACKE_zungtr,
    LAPACKE_zungtr_work,
    LAPACKE_zunmbr,
    LAPACKE_zunmbr_work,
    LAPACKE_zunmhr,
    LAPACKE_zunmhr_work,
    LAPACKE_zunmlq,
    LAPACKE_zunmlq_work,
    LAPACKE_zunmql,
    LAPACKE_zunmql_work,
    LAPACKE_zunmqr,
    LAPACKE_zunmqr_work,
    LAPACKE_zunmrq,
    LAPACKE_zunmrq_work,
    LAPACKE_zunmrz,
    LAPACKE_zunmrz_work,
    LAPACKE_zunmtr,
    LAPACKE_zunmtr_work,
    LAPACKE_zupgtr,
    LAPACKE_zupgtr_work,
    LAPACKE_zupmtr,
    LAPACKE_zupmtr_work,
    LAPACKE_zsyr,
    LAPACKE_zsyr_work,
    LAPACKE_zgetsqrhrt,
    LAPACKE_zgetsqrhrt_work,
    LAPACKE_zungtsqr_row,
    LAPACKE_zungtsqr_row_work,
    LAPACKE_zlangb,
    LAPACKE_zlangb_work,
    LAPACKE_zunhr_col,
    LAPACKE_zunhr_col_work,
    LAPACKE_ztrsyl3,
    LAPACKE_ztrsyl3_work,
    LAPACKE_ztz_nancheck,
    LAPACKE_ztz_trans,

    ## @(SRCX_OBJ) from `lapack-3.4.1/lapacke/src/Makefile`
    ## Not exported: requires LAPACKE_EXTENDED to be set and depends on the
    ##               corresponding LAPACK extended precision routines.
    #LAPACKE_cgbrfsx,
    #LAPACKE_cporfsx,
    #LAPACKE_dgerfsx,
    #LAPACKE_sgbrfsx,
    #LAPACKE_ssyrfsx,
    #LAPACKE_zherfsx,
    #LAPACKE_cgbrfsx_work,
    #LAPACKE_cporfsx_work,
    #LAPACKE_dgerfsx_work,
    #LAPACKE_sgbrfsx_work,
    #LAPACKE_ssyrfsx_work,
    #LAPACKE_zherfsx_work,
    #LAPACKE_cgerfsx,
    #LAPACKE_csyrfsx,
    #LAPACKE_dporfsx,
    #LAPACKE_sgerfsx,
    #LAPACKE_zgbrfsx,
    #LAPACKE_zporfsx,
    #LAPACKE_cgerfsx_work,
    #LAPACKE_csyrfsx_work,
    #LAPACKE_dporfsx_work,
    #LAPACKE_sgerfsx_work,
    #LAPACKE_zgbrfsx_work,
    #LAPACKE_zporfsx_work,
    #LAPACKE_cherfsx,
    #LAPACKE_dgbrfsx,
    #LAPACKE_dsyrfsx,
    #LAPACKE_sporfsx,
    #LAPACKE_zgerfsx,
    #LAPACKE_zsyrfsx,
    #LAPACKE_cherfsx_work,
    #LAPACKE_dgbrfsx_work,
    #LAPACKE_dsyrfsx_work,
    #LAPACKE_sporfsx_work,
    #LAPACKE_zgerfsx_work,
    #LAPACKE_zsyrfsx_work,
    #LAPACKE_cgbsvxx,
    #LAPACKE_cposvxx,
    #LAPACKE_dgesvxx,
    #LAPACKE_sgbsvxx,
    #LAPACKE_ssysvxx,
    #LAPACKE_zhesvxx,
    #LAPACKE_cgbsvxx_work,
    #LAPACKE_cposvxx_work,
    #LAPACKE_dgesvxx_work,
    #LAPACKE_sgbsvxx_work,
    #LAPACKE_ssysvxx_work,
    #LAPACKE_zhesvxx_work,
    #LAPACKE_cgesvxx,
    #LAPACKE_csysvxx,
    #LAPACKE_dposvxx,
    #LAPACKE_sgesvxx,
    #LAPACKE_zgbsvxx,
    #LAPACKE_zposvxx,
    #LAPACKE_cgesvxx_work,
    #LAPACKE_csysvxx_work,
    #LAPACKE_dposvxx_work,
    #LAPACKE_sgesvxx_work,
    #LAPACKE_zgbsvxx_work,
    #LAPACKE_zposvxx_work,
    #LAPACKE_chesvxx,
    #LAPACKE_dgbsvxx,
    #LAPACKE_dsysvxx,
    #LAPACKE_sposvxx,
    #LAPACKE_zgesvxx,
    #LAPACKE_zsysvxx,
    #LAPACKE_chesvxx_work,
    #LAPACKE_dgbsvxx_work,
    #LAPACKE_dsysvxx_work,
    #LAPACKE_sposvxx_work,
    #LAPACKE_zgesvxx_work,
    #LAPACKE_zsysvxx_work,

    ## @(MATGEN_OBJ) from `lapack-3.4.1/lapacke/src/Makefile`
    ## Not exported: requires LAPACKE_TESTING to be set and depends on libtmg
    ##               (see `lapack-3.4.1/TESTING/MATGEN`).
    LAPACKE_zlatms,
    LAPACKE_zlatms_work,
    LAPACKE_zlagge,
    LAPACKE_zlagge_work,
    LAPACKE_zlaghe,
    LAPACKE_zlaghe_work,
    LAPACKE_zlagsy,
    LAPACKE_zlagsy_work,
    ## new function from lapack-3.6.0
    LAPACKE_zgejsv,
    LAPACKE_zgejsv_work,
    LAPACKE_zgesvdx,
    LAPACKE_zgesvdx_work,
    LAPACKE_zgesvj,
    LAPACKE_zgesvj_work,
    LAPACKE_zgetrf2,
    LAPACKE_zgetrf2_work,
    LAPACKE_zgges3,
    LAPACKE_zgges3_work,
    LAPACKE_zggev3,
    LAPACKE_zggev3_work,
    LAPACKE_zgghd3,
    LAPACKE_zgghd3_work,
    LAPACKE_zggsvd3,
    LAPACKE_zggsvd3_work,
    LAPACKE_zggsvp3,
    LAPACKE_zggsvp3_work,
    LAPACKE_zhetrf_rook,
    LAPACKE_zhetrf_rook_work,
    LAPACKE_zhetrs_rook,
    LAPACKE_zhetrs_rook_work,
    LAPACKE_zlapmt,
    LAPACKE_zlapmt_work,
    LAPACKE_zlascl,
    LAPACKE_zlascl_work,
    LAPACKE_zpotrf2,
    LAPACKE_zpotrf2_work,
    LAPACKE_zsytrf_rook,
    LAPACKE_zsytrf_rook_work,
    LAPACKE_zsytrs_rook,
    LAPACKE_zsytrs_rook_work,
    LAPACKE_zuncsd2by1,
    LAPACKE_zuncsd2by1_work,

    ## new function from lapack-3.7.0
    LAPACKE_zgelq,
    LAPACKE_zgelq_work,
    LAPACKE_zgemlq,
    LAPACKE_zgemlq_work,
    LAPACKE_zgemqr,
    LAPACKE_zgemqr_work,
    LAPACKE_zgeqr,
    LAPACKE_zgeqr_work,
    LAPACKE_zgetsls,
    LAPACKE_zgetsls_work,
    LAPACKE_zhbev_2stage,
    LAPACKE_zhbev_2stage_work,
    LAPACKE_zhbevd_2stage,
    LAPACKE_zhbevd_2stage_work,
    LAPACKE_zhbevx_2stage,
    LAPACKE_zhbevx_2stage_work,
    LAPACKE_zhecon_3,
    LAPACKE_zhecon_3_work,
    LAPACKE_zheev_2stage,
    LAPACKE_zheev_2stage_work,
    LAPACKE_zheevd_2stage,
    LAPACKE_zheevd_2stage_work,
    LAPACKE_zheevr_2stage,
    LAPACKE_zheevr_2stage_work,
    LAPACKE_zheevx_2stage,
    LAPACKE_zheevx_2stage_work,
    LAPACKE_zhegv_2stage,
    LAPACKE_zhegv_2stage_work,
    LAPACKE_zhesv_aa,
    LAPACKE_zhesv_aa_work,
    LAPACKE_zhesv_rk,
    LAPACKE_zhesv_rk_work,
    LAPACKE_zhetrf_aa,
    LAPACKE_zhetrf_aa_work,
    LAPACKE_zhetrf_rk,
    LAPACKE_zhetrf_rk_work,
    LAPACKE_zhetri_3,
    LAPACKE_zhetri_3_work,
    LAPACKE_zhetrs_aa,
    LAPACKE_zhetrs_aa_work,
    LAPACKE_zhetrs_3,
    LAPACKE_zhetrs_3_work,
    LAPACKE_zsycon_3,
    LAPACKE_zsycon_3_work,
    LAPACKE_zsysv_aa,
    LAPACKE_zsysv_aa_work,
    LAPACKE_zsysv_rk,
    LAPACKE_zsysv_rk_work,
    LAPACKE_zsytrf_aa,
    LAPACKE_zsytrf_aa_work,
    LAPACKE_zsytrf_rk,
    LAPACKE_zsytrf_rk_work,
    LAPACKE_zsytri_3,
    LAPACKE_zsytri_3_work,
    LAPACKE_zsytrs_aa,
    LAPACKE_zsytrs_aa_work,
    LAPACKE_zsytrs_3,
    LAPACKE_zsytrs_3_work,
    
    ## new function from lapack-3.8.0
    LAPACKE_zhesv_aa_2stage,
    LAPACKE_zhesv_aa_2stage_work,
    LAPACKE_zhetrf_aa_2stage,
    LAPACKE_zhetrf_aa_2stage_work,
    LAPACKE_zhetrs_aa_2stage,
    LAPACKE_zhetrs_aa_2stage_work,
    LAPACKE_zlacrm,
    LAPACKE_zlacrm_work,
    LAPACKE_zlarcm,
    LAPACKE_zlarcm_work,
    LAPACKE_zlassq,
    LAPACKE_zlassq_work,
    LAPACKE_zsysv_aa_2stage,
    LAPACKE_zsysv_aa_2stage_work,
    LAPACKE_zsytrf_aa_2stage,
    LAPACKE_zsytrf_aa_2stage_work,
    LAPACKE_zsytrs_aa_2stage,
    LAPACKE_zsytrs_aa_2stage_work,
    # new functions from 3.9.0
    LAPACKE_zgesvdq,
    LAPACKE_zgesvdq_work,
);

#These function may need 2 underscores.
@lapack_embeded_underscore_objs=(
    xerbla_array, chla_transtype,
    );
@lapack_embeded_underscore_objs_s=(    
     slasyf_rook,
    ssytf2_rook, ssytrf_rook, ssytrs_rook,
    ssytri_rook, ssycon_rook, ssysv_rook,
    slasyf_rk, ssyconvf_rook, ssytf2_rk,
    ssytrf_rk, ssytrs_3, ssytri_3,
    ssytri_3x, ssycon_3, ssysv_rk,
    slasyf_aa, ssysv_aa, ssytrf_aa,
    ssytrs_aa, ssytrd_2stage, ssytrd_sy2sb,
    ssytrd_sb2st, ssb2st_kernels, ssyevd_2stage,
    ssyev_2stage, ssyevx_2stage, ssyevr_2stage,
    ssbev_2stage, ssbevx_2stage, ssbevd_2stage,
    ssygv_2stage, 
    ssysv_aa_2stage, ssytrf_aa_2stage,
    ssytrs_aa_2stage, 
    slaorhr_col_getrfnp, slaorhr_col_getrfnp2, sorhr_col, slarfb_gett
);
@lapack_embeded_underscore_objs_c=(    
    chetf2_rook, chetrf_rook, chetri_rook,
    chetrs_rook, checon_rook, chesv_rook,
    clahef_rook, clasyf_rook,
    csytf2_rook, csytrf_rook, csytrs_rook,
    csytri_rook, csycon_rook, csysv_rook,
    chetf2_rk,
    chetrf_rk, chetri_3, chetri_3x,
    chetrs_3, checon_3, chesv_rk,
    chesv_aa, chetrf_aa, chetrs_aa,
    clahef_aa, clahef_rk, clasyf_rk,
    clasyf_aa, csytf2_rk, csytrf_rk,
    csytrf_aa, csytrs_3, csytrs_aa,
    csytri_3, csytri_3x, csycon_3,
    csysv_rk, csysv_aa, csyconvf_rook,
    chetrd_2stage, chetrd_he2hb, chetrd_hb2st,
    chb2st_kernels, cheevd_2stage, cheev_2stage,
    cheevx_2stage, cheevr_2stage, chbev_2stage,
    chbevx_2stage, chbevd_2stage, chegv_2stage,
    chesv_aa_2stage,
    chetrf_aa_2stage, chetrs_aa_2stage,
    csysv_aa_2stage, csytrf_aa_2stage,
    csytrs_aa_2stage,
    claunhr_col_getrfnp, claunhr_col_getrfnp2, cunhr_col, clarfb_gett
);
@lapack_embeded_underscore_objs_d=(    
    dlasyf_rook,
    dsytf2_rook, dsytrf_rook, dsytrs_rook,
    dsytri_rook, dsycon_rook, dsysv_rook,
    dlasyf_rk, dsyconvf_rook,
    dsytf2_rk, dsytrf_rk, dsytrs_3,
    dsytri_3, dsytri_3x, dsycon_3,
    dsysv_rk, dlasyf_aa, dsysv_aa,
    dsytrf_aa, dsytrs_aa, dsytrd_2stage,
    dsytrd_sy2sb, dsytrd_sb2st, dsb2st_kernels,
    dsyevd_2stage, dsyev_2stage, dsyevx_2stage,
    dsyevr_2stage, dsbev_2stage, dsbevx_2stage,
    dsbevd_2stage, dsygv_2stage, 
     dsysv_aa_2stage,
    dsytrf_aa_2stage, dsytrs_aa_2stage,
    dlaorhr_col_getrfnp, dlaorhr_col_getrfnp2, dorhr_col, dlarfb_gett
);
@lapack_embeded_underscore_objs_z=(    
    zhetf2_rook, zhetrf_rook, zhetri_rook,
    zhetrs_rook, zhecon_rook, zhesv_rook,
    zlahef_rook, zlasyf_rook,
    zsytf2_rook, zsytrf_rook, zsytrs_rook,
    zsytri_rook, zsycon_rook, zsysv_rook,
    zhetf2_rk, zhetrf_rk, zhetri_3,
    zhetri_3x, zhetrs_3, zhecon_3,
    zhesv_rk, zhesv_aa, zhetrf_aa,
    zhetrs_aa, zlahef_aa, zlahef_rk,
    zlasyf_rk, zlasyf_aa, zsyconvf_rook,
    zsytrs_aa, zsytf2_rk, zsytrf_rk,
    zsytrf_aa, zsytrs_3, zsytri_3,
    zsytri_3x, zsycon_3, zsysv_rk,
    zsysv_aa, zhetrd_2stage, zhetrd_he2hb,
    zhetrd_hb2st, zhb2st_kernels, zheevd_2stage,
    zheev_2stage, zheevx_2stage, zheevr_2stage,
    zhbev_2stage, zhbevx_2stage, zhbevd_2stage,
    zhegv_2stage,
    zhesv_aa_2stage, zhetrf_aa_2stage,
    zhetrs_aa_2stage, zsysv_aa_2stage,
    zsytrf_aa_2stage, zsytrs_aa_2stage,
    zlaunhr_col_getrfnp, zlaunhr_col_getrfnp2, zunhr_col, zlarfb_gett
);


use File::Spec;
use File::Basename;
my $dirname = File::Spec->catfile(dirname(dirname(File::Spec->rel2abs(__FILE__))), "lapack-netlib");

if ($ARGV[12] == 1) {
	@blasobjs = (@blasobjs, @bfblasobjs);
	@cblasobjs = (@cblasobjs, @bfcblasobjs);
}
if ($ARGV[13] == 1) {
	@blasobjs = (@blasobjs, @hfblasobjs);
	@cblasobjs = (@cblasobjs, @hfcblasobjs);
}
if ($ARGV[14] == 1) {
	@blasobjs = (@blasobjs, @blasobjss);
	@cblasobjs = (@cblasobjs, @cblasobjss);
	@lapackobjs = (@lapackobjs, @lapackobjss);
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2s);
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2sc);
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2ds);
	@lapack_deprecated_objs = (@lapack_deprecated_objs, @lapack_deprecated_objss);
	@lapacke_deprecated_objs = (@lapacke_deprecated_objs, @lapacke_deprecated_objss);
	@lapack_embeded_underscore_objs = (@lapack_embeded_underscore_objs,  @lapack_embeded_underscore_objs_s); 
	@lapackeobjs = (@lapackeobjs, @lapackeobjss);
}
if ($ARGV[15] == 1) {
	@blasobjs = (@blasobjs, @blasobjsd);
	@cblasobjs = (@cblasobjs, @cblasobjsd);
	@lapackobjs = (@lapackobjs, @lapackobjsd);
	if ($ARGV[14] == 0) { 
		@lapackobjs2 = (@lapackobjs2, @lapackobjs2ds);
	}
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2d, @lapackobjs2dz);
	@lapack_deprecated_objs = (@lapack_deprecated_objs, @lapack_deprecated_objsd);
	@lapacke_deprecated_objs = (@lapacke_deprecated_objs, @lapacke_deprecated_objsd);
	@lapack_embeded_underscore_objs = (@lapack_embeded_underscore_objs,  @lapack_embeded_underscore_objs_d);
	@lapackeobjs = (@lapackeobjs, @lapackeobjsd);
}
if ($ARGV[16] == 1) {
	@blasobjs = (@blasobjs, @blasobjsc);
	@cblasobjs = (@cblasobjs, @cblasobjsc);
	@gemm3mobjs = (@gemm3mobjs, @gemm3mobjsc);
	@cblasgemm3mobjs = (@cblasgemm3mobjs, @cblasgemm3mobjsc);
	@lapackobjs = (@lapackobjs, @lapackobjsc);
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2c, @lapackobjs2zc);
	if ($ARGV[14] == 0) { 
		@lapackobjs2 = (@lapackobjs2, @lapackobjs2sc);
	}
	@lapack_deprecated_objs = (@lapack_deprecated_objs, @lapack_deprecated_objsc);
	@lapacke_deprecated_objs = (@lapacke_deprecated_objs, @lapacke_deprecated_objsc);
	@lapack_embeded_underscore_objs = (@lapack_embeded_underscore_objs,  @lapack_embeded_underscore_objs_c);
	@lapackeobjs = (@lapackeobjs, @lapackeobjsc);
}
if ($ARGV[17] == 1) {
	@blasobjs = (@blasobjs, @blasobjsz);
	@cblasobjs = (@cblasobjs, @cblasobjsz);
	@gemm3mobjs = (@gemm3mobjs, @gemm3mobjsz);
	@cblasgemm3mobjs = (@cblasgemm3mobjs, @cblasgemm3mobjsz);
	@lapackobjs = (@lapackobjs, @lapackobjsz);
	@lapackobjs2 = (@lapackobjs2, @lapackobjs2z);
	if ($ARGV[16] == 0) { 
		@lapackobjs2 = (@lapackobjs2, @lapackobjs2zc);
	}
	if ($ARGV[15] == 0) { 
		@lapackobjs2 = (@lapackobjs2, @lapackobjs2dz);
	}
	@lapack_deprecated_objs = (@lapack_deprecated_objs, @lapack_deprecated_objsz);
	@lapacke_deprecated_objs = (@lapacke_deprecated_objs, @lapacke_deprecated_objsz);
	@lapack_embeded_underscore_objs = (@lapack_embeded_underscore_objs,  @lapack_embeded_underscore_objs_z);
	@lapackeobjs = (@lapackeobjs, @lapackeobjsz);
}
if ($ARGV[8] == 1) {
    #ONLY_CBLAS=1
    @underscore_objs = (@misc_underscore_objs);
} elsif ($ARGV[5] == 1) {
    #NO_LAPACK=1
    @underscore_objs = (@blasobjs, @misc_underscore_objs);
} elsif (-d $dirname) {
    if ($ARGV[7] == 0) {
        # NEED2UNDERSCORES=0
        # Don't need 2 underscores
        @underscore_objs = (@blasobjs, @lapackobjs, @lapackobjs2, @misc_underscore_objs, @lapack_embeded_underscore_objs);
    } else {
        # Need 2 underscores
        @underscore_objs = (@blasobjs, @lapackobjs, @lapackobjs2, @misc_underscore_objs);
        @need_2underscore_objs = (@lapack_embeded_underscore_objs);
    };

    if ($ARGV[11] == 1) {
        #BUILD_LAPACK_DEPRECATED=1
        @underscore_objs = (@underscore_objs, @lapack_deprecated_objs);
    }
} else {
    @underscore_objs = (@blasobjs, @lapackobjs, @misc_underscore_objs);
}

if ($ARGV[8] == 1) {
    #ONLY_CBLAS=1
    @gemm3mobjs=();
    @exblasobjs=();
}

if ($ARGV[3] == 1) {
    @underscore_objs = (@underscore_objs, @exblasobjs);
};

if ($ARGV[1] eq "x86_64") { @underscore_objs = (@underscore_objs, @gemm3mobjs); };
if ($ARGV[1] eq "x86")    { @underscore_objs = (@underscore_objs, @gemm3mobjs); };
if ($ARGV[1] eq "ia64")   { @underscore_objs = (@underscore_objs, @gemm3mobjs); };
if ($ARGV[1] eq "MIPS")   { @underscore_objs = (@underscore_objs, @gemm3mobjs); };

if ($ARGV[4] == 0) {
    @no_underscore_objs = (@cblasobjs, @misc_no_underscore_objs);
    if ($ARGV[1] eq "x86_64") { @no_underscore_objs = (@no_underscore_objs, @cblasgemm3mobjs); };
    if ($ARGV[1] eq "x86")    { @no_underscore_objs = (@no_underscore_objs, @cblasgemm3mobjs); };
    if ($ARGV[1] eq "ia64")   { @no_underscore_objs = (@no_underscore_objs, @cblasgemm3mobjs); };
    if ($ARGV[1] eq "MIPS")   { @no_underscore_objs = (@no_underscore_objs, @cblasgemm3mobjs); };
}else{
    #NO_CBLAS=1
    @no_underscore_objs = (@misc_no_underscore_objs);
}
if ($ARGV[6] == 1) {
    #NO_LAPACKE=1
    @no_underscore_objs = (@no_underscore_objs);
} else {
    if ($ARGV[11] == 1) {
        #BUILD_LAPACK_DEPRECATED=1
        @no_underscore_objs = (@no_underscore_objs, @lapackeobjs, @lapacke_deprecated_objs);
    } else {
        @no_underscore_objs = (@no_underscore_objs, @lapackeobjs);
    }
}

@hplobjs  = (daxpy, dcopy, dscal, idamax, dgemv, dtrsv, dger, dgemm, dtrsm);
@hplobjs2 = (HPL_dlaswp00N, HPL_dlaswp01N, HPL_dlaswp01T);

$bu = $ARGV[2];

$bu = "" if (($bu eq "0") || ($bu eq "1"));

$symbolprefix = $ARGV[9];

$symbolsuffix = $ARGV[10];

if ($ARGV[0] eq "osx") {
    @underscore_objs = (@underscore_objs, @misc_common_objs);
    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    foreach $objs (@underscore_objs) {
        print "_", $symbolprefix, $objs, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@need_2underscore_objs) {
        print "_", $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@no_underscore_objs) {
        print "_", $symbolprefix, $objs, $symbolsuffix, "\n";
    }
    exit(0);
}

if ($ARGV[0] eq "aix"){
    @underscore_objs = (@underscore_objs, @misc_common_objs);
    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    foreach $objs (@underscore_objs) {
        print $symbolprefix, $objs, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@need_2underscore_objs) {
        print $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@no_underscore_objs) {
        print $symbolprefix, $objs, $symbolsuffix, "\n";
    }
    exit(0);
}

if ($ARGV[0] eq "objcopy") {
    @underscore_objs = (@underscore_objs, @misc_common_objs);
    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    foreach $objs (@underscore_objs) {
        print $objs, $bu, " ", $symbolprefix, $objs, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@need_2underscore_objs) {
        print $objs, $bu, $bu, " ", $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@no_underscore_objs) {
        print $objs, " ", $symbolprefix, $objs, $symbolsuffix, "\n";
    }
    exit(0);
}

if ($ARGV[0] eq "objconv") {
    @underscore_objs = (@underscore_objs, @misc_common_objs);
    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    foreach $objs (@underscore_objs) {
        print "-nr:_", $objs, $bu, ":_", $symbolprefix, $objs, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@need_2underscore_objs) {
        print "-nr:_", $objs, $bu, $bu, ":_", $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "\n";
    }

    foreach $objs (@no_underscore_objs) {
        print "-nr:_", $objs, ":_", $symbolprefix, $objs, $symbolsuffix, "\n";
    }
    exit(0);
}

if ($ARGV[0] eq "win2k"){
    print "EXPORTS\n";
    $count = 1;

    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    foreach $objs (@underscore_objs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, $symbolsuffix, "=$objs","_  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $objs, "_", $symbolsuffix, "=$objs","_  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, "=$objs", "_  \@", $count, "\n";
        $count ++;
    }

    foreach $objs (@need_2underscore_objs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, $symbolsuffix, "=$objs","__  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $objs, "__", $symbolsuffix, "=$objs","__  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, "=$objs", "__  \@", $count, "\n";
        $count ++;
    }

    #for misc_common_objs
    foreach $objs (@misc_common_objs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, "_", $symbolsuffix, "=$objs","_  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, "=$objs", "_  \@", $count, "\n";
        $count ++;
    }


    foreach $objs (@no_underscore_objs) {
        print "\t",$symbolprefix,$objs,$symbolsuffix,"=$objs","  \@", $count, "\n";
        $count ++;
    }

    exit(0);
}

if ($ARGV[0] eq "win2khpl") {
    print "EXPORTS\n";
    $count = 1;
    foreach $objs (@hplobjs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, $symbolsuffix, "=$objs","_  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $objs, "_", $symbolsuffix, "=$objs","_  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, "=$objs", "_  \@", $count, "\n";
        $count ++;
    }

    exit(0);
}

if ($ARGV[0] eq "microsoft"){
    @underscore_objs = (@underscore_objs, @misc_common_objs);

    print "EXPORTS\n";
    $count = 1;
    foreach $objs (@underscore_objs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, $symbolsuffix, " = $objs","_\n";
        $count ++;
        print "\t",$symbolprefix, $objs, "\_", $symbolsuffix, " = $objs","_\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, " = $objs","_\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, "\_", $symbolsuffix, " = $objs","_\n";
        $count ++;
    }

    foreach $objs (@need_2underscore_objs) {
        $uppercase = $objs;
        $uppercase =~ tr/[a-z]/[A-Z]/;
        print "\t",$symbolprefix, $objs, $symbolsuffix, "=$objs","__  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $objs, "__", $symbolsuffix, "=$objs","__  \@", $count, "\n";
        $count ++;
        print "\t",$symbolprefix, $uppercase, $symbolsuffix, "=$objs", "__  \@", $count, "\n";
        $count ++;
    }

    exit(0);
}

if ($ARGV[0] eq "linktest") {
    @underscore_objs = (@underscore_objs, @misc_common_objs);
    @no_underscore_objs = (@no_underscore_objs, @misc_common_objs);

    print "int main(void){\n";
    foreach $objs (@underscore_objs) {
        print "extern void ", $symbolprefix, $objs, $bu, $symbolsuffix, "();\n" if $objs ne "xerbla";
    }

    foreach $objs (@need_2underscore_objs) {
        print "extern void ", $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "();\n";
    }

    foreach $objs (@no_underscore_objs) {
        print "extern void ", $symbolprefix, $objs, $symbolsuffix, "();\n";
    }

    foreach $objs (@underscore_objs) {
        print $symbolprefix, $objs, $bu, $symbolsuffix, "();\n" if $objs ne "xerbla";
    }

    foreach $objs (@need_2underscore_objs) {
        print $symbolprefix, $objs, $bu, $bu, $symbolsuffix, "();\n";
    }

    foreach $objs (@no_underscore_objs) {
        print $symbolprefix, $objs, $symbolsuffix, "();\n";
    }

    print "return 0;}\n";
    exit(0);
}
