/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.text.StrMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class StrMatcherTest
extends AbstractLangTest {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    @Test
    public void testCharMatcher_char() {
        StrMatcher matcher = StrMatcher.charMatcher((char)'c');
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
    }

    @Test
    public void testCharSetMatcher_charArray() {
        StrMatcher matcher = StrMatcher.charSetMatcher((char[])"ace".toCharArray());
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])new char[0]));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])null));
        Assertions.assertTrue((boolean)(StrMatcher.charSetMatcher((char[])"a".toCharArray()) instanceof StrMatcher.CharMatcher));
    }

    @Test
    public void testCharSetMatcher_String() {
        StrMatcher matcher = StrMatcher.charSetMatcher((String)"ace");
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)""));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)null));
        Assertions.assertTrue((boolean)(StrMatcher.charSetMatcher((String)"a") instanceof StrMatcher.CharMatcher));
    }

    @Test
    public void testCommaMatcher() {
        StrMatcher matcher = StrMatcher.commaMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.commaMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
    }

    @Test
    public void testDoubleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.doubleQuoteMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.doubleQuoteMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testMatcherIndices() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 0, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1, 0, 2));
    }

    @Test
    public void testNoneMatcher() {
        StrMatcher matcher = StrMatcher.noneMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.noneMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testQuoteMatcher() {
        StrMatcher matcher = StrMatcher.quoteMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.quoteMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testSingleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.singleQuoteMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.singleQuoteMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testSpaceMatcher() {
        StrMatcher matcher = StrMatcher.spaceMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.spaceMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
    }

    @Test
    public void testSplitMatcher() {
        StrMatcher matcher = StrMatcher.splitMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.splitMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
    }

    @Test
    public void testStringMatcher_String() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher((String)""));
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher(null));
    }

    @Test
    public void testTabMatcher() {
        StrMatcher matcher = StrMatcher.tabMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.tabMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
    }

    @Test
    public void testTrimMatcher() {
        StrMatcher matcher = StrMatcher.trimMatcher();
        Assertions.assertSame((Object)matcher, (Object)StrMatcher.trimMatcher());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 10));
    }
}

