/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.certificate.ServerCertificateKt;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J<\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0003J<\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0003R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006("}, d2={"Lorg/signal/libsignal/metadata/certificate/ServerCertificate;", "Lorg/signal/libsignal/internal/NativeHandleGuard$SimpleOwner;", "nativeHandle", "", "<init>", "(J)V", "serialized", "", "([B)V", "trustRoot", "Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "keyId", "", "key", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "(Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;ILorg/signal/libsignal/protocol/ecc/ECPublicKey;)V", "release", "", "getKeyId", "()I", "getKey", "()Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getSerialized", "()[B", "certificate", "getCertificate", "signature", "getSignature", "issue", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "signingKey", "senderUuid", "", "senderE164", "Ljava/util/Optional;", "senderDeviceId", "senderIdentityKey", "expiration", "sender", "Lorg/signal/libsignal/protocol/ServiceId;", "libsignal-client"})
public final class ServerCertificate
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.ServerCertificate_Destroy(nativeHandle);
    }

    public ServerCertificate(long nativeHandle) {
        super(nativeHandle);
    }

    public ServerCertificate(@NotNull byte[] serialized) throws InvalidCertificateException {
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        super(ServerCertificateKt.access$createNativeFrom(serialized));
    }

    public ServerCertificate(@NotNull ECPrivateKey trustRoot, int keyId, @NotNull ECPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)trustRoot, (String)"trustRoot");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Long l = key.guardedMap(arg_0 -> ServerCertificate._init_$lambda$1(trustRoot, keyId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMap(...)");
        super(((Number)l).longValue());
    }

    public final int getKeyId() {
        Integer n = this.guardedMapChecked(Native::ServerCertificate_GetKeyId);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"guardedMapChecked(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public final ECPublicKey getKey() {
        Long l = this.guardedMap(Native::ServerCertificate_GetKey);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMap(...)");
        return new ECPublicKey(((Number)l).longValue());
    }

    @NotNull
    public final byte[] getSerialized() {
        byte[] byArray = this.guardedMap(Native::ServerCertificate_GetSerialized);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMap(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getCertificate() {
        byte[] byArray = this.guardedMapChecked(Native::ServerCertificate_GetCertificate);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getSignature() {
        byte[] byArray = this.guardedMapChecked(Native::ServerCertificate_GetSignature);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }

    @NotNull
    public final SenderCertificate issue(@NotNull ECPrivateKey signingKey, @NotNull String senderUuid, @NotNull Optional<String> senderE164, int senderDeviceId, @NotNull ECPublicKey senderIdentityKey, long expiration) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)senderUuid, (String)"senderUuid");
        Intrinsics.checkNotNullParameter(senderE164, (String)"senderE164");
        Intrinsics.checkNotNullParameter((Object)senderIdentityKey, (String)"senderIdentityKey");
        SenderCertificate senderCertificate = senderIdentityKey.guardedMap(arg_0 -> ServerCertificate.issue$lambda$4(this, signingKey, senderUuid, senderE164, senderDeviceId, expiration, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)senderCertificate, (String)"guardedMap(...)");
        return senderCertificate;
    }

    @NotNull
    public final SenderCertificate issue(@NotNull ECPrivateKey signingKey, @NotNull ServiceId sender, @NotNull Optional<String> senderE164, int senderDeviceId, @NotNull ECPublicKey senderIdentityKey, long expiration) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(senderE164, (String)"senderE164");
        Intrinsics.checkNotNullParameter((Object)senderIdentityKey, (String)"senderIdentityKey");
        String string = sender.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.issue(signingKey, string, senderE164, senderDeviceId, senderIdentityKey, expiration);
    }

    private static final Long _init_$lambda$1$lambda$0(int $keyId, long $serverPublicHandle, long trustRootHandle) {
        return Native.ServerCertificate_New($keyId, $serverPublicHandle, trustRootHandle);
    }

    private static final Long _init_$lambda$1(ECPrivateKey $trustRoot, int $keyId, long serverPublicHandle) {
        return $trustRoot.guardedMap(arg_0 -> ServerCertificate._init_$lambda$1$lambda$0($keyId, serverPublicHandle, arg_0));
    }

    private static final SenderCertificate issue$lambda$4$lambda$3$lambda$2(String $senderUuid, Optional $senderE164, int $senderDeviceId, long $identityHandle, long $expiration, long $serverCertificateHandle, long serverPrivateHandle) {
        return new SenderCertificate(Native.SenderCertificate_New($senderUuid, $senderE164.orElse(null), $senderDeviceId, $identityHandle, $expiration, $serverCertificateHandle, serverPrivateHandle));
    }

    private static final SenderCertificate issue$lambda$4$lambda$3(ECPrivateKey $signingKey, String $senderUuid, Optional $senderE164, int $senderDeviceId, long $identityHandle, long $expiration, long serverCertificateHandle) {
        return $signingKey.guardedMap(arg_0 -> ServerCertificate.issue$lambda$4$lambda$3$lambda$2($senderUuid, $senderE164, $senderDeviceId, $identityHandle, $expiration, serverCertificateHandle, arg_0));
    }

    private static final SenderCertificate issue$lambda$4(ServerCertificate this$0, ECPrivateKey $signingKey, String $senderUuid, Optional $senderE164, int $senderDeviceId, long $expiration, long identityHandle) {
        return this$0.guardedMap(arg_0 -> ServerCertificate.issue$lambda$4$lambda$3($signingKey, $senderUuid, $senderE164, $senderDeviceId, identityHandle, $expiration, arg_0));
    }
}

