// <copyright file="DeleteCookiesCommand.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

namespace OpenQA.Selenium.BiDi.Storage;

internal sealed class DeleteCookiesCommand(DeleteCookiesParameters @params)
    : Command<DeleteCookiesParameters, DeleteCookiesResult>(@params, "storage.deleteCookies");

internal sealed record DeleteCookiesParameters(CookieFilter? Filter, PartitionDescriptor? Partition) : Parameters;

public sealed record DeleteCookiesOptions : CommandOptions
{
    public CookieFilter? Filter { get; init; }

    public PartitionDescriptor? Partition { get; init; }
}

public sealed record ContextDeleteCookiesOptions : CommandOptions
{
    public CookieFilter? Filter { get; init; }

    internal static DeleteCookiesOptions WithContext(ContextDeleteCookiesOptions? options, BrowsingContext.BrowsingContext context) => new()
    {
        Partition = new ContextPartitionDescriptor(context),
        Filter = options?.Filter,
        Timeout = options?.Timeout
    };
}

public sealed record DeleteCookiesResult(PartitionKey PartitionKey) : EmptyResult;
