use v6.e.PREVIEW;
#BEGIN %*ENV<PERL6_TEST_DIE_ON_FAIL> = True;
use Test;

# Test combinations of flags for "%x".  The @info array is intialized with the
# flags (as a string), the size/precision specification (either a string or a
# number), and the expected strings for the values 0, 1, 256 and -256.  The
# flags values will be expanded to all possible permutations to ensure that the
# order of the flags is irrelevant.  Each flag permutation is combined with
# the size/permutation value to create a proper format string.  Each test will
# be done twice: once with a lowercase "x" and once with an uppercase "X".

#                        0 ,         1 ,       256 ,      -256 ;
my @info = ( # |-----------|-----------|-----------|-----------|
             # no size or size explicitely 0
       '',   '',        "0",        "1",      "100",     "-100",
      ' ',   '',        "0",        "1",      "100",     "-100",
      '0',   '',        "0",        "1",      "100",     "-100",
     '0 ',   '',        "0",        "1",      "100",     "-100",
      '+',   '',        "0",        "1",      "100",     "-100",
     '+ ',   '',        "0",        "1",      "100",     "-100",
     '+0',   '',        "0",        "1",      "100",     "-100",
    '+0 ',   '',        "0",        "1",      "100",     "-100",
      '-',   '',        "0",        "1",      "100",     "-100",
     '-+',   '',        "0",        "1",      "100",     "-100",
     '- ',   '',        "0",        "1",      "100",     "-100",
    '-+ ',   '',        "0",        "1",      "100",     "-100",
     '-0',   '',        "0",        "1",      "100",     "-100",
    '-+0',   '',        "0",        "1",      "100",     "-100",
    '-0 ',   '',        "0",        "1",      "100",     "-100",
   '-+0 ',   '',        "0",        "1",      "100",     "-100",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#',   '',        "0",      "0x1",    "0x100",   "0x-100",
     '# ',   '',        "0",      "0x1",    "0x100",   "0x-100",
     '#0',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#0 ',   '',        "0",      "0x1",    "0x100",   "0x-100",
     '#+',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#+ ',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#+0',   '',        "0",      "0x1",    "0x100",   "0x-100",
   '#+0 ',   '',        "0",      "0x1",    "0x100",   "0x-100",
     '#-',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#-+',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#- ',   '',        "0",      "0x1",    "0x100",   "0x-100",
   '#-+ ',   '',        "0",      "0x1",    "0x100",   "0x-100",
    '#-0',   '',        "0",      "0x1",    "0x100",   "0x-100",
   '#-+0',   '',        "0",      "0x1",    "0x100",   "0x-100",
   '#-0 ',   '',        "0",      "0x1",    "0x100",   "0x-100",
  '#-+0 ',   '',        "0",      "0x1",    "0x100",   "0x-100",

             # no size, precision 0
       '', '.0',         "",        "1",      "100",     "-100",
      ' ', '.0',         "",        "1",      "100",     "-100",
      '0', '.0',         "",        "1",      "100",     "-100",
     '0 ', '.0',         "",        "1",      "100",     "-100",
      '+', '.0',         "",        "1",      "100",     "-100",
     '+ ', '.0',         "",        "1",      "100",     "-100",
     '+0', '.0',         "",        "1",      "100",     "-100",
    '+0 ', '.0',         "",        "1",      "100",     "-100",
      '-', '.0',         "",        "1",      "100",     "-100",
     '-+', '.0',         "",        "1",      "100",     "-100",
     '- ', '.0',         "",        "1",      "100",     "-100",
    '-+ ', '.0',         "",        "1",      "100",     "-100",
     '-0', '.0',         "",        "1",      "100",     "-100",
    '-+0', '.0',         "",        "1",      "100",     "-100",
    '-0 ', '.0',         "",        "1",      "100",     "-100",
   '-+0 ', '.0',         "",        "1",      "100",     "-100",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#', '.0',         "",      "0x1",    "0x100",   "0x-100",
     '# ', '.0',         "",      "0x1",    "0x100",   "0x-100",
     '#0', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#0 ', '.0',         "",      "0x1",    "0x100",   "0x-100",
     '#+', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#+ ', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#+0', '.0',         "",      "0x1",    "0x100",   "0x-100",
   '#+0 ', '.0',         "",      "0x1",    "0x100",   "0x-100",
     '#-', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#-+', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#- ', '.0',         "",      "0x1",    "0x100",   "0x-100",
   '#-+ ', '.0',         "",      "0x1",    "0x100",   "0x-100",
    '#-0', '.0',         "",      "0x1",    "0x100",   "0x-100",
   '#-+0', '.0',         "",      "0x1",    "0x100",   "0x-100",
   '#-0 ', '.0',         "",      "0x1",    "0x100",   "0x-100",
  '#-+0 ', '.0',         "",      "0x1",    "0x100",   "0x-100",

             # 2 positions, usually doesn't fit
       '',    2,       " 0",       " 1",      "100",     "-100",
      ' ',    2,       " 0",       " 1",      "100",     "-100",
      '0',    2,       "00",       "01",      "100",     "-100",
     '0 ',    2,       "00",       "01",      "100",     "-100",
      '+',    2,       " 0",       " 1",      "100",     "-100",
     '+ ',    2,       " 0",       " 1",      "100",     "-100",
     '+0',    2,       "00",       "01",      "100",     "-100",
    '+0 ',    2,       "00",       "01",      "100",     "-100",
      '-',    2,       "0 ",       "1 ",      "100",     "-100",
     '-+',    2,       "0 ",       "1 ",      "100",     "-100",
     '- ',    2,       "0 ",       "1 ",      "100",     "-100",
    '-+ ',    2,       "0 ",       "1 ",      "100",     "-100",
     '-0',    2,       "0 ",       "1 ",      "100",     "-100",
    '-+0',    2,       "0 ",       "1 ",      "100",     "-100",
    '-0 ',    2,       "0 ",       "1 ",      "100",     "-100",
   '-+0 ',    2,       "0 ",       "1 ",      "100",     "-100",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#',    2,       " 0",      "0x1",    "0x100",   "0x-100",
     '# ',    2,       " 0",      "0x1",    "0x100",   "0x-100",
     '#0',    2,       "00",      "0x1",    "0x100",   "0x-100",
    '#0 ',    2,       "00",      "0x1",    "0x100",   "0x-100",
     '#+',    2,       " 0",      "0x1",    "0x100",   "0x-100",
    '#+ ',    2,       " 0",      "0x1",    "0x100",   "0x-100",
    '#+0',    2,       "00",      "0x1",    "0x100",   "0x-100",
   '#+0 ',    2,       "00",      "0x1",    "0x100",   "0x-100",
     '#-',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
    '#-+',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
    '#- ',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
   '#-+ ',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
    '#-0',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
   '#-+0',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
   '#-0 ',    2,       "0 ",      "0x1",    "0x100",   "0x-100",
  '#-+0 ',    2,       "0 ",      "0x1",    "0x100",   "0x-100",

             # 8 positions, should always fit
       '',    8, "       0", "       1", "     100", "    -100",
      ' ',    8, "       0", "       1", "     100", "    -100",
# NOTE: all the "0000-100" are bogus, but provided by the current implementation
      '0',    8, "00000000", "00000001", "00000100", "0000-100",
     '0 ',    8, "00000000", "00000001", "00000100", "0000-100",
      '+',    8, "       0", "       1", "     100", "    -100",
     '+ ',    8, "       0", "       1", "     100", "    -100",
     '+0',    8, "00000000", "00000001", "00000100", "0000-100",
    '+0 ',    8, "00000000", "00000001", "00000100", "0000-100",
      '-',    8, "0       ", "1       ", "100     ", "-100    ",
     '-+',    8, "0       ", "1       ", "100     ", "-100    ",
     '- ',    8, "0       ", "1       ", "100     ", "-100    ",
    '-+ ',    8, "0       ", "1       ", "100     ", "-100    ",
     '-0',    8, "0       ", "1       ", "100     ", "-100    ",
    '-+0',    8, "0       ", "1       ", "100     ", "-100    ",
    '-0 ',    8, "0       ", "1       ", "100     ", "-100    ",
   '-+0 ',    8, "0       ", "1       ", "100     ", "-100    ",
# NOTE: all the "*0x-100" are bogus, but provided by the current implementation
      '#',    8, "       0", "     0x1", "   0x100", "  0x-100",
     '# ',    8, "       0", "     0x1", "   0x100", "  0x-100",
     '#0',    8, "00000000", "000000x1", "0000x100", "000x-100",
    '#0 ',    8, "00000000", "000000x1", "0000x100", "000x-100",
     '#+',    8, "       0", "     0x1", "   0x100", "  0x-100",
    '#+ ',    8, "       0", "     0x1", "   0x100", "  0x-100",
    '#+0',    8, "00000000", "000000x1", "0000x100", "000x-100",
   '#+0 ',    8, "00000000", "000000x1", "0000x100", "000x-100",
     '#-',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
    '#-+',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
    '#- ',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
   '#-+ ',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
    '#-0',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
   '#-+0',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
   '#-0 ',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",
  '#-+0 ',    8, "0       ", "0x1     ", "0x100   ", "0x-100  ",

             # 8 positions with precision, precision fits sometimes
       '',  8.2, "      00", "      01", "     100", "    -100",
      ' ',  8.2, "      00", "      01", "     100", "    -100",
      '0',  8.2, "      00", "      01", "     100", "    -100",
     '0 ',  8.2, "      00", "      01", "     100", "    -100",
      '+',  8.2, "      00", "      01", "     100", "    -100",
     '+ ',  8.2, "      00", "      01", "     100", "    -100",
     '+0',  8.2, "      00", "      01", "     100", "    -100",
    '+0 ',  8.2, "      00", "      01", "     100", "    -100",
      '-',  8.2, "00      ", "01      ", "100     ", "-100    ",
     '-+',  8.2, "00      ", "01      ", "100     ", "-100    ",
     '- ',  8.2, "00      ", "01      ", "100     ", "-100    ",
    '-+ ',  8.2, "00      ", "01      ", "100     ", "-100    ",
     '-0',  8.2, "00      ", "01      ", "100     ", "-100    ",
    '-+0',  8.2, "00      ", "01      ", "100     ", "-100    ",
    '-0 ',  8.2, "00      ", "01      ", "100     ", "-100    ",
   '-+0 ',  8.2, "00      ", "01      ", "100     ", "-100    ",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
     '# ',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
     '#0',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
    '#0 ',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
     '#+',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
    '#+ ',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
    '#+0',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
   '#+0 ',  8.2, "      00", "    0x01", "   0x100", "  0x-100",
     '#-',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#-+',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#- ',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-+ ',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#-0',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-+0',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-0 ',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",
  '#-+0 ',  8.2, "00      ", "0x01    ", "0x100   ", "0x-100  ",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    @flat.append(
      '%' ~ $_ ~ $size ~ 'x',
      ($r0 => 0, $r1 => 1, $r4 => 256, $rm => -256)
    ) for $flags.comb.permutations>>.join;
    |@flat
}

# tests using variable precision
@info.append( (
             # no size, precision 0
       '', '.*',         "",        "1",      "100",     "-100",
      ' ', '.*',         "",        "1",      "100",     "-100",
      '0', '.*',         "",        "1",      "100",     "-100",
     '0 ', '.*',         "",        "1",      "100",     "-100",
      '+', '.*',         "",        "1",      "100",     "-100",
     '+ ', '.*',         "",        "1",      "100",     "-100",
     '+0', '.*',         "",        "1",      "100",     "-100",
    '+0 ', '.*',         "",        "1",      "100",     "-100",
      '-', '.*',         "",        "1",      "100",     "-100",
     '-+', '.*',         "",        "1",      "100",     "-100",
     '- ', '.*',         "",        "1",      "100",     "-100",
    '-+ ', '.*',         "",        "1",      "100",     "-100",
     '-0', '.*',         "",        "1",      "100",     "-100",
    '-+0', '.*',         "",        "1",      "100",     "-100",
    '-0 ', '.*',         "",        "1",      "100",     "-100",
   '-+0 ', '.*',         "",        "1",      "100",     "-100",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#', '.*',         "",      "0x1",    "0x100",   "0x-100",
     '# ', '.*',         "",      "0x1",    "0x100",   "0x-100",
     '#0', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#0 ', '.*',         "",      "0x1",    "0x100",   "0x-100",
     '#+', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#+ ', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#+0', '.*',         "",      "0x1",    "0x100",   "0x-100",
   '#+0 ', '.*',         "",      "0x1",    "0x100",   "0x-100",
     '#-', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#-+', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#- ', '.*',         "",      "0x1",    "0x100",   "0x-100",
   '#-+ ', '.*',         "",      "0x1",    "0x100",   "0x-100",
    '#-0', '.*',         "",      "0x1",    "0x100",   "0x-100",
   '#-+0', '.*',         "",      "0x1",    "0x100",   "0x-100",
   '#-0 ', '.*',         "",      "0x1",    "0x100",   "0x-100",
  '#-+0 ', '.*',         "",      "0x1",    "0x100",   "0x-100",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    @flat.append(
      '%' ~ $_ ~ $size ~ 'x',
      ($r0 => (0,0), $r1 => (0,1), $r4 => (0,256), $rm => (0,-256))
   ) for $flags.comb.permutations>>.join;
   |@flat
} );

@info.append( (
             # 8 positions with precision, precision fits sometimes
       '', "8.*", "      00", "      01", "     100", "    -100",
      ' ', "8.*", "      00", "      01", "     100", "    -100",
      '0', "8.*", "      00", "      01", "     100", "    -100",
     '0 ', "8.*", "      00", "      01", "     100", "    -100",
      '+', "8.*", "      00", "      01", "     100", "    -100",
     '+ ', "8.*", "      00", "      01", "     100", "    -100",
     '+0', "8.*", "      00", "      01", "     100", "    -100",
    '+0 ', "8.*", "      00", "      01", "     100", "    -100",
      '-', "8.*", "00      ", "01      ", "100     ", "-100    ",
     '-+', "8.*", "00      ", "01      ", "100     ", "-100    ",
     '- ', "8.*", "00      ", "01      ", "100     ", "-100    ",
    '-+ ', "8.*", "00      ", "01      ", "100     ", "-100    ",
     '-0', "8.*", "00      ", "01      ", "100     ", "-100    ",
    '-+0', "8.*", "00      ", "01      ", "100     ", "-100    ",
    '-0 ', "8.*", "00      ", "01      ", "100     ", "-100    ",
   '-+0 ', "8.*", "00      ", "01      ", "100     ", "-100    ",
# NOTE: all the "0x-100" are bogus, but provided by the current implementation
      '#', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
     '# ', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
     '#0', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
    '#0 ', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
     '#+', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
    '#+ ', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
    '#+0', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
   '#+0 ', "8.*", "      00", "    0x01", "   0x100", "  0x-100",
     '#-', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#-+', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#- ', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-+ ', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
    '#-0', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-+0', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
   '#-0 ', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",
  '#-+0 ', "8.*", "00      ", "0x01    ", "0x100   ", "0x-100  ",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    @flat.append(
      '%' ~ $_ ~ $size ~ 'x',
      ($r0 => (2,0), $r1 => (2,1), $r4 => (2,256), $rm => (2,-256))
   ) for $flags.comb.permutations>>.join;
   |@flat
} );

plan @info/2;

for @info -> $format, @tests {
    subtest {
        plan 2 * @tests;

        for @tests {
            is-deeply zprintf($format, |.value), .key,
              qq/zprintf("$format",{.value.list.join(",")}) eq '{.key}'/;
            is-deeply zprintf($format.uc, |.value), .key.uc,
              qq/zprintf("{$format.uc}",{.value.list.join(",")}) eq '{.key.uc}'/;
        }
    }, "Tested '$format'";
}

# vim: expandtab shiftwidth=4
