"""Integration tests for Rage4"""

import pytest
from integration_tests import IntegrationTestsV2


# Hook into testing framework by inheriting unittest.TestCase and reuse
# the tests which *each and every* implementation of the interface must
# pass, by inheritance from define_tests.TheTests
class TestRage4Provider(IntegrationTestsV2):
    """TestCase for Rage4"""

    provider_name = "rage4"
    domain = "capsulecd.com"

    def _filter_headers(self):
        return ["Authorization"]

    @pytest.mark.skip(reason="update requires type to be specified for this provider")
    def test_provider_when_calling_update_record_with_full_name_should_modify_record(
        self,
    ):
        return

    @pytest.mark.skip(reason="update requires type to be specified for this provider")
    def test_provider_when_calling_update_record_should_modify_record(self):
        return

    # TODO: enable the skipped tests
    @pytest.mark.skip(reason="new test, missing recording")
    def test_provider_when_calling_update_record_should_modify_record_name_specified(
        self,
    ):
        return
