/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalZone {
    /// Unique identifier of the rental provider
    #[serde(rename = "providerId")]
    pub provider_id: String,
    /// Unique identifier of the rental provider group
    #[serde(rename = "providerGroupId")]
    pub provider_group_id: String,
    /// Public name of the geofencing zone
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Zone precedence / z-index (higher number = higher precedence)
    #[serde(rename = "z")]
    pub z: i32,
    /// Bounding box of the area covered by this zone, [west, south, east, north] as [lon, lat, lon, lat] 
    #[serde(rename = "bbox")]
    pub bbox: Vec<f64>,
    /// A multi-polygon contains a number of polygons, each containing a number of rings, which are encoded as polylines (with precision 6).  For each polygon, the first ring is the outer ring, all subsequent rings are inner rings (holes). 
    #[serde(rename = "area")]
    pub area: Vec<Vec<models::EncodedPolyline>>,
    #[serde(rename = "rules")]
    pub rules: Vec<models::RentalZoneRestrictions>,
}

impl RentalZone {
    pub fn new(provider_id: String, provider_group_id: String, z: i32, bbox: Vec<f64>, area: Vec<Vec<models::EncodedPolyline>>, rules: Vec<models::RentalZoneRestrictions>) -> RentalZone {
        RentalZone {
            provider_id,
            provider_group_id,
            name: None,
            z,
            bbox,
            area,
            rules,
        }
    }
}

