:::{default-domain} bzl
:::

# Use in BUILD.bazel files

Once you have setup the dependencies, you are ready to start using them in your `BUILD.bazel`
files. If you haven't done so yet, set it up by following the following docs:
1. [WORKSPACE](./download-workspace)
1. [bzlmod](./download)

To refer to targets in a hub repo `pypi`, you can do one of two things:
```starlark
py_library(
    name = "my_lib",
    deps = [
        "@pypi//numpy",
    ],
)
```

Or use the `requirement` helper that needs to be loaded from the `hub` repo itself:
```starlark
load("@pypi//:requirements.bzl", "requirement")

py_library(
    deps = [
        requirement("numpy")
    ],
)
```

Note, that the usage of the `requirement` helper is not advised and can be problematic. See the
[notes below](#requirement-helper).

Note, that the hub repo contains the following targets for each package:
* `@pypi//numpy` which is a shorthand for `@pypi//numpy:numpy`. This is an {obj}`alias` to
  `@pypi//numpy:pkg`.
* `@pypi//numpy:pkg` - the {obj}`py_library` target automatically generated by the repository
  rules.
* `@pypi//numpy:data` - the {obj}`filegroup` that is for all of the extra files that are included
  as data in the `pkg` target.
* `@pypi//numpy:dist_info` - the {obj}`filegroup` that is for all of the files in the `<pkg prefix with version>.distinfo` directory.
* `@pypi//numpy:whl` - the {obj}`filegroup` that is the `.whl` file itself which includes all of
  the transitive dependencies via the {attr}`filegroup.data` attribute.

## Entry points

If you would like to access [entry points][whl_ep], see the `py_console_script_binary` rule documentation,
which can help you create a `py_binary` target for a particular console script exposed by a package.

[whl_ep]: https://packaging.python.org/specifications/entry-points/

## 'Extras' dependencies

Any 'extras' specified in the requirements lock file will be automatically added
as transitive dependencies of the package. In the example above, you'd just put
`requirement("useful_dep")` or `@pypi//useful_dep`.

## Consuming Wheel Dists Directly

If you need to depend on the wheel dists themselves, for instance, to pass them
to some other packaging tool, you can get a handle to them with the
`whl_requirement` macro. For example:

```starlark
load("@pypi//:requirements.bzl", "whl_requirement")

filegroup(
    name = "whl_files",
    data = [
        # This is equivalent to "@pypi//boto3:whl"
        whl_requirement("boto3"),
    ]
)
```

## Creating a filegroup of files within a whl

The rule {obj}`whl_filegroup` exists as an easy way to extract the necessary files
from a whl file without the need to modify the `BUILD.bazel` contents of the
whl repositories generated via `pip_repository`. Use it similarly to the `filegroup`
above. See the API docs for more information.

(requirement-helper)=
## A note about using the requirement helper

Each extracted wheel repo contains a `py_library` target representing
the wheel's contents. There are two ways to access this library. The
first uses the `requirement()` function defined in the central
repo's `//:requirements.bzl` file. This function maps a pip package
name to a label:

```starlark
load("@my_deps//:requirements.bzl", "requirement")

py_library(
    name = "mylib",
    srcs = ["mylib.py"],
    deps = [
        ":myotherlib",
        requirement("some_pip_dep"),
        requirement("another_pip_dep"),
    ]
)
```

The reason `requirement()` exists is to insulate from
changes to the underlying repository and label strings. However, those
labels have become directly used, so aren't able to easily change regardless.

On the other hand, using `requirement()` helper has several drawbacks:

- It doesn't work with `buildifier`
- It doesn't work with `buildozer`
- It adds extra layer on top of normal mechanisms to refer to targets.
- It does not scale well as each type of target needs a new macro to be loaded and imported.

If you don't want to use `requirement()`, you can use the library labels directly instead. For
`pip_parse`, the labels are of the following form:

```starlark
@{name}//{package}
```

Here `name` is the `name` attribute that was passed to `pip_parse` and
`package` is the pip package name with characters that are illegal in
Bazel label names (e.g. `-`, `.`) replaced with `_`. If you need to
update `name` from "old" to "new", then you can run the following
`buildozer` command:

```shell
buildozer 'substitute deps @old//([^/]+) @new//${1}' //...:*
```
