/*****************************************************************************
 * Copyright (C) 2020 VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * ( at your option ) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
import QtQuick

import VLC.Style

NavigableRow {
    id: row

    property var currentView
    signal clicked(int index)

    height: VLCStyle.localToolbar_height
    focus: true

    Accessible.role: Accessible.PageTabList

    property alias model: repeater.model

    Repeater {
        id: repeater

        delegate: BannerTabButton {
            text: model.displayText
            selected: model.name === row.currentView
            showCurrentIndicator: false
            height: VLCStyle.localToolbar_height
            onClicked: row.clicked(index)
        }
    }
}
