/*
 * Decompiled with CFR 0.152.
 */
package os;

import geny.Writable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import os.Internals$;
import os.Path;
import os.PathChunk$;
import os.SegmentedPath;
import os.SubPath;
import os.copy$;
import os.exists$;
import os.isDir$;
import os.isFile$;
import os.mtime$;
import os.mtime$set$;
import os.package$;
import os.read$inputStream$;
import os.remove$all$;
import os.walk$;
import os.zip;
import os.zip$ZipSource$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class zip$
implements Serializable {
    public static final zip$ZipSource$ ZipSource;
    public static final zip$ MODULE$;

    private zip$() {
    }

    static {
        MODULE$ = new zip$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(zip$.class);
    }

    public zip.ZipRoot open(Path path) {
        Tuple2[] tuple2Array = new Tuple2[1];
        String string2 = Predef$.MODULE$.ArrowAssoc("create");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, "true");
        return new zip.ZipRoot(FileSystems.newFileSystem(new URI("jar", path.wrapped().toUri().toString(), null), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava()));
    }

    public Path apply(Path dest, Seq<zip.ZipSource> sources, Seq<Regex> excludePatterns, Seq<Regex> includePatterns, boolean preserveMtimes, Seq<Regex> deletePatterns, int compressionLevel) {
        if (exists$.MODULE$.apply(dest)) {
            try (zip.ZipRoot opened = this.open(dest);){
                walk$.MODULE$.apply(opened, walk$.MODULE$.apply$default$2(), walk$.MODULE$.apply$default$3(), walk$.MODULE$.apply$default$4(), walk$.MODULE$.apply$default$5(), walk$.MODULE$.apply$default$6()).withFilter((Function1<Path, boolean> & Serializable)openedPath -> this.anyPatternsMatch(openedPath.relativeTo(opened).toString(), deletePatterns)).foreach(openedPath -> remove$all$.MODULE$.apply((Path)openedPath));
                this.createNewZip0(sources, excludePatterns, includePatterns, (path, sub) -> {
                    Path path2 = opened.$div(PathChunk$.MODULE$.SubPathChunk((SubPath)sub));
                    boolean bl = copy$.MODULE$.apply$default$3();
                    boolean bl2 = copy$.MODULE$.apply$default$4();
                    boolean bl3 = copy$.MODULE$.apply$default$5();
                    boolean bl4 = copy$.MODULE$.apply$default$7();
                    copy$.MODULE$.apply((Path)path, path2, bl, bl2, bl3, true, bl4);
                    if (!preserveMtimes) {
                        mtime$set$.MODULE$.apply(opened.$div(PathChunk$.MODULE$.SubPathChunk((SubPath)sub)), 0L);
                        BasicFileAttributeView view = Files.getFileAttributeView(opened.$div(PathChunk$.MODULE$.SubPathChunk((SubPath)sub)).toNIO(), BasicFileAttributeView.class, new LinkOption[0]);
                        view.setTimes(FileTime.fromMillis(0L), FileTime.fromMillis(0L), FileTime.fromMillis(0L));
                        return;
                    }
                });
            }
        }
        try (OutputStream f = Files.newOutputStream(dest.toNIO(), new OpenOption[0]);){
            this.createNewZip(sources, excludePatterns, includePatterns, preserveMtimes, compressionLevel, f);
        }
        return dest;
    }

    public Seq<zip.ZipSource> apply$default$2() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public Seq<Regex> apply$default$3() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public Seq<Regex> apply$default$4() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public boolean apply$default$5() {
        return false;
    }

    public Seq<Regex> apply$default$6() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public int apply$default$7() {
        return -1;
    }

    private void createNewZip0(Seq<zip.ZipSource> sources, Seq<Regex> excludePatterns, Seq<Regex> includePatterns, Function2<Path, SubPath, BoxedUnit> makeZipEntry0) {
        sources.foreach(source -> {
            if (isDir$.MODULE$.apply(source.src())) {
                walk$.MODULE$.apply(source.src(), walk$.MODULE$.apply$default$2(), walk$.MODULE$.apply$default$3(), walk$.MODULE$.apply$default$4(), walk$.MODULE$.apply$default$5(), walk$.MODULE$.apply$default$6()).foreach(path -> {
                    if (isFile$.MODULE$.apply((Path)path) && this.shouldInclude(path.toString(), excludePatterns, includePatterns)) {
                        makeZipEntry0.apply((Path)path, (SubPath)((SegmentedPath)source.dest().getOrElse(this::createNewZip0$$anonfun$1$$anonfun$1$$anonfun$1)).$div(PathChunk$.MODULE$.SubPathChunk(path.subRelativeTo(source.src()))));
                        return;
                    }
                });
                return;
            }
            if (this.shouldInclude(source.src().last(), excludePatterns, includePatterns)) {
                makeZipEntry0.apply(source.src(), (SubPath)source.dest().getOrElse(() -> this.createNewZip0$$anonfun$1$$anonfun$2(source)));
                return;
            }
        });
    }

    private void createNewZip(Seq<zip.ZipSource> sources, Seq<Regex> excludePatterns, Seq<Regex> includePatterns, boolean preserveMtimes, int compressionLevel, OutputStream out) {
        zipOut.setLevel(compressionLevel);
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            this.createNewZip0(sources, excludePatterns, includePatterns, (path, sub) -> this.makeZipEntry((Path)path, (SubPath)sub, preserveMtimes, zipOut));
        }
    }

    public boolean anyPatternsMatch(String fileName, Seq<Regex> patterns) {
        return patterns.exists((Function1<Regex, boolean> & Serializable)_$1 -> _$1.findFirstIn(fileName).isDefined());
    }

    public boolean shouldInclude(String fileName, Seq<Regex> excludePatterns, Seq<Regex> includePatterns) {
        boolean isExcluded = this.anyPatternsMatch(fileName, excludePatterns);
        boolean isIncluded = includePatterns.isEmpty() || this.anyPatternsMatch(fileName, includePatterns);
        return !isExcluded && isIncluded;
    }

    private void makeZipEntry(Path file, SubPath sub, boolean preserveMtimes, ZipOutputStream zipOut) {
        None$ mtimeOpt = preserveMtimes ? Some$.MODULE$.apply(BoxesRunTime.boxToLong(mtime$.MODULE$.apply(file))) : None$.MODULE$;
        None$ fis = isFile$.MODULE$.apply(file) ? Some$.MODULE$.apply(read$inputStream$.MODULE$.apply(file)) : None$.MODULE$;
        try {
            this.makeZipEntry0(sub, fis, mtimeOpt, zipOut);
        }
        finally {
            fis.foreach(_$2 -> _$2.close());
        }
    }

    private void makeZipEntry0(SubPath sub, Option<InputStream> is, Option<Object> preserveMtimes, ZipOutputStream zipOut) {
        ZipEntry zipEntry = new ZipEntry(sub.toString());
        Option<Object> option = preserveMtimes;
        if (option instanceof Some) {
            long mtime2 = BoxesRunTime.unboxToLong(((Some)option).value());
            zipEntry.setTime(mtime2);
        } else if (None$.MODULE$.equals(option)) {
            zipEntry.setTime(0L);
        } else {
            throw new MatchError(option);
        }
        zipOut.putNextEntry(zipEntry);
        is.foreach(_$3 -> Internals$.MODULE$.transfer((InputStream)_$3, zipOut, false));
    }

    public Writable stream(Seq<zip.ZipSource> sources, Seq<Regex> excludePatterns, Seq<Regex> includePatterns, boolean preserveMtimes, int compressionLevel) {
        return new Writable(sources, excludePatterns, includePatterns, preserveMtimes, compressionLevel, this){
            private final Seq sources$2;
            private final Seq excludePatterns$5;
            private final Seq includePatterns$5;
            private final boolean preserveMtimes$4;
            private final int compressionLevel$2;
            {
                this.sources$2 = sources$3;
                this.excludePatterns$5 = excludePatterns$7;
                this.includePatterns$5 = includePatterns$7;
                this.preserveMtimes$4 = preserveMtimes$5;
                this.compressionLevel$2 = compressionLevel$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final void writeBytesTo(OutputStream outputStream) {
                zip$.MODULE$.os$zip$$$_$stream$$anonfun$1(this.sources$2, this.excludePatterns$5, this.includePatterns$5, this.preserveMtimes$4, this.compressionLevel$2, outputStream);
            }
        };
    }

    public Seq<Regex> stream$default$2() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public Seq<Regex> stream$default$3() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Nothing$[0]));
    }

    public boolean stream$default$4() {
        return false;
    }

    public int stream$default$5() {
        return -1;
    }

    private final SubPath createNewZip0$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.sub();
    }

    private final SubPath createNewZip0$$anonfun$1$$anonfun$2(zip.ZipSource source$2) {
        return (SubPath)package$.MODULE$.sub().$div(PathChunk$.MODULE$.StringPathChunkInternal(source$2.src().last()));
    }

    public final /* synthetic */ void os$zip$$$_$stream$$anonfun$1(Seq sources$1, Seq excludePatterns$3, Seq includePatterns$3, boolean preserveMtimes$3, int compressionLevel$1, OutputStream outputStream) {
        this.createNewZip(sources$1, excludePatterns$3, includePatterns$3, preserveMtimes$3, compressionLevel$1, outputStream);
    }
}

