/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_te extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "గ్రీన్‌విచ్ సగటు సమయం",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "ఏకర్ ప్రామాణిక సమయం",
               "",
               "ఏకర్ వేసవి సమయం",
               "",
               "ఏకర్ సమయం",
               "",
            };
        final String[] Apia = new String[] {
               "సమోవా ప్రామాణిక సమయం",
               "",
               "సమోవా పగటి వెలుతురు సమయం",
               "",
               "సమోవా సమయం",
               "",
            };
        final String[] Cook = new String[] {
               "కుక్ దీవుల ప్రామాణిక సమయం",
               "",
               "కుక్ దీవుల అర్ధ వేసవి సమయం",
               "",
               "కుక్ దీవుల సమయం",
               "",
            };
        final String[] Cuba = new String[] {
               "క్యూబా ప్రామాణిక సమయం",
               "CST",
               "క్యూబా పగటి వెలుతురు సమయం",
               "CDT",
               "క్యూబా సమయం",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ఫిజీ ప్రామాణిక సమయం",
               "",
               "ఫిజీ వేసవి సమయం",
               "",
               "ఫిజీ సమయం",
               "",
            };
        final String[] Gulf = new String[] {
               "గల్ఫ్ ప్రామాణిక సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "హోవ్డ్ ప్రామాణిక సమయం",
               "",
               "హోవ్డ్ వేసవి సమయం",
               "",
               "హోవ్డ్ సమయం",
               "",
            };
        final String[] Iran = new String[] {
               "ఇరాన్ ప్రామాణిక సమయం",
               "",
               "ఇరాన్ పగటి వెలుతురు సమయం",
               "",
               "ఇరాన్ సమయం",
               "",
            };
        final String[] Niue = new String[] {
               "నియూ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ఓమ్స్క్ ప్రామాణిక సమయం",
               "",
               "ఓమ్స్క్ వేసవి సమయం",
               "",
               "ఓమ్స్క్ సమయం",
               "",
            };
        final String[] Peru = new String[] {
               "పెరూ ప్రామాణిక సమయం",
               "",
               "పెరూ వేసవి సమయం",
               "",
               "పెరూ సమయం",
               "",
            };
        final String[] Truk = new String[] {
               "చక్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "వేక్ దీవి సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "చిలీ ప్రామాణిక సమయం",
               "",
               "చిలీ వేసవి సమయం",
               "",
               "చిలీ సమయం",
               "",
            };
        final String[] China = new String[] {
               "చైనా ప్రామాణిక సమయం",
               "CST",
               "చైనా పగటి వెలుతురు సమయం",
               "CDT",
               "చైనా సమయం",
               "CT",
            };
        final String[] Cocos = new String[] {
               "కోకోస్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "డేవిస్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "భారతదేశ ప్రామాణిక సమయం",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "జపాన్ ప్రామాణిక సమయం",
               "JST",
               "జపాన్ పగటి వెలుతురు సమయం",
               "JDT",
               "జపాన్ సమయం",
               "JT",
            };
        final String[] Korea = new String[] {
               "కొరియన్ ప్రామాణిక సమయం",
               "KST",
               "కొరియన్ పగటి వెలుతురు సమయం",
               "KST",
               "కొరియన్ సమయం",
               "KST",
            };
        final String[] Nauru = new String[] {
               "నౌరు సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "నేపాల్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "పాలావ్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "సమోవా ప్రామాణిక సమయం",
               "SST",
               "సమోవా పగటి వెలుతురు సమయం",
               "SST",
               "సమోవా సమయం",
               "SST",
            };
        final String[] Syowa = new String[] {
               "స్యోవా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "టాంగా ప్రామాణిక సమయం",
               "",
               "టాంగా వేసవి సమయం",
               "",
               "టాంగా సమయం",
               "",
            };
        final String[] Yukon = new String[] {
               "యుకోన్ సమయం",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "అలాస్కా ప్రామాణిక సమయం",
               "AKST",
               "అలాస్కా పగటి వెలుతురు సమయం",
               "AKDT",
               "అలాస్కా సమయం",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "అమెజాన్ ప్రామాణిక సమయం",
               "",
               "అమెజాన్ వేసవి సమయం",
               "",
               "అమెజాన్ సమయం",
               "",
            };
        final String[] Azores = new String[] {
               "అజోర్స్ ప్రామాణిక సమయం",
               "",
               "అజోర్స్ వేసవి సమయం",
               "",
               "అజోర్స్ సమయం",
               "",
            };
        final String[] Bhutan = new String[] {
               "భూటాన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "బ్రూనై దారుసలామ్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ఈస్టర్ దీవి ప్రామాణిక సమయం",
               "",
               "ఈస్టర్ దీవి వేసవి సమయం",
               "",
               "ఈస్టర్ దీవి సమయం",
               "",
            };
        final String[] Guyana = new String[] {
               "గయానా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "హవాయ్-అల్యూషియన్ ప్రామాణిక సమయం",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ఇజ్రాయిల్ ప్రామాణిక సమయం",
               "IST",
               "ఇజ్రాయిల్ పగటి వెలుతురు సమయం",
               "IDT",
               "ఇజ్రాయిల్ సమయం",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "కోస్రాయి సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "మాసన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "మాస్కో ప్రామాణిక సమయం",
               "MSK",
               "మాస్కో వేసవి సమయం",
               "MSK",
               "మాస్కో సమయం",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "పొనేప్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "సమారా ప్రామాణిక సమయం",
               "",
               "సమారా వేసవి సమయం",
               "",
               "సమారా సమయం",
               "",
            };
        final String[] Tahiti = new String[] {
               "తహితి సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "తైవాన్ ప్రామాణిక సమయం",
               "CST",
               "తైవాన్ పగటి వెలుతురు సమయం",
               "CDT",
               "తైవాన్ సమయం",
               "CT",
            };
        final String[] Turkey = new String[] {
               "టర్కీ ప్రామాణిక సమయం",
               "",
               "టర్కీ వేసవి సమయం",
               "",
               "టర్కీ సమయం",
               "",
            };
        final String[] Tuvalu = new String[] {
               "తువాలు సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "వోస్టోక్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "వాలీస్ మరియు ఫుటునా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "అరేబియన్ ప్రామాణిక సమయం",
               "",
               "అరేబియన్ పగటి వెలుతురు సమయం",
               "",
               "అరేబియన్ సమయం",
               "",
            };
        final String[] Armenia = new String[] {
               "ఆర్మేనియా ప్రామాణిక సమయం",
               "",
               "ఆర్మేనియా వేసవి సమయం",
               "",
               "ఆర్మేనియా సమయం",
               "",
            };
        final String[] Bolivia = new String[] {
               "బొలీవియా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "చాథమ్ ప్రామాణిక సమయం",
               "",
               "చాథమ్ పగటి వెలుతురు సమయం",
               "",
               "చాథమ్ సమయం",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "సమన్వయ సార్వజనీన సమయం",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ఈక్వడార్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "గాంబియర్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "జార్జియా ప్రామాణిక సమయం",
               "",
               "జార్జియా వేసవి సమయం",
               "",
               "జార్జియా సమయం",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ఇర్కుట్స్క్ ప్రామాణిక సమయం",
               "",
               "ఇర్కుట్స్క్ వేసవి సమయం",
               "",
               "ఇర్కుట్స్క్ సమయం",
               "",
            };
        final String[] Magadan = new String[] {
               "మగడాన్ ప్రామాణిక సమయం",
               "",
               "మగడాన్ వేసవి సమయం",
               "",
               "మగడాన్ సమయం",
               "",
            };
        final String[] Myanmar = new String[] {
               "మయన్మార్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "నార్ఫోక్ దీవి ప్రామాణిక సమయం",
               "",
               "నార్ఫోక్ దీవి పగటి వెలుతురు సమయం",
               "",
               "నార్ఫోక్ దీవి సమయం",
               "",
            };
        final String[] Noronha = new String[] {
               "ఫెర్నాండో డి నొరోన్హా ప్రామాణిక సమయం",
               "",
               "ఫెర్నాండో డి నొరోన్హా వేసవి సమయం",
               "",
               "ఫెర్నాండో డి నొరోన్హా సమయం",
               "",
            };
        final String[] Reunion = new String[] {
               "రీయూనియన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "రొతేరా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "సోలమన్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "టోకెలావ్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ఉరుగ్వే ప్రామాణిక సమయం",
               "",
               "ఉరుగ్వే వేసవి సమయం",
               "",
               "ఉరుగ్వే సమయం",
               "",
            };
        final String[] Vanuatu = new String[] {
               "వనౌటు ప్రామాణిక సమయం",
               "",
               "వనౌటు వేసవి సమయం",
               "",
               "వనౌటు సమయం",
               "",
            };
        final String[] Yakutsk = new String[] {
               "యాకుట్స్క్ ప్రామాణిక సమయం",
               "",
               "యాకుట్స్క్ వేసవి సమయం",
               "",
               "యాకుట్స్క్ సమయం",
               "",
            };
        final String[] Atlantic = new String[] {
               "అట్లాంటిక్ ప్రామాణిక సమయం",
               "AST",
               "అట్లాంటిక్ పగటి వెలుతురు సమయం",
               "AST",
               "అట్లాంటిక్ సమయం",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "బ్రెజిలియా ప్రామాణిక సమయం",
               "",
               "బ్రెజిలియా వేసవి సమయం",
               "",
               "బ్రెజిలియా సమయం",
               "",
            };
        final String[] Chamorro = new String[] {
               "చామర్రో ప్రామాణిక సమయం",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "కొలంబియా ప్రామాణిక సమయం",
               "",
               "కొలంబియా వేసవి సమయం",
               "",
               "కొలంబియా సమయం",
               "",
            };
        final String[] Falkland = new String[] {
               "ఫాక్‌ల్యాండ్ దీవుల ప్రామాణిక సమయం",
               "",
               "ఫాక్‌ల్యాండ్ దీవుల వేసవి సమయం",
               "",
               "ఫాక్‌ల్యాండ్ దీవుల సమయం",
               "",
            };
        final String[] Malaysia = new String[] {
               "మలేషియా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "మాల్దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ఉలన్ బతోర్ ప్రామాణిక సమయం",
               "",
               "ఉలన్ బతోర్ వేసవి సమయం",
               "",
               "ఉలన్ బతోర్ సమయం",
               "",
            };
        final String[] Pakistan = new String[] {
               "పాకిస్తాన్ ప్రామాణిక సమయం",
               "PKT",
               "పాకిస్తాన్ వేసవి సమయం",
               "PKST",
               "పాకిస్తాన్ సమయం",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "పరాగ్వే ప్రామాణిక సమయం",
               "",
               "పరాగ్వే వేసవి సమయం",
               "",
               "పరాగ్వే సమయం",
               "",
            };
        final String[] Pitcairn = new String[] {
               "పిట్‌కైర్న్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "సూరినామ్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "అర్జెంటీనా ప్రామాణిక సమయం",
               "",
               "ఆర్జెంటీనా వేసవి సమయం",
               "",
               "అర్జెంటీనా సమయం",
               "",
            };
        final String[] Christmas = new String[] {
               "క్రిస్మస్ దీవి సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "గాలాపాగోస్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "హాంకాంగ్ ప్రామాణిక సమయం",
               "HKT",
               "హాంకాంగ్ వేసవి సమయం",
               "HKST",
               "హాంకాంగ్ సమయం",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ఇండోచైనా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి ప్రామాణిక సమయం",
               "",
               "పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి వేసవి సమయం",
               "",
               "పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి సమయం",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "కిర్గిస్తాన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "లార్డ్ హోవ్ ప్రామాణిక సమయం",
               "",
               "లార్డ్ హోవ్ పగటి వెలుతురు సమయం",
               "",
               "లార్డ్ హోవ్ సమయం",
               "",
            };
        final String[] Marquesas = new String[] {
               "మార్క్వేసాస్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "మారిషస్ ప్రామాణిక సమయం",
               "",
               "మారిషస్ వేసవి సమయం",
               "",
               "మారిషస్ సమయం",
               "",
            };
        final String[] Singapore = new String[] {
               "సింగపూర్ ప్రామాణిక సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "వెనిజులా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "అజర్బైజాన్ ప్రామాణిక సమయం",
               "",
               "అజర్బైజాన్ వేసవి సమయం",
               "",
               "అజర్బైజాన్ సమయం",
               "",
            };
        final String[] Bangladesh = new String[] {
               "బంగ్లాదేశ్ ప్రామాణిక సమయం",
               "",
               "బంగ్లాదేశ్ వేసవి సమయం",
               "",
               "బంగ్లాదేశ్ సమయం",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "కేప్ వెర్డె ప్రామాణిక సమయం",
               "",
               "కేప్ వెర్డె వేసవి సమయం",
               "",
               "కేప్ వెర్డె సమయం",
               "",
            };
        final String[] East_Timor = new String[] {
               "తూర్పు తైమూర్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "కజకిస్తాన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "సీషెల్స్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "తజికిస్తాన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ఉజ్బెకిస్తాన్ ప్రామాణిక సమయం",
               "",
               "ఉజ్బెకిస్తాన్ వేసవి సమయం",
               "",
               "ఉజ్బెకిస్తాన్ సమయం",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ఆఫ్ఘనిస్తాన్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "క్రాస్నోయార్స్క్ ప్రామాణిక సమయం",
               "",
               "క్రాస్నోయార్స్క్ వేసవి సమయం",
               "",
               "క్రాస్నోయార్స్క్ సమయం",
               "",
            };
        final String[] New_Zealand = new String[] {
               "న్యూజిల్యాండ్ ప్రామాణిక సమయం",
               "NZST",
               "న్యూజిల్యాండ్ పగటి వెలుతురు సమయం",
               "NZDT",
               "న్యూజిల్యాండ్ సమయం",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ఫిలిప్పైన్ ప్రామాణిక సమయం",
               "PST",
               "ఫిలిప్పైన్ వేసవి సమయం",
               "PDT",
               "ఫిలిప్పైన్ సమయం",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "వ్లాడివోస్టోక్ ప్రామాణిక సమయం",
               "",
               "వ్లాడివోస్టోక్ వేసవి సమయం",
               "",
               "వ్లాడివోస్టోక్ సమయం",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "హిందూ మహా సముద్ర సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "లైన్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "న్యూఫౌండ్‌ల్యాండ్ ప్రామాణిక సమయం",
               "NST",
               "న్యూఫౌండ్‌ల్యాండ్ పగటి వెలుతురు సమయం",
               "NDT",
               "న్యూఫౌండ్‌ల్యాండ్ సమయం",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "తుర్క్‌మెనిస్తాన్ ప్రామాణిక సమయం",
               "",
               "తుర్క్‌మెనిస్తాన్ వేసవి సమయం",
               "",
               "తుర్క్‌మెనిస్తాన్ సమయం",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ఫ్రెంచ్ గయానా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "న్యూ కాలెడోనియా ప్రామాణిక సమయం",
               "",
               "న్యూ కాలెడోనియా వేసవి సమయం",
               "",
               "న్యూ కాలెడోనియా సమయం",
               "",
            };
        final String[] South_Georgia = new String[] {
               "దక్షిణ జార్జియా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "యెకటెరిన్‌బర్గ్ ప్రామాణిక సమయం",
               "",
               "యెకటెరిన్‌బర్గ్ వేసవి సమయం",
               "",
               "యెకటెరిన్‌బర్గ్ సమయం",
               "",
            };
        final String[] Africa_Central = new String[] {
               "సెంట్రల్ ఆఫ్రికా సమయం",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "తూర్పు ఆఫ్రికా సమయం",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "పశ్చిమ ఆఫ్రికా సమయం",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "డ్యూమాంట్-డి’ఉర్విల్లే సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "సెంట్రల్ యూరోపియన్ ప్రామాణిక సమయం",
               "CET",
               "సెంట్రల్ యూరోపియన్ వేసవి సమయం",
               "CEST",
               "సెంట్రల్ యూరోపియన్ సమయం",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "తూర్పు యూరోపియన్ ప్రామాణిక సమయం",
               "EET",
               "తూర్పు యూరోపియన్ వేసవి సమయం",
               "EEST",
               "తూర్పు యూరోపియన్ సమయం",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "పశ్చిమ యూరోపియన్ ప్రామాణిక సమయం",
               "WET",
               "పశ్చిమ యూరోపియన్ వేసవి సమయం",
               "WEST",
               "పశ్చిమ యూరోపియన్ సమయం",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "మెక్సికన్ పసిఫిక్ ప్రామాణిక సమయం",
               "MST",
               "మెక్సికన్ పసిఫిక్ పగటి వెలుతురు సమయం",
               "MDT",
               "మెక్సికన్ పసిఫిక్ సమయం",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "దక్షిణ ఆఫ్రికా ప్రామాణిక సమయం",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "మధ్యమ ప్రామాణిక సమయం",
               "CST",
               "మధ్యమ పగటి వెలుతురు సమయం",
               "CDT",
               "మధ్యమ సమయం",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "తూర్పు ప్రామాణిక సమయం",
               "EST",
               "తూర్పు పగటి వెలుతురు సమయం",
               "EST",
               "తూర్పు సమయం",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "పసిఫిక్ ప్రామాణిక సమయం",
               "PST",
               "పసిఫిక్ పగటి వెలుతురు సమయం",
               "PDT",
               "పసిఫిక్ సమయం",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ఫ్రెంచ్ దక్షిణ మరియు అంటార్కిటిక్ సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "గిల్బర్ట్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "హవాయ్-అల్యూషియన్ ప్రామాణిక సమయం",
               "HST",
               "హవాయ్-అల్యూషియన్ పగటి వెలుతురు సమయం",
               "HDT",
               "హవాయ్-అల్యూషియన్ సమయం",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ఫినిక్స్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "సెయింట్ పియెర్ మరియు మిక్వెలాన్ ప్రామాణిక సమయం",
               "",
               "సెయింట్ పియర్ మరియు మిక్వెలాన్ పగటి వెలుతురు సమయం",
               "",
               "సెయింట్ పియెర్ మరియు మిక్వెలాన్ సమయం",
               "",
            };
        final String[] America_Mountain = new String[] {
               "మౌంటెయిన్ ప్రామాణిక సమయం",
               "MST",
               "మౌంటెయిన్ పగటి వెలుతురు సమయం",
               "MST",
               "మౌంటెయిన్ సమయం",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "మార్షల్ దీవుల సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "పాపువా న్యూ గినియా సమయం",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ఆస్ట్రేలియా మధ్యమ ప్రామాణిక సమయం",
               "ACST",
               "ఆస్ట్రేలియా మధ్యమ పగటి వెలుతురు సమయం",
               "ACDT",
               "ఆస్ట్రేలియా మధ్యమ సమయం",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ఆస్ట్రేలియన్ తూర్పు ప్రామాణిక సమయం",
               "AEST",
               "ఆస్ట్రేలియన్ తూర్పు పగటి వెలుతురు సమయం",
               "AEDT",
               "తూర్పు ఆస్ట్రేలియా సమయం",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ఆస్ట్రేలియన్ పశ్చిమ ప్రామాణిక సమయం",
               "AWST",
               "ఆస్ట్రేలియన్ పశ్చిమ పగటి వెలుతురు సమయం",
               "AWDT",
               "పశ్చిమ ఆస్ట్రేలియా సమయం",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "సెంట్రల్ ఇండోనేషియా సమయం",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "తూర్పు ఇండోనేషియా సమయం",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "పశ్చిమ ఇండోనేషియా సమయం",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "మధ్యమ ఆస్ట్రేలియన్ పశ్చిమ ప్రామాణిక సమయం",
               "",
               "ఆస్ట్రేలియా మధ్యమ పశ్చిమ పగటి వెలుతురు సమయం",
               "",
               "ఆస్ట్రేలియా మధ్యమ పశ్చిమ సమయం",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "ఐరిష్ ప్రామాణిక సమయం",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "సమన్వయ సార్వజనీన సమయం",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "ఐరిష్ ప్రామాణిక సమయం",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "గ్రీన్‌విచ్ సగటు సమయం",
                    "GMT",
                    "బ్రిటీష్ వేసవి సమయం",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ఎడెన్" },
            { "timezone.excity.Asia/Baku", "బాకు" },
            { "timezone.excity.Asia/Dili", "డిలి" },
            { "timezone.excity.Asia/Gaza", "గాజా" },
            { "timezone.excity.Asia/Hovd", "హోవ్డ్" },
            { "timezone.excity.Asia/Omsk", "ఓమ్స్క్" },
            { "timezone.excity.Asia/Oral", "ఓరల్" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "అమ్మన్" },
            { "timezone.excity.Asia/Aqtau", "అక్టావ్" },
            { "timezone.excity.Asia/Chita", "చితా" },
            { "timezone.excity.Asia/Dhaka", "ఢాకా" },
            { "timezone.excity.Asia/Dubai", "దుబాయి" },
            { "timezone.excity.Asia/Kabul", "కాబుల్" },
            { "timezone.excity.Asia/Macau", "మకావ్" },
            { "timezone.excity.Asia/Qatar", "ఖతార్" },
            { "timezone.excity.Asia/Seoul", "సియోల్" },
            { "timezone.excity.Asia/Tokyo", "టోక్యో" },
            { "timezone.excity.Asia/Tomsk", "టామ్స్క్" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "జుబా" },
            { "timezone.excity.Africa/Lome", "లోమ్" },
            { "timezone.excity.Asia/Almaty", "ఆల్మాటి" },
            { "timezone.excity.Asia/Anadyr", "అనడైర్" },
            { "timezone.excity.Asia/Aqtobe", "అక్టోబ్" },
            { "timezone.excity.Asia/Atyrau", "ఆటిరా" },
            { "timezone.excity.Asia/Beirut", "బీరట్" },
            { "timezone.excity.Asia/Brunei", "బ్రూనై" },
            { "timezone.excity.Asia/Hebron", "హెబ్రాన్" },
            { "timezone.excity.Asia/Kuwait", "కువైట్" },
            { "timezone.excity.Asia/Manila", "మనీలా" },
            { "timezone.excity.Asia/Muscat", "మస్కట్" },
            { "timezone.excity.Asia/Riyadh", "రియాధ్" },
            { "timezone.excity.Asia/Saigon", "హో చి మిన్హ్ నగరం" },
            { "timezone.excity.Asia/Taipei", "తైపీ" },
            { "timezone.excity.Asia/Tehran", "టెహ్రాన్" },
            { "timezone.excity.Asia/Urumqi", "ఉరుమ్‌కీ" },
            { "timezone.excity.Etc/Unknown", "తెలియని లొకేషన్" },
            { "timezone.excity.Europe/Kiev", "కీవ్" },
            { "timezone.excity.Europe/Oslo", "ఓస్లో" },
            { "timezone.excity.Europe/Riga", "రీగా" },
            { "timezone.excity.Europe/Rome", "రోమ్" },
            { "timezone.excity.Indian/Mahe", "మాహె" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "అక్రా" },
            { "timezone.excity.Africa/Cairo", "కైరో" },
            { "timezone.excity.Africa/Ceuta", "స్యూటా" },
            { "timezone.excity.Africa/Dakar", "డకార్" },
            { "timezone.excity.Africa/Lagos", "లాగోస్" },
            { "timezone.excity.Africa/Tunis", "ట్యునిస్" },
            { "timezone.excity.America/Adak", "అడాక్" },
            { "timezone.excity.America/Lima", "లిమా" },
            { "timezone.excity.America/Nome", "నోమ్" },
            { "timezone.excity.Asia/Baghdad", "బాగ్దాద్" },
            { "timezone.excity.Asia/Bahrain", "బహ్రెయిన్" },
            { "timezone.excity.Asia/Bangkok", "బ్యాంకాక్" },
            { "timezone.excity.Asia/Barnaul", "బార్నాల్" },
            { "timezone.excity.Asia/Bishkek", "బిష్కెక్" },
            { "timezone.excity.Asia/Colombo", "కొలంబో" },
            { "timezone.excity.Asia/Irkutsk", "ఇర్కుట్స్క్" },
            { "timezone.excity.Asia/Jakarta", "జకార్తా" },
            { "timezone.excity.Asia/Karachi", "కరాచీ" },
            { "timezone.excity.Asia/Kuching", "కుచింగ్" },
            { "timezone.excity.Asia/Magadan", "మగడాన్" },
            { "timezone.excity.Asia/Nicosia", "నికోసియా" },
            { "timezone.excity.Asia/Rangoon", "యాంగన్" },
            { "timezone.excity.Asia/Tbilisi", "టిబిలిసి" },
            { "timezone.excity.Asia/Thimphu", "థింఫు" },
            { "timezone.excity.Asia/Yakutsk", "యకుట్స్క్" },
            { "timezone.excity.Asia/Yerevan", "యెరెవన్" },
            { "timezone.excity.Europe/Kirov", "కిరోవ్" },
            { "timezone.excity.Europe/Malta", "మాల్టా" },
            { "timezone.excity.Europe/Minsk", "మిన్స్క్" },
            { "timezone.excity.Europe/Paris", "ప్యారిస్" },
            { "timezone.excity.Europe/Sofia", "సోఫియా" },
            { "timezone.excity.Europe/Vaduz", "వాడుజ్" },
            { "timezone.excity.Indian/Cocos", "కోకోస్ దీవులు" },
            { "timezone.excity.Pacific/Apia", "ఏపియా" },
            { "timezone.excity.Pacific/Fiji", "ఫీజీ" },
            { "timezone.excity.Pacific/Guam", "గ్వామ్" },
            { "timezone.excity.Pacific/Niue", "నియూ" },
            { "timezone.excity.Pacific/Truk", "చుక్" },
            { "timezone.excity.Pacific/Wake", "వేక్ దీవి" },
            { "timezone.excity.Africa/Asmera", "అస్మారా" },
            { "timezone.excity.Africa/Bamako", "బామాకో" },
            { "timezone.excity.Africa/Bangui", "బాంగుయ్" },
            { "timezone.excity.Africa/Banjul", "బంజూల్" },
            { "timezone.excity.Africa/Bissau", "బిస్సావ్" },
            { "timezone.excity.Africa/Douala", "డౌలా" },
            { "timezone.excity.Africa/Harare", "హరారే" },
            { "timezone.excity.Africa/Kigali", "కీగలి" },
            { "timezone.excity.Africa/Luanda", "లువాండా" },
            { "timezone.excity.Africa/Lusaka", "లుసాకా" },
            { "timezone.excity.Africa/Malabo", "మలాబో" },
            { "timezone.excity.Africa/Maputo", "మాపుటో" },
            { "timezone.excity.Africa/Maseru", "మసేరు" },
            { "timezone.excity.Africa/Niamey", "నియామే" },
            { "timezone.excity.America/Aruba", "అరుబా" },
            { "timezone.excity.America/Bahia", "బహియ" },
            { "timezone.excity.America/Belem", "బెలెమ్" },
            { "timezone.excity.America/Boise", "బొయిసీ" },
            { "timezone.excity.America/Jujuy", "జుజుయ్" },
            { "timezone.excity.America/Sitka", "సిట్కా" },
            { "timezone.excity.America/Thule", "థులే" },
            { "timezone.excity.Asia/Ashgabat", "యాష్గాబాట్" },
            { "timezone.excity.Asia/Calcutta", "కోల్‌కతా" },
            { "timezone.excity.Asia/Damascus", "డమాస్కస్" },
            { "timezone.excity.Asia/Dushanbe", "డుషన్బీ" },
            { "timezone.excity.Asia/Jayapura", "జయపుర" },
            { "timezone.excity.Asia/Katmandu", "ఖాట్మండు" },
            { "timezone.excity.Asia/Khandyga", "కంద్యాగ" },
            { "timezone.excity.Asia/Makassar", "మకాస్సర్" },
            { "timezone.excity.Asia/Qostanay", "కోస్తానే" },
            { "timezone.excity.Asia/Sakhalin", "సఖాలిన్" },
            { "timezone.excity.Asia/Shanghai", "షాంఘై" },
            { "timezone.excity.Asia/Tashkent", "తాష్కెంట్" },
            { "timezone.excity.Asia/Ust-Nera", "అస్ట్-నెరా" },
            { "timezone.excity.Europe/Athens", "ఏథెన్స్" },
            { "timezone.excity.Europe/Berlin", "బెర్లిన్" },
            { "timezone.excity.Europe/Dublin", "డబ్లిన్" },
            { "timezone.excity.Europe/Jersey", "జెర్సీ" },
            { "timezone.excity.Europe/Lisbon", "లిస్బన్" },
            { "timezone.excity.Europe/London", "లండన్" },
            { "timezone.excity.Europe/Madrid", "మాడ్రిడ్" },
            { "timezone.excity.Europe/Monaco", "మొనాకో" },
            { "timezone.excity.Europe/Moscow", "మాస్కో" },
            { "timezone.excity.Europe/Prague", "ప్రాగ్" },
            { "timezone.excity.Europe/Samara", "సమార" },
            { "timezone.excity.Europe/Skopje", "స్కోప్‌యే" },
            { "timezone.excity.Europe/Tirane", "టిరేన్" },
            { "timezone.excity.Europe/Vienna", "వియన్నా" },
            { "timezone.excity.Europe/Warsaw", "వార్షా" },
            { "timezone.excity.Europe/Zagreb", "జాగ్రెబ్" },
            { "timezone.excity.Europe/Zurich", "జ్యూరిచ్" },
            { "timezone.excity.Indian/Chagos", "చాగోస్" },
            { "timezone.excity.Indian/Comoro", "కొమోరో" },
            { "timezone.excity.Pacific/Efate", "ఇఫేట్" },
            { "timezone.excity.Pacific/Nauru", "నౌరు" },
            { "timezone.excity.Pacific/Palau", "పాలావ్" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "అబిడ్జాన్" },
            { "timezone.excity.Africa/Algiers", "అల్జియర్స్" },
            { "timezone.excity.Africa/Conakry", "కోనాక్రీ" },
            { "timezone.excity.Africa/Kampala", "కంపాలా" },
            { "timezone.excity.Africa/Mbabane", "బాబెన్" },
            { "timezone.excity.Africa/Nairobi", "నైరోబీ" },
            { "timezone.excity.Africa/Tripoli", "ట్రిపోలి" },
            { "timezone.excity.America/Belize", "బెలీజ్" },
            { "timezone.excity.America/Bogota", "బగోటా" },
            { "timezone.excity.America/Cancun", "కన్‌కూన్" },
            { "timezone.excity.America/Cayman", "కేమాన్" },
            { "timezone.excity.America/Cuiaba", "కుయబా" },
            { "timezone.excity.America/Dawson", "డాసన్" },
            { "timezone.excity.America/Denver", "డెన్వెర్" },
            { "timezone.excity.America/Guyana", "గయానా" },
            { "timezone.excity.America/Havana", "హవానా" },
            { "timezone.excity.America/Inuvik", "ఇనువిక్" },
            { "timezone.excity.America/Juneau", "జూనో" },
            { "timezone.excity.America/La_Paz", "లా పాజ్" },
            { "timezone.excity.America/Maceio", "మాసియో" },
            { "timezone.excity.America/Manaus", "మనాస్" },
            { "timezone.excity.America/Merida", "మెరిడా" },
            { "timezone.excity.America/Nassau", "నాస్సావ్" },
            { "timezone.excity.America/Panama", "పనామా" },
            { "timezone.excity.America/Recife", "రెసిఫీ" },
            { "timezone.excity.America/Regina", "రెజీనా" },
            { "timezone.excity.Asia/Famagusta", "ఫామగుస్టా" },
            { "timezone.excity.Asia/Hong_Kong", "హాంకాంగ్" },
            { "timezone.excity.Asia/Jerusalem", "జరూసలేం" },
            { "timezone.excity.Asia/Kamchatka", "కమ్‌చత్కా" },
            { "timezone.excity.Asia/Pontianak", "పొన్టియనాక్" },
            { "timezone.excity.Asia/Pyongyang", "ప్యోంగాంగ్" },
            { "timezone.excity.Asia/Qyzylorda", "క్విజిలోర్డా" },
            { "timezone.excity.Asia/Samarkand", "సమర్కాండ్" },
            { "timezone.excity.Asia/Singapore", "సింగపూర్" },
            { "timezone.excity.Asia/Vientiane", "వియన్టైన్" },
            { "timezone.excity.Europe/Andorra", "అండోరా" },
            { "timezone.excity.Europe/Saratov", "సరాటవ్" },
            { "timezone.excity.Europe/Tallinn", "తాల్లిన్" },
            { "timezone.excity.Europe/Vatican", "వాటికన్" },
            { "timezone.excity.Europe/Vilnius", "విల్నియస్" },
            { "timezone.excity.Indian/Mayotte", "మయోట్" },
            { "timezone.excity.Indian/Reunion", "రీయూనియన్" },
            { "timezone.excity.Pacific/Easter", "ఈస్టర్" },
            { "timezone.excity.Pacific/Kosrae", "కోస్రే" },
            { "timezone.excity.Pacific/Majuro", "మజురో" },
            { "timezone.excity.Pacific/Midway", "మిడ్వే" },
            { "timezone.excity.Pacific/Noumea", "నౌమియా" },
            { "timezone.excity.Pacific/Ponape", "పోన్‌పై" },
            { "timezone.excity.Pacific/Saipan", "సాయ్పాన్" },
            { "timezone.excity.Pacific/Tahiti", "తహితి" },
            { "timezone.excity.Pacific/Tarawa", "టరావా" },
            { "timezone.excity.Pacific/Wallis", "వాల్లిస్ & ఫ్యూటునా" },
            { "timezone.excity.Africa/Blantyre", "బ్లాన్టైర్" },
            { "timezone.excity.Africa/Djibouti", "జిబూటి" },
            { "timezone.excity.Africa/El_Aaiun", "ఎల్ ఎయున్" },
            { "timezone.excity.Africa/Freetown", "ఫ్రీటౌన్" },
            { "timezone.excity.Africa/Gaborone", "గబోరోన్" },
            { "timezone.excity.Africa/Khartoum", "ఖార్టోమ్" },
            { "timezone.excity.Africa/Kinshasa", "కిన్షాసా" },
            { "timezone.excity.Africa/Monrovia", "మోన్రోవియా" },
            { "timezone.excity.Africa/Ndjamena", "డ్జామెనా" },
            { "timezone.excity.Africa/Sao_Tome", "సావో టోమ్" },
            { "timezone.excity.Africa/Windhoek", "విండ్హోక్" },
            { "timezone.excity.America/Antigua", "ఆంటిగ్వా" },
            { "timezone.excity.America/Caracas", "కారాకస్" },
            { "timezone.excity.America/Cayenne", "కయేన్" },
            { "timezone.excity.America/Chicago", "చికాగో" },
            { "timezone.excity.America/Cordoba", "కోర్డోబా" },
            { "timezone.excity.America/Creston", "క్రెస్టన్" },
            { "timezone.excity.America/Curacao", "కురాకవో" },
            { "timezone.excity.America/Detroit", "డిట్రోయిట్" },
            { "timezone.excity.America/Godthab", "నూక్" },
            { "timezone.excity.America/Grenada", "గ్రెనడా" },
            { "timezone.excity.America/Halifax", "హాలిఫాక్స్" },
            { "timezone.excity.America/Iqaluit", "ఇక్వాలిట్" },
            { "timezone.excity.America/Jamaica", "జమైకా" },
            { "timezone.excity.America/Managua", "మనాగువా" },
            { "timezone.excity.America/Marigot", "మారిగోట్" },
            { "timezone.excity.America/Mendoza", "మెండోజా" },
            { "timezone.excity.America/Moncton", "మోన్‌క్టోన్" },
            { "timezone.excity.America/Noronha", "నరోన్హా" },
            { "timezone.excity.America/Ojinaga", "ఒజినగ" },
            { "timezone.excity.America/Phoenix", "ఫినిక్స్" },
            { "timezone.excity.America/Tijuana", "టిజువానా" },
            { "timezone.excity.America/Toronto", "టొరంటో" },
            { "timezone.excity.America/Tortola", "టోర్టోలా" },
            { "timezone.excity.America/Yakutat", "యకుటాట్" },
            { "timezone.excity.Asia/Phnom_Penh", "నోమ్‌పెన్హ్" },
            { "timezone.excity.Atlantic/Azores", "అజోర్స్" },
            { "timezone.excity.Atlantic/Canary", "కెనరీ" },
            { "timezone.excity.Atlantic/Faeroe", "ఫారో" },
            { "timezone.excity.Australia/Eucla", "యుక్లా" },
            { "timezone.excity.Australia/Perth", "పెర్త్" },
            { "timezone.excity.Europe/Belgrade", "బెల్‌గ్రేడ్" },
            { "timezone.excity.Europe/Brussels", "బ్రస్సెల్స్" },
            { "timezone.excity.Europe/Budapest", "బుడాపెస్ట్" },
            { "timezone.excity.Europe/Busingen", "బసింజన్" },
            { "timezone.excity.Europe/Chisinau", "చిసినావ్" },
            { "timezone.excity.Europe/Guernsey", "గ్వెర్న్సే" },
            { "timezone.excity.Europe/Helsinki", "హెల్సింకి" },
            { "timezone.excity.Europe/Istanbul", "ఇస్తాంబుల్" },
            { "timezone.excity.Europe/Sarajevo", "సరాజోవో" },
            { "timezone.excity.Indian/Maldives", "మాల్దీవులు" },
            { "timezone.excity.Pacific/Chatham", "చాథమ్ దీవులు" },
            { "timezone.excity.Pacific/Fakaofo", "ఫాకోఫో" },
            { "timezone.excity.Pacific/Gambier", "గాంబియేర్" },
            { "timezone.excity.Pacific/Norfolk", "నార్ఫక్ దీవి" },
            { "timezone.excity.Africa/Bujumbura", "బుజమ్బురా" },
            { "timezone.excity.Africa/Mogadishu", "మోగాదిషు" },
            { "timezone.excity.America/Anguilla", "ఆంగ్విల్లా" },
            { "timezone.excity.America/Asuncion", "అసున్సియోన్" },
            { "timezone.excity.America/Barbados", "బార్బడోస్" },
            { "timezone.excity.America/Dominica", "డొమినికా" },
            { "timezone.excity.America/Edmonton", "ఎడ్మోంటన్" },
            { "timezone.excity.America/Eirunepe", "ఇరునెప్" },
            { "timezone.excity.America/Mazatlan", "మాసట్‌లాన్" },
            { "timezone.excity.America/Miquelon", "మికెలాన్" },
            { "timezone.excity.America/New_York", "న్యూయార్క్" },
            { "timezone.excity.America/Resolute", "రిజల్యూట్" },
            { "timezone.excity.America/Santarem", "సాంటరెమ్" },
            { "timezone.excity.America/Santiago", "శాంటియాగో" },
            { "timezone.excity.America/St_Johns", "సెయింట్ జాన్స్" },
            { "timezone.excity.America/St_Kitts", "సెయింట్ కిట్స్" },
            { "timezone.excity.America/St_Lucia", "సెయింట్ లూసియా" },
            { "timezone.excity.America/Winnipeg", "విన్నిపెగ్" },
            { "timezone.excity.Antarctica/Casey", "కేసీ" },
            { "timezone.excity.Antarctica/Davis", "డెవిస్" },
            { "timezone.excity.Antarctica/Syowa", "స్యోవా" },
            { "timezone.excity.Antarctica/Troll", "ట్రోల్" },
            { "timezone.excity.Asia/Krasnoyarsk", "క్రసనోయార్స్క్" },
            { "timezone.excity.Asia/Novosibirsk", "నవోసిబిర్స్క్" },
            { "timezone.excity.Asia/Ulaanbaatar", "ఉలాన్బాటర్" },
            { "timezone.excity.Asia/Vladivostok", "వ్లాడివోస్టోక్" },
            { "timezone.excity.Atlantic/Bermuda", "బెర్ముడా" },
            { "timezone.excity.Atlantic/Madeira", "మదైరా" },
            { "timezone.excity.Atlantic/Stanley", "స్టాన్లీ" },
            { "timezone.excity.Australia/Darwin", "డార్విన్" },
            { "timezone.excity.Australia/Hobart", "హోబర్ట్" },
            { "timezone.excity.Australia/Sydney", "సిడ్నీ" },
            { "timezone.excity.Europe/Amsterdam", "ఆమ్‌స్టర్‌డామ్" },
            { "timezone.excity.Europe/Astrakhan", "అస్ట్రఖాన్" },
            { "timezone.excity.Europe/Bucharest", "బుకారెస్ట్" },
            { "timezone.excity.Europe/Gibraltar", "జిబ్రాల్టర్" },
            { "timezone.excity.Europe/Ljubljana", "ల్యూబ్ల్యానా" },
            { "timezone.excity.Europe/Mariehamn", "మారీయుహమ్" },
            { "timezone.excity.Europe/Podgorica", "పోడ్గోరికా" },
            { "timezone.excity.Europe/Stockholm", "స్టాక్హోమ్" },
            { "timezone.excity.Europe/Ulyanovsk", "ఉల్యనోవ్స్క్" },
            { "timezone.excity.Europe/Volgograd", "వోల్గోగ్రాడ్" },
            { "timezone.excity.Indian/Christmas", "క్రిస్మస్ దీవి" },
            { "timezone.excity.Indian/Kerguelen", "కెర్గ్యూలెన్" },
            { "timezone.excity.Indian/Mauritius", "మారిషస్" },
            { "timezone.excity.Pacific/Auckland", "ఆక్లాండ్" },
            { "timezone.excity.Pacific/Funafuti", "ఫునాఫుటి" },
            { "timezone.excity.Pacific/Honolulu", "హోనోలులు" },
            { "timezone.excity.Pacific/Pitcairn", "పిట్‌కైర్న్" },
            { "timezone.excity.Africa/Casablanca", "కాసాబ్లాంకా" },
            { "timezone.excity.Africa/Libreville", "లెబర్విల్లే" },
            { "timezone.excity.Africa/Lubumbashi", "లుబంబాషి" },
            { "timezone.excity.Africa/Nouakchott", "న్వాక్షోట్" },
            { "timezone.excity.Africa/Porto-Novo", "పోర్టో-నోవో" },
            { "timezone.excity.America/Anchorage", "యాంకరేజ్" },
            { "timezone.excity.America/Araguaina", "అరాగ్వేయీనా" },
            { "timezone.excity.America/Boa_Vista", "బోవా విస్టా" },
            { "timezone.excity.America/Catamarca", "కటమార్కా" },
            { "timezone.excity.America/Chihuahua", "చువావా" },
            { "timezone.excity.America/Coyhaique", "కొయాయ్కె" },
            { "timezone.excity.America/Fortaleza", "ఫోర్టలేజా" },
            { "timezone.excity.America/Glace_Bay", "గ్లేస్ బే" },
            { "timezone.excity.America/Goose_Bay", "గూస్ బే" },
            { "timezone.excity.America/Guatemala", "గ్వాటిమాలా" },
            { "timezone.excity.America/Guayaquil", "గయాక్విల్" },
            { "timezone.excity.America/Matamoros", "మాటమొరోస్" },
            { "timezone.excity.America/Menominee", "మెనోమినీ" },
            { "timezone.excity.America/Monterrey", "మోంటెర్రే" },
            { "timezone.excity.America/Sao_Paulo", "సావో పాలో" },
            { "timezone.excity.America/St_Thomas", "సెయింట్ థామస్" },
            { "timezone.excity.America/Vancouver", "వాన్కూవర్" },
            { "timezone.excity.Antarctica/Mawson", "మాసన్" },
            { "timezone.excity.Antarctica/Palmer", "పాల్మర్" },
            { "timezone.excity.Antarctica/Vostok", "వోస్టోక్" },
            { "timezone.excity.Asia/Kuala_Lumpur", "కౌలాలంపూర్" },
            { "timezone.excity.Asia/Novokuznetsk", "నొవొకుజ్‌నెట్‌స్క్" },
            { "timezone.excity.Europe/Bratislava", "బ్రాటిస్లావా" },
            { "timezone.excity.Europe/Copenhagen", "కోపెన్హాగన్" },
            { "timezone.excity.Europe/Luxembourg", "లక్సెంబర్గ్" },
            { "timezone.excity.Europe/San_Marino", "శాన్ మారినో" },
            { "timezone.excity.Europe/Simferopol", "సిమ్‌ఫెరోపోల్" },
            { "timezone.excity.Pacific/Enderbury", "క్యాంటన్ దీవి" },
            { "timezone.excity.Pacific/Galapagos", "గాలాపాగోస్" },
            { "timezone.excity.Pacific/Kwajalein", "క్వాజాలైన్" },
            { "timezone.excity.Pacific/Marquesas", "మార్క్వేసాస్" },
            { "timezone.excity.Pacific/Pago_Pago", "పాగో పాగో" },
            { "timezone.excity.Pacific/Rarotonga", "రరోటోంగా" },
            { "timezone.excity.Pacific/Tongatapu", "టోంగాటాపు" },
            { "timezone.excity.Africa/Addis_Ababa", "యాడిస్ అబాబా" },
            { "timezone.excity.Africa/Brazzaville", "బ్రాజావిల్లే" },
            { "timezone.excity.Africa/Ouagadougou", "ఔగాడౌగోవ్" },
            { "timezone.excity.America/Costa_Rica", "కోస్టా రికా" },
            { "timezone.excity.America/Grand_Turk", "గ్రాండ్ టర్క్" },
            { "timezone.excity.America/Guadeloupe", "గ్వాడెలోప్" },
            { "timezone.excity.America/Hermosillo", "హెర్మోసిల్లో" },
            { "timezone.excity.America/Kralendijk", "క్రలెండ్జిక్" },
            { "timezone.excity.America/Louisville", "లూయివిల్" },
            { "timezone.excity.America/Martinique", "మార్టినీక్" },
            { "timezone.excity.America/Metlakatla", "మెట్లకట్ల" },
            { "timezone.excity.America/Montevideo", "మోంటెవీడియో" },
            { "timezone.excity.America/Montserrat", "మాంట్సెరాట్" },
            { "timezone.excity.America/Paramaribo", "పరామారిబో" },
            { "timezone.excity.America/Rio_Branco", "రియో బ్రాంకో" },
            { "timezone.excity.America/St_Vincent", "సెయింట్ విన్సెంట్" },
            { "timezone.excity.America/Whitehorse", "వైట్‌హార్స్" },
            { "timezone.excity.Antarctica/McMurdo", "మెక్‌ముర్డో" },
            { "timezone.excity.Antarctica/Rothera", "రొతేరా" },
            { "timezone.excity.Asia/Srednekolymsk", "స్రెడ్నెకొలిమ్స్క్" },
            { "timezone.excity.Asia/Yekaterinburg", "యెకటెరింబర్గ్" },
            { "timezone.excity.Atlantic/Reykjavik", "రెక్జావిక్" },
            { "timezone.excity.Atlantic/St_Helena", "సెయింట్ హెలెనా" },
            { "timezone.excity.Australia/Adelaide", "అడెలైడ్" },
            { "timezone.excity.Australia/Brisbane", "బ్రిస్‌బెయిన్" },
            { "timezone.excity.Australia/Lindeman", "లిండెమాన్" },
            { "timezone.excity.Europe/Isle_of_Man", "ఐల్ ఆఫ్ మేన్" },
            { "timezone.excity.Europe/Kaliningrad", "కలినిన్‌గ్రద్" },
            { "timezone.excity.Pacific/Kiritimati", "కిరీటిమాటి" },
            { "timezone.excity.Africa/Johannesburg", "జొహెన్స్‌బర్గ్" },
            { "timezone.excity.America/El_Salvador", "ఎల్ సాల్వడోర్" },
            { "timezone.excity.America/Fort_Nelson", "ఫోర్ట్ నెల్సన్" },
            { "timezone.excity.America/Los_Angeles", "లాస్ ఏంజల్స్" },
            { "timezone.excity.America/Mexico_City", "మెక్సికో నగరం" },
            { "timezone.excity.America/Porto_Velho", "పోర్టో వెల్హో" },
            { "timezone.excity.America/Puerto_Rico", "ప్యూర్టో రికో" },
            { "timezone.excity.America/Tegucigalpa", "తెగుసిగల్పా" },
            { "timezone.excity.Arctic/Longyearbyen", "లాంగ్‌యియర్‌బైయన్" },
            { "timezone.excity.Atlantic/Cape_Verde", "కేప్ వెర్డె" },
            { "timezone.excity.Australia/Lord_Howe", "లార్డ్ హౌ దీవి" },
            { "timezone.excity.Australia/Melbourne", "మెల్బోర్న్" },
            { "timezone.excity.Indian/Antananarivo", "అంటానానారివో" },
            { "timezone.excity.Pacific/Guadalcanal", "గ్వాడల్కెనాల్" },
            { "timezone.excity.Africa/Dar_es_Salaam", "దార్ ఎస్ సలామ్" },
            { "timezone.excity.America/Blanc-Sablon", "బ్లాంక్-సబ్లోన్" },
            { "timezone.excity.America/Buenos_Aires", "బ్యూనోస్ ఎయిర్స్" },
            { "timezone.excity.America/Campo_Grande", "కాంపో గ్రాండ్" },
            { "timezone.excity.America/Danmarkshavn", "డెన్మార్క్‌షాన్" },
            { "timezone.excity.America/Dawson_Creek", "డాసన్ క్రీక్" },
            { "timezone.excity.America/Indiana/Knox", "నోక్స్, ఇండియాన" },
            { "timezone.excity.America/Indianapolis", "ఇండియానపోలిస్" },
            { "timezone.excity.America/Punta_Arenas", "పుంటా అరీనస్" },
            { "timezone.excity.America/Rankin_Inlet", "రన్‌కిన్ ఇన్‌లెట్" },
            { "timezone.excity.America/Scoresbysund", "ఇటోక్కోర్టూర్మిట్" },
            { "timezone.excity.Antarctica/Macquarie", "మకారీ దీవి" },
            { "timezone.excity.Pacific/Bougainville", "బొగెయిన్‌విల్లే" },
            { "timezone.excity.Pacific/Port_Moresby", "పోర్ట్ మోరెస్బే" },
            { "timezone.excity.America/Cambridge_Bay", "కేంబ్రిడ్జ్ బే" },
            { "timezone.excity.America/Ciudad_Juarez", "సియుదాద్ హ్వారెజ్" },
            { "timezone.excity.America/Coral_Harbour", "అటికోకన్" },
            { "timezone.excity.America/Indiana/Vevay", "వెవయ్, ఇండియాన" },
            { "timezone.excity.America/Lower_Princes", "లోయర్ ప్రిన్స్ క్వార్టర్" },
            { "timezone.excity.America/Port_of_Spain", "పోర్ట్ ఆఫ్ స్పెయిన్" },
            { "timezone.excity.America/Santo_Domingo", "శాంటో డోమింగో" },
            { "timezone.excity.America/St_Barthelemy", "సెయింట్ బర్తెలెమీ" },
            { "timezone.excity.America/Swift_Current", "స్విఫ్ట్ కరెంట్" },
            { "timezone.excity.Australia/Broken_Hill", "బ్రోకెన్ హిల్" },
            { "timezone.excity.America/Bahia_Banderas", "బహియా బండరాస్" },
            { "timezone.excity.America/Port-au-Prince", "పోర్ట్-అవ్-ప్రిన్స్" },
            { "timezone.excity.Atlantic/South_Georgia", "దక్షిణ జార్జియా" },
            { "timezone.excity.America/Argentina/Salta", "సాల్టా" },
            { "timezone.excity.America/Indiana/Marengo", "మరెంగో, ఇండియాన" },
            { "timezone.excity.America/Indiana/Winamac", "వినామాక్, ఇండియాన" },
            { "timezone.excity.America/Argentina/Tucuman", "టుకుమన్" },
            { "timezone.excity.America/Argentina/Ushuaia", "ఉష్యూయ" },
            { "timezone.excity.America/Indiana/Tell_City", "టెల్ నగరం, ఇండియాన" },
            { "timezone.excity.America/Indiana/Vincennes", "విన్‌సెన్నెస్, ఇండియాన" },
            { "timezone.excity.Antarctica/DumontDUrville", "డ్యూమాంట్ డి’ఉర్విల్లే" },
            { "timezone.excity.America/Argentina/La_Rioja", "లా రియోజ" },
            { "timezone.excity.America/Argentina/San_Juan", "శాన్ జ్యూన్" },
            { "timezone.excity.America/Argentina/San_Luis", "శాన్ లూయిస్" },
            { "timezone.excity.America/Indiana/Petersburg", "పీటర్స్‌బర్గ్, ఇండియాన" },
            { "timezone.excity.America/Kentucky/Monticello", "మోంటిసెల్లో, కెన్‌టుక్కీ" },
            { "timezone.excity.America/North_Dakota/Beulah", "బ్యులా, ఉత్తర డకోట" },
            { "timezone.excity.America/North_Dakota/Center", "సెంటర్, ఉత్తర డకోటా" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "రియో గల్లేగోస్" },
            { "timezone.excity.America/North_Dakota/New_Salem", "న్యూ సలేమ్, ఉత్తర డకోట" },
        };
        return data;
    }
}
