// copied from https://github.com/google/quic-trace/
// Only changed the package name.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v3.11.4
// source: quic-trace.proto

package pb

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type FrameType int32

const (
	FrameType_UNKNOWN_FRAME    FrameType = 0
	FrameType_STREAM           FrameType = 1
	FrameType_ACK              FrameType = 2
	FrameType_RESET_STREAM     FrameType = 3
	FrameType_CONNECTION_CLOSE FrameType = 4
	FrameType_MAX_DATA         FrameType = 5
	FrameType_MAX_STREAM_DATA  FrameType = 6
	FrameType_PING             FrameType = 7
	FrameType_BLOCKED          FrameType = 8
	FrameType_STREAM_BLOCKED   FrameType = 9
	FrameType_PADDING          FrameType = 10
	FrameType_CRYPTO           FrameType = 11
)

// Enum value maps for FrameType.
var (
	FrameType_name = map[int32]string{
		0:  "UNKNOWN_FRAME",
		1:  "STREAM",
		2:  "ACK",
		3:  "RESET_STREAM",
		4:  "CONNECTION_CLOSE",
		5:  "MAX_DATA",
		6:  "MAX_STREAM_DATA",
		7:  "PING",
		8:  "BLOCKED",
		9:  "STREAM_BLOCKED",
		10: "PADDING",
		11: "CRYPTO",
	}
	FrameType_value = map[string]int32{
		"UNKNOWN_FRAME":    0,
		"STREAM":           1,
		"ACK":              2,
		"RESET_STREAM":     3,
		"CONNECTION_CLOSE": 4,
		"MAX_DATA":         5,
		"MAX_STREAM_DATA":  6,
		"PING":             7,
		"BLOCKED":          8,
		"STREAM_BLOCKED":   9,
		"PADDING":          10,
		"CRYPTO":           11,
	}
)

func (x FrameType) Enum() *FrameType {
	p := new(FrameType)
	*p = x
	return p
}

func (x FrameType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FrameType) Descriptor() protoreflect.EnumDescriptor {
	return file_quic_trace_proto_enumTypes[0].Descriptor()
}

func (FrameType) Type() protoreflect.EnumType {
	return &file_quic_trace_proto_enumTypes[0]
}

func (x FrameType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *FrameType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = FrameType(num)
	return nil
}

// Deprecated: Use FrameType.Descriptor instead.
func (FrameType) EnumDescriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{0}
}

// Metadata for CONNECTION_CLOSE frames.
// Close_type will indicate whether the close is a Google QUIC close,
// IETF QUIC Transport CONNECTION CLOSE, or IETF QUIC Application
// Connection Close, frame.
type CloseType int32

const (
	CloseType_GOOGLE_QUIC_CONNECTION_CLOSE           CloseType = 0
	CloseType_IETF_QUIC_TRANSPORT_CONNECTION_CLOSE   CloseType = 1
	CloseType_IETF_QUIC_APPLICATION_CONNECTION_CLOSE CloseType = 2
)

// Enum value maps for CloseType.
var (
	CloseType_name = map[int32]string{
		0: "GOOGLE_QUIC_CONNECTION_CLOSE",
		1: "IETF_QUIC_TRANSPORT_CONNECTION_CLOSE",
		2: "IETF_QUIC_APPLICATION_CONNECTION_CLOSE",
	}
	CloseType_value = map[string]int32{
		"GOOGLE_QUIC_CONNECTION_CLOSE":           0,
		"IETF_QUIC_TRANSPORT_CONNECTION_CLOSE":   1,
		"IETF_QUIC_APPLICATION_CONNECTION_CLOSE": 2,
	}
)

func (x CloseType) Enum() *CloseType {
	p := new(CloseType)
	*p = x
	return p
}

func (x CloseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloseType) Descriptor() protoreflect.EnumDescriptor {
	return file_quic_trace_proto_enumTypes[1].Descriptor()
}

func (CloseType) Type() protoreflect.EnumType {
	return &file_quic_trace_proto_enumTypes[1]
}

func (x CloseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CloseType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CloseType(num)
	return nil
}

// Deprecated: Use CloseType.Descriptor instead.
func (CloseType) EnumDescriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{1}
}

type EncryptionLevel int32

const (
	EncryptionLevel_ENCRYPTION_UNKNOWN   EncryptionLevel = 0
	EncryptionLevel_ENCRYPTION_INITIAL   EncryptionLevel = 1
	EncryptionLevel_ENCRYPTION_0RTT      EncryptionLevel = 2
	EncryptionLevel_ENCRYPTION_1RTT      EncryptionLevel = 3
	EncryptionLevel_ENCRYPTION_HANDSHAKE EncryptionLevel = 4
)

// Enum value maps for EncryptionLevel.
var (
	EncryptionLevel_name = map[int32]string{
		0: "ENCRYPTION_UNKNOWN",
		1: "ENCRYPTION_INITIAL",
		2: "ENCRYPTION_0RTT",
		3: "ENCRYPTION_1RTT",
		4: "ENCRYPTION_HANDSHAKE",
	}
	EncryptionLevel_value = map[string]int32{
		"ENCRYPTION_UNKNOWN":   0,
		"ENCRYPTION_INITIAL":   1,
		"ENCRYPTION_0RTT":      2,
		"ENCRYPTION_1RTT":      3,
		"ENCRYPTION_HANDSHAKE": 4,
	}
)

func (x EncryptionLevel) Enum() *EncryptionLevel {
	p := new(EncryptionLevel)
	*p = x
	return p
}

func (x EncryptionLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_quic_trace_proto_enumTypes[2].Descriptor()
}

func (EncryptionLevel) Type() protoreflect.EnumType {
	return &file_quic_trace_proto_enumTypes[2]
}

func (x EncryptionLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *EncryptionLevel) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = EncryptionLevel(num)
	return nil
}

// Deprecated: Use EncryptionLevel.Descriptor instead.
func (EncryptionLevel) EnumDescriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{2}
}

type EventType int32

const (
	EventType_UNKNOWN_EVENT   EventType = 0
	EventType_PACKET_SENT     EventType = 1
	EventType_PACKET_RECEIVED EventType = 2
	EventType_PACKET_LOST     EventType = 3
	// An APPLICATION_LIMITED event occurs when the sender is capable of sending
	// more data and tries to send it, but discovers that it does not have any
	// outstanding data to send.  Such events are important to some congestion
	// control algorithms (for example, BBR) since they are trying to measure the
	// largest achievable throughput, but it is impossible to measure it when the
	// application does not send anything.
	EventType_APPLICATION_LIMITED EventType = 4
	// Record when external information about expected network conditions
	// (available bandwidth, RTT, congestion window, etc) is supplied to the
	// sender.
	EventType_EXTERNAL_PARAMETERS EventType = 5
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0: "UNKNOWN_EVENT",
		1: "PACKET_SENT",
		2: "PACKET_RECEIVED",
		3: "PACKET_LOST",
		4: "APPLICATION_LIMITED",
		5: "EXTERNAL_PARAMETERS",
	}
	EventType_value = map[string]int32{
		"UNKNOWN_EVENT":       0,
		"PACKET_SENT":         1,
		"PACKET_RECEIVED":     2,
		"PACKET_LOST":         3,
		"APPLICATION_LIMITED": 4,
		"EXTERNAL_PARAMETERS": 5,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_quic_trace_proto_enumTypes[3].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_quic_trace_proto_enumTypes[3]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *EventType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = EventType(num)
	return nil
}

// Deprecated: Use EventType.Descriptor instead.
func (EventType) EnumDescriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{3}
}

type TransmissionReason int32

const (
	// Indicates that there was not any particular special reason the packet was
	// sent.
	TransmissionReason_NORMAL_TRANSMISSION TransmissionReason = 0
	// Indicates that the packet sent is a tail loss probe, cf.
	// https://tools.ietf.org/html/draft-ietf-quic-recovery-14#section-4.3.2
	TransmissionReason_TAIL_LOSS_PROBE TransmissionReason = 1
	// Indicates that the packet is sent due to retransmission timeout, cf
	// https://tools.ietf.org/html/draft-ietf-quic-recovery-14#section-4.3.3
	TransmissionReason_RTO_TRANSMISSION TransmissionReason = 2
	// Indicates that the packet is sent in order to probe whether there is extra
	// bandwidth available in cases where the sender needs an estimate of
	// available bandwidth, but the application does not provide enough data for
	// such estimate to become naturally available.  This is usually only used in
	// real-time protocols.
	TransmissionReason_PROBING_TRANSMISSION TransmissionReason = 3
)

// Enum value maps for TransmissionReason.
var (
	TransmissionReason_name = map[int32]string{
		0: "NORMAL_TRANSMISSION",
		1: "TAIL_LOSS_PROBE",
		2: "RTO_TRANSMISSION",
		3: "PROBING_TRANSMISSION",
	}
	TransmissionReason_value = map[string]int32{
		"NORMAL_TRANSMISSION":  0,
		"TAIL_LOSS_PROBE":      1,
		"RTO_TRANSMISSION":     2,
		"PROBING_TRANSMISSION": 3,
	}
)

func (x TransmissionReason) Enum() *TransmissionReason {
	p := new(TransmissionReason)
	*p = x
	return p
}

func (x TransmissionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransmissionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_quic_trace_proto_enumTypes[4].Descriptor()
}

func (TransmissionReason) Type() protoreflect.EnumType {
	return &file_quic_trace_proto_enumTypes[4]
}

func (x TransmissionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *TransmissionReason) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = TransmissionReason(num)
	return nil
}

// Deprecated: Use TransmissionReason.Descriptor instead.
func (TransmissionReason) EnumDescriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{4}
}

// Metadata for STREAM frames.
type StreamFrameInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StreamId *uint64 `protobuf:"varint,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	Fin      *bool   `protobuf:"varint,2,opt,name=fin" json:"fin,omitempty"`
	Length   *uint64 `protobuf:"varint,3,opt,name=length" json:"length,omitempty"`
	Offset   *uint64 `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
}

func (x *StreamFrameInfo) Reset() {
	*x = StreamFrameInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamFrameInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamFrameInfo) ProtoMessage() {}

func (x *StreamFrameInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamFrameInfo.ProtoReflect.Descriptor instead.
func (*StreamFrameInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{0}
}

func (x *StreamFrameInfo) GetStreamId() uint64 {
	if x != nil && x.StreamId != nil {
		return *x.StreamId
	}
	return 0
}

func (x *StreamFrameInfo) GetFin() bool {
	if x != nil && x.Fin != nil {
		return *x.Fin
	}
	return false
}

func (x *StreamFrameInfo) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

func (x *StreamFrameInfo) GetOffset() uint64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

// Metadata for CRYPTO frames.
type CryptoFrameInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Length *uint64 `protobuf:"varint,1,opt,name=length" json:"length,omitempty"`
	Offset *uint64 `protobuf:"varint,2,opt,name=offset" json:"offset,omitempty"`
}

func (x *CryptoFrameInfo) Reset() {
	*x = CryptoFrameInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoFrameInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoFrameInfo) ProtoMessage() {}

func (x *CryptoFrameInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoFrameInfo.ProtoReflect.Descriptor instead.
func (*CryptoFrameInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{1}
}

func (x *CryptoFrameInfo) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

func (x *CryptoFrameInfo) GetOffset() uint64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

// The intervals are closed, i.e. the interval represented here is
// [first_packet, last_packet].
type AckBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FirstPacket *uint64 `protobuf:"varint,1,opt,name=first_packet,json=firstPacket" json:"first_packet,omitempty"`
	LastPacket  *uint64 `protobuf:"varint,2,opt,name=last_packet,json=lastPacket" json:"last_packet,omitempty"`
}

func (x *AckBlock) Reset() {
	*x = AckBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckBlock) ProtoMessage() {}

func (x *AckBlock) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckBlock.ProtoReflect.Descriptor instead.
func (*AckBlock) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{2}
}

func (x *AckBlock) GetFirstPacket() uint64 {
	if x != nil && x.FirstPacket != nil {
		return *x.FirstPacket
	}
	return 0
}

func (x *AckBlock) GetLastPacket() uint64 {
	if x != nil && x.LastPacket != nil {
		return *x.LastPacket
	}
	return 0
}

// Metadata for ACK frames.
type AckInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AckedPackets []*AckBlock `protobuf:"bytes,1,rep,name=acked_packets,json=ackedPackets" json:"acked_packets,omitempty"`
	AckDelayUs   *uint64     `protobuf:"varint,2,opt,name=ack_delay_us,json=ackDelayUs" json:"ack_delay_us,omitempty"`
}

func (x *AckInfo) Reset() {
	*x = AckInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckInfo) ProtoMessage() {}

func (x *AckInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckInfo.ProtoReflect.Descriptor instead.
func (*AckInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{3}
}

func (x *AckInfo) GetAckedPackets() []*AckBlock {
	if x != nil {
		return x.AckedPackets
	}
	return nil
}

func (x *AckInfo) GetAckDelayUs() uint64 {
	if x != nil && x.AckDelayUs != nil {
		return *x.AckDelayUs
	}
	return 0
}

// Metadata for RST_STREAM frames.
type ResetStreamInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StreamId             *uint64 `protobuf:"varint,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	ApplicationErrorCode *uint32 `protobuf:"varint,2,opt,name=application_error_code,json=applicationErrorCode" json:"application_error_code,omitempty"`
	FinalOffset          *uint64 `protobuf:"varint,3,opt,name=final_offset,json=finalOffset" json:"final_offset,omitempty"`
}

func (x *ResetStreamInfo) Reset() {
	*x = ResetStreamInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetStreamInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetStreamInfo) ProtoMessage() {}

func (x *ResetStreamInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetStreamInfo.ProtoReflect.Descriptor instead.
func (*ResetStreamInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{4}
}

func (x *ResetStreamInfo) GetStreamId() uint64 {
	if x != nil && x.StreamId != nil {
		return *x.StreamId
	}
	return 0
}

func (x *ResetStreamInfo) GetApplicationErrorCode() uint32 {
	if x != nil && x.ApplicationErrorCode != nil {
		return *x.ApplicationErrorCode
	}
	return 0
}

func (x *ResetStreamInfo) GetFinalOffset() uint64 {
	if x != nil && x.FinalOffset != nil {
		return *x.FinalOffset
	}
	return 0
}

// Metadata for CONNECTION_CLOSE/APPLICATION_CLOSE frames.
type CloseInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ErrorCode               *uint32    `protobuf:"varint,1,opt,name=error_code,json=errorCode" json:"error_code,omitempty"`
	ReasonPhrase            *string    `protobuf:"bytes,2,opt,name=reason_phrase,json=reasonPhrase" json:"reason_phrase,omitempty"`
	CloseType               *CloseType `protobuf:"varint,3,opt,name=close_type,json=closeType,enum=pb.CloseType" json:"close_type,omitempty"`
	TransportCloseFrameType *uint64    `protobuf:"varint,4,opt,name=transport_close_frame_type,json=transportCloseFrameType" json:"transport_close_frame_type,omitempty"`
}

func (x *CloseInfo) Reset() {
	*x = CloseInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseInfo) ProtoMessage() {}

func (x *CloseInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseInfo.ProtoReflect.Descriptor instead.
func (*CloseInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{5}
}

func (x *CloseInfo) GetErrorCode() uint32 {
	if x != nil && x.ErrorCode != nil {
		return *x.ErrorCode
	}
	return 0
}

func (x *CloseInfo) GetReasonPhrase() string {
	if x != nil && x.ReasonPhrase != nil {
		return *x.ReasonPhrase
	}
	return ""
}

func (x *CloseInfo) GetCloseType() CloseType {
	if x != nil && x.CloseType != nil {
		return *x.CloseType
	}
	return CloseType_GOOGLE_QUIC_CONNECTION_CLOSE
}

func (x *CloseInfo) GetTransportCloseFrameType() uint64 {
	if x != nil && x.TransportCloseFrameType != nil {
		return *x.TransportCloseFrameType
	}
	return 0
}

// Metadata for MAX_DATA/MAX_STREAM_DATA frames.
type FlowControlInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxData  *uint64 `protobuf:"varint,1,opt,name=max_data,json=maxData" json:"max_data,omitempty"`
	StreamId *uint64 `protobuf:"varint,2,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
}

func (x *FlowControlInfo) Reset() {
	*x = FlowControlInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlowControlInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowControlInfo) ProtoMessage() {}

func (x *FlowControlInfo) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowControlInfo.ProtoReflect.Descriptor instead.
func (*FlowControlInfo) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{6}
}

func (x *FlowControlInfo) GetMaxData() uint64 {
	if x != nil && x.MaxData != nil {
		return *x.MaxData
	}
	return 0
}

func (x *FlowControlInfo) GetStreamId() uint64 {
	if x != nil && x.StreamId != nil {
		return *x.StreamId
	}
	return 0
}

// A message representing a frame, either sent or received.
type Frame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FrameType       *FrameType       `protobuf:"varint,1,opt,name=frame_type,json=frameType,enum=pb.FrameType" json:"frame_type,omitempty"`
	StreamFrameInfo *StreamFrameInfo `protobuf:"bytes,2,opt,name=stream_frame_info,json=streamFrameInfo" json:"stream_frame_info,omitempty"`
	AckInfo         *AckInfo         `protobuf:"bytes,3,opt,name=ack_info,json=ackInfo" json:"ack_info,omitempty"`
	ResetStreamInfo *ResetStreamInfo `protobuf:"bytes,4,opt,name=reset_stream_info,json=resetStreamInfo" json:"reset_stream_info,omitempty"`
	CloseInfo       *CloseInfo       `protobuf:"bytes,5,opt,name=close_info,json=closeInfo" json:"close_info,omitempty"`
	FlowControlInfo *FlowControlInfo `protobuf:"bytes,6,opt,name=flow_control_info,json=flowControlInfo" json:"flow_control_info,omitempty"`
	CryptoFrameInfo *CryptoFrameInfo `protobuf:"bytes,7,opt,name=crypto_frame_info,json=cryptoFrameInfo" json:"crypto_frame_info,omitempty"`
}

func (x *Frame) Reset() {
	*x = Frame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Frame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Frame) ProtoMessage() {}

func (x *Frame) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Frame.ProtoReflect.Descriptor instead.
func (*Frame) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{7}
}

func (x *Frame) GetFrameType() FrameType {
	if x != nil && x.FrameType != nil {
		return *x.FrameType
	}
	return FrameType_UNKNOWN_FRAME
}

func (x *Frame) GetStreamFrameInfo() *StreamFrameInfo {
	if x != nil {
		return x.StreamFrameInfo
	}
	return nil
}

func (x *Frame) GetAckInfo() *AckInfo {
	if x != nil {
		return x.AckInfo
	}
	return nil
}

func (x *Frame) GetResetStreamInfo() *ResetStreamInfo {
	if x != nil {
		return x.ResetStreamInfo
	}
	return nil
}

func (x *Frame) GetCloseInfo() *CloseInfo {
	if x != nil {
		return x.CloseInfo
	}
	return nil
}

func (x *Frame) GetFlowControlInfo() *FlowControlInfo {
	if x != nil {
		return x.FlowControlInfo
	}
	return nil
}

func (x *Frame) GetCryptoFrameInfo() *CryptoFrameInfo {
	if x != nil {
		return x.CryptoFrameInfo
	}
	return nil
}

// Metadata that represents transport stack's understanding of the current state
// of the transport channel.
type TransportState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinRttUs *uint64 `protobuf:"varint,1,opt,name=min_rtt_us,json=minRttUs" json:"min_rtt_us,omitempty"`
	// Smoothed RTT, usually computed using EWMA.
	SmoothedRttUs *uint64 `protobuf:"varint,2,opt,name=smoothed_rtt_us,json=smoothedRttUs" json:"smoothed_rtt_us,omitempty"`
	// The latest RTT measureent available.
	LastRttUs     *uint64 `protobuf:"varint,3,opt,name=last_rtt_us,json=lastRttUs" json:"last_rtt_us,omitempty"`
	InFlightBytes *uint64 `protobuf:"varint,4,opt,name=in_flight_bytes,json=inFlightBytes" json:"in_flight_bytes,omitempty"`
	CwndBytes     *uint64 `protobuf:"varint,5,opt,name=cwnd_bytes,json=cwndBytes" json:"cwnd_bytes,omitempty"`
	// Pacing rate, in bits per second.
	PacingRateBps *uint64 `protobuf:"varint,6,opt,name=pacing_rate_bps,json=pacingRateBps" json:"pacing_rate_bps,omitempty"`
	// Any arbitrary information about congestion control state that is not
	// representable via parameters above.
	CongestionControlState *string `protobuf:"bytes,7,opt,name=congestion_control_state,json=congestionControlState" json:"congestion_control_state,omitempty"`
}

func (x *TransportState) Reset() {
	*x = TransportState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransportState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransportState) ProtoMessage() {}

func (x *TransportState) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransportState.ProtoReflect.Descriptor instead.
func (*TransportState) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{8}
}

func (x *TransportState) GetMinRttUs() uint64 {
	if x != nil && x.MinRttUs != nil {
		return *x.MinRttUs
	}
	return 0
}

func (x *TransportState) GetSmoothedRttUs() uint64 {
	if x != nil && x.SmoothedRttUs != nil {
		return *x.SmoothedRttUs
	}
	return 0
}

func (x *TransportState) GetLastRttUs() uint64 {
	if x != nil && x.LastRttUs != nil {
		return *x.LastRttUs
	}
	return 0
}

func (x *TransportState) GetInFlightBytes() uint64 {
	if x != nil && x.InFlightBytes != nil {
		return *x.InFlightBytes
	}
	return 0
}

func (x *TransportState) GetCwndBytes() uint64 {
	if x != nil && x.CwndBytes != nil {
		return *x.CwndBytes
	}
	return 0
}

func (x *TransportState) GetPacingRateBps() uint64 {
	if x != nil && x.PacingRateBps != nil {
		return *x.PacingRateBps
	}
	return 0
}

func (x *TransportState) GetCongestionControlState() string {
	if x != nil && x.CongestionControlState != nil {
		return *x.CongestionControlState
	}
	return ""
}

// Documents external network parameters supplied to the sender.  Typically not
// all of those would be supplied (e.g. if bandwidth and RTT are supplied, you
// can infer the suggested CWND), but there are no restrictions on which fields
// may or may not be set.
type ExternalNetworkParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BandwidthBps *uint64 `protobuf:"varint,1,opt,name=bandwidth_bps,json=bandwidthBps" json:"bandwidth_bps,omitempty"` // in bits per second
	RttUs        *uint64 `protobuf:"varint,2,opt,name=rtt_us,json=rttUs" json:"rtt_us,omitempty"`
	CwndBytes    *uint64 `protobuf:"varint,3,opt,name=cwnd_bytes,json=cwndBytes" json:"cwnd_bytes,omitempty"`
}

func (x *ExternalNetworkParameters) Reset() {
	*x = ExternalNetworkParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalNetworkParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalNetworkParameters) ProtoMessage() {}

func (x *ExternalNetworkParameters) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalNetworkParameters.ProtoReflect.Descriptor instead.
func (*ExternalNetworkParameters) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{9}
}

func (x *ExternalNetworkParameters) GetBandwidthBps() uint64 {
	if x != nil && x.BandwidthBps != nil {
		return *x.BandwidthBps
	}
	return 0
}

func (x *ExternalNetworkParameters) GetRttUs() uint64 {
	if x != nil && x.RttUs != nil {
		return *x.RttUs
	}
	return 0
}

func (x *ExternalNetworkParameters) GetCwndBytes() uint64 {
	if x != nil && x.CwndBytes != nil {
		return *x.CwndBytes
	}
	return 0
}

// An event that has occurred over duration of the connection.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimeUs          *uint64          `protobuf:"varint,1,opt,name=time_us,json=timeUs" json:"time_us,omitempty"`
	EventType       *EventType       `protobuf:"varint,2,opt,name=event_type,json=eventType,enum=pb.EventType" json:"event_type,omitempty"`
	PacketNumber    *uint64          `protobuf:"varint,3,opt,name=packet_number,json=packetNumber" json:"packet_number,omitempty"`
	Frames          []*Frame         `protobuf:"bytes,4,rep,name=frames" json:"frames,omitempty"`
	PacketSize      *uint64          `protobuf:"varint,5,opt,name=packet_size,json=packetSize" json:"packet_size,omitempty"`
	EncryptionLevel *EncryptionLevel `protobuf:"varint,6,opt,name=encryption_level,json=encryptionLevel,enum=pb.EncryptionLevel" json:"encryption_level,omitempty"`
	// State of the transport stack after the event has happened.
	TransportState *TransportState `protobuf:"bytes,7,opt,name=transport_state,json=transportState" json:"transport_state,omitempty"`
	// For event_type = EXTERNAL_PARAMETERS, record parameters specified.
	ExternalNetworkParameters *ExternalNetworkParameters `protobuf:"bytes,8,opt,name=external_network_parameters,json=externalNetworkParameters" json:"external_network_parameters,omitempty"`
	// For sent packets, indicate if there is a special reason for why the packet
	// in question was transmitted.
	TransmissionReason *TransmissionReason `protobuf:"varint,9,opt,name=transmission_reason,json=transmissionReason,enum=pb.TransmissionReason,def=0" json:"transmission_reason,omitempty"`
}

// Default values for Event fields.
const (
	Default_Event_TransmissionReason = TransmissionReason_NORMAL_TRANSMISSION
)

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{10}
}

func (x *Event) GetTimeUs() uint64 {
	if x != nil && x.TimeUs != nil {
		return *x.TimeUs
	}
	return 0
}

func (x *Event) GetEventType() EventType {
	if x != nil && x.EventType != nil {
		return *x.EventType
	}
	return EventType_UNKNOWN_EVENT
}

func (x *Event) GetPacketNumber() uint64 {
	if x != nil && x.PacketNumber != nil {
		return *x.PacketNumber
	}
	return 0
}

func (x *Event) GetFrames() []*Frame {
	if x != nil {
		return x.Frames
	}
	return nil
}

func (x *Event) GetPacketSize() uint64 {
	if x != nil && x.PacketSize != nil {
		return *x.PacketSize
	}
	return 0
}

func (x *Event) GetEncryptionLevel() EncryptionLevel {
	if x != nil && x.EncryptionLevel != nil {
		return *x.EncryptionLevel
	}
	return EncryptionLevel_ENCRYPTION_UNKNOWN
}

func (x *Event) GetTransportState() *TransportState {
	if x != nil {
		return x.TransportState
	}
	return nil
}

func (x *Event) GetExternalNetworkParameters() *ExternalNetworkParameters {
	if x != nil {
		return x.ExternalNetworkParameters
	}
	return nil
}

func (x *Event) GetTransmissionReason() TransmissionReason {
	if x != nil && x.TransmissionReason != nil {
		return *x.TransmissionReason
	}
	return Default_Event_TransmissionReason
}

type Trace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// QUIC version tag, as represented on wire.  Should be always 4 bytes long.
	ProtocolVersion []byte `protobuf:"bytes,1,opt,name=protocol_version,json=protocolVersion" json:"protocol_version,omitempty"`
	// Source and destination connection ID.  If multiple connection IDs are used,
	// record the first one used with short-form header.
	SourceConnectionId      []byte   `protobuf:"bytes,2,opt,name=source_connection_id,json=sourceConnectionId" json:"source_connection_id,omitempty"`
	DestinationConnectionId []byte   `protobuf:"bytes,3,opt,name=destination_connection_id,json=destinationConnectionId" json:"destination_connection_id,omitempty"`
	Events                  []*Event `protobuf:"bytes,4,rep,name=events" json:"events,omitempty"`
}

func (x *Trace) Reset() {
	*x = Trace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_quic_trace_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace) ProtoMessage() {}

func (x *Trace) ProtoReflect() protoreflect.Message {
	mi := &file_quic_trace_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace.ProtoReflect.Descriptor instead.
func (*Trace) Descriptor() ([]byte, []int) {
	return file_quic_trace_proto_rawDescGZIP(), []int{11}
}

func (x *Trace) GetProtocolVersion() []byte {
	if x != nil {
		return x.ProtocolVersion
	}
	return nil
}

func (x *Trace) GetSourceConnectionId() []byte {
	if x != nil {
		return x.SourceConnectionId
	}
	return nil
}

func (x *Trace) GetDestinationConnectionId() []byte {
	if x != nil {
		return x.DestinationConnectionId
	}
	return nil
}

func (x *Trace) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

var File_quic_trace_proto protoreflect.FileDescriptor

var file_quic_trace_proto_rawDesc = []byte{
	0x0a, 0x10, 0x71, 0x75, 0x69, 0x63, 0x2d, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x02, 0x70, 0x62, 0x22, 0x70, 0x0a, 0x0f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x03, 0x66, 0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x41, 0x0a, 0x0f, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x4e, 0x0a, 0x08, 0x41,
	0x63, 0x6b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x69, 0x72, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x66,
	0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0a, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x5e, 0x0a, 0x07, 0x41,
	0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x0d, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e,
	0x70, 0x62, 0x2e, 0x41, 0x63, 0x6b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0c, 0x61, 0x63, 0x6b,
	0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x0c, 0x61, 0x63, 0x6b,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0a, 0x61, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x0f,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x16,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xba, 0x01, 0x0a, 0x09, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0a, 0x63, 0x6c, 0x6f, 0x73, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x70, 0x62,
	0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x49, 0x0a, 0x0f, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x22, 0x8f, 0x03,
	0x0a, 0x05, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x70, 0x62,
	0x2e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x26, 0x0a, 0x08, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x70, 0x62, 0x2e, 0x41, 0x63,
	0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3f,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f,
	0x72, 0x65, 0x73, 0x65, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x2c, 0x0a, 0x0a, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x62, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x09, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3f, 0x0a,
	0x11, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x46, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3f,
	0x0a, 0x11, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x62, 0x2e, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22,
	0x9f, 0x02, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1c, 0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x74, 0x74, 0x5f, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x52, 0x74, 0x74, 0x55, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x74, 0x74,
	0x5f, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x73, 0x6d, 0x6f, 0x6f, 0x74,
	0x68, 0x65, 0x64, 0x52, 0x74, 0x74, 0x55, 0x73, 0x12, 0x1e, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x72, 0x74, 0x74, 0x5f, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x6c,
	0x61, 0x73, 0x74, 0x52, 0x74, 0x74, 0x55, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x69, 0x6e, 0x5f, 0x66,
	0x6c, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0d, 0x69, 0x6e, 0x46, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x77, 0x6e, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x77, 0x6e, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62,
	0x70, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67,
	0x52, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x63, 0x6f, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x22, 0x76, 0x0a, 0x19, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x62, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x42, 0x70, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x74, 0x74, 0x5f, 0x75, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x05, 0x72, 0x74, 0x74, 0x55, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x77,
	0x6e, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09,
	0x63, 0x77, 0x6e, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xf1, 0x03, 0x0a, 0x05, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x73, 0x12, 0x2c, 0x0a, 0x0a,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0d, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x21, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x09, 0x2e, 0x70, 0x62, 0x2e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x3e, 0x0a, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e,
	0x70, 0x62, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x52, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70,
	0x62, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x5d, 0x0a, 0x1b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x19, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x5c, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x70,
	0x62, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x3a, 0x13, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x5f, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0xc3, 0x01,
	0x0a, 0x05, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x21, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x09, 0x2e, 0x70, 0x62, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x2a, 0xc2, 0x01, 0x0a, 0x09, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x46, 0x52, 0x41,
	0x4d, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x53,
	0x45, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x10,
	0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x41, 0x58, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x05, 0x12,
	0x13, 0x0a, 0x0f, 0x4d, 0x41, 0x58, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0b,
	0x0a, 0x07, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x09, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x10, 0x0b, 0x2a, 0x83, 0x01, 0x0a, 0x09, 0x43, 0x6c, 0x6f,
	0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x51, 0x55, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x10, 0x00, 0x12, 0x28, 0x0a, 0x24, 0x49, 0x45, 0x54, 0x46,
	0x5f, 0x51, 0x55, 0x49, 0x43, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45,
	0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x49, 0x45, 0x54, 0x46, 0x5f, 0x51, 0x55, 0x49, 0x43, 0x5f,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x85,
	0x01, 0x0a, 0x0f, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x30, 0x52, 0x54, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x4e, 0x43, 0x52, 0x59,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x52, 0x54, 0x54, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14,
	0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x41, 0x4e, 0x44, 0x53,
	0x48, 0x41, 0x4b, 0x45, 0x10, 0x04, 0x2a, 0x87, 0x01, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x41, 0x43, 0x4b, 0x45,
	0x54, 0x5f, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x41, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4c, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x12, 0x17,
	0x0a, 0x13, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49,
	0x4d, 0x49, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x58, 0x54, 0x45, 0x52,
	0x4e, 0x41, 0x4c, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x05,
	0x2a, 0x72, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c,
	0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x54, 0x41, 0x49, 0x4c, 0x5f, 0x4c, 0x4f, 0x53, 0x53, 0x5f, 0x50, 0x52, 0x4f,
	0x42, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x54, 0x4f, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52,
	0x4f, 0x42, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x4d, 0x49, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x10, 0x03, 0x42, 0x06, 0x5a, 0x04, 0x2e, 0x3b, 0x70, 0x62,
}

var (
	file_quic_trace_proto_rawDescOnce sync.Once
	file_quic_trace_proto_rawDescData = file_quic_trace_proto_rawDesc
)

func file_quic_trace_proto_rawDescGZIP() []byte {
	file_quic_trace_proto_rawDescOnce.Do(func() {
		file_quic_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_quic_trace_proto_rawDescData)
	})
	return file_quic_trace_proto_rawDescData
}

var file_quic_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_quic_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_quic_trace_proto_goTypes = []interface{}{
	(FrameType)(0),                    // 0: pb.FrameType
	(CloseType)(0),                    // 1: pb.CloseType
	(EncryptionLevel)(0),              // 2: pb.EncryptionLevel
	(EventType)(0),                    // 3: pb.EventType
	(TransmissionReason)(0),           // 4: pb.TransmissionReason
	(*StreamFrameInfo)(nil),           // 5: pb.StreamFrameInfo
	(*CryptoFrameInfo)(nil),           // 6: pb.CryptoFrameInfo
	(*AckBlock)(nil),                  // 7: pb.AckBlock
	(*AckInfo)(nil),                   // 8: pb.AckInfo
	(*ResetStreamInfo)(nil),           // 9: pb.ResetStreamInfo
	(*CloseInfo)(nil),                 // 10: pb.CloseInfo
	(*FlowControlInfo)(nil),           // 11: pb.FlowControlInfo
	(*Frame)(nil),                     // 12: pb.Frame
	(*TransportState)(nil),            // 13: pb.TransportState
	(*ExternalNetworkParameters)(nil), // 14: pb.ExternalNetworkParameters
	(*Event)(nil),                     // 15: pb.Event
	(*Trace)(nil),                     // 16: pb.Trace
}
var file_quic_trace_proto_depIdxs = []int32{
	7,  // 0: pb.AckInfo.acked_packets:type_name -> pb.AckBlock
	1,  // 1: pb.CloseInfo.close_type:type_name -> pb.CloseType
	0,  // 2: pb.Frame.frame_type:type_name -> pb.FrameType
	5,  // 3: pb.Frame.stream_frame_info:type_name -> pb.StreamFrameInfo
	8,  // 4: pb.Frame.ack_info:type_name -> pb.AckInfo
	9,  // 5: pb.Frame.reset_stream_info:type_name -> pb.ResetStreamInfo
	10, // 6: pb.Frame.close_info:type_name -> pb.CloseInfo
	11, // 7: pb.Frame.flow_control_info:type_name -> pb.FlowControlInfo
	6,  // 8: pb.Frame.crypto_frame_info:type_name -> pb.CryptoFrameInfo
	3,  // 9: pb.Event.event_type:type_name -> pb.EventType
	12, // 10: pb.Event.frames:type_name -> pb.Frame
	2,  // 11: pb.Event.encryption_level:type_name -> pb.EncryptionLevel
	13, // 12: pb.Event.transport_state:type_name -> pb.TransportState
	14, // 13: pb.Event.external_network_parameters:type_name -> pb.ExternalNetworkParameters
	4,  // 14: pb.Event.transmission_reason:type_name -> pb.TransmissionReason
	15, // 15: pb.Trace.events:type_name -> pb.Event
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_quic_trace_proto_init() }
func file_quic_trace_proto_init() {
	if File_quic_trace_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_quic_trace_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamFrameInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoFrameInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetStreamInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlowControlInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Frame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransportState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalNetworkParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_quic_trace_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_quic_trace_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_quic_trace_proto_goTypes,
		DependencyIndexes: file_quic_trace_proto_depIdxs,
		EnumInfos:         file_quic_trace_proto_enumTypes,
		MessageInfos:      file_quic_trace_proto_msgTypes,
	}.Build()
	File_quic_trace_proto = out.File
	file_quic_trace_proto_rawDesc = nil
	file_quic_trace_proto_goTypes = nil
	file_quic_trace_proto_depIdxs = nil
}
